Attribute VB_Name = "modStatstring"
Option Explicit

Public Function GetClientName(ByRef ProductID$, Optional ByVal Short As Boolean) As String
    Select Case UCase$(ProductID)
        Case "CHAT", "TAHC": GetClientName = "Telnet Client"
        Case "STAR", "RATS": GetClientName = "StarCraft"
        Case "JSTR", "RTSJ": GetClientName = "StarCraft: Japanese"
        Case "SSHR", "RHSS": GetClientName = "StarCraft: Shareware"
        Case "SEXP", "PXES": GetClientName = "StarCraft: BroodWar"
        Case "W2BN", "NB2W": GetClientName = "WarCraft II: Battle.net Edition"
        Case "WAR3", "3RAW": GetClientName = "WarCraft III: Reign of Chaos"
        Case "W3XP", "PX3W": GetClientName = "WarCraft III: Frozen Throne"
        Case "D2DV", "VD2D": GetClientName = "Diablo II: Classic"
        Case "D2XP", "PX2D": GetClientName = "Diablo II: Lord of Destruction"
        Case "DRTL", "LTRD": GetClientName = "Diablo"
        Case "DSHR", "RHSD": GetClientName = "Diablo: Shareware"
        Case Else: GetClientName = "Unknown (" & ProductID & ")"
    End Select
End Function

Public Function GetClanName(ByVal statstring$) As String
    If LenB(statstring) = 0 Then Exit Function
    If Left$(statstring, 4) = "3RAW" Or Left$(statstring, 4) = "PX3W" Then
        Dim Splt() As String
        Splt() = Split(statstring, Space$(1))
        If UBound(Splt) = 3 Then
            GetClanName = Replace$(StrReverse$(Right$(Splt(3), 4)), vbNullChar, vbNullString)
        End If
    End If
End Function

Public Function GetClientStats(ByVal statstring$) As String
    If LenB(statstring) = 0 Then Exit Function
    Dim client As String * 4
    client = UCase$(Left$(statstring, 4))
    Select Case client
        Case "STAR", "RATS", "JSTR", "RTSJ", "SEXP", "PXES", "SSHR", "RHSS", "W2BN", "NB2W"
            GetClientStats = GetStatsSC(statstring$)
        Case "DRTL", "LTRD", "DSHR", "RHSD"
            GetClientStats = GetStatsD1(statstring$)
        Case "WAR3", "3RAW"
            GetClientStats = GetStatsRoC(statstring$)
        Case "W3XP", "PX3W"
            GetClientStats = GetStatsTFT(statstring$)
        Case "D2DV", "VD2D", "D2XP", "PX2D"
            GetClientStats = GetStatsD2(statstring$)
        Case Else
            GetClientStats = vbNullString
    End Select
End Function

Private Function GetStatsSC(ByRef statstring$) As String
    Dim w$()
    w$() = Split(statstring, Space$(1))
    GetStatsSC = w$(3) & " wins" & IIf(Val(w$(2)) > 0, ", #" & w$(3), vbNullString) & IIf(Val(w$(1)) > 0, ", " & w$(1) & " rating", vbNullString) & IIf(Val(w$(4)) = 1, ", spawned", vbNullString)
End Function

Private Function GetStatsRoC(ByRef statstring$) As String
    ''No tier
    If Len(statstring) = 4 Then
        GetStatsRoC = vbNullString
        Exit Function
    End If
    
    ''Get tier
    Dim tier As String
    tier = Left$(Split(statstring, Space$(1))(1), 2)
    
    ''Check if peon
    If Val(Left$(tier, 1)) = 1 Then GetStatsRoC = "Orc Peon": Exit Function
    
    ''Create tier arrays
    Dim buf As String
    Dim hTier(), _
        eTier(), _
        oTier(), _
        uTier(), _
        rTier()
    
    ''Build arrays
    hTier() = Array("Footman (25+ wins)", "Knight (250+ wins)", "Archmage (500+ wins)", "Medivh (1500+ wins)")
    oTier() = Array("Grunt (25+ wins)", "Tauren (250+ wins)", "Far Seer (500+ wins)", "Thrall (1500+ wins)")
    eTier() = Array("Archer (25+ wins)", "Druid of the Claw (250+ wins)", "Priestess of the Moon (500+ wins)", "Furion Stormrage (1500+ wins)")
    uTier() = Array("Ghoul (25+ wins)", "Abomination (250+ wins)", "Lich (500+ wins)", "Tichondrius (1500+ wins)")
    rTier() = Array("Green Dragon Whelp (25+ wins)", "Blue Dragon (250+ wins)", "Red Dragon (500+ wins)", "Deathwing (1500+ wins)")
    
    ''Build buffer
    Select Case Mid$(tier, 2, 1)
        Case "H": buf = "Human " & CStr(hTier(Val(Left$(tier, 1)) - 2))
        Case "N": buf = "Night Elf " & CStr(eTier(Val(Left$(tier, 1)) - 2))
        Case "O": buf = "Orc " & CStr(oTier(Val(Left$(tier, 1)) - 2))
        Case "R": buf = "Random " & CStr(rTier(Val(Left$(tier, 1)) - 2))
        Case "U": buf = "Undead " & CStr(uTier(Val(Left$(tier, 1)) - 2))
    End Select
    
    ''Return
    GetStatsRoC = buf
End Function

Private Function GetStatsTFT(ByRef statstring$) As String
    ''No tier
    If Len(statstring) = 4 Then
        GetStatsTFT = vbNullString
        Exit Function
    End If
    
    ''Get tier
    Dim tier As String
    tier = Left$(Split(statstring, Space$(1))(1), 2)
    
    ''Check if peon
    If Val(Left$(tier, 1)) = 1 Then GetStatsTFT = "Orc Peon": Exit Function
    
    ''Create tier arrays
    Dim buf As String
    Dim hTier(), _
        eTier(), _
        oTier(), _
        uTier(), _
        tTier(), _
        rTier()

    ''Build arrays
    hTier() = Array("Rifleman (25+ wins)", "Sorceress (150+ wins)", "Spellbreaker (350+ wins)", "Blood Mage (750+ wins)", "Jaina (1500+ wins)")
    oTier() = Array("Troll Headhunter (25+ wins)", "Shaman (150+ wins)", "Spirit Walker (350+ wins)", "Shadow Hunter (750+ wins)", "Rexxar (1500+ wins)")
    eTier() = Array("Huntress (25+ wins)", "Druid of the Talon (150+ wins)", "Dryad (350+ wins)", "Keeper of the Grove (750+ wins)", "Maiev (1500+ wins)")
    uTier() = Array("Crypt Fiend (25+ wins)", "Banshee (150+ wins)", "Destroyer (350+ wins)", "Crypt Lord (750+ wins)", "Sylvanas (1500+ wins)")
    rTier() = Array("Myrmidon (25+ wins)", "Siren (150+ wins)", "Dragon Turtle (350+ wins)", "Sea Witch (750+ wins)", "Illidan (1500+ wins)")
    tTier() = Array("Felguard (25+ wins)", "Infernal (150+ wins)", "Doomguard (350+ wins)", "Pit Lord (750+ wins)", "Archimonde (1500+ wins)")
    
    ''Build buffer
    Select Case Mid$(tier, 2, 1)
        Case "H": buf = "Human " & CStr(hTier(Val(Left$(tier, 1)) - 2))
        Case "N": buf = "Night Elf " & CStr(eTier(Val(Left$(tier, 1)) - 2))
        Case "O": buf = "Orc " & CStr(oTier(Val(Left$(tier, 1)) - 2))
        Case "R": buf = "Random " & CStr(rTier(Val(Left$(tier, 1)) - 2))
        Case "T": buf = "Tournament " & CStr(tTier(Val(Left$(tier, 1)) - 2))
        Case "U": buf = "Undead " & CStr(uTier(Val(Left$(tier, 1)) - 2))
    End Select
    
    ''Return
    GetStatsTFT = buf
End Function

Private Function GetStatsD1(ByRef statstring$) As String
    Dim w$(), Class$
    w$() = Split(statstring, Space$(1))
    
    If UBound(w$()) = 9 Then
        Dim c()
        c() = Array("Warrior", "Rogue", "Sorceror")
        
        If Val(w(2)) > 2 Or Val(w(2)) < 0 Then
            GetStatsD1 = "Invalid class: " & statstring
            Exit Function
        Else
            Class = CStr(c(Val(w(2))))
        End If
    Else
        GetStatsD1 = "Invalid stats: " & statstring
        Exit Function
    End If

    GetStatsD1 = "lvl " & w$(1) & " " & Class & ", " & _
        w$(3) & " dots, " & w$(4) & " strength, " & _
        w$(5) & " magic, " & w$(6) & " dexterity, " & _
        w$(7) & " vitality, & " & w$(8) & " gold"
End Function

Private Function GetStatsD2(ByRef statstring$) As String
    If Len(statstring) = 4 Then
        GetStatsD2 = vbNullString
        Exit Function
    End If
    
    Dim r()
    r() = Array("Unknown", "Amazon", "Sorceress", _
        "Necromancer", "Paladin", "Barbarian", "Druid", "Assassin")
    
    Dim race As Byte, level As Byte, charflag As Byte, actflag As Byte
    Dim hardcore As Boolean, ladder As Boolean, dead As Boolean
    Dim female As Boolean, expansion As Boolean
    Dim product$, server$, char$, raceStr$, Title$
    product$ = Left$(statstring, 4)
    statstring = Mid$(statstring, 5)
    server$ = Left$(statstring, InStr(statstring, ",") - 1)
    statstring = Mid$(statstring, Len(server) + 2)
    char$ = Left$(statstring, InStr(statstring, ",") - 1)
    statstring = Mid$(statstring, Len(char) + 2)
    
    If Len(statstring) <> 33 Then
        GetStatsD2 = vbNullString
        Exit Function
    End If
    
    race = CByte(Asc(Mid$(statstring, 14, 1)))
    level = CByte(Asc(Mid$(statstring, 26, 1)))
    charflag = CByte(Asc(Mid$(statstring, 27, 1)))
    actflag = CByte(Asc(Mid$(statstring, 28, 1)))
    hardcore = CBool(charflag And &H4 = &H4)
    ladder = CBool(Asc(Mid$(statstring, 31, 1)) < &HFF)
    
    If hardcore Then dead = CBool(charflag And &H8 = &H8)
    
    If race > 7 Or race < 1 Then race = 0
    If race = 1 Or race = 2 Or race = 7 Then female = True
    raceStr = r(race)
    
    If product = "PX2D" Then
        If charflag And &H20 Then
            expansion = True
            If hardcore Then
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Destroyer "
                    Case 2: Title = "Conqueror "
                    Case 3: Title = "Guardian "
                End Select
            Else
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Slayer "
                    Case 2: Title = "Champion "
                    Case 3: Title = IIf(female, "P", "M") & "atriarch "
                End Select
            End If
        End If
    Else
        If hardcore Then
            If Not female Then
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Sir "
                    Case 2: Title = "Lord "
                    Case 3: Title = "Baron "
                End Select
            Else
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Dame "
                    Case 2: Title = "Lady "
                    Case 3: Title = "Baroness "
                End Select
            End If
        Else
            If Not female Then
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Count "
                    Case 2: Title = "Duke "
                    Case 3: Title = "King "
                End Select
            Else
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Countess "
                    Case 2: Title = "Duchess "
                    Case 3: Title = "Queen "
                End Select
            End If
        End If
    End If
    
    GetStatsD2 = Title & char & ", " & IIf(dead, "dead ", vbNullString) & _
        IIf(hardcore, "hardcore ", vbNullString) & IIf(ladder, "ladder ", vbNullString) & _
        "lvl" & level & " " & IIf(expansion, "exp ", vbNullString) & _
        raceStr ' & " on realm " & server
End Function

Private Function LShift(ByVal pnValue As Long, ByVal pnShift As Long) As Double:
    LShift = CDbl(pnValue * (2 ^ pnShift))
End Function

Private Function RShift(ByVal pnValue As Long, ByVal pnShift As Long) As Double
    RShift = CDbl(pnValue \ (2 ^ pnShift))
End Function

