Attribute VB_Name = "modRtfColorSmileys"
Option Explicit

Private Const WM_PASTE = &H302

Public Sub ReplaceColours(RTB As RichTextBox, dblStart As Double)
    On Error GoTo hErr
    Dim Pos As Double, Colour As Long
    Do
        Pos = RTB.Find("", dblStart)
        If (Pos > 0) Then
            RTB.SelStart = Pos
            RTB.SelLength = 2
            If Len(RTB.SelText) = 2 Then
                Select Case Mid$(RTB.SelText, 2)
                    Case "P", "W": Colour = SCWhite
                    Case "Q": Colour = SCGray
                    Case "R": Colour = SCGreen
                    Case "S", "X", "Z": Colour = SCYellow
                    Case "T", "U", "V": Colour = SCCyan
                    Case "Y", "[": Colour = SCRed
                    Case Else: Colour = SCWhite
                End Select
            End If
            RTB.SelText = vbNullString
            RTB.SelStart = Pos
            RTB.SelLength = 200000000
            RTB.SelColor = Colour
        End If
    Loop Until (Pos < 1) Or (Err)
    Do
        Pos = RTB.Find("C", dblStart)
        If (Pos > 0) Then
            RTB.SelStart = Pos
            RTB.SelLength = 3
            If Len(RTB.SelText) = 3 Then
                Select Case Mid$(RTB.SelText, 3)
                    Case "0": Colour = D2White
                    Case "1": Colour = D2Red
                    Case "2": Colour = D2Green
                    Case "3": Colour = D2Blue
                    Case "4": Colour = D2Beige
                    Case "5": Colour = D2Gray
                    Case "6": Colour = D2Black
                    Case "7": Colour = D2Beige2
                    Case "8": Colour = D2Orange
                    Case "9": Colour = D2LtYellow
                    Case ":": Colour = D2MdGreen
                    Case ";": Colour = D2Purple
                    Case "<": Colour = D2DkGreen
                    Case Else: Colour = D2White
                End Select
            End If
            RTB.SelText = vbNullString
            RTB.SelStart = Pos
            RTB.SelLength = 200000000
            RTB.SelColor = Colour
        End If
    Loop Until (Pos < 1) Or (Err)
    Exit Sub
hErr:
    ErrorHandler "RichTextBox", "ReplaceColours"
End Sub

Public Sub ReplaceSmilies(RTB As RichTextBox, StartPos As Double)
    RTB.Locked = False
    ReplaceSmiley RTB, StartPos, ":m:", 1
    ReplaceSmiley RTB, StartPos, ":D", 2
    ReplaceSmiley RTB, StartPos, ":O", 3
    ReplaceSmiley RTB, StartPos, ":P", 4
    ReplaceSmiley RTB, StartPos, ":)", 5
    ReplaceSmiley RTB, StartPos, ":(", 6
    ReplaceSmiley RTB, StartPos, ":'(", 7
    ReplaceSmiley RTB, StartPos, ";)", 8
    RTB.Locked = True
End Sub

Private Sub ReplaceSmiley(RTB As RichTextBox, dblStart As Double, strCompare As String, intPicture As Integer)
    On Error GoTo hErr
    Dim Pos As Double
    Do
        Pos = RTB.Find(strCompare, dblStart)
        If (Pos > 0) Then
            RTB.SelStart = Pos
            RTB.SelLength = Len(strCompare)
            RTB.SelText = vbNullString
            InsertPicture RTB, frmBot.imlSmiley.ListImages(intPicture).Picture
        End If
    Loop Until (Pos < 1) Or (Err)
    Exit Sub
hErr:
    ErrorHandler "RichTextBox", "ReplaceSmiley"
End Sub

Public Sub InsertPicture(RTB As RichTextBox, pic As StdPicture)
    Clipboard.Clear
    Clipboard.SetData pic
    SendMessage RTB.hWnd, WM_PASTE, 0&, 0&
End Sub
