Attribute VB_Name = "modReadWrite"
Option Explicit

Private Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long
Private Declare Function GetPrivateProfileSection Lib "kernel32" Alias "GetPrivateProfileSectionA" (ByVal lpAppName As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileSection Lib "kernel32" Alias "WritePrivateProfileSectionA" (ByVal lpAppName As String, ByVal lpString As String, ByVal lpFileName As String) As Long

Public fso As New FileSystemObject

Public Function WriteLog(Index As Integer, SelStart As Double)
    On Error GoTo hErr:
    Dim path As String
    path = AppData & "Logging"
    If Not fso.FolderExists(path) Then fso.CreateFolder path
    path = path & "\" & frmBot.Bot(Index).Profile
    If Not fso.FolderExists(path) Then fso.CreateFolder path
    path = path & "\" & MonthName(Month(Date)) & " " & Year(Date)
    If Not fso.FolderExists(path) Then fso.CreateFolder path
    path = path & "\" & WeekdayName(Weekday(Date), False) & " " & Dayeth(Day(Date)) & ".txt"
    If Not fso.FileExists(path) Then fso.CreateTextFile path
    Open path For Append As #9
        Print #9, CurrentTime & Replace$(Mid$(frmBot.rtbChat(Index).Text, SelStart + 1), vbNewLine, vbNullString)
    Close #9
    Exit Function
hErr:
    ErrorHandler "ReadWrite", "WriteLog"
End Function

Public Function RandomQuote() As String
    On Error GoTo hErr
    Open AppData & "Quotes.txt" For Append As #1
    Close #1
    
    Open AppData & "Quotes.txt" For Input As #1
        Dim strContent As String
        strContent = Input(LOF(1), #1)
    Close #1
    
    Dim Counter As Long
    Do Until Counter = 3 Or LenB(RandomQuote) > 0 Or Err
        If InStrB(strContent, vbNewLine) > 0 Then
            Dim strLines() As String
            strLines = Split(strContent, vbNewLine)
            Randomize Timer
            RandomQuote = strLines(Int(Rnd * UBound(strLines)))
            Counter = Counter + 1
        Else
            RandomQuote = strContent
            Counter = Counter + 1
        End If
        DoEvents
    Loop
    Exit Function
hErr:
    ErrorHandler "ReadWrite", "RandomQuote"
End Function

Public Function FileList(Mask As String) As String()
    On Error GoTo hErr
    Dim sWkg As String, sAns() As String, lCtr As Long
    ReDim sAns(0) As String
    sWkg = Dir(Mask, vbNormal)
    Do While Len(sWkg)
        If sAns(0) = vbNullString Then
            sAns(0) = sWkg
        Else
            lCtr = UBound(sAns) + 1
            ReDim Preserve sAns(lCtr) As String
            sAns(lCtr) = sWkg
        End If
        sWkg = Dir
    Loop
    FileList = sAns
    Exit Function
hErr:
    ErrorHandler "ReadWrite", "FileList"
End Function

Public Function ReadIni(ByRef File As String, ByRef Section As String, ByRef key As String) As String
    On Error GoTo hErr
    If (fso.FileExists(File) = False) Then
        fso.CreateTextFile File
        Exit Function
    End If
    Dim Buffer As String * 256
    GetPrivateProfileString Section, key, vbNullString, Buffer, 256, File
    If InStrB(Buffer, vbNullChar) > 0 Then Buffer = Split(Buffer, vbNullChar)(0)
    ReadIni = Trim$(Buffer)
    Exit Function
hErr:
    ErrorHandler "ReadWrite", "ReadIni"
End Function

Public Sub WriteIni(ByRef File As String, ByRef Section As String, ByRef key As String, ByRef value As String)
    On Error GoTo hErr
    If (fso.FileExists(File) = False) Then
        fso.CreateTextFile File
        Exit Sub
    End If
    WritePrivateProfileString Section, key, value, File
    Exit Sub
hErr:
    ErrorHandler "ReadWrite", "WriteIni"
End Sub

Public Function DebugOutput(ByVal sIn As String) As String
    On Error GoTo hErr
    Dim x1 As Long, y1 As Long
    Dim iLen As Long, iPos As Long
    Dim sB As String, ST As String
    Dim sOut As String
    Dim Offset As Long, sOffset As String
    
    iLen = Len(sIn)
    If iLen = 0 Then Exit Function
    sOut = vbNullString
    Offset = 0
    For x1 = 0 To ((iLen - 1) \ 16)
        sOffset = Right$("0000" & Hex(Offset), 4)
        sB = String(48, " ")
        ST = "................"
        For y1 = 1 To 16
        iPos = 16 * x1 + y1
        If iPos > iLen Then Exit For
        Mid$(sB, 3 * (y1 - 1) + 1, 2) = Right$("00" & Hex(Asc(Mid$(sIn, iPos, 1))), 2) & " "
        Select Case Asc(Mid$(sIn, iPos, 1))
        Case 0, 9, 10, 13
        Case Else
            Mid$(ST, y1, 1) = Mid$(sIn, iPos, 1)
        End Select
        Next y1
        If LenB(sOut) > 0 Then sOut = sOut & vbCrLf
        sOut = sOut & sOffset & ":  "
        sOut = sOut & sB & "  " & ST
        Offset = Offset + 16
    Next x1
    DebugOutput = sOut
    Exit Function
hErr:
    ErrorHandler "ReadWrite", "DebugOutput"
End Function
