Attribute VB_Name = "modProfiles"
Option Explicit

Public SelectedTab As Integer

Public Property Get SelectedBot() As Integer
    'Get the selected bot
    SelectedBot = TabToBotIndex(SelectedTab)
    'Check if selectedbot is valid
    frmBot.mnuModeration.Visible = (SelectedBot > -1)
End Property

Public Sub DeleteProfile(Profile As String)
    On Error GoTo hErr
    Kill AppData & "Profiles\" & Profile & ".ini"
    Dim i As Integer
    For i = 1 To frmBot.tbsProfile.Tabs.Count
        If frmBot.tbsProfile.Tabs(i).Caption = Profile Then
            UnloadProfile i
            Exit For
        End If
    Next i
    Exit Sub
hErr:
    MsgBox "An error occurred when trying to delete this profile: " & vbNewLine & Err.Description, vbCritical, "Delete Profile"
End Sub

Public Sub SaveLoadedProfiles()
    'Initialize profiles array
    Dim i As Integer, Profiles() As String
    ReDim Profiles(0)
    For i = 0 To frmBot.Bot.UBound
        'Check if current bot is loaded
        If (frmBot.Bot(i).IsLoaded) Then
            If LenB(Profiles(0)) = 0 Then
                'Set array item 0 to profile
                Profiles(0) = frmBot.Bot(i).Profile
            Else
                'Add profile to array
                ReDim Preserve Profiles(UBound(Profiles) + 1)
                Profiles(UBound(Profiles)) = frmBot.Bot(i).Profile
            End If
        End If
    Next i
    'Finally, write loaded profiles
    WriteIni AppSettings, "Cache", "LoadedProfiles", Join(Profiles, ":")
End Sub

Public Sub LoadProfile(ByVal strProfile As String)
    On Error GoTo hErr
    'Check if profile is already loaded
    Dim n As Integer
    For n = 0 To frmBot.Bot.UBound
        If (frmBot.Bot(n).Profile = strProfile) Then
            'Profile is loaded, tell user!
            MsgBox "Profile " & """" & strProfile & """" & " is already loaded!", vbExclamation
            Exit Sub
        End If
    Next n
    'Initialize variables
    Dim F As String, intBot As Integer, r As Integer
    F = AppData & "Profiles\" & strProfile & ".ini"
    intBot = -1
    'Check if there is a bot to reuse
    For r = 0 To frmBot.Bot.UBound
        If (Not frmBot.Bot(r).IsLoaded) Then intBot = r: Exit For
    Next r
    'Cannot reuse an unloaded Bot
    If (intBot = -1) Then
        'Load a new instance of the Bot
        Load frmBot.Bot(frmBot.Bot.UBound + 1)
        intBot = frmBot.Bot.UBound
        'Load new controls
        Load frmBot.rtbChat(intBot)
        Load frmBot.rtbWhsp(intBot)
        Load frmBot.lvUsers(intBot)
        'Set controls to visible
        frmBot.rtbChat(intBot).Visible = True
        frmBot.rtbWhsp(intBot).Visible = True
        frmBot.lvUsers(intBot).Visible = True
    End If
    'Change icon set to currently defined
    If Not frmBot.mnuWarCraftIcons.Checked Then
        Set frmBot.lvUsers(intBot).SmallIcons = frmBot.imlClassic
    Else
        Set frmBot.lvUsers(intBot).SmallIcons = frmBot.imlWarCraft
    End If
    'Clear all controls so previous index controls data is not copied
    frmBot.rtbChat(intBot).Text = vbNullString
    frmBot.lvUsers(intBot).ListItems.Clear
    'Copy information to bot
    frmBot.Bot(intBot).BotIndex = intBot
    frmBot.Bot(intBot).ProfilePath = F
    LoadProfileValues F, frmBot.Bot(intBot)
    frmBot.Bot(intBot).IsLoaded = True
    frmBot.Bot(intBot).Profile = strProfile
    frmBot.Bot(intBot).DbFile = AppData & "Profiles\" & strProfile & ".db"
    frmBot.Bot(intBot).ReloadDatabase
    'Create a tab
    frmBot.tbsProfile.Tabs.Add(, , strProfile, 1).Tag = intBot
    'Select the tab
    If SelectedTab = 0 Then ViewProfile frmBot.tbsProfile.Tabs.Count
    'Resize the form
    frmBot.Form_Resize
    Exit Sub
hErr:
    Close #1
    ErrorHandler "Profiles", "LoadProfile"
End Sub

Public Sub LoadModerationValues(F As String, b As BNCS)
    'Import moderation settings
    b.Config.Moderation.Lockdown = (UCase$(ReadIni(F, "Moderation", "Lockdown")) = "Y")
    b.Config.Moderation.Floodban = (UCase$(ReadIni(F, "Moderation", "Floodban")) = "Y")
    b.Config.Moderation.Loadban = (UCase$(ReadIni(F, "Moderation", "Loadban")) = "Y")
    b.Config.Moderation.Numberban = (UCase$(ReadIni(F, "Moderation", "Numberban")) = "Y")
    b.Config.Moderation.PingHigh = (UCase$(ReadIni(F, "Moderation", "PingHigh")) = "Y")
    b.Config.Moderation.PingNegative = (UCase$(ReadIni(F, "Moderation", "PingNegative")) = "Y")
    b.Config.Moderation.PingZero = (UCase$(ReadIni(F, "Moderation", "PingZero")) = "Y")
    b.Config.Moderation.Plugban = (UCase$(ReadIni(F, "Moderation", "Plugban")) = "Y")
    b.Config.Moderation.Ipban = (UCase$(ReadIni(F, "Moderation", "Ipban")) = "Y")
    b.Config.Moderation.Clientban = (UCase$(ReadIni(F, "Moderation", "Clientban")) = "Y")
    b.Config.Moderation.ClientSTAR = (UCase$(ReadIni(F, "Moderation", "ClientSTAR")) = "Y")
    b.Config.Moderation.ClientSEXP = (UCase$(ReadIni(F, "Moderation", "ClientSEXP")) = "Y")
    b.Config.Moderation.ClientW2BN = (UCase$(ReadIni(F, "Moderation", "ClientW2BN")) = "Y")
    b.Config.Moderation.ClientWAR3 = (UCase$(ReadIni(F, "Moderation", "ClientWAR3")) = "Y")
    b.Config.Moderation.ClientW3XP = (UCase$(ReadIni(F, "Moderation", "ClientW3XP")) = "Y")
    b.Config.Moderation.ClientD2DV = (UCase$(ReadIni(F, "Moderation", "ClientD2DV")) = "Y")
    b.Config.Moderation.ClientD2XP = (UCase$(ReadIni(F, "Moderation", "ClientD2XP")) = "Y")
End Sub

Public Sub LoadProfileValues(F As String, b As BNCS)
    On Error GoTo hErr
    LoadModerationValues F, b
    'Import configuration settings
    b.Config.Plug = (UCase$(ReadIni(F, "Main", "Plug")) = "Y")
    b.Config.Idle = (UCase$(ReadIni(F, "Idle", "Idle")) = "Y")
    b.Config.IdleTime = Val(ReadIni(F, "Idle", "Time"))
    b.Config.IdleMessage = ReadIni(F, "Idle", "Message")
    b.Config.Greet = (UCase$(ReadIni(F, "Greeting", "Greeting")) = "Y")
    b.Config.GreetMessage = ReadIni(F, "Greeting", "Message")
    b.Config.Farewell = (UCase$(ReadIni(F, "Farewell", "Farewell")) = "Y")
    b.Config.FarewellMessage = ReadIni(F, "Farewell", "Message")
    b.Config.BnlsServer = ReadIni(F, "BNLS", "Server")
    b.Config.Cdkey = ReadIni(F, "Main", "Cdkey")
    b.Config.Realm = LCase$(RealmToStr(Val(ReadIni(F, "Main", "Realm"))))
    b.Config.CdkeyEx = ReadIni(F, "Main", "CdkeyEx")
    b.Config.Channel = ReadIni(F, "Main", "Channel")
    b.Config.JoinChannel = (UCase$(ReadIni(F, "Main", "Join") = "Y"))
    b.Config.Password = ReadIni(F, "Main", "Password")
    b.Config.Trigger = ReadIni(F, "Main", "Trigger")
    b.Config.NewPassword = ReadIni(F, "Main", "NewPassword")
    b.Config.Email = ReadIni(F, "Register", "Email")
    b.Config.NewEmail = ReadIni(F, "Register", "NewEmail")
    b.Config.ProductID = ReadIni(F, "Main", "ProductID")
    b.Config.Verbyte = CByte(Val("&H0" & ReadIni(F, "Main", "Verbyte")))
    b.Config.Proxy.Proxy = ReadIni(F, "Proxy", "Proxy")
    b.Config.Proxy.Port = Val(ReadIni(F, "Proxy", "Port"))
    b.Config.Proxy.Ident = ReadIni(F, "Proxy", "Ident")
    b.Config.Proxy.Socks = IIf(Val(ReadIni(F, "Proxy", "SocksVer")) = 4, SocksVer.Socks4, SocksVer.Socks5)
    b.Config.Proxy.UseProxy = (UCase$(ReadIni(F, "Proxy", "UseProxy") = "Y"))
    b.Config.server = ReadIni(F, "Main", "Server")
    b.Config.UseBNLS = (UCase$(ReadIni(F, "BNLS", "UseBNLS") = "Y"))
    b.Config.Username = ReadIni(F, "Main", "Username")
    If LenB(b.Config.Trigger) = 0 Then b.Config.Trigger = "."
    Select Case Val(ReadIni(F, "Register", "Mode"))
        Case 0, 1, 2, 3: b.Config.Register = Val(ReadIni(F, "Register", "Mode"))
        Case Else: b.Config.Register = Disabled
    End Select
    Select Case Val(ReadIni(F, "Main", "Ping"))
        Case 0, 1, 2: b.Config.Ping = Val(ReadIni(F, "Main", "Ping"))
        Case Else: b.Config.Ping = DisablePing
    End Select
    Exit Sub
hErr:
    Close #1
    ErrorHandler "Profiles", "LoadProfileValues"
End Sub

Public Sub ViewProfile(ByVal intTab As Integer)
    On Error GoTo hErr
    Dim intBot As Integer
    intBot = TabToBotIndex(intTab)
    If (intBot <> -1) Then
        SelectedTab = intTab
        frmBot.Bot(intBot).IsActive = False
        frmBot.rtbChat(intBot).ZOrder vbBringToFront
        frmBot.rtbWhsp(intBot).ZOrder vbBringToFront
        frmBot.lvUsers(intBot).ZOrder vbBringToFront
        'Clan options
        If frmBot.Bot(intBot).IsWarCraft And frmBot.Bot(intBot).IsOnline Then
            frmBot.mnuInClan.Visible = (frmBot.Bot(intBot).Self.Clanned)
            frmBot.mnuClan.Visible = Not frmBot.mnuInClan.Visible
        Else
            frmBot.mnuInClan.Visible = False
            frmBot.mnuClan.Visible = False
        End If
        'Moderation options
        LoadModerationValues frmBot.Bot(intBot).ProfilePath, frmBot.Bot(intBot)
        frmBot.mnuClientbans.Checked = frmBot.Bot(intBot).Config.Moderation.Clientban
        frmBot.mnuClientD2DV.Checked = frmBot.Bot(intBot).Config.Moderation.ClientD2DV
        frmBot.mnuClientD2XP.Checked = frmBot.Bot(intBot).Config.Moderation.ClientD2XP
        frmBot.mnuClientSTAR.Checked = frmBot.Bot(intBot).Config.Moderation.ClientSTAR
        frmBot.mnuClientSEXP.Checked = frmBot.Bot(intBot).Config.Moderation.ClientSEXP
        frmBot.mnuClientW2BN.Checked = frmBot.Bot(intBot).Config.Moderation.ClientW2BN
        frmBot.mnuClientWAR3.Checked = frmBot.Bot(intBot).Config.Moderation.ClientWAR3
        frmBot.mnuClientW3XP.Checked = frmBot.Bot(intBot).Config.Moderation.ClientW3XP
        frmBot.mnuPingZero.Checked = frmBot.Bot(intBot).Config.Moderation.PingZero
        frmBot.mnuPingNeg.Checked = frmBot.Bot(intBot).Config.Moderation.PingNegative
        frmBot.mnuPingHigh.Checked = frmBot.Bot(intBot).Config.Moderation.PingHigh
        frmBot.mnuPlugban.Checked = frmBot.Bot(intBot).Config.Moderation.Plugban
        frmBot.mnuLoadban.Checked = frmBot.Bot(intBot).Config.Moderation.Loadban
        frmBot.mnuLockdown.Checked = frmBot.Bot(intBot).Config.Moderation.Lockdown
        frmBot.mnuNumberban.Checked = frmBot.Bot(intBot).Config.Moderation.Numberban
        frmBot.mnuIpban.Checked = frmBot.Bot(intBot).Config.Moderation.Ipban
        frmBot.mnuFloodban.Checked = frmBot.Bot(intBot).Config.Moderation.Floodban
        'Diablo options
        frmBot.mnuCharacterList.Visible = frmBot.Bot(intBot).IsDiablo
        'Connection options
        frmBot.mnuConnect.Caption = IIf(frmBot.Bot(intBot).IsConnected, "Reconnect", "Connect")
    Else
        If (frmBot.tbsProfile.Tabs.Count > 0) Then ViewProfile 1
    End If
    'Check if bot is online
    If frmBot.Bot(intBot).IsOnline Then
        frmBot.lblChannel.Caption = "#" & frmBot.Bot(intBot).Self.Channel & " (" & frmBot.lvUsers(intBot).ListItems.Count & ")"
    Else
        frmBot.lblChannel.Caption = "-- Offline --"
    End If
    'Refresh the channel
    RefreshChannel
    'Update the view timer
    frmBot.tmrView_Timer
    'Resize the main form
    frmBot.Form_Resize
    Exit Sub
hErr:
    Close #1
    ErrorHandler "Profiles", "ViewProfile"
End Sub

Public Sub UnloadProfile(ByVal intTab As Integer)
    On Error GoTo hErr
    Dim intBot As Integer
    intBot = TabToBotIndex(intTab)
    'Check if bot index is valid
    If (intBot > -1) Then
        'Close connection
        frmBot.Bot(intBot).Disconnect
        'Clear variables
        frmBot.Bot(intBot).Profile = vbNullString
        'No longer loaded
        frmBot.Bot(intBot).IsLoaded = False
        'Clear controls
        frmBot.rtbChat(intBot).Text = vbNullString
        frmBot.rtbWhsp(intBot).Text = vbNullString
        frmBot.lvUsers(intBot).ListItems.Clear
        'Clear classes
        Set frmBot.Bot(intBot).Self = New clsSelf
        Set frmBot.Bot(intBot).Config = New clsConfig
    End If
    'Check if tab is valid
    If TabWithinBounds(intTab) Then
        frmBot.tbsProfile.Tabs.Remove intTab
        If (frmBot.tbsProfile.Tabs.Count > 0) Then ViewProfile 1
    Else
        MsgBox "Cannot unload profile, tab index is out of bounds!", vbExclamation
    End If
    Exit Sub
hErr:
    Close #1
    ErrorHandler "Profiles", "UnloadProfile"
End Sub

Public Function LoadTabOnly(intBot As Integer) As Boolean
    'Load the tab, when you switch from tabless to tabbed
    frmBot.Bot(intBot).Tabless = False
    frmBot.tbsProfile.Tabs.Add(, , frmBot.Bot(intBot).Profile, 1).Tag = intBot
End Function

Public Function UnloadTabOnly(intBot As Integer) As Boolean
    'Unload the tab, but leave the bot loaded (tabless)
    On Error GoTo hErr
    If frmBot.tbsProfile.Tabs.Count > 1 Then
        Dim i As Integer
        For i = 1 To frmBot.tbsProfile.Tabs.Count
            If (Val(frmBot.tbsProfile.Tabs(i).Tag) = intBot) Then
                frmBot.Bot(intBot).Tabless = True
                frmBot.tbsProfile.Tabs.Remove i
                UnloadTabOnly = True
                Exit Function
            End If
        Next i
    Else
        MsgBox "You must have atleast one bot being tabbed!", vbExclamation
        Exit Function
    End If
    SelectNextTab
hErr:
    UnloadTabOnly = False
End Function

Public Sub CreateProfile()
    On Error GoTo hErr
    Dim str As String
    str = InputBox("Enter name for new profile:", "Create Profile")
    str = FixFilename(str)
    If LenB(str) > 0 Then
        Open AppData & "Profiles\" & str & ".ini" For Append As #1
        Close #1
        frmConfigure.ProfileManager = True
        frmConfigure.Show
        frmConfigure.ShowProfile str
    End If
    Exit Sub
hErr:
    MsgBox "An error occurred when trying to create a profile: " & vbNewLine & Err.Description, vbCritical, "Create Profile"
End Sub

Public Function RenameProfile(CurrentName As String) As String
    On Error GoTo hErr
    Dim str As String
    str = InputBox("Enter what you want to call the profile:", "Rename Profile", CurrentName)
    str = FixFilename(str)
    If LenB(str) > 0 Then
        Dim i As Integer
        For i = 1 To frmBot.tbsProfile.Tabs.Count
            If frmBot.tbsProfile.Tabs(i).Caption = CurrentName Then
                frmBot.tbsProfile.Tabs(i).Caption = str
                Exit For
            End If
        Next i
        For i = 0 To frmBot.Bot.UBound
            If frmBot.Bot(i).Profile = CurrentName Then
                frmBot.Bot(i).Profile = str
                Exit For
            End If
        Next i
        RenameProfile = str
        If fso.FileExists(AppData & "Profiles\" & CurrentName & ".db") Then
            FileCopy AppData & "Profiles\" & CurrentName & ".db", AppData & "Profiles\" & str & ".db"
            Kill AppData & "Profiles\" & CurrentName & ".db"
        End If
        FileCopy AppData & "Profiles\" & CurrentName & ".ini", AppData & "Profiles\" & str & ".ini"
        Kill AppData & "Profiles\" & CurrentName & ".ini"
    End If
    Exit Function
hErr:
    str = vbNullString
    MsgBox "An error occurred when trying to rename this profile: " & vbNewLine & Err.Description, vbCritical, "Rename Profile"
End Function

Public Sub SelectNextTab()
    'Select the next tab
    On Error GoTo hErr
    If frmBot.tbsProfile.Tabs.Count > 0 Then
        Dim i As Integer
        For i = 1 To frmBot.tbsProfile.Tabs.Count
            ViewProfile i
            Exit For
        Next i
    End If
    Exit Sub
hErr:
    ErrorHandler "Profiles", "SelectNextTab"
End Sub

Public Function BotToTabIndex(intBot As Integer) As Integer
    'Convert bot to tab index
    On Error GoTo hErr
    If frmBot.tbsProfile.Tabs.Count > 0 Then
        Dim i As Integer
        For i = 1 To frmBot.tbsProfile.Tabs.Count
            If (Val(frmBot.tbsProfile.Tabs(i).Tag) = intBot) Then
                BotToTabIndex = i
                Exit Function
            End If
        Next i
    End If
hErr:
    BotToTabIndex = -1
End Function

Public Function TabToBotIndex(intTab As Integer) As Integer
    'Convert tab to bot index
    If TabWithinBounds(intTab) Then
        TabToBotIndex = Val(frmBot.tbsProfile.Tabs(intTab).Tag)
    Else
        TabToBotIndex = -1
    End If
End Function

Public Function TabWithinBounds(intTab As Integer) As Boolean
    'Check if tab exists
    TabWithinBounds = (intTab <= frmBot.tbsProfile.Tabs.Count And intTab > 0)
End Function
