Attribute VB_Name = "modOpacity"
Private Declare Function GetWindowLong Lib "user32" Alias "GetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long) As Long
Private Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function SetLayeredWindowAttributes Lib "user32" (ByVal hwnd As Long, ByVal crey As Byte, ByVal bAlpha As Byte, ByVal dwFlags As Long) As Long

Private Const GWL_EXSTYLE = (-20)
Private Const WS_EX_LAYERED = &H80000
Private Const LWA_ALPHA = &H2&

Public Sub ChangeOpacity(frm As Form, ByVal bytPercent As Byte)
    #If Win32 Then
        If (bytPercent < 100) Then
            Dim bytOpacity As Byte
            bytOpacity = 255 * (bytPercent / 100)
            Call SetWindowLong(frm.hwnd, GWL_EXSTYLE, GetWindowLong(frm.hwnd, GWL_EXSTYLE) Or WS_EX_LAYERED)
            Call SetLayeredWindowAttributes(frm.hwnd, 0, bytOpacity, LWA_ALPHA)
        Else
            Call SetWindowLong(frm.hwnd, GWL_EXSTYLE, GetWindowLong(frm.hwnd, GWL_EXSTYLE) And (Not WS_EX_LAYERED))
        End If
    #End If
End Sub
