Attribute VB_Name = "modGroups"
Option Explicit

Public Groups() As clsGroup
Public GroupsLoaded As Boolean

Public Sub RefreshChannel()
    On Error GoTo hErr
    Dim I As Integer
    For I = 1 To frmBot.lvUsers(SelectedBot).ListItems.Count
        Dim lngColor As Long
        lngColor = GetGroupColor(frmBot.lvUsers(SelectedBot).ListItems(I).text)
        With frmBot.lvUsers(SelectedBot).ListItems(I)
            If lngColor <> -1 Then
                If .ForeColor <> lngColor Then .ForeColor = lngColor
            Else
                If (LCase$(Suffix(.text)) = LCase$(frmBot.Bot(SelectedBot).Self.Username)) Then
                    If .ForeColor <> vbSkyBlue Then .ForeColor = vbSkyBlue
                Else
                    If frmBot.mnuIdleColoring.Checked Then
                        If frmBot.Bot(SelectedBot).UserIsIdle(.text) Then
                            If .ForeColor <> &HA0A0A0 Then .ForeColor = &HA0A0A0
                        Else
                            If .ForeColor <> vbWhite Then .ForeColor = vbWhite
                        End If
                    Else
                        If .ForeColor <> vbWhite Then .ForeColor = vbWhite
                    End If
                End If
            End If
        End With
    Next I
    Exit Sub
hErr:
    Close #1
    ErrorHandler "Groups", "RefreshChannel"
End Sub

Public Function AddToGroup(Group As String, Username As String) As Boolean
    On Error GoTo hErr
    If GroupsLoaded = True Then
        Dim I As Integer
        For I = 0 To UBound(Groups())
            If LCase$(Groups(I).Name) = LCase$(Group) Then
                Groups(I).AddMember Username
                Groups(I).SaveGroup
                AddToGroup = True
                Exit Function
            End If
        Next I
    End If
    Exit Function
hErr:
    ErrorHandler "Groups", "AddToGroup"
End Function

Public Function RemoveFromGroup(Username As String) As Boolean
    On Error GoTo hErr
    If GroupsLoaded = True Then
        Dim I As Integer, n As Integer
        For I = 0 To UBound(Groups())
            If Groups(I).IsInGroup(Username) Then
                RemoveFromGroup = Groups(I).RemoveMember(Username)
                Groups(I).SaveGroup
                Exit Function
            End If
        Next I
    End If
    Exit Function
hErr:
    ErrorHandler "Groups", "RemoveFromGroup"
End Function

Public Function GetGroupColor(Username As String) As Long
    On Error GoTo hErr
    Dim I As Integer
    For I = 0 To UBound(Groups)
        If Not Groups(I) Is Nothing Then
            If Groups(I).IsInGroup(Username) Then
                GetGroupColor = Groups(I).Color
                Exit Function
            End If
        End If
    Next I
hErr:
    GetGroupColor = -1
End Function

Public Function GetGroupName(Username As String) As String
    On Error GoTo hErr
    If GroupsLoaded = True Then
        Dim I As Integer
        For I = 0 To UBound(Groups)
            If Groups(I).IsInGroup(Username) Then
                GetGroupName = Groups(I).Name
                Exit Function
            End If
        Next I
    End If
    Exit Function
hErr:
    ErrorHandler "Groups", "GetGroupName"
End Function

Public Sub DisplayGroups()
    On Error GoTo hErr
    Dim I As Integer
    For I = frmBot.mnuGroups.UBound To 1 Step -1
        Unload frmBot.mnuGroups(I)
    Next I
    frmBot.mnuGroups(0).Caption = "-"
    If GroupsLoaded = True Then
        If ArrayInit(Not Groups) Then
            If LenB(Groups(0).Name) > 0 Then
                For I = 0 To UBound(Groups)
                    If frmBot.mnuGroups(0).Caption = "-" Then
                        frmBot.mnuGroups(0).Caption = Groups(I).Name
                    Else
                        Load frmBot.mnuGroups(frmBot.mnuGroups.Count)
                        frmBot.mnuGroups(frmBot.mnuGroups.UBound).Caption = Groups(I).Name
                    End If
                Next I
            End If
        End If
    End If
    Exit Sub
hErr:
    Close #1
    ErrorHandler "Group", "DisplayGroups"
End Sub

Public Sub LoadGroups()
    ReDim Groups(0)
    GroupsLoaded = False
    On Error GoTo hErr
    Dim Files() As String, I As Integer, n As Integer, ts As TextStream
    If (fso.FolderExists(AppData & "Groups\") = False) Then fso.CreateFolder AppData & "Groups\"
    If LenB(Dir$(AppData & "Groups\")) > 0 Then
        Files = FileList(AppData & "Groups\*.txt")
        If ArrayInit(Not Files) Then
            ReDim Groups(UBound(Files()))
            GroupsLoaded = True
            For I = 0 To UBound(Files())
                Set Groups(I) = New clsGroup
                Groups(I).ClearMembers
                Groups(I).Name = Left$(Files(I), InStrRev(Files(I), ".") - 1)
                Set ts = fso.OpenTextFile(AppData & "Groups\" & Files(I), ForReading)
                Dim content As String, lines() As String
                If ts.AtEndOfStream = False Then
                    content = ts.ReadAll()
                    ts.Close
                    If InStrB(content, vbNewLine) > 0 Then
                        lines = Split(content, vbNewLine)
                        If lines(0) Like "Color=*" Then
                            Groups(I).Color = Val(Mid$(lines(0), 7))
                        End If
                        If Groups(I).Color = 0 Then Groups(I).Color = vbWhite
                        For n = 1 To UBound(lines)
                            If LenB(lines(n)) > 0 Then
                                Groups(I).AddMember lines(n)
                            End If
                        Next n
                    End If
                End If
            Next I
        End If
    End If
    Exit Sub
hErr:
    Close #1
    ErrorHandler "Group", "LoadGroups"
End Sub

