VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsStatstring"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Function GetClientName(ByRef ProductID$, Optional ByVal Short As Boolean) As String
    On Error GoTo hErr
    Select Case UCase$(ProductID)
        Case "CHAT", "TAHC": GetClientName = "Telnet Client"
        Case "STAR", "RATS": GetClientName = "StarCraft"
        Case "JSTR", "RTSJ": GetClientName = "StarCraft Japanese"
        Case "SSHR", "RHSS": GetClientName = "StarCraft Shareware"
        Case "SEXP", "PXES": GetClientName = "StarCraft BroodWar"
        Case "W2BN", "NB2W": GetClientName = "WarCraft II Battle.net Edition"
        Case "WAR3", "3RAW": GetClientName = "WarCraft III Reign of Chaos"
        Case "W3XP", "PX3W": GetClientName = "WarCraft III Frozen Throne"
        Case "D2DV", "VD2D": GetClientName = "Diablo II Classic"
        Case "D2XP", "PX2D": GetClientName = "Diablo II Lord of Destruction"
        Case "DRTL", "LTRD": GetClientName = "Diablo"
        Case "DSHR", "RHSD": GetClientName = "Diablo Shareware"
        Case Else: GetClientName = "Unknown (" & ProductID & ")"
    End Select
    Exit Function
hErr:
    ErrorHandler "Statstring", "GetClientName"
End Function

Public Function GetClanName(ByVal Statstring$) As String
    On Error GoTo hErr
    If LenB(Statstring) = 0 Then Exit Function
    If Left$(Statstring, 4) = "3RAW" Or Left$(Statstring, 4) = "PX3W" Then
        Dim Splt() As String
        Splt() = Split(Statstring, Space$(1))
        If UBound(Splt) = 3 Then
            GetClanName = Replace$(StrReverse$(Right$(Splt(3), 4)), vbNullChar, vbNullString)
        End If
    End If
    Exit Function
hErr:
    ErrorHandler "Statstring", "GetClanName"
End Function

Public Function GetClientStats(ByVal Statstring$) As String
    On Error GoTo hErr
    If Len(Statstring) < 5 Then Exit Function
    Dim client As String * 4
    client = UCase$(Left$(Statstring, 4))
    Select Case client
        Case "STAR", "RATS", "JSTR", "RTSJ", "SEXP", "PXES", "SSHR", "RHSS", "W2BN", "NB2W"
            GetClientStats = GetStarCraftStats(Statstring$)
        Case "DRTL", "LTRD", "DSHR", "RHSD"
            GetClientStats = GetDiabloStats(Statstring$)
        Case "WAR3", "3RAW"
            GetClientStats = GetReignOfChaosStats(Statstring$)
        Case "W3XP", "PX3W"
            GetClientStats = GetFrozenThroneStats(Statstring$)
        Case "D2DV", "VD2D", "D2XP", "PX2D"
            GetClientStats = GetDiablo2Stats(Statstring$)
        Case Else
            GetClientStats = vbNullString
    End Select
    Exit Function
hErr:
    ErrorHandler "Statstring", "GetClientStats"
End Function

Private Function GetStarCraftStats(ByRef Statstring$) As String
    On Error GoTo hErr
    Dim w$()
    w$() = Split(Statstring, Space$(1))
    GetStarCraftStats = w$(3) & " wins" & IIf(Val(w$(2)) > 0, ", #" & w$(3), vbNullString) & IIf(Val(w$(1)) > 0, ", " & w$(1) & " rating", vbNullString) & IIf(Val(w$(4)) = 1, ", spawned", vbNullString)
    Exit Function
hErr:
    ErrorHandler "Statstring", "GetStarCraftStats"
End Function

Private Function GetReignOfChaosStats(ByRef Statstring$) As String
    On Error GoTo hErr
    ''No tier
    If Len(Statstring) = 4 Then
        GetReignOfChaosStats = vbNullString
        Exit Function
    End If
    
    ''Get tier
    Dim tier As String
    tier = Left$(Split(Statstring, Space$(1))(1), 2)
    
    ''Check if peon
    If Val(Left$(tier, 1)) = 1 Then GetReignOfChaosStats = "Orc Peon": Exit Function
    
    ''Create tier arrays
    Dim buf As String
    Dim hTier(), _
        eTier(), _
        oTier(), _
        uTier(), _
        rTier()
    
    ''Build arrays
    hTier() = Array("Footman (25+ wins)", "Knight (250+ wins)", "Archmage (500+ wins)", "Medivh (1500+ wins)")
    oTier() = Array("Grunt (25+ wins)", "Tauren (250+ wins)", "Far Seer (500+ wins)", "Thrall (1500+ wins)")
    eTier() = Array("Archer (25+ wins)", "Druid of the Claw (250+ wins)", "Priestess of the Moon (500+ wins)", "Furion Stormrage (1500+ wins)")
    uTier() = Array("Ghoul (25+ wins)", "Abomination (250+ wins)", "Lich (500+ wins)", "Tichondrius (1500+ wins)")
    rTier() = Array("Green Dragon Whelp (25+ wins)", "Blue Dragon (250+ wins)", "Red Dragon (500+ wins)", "Deathwing (1500+ wins)")
    
    ''Build buffer
    Select Case Mid$(tier, 2, 1)
        Case "H": buf = "Human " & CStr(hTier(Val(Left$(tier, 1)) - 2))
        Case "N": buf = "Night Elf " & CStr(eTier(Val(Left$(tier, 1)) - 2))
        Case "O": buf = "Orc " & CStr(oTier(Val(Left$(tier, 1)) - 2))
        Case "R": buf = "Random " & CStr(rTier(Val(Left$(tier, 1)) - 2))
        Case "U": buf = "Undead " & CStr(uTier(Val(Left$(tier, 1)) - 2))
    End Select
    
    ''Return
    GetReignOfChaosStats = buf
    Exit Function
hErr:
    ErrorHandler "Statstring", "GetReignOfChaosStats"
End Function

Private Function GetFrozenThroneStats(ByRef Statstring$) As String
    On Error GoTo hErr
    ''No tier
    If Len(Statstring) = 4 Then
        GetFrozenThroneStats = vbNullString
        Exit Function
    End If
    
    ''Get tier
    Dim tier As String
    tier = Left$(Split(Statstring, Space$(1))(1), 2)
    
    ''Check if peon
    If Val(Left$(tier, 1)) = 1 Then GetFrozenThroneStats = "Orc Peon": Exit Function
    
    ''Create tier arrays
    Dim buf As String
    Dim hTier(), _
        eTier(), _
        oTier(), _
        uTier(), _
        tTier(), _
        rTier()

    ''Build arrays
    hTier() = Array("Rifleman (25+ wins)", "Sorceress (150+ wins)", "Spellbreaker (350+ wins)", "Blood Mage (750+ wins)", "Jaina (1500+ wins)")
    oTier() = Array("Troll Headhunter (25+ wins)", "Shaman (150+ wins)", "Spirit Walker (350+ wins)", "Shadow Hunter (750+ wins)", "Rexxar (1500+ wins)")
    eTier() = Array("Huntress (25+ wins)", "Druid of the Talon (150+ wins)", "Dryad (350+ wins)", "Keeper of the Grove (750+ wins)", "Maiev (1500+ wins)")
    uTier() = Array("Crypt Fiend (25+ wins)", "Banshee (150+ wins)", "Destroyer (350+ wins)", "Crypt Lord (750+ wins)", "Sylvanas (1500+ wins)")
    rTier() = Array("Myrmidon (25+ wins)", "Siren (150+ wins)", "Dragon Turtle (350+ wins)", "Sea Witch (750+ wins)", "Illidan (1500+ wins)")
    tTier() = Array("Felguard (25+ wins)", "Infernal (150+ wins)", "Doomguard (350+ wins)", "Pit Lord (750+ wins)", "Archimonde (1500+ wins)")
    
    ''Build buffer
    Select Case Mid$(tier, 2, 1)
        Case "H": buf = "Human " & CStr(hTier(Val(Left$(tier, 1)) - 2))
        Case "N": buf = "Night Elf " & CStr(eTier(Val(Left$(tier, 1)) - 2))
        Case "O": buf = "Orc " & CStr(oTier(Val(Left$(tier, 1)) - 2))
        Case "R": buf = "Random " & CStr(rTier(Val(Left$(tier, 1)) - 2))
        Case "T": buf = "Tournament " & CStr(tTier(Val(Left$(tier, 1)) - 2))
        Case "U": buf = "Undead " & CStr(uTier(Val(Left$(tier, 1)) - 2))
    End Select
    
    ''Return
    GetFrozenThroneStats = buf
    Exit Function
hErr:
    ErrorHandler "Statstring", "GetFrozenThroneStats"
End Function

Private Function GetDiabloStats(ByRef Statstring$) As String
    On Error GoTo hErr
    Dim w$(), Class$
    w$() = Split(Statstring, Space$(1))
    
    If UBound(w$()) = 9 Then
        Dim c()
        c() = Array("Warrior", "Rogue", "Sorceror")
        
        If Val(w(2)) > 2 Or Val(w(2)) < 0 Then
            GetDiabloStats = "Invalid class: " & Statstring
            Exit Function
        Else
            Class = CStr(c(Val(w(2))))
        End If
    Else
        GetDiabloStats = "Invalid stats: " & Statstring
        Exit Function
    End If

    GetDiabloStats = "lvl " & w$(1) & " " & Class & ", " & _
        w$(3) & " dots, " & w$(4) & " strength, " & _
        w$(5) & " magic, " & w$(6) & " dexterity, " & _
        w$(7) & " vitality, & " & w$(8) & " gold"
    Exit Function
hErr:
    ErrorHandler "Statstring", "GetDiabloStats"
End Function

Public Sub GetDiablo2Detail(ByRef Statstring As String, ByRef Level As Byte, ByRef Class As String, ByRef Expansion As Boolean)
    If Len(Statstring) <> 33 Then Exit Sub
    
    Dim r()
    r() = Array("Unknown", "Amazon", "Sorceress", _
        "Necromancer", "Paladin", "Barbarian", "Druid", "Assassin")
    
    Dim Race As Byte, Char As Byte
    Race = CByte(Asc(Mid$(Statstring, 14, 1)))
    Level = CByte(Asc(Mid$(Statstring, 26, 1)))
    Char = CByte(Asc(Mid$(Statstring, 27, 1)))
    If Char And &H20 Then Expansion = True
    If Race > 7 Or Race < 1 Then Race = 0
    Class = r(Race)
End Sub

Public Sub GetDiablo2Info(ByRef Statstring As String, ByRef Out() As String)
    On Error GoTo hErr
    ReDim Out(0)
    If Len(Statstring) = 4 Then Exit Sub

    Dim r()
    r() = Array("Unknown", "Amazon", "Sorceress", _
        "Necromancer", "Paladin", "Barbarian", "Druid", "Assassin")
    
    Dim Race As Byte, Level As Byte, charflag As Byte, actflag As Byte
    Dim hardcore As Boolean, ladder As Boolean, dead As Boolean
    Dim female As Boolean, Expansion As Boolean
    Dim product$, server$, Char$, raceStr$, Title$
    product$ = Left$(Statstring, 4)
    Statstring = Mid$(Statstring, 5)
    server$ = Left$(Statstring, InStr(Statstring, ",") - 1)
    Statstring = Mid$(Statstring, Len(server) + 2)
    Char$ = Left$(Statstring, InStr(Statstring, ",") - 1)
    Statstring = Mid$(Statstring, Len(Char) + 2)

    If Len(Statstring) <> 33 Then Exit Sub

    Race = CByte(Asc(Mid$(Statstring, 14, 1)))
    Level = CByte(Asc(Mid$(Statstring, 26, 1)))
    charflag = CByte(Asc(Mid$(Statstring, 27, 1)))
    actflag = CByte(Asc(Mid$(Statstring, 28, 1)))
    hardcore = CBool((charflag And &H4) = &H4)
    ladder = CBool(Asc(Mid$(Statstring, 31, 1)) < &HFF)
    
    If hardcore Then dead = CBool((charflag And &H8) = &H8)
    
    If Race > 7 Or Race < 1 Then Race = 0
    If Race = 1 Or Race = 2 Or Race = 7 Then female = True
    raceStr = r(Race)
    
    If product = "PX2D" Then
        If charflag And &H20 Then
            Expansion = True
            If hardcore Then
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Destroyer "
                    Case 2: Title = "Conqueror "
                    Case 3: Title = "Guardian "
                End Select
            Else
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Slayer "
                    Case 2: Title = "Champion "
                    Case 3: Title = IIf(female, "P", "M") & "atriarch "
                End Select
            End If
        End If
    Else
        If hardcore Then
            If Not female Then
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Sir "
                    Case 2: Title = "Lord "
                    Case 3: Title = "Baron "
                End Select
            Else
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Dame "
                    Case 2: Title = "Lady "
                    Case 3: Title = "Baroness "
                End Select
            End If
        Else
            If Not female Then
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Count "
                    Case 2: Title = "Duke "
                    Case 3: Title = "King "
                End Select
            Else
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Countess "
                    Case 2: Title = "Duchess "
                    Case 3: Title = "Queen "
                End Select
            End If
        End If
    End If
    
    ReDim Out(6)
    Out(0) = "Character: " & Title & Char
    Out(1) = "Dead: " & YesNo(dead)
    Out(2) = "Hardcore: " & YesNo(hardcore)
    Out(3) = "Ladder: " & YesNo(ladder)
    Out(4) = "Expansion: " & YesNo(Expansion)
    Out(5) = "Class: " & raceStr
    Out(6) = "Level: " & Level
    Exit Sub
hErr:
    ErrorHandler "Statstring", "GetDiablo2Info"
End Sub

Private Function GetDiablo2Stats(ByRef Statstring As String, Optional ByVal NoChar As Boolean) As String
    On Error GoTo hErr
    If Len(Statstring) = 4 Then
        GetDiablo2Stats = vbNullString
        Exit Function
    End If
    
    Dim r()
    r() = Array("Unknown", "Amazon", "Sorceress", _
        "Necromancer", "Paladin", "Barbarian", "Druid", "Assassin")
    
    Dim Race As Byte, Level As Byte, charflag As Byte, actflag As Byte
    Dim hardcore As Boolean, ladder As Boolean, dead As Boolean
    Dim female As Boolean, Expansion As Boolean
    Dim product$, server$, Char$, raceStr$, Title$
    If Not NoChar Then
        product$ = Left$(Statstring, 4)
        Statstring = Mid$(Statstring, 5)
        server$ = Left$(Statstring, InStr(Statstring, ",") - 1)
        Statstring = Mid$(Statstring, Len(server) + 2)
        Char$ = Left$(Statstring, InStr(Statstring, ",") - 1)
        Statstring = Mid$(Statstring, Len(Char) + 2)
    End If
    
    If Len(Statstring) <> 33 Then
        GetDiablo2Stats = vbNullString
        Exit Function
    End If
    
    Race = CByte(Asc(Mid$(Statstring, 14, 1)))
    Level = CByte(Asc(Mid$(Statstring, 26, 1)))
    charflag = CByte(Asc(Mid$(Statstring, 27, 1)))
    actflag = CByte(Asc(Mid$(Statstring, 28, 1)))
    hardcore = CBool((charflag And &H4) = &H4)
    ladder = CBool(Asc(Mid$(Statstring, 31, 1)) < &HFF)
    
    If hardcore Then dead = CBool((charflag And &H8) = &H8)
    
    If Race > 7 Or Race < 1 Then Race = 0
    If Race = 1 Or Race = 2 Or Race = 7 Then female = True
    raceStr = r(Race)
    
    If product = "PX2D" Then
        If charflag And &H20 Then
            Expansion = True
            If hardcore Then
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Destroyer "
                    Case 2: Title = "Conqueror "
                    Case 3: Title = "Guardian "
                End Select
            Else
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Slayer "
                    Case 2: Title = "Champion "
                    Case 3: Title = IIf(female, "P", "M") & "atriarch "
                End Select
            End If
        End If
    Else
        If hardcore Then
            If Not female Then
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Sir "
                    Case 2: Title = "Lord "
                    Case 3: Title = "Baron "
                End Select
            Else
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Dame "
                    Case 2: Title = "Lady "
                    Case 3: Title = "Baroness "
                End Select
            End If
        Else
            If Not female Then
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Count "
                    Case 2: Title = "Duke "
                    Case 3: Title = "King "
                End Select
            Else
                Select Case RShift(actflag And &H18, 3)
                    Case 1: Title = "Countess "
                    Case 2: Title = "Duchess "
                    Case 3: Title = "Queen "
                End Select
            End If
        End If
    End If
    
    GetDiablo2Stats = IIf(NoChar, "", Title & Char & ", ") & IIf(dead, "dead ", vbNullString) & _
        IIf(hardcore, "hardcore ", vbNullString) & IIf(ladder, "ladder ", vbNullString) & _
        IIf(Expansion, "exp ", vbNullString) & _
        raceStr & " (level " & Level & ")" ' & " on realm " & server
    Exit Function
hErr:
    ErrorHandler "Statstring", "GetDiablo2Stats"
End Function

Private Function LShift(ByVal pnValue As Long, ByVal pnShift As Long) As Double:
    LShift = CDbl(pnValue * (2 ^ pnShift))
End Function

Private Function RShift(ByVal pnValue As Long, ByVal pnShift As Long) As Double
    RShift = CDbl(pnValue \ (2 ^ pnShift))
End Function



