VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsMedia"
Attribute VB_GlobalNameSpace = True
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Private Declare Function GetWindowText Lib "user32" Alias "GetWindowTextA" (ByVal hwnd As Long, ByVal lpString As String, ByVal cch As Long) As Long
Private Declare Function GetWindow Lib "user32" (ByVal hwnd As Long, _
  ByVal wCmd As Long) As Long

'To use with SendMessage()
Private Const WM_KEYDOWN = &H100
Private Const WM_KEYUP = &H101
Private Const WM_CHAR = &H102
Private Const MK_LBUTTON = &H1

'To use with keybd_event()
Private Const KEYEVENTF_KEYDOWN = &H0
Private Const KEYEVENTF_EXTENDEDKEY = &H1
Private Const KEYEVENTF_KEYUP = &H2

Private mMediaPlayer As MEDIAPLAYERS
Public CurrentTrack As String
Public Enum MEDIAPLAYERS
    None& = 0
    iTunes& = 1
    Foobar& = 2
    Winamp& = 3
    WindowsMediaPlayer& = 4
    Lastfm& = 5
    Kb& = 6
End Enum

Public Property Let MediaPlayer(value As MEDIAPLAYERS)
    mMediaPlayer = value
    If value = iTunes Then
        If Opened Then
            Unload frmiTunes
            Load frmiTunes
        End If
    Else
        Unload frmiTunes
    End If
End Property

Public Property Get MediaPlayer() As MEDIAPLAYERS
    MediaPlayer = mMediaPlayer
End Property

Public Property Get MediaPlayerToString() As String
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        MediaPlayerToString = "foobar2000"
    Case MEDIAPLAYERS.iTunes
        MediaPlayerToString = "iTunes"
    Case MEDIAPLAYERS.Winamp
        MediaPlayerToString = "Winamp"
    Case MEDIAPLAYERS.WindowsMediaPlayer
        MediaPlayerToString = "Windows Media Player"
    Case MEDIAPLAYERS.Kb
        MediaPlayerToString = "KbMedia Player"
    Case MEDIAPLAYERS.Lastfm
        MediaPlayerToString = "Last.fm"
    Case Else
        MediaPlayerToString = "None"
    End Select
End Property

Private Function FoobarHandle() As Long
    FoobarHandle = FindWindow("{E7076D1C-A7BF-4f39-B771-BCBE88F2A2A8}", vbNullString) Or FindWindow("{DA7CD0DE-1602-45e6-89A1-C2CA151E008E}/1", vbNullString)
End Function

Private Function WinampHandle() As Long
    WinampHandle = FindWindow("Winamp v1.x", vbNullString)
End Function

Public Function LastfmHandle() As Long
    Dim tempHwnd As Long
    tempHwnd = FindWindow("QWidget", vbNullString)
    Do Until tempHwnd = 0
        Dim str As String, r As Long
        str = Space$(256)
        r = GetWindowText(tempHwnd, str, 256)
        str = Left$(str, r)
        If InStr(str, "  ") > 0 Or str = "Last.fm" Then
            LastfmHandle = tempHwnd
            Exit Do
        End If
        tempHwnd = GetWindow(tempHwnd, 2)
    Loop
    'Enumerate through the process list, when it comes to "LastFM.exe", _
     get it's pID, store it, get info, there ya go.
End Function

Private Function KbHandle() As Long
    KbHandle = FindWindow("TFrmMIDI", vbNullString)
End Function

Private Function iTunesHandle() As Long
    iTunesHandle = FindWindow("iTunes", vbNullString)
End Function

Private Function WmpHandle() As Long
    WmpHandle = FindWindow("WMPlayerApp", vbNullString)
End Function

Public Function Opened() As Boolean
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Opened = (FoobarHandle <> 0)
    Case MEDIAPLAYERS.iTunes
        Opened = (iTunesHandle <> 0)
    Case MEDIAPLAYERS.Winamp
        Opened = (WinampHandle <> 0)
    Case MEDIAPLAYERS.Kb
        Opened = (KbHandle <> 0)
    Case MEDIAPLAYERS.Lastfm
        Opened = (LastfmHandle <> 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Opened = (WmpHandle <> 0)
    End Select
End Function

Public Sub BeginPlay()
    On Error GoTo hErr:
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Call PostMessage(FoobarHandle, WM_KEYDOWN, FOOBAR_PLAY, 0)
    Case MEDIAPLAYERS.iTunes
        Dim I As New iTunesApp
        I.Play
    Case MEDIAPLAYERS.Lastfm
    
    Case MEDIAPLAYERS.Kb
        Call PostMessage(KbHandle, WM_COMMAND, KB_PLAY, 0)
    Case MEDIAPLAYERS.Winamp
        Call PostMessage(WinampHandle, WM_COMMAND, WINAMP_PLAY, 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Call PostMessage(WmpHandle, WM_COMMAND, WMP_PLAY, 0)
    End Select
    Exit Sub
hErr:
    ErrorHandler "Media", "BeginPlay"
End Sub

Public Sub StopPlay()
    On Error GoTo hErr:
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Call PostMessage(FoobarHandle, WM_KEYDOWN, FOOBAR_STOP, 0)
    Case MEDIAPLAYERS.iTunes
        Dim I As New iTunesApp
        I.Stop
    Case MEDIAPLAYERS.Kb
        Call PostMessage(KbHandle, WM_COMMAND, KB_STOP, 0)
    Case MEDIAPLAYERS.Winamp
        Call PostMessage(WinampHandle, WM_COMMAND, WINAMP_STOP, 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Call PostMessage(WmpHandle, WM_COMMAND, WMP_STOP, 0)
    End Select
    Exit Sub
hErr:
    ErrorHandler "Media", "StopPlay"
End Sub

Public Sub PausePlay()
    On Error GoTo hErr:
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Call PostMessage(FoobarHandle, WM_KEYDOWN, FOOBAR_PAUS, 0)
    Case MEDIAPLAYERS.iTunes
        Dim I As New iTunesApp
        I.Pause
    Case MEDIAPLAYERS.Kb
        Call PostMessage(KbHandle, WM_COMMAND, KB_PAUSE, 0)
    Case MEDIAPLAYERS.Winamp
        Call PostMessage(WinampHandle, WM_COMMAND, WINAMP_PAUS, 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Call PostMessage(WmpHandle, WM_COMMAND, WMP_PAUS, 0)
    End Select
    Exit Sub
hErr:
    ErrorHandler "Media", "PausePlay"
End Sub

Public Sub NextTrack()
    On Error GoTo hErr:
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Call PostMessage(FoobarHandle, WM_KEYDOWN, FOOBAR_NEXT, 0)
    Case MEDIAPLAYERS.iTunes
        Dim I As New iTunesApp
        I.NextTrack
    Case MEDIAPLAYERS.Kb
        Call PostMessage(KbHandle, WM_COMMAND, KB_NEXT, 0)
    Case MEDIAPLAYERS.Winamp
        Call PostMessage(WinampHandle, WM_COMMAND, WINAMP_NEXT, 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Call PostMessage(WmpHandle, WM_COMMAND, WMP_NEXT, 0)
    End Select
    Exit Sub
hErr:
    ErrorHandler "Media", "NextTrack"
End Sub

Public Sub PreviousTrack()
    On Error GoTo hErr:
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Call PostMessage(FoobarHandle, WM_KEYDOWN, FOOBAR_PREV, 0)
    Case MEDIAPLAYERS.iTunes
        Dim I As New iTunesApp
        I.BackTrack
    Case MEDIAPLAYERS.Kb
        Call PostMessage(KbHandle, WM_COMMAND, KB_PREV, 0)
    Case MEDIAPLAYERS.Winamp
        Call PostMessage(WinampHandle, WM_COMMAND, WINAMP_PREV, 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Call PostMessage(WmpHandle, WM_COMMAND, WMP_PREV, 0)
    End Select
    Exit Sub
hErr:
    ErrorHandler "Media", "PreviousTrack"
End Sub

Private Function GetTitle(Handle As Long) As String
    Dim bufLen As Long, buf As String
    bufLen = SendMessage(Handle, &HE, &H0, ByVal &H0)
    buf = String$(bufLen, 0)
    SendMessage Handle, &HD, bufLen + 1, ByVal buf
    buf = Replace$(buf, "_", Space$(1))
    buf = Replace$(buf, "&", "&&")
    buf = Replace$(buf, Space$(2), Space$(1))
    If InStrB(buf, "[foobar") > 0 Then buf = Left$(buf, InStr(buf, "[foobar") - 1)
    If InStrB(buf, " - Windows Media Player") > 0 Then buf = Left$(buf, InStr(buf, " - Windows Media Player") - 1)
    If InStrB(buf, " - Winamp") > 0 Then buf = Left$(buf, InStr(buf, " - Winamp") - 1)
    GetTitle = buf
End Function

Public Function Track() As String
    If Not Opened Then
        Track = MediaPlayerToString & " | " & "Not running!"
        Exit Function
    End If
    
    On Error GoTo hErr:
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Track = GetTitle(FoobarHandle)
    Case MEDIAPLAYERS.iTunes
        Track = CurrentTrack
    Case MEDIAPLAYERS.Winamp
        Track = GetTitle(WinampHandle)
    Case MEDIAPLAYERS.Lastfm
        Track = GetTitle(LastfmHandle)
    Case MEDIAPLAYERS.Kb
        Track = GetTitle(KbHandle)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Track = GetTitle(WmpHandle)
    End Select
    
hErr:
    If Track = "Windows Media Player" Then Track = "Blogging plugin not running or playback has not started!"
    If Track Like "foobar2000*" Then Track = "Not playing!"
    If Len(Track) = 0 Then Track = "Not playing!"
    If Track = "- KbMedia Player -" Then Track = "Not playing!"
    Track = Replace$(Track, " - KbMedia Player -", vbNullString)
    Track = Replace$(Track, "", "-")
    Track = Trim$(Track)
    If Track = "Last.fm" Then Track = "Not playing!"
    If Left$(Track, 1) = "[" And Right(Track, 1) = "]" Then Track = Mid$(Track, 2, Len(Track) - 2)
    Track = MediaPlayerToString & " | " & Track
End Function
