VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDatabase"
Attribute VB_GlobalNameSpace = True
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Dim fso As New FileSystemObject
Dim strFile As String
Dim Members() As String

Private Const MINIMUM As Integer = 1
Private Const MAXIMUM As Integer = 200

Public Property Let FilePath(Path As String)
    strFile = Path
    If (Not fso.FileExists(Path)) Then fso.CreateTextFile Path, True
    LoadMembers
End Property

Public Property Get FilePath() As String
    FilePath = strFile
End Property

Private Sub LoadMembers()
    On Error GoTo hErr
    ReDim Members(0)
    Dim ts As TextStream, strContent As String, strSplt() As String, I As Integer
    Set ts = fso.OpenTextFile(strFile, ForReading)
    If ts.AtEndOfStream = False Then
        strContent = ts.ReadAll
        strSplt() = Split(strContent, vbNewLine)
        ts.Close
        For I = 0 To UBound(strSplt())
            If (InStrB(strSplt(I), Space$(1)) > 0) Then
                Dim strMember() As String
                strMember() = Split(strSplt(I), Space$(1))
                If (Val(strMember(1)) = strMember(1)) And (LenB(strMember(0)) > 0) Then
                    If (LenB(Members(0)) = 0) Then
                        Members(0) = strMember(0) & Space$(1) & strMember(1)
                    Else
                        ReDim Preserve Members(UBound(Members) + 1)
                        Members(UBound(Members)) = strMember(0) & Space$(1) & strMember(1)
                    End If
                End If
            End If
        Next I
    End If
    Exit Sub
hErr:
    ErrorHandler "Database", "LoadMembers"
End Sub

Private Sub SaveMembers()
    On Error GoTo hErr
    Dim ts As TextStream, I As Integer
    Set ts = fso.OpenTextFile(strFile, ForWriting)
    For I = 0 To UBound(Members())
        Call ts.WriteLine(Members(I))
    Next I
    ts.Close
    Exit Sub
hErr:
    ErrorHandler "Database", "SaveMembers"
End Sub

Public Function AddMember(Username As String, Rank As Integer) As Boolean
    On Error GoTo hErr
    If (FindMember(Username) = -1) Then
        If (Rank >= MINIMUM And Rank < MAXIMUM) Then
            If (LenB(Members(0)) = 0) Then
                Members(0) = Username & Space$(1) & Rank
            Else
                ReDim Preserve Members(UBound(Members()) + 1)
                Members(UBound(Members)) = Username & Space$(1) & Rank
            End If
            AddMember = True
        End If
    End If
    SaveMembers
    Exit Function
hErr:
    ErrorHandler "Database", "AddMember"
End Function

Public Function FindMember(Username As String) As Integer
    On Error GoTo hErr
    Dim I As Integer
    For I = 0 To UBound(Members())
        If InStrB(Members(I), Space$(1)) > 0 Then
            Dim strMember() As String
            strMember = Split(Members(I), Space$(1))
            If LCase$(strMember(0)) = LCase$(Username) Then
                FindMember = I
                Exit Function
            End If
        End If
    Next I
    FindMember = -1
    Exit Function
hErr:
    ErrorHandler "Database", "FindMember"
End Function

Public Function GetRankByIndex(index As Integer) As Integer
    On Error GoTo hErr
    If (index < LBound(Members) Or index > UBound(Members)) Then
        GetRankByIndex = -1
    Else
        If (InStrB(Members(index), Space$(1)) > 0) Then
            Dim strMember() As String
            strMember = Split(Members(index), Space$(1))
            GetRankByIndex = Val(strMember(1))
        Else
            GetRankByIndex = -1
        End If
    End If
    Exit Function
hErr:
    ErrorHandler "Database", "GetRankByIndex"
End Function

Public Function GetRankByMemberName(Username As String) As Integer
    On Error GoTo hErr
    Dim index As Integer
    index = FindMember(Username)
    If (index > -1) Then
        GetRankByMemberName = GetRankByIndex(index)
    End If
    Exit Function
hErr:
    ErrorHandler "Database", "GetRankByMemberName"
End Function

Public Function RemoveMember(Username As String) As Boolean
    On Error GoTo hErr
    Dim I As Integer
    For I = 0 To UBound(Members())
        If InStrB(Members(I), Space$(1)) > 0 Then
            Dim strMember() As String
            strMember = Split(Members(I), Space$(1))
            If LCase$(strMember(0)) = LCase$(Username) Then
                Dim r As Integer
                For r = I To UBound(Members()) - 1
                    Members(r) = Members(r + 1)
                Next r
                ReDim Preserve Members(UBound(Members) - 1)
                RemoveMember = True
                SaveMembers
                Exit Function
            End If
        End If
    Next I
    RemoveMember = False
    Exit Function
hErr:
    ErrorHandler "Database", "RemoveMember"
End Function

Public Function SearchMembers(ByVal Wildcard As String) As String()
    On Error GoTo hErr
    Dim I As Integer, tmp() As String
    ReDim tmp(0)
    For I = 0 To UBound(Members())
        If (InStrB(Members(I), Space$(1)) > 0) Then
            Dim strMember() As String
            strMember = Split(Members(I), Space$(1))
            Wildcard = PrepareCompare(Wildcard)
            If LCase$(strMember(0)) Like LCase$(Wildcard) Then
                If (LenB(tmp(0)) = 0) Then
                    tmp(0) = strMember(0)
                Else
                    ReDim Preserve tmp(UBound(tmp) + 1)
                    tmp(UBound(tmp)) = strMember(0)
                End If
            End If
        End If
    Next I
    SearchMembers = tmp
    Exit Function
hErr:
    ErrorHandler "Database", "SearchMembers"
End Function

Private Function PrepareCompare(ByVal Wildcard As String) As String
    Wildcard = Replace$(Wildcard, "[", "")
    Wildcard = Replace$(Wildcard, "]", "")
    Wildcard = Replace$(Wildcard, "", "[[]")
    Wildcard = Replace$(Wildcard, "", "[]]")
    Wildcard = Replace$(Wildcard, "#", "[#]")
    Wildcard = Replace$(Wildcard, "-", "[-]")
    PrepareCompare = Wildcard
End Function
