Attribute VB_Name = "UI_Load"
'///////////////////////////////////////
' MirageChat v2* Created by DDA-TriCk-E
' Source Release Date: 4th April 2006
'///////////////////////////////////////
Option Explicit
Public Const CL_UNKNOWN$ = vbNullString
Public Const CL_INUSE$ = "*"
Public Const CL_MUTED$ = "**"
Public Const CL_VOID$ = "***"
Public Const CL_WORKING$ = "****"
Public Const CL_BANNED$ = "x"
Public Const CL_WRONG$ = "xx"
Public Const CL_INVALID$ = "xxx"

Public Groups() As String, Cdkeys() As String, Proxies() As String, Accounts() As String
    
    Public Sub CreateTabs()
        Dim ct As cTab
        Set ct = frmMain.tbsRight.Tabs.Add("USERS", , "Users")
        Set ct.Panel = frmMain.picChannel
        ct.ToolTipText = "Channel Users"
        
        Set ct = frmMain.tbsRight.Tabs.Add("FRIENDS", , "Friends")
        Set ct.Panel = frmMain.picFriends
        ct.ToolTipText = "Friends Listing"
        
        Set ct = frmMain.tbsRight.Tabs.Add("CLAN", , "Clan")
        Set ct.Panel = frmMain.picClan
        ct.ToolTipText = "Clan Listing"
        
        Set ct = frmMain.tbsRight.Tabs.Add("MIRAGE", , "MirageNet")
        Set ct.Panel = frmMain.picMirage
        ct.ToolTipText = "MirageNet Server"
    End Sub
    
    Public Sub LoadUserGroups()
        ReDim Groups(0)
        Dim iLoop As Integer, sLine As String, iFile As Integer, bBracket As Boolean
        For iLoop = frmMain.mnuGroups.UBound To 1 Step -1
            Unload frmMain.mnuGroups(iLoop)
        Next
        Load frmMain.mnuGroups(frmMain.mnuGroups.UBound + 1)
        frmMain.mnuGroups(frmMain.mnuGroups.UBound).Caption = "None"
        iFile = FreeFile
        
        Open PrefPath For Input As #iFile
            Do Until EOF(iFile)
                Line Input #iFile, sLine
                If (sLine Like "[[]*[]]") Then
                    bBracket = (LCase$(sLine) = "[groups]")
                ElseIf (sLine Like "*=*") Then
                    If (bBracket = True) Then
                        ReDim Preserve Groups(UBound(Groups) + 1)
                        Groups(UBound(Groups)) = sLine
                        Load frmMain.mnuGroups(frmMain.mnuGroups.UBound + 1)
                        frmMain.mnuGroups(frmMain.mnuGroups.UBound).Caption = Split(sLine, "=")(0)
                    End If
                End If
            Loop
        Close #iFile
        If Active > 0 Then
            If Profiles(Active).Online = True Then DisplayList Channel, Active
        End If
    End Sub
    
    Public Sub LoadFonts()
        With frmMain
            Dim iLoop As Integer
            For iLoop = 1 To Screen.FontCount - 1
                Load .mnuFont(iLoop)
                Load .mnuFont2(iLoop)
                .mnuFont(iLoop).Caption = Screen.Fonts(iLoop)
                .mnuFont2(iLoop).Caption = Screen.Fonts(iLoop)
            Next iLoop
            .mnuFont(0).Visible = False
            .mnuFont2(0).Visible = False
        End With
    End Sub

    Public Sub LoadProfiles()
        Dim Files() As String, X As Integer
        ReDim Files(0)
        Files() = FileList(App.Path & "\Profiles\*.ini")
        
        For X = -frmMain.mnuProfiles.UBound To -1
            Unload frmMain.mnuProfiles(Abs(X))
        Next X
        
        Dim C As Integer
        For X = 0 To UBound(Files())
            If Len(Files(X)) > 0 Then
                C = frmMain.mnuProfiles.UBound + 1
                Load frmMain.mnuProfiles(C)
                
                Dim ProfileName As String, Client As String * 4, Server As String, Channel As String
                ProfileName = Left$(Files(X), InStrRev(Files(X), ".") - 1)
                Client = GetINI(App.Path & "\Profiles\" & Files(X), "Config", "ProductID")
                Channel = GetINI(App.Path & "\Profiles\" & Files(X), "Config", "Channel")
                Server = getServerName(GetINI(App.Path & "\Profiles\" & Files(X), "Config", "Server"))
                
                frmMain.mnuProfiles(C).Caption = Client & "   |   " & ProfileName & vbTab & Server & "   |   " & Channel
                frmMain.mnuProfiles(C).Tag = App.Path & "\Profiles\" & Files(X)
            End If
        Next X
    End Sub

    Public Sub LoadProxies()
        Dim sFile As String, iBound As Integer, sLine As String, iFile As Integer
        Dim sSplt() As String
        ReDim Proxies(0)
        iFile = FreeFile
        sFile = App.Path & "\Proxies.db"
        
        Open sFile For Append As #iFile: Close #iFile
        Open sFile For Input As #iFile
            Do Until EOF(iFile)
                Line Input #iFile, sLine
                sSplt() = Split(sLine, Space$(1))
                If UBound(sSplt) = 2 Then
                    iBound = UBound(Proxies) + 1
                    ReDim Preserve Proxies(iBound)
                    Proxies(iBound) = sLine
                End If
            Loop
        Close #iFile
        Erase sSplt()
        DisplayProxies
    End Sub

    Public Sub LoadProfile(ByVal ProfilePath As String, Optional ByVal DontLoad As Boolean = False)
        Dim iFile As Integer, sFile As String, iFind As Integer, _
            iTagVal As Integer, iFound As Integer
            
            iFile = FreeFile
            sFile = ProfilePath
            Open sFile For Append As #iFile: Close #iFile
                
            With frmMain.tbsProfiles.Tabs
                For iFind = .Count To 1 Step -1
                    iTagVal = Val(.Item(iFind).Tag)
                    If (iTagVal > 0) Then
                        If (Profiles(iTagVal).ProfilePath = ProfilePath) Then
                            If MsgBox("Profile is already loaded, this profile will be reloaded.", vbQuestion + vbOKCancel, "Already Loaded!") = vbCancel Then Exit Sub
                            iFound = iTagVal
                            Exit For
                        End If
                    End If
                Next iFind
            End With
            
        Dim iProfile As Integer, iObject As Integer, iControl As Integer

        If (iFound > 0) Then
            iProfile = iFound
            iObject = Profiles(iFound).PacketIndex
            iControl = Profiles(iFound).CtrlIndex
        Else
            If (DontLoad = True) Then Exit Sub
            
            iProfile = (UBound(Profiles) + 1)
            iObject = (UBound(Connection) + 1)
            ReDim Preserve Profiles(iProfile), Connection(iObject), _
                Packet(iObject), lUsers(iObject), _
                lFriends(iObject), lClan(iObject)
                
            ReDim Profiles(iProfile).HyperLinks(0)
            
            With frmMain
                iControl = (.wsBnet.UBound + 1)
                Load .wsBnet(iControl)
                Load .wsMCP(iControl)
                Load .rtbMain(iControl)
                
                .wsBnet(iControl).Tag = iObject
                .rtbMain(iControl).Visible = True
                .rtbMain(iControl).Text = vbNullString
            End With
            
            lClan(iObject).Clear
            lUsers(iObject).Clear
            lFriends(iObject).Clear
            
            With Connection(iObject)
                .CtrlIndex = iControl
                .ProfileIndex = iProfile
                .Index = iObject
            End With
        
            With Packet(iObject)
                .CtrlIndex = iControl
                .ProfileIndex = iProfile
                .Index = iObject
            End With
        
            With Profiles(iProfile)
                .CtrlIndex = iControl
                .ProfileIndex = iProfile
                .PacketIndex = iObject
                .ProfilePath = sFile
                .ProfileName = Mid$(.ProfilePath, InStrRev(.ProfilePath, "\") + 1)
                .ProfileName = Left$(.ProfileName, InStrRev(.ProfileName, ".") - 1)
            End With
            
            frmMain.tbsProfiles.Tabs.Add(, , Profiles(iProfile).ProfileName, 0).Tag = iProfile
        End If
        
        With Profiles(iProfile)
            .MyLastEvent = GetTickCount()
            
            .Username = GetINI(ProfilePath, "Config", "Username")
            .Password = GetINI(ProfilePath, "Config", "Password")
            .Password2 = GetINI(ProfilePath, "Config", "Password2")
            .Master = GetINI(ProfilePath, "Config", "Master")
            .Trigger = GetINI(ProfilePath, "Config", "Trigger")
            .Channel = GetINI(ProfilePath, "Config", "Channel")
            .Server = GetINI(ProfilePath, "Config", "Server")
            .Email = GetINI(ProfilePath, "Config", "Email")
            .Email2 = GetINI(ProfilePath, "Config", "Email2")
            .ProductID = GetINI(ProfilePath, "Config", "ProductID")
            .ProductByte = Val("&H0" & GetINI(PrefPath, "Verbytes", .ProductID))
            .HashPath = Replace(GetINI(PrefPath, "Hashes", .ProductID), "$PATH", App.Path)
            .Ping = Val(GetINI(ProfilePath, "Config", "Ping"))
            .LoginType = UCase$(GetINI(ProfilePath, "Config", "LoginType"))
            .LoginType = IIf(Len(.LoginType) = 0, "NORMAL", .LoginType)
            
            Dim sCdkeys() As String
            ReDim sCdkeys(1), .ChannelsLocal(0), .ChannelsRemote(0)
            
            Select Case UCase$(.ProductID)
                Case "D2XP": sCdkeys(0) = "D2DV": sCdkeys(1) = "D2XP"
                Case "W3XP": sCdkeys(0) = "WAR3": sCdkeys(1) = "W3XP"
                Case Else: ReDim sCdkeys(0): sCdkeys(0) = .ProductID
            End Select
            
            .Cdkey1 = GetINI(ProfilePath, "Cdkey", sCdkeys(0))
                If (UBound(sCdkeys) = 1) Then
                    .Cdkey2 = GetINI(.ProfilePath, "Cdkey", sCdkeys(1))
                Else
                    .Cdkey2 = vbNullString
                End If
            Erase sCdkeys()
            
            .CdkeyStatus = "Unknown"
            .CdkeyStatusIndicator = 0
            .Plug = CBool(Val(GetINI(.ProfilePath, "Config", "Plug")))
            Funct.AddChat iControl, vbGreen, "Profile " & .ProfileName & " loaded!"
            
            LoadChannels iProfile
            
            If (Val(GetINI(.ProfilePath, "Settings", "AutoConnect")) = 1) And _
                (.Online = False) Then Connection(iObject).Connect
            
            If Active = 0 Then Active = iProfile
        End With
        frmMain.Form_Resize
        frmMain.RefreshTabs
        
        On Error GoTo setfont:
            
        Dim iSize1 As Integer, iSize2 As Integer
        iSize1 = Val(GetINI(PrefPath, "Settings", "ChatFontSize"))
        iSize2 = Val(GetINI(PrefPath, "Settings", "ListFontSize"))
        
        If iSize1 > 0 Then frmMain.mnuSize_Click iSize1 - 1
        If iSize2 > 0 Then frmMain.mnuSize2_Click iSize2 - 1
        
        frmMain.ChangeChatFont GetINI(PrefPath, "Settings", "ChatFont")
        frmMain.ChangeListFont GetINI(PrefPath, "Settings", "ListFont")
        Exit Sub
setfont:
        frmMain.ChangeChatFont "Verdana"
        frmMain.ChangeListFont "Verdana"
    End Sub
    
    Public Sub LoadCdkeys()
        Dim iUnload As Integer, sFile As String, iFile As Integer, _
            sLine As String, bBracket As Boolean
        sFile = StatPath
        iFile = FreeFile
        
        For iUnload = frmMain.mnuCdkeys.UBound To 1 Step -1
            Unload frmMain.mnuCdkeys(iUnload)
        Next iUnload
        
        Open sFile For Input As #iFile
            Do Until EOF(iFile)
                Line Input #iFile, sLine
                If sLine Like "[[]*[]]" Then
                    If sLine = "[Cdkeys]" Then bBracket = True Else bBracket = False
                ElseIf sLine Like "*=*" Then
                    If bBracket = True Then
                        If sLine Like "* * *" Then
                            Dim sSplt() As String, sCdkey As String
                            sCdkey = Split(sLine, "=")(0)
                            sSplt() = Split(Split(sLine, "=")(1), " ")
                            With frmMain
                                Load .mnuCdkeys(.mnuCdkeys.UBound + 1)
                                .mnuCdkeys(.mnuCdkeys.UBound).Caption = sSplt(2) & "  |  " & sCdkey & vbTab & sSplt(1)
                            End With
                            Erase sSplt()
                        End If
                    End If
                End If
            Loop
        Close #1
    End Sub
    
    Public Sub LoadChannels(ByVal ProfileIndex As Integer)
        ReDim Profiles(ProfileIndex).ChannelsLocal(0)
        Dim sFile As String, iFile As Integer, sLine As String, sName As String
        sFile = App.Path & "\Channels.db"
        iFile = FreeFile
        sName = getServerName(Profiles(ProfileIndex).Server, False)
        
        Open sFile For Append As #iFile: Close #iFile
        Open sFile For Input As #iFile
            Do Until EOF(iFile)
                Dim Splt() As String
                Line Input #iFile, sLine
                If InStr(sLine, Chr(11)) > 0 Then
                    Splt() = Split(sLine, Chr(11))
                    If LCase$(Splt(1)) = LCase$(sName) Then
                        ReDim Preserve Profiles(ProfileIndex).ChannelsLocal(UBound(Profiles(ProfileIndex).ChannelsLocal) + 1)
                        Profiles(ProfileIndex).ChannelsLocal(UBound(Profiles(ProfileIndex).ChannelsLocal)) = Splt(0)
                    End If
                End If
                Erase Splt()
            Loop
        Close #iFile
    End Sub
    
    Public Function GetRndLine(ByVal File As String) As String
        Dim iFile As Integer, sFile As String, lCount As Long, lRandom As Long, sArray() As String
        iFile = FreeFile
        sFile = File
        
        Open sFile For Append As #iFile: Close #iFile
        Open sFile For Input As #iFile
            sArray = Split(Input(LOF(iFile), #iFile), vbLf)
            lCount = UBound(sArray)
GetRandom:
            Randomize Timer
            lRandom = IIf(lCount > 0, Int(Rnd * lCount), -1)
            If (lRandom > -1) Then
                If (Len(sArray(lRandom)) > 0) Then
                    GetRndLine = sArray(lRandom)
                Else
                    GoTo GetRandom:
                End If
            Else
                GetRndLine = "Unable to get a line from " & Chr(34) & Mid(sFile, InStrRev(sFile, "\")) & Chr(34)
            End If
        Close #iFile
    End Function
