Attribute VB_Name = "RT_WinampRemoteToLocal"
Option Explicit

Private Declare Function FindWindow Lib "user32" Alias "FindWindowA" _
    (ByVal lpszClassName As String, ByVal lpszWindowName As String) _
    As Long
Private Declare Function GetWindowThreadProcessId Lib "user32" _
    (ByVal hWnd As Long, ByRef lpdwProcessId As Long) As Long
Private Declare Function OpenProcess Lib "kernel32" _
    (ByVal dwDesiredAccess As Long, ByVal bInheritHandle As Long, _
    ByVal dwProcessId As Long) As Long
Private Const PROCESS_VM_READ As Long = &H10
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" _
    (ByVal hWnd As Long, ByVal Msg As Long, ByVal wParam As Long, _
    ByVal lParam As Long) As Long
Private Const WM_USER As Long = &H400
Private Const IPC_GETPLAYLISTFILE As Long = 211
Private Const IPC_GETLISTPOS As Long = 125
Private Declare Function ReadProcessMemory Lib "kernel32" _
    (ByVal hProcess As Long, ByVal lpBaseAddress As Long, _
    ByRef lpBuffer As Any, ByVal nSize As Long, _
    ByRef lpNumberOfBytesRead As Long) As Long
Private Declare Function CloseHandle Lib "kernel32" _
    (ByVal hObject As Long) As Long
Private Const MAX_PATH As Long = 260
Private hWndWinamp As Long

Private Function GetWinampWindow() As Long
    GetWinampWindow = FindWindow("Winamp v1.x", vbNullString)
End Function
Public Function GetPlayingFileName() As String
    Dim strFileName As String
    Dim lp As Long, lpWinamp As Long
    Dim iIndex As Long
    Dim PID As Long
    Dim bRet As Long
    Dim dwRead As Long
    Dim Buffer(MAX_PATH) As Byte
    Dim Temp As String

    hWndWinamp = GetWinampWindow
    If hWndWinamp = 0 Then
      GetPlayingFileName = ""
      Exit Function
    End If
    
    iIndex = SendMessage(hWndWinamp, WM_USER, 0, IPC_GETLISTPOS)
    lp = SendMessage(hWndWinamp, WM_USER, iIndex, IPC_GETPLAYLISTFILE)
    If lp = 0 Then
        GetPlayingFileName = ""
        Exit Function
    End If
    Call GetWindowThreadProcessId(hWndWinamp, PID)
    lpWinamp = OpenProcess(PROCESS_VM_READ, 0, PID)
    If lpWinamp = 0 Then
        GetPlayingFileName = ""
        Exit Function
    End If
    bRet = ReadProcessMemory(lpWinamp, lp, Buffer(0), MAX_PATH, dwRead)
    Call CloseHandle(lpWinamp)
    
    Temp = StrConv(Buffer, vbUnicode)
    strFileName = Left$(Temp, InStr(Temp, Chr$(0)) - 1)

    GetPlayingFileName = strFileName
    
End Function
