Attribute VB_Name = "RT_Statstring"
'///////////////////////////////////////
' MirageChat v2* Created by DDA-TriCk-E
' Source Release Date: 4th April 2006
'///////////////////////////////////////
    Option Explicit
    
    Public Function GetServer(ByVal Statstring As String, ByRef Server As String) As Byte
        Server = Mid$(Statstring, 5, InStr(5, Statstring, ",") - 5)
        GetServer = InStr(5, Statstring, ",") + 1
    End Function
    
    Public Function GetCharacterName(ByVal Statstring As String, ByVal start As Byte, ByRef cName As String) As Byte
        cName = Mid$(Statstring, start, InStr(start, Statstring, ",") - start)
        GetCharacterName = InStr(start, Statstring, ",") + 1
    End Function
    
    Public Sub makeArray(ByVal Text As String, ByRef nArray() As String)
        Dim I As Long
        ReDim nArray(0)
        For I = 0 To Len(Text)
            nArray(I) = Mid$(Text, I + 1, 1)
            If I <> Len(Text) Then
                ReDim Preserve nArray(0 To UBound(nArray) + 1)
            End If
        Next I
    End Sub
    
    Public Function LShift(ByVal pnValue As Long, ByVal pnShift As Long) As Double:
        LShift = CDbl(pnValue * (2 ^ pnShift))
    End Function
    
    Public Function RShift(ByVal pnValue As Long, ByVal pnShift As Long) As Double
        RShift = CDbl(pnValue \ (2 ^ pnShift))
    End Function
    
    Public Function GetClientStats(sStatsing As String) As String
        Dim sProductID As String, sClient As String
        Dim sClass As String, sDiablo As String
        Dim sChar As String, sCharInfo As String, sClan As String
        Dim sValues() As String
        sProductID = StrReverse(Left$(sStatsing, 4))
        
        sClient = GetINI(CharPath, "Long_Client", sProductID)
        If Len(sClient) = 0 Then sClient = GetINI(CharPath, "Long_Client", "ELSE")
        
        Select Case sProductID
            Case "STAR", "SSHR", "SEXP", "JSTR", "W2BN"
                sValues() = Split(sStatsing, " ")
                If UBound(sValues()) > 0 Then
                    GetClientStats = "Client Details: " & vbNewLine & _
                        " Client: " & sClient & vbNewLine & _
                        " Ladder Rank: #" & sValues(2) & vbNewLine & _
                        " Ladder Rating: " & sValues(1) & vbNewLine & _
                        " Wins: " & sValues(3)
                    Exit Function
                Else
                    GetClientStats = "Client Details: " & vbNewLine & " Client: " & sClient
                End If
            Case "D2DV", "D2XP"
                If Len(sStatsing) = 4 Then
                    GetClientStats = "Client Details: " & vbNewLine & _
                        " Client: " & sClient & vbNewLine & _
                        " Character: <Open>"
                    Exit Function
                Else
                    Dim sServer As String, sCharClass As String, lngLen As Long
                    Dim bCharClass As Byte, bCharLevel As Byte, bHardCore As Byte, bDead As Byte, bFemale As Boolean
                    Dim sBuf As String, Expansion As Boolean, sPrefix As String
                    
                    lngLen = GetServer(sStatsing, sServer)
                    lngLen = GetCharacterName(sStatsing, lngLen, sChar)
                    Call makeArray(Mid$(sStatsing, lngLen), sValues())
                    
                    bCharClass = AscW(sValues(13)) - 1
                    If (bCharClass < 0) Or (bCharClass > 7) Then bCharClass = 7
                    If (bCharClass = 0) Or (bCharClass = 1) Or (bCharClass = 6) Then bFemale = True Else bFemale = False
                    bCharLevel = AscW(sValues(25))
                    bHardCore = AscW(sValues(26)) And 4
                    
                    sCharClass = GetINI(CharPath, "D2DV_Char", bCharClass & "")
                    If Len(sCharClass) = 0 Then sCharClass = GetINI(CharPath, "D2DV_Char", "ELSE")
    
                    If (sProductID = "D2XP") Then
                        If (AscW(sValues(26)) And &H20) Then
                            sBuf = RShift((AscW(sValues(27)) And &H18), 3)
                            If bFemale Then sBuf = sBuf & "F"
                            If bHardCore Then sBuf = sBuf & "H"
                            sPrefix = GetINI(CharPath, "D2XP_Prefix", sBuf)
                            Expansion = True
                        End If
                    End If
                    
                    If Not Expansion Then
                        sBuf = RShift((AscW(sValues(27)) And &H18), 3)
                        If bFemale Then sBuf = sBuf & "F" Else sBuf = sBuf & "M"
                        If bHardCore Then sBuf = sBuf & "H"
                        sPrefix = GetINI(CharPath, "D2DV_Prefix", sBuf)
                    End If
                    
                    If bHardCore Then
                        If (AscW(sValues(26)) And &H8) Then sPrefix = "Dead " & sPrefix
                        GetClientStats = "Client Details: " & vbNewLine & _
                            " Client: " & sClient & vbNewLine & _
                            " Class: (Hardcore) " & sCharClass & vbNewLine & _
                            " Level: " & bCharLevel & vbNewLine & _
                            " Name: " & sPrefix & " " & sChar & vbNewLine & _
                            " Realm: " & sServer
                    Else
                        GetClientStats = "Client Details: " & vbNewLine & _
                            " Client: " & sClient & vbNewLine & _
                            " Class: " & sCharClass & vbNewLine & _
                            " Level: " & bCharLevel & vbNewLine & _
                            " Name: " & sPrefix & " " & sChar & vbNewLine & _
                            " Realm: " & sServer
                    End If
                End If
            Case "DRTL", "DSHR"
                sValues() = Split(sStatsing, " ")
                If UBound(sValues()) > 0 Then
                    sClass = GetINI(CharPath, "DRTL_Class", Val(sValues(2)) & "")
                    sDiablo = GetINI(CharPath, "DRTL_Diablo", Val(sValues(3)) & "")
                    
                    GetClientStats = "Client Details: " & vbNewLine & _
                        " Client: " & sClient & vbNewLine & _
                        " Class: " & sClass & vbNewLine & _
                        " Dexterity: " & Val(sValues(6)) & vbNewLine & _
                        " Level: " & Val(sValues(1)) & vbNewLine & _
                        " Magic: " & Val(sValues(5)) & vbNewLine & _
                        " Strength: " & Val(sValues(4)) & vbNewLine & _
                        " Vitality: " & Val(sValues(7)) & vbNewLine & _
                        " Character's Gold: " & Val(sValues(8)) & vbNewLine & _
                        " Diablo: " & sDiablo
                Else
                    GetClientStats = "Client Details: " & vbNewLine & " Client: " & sClient
                End If
    
            Case "WAR3"
                sValues() = Split(sStatsing, " ")
                    If Left$(sValues(1), 1) = "1" Then
                        sChar = GetINI(CharPath, "WAR3_Char", "1")
                        sCharInfo = GetINI(CharPath, "WAR3_CharInfo", "1")
                    Else
                        sChar = GetINI(CharPath, "WAR3_Char", Left(sValues(1), 2))
                        sCharInfo = GetINI(CharPath, "WAR3_CharInfo", Left(sValues(1), 2))
                    End If
                    
                    If UBound(sValues()) = 3 Then
                        sClan = " Clan: " & StrReverse(Split(sValues(3), Chr(&H0))(0)) & vbNewLine
                    Else
                        sClan = ""
                    End If
    
                    GetClientStats = "Client Details: " & vbNewLine & _
                        " Client: " & sClient & vbNewLine & _
                        sClan & _
                        " Character: " & sChar & vbNewLine & _
                        " Character Requirement: " & sCharInfo & vbNewLine & _
                        " Highest Level: " & sValues(2)
                    
            Case "W3XP"
                sValues() = Split(sStatsing, " ")
                    If Left$(sValues(1), 1) = "1" Then
                        sChar = GetINI(CharPath, "W3XP_Char", "1")
                        sCharInfo = GetINI(CharPath, "W3XP_CharInfo", "1")
                    Else
                        sChar = GetINI(CharPath, "W3XP_Char", Left(sValues(1), 2))
                        sCharInfo = GetINI(CharPath, "W3XP_CharInfo", Left(sValues(1), 2))
                    End If
                    
                    If UBound(sValues()) = 3 Then
                        sClan = " Clan: " & StrReverse(Split(sValues(3), Chr(&H0))(0)) & vbNewLine
                    Else
                        sClan = ""
                    End If
        
                    GetClientStats = "Client Details: " & vbNewLine & _
                        " Client: " & sClient & vbNewLine & _
                        sClan & _
                        " Character: " & sChar & vbNewLine & _
                        " Character Requirement: " & sCharInfo & vbNewLine & _
                        " Highest Level: " & sValues(2)
                    
            Case Else
                GetClientStats = "Client Details: " & vbNewLine & _
                    " Client: " & sClient
        End Select
    End Function
