Attribute VB_Name = "RT_RichTextBox"
Option Explicit

Private Type POINTAPI
    X As Long
    Y As Long
End Type

Private Const EM_CHARFROMPOS& = &HD7

Public Function RichWordOver(rch As RichTextBox, X As Single, Y As Single) As String
    On Error Resume Next
    Dim pt As POINTAPI
    Dim pos As Integer
    Dim start_pos As Integer
    Dim end_pos As Integer
    Dim ch As String
    Dim txt As String
    Dim txtlen As Double

    ' Convert the position to pixels.
    pt.X = X \ Screen.TwipsPerPixelX
    pt.Y = Y \ Screen.TwipsPerPixelY

    ' Get the character number
    pos = SendMessage(rch.hWnd, EM_CHARFROMPOS, 0&, pt)
    If pos <= 0 Then Exit Function

    ' Find the start of the word.
    txt = rch.Text
    For start_pos = pos To 1 Step -1
        ch = Mid$(rch.Text, start_pos, 1)
        '(ch >= "0" And ch <= "9") Or _
        ' Allow digits, letters, and underscores.
        If Not ( _
            (ch >= "0" And ch <= "9") Or _
            (ch >= "a" And ch <= "z") Or _
            (ch >= "A" And ch <= "Z") Or _
            ch = "_" Or ch = "$" Or ch = "`" Or ch = "$" Or ch = "@" Or _
            ch = "^" Or ch = "&" Or ch = "(" Or ch = ")" Or ch = "[" Or _
            ch = "]" Or ch = "{" Or ch = "}" Or ch = "!" Or ch = "~" Or _
            ch = "'" Or ch = "." Or ch = "-" Or ch = "|" Or ch = "+" Or _
            ch = "=" _
        ) Then Exit For
    Next start_pos
    start_pos = start_pos + 1

    ' Find the end of the word.
    txtlen = Len(txt)
    For end_pos = pos To txtlen
        ch = Mid$(txt, end_pos, 1)
        ' Allow digits, letters, and underscores.
        '(ch >= "0" And ch <= "9") Or
        If Not ( _
            (ch >= "0" And ch <= "9") Or _
            (ch >= "a" And ch <= "z") Or _
            (ch >= "A" And ch <= "Z") Or _
            ch = "_" Or ch = "$" Or ch = "`" Or ch = "$" Or ch = "@" Or _
            ch = "^" Or ch = "&" Or ch = "(" Or ch = ")" Or ch = "[" Or _
            ch = "]" Or ch = "{" Or ch = "}" Or ch = "!" Or ch = "~" Or _
            ch = "'" Or ch = "." Or ch = "-" Or ch = "|" Or ch = "+" Or _
            ch = "=" _
        ) Then Exit For
    Next end_pos
    end_pos = end_pos - 1

    If start_pos <= end_pos Then
        RichWordOver = Mid$(txt, start_pos, end_pos - start_pos + 1)
        If end_pos > start_pos Then
            Dim lngSpace As Long, lngNewline As Long
            lngSpace = InStr(end_pos - start_pos, txt, Space$(1))
            lngNewline = InStr(end_pos - start_pos, txt, vbNewLine)
            If lngNewline < lngSpace Then lngSpace = lngNewline
            
            If (LCase$(RichWordOver) Like "clan*") Then
                RichWordOver = Split(Mid$(txt, start_pos, lngSpace), vbCrLf)(0)
            ElseIf (LCase$(RichWordOver) Like "op*") Then
                RichWordOver = Split(Mid$(txt, start_pos, lngSpace), vbCrLf)(0)
            End If
        End If
    End If
End Function
