Attribute VB_Name = "RT_Functions"
'///////////////////////////////////////
' MirageChat v2* Created by DDA-TriCk-E
' Source Release Date: 4th April 2006
'///////////////////////////////////////
    Option Explicit
    
    Public Function ConvertPort(Port As String) As String
        ConvertPort = (Asc(Mid(Port, 1, 1)) * (2 ^ 8)) + Asc(Mid(Port, 2, 1))
    End Function
    
    Public Function FixPacketID(ByVal byteID As Byte) As String
        FixPacketID = IIf(Len(Hex(byteID) = 2), "0x", "0x0") & Hex(byteID)
    End Function

    Public Function KillNull(ByVal Text As String) As String
        If InStr(Text, Chr(0)) > 0 Then KillNull = Split(Text, vbNullChar)(0) Else KillNull = Text
    End Function

    Public Function ChrLoop$(ByVal Character As Byte, ByVal Length As Long)
        Dim intLoop As Integer
        For intLoop = 1 To Length Step 1
            ChrLoop$ = ChrLoop$ & Chr$(Character)
        Next
    End Function

    Public Function GetBNCSPacketName(ByVal byteID As Byte) As String
        GetBNCSPacketName = GetINI(CharPath, "BNCSPacket", CStr(Hex(byteID)))
        If Len(GetBNCSPacketName) = 0 Then GetBNCSPacketName = "UNKNOWN PACKET"
    End Function

    Public Function GetMCPPacketName(ByVal byteID As Byte) As String
        GetMCPPacketName = GetINI(CharPath, "MCPPacket", CStr(Hex(byteID)))
        If Len(GetMCPPacketName) = 0 Then GetMCPPacketName = "UNKNOWN PACKET"
    End Function

    Public Function ServerIPToChar(ByVal ServerIP As String, ByRef CharString As String) As Boolean
        Dim IP() As String
        IP() = Split(ServerIP, ".")
        If UBound(IP) = 3 Then
            CharString = Chr(IP(0)) & Chr(IP(1)) & Chr(IP(2)) & Chr(IP(3))
            ServerIPToChar = True
        Else
            ServerIPToChar = False
        End If
    End Function
    
    Public Sub LoadProfilesMenus()
        frmMain.mnuAAP(0).Visible = True
        frmMain.mnuSTP(0).Visible = True
        Dim intCount As Integer
        For intCount = frmMain.mnuAAP.UBound To 1 Step -1
            Unload frmMain.mnuAAP(intCount)
        Next
        For intCount = frmMain.mnuSTP.UBound To 1 Step -1
            Unload frmMain.mnuSTP(intCount)
        Next
    
        Dim strFiles() As String
        strFiles() = FileList(App.Path & "\Profiles\*.ini")
        
        For intCount = 0 To UBound(strFiles)
            Load frmMain.mnuAAP(intCount + 1)
            Load frmMain.mnuSTP(intCount + 1)
            frmMain.mnuAAP(intCount + 1).Caption = strFiles(intCount)
            frmMain.mnuSTP(intCount + 1).Caption = strFiles(intCount)
        Next
        
        If intCount > 0 Then
            frmMain.mnuAAP(0).Visible = False
            frmMain.mnuSTP(0).Visible = False
        End If
    End Sub
    
    Public Function TabIndex(Index As Integer) As Integer
        Dim iLoop As Integer
        For iLoop = 1 To frmMain.tbsProfiles.Tabs.Count
            If frmMain.tbsProfiles.Tabs.Item(iLoop).Tag = Index Then
                TabIndex = iLoop
                Exit Function
            End If
        Next iLoop
    End Function

    Public Function secondsToTime(ByVal lSeconds As Long) As String
        Dim Hours As String, Minutes As String, Seconds As String
        Hours = Round(lSeconds \ 3600, 0)
        Minutes = Round(lSeconds \ 60, 0)
        Seconds = Round(lSeconds Mod 60, 0)
        
        If Hours > 0 Then
            secondsToTime = Format(Hours, "0") & ":" & Format(Minutes, "00") & ":" & Format(Seconds, "00")
        Else
            secondsToTime = Format(Minutes, "0") & ":" & Format(Seconds, "00")
        End If
    End Function

    Public Function getServerName(ByVal ServerIP As String, Optional ByVal WAR3 As Boolean) As String
        Dim tmpServer As String
        Const USWEST_IP = "63.241.83.*"
        Const USEAST_IP = "63.240.202.*"
        Const ASIA_IP = "211.233.0.*"
        Const EUROPE_IP = "213.248.106.*"
        
        tmpServer = ServerIP
        
        If LCase$(ServerIP) Like USWEST_IP Then tmpServer = "USWest"
        If LCase$(ServerIP) Like "usw*" Then tmpServer = "USWest"
        If LCase$(ServerIP) Like "raynor.*" Then tmpServer = "USWest"
        If LCase$(ServerIP) Like "kerrigan.*" Then tmpServer = "USWest"
        If LCase$(ServerIP) Like USEAST_IP Then tmpServer = "USEast"
        If LCase$(ServerIP) Like "use*" Then tmpServer = "USEast"
        If LCase$(ServerIP) Like "exodus.*" Then tmpServer = "USEast"
        If LCase$(ServerIP) Like "tassadar.*" Then tmpServer = "USEast"
        If LCase$(ServerIP) Like ASIA_IP Then tmpServer = "Asia"
        If LCase$(ServerIP) Like "asia.*" Then tmpServer = "Asia"
        If LCase$(ServerIP) Like "kor*" Then tmpServer = "Asia"
        If LCase$(ServerIP) Like "fenix.*" Then tmpServer = "Asia"
        If LCase$(ServerIP) Like EUROPE_IP Then tmpServer = "Europe"
        If LCase$(ServerIP) Like "zeratul.*" Then tmpServer = "Europe"
        If LCase$(ServerIP) Like "eur*" Then tmpServer = "Europe"
        
        If WAR3 = True Then
            Select Case tmpServer
                Case "USWest": tmpServer = "Lordaeron"
                Case "USEast": tmpServer = "Azeroth"
                Case "Asia": tmpServer = "Kalimdor"
                Case "Europe": tmpServer = "Europe"
            End Select
        End If
        getServerName = tmpServer
    End Function

    Public Function version() As String
        version = "MirageChat v2.5"
    End Function
    
    Public Function ParseFileName(ByVal Name As String) As String
        Dim X As String
        X = Name
        If InStr(X, ".") > 0 Then X = Mid(X, 1, InStrRev(X, ".") - 1)
        If InStr(X, "/") > 0 Then X = Mid(X, InStrRev(X, "/") + 1)
        If InStr(X, "\") > 0 Then X = Mid(X, InStrRev(X, "\") + 1)
        X = Replace(X, ":", "")
        X = Replace(X, "?", "")
        X = Replace(X, "<", "")
        X = Replace(X, ">", "")
        X = Replace(X, "*", "")
        X = Replace(X, Chr(34), "")
        X = Replace(X, "|", "")
        ParseFileName = X & ".ini"
    End Function

' Convert 'GetTickCount()' to readable time
'------------------------------
    Public Function tickToTime(Ticks As Long, td As sTimeDisplays) As String
        Dim Days&, Hours&, Minutes&, Seconds&, Ret$
        Dim strDays$, strHours$, strMinutes$, strSeconds$
        Days = Int(Ticks / 86400000)
        Ticks = Ticks Mod 86400000
        Hours = Int(Ticks / 3600000)
        Ticks = Ticks Mod 3600000
        Minutes = Int(Ticks / 60000)
        Ticks = Ticks Mod 60000
        Seconds = Int(Ticks / 1000)
        
        If td = ddhhmmss Then
            If Days > 0 Then strDays = Days & "d "
            If Hours > 0 Then strHours = Hours & "h "
            If Minutes > 0 Then strMinutes = Minutes & "m "
            If Seconds > 0 Then strSeconds = Seconds & "s"
            Ret = strDays & strHours & strMinutes & strSeconds
            If Right(Ret, 1) = Space$(1) Then Ret = Mid$(Ret, 1, Len(Ret) - 1)
            If Len(Ret) = 0 Then Ret = "Now"
        ElseIf td = ddhhmmss_full Then
            If Days > 0 Then strDays = Days & "days, "
            If Hours > 0 Then strHours = Hours & "hours, "
            If Minutes > 0 Then strMinutes = Minutes & "minutes, "
            If Seconds > 0 Then strSeconds = Seconds & "seconds, "
            Ret = strDays & strHours & strMinutes & strSeconds
            If Right(Ret, 2) = ", " Then Ret = Mid$(Ret, 1, Len(Ret) - 2)
            If Len(Ret) = 0 Then Ret = "Now"
        End If
        
        tickToTime = Ret
    End Function

' Writes data to .ini file
'------------------------------
    Public Sub WriteINI(INIFile As String, sSection As String, sEntry As String, sString As String)
        Dim X&, sFileName$
        sFileName = INIFile
        FileCreate sFileName
        X = WritePrivateProfileString(sSection$, Space$(3) & sEntry$, sString$, sFileName$)
    End Sub
    
' Reads data from .ini file
'------------------------------
    Public Function GetINI(INIFile As String, sSection As String, sEntry As String) As String
        Dim sDefault$, sRetBuf$, iLenuf%
        Dim sValue$, sFileName$, X&
        sDefault = vbNullString
        sRetBuf = String$(256, &H0) '256 nullchar
        iLenuf = Len(sRetBuf$)
        sFileName = INIFile
        Call FileCreate(sFileName)
        X = GetPrivateProfileString(sSection$, sEntry$, sDefault$, sRetBuf$, iLenuf%, sFileName$)
        sValue$ = Left$(sRetBuf$, X)
        GetINI = sValue$
    End Function

' Creates a file
'------------------------------
    Public Sub FileCreate(strFile As String)
        On Error Resume Next
        If Len(strFile) > 0 Then
            Dim FF As Integer: FF = FreeFile
            Open strFile For Append As #FF: Close #FF
        End If
    End Sub
    
' Gets directory listing by type
'------------------------------
    Public Function FileList(Mask As String) As String()
        Dim sWkg As String
        Dim sAns() As String
        Dim lCtr As Long
        
        ReDim sAns(0) As String
        sWkg = Dir(Mask, vbNormal)
        
        Do While Len(sWkg)
        
            If sAns(0) = vbNullString Then
                sAns(0) = sWkg
            Else
                lCtr = UBound(sAns) + 1
                ReDim Preserve sAns(lCtr) As String
                sAns(lCtr) = sWkg
            End If
            sWkg = Dir
        Loop
        
        FileList = sAns
    End Function

' Convert string to hex
'------------------------------
    Public Function StringToHex(ByVal strToHex As String) As String
        Dim bIs As Boolean
        Dim strTemp As String, strReturn As String, I As Long
        For I = 1 To Len(strToHex)
            strTemp = Hex(Asc(Mid$(strToHex, I, 1)))
        If Len(strTemp) = 1 Then strTemp = "0" & strTemp
        strReturn = strReturn & Space$(1) & strTemp

        Next I
        StringToHex = strReturn
    End Function
    
    Public Function StringToHex2(ByVal strToHex As String) As String
        Dim bIs As Boolean
        Dim strTemp As String, strReturn As String, I As Long
        For I = 1 To Len(strToHex)
            strTemp = Hex(Asc(Mid$(strToHex, I, 1)))
        If Len(strTemp) = 1 Then strTemp = "0" & strTemp
        strReturn = strReturn & IIf(bIs = False, vbTab, vbNullString) & strTemp
        bIs = Not bIs
        Next I
        
        Dim strString As String
        Dim lngLen As Long: lngLen = Len(strReturn)
        Dim lngPos As Long: lngPos = 1
        If lngLen > 40 Then
            While lngLen - lngPos > 40
                strString = strString & Mid(strReturn, lngPos + 1, 40) & vbNewLine
                lngPos = lngPos + 40
            Wend
            If lngLen - lngPos > 0 Then
                strString = strString & Mid(strReturn, lngPos + 1)
            End If
        Else
            strString = Mid(strReturn, 2)
        End If
        StringToHex2 = strString
    End Function
    
' Get files required for hashing algorithms
'------------------------------
    Public Sub GetHashFiles(ByVal X As Integer, ByVal ProductID As String, ByRef Files() As String, ByRef NumCdkeys As Long)
        NumCdkeys = 1
        Select Case UCase$(ProductID)
            Case "STAR", "SEXP", "SSHR"
                Files(0) = Profiles(X).HashPath & "\Starcraft.exe"
                Files(1) = Profiles(X).HashPath & "\Storm.dll"
                Files(2) = Profiles(X).HashPath & "\Battle.snp"
            Case "W2BN"
                Files(0) = Profiles(X).HashPath & "\Warcraft II BNE.exe"
                Files(1) = Profiles(X).HashPath & "\Storm.dll"
                Files(2) = Profiles(X).HashPath & "\Battle.snp"
            Case "D2DV", "D2XP"
                If (UCase$(ProductID) = "D2XP") Then NumCdkeys = 2
                Files(0) = Profiles(X).HashPath & "\Game.exe"
                Files(1) = Profiles(X).HashPath & "\Bnclient.dll"
                Files(2) = Profiles(X).HashPath & "\D2client.dll"
            Case "WAR3", "W3XP"
                If (UCase$(ProductID) = "W3XP") Then NumCdkeys = 2
                Files(0) = Profiles(X).HashPath & "\War3.exe"
                Files(1) = Profiles(X).HashPath & "\Storm.dll"
                Files(2) = Profiles(X).HashPath & "\Game.dll"
            Case "DRTL"
                Files(0) = Profiles(X).HashPath & "\Diablo.exe"
                Files(1) = Profiles(X).HashPath & "\Storm.dll"
                Files(2) = Profiles(X).HashPath & "\Battle.snp"
            Case "DSHR"
                Files(0) = Profiles(X).HashPath & "\Diablo_s.exe"
                Files(1) = Profiles(X).HashPath & "\Storm.dll"
                Files(2) = Profiles(X).HashPath & "\Battle.snp"
            Case "JSTR"
                Files(0) = Profiles(X).HashPath & "\StarCraftJ.exe"
                Files(1) = Profiles(X).HashPath & "\Storm.dll"
                Files(2) = Profiles(X).HashPath & "\Battle.snp"
        End Select
    End Sub
    
' Get the channel flags
'------------------------------
    Public Function GetChannelFlags(ByVal Flags As Long) As String
        Dim strBuffer As String
        If (Flags And CHANNEL_GLOBAL) = CHANNEL_GLOBAL Then strBuffer = strBuffer & "Global+"
        If (Flags And CHANNEL_MODERATED) = CHANNEL_MODERATED Then strBuffer = strBuffer & "Moderated+"
        If (Flags And CHANNEL_PRODUCTSPECIFIC) = CHANNEL_PRODUCTSPECIFIC Then strBuffer = strBuffer & "Product Specific+"
        If (Flags And CHANNEL_PUBLIC) = CHANNEL_PUBLIC Then strBuffer = strBuffer & "Public+"
        If (Flags And CHANNEL_RESTRICTED) = CHANNEL_RESTRICTED Then strBuffer = strBuffer & "Restricted+"
        If (Flags And CHANNEL_SILENT) = CHANNEL_SILENT Then strBuffer = strBuffer & "Silent+"
        If (Flags And CHANNEL_SYSTEM) = CHANNEL_SYSTEM Then strBuffer = strBuffer & "System+"
        If Flags = &H0 Then strBuffer = strBuffer & "Private+"
    
        strBuffer = Left$(strBuffer, Len(strBuffer) - 1)
        GetChannelFlags = strBuffer
    End Function
    
' Get Lcoale Information
'------------------------------
    Public Function GetInfo(ByVal lInfo As Long) As String
        Dim Buffer As String, Ret As String
        Buffer = String$(256, 0)
        Ret = GetLocaleInfo(LOCALE_USER_DEFAULT, lInfo, Buffer, Len(Buffer))
        If Ret > 0 Then
            GetInfo = Left$(Buffer, Ret - 1)
        Else
            GetInfo = ""
        End If
    End Function
    
' Top-Most Form Setting
'------------------------------
    Public Sub SetAlwaysOnTopMode(hWndOrForm As Variant, Optional ByVal OnTop As Boolean = _
        True)
        Dim hwnd As Long
        ' get the hWnd of the form to be move on top
        If VarType(hWndOrForm) = vbLong Then
            hwnd = hWndOrForm
        Else
            hwnd = hWndOrForm.hwnd
        End If
        SetWindowPos hwnd, IIf(OnTop, HWND_TOPMOST, HWND_NOTOPMOST), 0, 0, 0, 0, _
            SWP_NOMOVE Or SWP_NOSIZE Or SWP_SHOWWINDOW
    End Sub
    
    Public Function FlagsToString(lngFlags As Long) As String
        Dim strFlags As String
        If (lngFlags = 0) Then strFlags = "normal": GoTo Convert:
        If (lngFlags And FL_BLIZZREP) = FL_BLIZZREP Then strFlags = strFlags & "Blizzard Representative, "
        If (lngFlags And FL_OPS) = FL_OPS Then strFlags = strFlags & "channel ops, "
        If (lngFlags And FL_PLUG) = FL_PLUG Then strFlags = strFlags & "UDP plug, "
        If (lngFlags And FL_IGNORE) = FL_IGNORE Then strFlags = strFlags & "ignored, "
        If (lngFlags And FL_SPEAKER) = FL_SPEAKER Then strFlags = strFlags & "speaker, "
        If (lngFlags And FL_JAILED) = FL_JAILED Then strFlags = strFlags & "jailed, "
        If (lngFlags And FL_GUEST) = FL_GUEST Then strFlags = strFlags & "guest, "
Convert:
        If Right$(strFlags, 2) = ", " Then strFlags = Mid$(strFlags, 1, Len(strFlags) - 2)
        strFlags = Mid$(UCase$(strFlags), 1, 1) & Mid$(strFlags, 2)
        FlagsToString = strFlags
    End Function
