Attribute VB_Name = "MNET_Definitions"
'///////////////////////////////////////
' MirageChat v2* Created by DDA-TriCk-E
' Source Release Date: 4th April 2006
'///////////////////////////////////////
    Option Explicit
    
    Public MNPacket As New MNET_Packet
    Private strBuffer As String
    Public Index As Integer
    
    Const EVID_ERROR& = &H1
    Const EVID_FAIL& = &H2
    Const EVID_INFO& = &H3
    Const EVID_EMOTE& = &H4
    Const EVID_WHISPERTO& = &H5
    Const EVID_WHISPERFROM& = &H6
    Const EVID_TALK& = &H7
    Const EVID_USERHERE& = &H8
    Const EVID_USERLEFT& = &H9
    Const EVID_USERJOIN& = &HA
    
    Const ID_EVENTS& = &HEB
    
    Public Sub MNTextAdd(ParamArray saElements() As Variant)
        On Error Resume Next
        Dim I As Integer
            With frmMain.rtbMirage
                'todo: fix error >>
                If Len(.Text) > 20000 Then .Text = vbNullString
                .SelStart = Len(.Text)
                .SelLength = 0
                .SelColor = vbWhite
                .SelText = "[" & Time & "] "
                .SelStart = Len(.Text)
            End With
    
        For I = LBound(saElements) To UBound(saElements) Step 2
            With frmMain.rtbMirage
                .SelStart = Len(.Text)
                .SelLength = 0
                .SelColor = saElements(I)
                .SelText = saElements(I + 1) & Left$(vbNewLine, -2 * CLng((I + 1) = UBound(saElements)))
                .SelStart = Len(.Text)
            End With
        Next I
    End Sub

    Public Sub MNHandleData(ByVal Data As String)
        Dim lngLen As Long, bytPacketType As Byte, _
        bytPacketID As Byte
        strBuffer = strBuffer & Data
        While Len(strBuffer) > 4
            lngLen = Val("&H" & StringToHex(StrReverse(Mid$(strBuffer, 3, 2))))
            If (Len(strBuffer) < lngLen) Or (lngLen < 0) Then Exit Sub
                MNPacket.SetData Left$(strBuffer, lngLen)
                bytPacketType = MNPacket.GetByte()
                bytPacketID = MNPacket.GetByte()
                MNPacket.Skip 2
                
                If bytPacketType = &HFD Then MNHandlePacket bytPacketID
            strBuffer = Mid$(strBuffer, lngLen + 1)
        Wend
    End Sub

    Public Sub Send_0xEA()
        MNPacket.InsertCString GetINI(PrefPath, "MirageNet", "Username")
        MNPacket.InsertCString GetINI(PrefPath, "MirageNet", "Password")
        MNPacket.SendPacket &HEA
    End Sub
    
    Public Sub Recv_0xEA()
        frmMain.lvMNS.ListItems.Clear
        MNPacket.Skip 4
        MNTextAdd vbYellow, "News: " & MNPacket.GetCString
        MNTextAdd vbGreen, "Logged on as: ", vbWhite, MNPacket.GetCString
    End Sub

    Public Sub Recv_0xEB()
        Dim X As Integer, Username As String
        Select Case MNPacket.GetDWORD()
            Case EVID_ERROR
                MNTextAdd vbRed, "Error: " & MNPacket.GetCString
            Case EVID_INFO
                MNTextAdd vbYellow, "Info: " & MNPacket.GetCString
            Case EVID_FAIL
                MNTextAdd vbRed, "Failure: " & MNPacket.GetCString
                frmMain.wsMirage.Close
            Case EVID_EMOTE
                MNTextAdd vbYellow, "<" & MNPacket.GetCString & " " & MNPacket.GetCString & ">"
            Case EVID_WHISPERTO
                MNTextAdd vbYellow, "<To: " & MNPacket.GetCString & "> ", RGB(&HE0, &HE0, &HE0), MNPacket.GetCString
            Case EVID_WHISPERFROM
                MNTextAdd vbYellow, "<From: " & MNPacket.GetCString & "> ", RGB(&HE0, &HE0, &HE0), MNPacket.GetCString
            Case EVID_TALK
                MNTextAdd vbYellow, "<" & MNPacket.GetCString & "> ", vbWhite, MNPacket.GetCString
            Case EVID_USERJOIN
                Username = MNPacket.GetCString
                MNTextAdd vbGreen, Username & " has joined the server."
                frmMain.lvMNS.ListItems.Add , , Username, , ICON_CHAT
                
                'frmClient.txtCounter = frmClient.List1.ListCount & " user(s)"
            Case EVID_USERLEFT
                Username = MNPacket.GetCString
                For X = -frmMain.lvMNS.ListItems.Count To -1
                    If frmMain.lvMNS.ListItems.Item(Abs(X)).Text = Username Then
                        frmMain.lvMNS.ListItems.Remove Abs(X)
                    End If
                Next X
                MNTextAdd vbGreen, Username & " has left the server."
                'frmClient.txtCounter = frmClient.List1.ListCount & " user(s)"
            Case EVID_USERHERE
                Username = MNPacket.GetCString
                MNTextAdd vbGreen, Username & " is online."
                frmMain.lvMNS.ListItems.Add , , Username, , ICON_CHAT
                'frmClient.List1.AddItem Username
                'frmClient.txtCounter = frmClient.List1.ListCount & " user(s)"
        End Select
    End Sub

    Public Sub MNHandlePacket(ByVal PacketID As Byte)
        'If PacketID > 0 Then Funct.AddChat 0, vbWhite, "mncs(in) <- " & FixPacketID(PacketID) & vbNewLine & StringToHex2(MNPacket.GetData) & vbNewLine
        Select Case PacketID
            Case &HEA: Recv_0xEA
            Case &HEB: Recv_0xEB
        End Select
    End Sub
