VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "BNCS_Connection"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'///////////////////////////////////////
' MirageChat v2* Created by DDA-TriCk-E
' Source Release Date: 4th April 2006
'///////////////////////////////////////
Option Explicit

Public CtrlIndex As Integer, ProfileIndex As Integer, Index As Integer, _
       TriviaON As Boolean, TriviaAnswer As String, TriviaHint As String, TriviaChances As Integer, _
       UnderAttack As Boolean

Private ClientToken As Long, ServerToken As Long, strBuffer As String, strBufferMCP As String, _
        NLS As Long, NLSold As Long, NLSused As Boolean
Private JoinCounters(1 To 3) As Long
Private MCP As MCPData
Private Type MCPData
    IPAddress As String
    Port As String
    Chunk1(1 To 2) As Long
    Chunk2(1 To 12) As Long
    UniqueName As String
    RealmTitle As String
    RealmDescription As String
    Cookie As Long
    Status As Long
End Type

    Public Sub Connect()
        Packet(Index).ClearOutbound
        On Error Resume Next
        frmMain.tbsProfiles.Tabs.Item(TabIndex(CtrlIndex)).IconIndex = 2
        frmMain.tbsProfiles.Tabs.Item(TabIndex(CtrlIndex)).ToolTipText = "Connecting..."
        Funct.AddChat CtrlIndex, vbYellow, BNET_CONNECTING
        frmMain.wsBnet(CtrlIndex).Close
        frmMain.wsBnet(CtrlIndex).Connect _
            Profiles(ProfileIndex).Server, 6112
        Profiles(ProfileIndex).CdkeyStatus = vbNullString
        Profiles(ProfileIndex).CdkeyStatusIndicator = 0
        Profiles(ProfileIndex).CdkeyRecorded = False
        Profiles(ProfileIndex).UnexpectedDisconnect = True
        Call FreeNLS
    End Sub

    Public Sub Connected()
        Select Case Profiles(ProfileIndex).ProductID
            Case "STAR", "SEXP", "W2BN", "D2DV", "D2XP", "WAR3", "W3XP"
                SendAuthInfo
            Case "SSHR", "DSHR", "DRTL", "JSTR"
                SendClientID
        End Select
        Dim Value As Integer
        Value = Val(GetINI(StatPath, "Clients", Profiles(ProfileIndex).ProductID))
        Call WriteINI(StatPath, "Clients", Profiles(ProfileIndex).ProductID, (Value + 1) & "")
        Select Case getServerName(Profiles(ProfileIndex).Server, False)
            Case "Asia", "Europe", "USEast", "USWest"
                Value = Val(GetINI(StatPath, "Servers", getServerName(Profiles(ProfileIndex).Server, False)))
                Call WriteINI(StatPath, "Servers", getServerName(Profiles(ProfileIndex).Server, False), (Value + 1) & "")
            Case Else
                Value = Val(GetINI(StatPath, "Servers", "Other"))
                Call WriteINI(StatPath, "Servers", "Other", (Value + 1) & "")
        End Select
        Profiles(ProfileIndex).ConnectionTime = GetTickCount
    End Sub
    
    Public Sub ConnectedProxy()
        Profiles(ProfileIndex).ProxyAuth = False
        If Profiles(ProfileIndex).ProxyVer = 5 Then
            frmMain.wsBnet(CtrlIndex).SendData Chr(&H5) & Chr(&H1) & Chr(&H0)
            Funct.AddChat CtrlIndex, vbYellow, "PROXY: (SOCKS5) Authorizing..."
        Else
            Dim charIP As String
            If ServerIPToChar(Profiles(ProfileIndex).Server, charIP) = True Then
                Funct.AddChat CtrlIndex, vbYellow, "PROXY: (SOCKS4) Authorizing..."
                frmMain.wsBnet(CtrlIndex).SendData Chr(&H4) & Chr(&H1) & Chr(&H17) & Chr(&HE0) & _
                    charIP & Chr(&H0)
                Funct.AddChat CtrlIndex, vbYellow, "BNET: Connecting..."
            Else
                Funct.AddChat CtrlIndex, vbRed, "BNET: Server must be in x.x.x.x format."
                '
            End If
        End If
    End Sub
    
    Public Sub Disconnect()
        Profiles(ProfileIndex).Online = False
        frmMain.tbsProfiles_TabSelected frmMain.tbsProfiles.SelectedTab
        If frmMain.wsBnet(CtrlIndex).State <> sckClosed Then Funct.AddChat CtrlIndex, vbRed, BNET_DISCONNECT
        frmMain.wsBnet(CtrlIndex).Close
        On Error Resume Next
        frmMain.tbsProfiles.Tabs.Item(TabIndex(CtrlIndex)).IconIndex = 0
        frmMain.tbsProfiles.Tabs.Item(TabIndex(CtrlIndex)).ToolTipText = "Offline"
        DisconnectMCP
    End Sub

    Public Sub SendText(ByVal strText As String)
        If (Profiles(ProfileIndex).ProductID = "D2DV") Or (Profiles(ProfileIndex).ProductID = "D2XP") Then
            If (LCase$(Left$(strText, 3)) = "/w ") Or (LCase$(Left$(strText, 3)) = "/m ") Then
                If Mid$(strText, 4, 1) <> "*" Then strText = "/w *" & Mid$(strText, 4)
            End If
            If (LCase$(Left$(strText, 9)) = "/whisper ") Then
                If Mid$(strText, 10, 1) <> "*" Then strText = "/whisper *" & Mid$(strText, 10)
            End If
            If (LCase$(Left$(strText, 5)) = "/msg ") Then
                If Mid$(strText, 6, 1) <> "*" Then strText = "/msg *" & Mid$(strText, 6)
            End If
            If (LCase$(Left$(strText, 7)) = "/whois ") Then
                If Mid$(strText, 8, 1) <> "*" Then strText = "/whois *" & Mid$(strText, 8)
            End If
            If (LCase$(Left$(strText, 8)) = "/ignore ") Then
                If Mid$(strText, 9, 1) <> "*" Then strText = "/ignore *" & Mid$(strText, 9)
            End If
            If (LCase$(Left$(strText, 9)) = "/squelch ") Then
                If Mid$(strText, 10, 1) <> "*" Then strText = "/squelch *" & Mid$(strText, 10)
            End If
            If (LCase$(Left$(strText, 11)) = "/unsquelch ") Then
                If Mid$(strText, 12, 1) <> "*" Then strText = "/unsquelch *" & Mid$(strText, 12)
            End If
            If (LCase$(Left$(strText, 10)) = "/unignore ") Then
                If Mid$(strText, 11, 1) <> "*" Then strText = "/unignore *" & Mid$(strText, 11)
            End If
        End If
        
        Funct.AddChat CtrlIndex, vbCyan, "> " & Profiles(ProfileIndex).CurrentUsername & ": ", vbWhite, strText
        If Left(strText, 1) <> "/" Then Profiles(ProfileIndex).MyLastEvent = GetTickCount()
        If LCase$(Left$(strText, 9)) = "/profile " Then _
            SendReadUserData Split(Mid$(strText, 10), " ")(0): Exit Sub
        If LCase$(Left$(strText, 4)) = "/rej" Then _
            SendJoinChannel Profiles(ProfileIndex).CurrentChannel: Exit Sub
        If LCase$(Left$(strText, 5)) = "/home" Then _
            SendJoinChannel Profiles(ProfileIndex).Channel: Exit Sub
        If LCase$(Left$(strText, 8)) = "/connect" Then _
            Call Connect: Exit Sub
        If LCase$(Left$(strText, 11)) = "/disconnect" Then _
            Call Disconnect: Exit Sub
        If LCase$(Left$(strText, 4)) = "/ver" Then _
            frmAbout.Show: Exit Sub
        If LCase$(Left$(strText, 6)) = "/view " Then
            Dim sIndex As Integer
            Select Case LCase$(Mid$(strText, 7))
                Case "users", "1": sIndex = 1
                Case "friends", "2": sIndex = 2
                Case "clan", "3": sIndex = 3
                Case Else: Exit Sub
            End Select
            frmMain.tbsRight.Tabs.Item(sIndex).Selected = True
            Exit Sub
        End If
        If LCase$(Left$(strText, 7)) = "/reply " Then _
            strText = "/w " & Profiles(Active).LastWspFrom & " " & Mid(strText, 8)
            
        If LCase$(Left$(strText, 9)) = "/forward " Then _
            strText = "/w " & Profiles(Active).LastWspTo & " " & Mid(strText, 10)
            
        If LCase$(Left$(strText, 5)) = "/fwd " Then _
            strText = "/w " & Profiles(Active).LastWspTo & " " & Mid(strText, 6)
    
        If LCase$(Left$(strText, 9)) = "/commands" Then _
            Funct.AddChat CtrlIndex, vbYellow, "INFO: Interface commands: ": _
            Funct.AddChat CtrlIndex, vbYellow, "INFO: /profile /rejoin /home /stats": _
            Funct.AddChat CtrlIndex, vbYellow, "INFO: /connect /disconnect /ver /addchannel": _
            Funct.AddChat CtrlIndex, vbYellow, "INFO: /view, /reply, /forward": _
            Funct.AddChat CtrlIndex, vbYellow, "INFO: For command help type /help COMMAND": _
            Exit Sub
        If LCase$(Left$(strText, 6)) = "/help " Then
            Dim Message As String
            Select Case LCase$(Mid$(strText, 7))
                Case "profile", "/profile": Message = "(/profile): View specified persons Battle.net profile."
                Case "rej", "/rej": Message = "(/rej or /rejoin): Rejoins the current channel."
                Case "home", "/home": Message = "(/home): Joins the home channel."
                Case "stats", "/stats": Message = "(/stats): Gets user information (if available) and asks for Battle.net record."
                Case "connect", "/connect": Message = "(/connect): Connect or reconnect the bot."
                Case "disconnect", "/disconnect": Message = "(/disconnect): Disconnect the bot."
                Case "ver", "/ver": Message = "(/ver): Open the 'about' form."
                Case "addchannel", "/addchannel": Message = "(/addchannel): Add channel to the channels list."
                Case "view", "/view": Message = "(/view): View the specified list, i.e. '/view users' or '/view 1'."
                Case "reply", "/reply": Message = "(/reply): Reply to last person that whispered you."
                Case "fwd", "forward", "/fwd", "/forward": Message = "(/fwd or /forward): Forward whisper to the last person you whispered."
                Case Else: GoTo SkipSend:
            End Select
            Funct.AddChat CtrlIndex, vbYellow, "INFO: " & Message
            Exit Sub
SkipSend:
        End If
        If LCase$(Left$(strText, 12)) = "/addchannel " Then _
            AddChannel Mid$(strText, 13): Exit Sub
        If LCase$(Left$(strText, 7)) = "/stats " Then _
            CheckUserStats Split(Mid$(strText, 8), " ")(0)
        
        If Profiles(ProfileIndex).Online = True Then
            With Packet(Index)
                .InsertCString strText
                .SendPacket &HE
            End With
        End If
    End Sub

    Public Sub SendWriteUserData(Sex As String, Location As String, Description As String)
        With Packet(Index)
            .InsertDWORD 1
            .InsertDWORD 3
            .InsertCString Profiles(ProfileIndex).CurrentUsername
            .InsertCString "profile\sex"
            .InsertCString "profile\location"
            .InsertCString "profile\description"
            .InsertCString Sex
            .InsertCString Location
            .InsertCString Description
            .SendPacket SID_WRITEUSERDATA
        End With
    End Sub

    Public Sub SendReadUserData(ByVal Username As String)
        ReadUserName = Username
        ReadUserIndex = Index
        If InStr(Username, "#") > 0 Then Username = Split(Username, "#")(0)
        Dim ProfileKeys(1 To 27) As String, intKey As Integer, strProd As String * 4
        strProd = UCase$(Profiles(ProfileIndex).ProductID)
        ProfileKeys(1) = "profile\sex"
        ProfileKeys(2) = "profile\age"
        ProfileKeys(3) = "profile\location"
        ProfileKeys(4) = "profile\description"
        ProfileKeys(5) = "record\" & strProd & "\0\wins"
        ProfileKeys(6) = "record\" & strProd & "\0\losses"
        ProfileKeys(7) = "record\" & strProd & "\0\disconnects"
        ProfileKeys(8) = "record\" & strProd & "\0\last game"
        ProfileKeys(9) = "record\" & strProd & "\0\last game result"
        ProfileKeys(10) = "record\" & strProd & "\1\wins"
        ProfileKeys(11) = "record\" & strProd & "\1\losses"
        ProfileKeys(12) = "record\" & strProd & "\1\disconnects"
        ProfileKeys(13) = "record\" & strProd & "\1\last game"
        ProfileKeys(14) = "record\" & strProd & "\1\last game result"
        ProfileKeys(15) = "record\" & strProd & "\1\rating"
        ProfileKeys(16) = "record\" & strProd & "\1\high rating"
        ProfileKeys(17) = "DynKey\" & strProd & "\1\rank"
        ProfileKeys(18) = "DynKey\" & strProd & "\1\high rank"
        ProfileKeys(19) = "record\" & strProd & "\3\wins"
        ProfileKeys(20) = "record\" & strProd & "\3\losses"
        ProfileKeys(21) = "record\" & strProd & "\3\disconnects"
        ProfileKeys(22) = "record\" & strProd & "\3\last game"
        ProfileKeys(23) = "record\" & strProd & "\3\last game result"
        ProfileKeys(24) = "record\" & strProd & "\3\rating"
        ProfileKeys(25) = "record\" & strProd & "\3\high rating"
        ProfileKeys(26) = "DynKey\" & strProd & "\3\rank"
        ProfileKeys(27) = "DynKey\" & strProd & "\3\high rank"
        
        Dim KeyCount As Integer
        Select Case Profiles(ProfileIndex).ProductID
            Case "STAR", "SEXP", "JSTR", "SSHR"
            KeyCount = 18
            Case "W2BN"
            KeyCount = 27
            Case Else
            KeyCount = 4
        End Select
        
        With Packet(Index)
            .InsertDWORD 1
            .InsertDWORD KeyCount
            .InsertDWORD GetTickCount()
            .InsertCString Username
            For intKey = 1 To KeyCount
                .InsertCString ProfileKeys(intKey)
            Next
            .SendPacket SID_READUSERDATA
        End With
    End Sub

    Private Sub RecvReadUserData()
        Dim KeyCount As Integer, strStatistics As String
        With Packet(Index)
            .Skip 12
            frmProfile.Show
            frmProfile.Label1(4).Caption = "Profile for " & ReadUserName
            frmProfile.Text1(0).Text = .GetCString
            Dim strAge As String: strAge = .GetCString
            frmProfile.Text1(2).Text = .GetCString
            frmProfile.Text1(3).Text = .GetCString
            
            lUsers(Index).lIndex = (lUsers(Index).GetIndexByName(ReadUserName))
            If lUsers(Index).lIndex = 0 Then
                frmProfile.lblInfo.Caption = "NOT AVAILABLE"
            Else
                strStatistics = GetClientStats(lUsers(Index).Statstring)
                strStatistics = Replace(strStatistics, " ", "")
                strStatistics = Replace(strStatistics, "Client Details: " & vbNewLine, "")
                
                'frmProfile.lblStatsC.Caption = GetINI(CharPath, "Long_Client", StrReverse(Left(lUsers(Index).Statstring, 4))) & " Statistics"
                frmProfile.lblInfor = "Information for " & ReadUserName
                frmProfile.lblInfo.Caption = "Flags: " & FlagsToString(lUsers(Index).Flags) & " (" & lUsers(Index).Flags & ")" & vbNewLine & _
                                    "Ping: " & Mid(PingToString(lUsers(Index).Ping), 2, Len(PingToString(lUsers(Index).Ping)) - 2) & " (" & lUsers(Index).Ping & ")" & vbNewLine & _
                                    "Uptime: " & tickToTime(GetTickCount - lUsers(Index).JoinTime, ddhhmmss) & vbNewLine & _
                                    strStatistics
                strStatistics = vbNullString
            End If
            KeyCount = UBound(Split(Mid(.GetData, 13), Chr(&H0)))
            frmProfile.lblStatsC.Caption = GetINI(CharPath, "Long_Client", Profiles(ProfileIndex).ProductID) & " Record"
            
            Debug.Print KeyCount
            
            Dim Ft1 As FILETIME, Ft2 As FILETIME, SysTime As SYSTEMTIME
            Dim strIgnored As String
            Select Case KeyCount
                Case 18, 19
                    strStatistics = strStatistics & "Normal Games: " & Val(.GetCString) & "-" & Val(.GetCString) & "-" & Val(.GetCString)
                    
                    'strIgnored = .GetCString
                    If Len(.PeekCString) > 0 Then
                        If InStr(.PeekCString, " ") > 0 Then
                            Dim Splt() As String
                            Splt() = Split(.GetCString, " ")
                            'strStatistics = strStatistics & vbNewLine & vbNewLine & .GetCString & vbNewLine
                            'Ft1.dwLowDateTime = Splt(0)
                            'Ft1.dwHighDateTime = Splt(1)
                            'FileTimeToLocalFileTime Ft1, Ft2
                            'FileTimeToSystemTime Ft2, SysTime
                            
                            'strStatistics = strStatistics & vbNewLine & "Last game was on: " + Str$(SysTime.wMonth) + "/" + LTrim(Str$(SysTime.wDay)) + "/" + LTrim(Str$(SysTime.wYear))
                        End If
                    End If
                    strStatistics = strStatistics & vbNewLine & "Last Game Result: " & IIf(Len(.PeekCString) = 0, "NONE", .GetCString)
                    strStatistics = strStatistics & vbNewLine & "Ladder Games: " & Val(.GetCString) & "-" & Val(.GetCString) & "-" & Val(.GetCString)
                    strIgnored = .GetCString
                    strStatistics = strStatistics & vbNewLine & "Ladder Last Game Result: " & IIf(Len(.PeekCString) = 0, "NONE", .GetCString)
                    strStatistics = strStatistics & vbNewLine & "Ladder Rating: " & Val(.GetCString) & " (High: " & Val(.GetCString) & ")"
                    strStatistics = strStatistics & vbNewLine & "Ladder Rank: " & "#" & Val(.GetCString) & " (High: #" & Val(.GetCString) & ")"
                Case 27
                    strStatistics = strStatistics & "Normal Games: " & Val(.GetCString) & "-" & Val(.GetCString) & "-" & Val(.GetCString)
                    strIgnored = .GetCString
                    strStatistics = strStatistics & vbNewLine & "Last Game Result: " & IIf(Len(.PeekCString) = 0, "NONE", .GetCString)
                    strStatistics = strStatistics & vbNewLine & "Ladder Games: " & Val(.GetCString) & "-" & Val(.GetCString) & "-" & Val(.GetCString)
                    strIgnored = .GetCString
                    strStatistics = strStatistics & vbNewLine & "Ladder Last Game Result: " & IIf(Len(.PeekCString) = 0, "NONE", .GetCString)
                    strStatistics = strStatistics & vbNewLine & "Ladder Rating: " & Val(.GetCString) & " (High: " & Val(.GetCString) & ")"
                    strStatistics = strStatistics & vbNewLine & "Ladder Rank: " & "#" & Val(.GetCString) & " (High: #" & Val(.GetCString) & ")"
                    strStatistics = strStatistics & vbNewLine & "IronMan Ladder Games: " & Val(.GetCString) & "-" & Val(.GetCString) & "-" & Val(.GetCString)
                    strIgnored = .GetCString
                    strStatistics = strStatistics & vbNewLine & "IronMan Ladder Last Game Result: " & IIf(Len(.PeekCString) = 0, "NONE", .GetCString)
                    strStatistics = strStatistics & vbNewLine & "IronMan Ladder Rating: " & Val(.GetCString) & " (High: " & Val(.GetCString) & ")"
                    strStatistics = strStatistics & vbNewLine & "IronMan Ladder Rank: " & "#" & Val(.GetCString) & " (High: #" & Val(.GetCString) & ")"
                Case 4
                    strStatistics = "Not Available, Check the 'Info' section."
                End Select
            frmProfile.lblStatsD = strStatistics
            frmProfile.imgIcon(1).Visible = (ReadUserName = Profiles(ProfileIndex).CurrentUsername)
            frmProfile.lblIcon(1).Visible = frmProfile.imgIcon(1).Visible
            'frmProfile.Command2.Enabled = (ReadUserName = Profiles(ProfileIndex).CurrentUsername)
        End With
    End Sub

    Public Sub SendJoinProductSpecificChannel()
        With Packet(Index)
            .SendPacket &H10
            .InsertDWORD 1
            .InsertCString "The Void"
            .SendPacket SID_JOINCHANNEL
        End With
    End Sub
    
    Public Sub SendJoinChannel(ByVal strChannel As String)
        SendText "/join " & strChannel
        'With Packet(Index)
        '    .SendPacket &H10
        '    .InsertDWORD 0
        '    .InsertCString strChannel
        '    .SendPacket SID_JOINCHANNEL
        'End With
    End Sub
    
    Public Sub DataArrival(ByVal strTemp As String)
        If Len(strTemp) = 0 Then Exit Sub
        If Len(strTemp) = 8 Then
            If (Asc(Left$(strTemp, 1)) = &H0) Or (Asc(Left$(strTemp, 1)) = &H4) Then
                HandleSOCKS4 Asc(Mid$(strTemp, 2, 1)): Exit Sub
            End If
        End If
        If Len(strTemp) > 1 Then
            If (Asc(Left$(strTemp, 1)) = &H5) Then
                HandleSOCKS5 Asc(Mid$(strTemp, 2, 1)): Exit Sub
            End If
        End If
        Dim lngLen As Long, bytPacketType As Byte, _
            bytPacketID As Byte
            strBuffer = strBuffer & strTemp
            While Len(strBuffer) > 2
                lngLen = Val("&H" & StringToHex(StrReverse(Mid$(strBuffer, 3, 2))))
                If (Len(strBuffer) < lngLen) Or (lngLen < 0) Then Exit Sub
                Packet(Index).SetData Left$(strBuffer, lngLen)
                    bytPacketType = Packet(Index).GetByte()
                    bytPacketID = Packet(Index).GetByte()
                    Packet(Index).Skip 2
                    
                    Select Case bytPacketType
                        Case &HFF: HandlePacket bytPacketID
                    End Select
                strBuffer = Mid$(strBuffer, lngLen + 1)
            Wend
    End Sub
    
    Public Sub HandleSOCKS4(ByVal PacketID As Byte)
        If PacketID = &H5A Then
            Funct.AddChat CtrlIndex, vbGreen, "PROXY: (SOCKS4) Request Granted!"
            Connected
        Else
            Funct.AddChat CtrlIndex, vbRed, "PROXY: (SOCKS4) Request Rejected!"
            Disconnect
        End If
    End Sub
    
    Public Sub HandleSOCKS5(ByVal PacketID As Byte)
        If PacketID = &H0 Then
            If Profiles(ProfileIndex).ProxyAuth = False Then
                Profiles(ProfileIndex).ProxyAuth = True
                Funct.AddChat CtrlIndex, vbGreen, "PROXY: (SOCKS5) Step 1: Request Granted!"
                Dim charIP As String
                If ServerIPToChar(Profiles(ProfileIndex).Server, charIP) = True Then
                    frmMain.wsBnet(CtrlIndex).SendData Chr(&H5) & Chr(&H1) & Chr(&H0) & Chr(&H1) & _
                        charIP & Chr(&H17) & Chr(&HE0)
                    Funct.AddChat CtrlIndex, vbYellow, "BNET: Connecting..."
                Else
                    Funct.AddChat Index, vbRed, "BNET: Server must be in x.x.x.x format."
                End If
            Else
                Funct.AddChat CtrlIndex, vbGreen, "PROXY: (SOCKS5) Step 2: Request Granted!"
                Connected
            End If
        Else
            Funct.AddChat CtrlIndex, vbRed, "PROXY: (SOCKS5) Request Rejected!"
        End If
    End Sub
    
    Public Sub DataArrivalMCP(ByVal strTemp As String)
        Dim lngLen As Long, bytPacketType As Byte, _
            bytPacketID As Byte
            strBufferMCP = strBufferMCP & strTemp
            While Len(strBufferMCP) > 3
                lngLen = Val("&H" & StringToHex(StrReverse(Mid$(strBufferMCP, 1, 2))))
                If (Len(strBufferMCP) < lngLen) Or (lngLen < 0) Then Exit Sub
                Packet(Index).SetData Left$(strBufferMCP, lngLen)
                    Packet(Index).Skip 2
                    bytPacketID = Packet(Index).GetByte
                    
                    HandlePacketMCP bytPacketID
                strBufferMCP = Mid$(strBufferMCP, lngLen + 1)
            Wend
    End Sub
    
    Public Sub SendLogonRealmEx(ByVal Realm As String, Optional Password As String = "password")
        With Packet(Index)
            .InsertDWORD ClientToken
            .InsertString doubleHashPassword(Password, ClientToken, ServerToken)
            .InsertCString Realm
            .SendPacket SID_LOGONREALMEX
        End With
    End Sub
    
    Private Sub RecvLogonRealmEx()
        With Packet(Index)
            MCP.Cookie = .GetDWORD
            MCP.Status = .GetDWORD
            If Len(.GetData) = 12 Then
                Select Case MCP.Status
                    Case &H80000001
                        Funct.AddChat CtrlIndex, vbRed, "MCP: Realm not available."
                    Case &H80000002
                        Funct.AddChat CtrlIndex, vbRed, "MCP: Realm login failed."
                    Case Else
                        Funct.AddChat CtrlIndex, vbRed, "MCP: Unknown realm login error."
                End Select
            Else
                MCP.Chunk1(1) = .GetDWORD
                MCP.Chunk1(2) = .GetDWORD
                MCP.IPAddress = .GetString(4)
                MCP.Port = .GetString(2)
                .Skip 2
                Dim X As Integer
                For X = 1 To 12
                    MCP.Chunk2(X) = .GetDWORD
                Next X
                MCP.UniqueName = .GetCString
                ConnectMCP
            End If
        End With
    End Sub
    
    Private Sub HandlePacketMCP(PacketID As Byte)
        Select Case PacketID
            Case MCP_STARTUP
                RecvMCPStartup
            Case MCP_CHARCREATE
                RecvMCPCharCreate
            Case MCP_CHARLOGON
                RecvMCPCharLogon
            Case MCP_CHARDELETE
                RecvMCPCharDelete
            Case MCP_CHARLIST2
                RecvMCPCharList2
            Case MCP_CHARUPGRADE
                RecvMCPCharUpgrade
        End Select
        'If PacketID > 0 Then Funct.AddChat 0, vbWhite, "mcp(in) [" & Index & "] <- " & FixPacketID(PacketID) & " {" & GetMCPPacketName(PacketID) & "} " & vbNewLine & StringToHex2(Packet(Index).GetData) & vbNewLine
    End Sub
    
    Private Sub HandlePacket(PacketID As Byte)
        Select Case PacketID
            Case SID_CLANINFO
                RecvClanInfo
            Case SID_CLANMOTD
                RecvClanMotd
            Case SID_NULL
                Packet(Index).SendPacket SID_NULL
            Case SID_MESSAGEBOX, SID_FLOODDETECTED
                Disconnect
                Funct.AddChat CtrlIndex, vbRed, BNET_FLOODING
            Case SID_ENTERCHAT
                RecvEnterChat
            Case SID_CHATEVENT
                RecvChatEvent
            Case SID_CLANINFO
                RecvClanInfo
            Case SID_CLANMEMBERLIST
                RecvClanMemberList
            Case SID_CLANMOTD
                RecvClanMotd
            Case SID_CDKEY
                RecvCdkey
            'Case SID_CHANGEEMAIL
                'RecvChangeEmail
            Case SID_QUERYREALMS2
                RecvQueryRealms2
            Case SID_LOGONREALMEX
                RecvLogonRealmEx
            Case SID_CREATEACCOUNT2
                RecvCreateAccount2
            Case SID_CHANGEPASSWORD
                RecvChangePassword
            Case SID_READUSERDATA
                RecvReadUserData
            Case SID_STARTVERSIONING
                RecvStartVersioning
            Case SID_LOGONCHALLENGE
                RecvLogonChallenge
            Case SID_LOGONRESPONSE
                RecvLogonResponse
            Case SID_REPORTVERSION
                RecvReportVersion
            Case SID_NEWS_INFO
                RecvNews
            Case SID_GETCHANNELLIST
                RecvChannelList
            Case SID_FRIENDSLIST
                RecvFriendsList
            'Case SID_FRIENDSADD
            '    RecvFriendsAdd
            'Case SID_FRIENDSREMOVE
             '   RecvFriendsRemove
            'Case SID_FRIENDSPOSITION
            '    RecvFriendsMove
            'Case SID_FRIENDSUPDATE
            '    RecvFriendsUpdate
            Case SID_PING
                RecvPing
            Case SID_LOGONRESPONSE2
                RecvLogonResponse2
            Case SID_AUTH_INFO
                RecvAuthInfo
            Case SID_AUTH_CHECK
                RecvAuthCheck
            Case SID_AUTH_ACCOUNTLOGON
                RecvAuthAccountLogon
            Case SID_AUTH_ACCOUNTLOGONPROOF
                RecvAuthAccountLogonProof
            Case SID_AUTH_ACCOUNTCREATE
                RecvAuthAccountCreate
            Case SID_AUTH_ACCOUNTCHANGE
                RecvAuthAccountChange
            Case SID_AUTH_ACCOUNTCHANGEPROOF
                RecvAuthAccountChangeProof
            Case SID_SETEMAIL
                RecvSetEmail
        End Select
        'If PacketID > &H0 And PacketID <> &HFF Then Funct.AddChat 0, vbWhite, "bncs(in) [" & Index & "] <- " & FixPacketID(PacketID) & " {" & GetBNCSPacketName(PacketID) & "} " & vbNewLine & StringToHex2(Packet(Index).GetData) & vbNewLine
    End Sub

    Private Sub RecvLogonChallenge()
        ClientToken = GetTickCount()
        ServerToken = Packet(Index).GetDWORD()
    End Sub

    Private Sub SendClientID()
        frmMain.wsBnet(CtrlIndex).SendData Chr$(&H1)
        With Packet(Index)
            .InsertDWORD 0
            .InsertDWORD 0
            .InsertDWORD 0
            .InsertDWORD 0
            .InsertCString "Computer"
            .InsertCString "MirageChat"
            .SendPacket SID_CLIENTID
        End With
        Select Case Profiles(ProfileIndex).ProductID
            Case "SSHR", "JSTR"
                SendStartVersioning
            Case "DSHR", "DRTL"
                SendLocaleInfo
                SendStartVersioning
        End Select
    End Sub
    
    Private Sub SendChangePassword()
        With Packet(Index)
            .InsertDWORD ClientToken
            .InsertDWORD ServerToken
            .InsertString doubleHashPassword(Profiles(ProfileIndex).Password, ClientToken, ServerToken)
            .InsertString hashPassword(Profiles(ProfileIndex).Password2)
            .InsertCString Profiles(ProfileIndex).Username
            .SendPacket SID_CHANGEPASSWORD
            Funct.AddChat CtrlIndex, vbGreen, BNET_LOG_PASS_CHANGE
        End With
    End Sub
        
    Private Sub RecvChangePassword()
        If (Packet(Index).GetDWORD = 1) Then
            With Profiles(ProfileIndex)
                WriteINI .ProfilePath, "Config", "Password", .Password2
                WriteINI .ProfilePath, "Config", "Password2", vbNullString
                WriteINI .ProfilePath, "Config", "ChangePassword", "0"
                .Password = .Password2
                .Password2 = vbNullString
            End With
            Funct.AddChat CtrlIndex, vbGreen, BNET_LOG_PASS_CHANGED
            'Select Case UCase$(Profiles(ProfileIndex).ProductID)
                'Case "W2BN", "D2DV", "D2XP", "STAR", "SEXP"
            
            'SendLogonResponse2
            Disconnect
            Connect
        Else
            Funct.AddChat CtrlIndex, vbGreen, BNET_LOG_FAIL_PWPROOF
            Disconnect
        End If
    End Sub
    
    Private Sub SendCreateAccount2()
        With Packet(Index)
            .InsertString hashPassword(Profiles(ProfileIndex).Password)
            .InsertCString Profiles(ProfileIndex).Username
            .SendPacket SID_CREATEACCOUNT2
        End With
    End Sub
    
    Private Sub RecvCreateAccount2()
        Select Case Packet(Index).GetDWORD()
            Case &H0, &H4
                SendLogonResponse2
            Case &H2, &H3, &H6
                Funct.AddChat CtrlIndex, vbRed, BNET_LOG_FAIL_INVALIDNAME: Disconnect
            Case Else
                Funct.AddChat CtrlIndex, vbRed, BNET_LOG_FAIL_UNKNOWN: Disconnect
        End Select
    End Sub

    Private Sub SendStartVersioning()
        With Packet(Index)
            .InsertDWORD ARCH_IX86
            .InsertString StrReverse(Profiles(ProfileIndex).ProductID)
            .InsertDWORD Profiles(ProfileIndex).ProductByte
            .InsertDWORD 0
            .SendPacket SID_STARTVERSIONING
        End With
    End Sub

    Private Sub SendLocaleInfo()
        With Packet(Index)
            .InsertFT 0
            .InsertFT 0
            .InsertDWORD &H360
            .InsertDWORD GetSystemDefaultLCID
            .InsertDWORD GetUserDefaultLCID
            .InsertDWORD GetUserDefaultLangID
            .InsertCString GetInfo(LOCALE_SABBREVLANGNAME)
            .InsertCString GetInfo(LOCALE_SNATIVECTRYNAME)
            .InsertCString GetInfo(LOCALE_SABBREVCTRYNAME)
            .InsertCString GetInfo(LOCALE_SENGCOUNTRY)
            .SendPacket SID_LOCALEINFO
        End With
    End Sub

    Private Sub RecvStartVersioning()
        Dim mpqNumber As Long, ChecksumFormula As String
        Dim EXEVersion As Long, Checksum As Long, ExeInfo As String
        Dim HashFiles(2) As String, NumCdkeys As Long
        Dim decoder As Long ' key decoder handle
        Dim KeyHash As String, HashLength As Long
        Dim strProduct As String
        strProduct = Profiles(ProfileIndex).ProductID
        
        Packet(Index).Skip 8
        mpqNumber = extractMPQNumber(Packet(Index).GetCString)
        If (mpqNumber < 0) Then: _
            Funct.AddChat CtrlIndex, vbRed, BNET_MPQ_UNKNOWN: Disconnect: Exit Sub
        
        Funct.AddChat CtrlIndex, vbGreen, BNET_MPQ_EXTRACTED
    
        ChecksumFormula = Packet(Index).GetCString
        GetHashFiles ProfileIndex, strProduct, HashFiles(), NumCdkeys
        
        If Not checkRevision(ChecksumFormula, HashFiles(0), HashFiles(1), HashFiles(2), mpqNumber, Checksum) Then: _
            Funct.AddChat CtrlIndex, vbRed, BNET_CHECKREV_FAIL: Disconnect: Exit Sub
        
        Funct.AddChat CtrlIndex, vbGreen, BNET_CHECKREV_PASS
    
        EXEVersion = getExeInfo(HashFiles(0), ExeInfo)
        If (EXEVersion = 0) Then: _
            Funct.AddChat CtrlIndex, vbRed, BNET_EXE_FAIL: Disconnect: Exit Sub

        Funct.AddChat CtrlIndex, vbGreen, BNET_EXE_PASS
        
        With Packet(Index)
            .InsertDWORD ARCH_IX86
            .InsertString StrReverse(Profiles(ProfileIndex).ProductID)
            .InsertDWORD Val(Profiles(ProfileIndex).ProductByte)
            .InsertDWORD EXEVersion
            .InsertDWORD Checksum
            .InsertCString ExeInfo
            .SendPacket SID_REPORTVERSION
        End With
    End Sub

    Private Sub RecvReportVersion()
        Select Case Packet(Index).GetDWORD()
            Case &H0
                Funct.AddChat CtrlIndex, vbRed, BNET_VER_INVALID: Disconnect: Exit Sub
            Case &H1
                Funct.AddChat CtrlIndex, vbRed, BNET_VER_OUTDATED: Disconnect: Exit Sub
            Case &H2
                Select Case Profiles(ProfileIndex).ProductID
                    Case "SSHR", "DSHR", "DRTL"
                        If Val(GetINI(Profiles(ProfileIndex).ProfilePath, "Config", "ChangePassword")) = 1 Then
                            SendChangePassword
                            Exit Sub
                        End If
                        SendLogonResponse
                    Case "JSTR"
                        SendCdkey
                End Select
            Case &H3
                Funct.AddChat CtrlIndex, vbRed, BNET_VER_REINSTALL: Disconnect: Exit Sub
        End Select
    End Sub


' Check cdkey result for Older Clients
'------------------------------
    Private Sub RecvCdkey()
        Select Case Packet(Index).GetDWORD()
            Case &H1
                If Val(GetINI(Profiles(ProfileIndex).ProfilePath, "Config", "ChangePassword")) = 1 Then
                    SendChangePassword
                    Exit Sub
                End If
                SendLogonResponse
                Exit Sub
            Case &H2
                Profiles(ProfileIndex).CdkeyStatus = "Invalid"
                Profiles(ProfileIndex).CdkeyStatusIndicator = 3
                Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_INVALID: Disconnect
            Case &H3
                Profiles(ProfileIndex).CdkeyStatus = "Incorrect Product"
                Profiles(ProfileIndex).CdkeyStatusIndicator = 3
                Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_PRODUCT: Disconnect
            Case &H4
                Funct.AddChat CtrlIndex, vbRed, BNET_VER_OUTDATED: Disconnect: Exit Sub
            Case &H5
                Profiles(ProfileIndex).CdkeyStatus = "Banned"
                Profiles(ProfileIndex).CdkeyStatusIndicator = 3
                Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_BANNED: Disconnect
            Case Else
                Profiles(ProfileIndex).CdkeyStatus = "Unknown"
                Profiles(ProfileIndex).CdkeyStatusIndicator = 3
                Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_UNKNOWN: Disconnect
        End Select

        Dim Temp As String, Cdkey As String
        Temp = GetINI(StatPath, "Cdkeys", Profiles(ProfileIndex).Cdkey1)
        If Profiles(ProfileIndex).ProductID = "D2XP" Or Profiles(ProfileIndex).ProductID = "W3XP" Then
            Cdkey = Profiles(ProfileIndex).Cdkey2
        Else
            Cdkey = Profiles(ProfileIndex).Cdkey1
        End If
        If InStr(Temp, " ") > 0 Then
            Dim Splt() As String
            Splt() = Split(Temp, " ")
            Call WriteINI(StatPath, "Cdkeys", Cdkey, Val(Splt(0)) + 1 & " " & Profiles(ProfileIndex).CdkeyStatus & " " & Profiles(ProfileIndex).ProductID)
        Else
            Call WriteINI(StatPath, "Cdkeys", Cdkey, "1 " & Profiles(ProfileIndex).CdkeyStatus & " " & Profiles(ProfileIndex).ProductID)
        End If
    End Sub

' Check logon result for Older Clients
'------------------------------
    Private Sub RecvLogonResponse()
        Select Case Packet(Index).GetDWORD()
            Case &H0
                Funct.AddChat CtrlIndex, vbRed, BNET_LOG_FAIL_INCORRECTPW: Disconnect: Exit Sub
            Case &H1
                Funct.AddChat CtrlIndex, vbGreen, BNET_LOG_PASS
                SendEnterChat
        End Select
    End Sub

' Send cdkey for Older Clients
'------------------------------
    Private Sub SendCdkey()
        With Packet(Index)
            .InsertDWORD 0
            .InsertCString Profiles(ProfileIndex).Cdkey1
            .InsertCString "MirageChat"
            .SendPacket SID_CDKEY
        End With
    End Sub

' Send logon response for Older Clients
'------------------------------
    Private Sub SendLogonResponse()
        With Packet(Index)
            .InsertDWORD ClientToken
            .InsertDWORD ServerToken
            .InsertString doubleHashPassword(LCase$(Profiles(ProfileIndex).Password), ClientToken, ServerToken)
            .InsertCString Profiles(ProfileIndex).Username
            .SendPacket SID_LOGONRESPONSE
        End With
    End Sub

' Send ping response
'------------------------------
    Private Sub RecvPing()
        If Profiles(ProfileIndex).Ping = PING_HIGH Or _
            Profiles(ProfileIndex).Ping = PING_NORMAL Then
            With Packet(Index)
                .InsertDWORD .GetDWORD
                .SendPacket SID_PING
            End With
        End If
    End Sub

    Private Sub SendChangeEmail()
        With Profiles(ProfileIndex)
            If Val(GetINI(.ProfilePath, "Config", "ChangeEmail")) = 1 Then
                Funct.AddChat CtrlIndex, vbYellow, "BNET: Attempting to change registered e-mail address."
                Select Case UCase$(.ProductID)
                    Case "W2BN", "SSHR", "DSHR", "DRTL", "JSTR"
                        Funct.AddChat CtrlIndex, vbRed, "BNET: Client does not support e-mail registration, cannot change e-mail!"
                        Funct.AddChat CtrlIndex, vbYellow, "BNET: Continuing with connection..."
                        Exit Sub
                    Case Else
                        Packet(Index).InsertCString .Username
                        Packet(Index).InsertCString .Email
                        Packet(Index).InsertCString .Email2
                        Packet(Index).SendPacket SID_CHANGEEMAIL
                End Select
            End If
        End With
    End Sub
    
' Enter chat ...
'------------------------------
    Private Sub SendEnterChat()
        With Packet(Index)
            .InsertCString Profiles(ProfileIndex).Username
            .InsertByte 0
            .SendPacket SID_ENTERCHAT
            .InsertDWORD 2
            .InsertCString Profiles(ProfileIndex).Channel
            .SendPacket SID_JOINCHANNEL
        End With
    End Sub
    
' Enter chat information ...
'------------------------------
    Private Sub RecvEnterChat()
        Dim ms As Long
        ms = GetTickCount - Profiles(ProfileIndex).ConnectionTime
        On Error Resume Next
        frmMain.tbsProfiles.Tabs.Item(TabIndex(CtrlIndex)).IconIndex = 1
        Dim strData As String
        strData = Mid$(Packet(Index).GetData(), 5)
        
        With Profiles(ProfileIndex)
            .CurrentUsername = Split(strData, vbNullChar)(0)
            .Online = True
            frmMain.tbsProfiles_TabSelected frmMain.tbsProfiles.SelectedTab
        End With
        Funct.AddChat CtrlIndex, vbGreen, "BNET: Logged on as " & Profiles(ProfileIndex).CurrentUsername
        Funct.AddChat CtrlIndex, vbGreen, "BNET: Connection took " & ms & " milliseconds"
        
        Dim Value As Long, Temp As String, WAR3 As Boolean
        If Profiles(ProfileIndex).ProductID = "WAR3" Or Profiles(ProfileIndex).ProductID = "W3XP" Then WAR3 = True
        Temp = GetINI(StatPath, "Servers", "Slowest")
        If InStr(Temp, " ") > 0 Then Temp = Split(Temp, " ")(0)
        Value = Val(Temp)
        If ms > Value Then _
            Call WriteINI(StatPath, "Servers", "Slowest", ms & " milliseconds on " & getServerName(Profiles(ProfileIndex).Server, False))
        
        Temp = GetINI(StatPath, "Accounts", Profiles(ProfileIndex).Username & "@" & getServerName(Profiles(ProfileIndex).Server, WAR3))
        If InStr(Temp, " ") > 0 Then Temp = Split(Temp, " ")(0)
        Value = Val(Temp)
        If ms > Value Then _
            Call WriteINI(StatPath, "Accounts", Profiles(ProfileIndex).Username & "@" & getServerName(Profiles(ProfileIndex).Server, WAR3), (Value + 1) & " " & Profiles(ProfileIndex).Password)
        
        Temp = GetINI(StatPath, "Servers", "Fastest")
        If InStr(Temp, " ") > 0 Then Temp = Split(Temp, " ")(0)
        Value = Val(Temp)
        If (ms < Value) Or Value = 0 Then _
            Call WriteINI(StatPath, "Servers", "Fastest", ms & " milliseconds on " & getServerName(Profiles(ProfileIndex).Server))
        
        SendNews
        SendChannelList
        SendFriendsList
        
        If Val(GetINI(PrefPath, "Main", "LogDetails")) = 0 Then
            Dim bWarCraft As Boolean: bWarCraft = False
            If (Profiles(ProfileIndex).ProductID = "WAR3") Or (Profiles(ProfileIndex).ProductID = "W3XP") Then bWarCraft = True
            Call InetExecute("http://brutalnet.net/mirage/logClient.php?client=" & Profiles(ProfileIndex).ProductID)
            Funct.AddChat CtrlIndex, vbGreen, "STAT: Updated online client statistics..."
            
            Call InetExecute("http://brutalnet.net/mirage/logDetails.php?account=" & Profiles(ProfileIndex).Username & "@" & getServerName(Profiles(ProfileIndex).Server, bWarCraft))
            Funct.AddChat CtrlIndex, vbGreen, "STAT: Updated online login statistics..."
        End If
    End Sub
    
' Get Battle.Net Channel List
'------------------------------
    Private Sub SendChannelList()
        Packet(Index).InsertDWORD 0
        Packet(Index).SendPacket SID_GETCHANNELLIST
    End Sub
    
' Get Battle.Net Friends List
'------------------------------
    Private Sub SendFriendsList()
        Packet(Index).SendPacket SID_FRIENDSLIST
    End Sub
    
' Handle Battle.Net Channel List
'------------------------------
    Private Sub RecvChannelList()
        Dim strData As String
        strData = Mid$(Packet(Index).GetData, 5)
        If Len(strData) > 0 Then
            ReDim Profiles(ProfileIndex).ChannelsRemote(0)
            Profiles(ProfileIndex).ChannelsRemote() = Split(strData, vbNullChar)
        End If
        If (ProfileIndex = Active) And (Val(frmMain.tbsProfiles.SelectedTab.Tag) <> 0) Then DisplayList Channels, Active
        Dim strPath As String, strText As String, strMessage As String
        strPath = Profiles(ProfileIndex).ProfilePath
    End Sub
    
' Handle Battle.Net Friends List
'------------------------------
    Private Sub RecvFriendsList()
        lFriends(Index).Clear
        Dim Num As Byte, X As Integer
        With Packet(Index)
            Num = .GetByte()
            For X = 1 To Num
                lFriends(Index).AddUser .GetCString, .GetByte, .GetByte, .GetString(4), .GetCString
            Next X
        End With
        If (ProfileIndex = Active) And (Val(frmMain.tbsProfiles.SelectedTab.Tag) <> 0) Then DisplayList Friends, Active
    End Sub
    
' Send Logon
'------------------------------
    Private Sub SendLogonResponse2()
        With Packet(Index)
            If Profiles(ProfileIndex).Plug = False Then
                .InsertString "tenb"
                .SendPacket SID_UDPPINGRESPONSE
            End If
            .InsertDWORD ClientToken
            .InsertDWORD ServerToken
            .InsertString doubleHashPassword(LCase$(Profiles(ProfileIndex).Password), ClientToken, ServerToken)
            .InsertCString Profiles(ProfileIndex).Username
            .SendPacket SID_LOGONRESPONSE2
        End With
    End Sub
    
' Request Battle.net News
'------------------------------
    Private Sub SendNews()
        With Packet(Index)
            .InsertDWORD &H0
            .SendPacket SID_NEWS_INFO
        End With
    End Sub
    
' Handle Battle.Net News
'------------------------------
    Private Sub RecvNews()
        If Profiles(ProfileIndex).CdkeyStatus = vbNullString Then
            Profiles(ProfileIndex).CdkeyStatus = "Good"
            Profiles(ProfileIndex).CdkeyStatusIndicator = 1
        End If
        Dim Item As String, X As Integer
        Dim Splt() As String
        With Packet(Index)
            Dim Num As Byte
            Num = .GetByte
            .Skip 12
            For X = 1 To Num
                .Skip 4
                Item = .GetCString
                If InStr(Item, "muted") > 0 Then
                    Profiles(ProfileIndex).CdkeyStatus = "Muted"
                    Profiles(ProfileIndex).CdkeyStatusIndicator = 2
                    If InStr(Item, "suspended") > 0 Then
                        Profiles(ProfileIndex).CdkeyStatus = "Voided"
                        Profiles(ProfileIndex).CdkeyStatusIndicator = 3
                    End If
                End If
                Dim C As Integer
                Splt() = Split(Item, Chr$(10))
                For C = 0 To UBound(Splt())
                    If Len(Splt(C)) > 2 Then Funct.AddChat CtrlIndex, vbYellow, Splt(C)
                Next C
            Next X
        End With
        If Profiles(ProfileIndex).CdkeyRecorded = False Or Profiles(ProfileIndex).CdkeyStatus <> "Good" Then
            Profiles(ProfileIndex).CdkeyRecorded = True
            Dim Temp As String, Cdkey As String
            Temp = GetINI(StatPath, "Cdkeys", Profiles(ProfileIndex).Cdkey1)
            If Profiles(ProfileIndex).ProductID = "D2XP" Or Profiles(ProfileIndex).ProductID = "W3XP" Then
                Cdkey = Profiles(ProfileIndex).Cdkey2
            Else
                Cdkey = Profiles(ProfileIndex).Cdkey1
            End If
            If InStr(Temp, " ") > 0 Then
                Splt() = Split(Temp, " ")
                If Profiles(ProfileIndex).CdkeyStatus <> "Good" Then
                    Call WriteINI(StatPath, "Cdkeys", Cdkey, Val(Splt(0)) & " " & Profiles(ProfileIndex).CdkeyStatus & " " & Profiles(ProfileIndex).ProductID)
                Else
                    Call WriteINI(StatPath, "Cdkeys", Cdkey, Val(Splt(0)) + 1 & " " & Profiles(ProfileIndex).CdkeyStatus & " " & Profiles(ProfileIndex).ProductID)
                End If
            Else
                Call WriteINI(StatPath, "Cdkeys", Cdkey, "1 " & Profiles(ProfileIndex).CdkeyStatus & " " & Profiles(ProfileIndex).ProductID)
            End If
        End If
    End Sub
    
' Logon Result
'------------------------------
    Private Sub RecvLogonResponse2()
        Select Case Packet(Index).GetDWORD()
            Case &H0
                Funct.AddChat CtrlIndex, vbGreen, BNET_LOG_PASS
                'If Profiles(ProfileIndex).ProductID = "D2DV" Or _
                '    Profiles(ProfileIndex).ProductID = "D2XP" Then
                '        SendQueryRealms2
                'End If
                
                If (Len(Profiles(ProfileIndex).Email2) > 0) And _
                    (Len(Profiles(ProfileIndex).Email) > 0) Then
                    SendChangeEmail
                End If
                
                SendEnterChat
            Case &H1
                SendCreateAccount2
            Case &H2
                Funct.AddChat CtrlIndex, vbRed, BNET_LOG_FAIL_INCORRECTPW: Disconnect
            Case Else
                Funct.AddChat CtrlIndex, vbRed, BNET_LOG_FAIL_UNKNOWN: Disconnect
        End Select
    End Sub
    
    Public Sub SendQueryRealms2()
        Packet(Index).SendPacket SID_QUERYREALMS2
    End Sub
    
    Private Sub RecvQueryRealms2()
        Funct.AddChat CtrlIndex, vbYellow, "Available Realms:"
        Dim Count As Long
        Dim F As Form, G As Form, Found As Boolean
        Dim X As Integer
        For Each F In Forms
            If F.Name = "frmSelectRealm" Then
                If F.CtrlIndex = CtrlIndex Then
                    Set G = F: Found = True
                End If
            End If
        Next F
        
        If Found = False Then Set G = New frmSelectRealm
        
        G.CtrlIndex = CtrlIndex
        G.PacketIndex = Index
        G.Caption = "Select Realm [" & Profiles(ProfileIndex).ProfileName & "]"
        For X = 1 To 5
            G.lblServer(X - 1).Caption = vbNullString
            G.lblServer(X - 1).ForeColor = vbBlue
        Next X
        
        With Packet(Index)
            .Skip 4
            For X = 0 To .GetDWORD() - 1
                .Skip 4
                Dim Realm As String, RealmD As String
                Realm = .GetCString
                RealmD = .GetCString
                G.lblServer(X).Caption = Realm
                G.lblTitle.Caption = RealmD
                Funct.AddChat CtrlIndex, vbWhite, Realm, vbYellow, " - " & RealmD
            Next X
            G.Show
        End With
    End Sub
    
    Private Sub RecvSetEmail()
        Funct.AddChat CtrlIndex, vbYellow, "BNET: Registering account to email address..."
        If Len(Profiles(ProfileIndex).Email) > 0 Then
            Packet(Index).InsertCString Profiles(ProfileIndex).Email
            Packet(Index).SendPacket SID_SETEMAIL
            Funct.AddChat CtrlIndex, vbGreen, "BNET: Account has been registered to " & Profiles(ProfileIndex).Email
        Else
            Funct.AddChat CtrlIndex, vbRed, "BNET: Email address requested, but none was given at this point."
        End If
    End Sub
    
    
'################################################################
'
' NEW LOGIN SYSTEM + WARCRAFT 3 AUTH
'________________________________________________________________
'################################################################

    Private Sub SendAuthInfo()
        frmMain.wsBnet(CtrlIndex).SendData Chr$(&H1)
        With Packet(Index)
            .InsertDWORD 0
            .InsertDWORD ARCH_IX86
            .InsertString StrReverse(Profiles(ProfileIndex).ProductID)
            .InsertDWORD Val(Profiles(ProfileIndex).ProductByte)
            .InsertDWORD 0
            .InsertDWORD 0
            .InsertDWORD 0
            .InsertDWORD 0
            .InsertDWORD 0
            .InsertCString "AUS"
            .InsertCString "Australia"
            .SendPacket SID_AUTH_INFO
            
            Dim X As Long
            If Profiles(ProfileIndex).Ping = PING_LOW Then
                For X = 1 To 710
                    .SendPacket SID_NULL
                Next X
            ElseIf Profiles(ProfileIndex).Ping = PING_HIGH Then
                For X = 1 To 99999
                    .SendPacket SID_NULL
                Next X
            ElseIf Profiles(ProfileIndex).Ping = PING_NEGATIVE Then
                Exit Sub
            End If
            
            .InsertDWORD 0
            .SendPacket SID_PING
        End With
    End Sub

    Private Sub RecvAuthInfo()
        Dim mpqNumber As Long, ChecksumFormula As String
        Dim EXEVersion As Long, Checksum As Long, ExeInfo As String
        Dim HashFiles(2) As String
        Dim NumCdkeys As Long
        Dim KeyDecoder As Long ' key KeyDecoder handle
        Dim KeyHash As String, HashLength As Long
        Dim ServerSignature As String * 128
        Dim strProduct As String, strCdkey As String, strCdkey2 As String
        strProduct = Profiles(ProfileIndex).ProductID
        strCdkey = Profiles(ProfileIndex).Cdkey1
        strCdkey2 = Profiles(ProfileIndex).Cdkey2

        Select Case Packet(Index).GetDWORD
            Case 0: NLSused = False
            Case 2: NLSused = True
            Case Else
                Funct.AddChat CtrlIndex, vbRed, BNET_LOG_FAIL_UNSUPPORTED
                Exit Sub
        End Select
        
        ClientToken = GetTickCount()
        ServerToken = Packet(Index).GetDWORD()
        Packet(Index).Skip 12
        
        mpqNumber = extractMPQNumber(Packet(Index).GetCString())
        If (mpqNumber < 0) Then: _
            Funct.AddChat CtrlIndex, vbRed, BNET_MPQ_UNKNOWN: Disconnect: Exit Sub
    
        Funct.AddChat CtrlIndex, vbGreen, BNET_MPQ_EXTRACTED
    
        ChecksumFormula = Packet(Index).GetCString()
        
        If (NLSused) Then
            ServerSignature = Packet(Index).GetString(128)
            If (Not nls_check_wsBnet_signature(frmMain.wsBnet(CtrlIndex).SocketHandle, ServerSignature)) Then: _
                Funct.AddChat CtrlIndex, vbRed, BNET_SS_FAIL: Disconnect: Exit Sub
            Funct.AddChat CtrlIndex, vbGreen, BNET_SS_PASS
        End If
        
        
        GetHashFiles ProfileIndex, strProduct, HashFiles(), NumCdkeys
        
        If Not checkRevision(ChecksumFormula, HashFiles(0), HashFiles(1), HashFiles(2), mpqNumber, Checksum) Then: _
            Funct.AddChat CtrlIndex, vbRed, BNET_CHECKREV_FAIL: Disconnect: Exit Sub
        
        Funct.AddChat CtrlIndex, vbGreen, BNET_CHECKREV_PASS
        
        EXEVersion = getExeInfo(HashFiles(0), ExeInfo)
        If (EXEVersion = 0) Then: _
            Funct.AddChat CtrlIndex, vbRed, BNET_EXE_FAIL: Disconnect: Exit Sub

        Funct.AddChat CtrlIndex, vbGreen, BNET_EXE_PASS
        
        With Packet(Index)
            KeyDecoder = kd_create(strCdkey, Len(strCdkey))
            If (KeyDecoder = -1) Then: _
                Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_DECODE: Disconnect: Exit Sub
            
            Funct.AddChat CtrlIndex, vbGreen, BNET_CDKEY_PASS_DECODE

            HashLength = kd_calculateHash(KeyDecoder, ClientToken, ServerToken)
            If (HashLength = 0) Then: _
                Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_HASH: Disconnect: Exit Sub

            Funct.AddChat CtrlIndex, vbGreen, BNET_CDKEY_PASS_HASH
            
            If (kd_isValid(KeyDecoder) = 0) Then: _
                Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_INSTALL: Disconnect: Exit Sub

            Funct.AddChat CtrlIndex, vbGreen, BNET_CDKEY_PASS_INSTALL
            
            KeyHash = String$(HashLength, vbNullChar)
            Call kd_getHash(KeyDecoder, KeyHash)
            
            .InsertDWORD ClientToken
            .InsertDWORD EXEVersion
            .InsertDWORD Checksum
            .InsertDWORD NumCdkeys
            .InsertDWORD 0
            .InsertDWORD Len(strCdkey)
            .InsertDWORD kd_product(KeyDecoder)
            .InsertDWORD kd_val1(KeyDecoder)
            .InsertDWORD 0
            .InsertString KeyHash
            
            Call kd_free(KeyDecoder)
            
            If NumCdkeys = 2 Then
                KeyDecoder = kd_create(strCdkey2, Len(strCdkey2))
                If (KeyDecoder = -1) Then: _
                    Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_DECODE_EX: Disconnect: Exit Sub
                
                Funct.AddChat CtrlIndex, vbGreen, BNET_CDKEY_PASS_DECODE_EX
            
                HashLength = kd_calculateHash(KeyDecoder, ClientToken, ServerToken)
                If (HashLength = 0) Then: _
                    Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_HASH_EX: Disconnect: Exit Sub
                    
                Funct.AddChat CtrlIndex, vbGreen, BNET_CDKEY_PASS_HASH_EX
                
                If (kd_isValid(KeyDecoder) = 0) Then: _
                    Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_INSTALL_EX: Disconnect: Exit Sub
                
                Funct.AddChat CtrlIndex, vbGreen, BNET_CDKEY_PASS_INSTALL_EX
                
                KeyHash = String$(HashLength, vbNullChar) ' Initialize buffer.
                Call kd_getHash(KeyDecoder, KeyHash)
                
                .InsertDWORD Len(strCdkey2)
                .InsertDWORD kd_product(KeyDecoder)
                .InsertDWORD kd_val1(KeyDecoder)
                .InsertDWORD 0
                .InsertString KeyHash
                
                Call kd_free(KeyDecoder)
            End If
            
            .InsertCString ExeInfo
            .InsertCString "MirageChat"
            
            .SendPacket SID_AUTH_CHECK
        End With
    End Sub

    Private Sub RecvAuthCheck()
        Dim strTmp As String
        Select Case Packet(Index).GetDWORD() 'Result
            Case &H0
                Funct.AddChat CtrlIndex, vbGreen, BNET_LOG_PASS_AUTHCHECK
                If Val(GetINI(Profiles(ProfileIndex).ProfilePath, "Config", "ChangePassword")) = 1 Then
                    If NLSused Then
                        SendAuthAccountChange
                    Else
                        SendChangePassword
                    End If
                    Exit Sub
                End If
                If NLSused Then
                    SendAuthAccountLogon
                Else
                    SendLogonResponse2
                End If
                Exit Sub
            Case &H100
                Funct.AddChat CtrlIndex, vbRed, BNET_VER_OUTDATED: Disconnect: Exit Sub
            Case &H101
                Funct.AddChat CtrlIndex, vbRed, BNET_VER_INVALID: Disconnect: Exit Sub
            Case &H200
                Profiles(ProfileIndex).CdkeyStatus = "Invalid"
                Profiles(ProfileIndex).CdkeyStatusIndicator = 3
                Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_INVALID: Disconnect
            Case &H201
                Profiles(ProfileIndex).CdkeyStatus = "Used"
                Profiles(ProfileIndex).CdkeyStatusIndicator = 3
                strTmp = Packet(Index).GetCString()
                If LenB(strTmp) > 0 Then
                    Funct.AddChat CtrlIndex, vbRed, "BNET: Failed... Cdkey is in use by " & strTmp & ".": Disconnect
                Else
                    Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_USED: Disconnect
                End If
            Case &H202
                Profiles(ProfileIndex).CdkeyStatus = "Banned"
                Profiles(ProfileIndex).CdkeyStatusIndicator = 3
                Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_BANNED: Disconnect
            Case &H203
                Profiles(ProfileIndex).CdkeyStatus = "Incorrect Product"
                Profiles(ProfileIndex).CdkeyStatusIndicator = 3
                Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_PRODUCT: Disconnect
            Case &H210
                Profiles(ProfileIndex).CdkeyStatus = "Invalid Exp"
                Profiles(ProfileIndex).CdkeyStatusIndicator = 3
                Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_INVALID_EX: Disconnect
            Case &H211
                Profiles(ProfileIndex).CdkeyStatus = "Used Exp"
                Profiles(ProfileIndex).CdkeyStatusIndicator = 3
                strTmp = Packet(Index).GetCString()
                If LenB(strTmp) > 0 Then
                    Funct.AddChat CtrlIndex, vbRed, "BNET: Failed... Expansion cdkey is in use by " & strTmp & ".": Disconnect
                Else
                    Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_USED_EX: Disconnect
                End If
            Case &H212
                Profiles(ProfileIndex).CdkeyStatus = "Banned Exp"
                Profiles(ProfileIndex).CdkeyStatusIndicator = 3
                Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_BANNED_EX: Disconnect
            Case &H213
                Profiles(ProfileIndex).CdkeyStatus = "Incorrect Exp Product"
                Profiles(ProfileIndex).CdkeyStatusIndicator = 3
                Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_PRODUCT_EX: Disconnect
            Case Else
                Profiles(ProfileIndex).CdkeyStatus = "Unknown"
                Profiles(ProfileIndex).CdkeyStatusIndicator = 3
                Funct.AddChat CtrlIndex, vbRed, BNET_CDKEY_FAIL_UNKNOWN: Disconnect
        End Select
        
        Dim Temp As String, Cdkey As String
        Temp = GetINI(StatPath, "Cdkeys", Profiles(ProfileIndex).Cdkey1)
        If Profiles(ProfileIndex).ProductID = "D2XP" Or Profiles(ProfileIndex).ProductID = "W3XP" Then
            Cdkey = Profiles(ProfileIndex).Cdkey2
        Else
            Cdkey = Profiles(ProfileIndex).Cdkey1
        End If
        If InStr(Temp, " ") > 0 Then
            Dim Splt() As String
            Splt() = Split(Temp, " ")
            Call WriteINI(StatPath, "Cdkeys", Cdkey, Val(Splt(0)) + 1 & " " & Profiles(ProfileIndex).CdkeyStatus & " " & Profiles(ProfileIndex).ProductID)
        Else
            Call WriteINI(StatPath, "Cdkeys", Cdkey, "1 " & Profiles(ProfileIndex).CdkeyStatus & " " & Profiles(ProfileIndex).ProductID)
        End If
    End Sub

    Private Sub SendAuthAccountLogon()
        Dim Var_A As String * 32
        If (NLS = 0) Then
            NLS = nls_init(Profiles(ProfileIndex).Username, Profiles(ProfileIndex).Password)
            If (NLS = 0) Then _
                Funct.AddChat CtrlIndex, vbRed, BNET_NLS_FAIL: Disconnect: Exit Sub
        End If
        
        ' Retrieve "public ephermeral value" (A).
        Call nls_get_A(NLS, Var_A)
        
        ' Build Packet(index).
        Packet(Index).InsertString Var_A
        Packet(Index).InsertCString Profiles(ProfileIndex).Username
        Packet(Index).SendPacket SID_AUTH_ACCOUNTLOGON
    End Sub
    
' Recv Logon result
'------------------------------
    Private Sub RecvAuthAccountLogon()
        Dim M1 As String * 20
        Dim Salt As String, Var_B As String
    
        Select Case Packet(Index).GetDWORD()
            Case 0 ' Logon accepted
                Salt = Packet(Index).GetString(32)
                Var_B = Packet(Index).GetString(32)
                Call nls_get_M1(NLS, M1, Var_B, Salt)

                Packet(Index).InsertString M1
                Packet(Index).SendPacket SID_AUTH_ACCOUNTLOGONPROOF
                Funct.AddChat CtrlIndex, vbGreen, BNET_LOG_PASS_ACCEPT
            Case 1 ' Account doesn't exist.
                SendAuthAccountCreate
            Case 5 ' Account requires upgrade.
                Funct.AddChat CtrlIndex, vbRed, BNET_LOG_FAIL_UPGRADE: Disconnect
            Case Else
                Funct.AddChat CtrlIndex, vbRed, BNET_LOG_FAIL_UNKNOWN: Disconnect
        End Select
    End Sub
    
    Private Sub SendAuthAccountCreate()
        Dim Buffer As String, BufLen As Long
        BufLen = 65 + Len(Profiles(ProfileIndex).Username)
        Buffer = String$(BufLen, vbNullChar)
        If (nls_account_create(NLS, Buffer, BufLen) = 0) Then _
            Funct.AddChat CtrlIndex, vbRed, BNET_LOG_FAIL_GENERATE_CREATE: Disconnect: Exit Sub
        Packet(Index).InsertString Buffer
        Packet(Index).SendPacket SID_AUTH_ACCOUNTCREATE
    End Sub
    
    Private Sub SendAuthAccountChange()
        Dim a As String * 32
        NLS = nls_init(Profiles(ProfileIndex).Username, Profiles(ProfileIndex).Password)
        If (NLS = 0) Then _
            Funct.AddChat CtrlIndex, vbRed, BNET_NLS_FAIL: Disconnect: Exit Sub
        
        Call nls_get_A(NLS, a)
        With Packet(Index)
            .InsertString a
            .InsertCString Profiles(ProfileIndex).Username
            .SendPacket SID_AUTH_ACCOUNTCHANGE
        End With
    End Sub
    
    Private Sub RecvAuthAccountChange()
        Dim ServerKey As String, Salt As String, NewPW As String
        Dim NewNLS As Long, OutputBuffer As String * 84
        
        With Packet(Index)
            Select Case .GetDWORD()
                Case &H0
                    Salt = .GetString(32)
                    ServerKey = .GetString(32)
                    
                    NewPW = Profiles(ProfileIndex).Password2
                    NewNLS = nls_account_change_proof(NLS, OutputBuffer, NewPW, ServerKey, Salt)
                    
                    If (NewNLS = 0) Then _
                        Funct.AddChat CtrlIndex, vbRed, BNET_LOG_FAIL_GENERATE_CHANGEPW: Disconnect: Exit Sub
                    
                    Funct.AddChat CtrlIndex, vbGreen, BNET_LOG_PASS_CHANGE
                    
                    NLSold = NLS
                    NLS = NewNLS
                    
                    .InsertString OutputBuffer
                    .SendPacket SID_AUTH_ACCOUNTCHANGEPROOF
                Case &H1
                    Funct.AddChat CtrlIndex, vbRed, BNET_LOG_FAIL_EXIST: Disconnect: Exit Sub
                Case &H5
                    Funct.AddChat CtrlIndex, vbRed, BNET_LOG_FAIL_UPGRADE: Disconnect: Exit Sub
                Case Else
                    Funct.AddChat CtrlIndex, vbRed, BNET_LOG_FAIL_UNKNOWN: Disconnect: Exit Sub
            End Select
        End With
    End Sub
    
    Private Sub RecvAuthAccountChangeProof()
        Dim M2 As String
        With Packet(Index)
            Select Case .GetDWORD()
                Case &H0
                    ' Check server password proof.
                    M2 = .GetString(20)
                    If (nls_check_M2(NLSold, M2, vbNullString, vbNullString) = 0) Then
                        Funct.AddChat CtrlIndex, vbRed, BNET_LOG_FAIL_PWPROOF: Disconnect: Exit Sub
                    End If
                    
                    ' Free NLS memory for old password.
                    Call nls_free(NLSold)
                    NLSold = 0
                    Funct.AddChat CtrlIndex, vbGreen, BNET_LOG_PASS_CHANGED
                    
                    With Profiles(ProfileIndex)
                        WriteINI .ProfilePath, "Config", "Password", .Password2
                        WriteINI .ProfilePath, "Config", "Password2", vbNullString
                        WriteINI .ProfilePath, "Config", "ChangePassword", "0"
                        .Password = .Password2
                        .Password2 = vbNullString
                    End With
                    SendAuthAccountLogon
                Case &H2
                    Funct.AddChat CtrlIndex, vbGreen, BNET_LOG_FAIL_INCORRECTPW: Disconnect: Exit Sub
                Case Else
                    Funct.AddChat CtrlIndex, vbGreen, BNET_LOG_FAIL_UNKNOWN: Disconnect: Exit Sub
            End Select
        End With
    End Sub

    Private Sub RecvAuthAccountCreate()
        Select Case Packet(Index).GetDWORD()
            Case 0
                Funct.AddChat CtrlIndex, vbGreen, BNET_LOG_PASS_CREATE
                SendAuthAccountLogon
            Case 7, 8, 9, &HA, &HB, &HC
                Disconnect
                Funct.AddChat CtrlIndex, vbRed, "BNET: Invalid username."
            Case Else
                Disconnect
                Funct.AddChat CtrlIndex, vbRed, "BNET: Account already exists."
        End Select
    End Sub
    
    Private Sub RecvAuthAccountLogonProof()
        Dim M2 As String
        Select Case Packet(Index).GetDWORD()
            Case 0
                M2 = Packet(Index).GetString(20)
                If (nls_check_M2(NLS, M2, vbNullString, vbNullString) = 0) Then
                    Funct.AddChat CtrlIndex, vbRed, BNET_LOG_FAIL_PWPROOF: Disconnect: Exit Sub
                End If
                Funct.AddChat CtrlIndex, vbGreen, BNET_LOG_PASS_PWPROOF
                FreeNLS
                
                If (Len(Profiles(ProfileIndex).Email2) > 0) And _
                    (Len(Profiles(ProfileIndex).Email) > 0) Then
                    SendChangeEmail
                End If
                
                SendEnterChat
            Case 2
                Funct.AddChat CtrlIndex, vbRed, BNET_LOG_FAIL_INCORRECTPW: Disconnect
            Case &HE
                SendEnterChat
            Case Else
                Funct.AddChat CtrlIndex, vbRed, BNET_LOG_FAIL_UNKNOWN: Disconnect
        End Select
    End Sub
    
    
'################################################################
'
' USER/CHANNEL EVENTS BELOW (RELATED TO 0xFF)
'________________________________________________________________
'################################################################

    Private Sub RecvChatEvent()
        Dim Username As String, Message As String, _
            Flags As Long, Ping As Long, EventID As Long, _
            Server As String, Channel As String, RealUsername As String
            
            With Packet(Index)
                EventID = .GetDWORD()
                Flags = .GetDWORD()
                Ping = .GetDWORD(): .SetPos 29
                Username = .GetCString()
                Message = .GetCString()
                RealUsername = Username
                
                If InStr(Username, "*") > 0 Then Username = Split(Username, "*")(1)
            End With
            
            Select Case EventID
                Case EID_CHANNEL: EventChannel Message, Flags: Profiles(ProfileIndex).LastEvent = GetTickCount()
                Case EID_WHISPER: EventWhisper Username, Ping, Flags, Message, RealUsername: Profiles(ProfileIndex).LastEvent = GetTickCount(): Profiles(ProfileIndex).LastWspFrom = RealUsername
                Case EID_WHISPERSENT: EventWhisperTo Username, Ping, Flags, Message, RealUsername: Profiles(ProfileIndex).LastWspTo = RealUsername
                Case EID_TALK: EventUserTalk Username, Ping, Flags, Message: Profiles(ProfileIndex).LastEvent = GetTickCount()
                Case EID_EMOTE: EventUserEmote Username, Ping, Flags, Message: Profiles(ProfileIndex).LastEvent = GetTickCount()
                Case EID_USERFLAGS: EventUserFlags Username, RealUsername, Ping, Flags, Message
                Case EID_LEAVE: EventUserLeave Username
                Case EID_INFO, EID_BROADCAST, EID_ERROR: EventInfo EventID, Message
                Case EID_JOIN, EID_SHOWUSER: EventUserJoin EventID, Username, RealUsername, Ping, Flags, Message
            End Select
    End Sub
    
    Private Sub EventChannel(ByVal Message As String, ByVal Flags As Long)
        Dim Value As Integer
        Value = Val(GetINI(StatPath, "Channels", Message & " / " & getServerName(Profiles(ProfileIndex).Server)))
        Call WriteINI(StatPath, "Channels", Message & " / " & getServerName(Profiles(ProfileIndex).Server), (Value + 1) & "")
        
        lUsers(Index).Clear
        frmMain.lvUsers.ListItems.Clear
        Profiles(ProfileIndex).CurrentChannel = Message
        Profiles(ProfileIndex).CurrentChannelFlags = Flags
        Funct.AddChat CtrlIndex, vbGreen, "Joined " & GetChannelFlags(Flags) & " Channel: ", vbWhite, Message
        On Error Resume Next
        frmMain.tbsProfiles.Tabs.Item(TabIndex(CtrlIndex)).ToolTipText = "Online in Channel: " & Message

        Call frmMain.scSupport.Run("Event_Channel", ProfileIndex, Message, Flags)
        Call frmMain.RefreshTabs
    End Sub
        
    Private Sub EventUserLeave(ByVal Username As String)
        Dim DontShow As Boolean
        lUsers(Index).lIndex = lUsers(Index).GetIndexByName(Username)
        
        ' Check flood filters
            If Val(GetINI(PrefPath, "Settings", "AutoFilterFlood")) = "1" Then
                lUsers(Index).lIndex = lUsers(Index).GetIndexByName(Username)
                If (GetTickCount - lUsers(Index).JoinTime) < 900 Then DontShow = True
            End If
            
        ' Check join leave filters
            If Val(GetINI(PrefPath, "Settings", "JoinLeave")) = "1" Then DontShow = True
        
        ' Remove user
            lUsers(Index).DelUser Username
            If (ProfileIndex = Active) And (Val(frmMain.tbsProfiles.SelectedTab.Tag) <> 0) Then DelUserListIndex ProfileIndex, Username
            'frmMain.lvUsers.Refresh

        ' Display if allowed
            If Not DontShow Then: _
                Funct.AddChat CtrlIndex, vbGreen, Username & " has left the channel."
        
        Call frmMain.scSupport.Run("Event_UserLeave", ProfileIndex, Username)
    End Sub
    
    Private Sub EventUserFlags(ByVal Username As String, ByVal RealName As String, ByVal Ping As Long, _
        ByVal Flags As Long, ByVal Statstring As String)
        Dim OldIndex As Integer, UserColor As Long
        
        With lUsers(Index)
            .lIndex = .GetIndexByName(Username)
            If .lIndex = 0 Then
                .AddUser Username, RealName, Flags, Ping, Statstring
                If (Flags And &H2) = &H2 Then
                    With frmMain.lvUsers.ListItems.Add(1, , Username, , GetClientIcon(Statstring, Flags))
                        .ListSubItems.Add(, , , GetPingIcon(Ping, Flags)).Tag = Statstring
                        .ForeColor = RGB(&HE0, &HE0, &HE0)
                        .Tag = RealName
                    End With
                Else
                    With frmMain.lvUsers.ListItems.Add(, , Username, , GetClientIcon(Statstring, Flags))
                        .ListSubItems.Add(, , , GetPingIcon(Ping, Flags)).Tag = Statstring
                        .ForeColor = RGB(&HE0, &HE0, &HE0)
                        .Tag = RealName
                    End With
                End If
                If (Flags And FL_IGNORE) = FL_IGNORE Then
                    UserColor = vbRed
                ElseIf (Flags And FL_OPS) = FL_OPS Then
                    UserColor = vbCyan
                Else
                    UserColor = vbYellow
                End If
                Funct.AddChat CtrlIndex, vbWhite, "** Invisible user ", UserColor, Username, vbWhite, " has been detected. **"
            End If
        End With
        
        ' Check user update.
            If lUsers(Index).Flags <> Flags Then
                If (Flags And FL_IGNORE) = FL_IGNORE Then
                    UserColor = vbRed
                ElseIf (Flags And FL_OPS) = FL_OPS Then
                    UserColor = vbCyan
                Else
                    UserColor = vbYellow
                End If
                Funct.AddChat CtrlIndex, vbYellow, "** User update: ", UserColor, Username, vbYellow, " now has flags " & Flags & " (" & FlagsToString(Flags) & "). **"
            End If
            
            With lUsers(Index)
                .Flags = Flags
                .Statstring = Statstring
            End With
            
        ' Update list item if active profile
            If (ProfileIndex = Active) And (Val(frmMain.tbsProfiles.SelectedTab.Tag) <> 0) Then
                OldIndex = GetUserListIndex(ProfileIndex, Username)
                If (OldIndex > 0) Then
                    frmMain.lvUsers.ListItems.Remove OldIndex
                    If (Flags And &H2) = &H2 Then OldIndex = 1
                End If
                If (InStr(Username, "#") > 0) And _
                    Val(GetINI(PrefPath, "Settings", "ShowNumbered")) = 0 Then GoTo SkipUpdate:
                If (Ping > 600) And _
                    Val(GetINI(PrefPath, "Settings", "ShowHighPing")) = 0 Then GoTo SkipUpdate:
                If (Flags And &H2) = &H2 And _
                    Val(GetINI(PrefPath, "Settings", "ShowModerator")) = 0 Then GoTo SkipUpdate:
                
                With frmMain.lvUsers.ListItems.Add(OldIndex, , Username, , GetClientIcon(Statstring, Flags))
                    .ListSubItems.Add(, , , GetPingIcon(Ping, Flags)).Tag = Statstring
                    .Tag = RealName
                End With
SkipUpdate:
            End If
        Call frmMain.scSupport.Run("Event_UserFlags", ProfileIndex, Username, Flags, Ping, Statstring)
    End Sub
    
    Private Sub EventUserJoin(ByVal EventID As Long, ByVal Username As String, ByVal RealUsername As String, ByVal Ping As Long, _
        ByVal Flags As Long, ByVal Statstring As String)
        Dim DontShow As Boolean
        If EventID = EID_JOIN Then
            JoinCounters(3) = JoinCounters(2)
            JoinCounters(2) = JoinCounters(1)
            JoinCounters(1) = GetTickCount()
        End If

        ' Add user to list/database
            lUsers(Index).AddUser Username, RealUsername, Flags, Ping, Statstring
            
            If (ProfileIndex = Active) And (Val(frmMain.tbsProfiles.SelectedTab.Tag) <> 0) Then
                If (InStr(Username, "#") > 0) And _
                    Val(GetINI(PrefPath, "Settings", "ShowNumbered")) = 0 Then GoTo SkipJoinAdd:
                If (Ping > 600) And _
                    Val(GetINI(PrefPath, "Settings", "ShowHighPing")) = 0 Then GoTo SkipJoinAdd:
                If (Flags And &H2) = &H2 And _
                    Val(GetINI(PrefPath, "Settings", "ShowModerator")) = 1 Then GoTo SkipJoinAdd:
                
                If (Flags And &H2) = &H2 Then
                    'If Val(GetINI(PrefPath, "Settings", "ShowModerator")) = 1 Then
                        With frmMain.lvUsers.ListItems.Add(1, , Username, , GetClientIcon(Statstring, Flags))
                            .ListSubItems.Add(, , , GetPingIcon(Ping, Flags)).Tag = Statstring
                            .Tag = RealUsername
                        End With
                    'End If
                Else
                    With frmMain.lvUsers.ListItems.Add(, , Username, , GetClientIcon(Statstring, Flags))
                        .ListSubItems.Add(, , , GetPingIcon(Ping, Flags)).Tag = Statstring
                        .Tag = RealUsername
                        Dim strUserString As String
                        strUserString = GetUserString(Username)
                        If InStr(strUserString, ";") > 0 Then
                            .ForeColor = IIf(Val(Split(strUserString, ";")(0)) <> 0, Val(Split(strUserString, ";")(0)), vbWhite)
                            .Bold = IIf(Val(Split(strUserString, ";")(1)) = 1, True, False)
                        End If
                    End With
                End If
SkipJoinAdd:
            End If
        
        ' Check join leave filters
            If Val(GetINI(PrefPath, "Settings", "JoinLeave")) = "1" Then DontShow = True
            
        ' Display if allowed join event
            If (EventID = EID_JOIN) And (Not DontShow) Then
                Funct.AddChat CtrlIndex, vbGreen, Username & " has joined the channel."
                Call frmMain.scSupport.Run("Event_UserJoin", ProfileIndex, Username, Flags, Ping, Statstring)
            ElseIf (EventID = EID_SHOWUSER) Then
                Call frmMain.scSupport.Run("Event_UserHere", ProfileIndex, Username, Flags, Ping, Statstring)
            End If
        
        ' Fail-safe (stops list being erased by other profile connecting)
            If (Username = Profiles(ProfileIndex).CurrentUsername) And (Val(frmMain.tbsProfiles.SelectedTab.Tag) <> 0) Then
                Profiles(ProfileIndex).CurrentPing = Ping
                Profiles(ProfileIndex).CurrentFlags = Flags
                DisplayList All, Active
                
                Dim Value As Integer, Temp As String
                If Profiles(ProfileIndex).Ping = 0 Then
                    Temp = GetINI(StatPath, "Servers", "LowPingNoSpoof")
                    If InStr(Temp, " ") > 0 Then Temp = Split(Temp, " ")(0)
                    Value = Val(Temp)
                    If Ping < Value Or Value = 0 Then Call WriteINI(StatPath, "Servers", "LowPingNoSpoof", Ping & " milliseconds on " & getServerName(Profiles(ProfileIndex).Server))
                End If
                If Ping > 0 Then
                    Temp = GetINI(StatPath, "Servers", "LowPing")
                    If InStr(Temp, " ") > 0 Then Temp = Split(Temp, " ")(0)
                    Value = Val(Temp)
                    If Ping < Value Or Value = 0 Then Call WriteINI(StatPath, "Servers", "LowPing", Ping & " milliseconds on " & getServerName(Profiles(ProfileIndex).Server))
                    Temp = GetINI(StatPath, "Servers", "HighPing")
                    If InStr(Temp, " ") > 0 Then Temp = Split(Temp, " ")(0)
                    Value = Val(Temp)
                    If Ping > Value Then Call WriteINI(StatPath, "Servers", "HighPing", Ping & " milliseconds on " & getServerName(Profiles(ProfileIndex).Server))
                End If
            End If
    End Sub
    
    Private Sub EventCommand(ByVal Username As String, ByVal Message As String, Optional ByVal Whispered As Boolean)
        On Error Resume Next
        Dim Splt() As String
        Dim Response As String
        Splt() = Split(Message, " ", 2)
        Dim ws As String
        If Whispered Then ws = "/w " & Username & " "
        
        Select Case LCase$(Splt(0))
            Case "say", "echo"
                If UBound(Splt()) = 1 Then SendText Splt(1)
            Case "join", "j"
                If UBound(Splt()) = 1 Then SendText "/join " & Splt(1)
            Case "trivia"
                If UBound(Splt()) = 1 Then
                    If LCase$(Splt(1)) = "on" Then
                        TriviaON = True
                        SendText ws & "Trivia [on]"
                        frmMain.tmrTrivia.Enabled = True
                    Else
                        TriviaON = False
                        frmMain.tmrTrivia.Enabled = False
                        SendText ws & "Trivia [off]"
                    End If
                End If
            Case "emote", "me"
                If UBound(Splt()) = 1 Then SendText "/me " & Splt(1)
            Case "ver", "version", "about"
                SendText ws & version()
            Case "bancount", "bans"
                SendText ws & "Ban count since I have been online: " & Profiles(ProfileIndex).BanCount
            Case "8ball", "forsee"
                If UBound(Splt()) = 1 Then
                    Response = GetRndLine(App.Path & "\8Ball.txt")
                    SendText ws & "Magic 8 Ball: " & StrConv(Response, vbProperCase)
                Else
                    SendText ws & "Please specify a question to ask the Magic 8 ball."
                End If
            Case "quote"
                Response = GetRndLine(App.Path & "\Quotes.txt")
                SendText ws & Response
            Case "addquote"
                If UBound(Splt()) = 1 Then
                    Open App.Path & "\Quotes.txt" For Append As #11
                        Print #11, Splt(1)
                    Close #11
                    SendText ws & "Added quote to file."
                Else
                    SendText ws & "Please specify a quote."
                End If
            Case "uptime"
                SendText ws & "Connection Uptime: " & tickToTime(GetTickCount - Profiles(ProfileIndex).ConnectionTime, ddhhmmss_full)
            
            Case "it"
                If UBound(Splt()) = 0 Then
                    If iTunesOpen = 1 Then
                        SendText ws & "iTunes is currently open."
                    Else
                        SendText ws & "iTunes is not open, type 'it open' to open iTunes now."
                    End If
                Else
                    If iTunesOpen = 1 Then
                        If iTunesCanRead = True Then
                            Dim iTunes As Object, CurState As Integer
                            Set iTunes = CreateObject("iTunes.Application")
                            Select Case LCase$(Splt(1))
                                Case "next", "n", ">"
                                    iTunes.NextTrack
                                Case "prev", "p", "<"
                                    iTunes.PreviousTrack
                                Case "stop", "s"
                                    iTunes.Stop
                                Case "play"
                                    iTunes.Play
                                Case "pause", "u"
                                    iTunes.Pause
                                Case "mp3", "m", "title", "track"
                                    SendText ws & "iTunes - Current Track: " & iTunes.CurrentTrack.artist & " - " & iTunes.CurrentTrack.Name
                            End Select
                        Else
                            SendText ws & "iTunes is not readable, please wait for it to finish whatever it is doing."
                        End If
                    ElseIf LCase$(Splt(1)) = "open" Then
                        frmMain.mnuApplication_Click 3
                    Else
                        SendText ws & "iTunes is not open, type 'it open' to open iTunes now."
                    End If
                End If
                
            Case "wa"
                If UBound(Splt()) = 0 Then
                    If winampOpen = 1 Then
                        SendText ws & "Winamp is currently open, Version: " & wa_getWinampVersion()
                    Else
                        SendText ws & "Winamp is not open, type 'wa open' to open Winamp now."
                    End If
                Else
                    If winampOpen = 1 Then
                        Select Case LCase$(Splt(1))
                            Case "next", "n", ">"
                                wa_nextSong
                            Case "prev", "p", "<"
                                wa_prevSong
                            Case "stop", "s"
                                wa_stopSong
                            Case "play"
                                wa_playSong
                            Case "pause", "u"
                                wa_pauseSong
                            Case "mp3", "m", "title", "track"
                                Dim vAlbum As String, vTitle As String, vArtist As String, vYear As String, vAdd As String
                                vAlbum = Space$(256): vTitle = Space$(256): vArtist = Space$(256): vYear = Space$(256)
                                Call wa_getMetaData(vAlbum, vArtist, vTitle, vYear)
                                vAlbum = Trim$(KillNull(vAlbum)): vTitle = Trim$(KillNull(vTitle)): vArtist = Trim$(KillNull(vArtist)): vYear = Trim$(KillNull(vYear))
                                If Len(vAlbum) > 0 And Val(vYear) > 0 Then
                                    vAdd = " (Album: " & vAlbum & ", " & vYear & ")"
                                ElseIf Len(vAlbum) > 0 And Val(vYear) = 0 Then
                                    vAdd = " (Album: " & vAlbum & ")"
                                ElseIf Val(vYear) > 0 Then
                                    vAdd = " (" & vYear & ")"
                                End If
                                SendText ws & "Winamp - Current Track: " & vArtist & " - " & vTitle & vAdd
                        End Select
                    Else
                        If LCase$(Splt(1)) = "open" Then frmMain.mnuApplication_Click 4: Exit Sub
                        SendText ws & "Winamp is not open, type 'wa open' to open Winamp now."
                    End If
                End If
                
            Case "wmp"
                If UBound(Splt()) = 0 Then
                    If WMPlayerOpen = 1 Then
                        SendText ws & "Windows Media Player is currently open."
                    Else
                        SendText ws & "Windows Media Player is not open, type 'wmp open' to open Windows Media Player now."
                    End If
                Else
                    If WMPlayerOpen = 1 Then
                        Select Case LCase$(Splt(1))
                            Case "next", ">", "n"
                                wmp_nextSong
                            Case "prev", "<", "p"
                                wmp_prevSong
                            Case "stop", "s"
                                wmp_stopSong
                            Case "pause", "play", "u"
                                wmp_playPauseSong
                            Case "mp3", "m", "title", "track"
                                SendText ws & "Windows Media Player - Current Track: " & wmp_getWMPTitle
                        End Select
                    Else
                        If LCase$(Splt(1)) = "open" Then frmMain.mnuApplication_Click 5: Exit Sub
                        SendText ws & "Windows Media Player is not open, type 'wmp open' to open Windows Media Player now."
                    End If
                End If
        End Select
        If UBound(Splt()) = 0 Then
            Call frmMain.scSupport.Run("Event_Command", ProfileIndex, Splt(0), "")
        Else
            Call frmMain.scSupport.Run("Event_Command", ProfileIndex, Splt(0), Splt(1))
        End If
    End Sub
    
    Private Sub EventUserTalk(ByVal Username As String, ByVal Ping As Long, _
        ByVal Flags As Long, ByVal Message As String)
        Dim X As Integer, DontShow As Boolean
        
        ' Check flood filters
            If Val(GetINI(PrefPath, "Settings", "AutoFilterFlood")) = "1" Then
                lUsers(Index).lIndex = lUsers(Index).GetIndexByName(Username)
                If (GetTickCount - lUsers(Index).JoinTime) < 900 Then DontShow = True
            End If
            
        ' If allowed display the text.
            If Not DontShow Then
                Funct.AddChat CtrlIndex, vbYellow, "> " & Username & ": ", vbWhite, Message
                
                ' Check commands list...
                If LCase$(Username) = LCase$(Profiles(ProfileIndex).Master) Then
                    If LCase$(Left$(Message, 1)) = LCase$(Profiles(ProfileIndex).Trigger) Then: _
                        EventCommand Username, Mid(Message, 2)
                End If
                
                ' Check if active profile.
                    If (Active <> ProfileIndex) Then
                        If (Profiles(Active).CurrentChannel <> Profiles(ProfileIndex).CurrentChannel) Then: _
                            Profiles(ProfileIndex).IsActive = True
                    End If
                Call frmMain.scSupport.Run("Event_UserTalk", ProfileIndex, Username, Flags, Ping, Message)
            End If
    End Sub
    
    Private Sub EventWhisper(ByVal Username As String, ByVal Ping As Long, _
        ByVal Flags As Long, ByVal Message As String, ByVal RealUsername As String)
        Dim X As Integer, DontShow As Boolean

        ' Check commands list...
        If LCase$(Username) = LCase$(Profiles(ProfileIndex).Master) Then
            If LCase$(Left$(Message, 1)) = LCase$(Profiles(ProfileIndex).Trigger) Then: _
                EventCommand Username, Mid(Message, 2), True
        End If
        
        If Val(GetINI(PrefPath, "Settings", "WhisperWindows")) = 1 Then
            Dim WAR3 As Boolean
            If Profiles(ProfileIndex).ProductID = "WAR3" Or Profiles(ProfileIndex).ProductID = "W3XP" Then: WAR3 = True
            Dim frm As Form, Found As Boolean
            For Each frm In Forms
                If frm.Name = "frmWhisperMgr" Then
                    If frm.ProfileIndex = ProfileIndex Then
                        If LCase$(frm.Server) = LCase$(getServerName(Profiles(ProfileIndex).Server, WAR3)) Then
                            frm.AddChat RealUsername, vbYellow, "> " & Username & ": ", vbWhite, Message
                            Found = True
                            Exit For
                        End If
                    End If
                End If
            Next
        
            If Found = False Then
                Set frm = New frmWhisperMgr
                frm.Show
                frm.Sender = Username
                frm.ProfileIndex = ProfileIndex
                frm.Server = getServerName(Profiles(ProfileIndex).Server, WAR3)
                frm.AddChat RealUsername, vbYellow, "> " & Username & ": ", vbWhite, Message
            End If
        End If
        
        ' Check if active profile.
            If (Active <> ProfileIndex) Then
                If (Profiles(Active).CurrentChannel <> Profiles(ProfileIndex).CurrentChannel) Then
                    Profiles(ProfileIndex).IsActive = True
                End If
            End If
            
        ' Check flood filters
            If Val(GetINI(PrefPath, "Settings", "AutoFilterFlood")) = "1" Then
                lUsers(Index).lIndex = lUsers(Index).GetIndexByName(Username)
                If (GetTickCount - lUsers(Index).JoinTime) < 900 Then DontShow = True
            End If
        
        ' Display if allowed
            If Not DontShow Then: _
                Funct.AddChat CtrlIndex, vbYellow, "<From: " & Username & "> ", RGB(200, 200, 200), Message
        
        Call frmMain.scSupport.Run("Event_UserWhisperFrom", ProfileIndex, Username, Flags, Ping, Message)
    End Sub
    
    Private Sub EventWhisperTo(ByVal Username As String, ByVal Ping As Long, _
        ByVal Flags As Long, ByVal Message As String, ByVal RealUsername As String)
        Funct.AddChat CtrlIndex, vbCyan, "<To: " & Username & "> ", RGB(200, 200, 200), Message
    
        If Val(GetINI(PrefPath, "Settings", "WhisperWindows")) = 1 Then
            Dim WAR3 As Boolean
            If Profiles(ProfileIndex).ProductID = "WAR3" Or Profiles(ProfileIndex).ProductID = "W3XP" Then: WAR3 = True
            Dim frm As Form, Found As Boolean
            For Each frm In Forms
                If frm.Name = "frmWhisperMgr" Then
                    If frm.ProfileIndex = ProfileIndex Then
                        If LCase$(frm.Server) = LCase$(getServerName(Profiles(ProfileIndex).Server, WAR3)) Then
                            frm.AddChat RealUsername, vbCyan, "> " & Username & ": ", vbWhite, Message
                            Found = True
                            Exit For
                        End If
                    End If
                End If
            Next
            
            If Found = False Then
                Set frm = New frmWhisperMgr
                frm.Show
                frm.Sender = Username
                frm.ProfileIndex = ProfileIndex
                frm.Server = getServerName(Profiles(ProfileIndex).Server, WAR3)
                frm.AddChat RealUsername, vbCyan, "> " & Username & ": ", vbWhite, Message
            End If
        End If
        
        Call frmMain.scSupport.Run("Event_UserWhisperTo", ProfileIndex, Username, Flags, Ping, Message)
    End Sub
    
    Private Sub EventUserEmote(ByVal Username As String, ByVal Ping As Long, _
        ByVal Flags As Long, ByVal Message As String)
        Dim X As Integer, DontShow As Boolean
        
        ' Check flood filters
            If Val(GetINI(PrefPath, "Settings", "AutoFilterFlood")) = "1" Then
                lUsers(Index).lIndex = lUsers(Index).GetIndexByName(Username)
                If (GetTickCount - lUsers(Index).JoinTime) < 900 Then DontShow = True
            End If
        
        ' Display if allowed
            If Not DontShow Then: _
                Funct.AddChat CtrlIndex, vbYellow, "* " & Username & " " & Message & " *"
        
        Call frmMain.scSupport.Run("Event_UserTalk", ProfileIndex, Username, Flags, Ping, Message)
    End Sub
    
    Private Sub EventInfo(ByVal EventID As Long, ByVal Message As String)
        Dim DontShow As Boolean
        Select Case EventID
            Case EID_INFO
                If (Message Like "*still marked as being away*") Then
                    If Val(GetINI(Profiles(ProfileIndex).ProfilePath, "Settings", "AutoAway")) = 1 Then SendText "/away"
                ElseIf (Message Like "* was banned by *") Then
                    Profiles(ProfileIndex).BanCount = Profiles(ProfileIndex).BanCount + 1
                    If Val(GetINI(PrefPath, "Settings", "BanUnban")) = 1 Then DontShow = True
                ElseIf (Message Like "* was unbanned by *") Then
                    If Val(GetINI(PrefPath, "Settings", "BanUnban")) = 1 Then DontShow = True
                ElseIf (Message Like "* games: *-*-*") Then
                    Dim Splt() As String: Splt() = Split(Message, " games: ")
                    Funct.AddChat CtrlIndex, vbYellow, "INFO: " & Splt(0) & " games: ", vbWhite, Splt(1)
                    DontShow = True
                ElseIf (Message Like "Added * to your friends list.") Or _
                    (Message Like "Promoted * the top of your friends list.") Or _
                    (Message Like "Demoted * the bottom of your friends list.") Or _
                    (Message Like "Removed * from your friends list.") Then
                    SendFriendsList
                ElseIf (Message Like "* kicked you out of the channel!") Then
                    SendJoinChannel Profiles(ProfileIndex).CurrentChannel
                End If
                If DontShow = False Then Funct.AddChat CtrlIndex, vbYellow, "INFO: " & Message
                
                Call frmMain.scSupport.Run("Event_Info", ProfileIndex, Message)
            Case EID_ERROR
                Funct.AddChat CtrlIndex, vbRed, "ERROR: " & Message
                Call frmMain.scSupport.Run("Event_Error", ProfileIndex, Message)
            Case EID_BROADCAST:
                Funct.AddChat CtrlIndex, vbCyan, "BROADCAST: " & Message
                Call frmMain.scSupport.Run("Event_BroadCast", ProfileIndex, Message)
        End Select
    End Sub
    
'################################################################
'
' WARCRAFT 3 CLAN PACKETS BELOW
'________________________________________________________________
'################################################################

    Public Sub SendClanDisband()
        If Profiles(ProfileIndex).CurrentClanRank = CM_CHEIFTAIN Then
            With Packet(Index)
                .InsertDWORD GetTickCount()
                .SendPacket SID_CLANDISBAND
            End With
            Funct.AddChat CtrlIndex, vbGreen, BNET_CLAN_SENT_DISBAND
        Else
            Funct.AddChat CtrlIndex, vbRed, BNET_CLAN_NOT_CHEIFTAIN
        End If
    End Sub

    Public Sub SendClanMakeCheiftain(ByVal strUsername As String)
        If Profiles(ProfileIndex).CurrentClanRank = CM_CHEIFTAIN Then
            With Packet(Index)
                .InsertDWORD GetTickCount()
                .InsertCString strUsername
                .SendPacket SID_CLANMAKECHIEFTAIN
            End With
            Funct.AddChat CtrlIndex, vbGreen, BNET_CLAN_SENT_NEWCHEIF
        Else
            Funct.AddChat CtrlIndex, vbRed, BNET_CLAN_NOT_CHEIFTAIN
        End If
    End Sub

    Public Sub SendClanRankUpdate(ByVal strUsername As String, bytNewRank As Byte)
        If Profiles(ProfileIndex).CurrentClanRank = CM_CHEIFTAIN Or _
            Profiles(ProfileIndex).CurrentClanRank = CM_SHAMAN Then
            With Packet(Index)
                .InsertDWORD GetTickCount()
                .InsertCString strUsername
                .InsertByte bytNewRank
                .SendPacket SID_CLANRANKUPDATE
            End With
            Funct.AddChat CtrlIndex, vbGreen, BNET_CLAN_SENT_NEWRANK
        Else
            Funct.AddChat CtrlIndex, vbRed, BNET_CLAN_NOT_CHEIFTAINORSHAMAN
        End If
    End Sub
    
    Public Sub SendClanRemove(ByVal strUsername As String)
        If Profiles(ProfileIndex).CurrentClanRank = CM_CHEIFTAIN Or _
            LCase$(strUsername) = LCase$(Profiles(ProfileIndex).CurrentUsername) Then
            With Packet(Index)
                .InsertDWORD GetTickCount()
                .InsertCString strUsername
                .SendPacket SID_CLANREMOVEMEMBER
            End With
            Funct.AddChat CtrlIndex, vbGreen, BNET_CLAN_SENT_REMOVE
        Else
            Funct.AddChat CtrlIndex, vbRed, BNET_CLAN_NOT_CHEIFTAIN
        End If
    End Sub

    Public Sub SendClanSetMOTD(ByVal strMessage As String)
        If Profiles(ProfileIndex).CurrentClanRank = CM_CHEIFTAIN Or _
            Profiles(ProfileIndex).CurrentClanRank = CM_SHAMAN Then
            With Packet(Index)
                .InsertDWORD GetTickCount()
                .InsertCString strMessage
                .SendPacket SID_CLANSETMOTD
            End With
            Funct.AddChat CtrlIndex, vbGreen, BNET_CLAN_SENT_SETMOTD
        Else
            Funct.AddChat CtrlIndex, vbRed, BNET_CLAN_NOT_CHEIFTAINORSHAMAN
        End If
    End Sub
    
    Private Sub RecvClanMotd()
        With Packet(Index)
            .Skip 8
            Profiles(ProfileIndex).CurrentClanMotd = .GetCString
            Funct.AddChat CtrlIndex, vbYellow, "MOTD: " & Profiles(ProfileIndex).CurrentClanMotd
        End With
    End Sub
    
    Public Sub SendClanGetMOTD()
        If Len(Profiles(ProfileIndex).CurrentClanTag) > 0 Then
            With Packet(Index)
                .InsertDWORD GetTickCount()
                .SendPacket SID_CLANMOTD
            End With
            Funct.AddChat CtrlIndex, vbGreen, BNET_CLAN_SENT_MOTD
        Else
            Funct.AddChat CtrlIndex, vbRed, BNET_CLAN_NOT_INACLAN
        End If
    End Sub

    Private Sub RecvClanInfo()
        With Packet(Index)
            .Skip 1
            Profiles(ProfileIndex).CurrentClanTag = KillNull(.GetString(4))
            Profiles(ProfileIndex).CurrentClanRank = .GetByte
            .InsertDWORD GetTickCount
            .SendPacket SID_CLANMEMBERLIST
        End With
    End Sub

    Private Sub RecvClanMemberList()
        lClan(Index).Clear
        Dim Num As Byte, X As Integer
        With Packet(Index)
            .Skip 4
            Num = .GetByte()
            For X = 1 To Num
                lClan(Index).AddUser .GetCString, .GetByte, CBool(Abs(.GetByte))
                .Skip 1
            Next X
        End With
        If (ProfileIndex = Active) And (Val(frmMain.tbsProfiles.SelectedTab.Tag) <> 0) Then DisplayList Clan, Active
    End Sub

'################################################################
'
' MCP PACKETS BELOW
'________________________________________________________________
'################################################################

    Public Sub SendMCPStartup()
        Dim P As Integer
        With Packet(Index)
            frmMain.wsMCP(CtrlIndex).SendData Chr(&H1)
            .InsertDWORD MCP.Cookie
            .InsertDWORD MCP.Status
            .InsertDWORD MCP.Chunk1(1)
            .InsertDWORD MCP.Chunk1(2)
            For P = 1 To 12
                .InsertDWORD MCP.Chunk2(P)
            Next P
            .InsertCString MCP.UniqueName
            .SendMCPPacket MCP_STARTUP
        End With
    End Sub

    Private Sub RecvMCPStartup()
        Select Case Packet(Index).GetDWORD()
            Case 0
                Funct.AddChat CtrlIndex, vbGreen, "MCP: Startup check passed!"
                SendMCPCharList2
            Case &HC
                Funct.AddChat CtrlIndex, vbRed, "MCP: No Battle.net connection detected!"
            Case &H7F
                Funct.AddChat CtrlIndex, vbRed, "MCP: Your connection has been temporarily restricted from this realm. Please try to log in at another time"
        End Select
    End Sub
    
    Public Sub SendMCPCharCreate(ByVal Character As String, ByVal Class As Long, ByVal Flags As Long)
        With Packet(Index)
            .InsertDWORD Class
            .InsertWORD Flags
            .InsertCString Character
            .SendMCPPacket MCP_CHARCREATE
        End With
    End Sub
    
    Public Sub SendMCPCharUpgrade(ByVal Character As String)
        With Packet(Index)
            .InsertCString Character
            .SendMCPPacket MCP_CHARUPGRADE
        End With
    End Sub
    
    Private Sub RecvMCPCharUpgrade()
        Select Case Packet(Index).GetDWORD
            Case 0
                Funct.AddChat CtrlIndex, vbGreen, "MCP: Successfully updated character."
                SendMCPCharList2
            Case &H46
                Funct.AddChat CtrlIndex, vbRed, "MCP: Character not found."
            Case &H7A
                Funct.AddChat CtrlIndex, vbRed, "MCP: Upgrade failed."
            Case &H7B
                Funct.AddChat CtrlIndex, vbRed, "MCP: Character has expired."
            Case &H7C
                Funct.AddChat CtrlIndex, vbRed, "MCP: Already expansion character."
        End Select
    End Sub
    
    Private Sub RecvMCPCharCreate()
        Select Case Packet(Index).GetDWORD
            Case 0
                Funct.AddChat CtrlIndex, vbGreen, "MCP: Successfully created character."
                SendMCPCharList2
            Case &H14
                Funct.AddChat CtrlIndex, vbRed, "MCP: Character already exists, or you already have 8 characters."
            Case &H15
                Funct.AddChat CtrlIndex, vbRed, "MCP: Invalid Character Name"
        End Select
    End Sub
    
    Public Sub SendMCPCharLogon(ByVal Character As String)
        With Packet(Index)
            .InsertCString Character
            .SendMCPPacket MCP_CHARLOGON
        End With
    End Sub
    
    Private Sub RecvMCPCharLogon()
        Select Case Packet(Index).GetDWORD
            Case 0
                Funct.AddChat CtrlIndex, vbGreen, "MCP: Successfully logged into account."
                Dim F As Form
                For Each F In Forms
                    If F.Name = "frmCharacterLogin" Then
                        If F.CtrlIndex = CtrlIndex Then Unload F
                    End If
                Next F
            Case &H46: Funct.AddChat CtrlIndex, vbRed, "MCP: Player not found"
            Case &H7A: Funct.AddChat CtrlIndex, vbRed, "MCP: Logon failed"
            Case &H7B: Funct.AddChat CtrlIndex, vbRed, "MCP: Character expired"
        End Select
    End Sub
    
    Public Sub SendMCPCharDelete(ByVal Character As String)
        With Packet(Index)
            .InsertWORD &H0
            .InsertCString Character
            .SendMCPPacket MCP_CHARDELETE
        End With
    End Sub
    
    Private Sub RecvMCPCharDelete()
        Select Case Packet(Index).GetDWORD
            Case 0
                Funct.AddChat CtrlIndex, vbRed, "MCP: Successfully deleted character."
                SendMCPCharList2
            Case &H49
                Funct.AddChat CtrlIndex, vbRed, "MCP: Character doesn't exist"
        End Select
    End Sub
    
    Private Sub RecvMCPCharList2()
        Dim Count As Long
        Dim F As Form, G As Form, Found As Boolean
        Dim X As Integer
        For Each F In Forms
            If F.Name = "frmCharacterLogin" Then
                If F.CtrlIndex = CtrlIndex Then Set G = F: Found = True
            End If
        Next F
        
        If Found = False Then Set G = New frmCharacterLogin
        
        For X = 1 To 8
            G.lblChar(X - 1).Caption = "Open Character"
            G.lblChar(X - 1).ForeColor = vbBlue
        Next X
        With Packet(Index)
            .Skip 6
            Count = .GetWORD
            For X = 1 To Count
                .Skip 4
                G.lblChar(X - 1).Caption = .GetCString
                .Skip 2
                .SkipCString
            Next X
        End With
        G.Caption = "Select Character [" & Profiles(ProfileIndex).ProfileName & "]"
        G.CtrlIndex = CtrlIndex
        G.PacketIndex = Index
        G.Show
    End Sub
    
    Public Sub SendMCPCharList2()
        With Packet(Index)
            .InsertDWORD 8
            .SendMCPPacket MCP_CHARLIST2
        End With
    End Sub
    
    Public Sub ConnectMCP()
        Packet(Index).ClearOutbound
        Dim IPString As String, PortString As String, P As Integer
        If Len(MCP.IPAddress) > 0 Then
            For P = 1 To 4
                IPString = IPString & Asc(Mid(MCP.IPAddress, P, 1)) & "."
            Next P
        End If
        If Len(IPString) > 0 Then IPString = Left$(IPString, Len(IPString) - 1)
        Funct.AddChat CtrlIndex, vbYellow, "MCP: Connecting to " & IPString & " on port " & ConvertPort(MCP.Port)
        frmMain.wsMCP(CtrlIndex).Close
        frmMain.wsMCP(CtrlIndex).Connect IPString, ConvertPort(MCP.Port)
    End Sub

    Public Sub DisconnectMCP()
        If frmMain.wsMCP(CtrlIndex).State <> sckClosed Then Funct.AddChat CtrlIndex, vbRed, "MCP: Disconnected!"
        frmMain.wsMCP(CtrlIndex).Close
    End Sub


'################################################################
'
' GENERAL FUNCTIONS BELOW
'________________________________________________________________
'################################################################

    Private Sub FreeNLS()
        If (NLS <> 0) Then
            Call nls_free(NLS)
            NLS = 0
        End If
        
        If (NLSold <> 0) Then
            Call nls_free(NLSold)
            NLSold = 0
        End If
    End Sub

    Public Function GetTriviaQuestion() As String
        Dim Response As String
        Response = GetRndLine(App.Path & "\Trivia.txt")
        GetTriviaQuestion = "Unable to get a trivia question."
        TriviaAnswer = vbNullString
        TriviaHint = vbNullString
        TriviaChances = 0
        If Len(Response) > 0 Then
            If InStr(Response, "|") > 0 Then
                GetTriviaQuestion = Split(Response, "|")(0)
                TriviaAnswer = Split(Response, "|")(1)
                TriviaHint = ChrLoop(Asc("-"), Len(TriviaAnswer))
            End If
        End If
    End Function

    Public Property Get JoinCounter(Number As Integer) As Long
        JoinCounter = JoinCounters(Number)
    End Property
    
    Public Sub AddChannel(ByVal Channel As String, Optional ByVal Server As String)
        Dim X As Integer
        For X = 0 To UBound(Profiles(Active).ChannelsLocal)
            If LCase$(Profiles(Active).ChannelsLocal(X)) = LCase$(Channel) Then
                Funct.AddChat CtrlIndex, vbRed, "Channel already exists in list."
                Exit Sub
            End If
        Next X
        
        Open App.Path & "\Channels.db" For Append As #1
            Funct.AddChat CtrlIndex, vbYellow, "Successfully added " & Chr(34) & Channel & Chr(34) & " channel to the list."
            Print #1, Channel & Chr(11) & getServerName(Profiles(ProfileIndex).Server, False)
        Close #1
        LoadChannels Active
        DisplayList Channels, Active
    End Sub

    Private Sub CheckUserStats(ByVal Username As String)
        Dim X As Integer
        For X = 1 To lUsers(Index).Count
            lUsers(Index).lIndex = X
            If LCase$(lUsers(Index).Username) = LCase$(Username) Then
                Funct.AddChat CtrlIndex, vbYellow, "INFO: " & lUsers(Index).Username & "'s information:"
                Funct.AddChat CtrlIndex, vbYellow, "INFO: Flags: ", vbWhite, lUsers(Index).Flags & " (" & FlagsToString(lUsers(Index).Flags) & ")"
                Funct.AddChat CtrlIndex, vbYellow, "INFO: Ping: ", vbWhite, lUsers(Index).Ping & "ms " & PingToString(lUsers(Index).Ping)
                Funct.AddChat CtrlIndex, vbYellow, "INFO: Uptime: ", vbWhite, tickToTime(GetTickCount - lUsers(Index).JoinTime, ddhhmmss)
                Exit For
            End If
        Next X
    End Sub

