Attribute VB_Name = "modSovereign"
Option Explicit

Public Function SovEncode(Text As String) As String()
    Dim i As Integer
    'Convert to Asc()
    Dim encoded As String
    For i = 1 To Len(Text) Step 1
        encoded = encoded & Pad(Asc(Mid(Text, i, 1)), 3)
    Next
    
    'Put into array
    Dim sencoded() As String
    ReDim sencoded(1 To Len(encoded)) As String
    For i = 1 To Len(encoded) Step 1
        If (i Mod 3) = 0 Then
            sencoded(i) = "0"
        Else
            sencoded(i) = Mid(encoded, i, 1)
        End If
    Next
    
    'Randomize
    Randomize
    
    'Shuffle (Public key)
    Dim PublicKeySize As Integer
    PublicKeySize = 20
    Dim pubkey1() As Integer
    Dim pubkey2() As Integer
    ReDim pubkey1(1 To PublicKeySize) As Integer
    ReDim pubkey2(1 To PublicKeySize) As Integer
    
    Dim tmppos As String
    For i = 1 To PublicKeySize Step 1
        'Generate Public key values
        pubkey1(i) = Int(Rnd * (Len(encoded) - 1)) + 1
        pubkey2(i) = Int(Rnd * (Len(encoded) - 1)) + 1
        
        'Shuffle values
        tmppos = sencoded(pubkey1(i))
        sencoded(pubkey1(i)) = sencoded(pubkey2(i))
        sencoded(pubkey2(i)) = tmppos
    Next
    
    'Create Public key
    Dim PublicKey As String
    For i = 1 To PublicKeySize Step 1
        PublicKey = PublicKey & Chr(pubkey1(i) - 1 + 50) & Chr(pubkey2(i) - 1 + 50)
    Next
    
    'Rebuild encoded string
    encoded = ""
    For i = LBound(sencoded) To UBound(sencoded) Step 1
        encoded = encoded & sencoded(i)
    Next
    
    'Convert to Chr()
    Dim encoded2 As String
    For i = 1 To Len(encoded) Step 1
        encoded2 = encoded2 & Chr(Val(Mid(encoded, i, 1)) + 10)
    Next
    
    'Return encoded value
    Dim arReturn(0 To 1) As String
    arReturn(0) = PublicKey
    arReturn(1) = encoded2
    SovEncode = arReturn
End Function

Private Function Pad(Number As String, PadSize As Integer) As String
    Dim tmpNumber As String
    tmpNumber = Number
    
    'Pad the value
    Do Until Len(tmpNumber) >= PadSize
        tmpNumber = "0" & tmpNumber
    Loop
    
    'Return padded value
    Pad = tmpNumber
End Function

