Attribute VB_Name = "modExtension"
Option Explicit

'-----------------------------------------------------
' MirageBot Extensions Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

'// Theme Variables
Public CurrentTheme As String, _
        AlignmentT As String, _
        StretchHeight As Long, _
        ImageStretch As Boolean, _
        PaddingT As Long, _
        PaddingL As Long, _
        PaddingR As Long, _
        PaddingS As Long, _
        PaddingB As Long, _
        PaddingX As Long, _
        IndentL As Long, _
        IndentR As Long, _
        DockBack As Integer, _
        TabBackground As Long, _
        TabForeground As Long, _
        DockOver1 As Integer, _
        DockOver2 As Integer, _
        DockOver3 As Integer, _
        DockOver4 As Integer, _
        DockOver5 As Integer, _
        DockOver6 As Integer, _
        DockOver7 As Integer, _
        DockOver8 As Integer
'// Emoticons

Public Sub ReadCommand(ByVal File As String, ByRef Command As String, ByRef Alias As String, ByRef Parameters As String, ByRef Help As String, ByRef CType As Integer, ByRef Response As String)
    Dim Content As String, Lines() As String, i As Integer, Header As String
    File = AppData & "Commands\Custom Commands\" & File & ".txt"
    Content = ReadFile(File)
    Lines = Split(Content, vbNewLine)
    Command = vbNS
    Alias = vbNS
    Parameters = vbNS
    Help = vbNS
    Response = vbNS
    CType = 0
    
    For i = 0 To UBound(Lines)
        If LenB(Lines(i)) Then
            If Left$(Lines(i), 1) = "[" And Right$(Lines(i), 1) = "]" Then
                Header = LCase$(Lines(i))
            Else
                If Header = "[basic]" Then
                    If InStr(Lines(i), "=") Then
                        Dim Field() As String
                        Field = Split(Lines(i), "=", 2)
                        Select Case UCase$(Field(0))
                        Case "COMMAND"
                            Command = Trim$(Field(1))
                        Case "ALIAS"
                            Alias = Trim$(Field(1))
                        Case "PARAMETERS"
                            Parameters = Trim$(Field(1))
                        Case "HELP"
                            Help = Trim$(Field(1))
                        Case "TYPE"
                            Select Case Field(1)
                            Case 0, 1, 2: CType = Val(Field(1))
                            Case Else: CType = 0
                            End Select
                        End Select
                    End If
                ElseIf Header = "[response]" Then
                    If Len(Response) = 0 Then
                        Response = Lines(i)
                    Else
                        Response = Response & vbNewLine & Lines(i)
                    End If
                End If
            End If
        End If
    Next i
End Sub


Public Sub LoadEmoticons(File As String)
On Error GoTo hErr:
    If LenB(File) = 0 Then Exit Sub
1   Dim FF As Integer, LN As String, S() As String, FSO As New FileSystemObject
2   frmBot.imlSmiley.ListImages.Clear
    FF = FreeFile
3   Open AppData & "Emoticons\" & File & ".ini" For Append As #FF: Close #FF
4   Open AppData & "Emoticons\" & File & ".ini" For Input As #FF
    frmBot.imlSmiley.Tag = File
5   Do Until EOF(FF) Or Err
6       Line Input #FF, LN
7       If InStr(LN, "#") > 0 Then
8           S = Split(LN, "#", 2)
9           If FSO.FileExists(AppData & "Emoticons\" & File & "\" & S(0)) Then
10              With frmBot.imlSmiley.ListImages.Add(, , LoadPicture(AppData & "Emoticons\" & File & "\" & S(0)))
11                  .Tag = S(1)
12              End With
13          End If
14      End If
15  Loop
16  Close #FF
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Emoticons", "LoadEmoticons"
End Sub





'// Plugins

Public Sub RefreshPlugins()
On Error GoTo hErr:
    Dim i As Long
    ReDim S(frmBot.mnuPlugin.UBound)
1   For i = frmBot.mnuPlugin.UBound To 1 Step -1
2       Unload frmBot.mnuPlugin(i)
3   Next i
4   frmBot.mnuPlugin(0).Caption = vbNS
    If Not SanityCheck Then Exit Sub
6   Dim F() As String
7   F = FileList(AppData & "Plugins\*.dll")
8   For i = 0 To UBound(F)
9       If LenB(F(i)) > 4 Then
10          With frmBot.mnuPlugin
                Dim p As String
                p = Left$(F(i), Len(F(i)) - 4)
11              If Len(.Item(0).Caption) > 0 Then Load frmBot.mnuPlugin(.Count)
12              .Item(.UBound).Caption = p
13              .Item(.UBound).Checked = frmBot.Bot(SelBot).PluginEnabled(p)
            End With
        End If
    Next i
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Main", "RefreshPlugins"
End Sub

Public Sub GetPluginValues(Plugin As String, ByRef Name As String, ByRef Major As Integer, ByRef Minor As Integer, ByRef Build As Integer, ByRef Author As String, ByRef Commands As String, ByRef Description As String)
On Error GoTo hErr:
    Dim obj As Object
    Name = vbNS
    Major = 0
    Minor = 0
    Build = 0
    Author = vbNS
    Commands = vbNS
    Description = vbNS
    Shell "regsvr32 " & ChrW$(34) & AppData & "Plugins\" & Plugin & ".dll" & ChrW$(34) & " /s"
    Set obj = CreateObject(Plugin & ".clsPlugin")
    Call obj.Plugin(Name, Major, Minor, Build, Author, Commands, Description)
    Set obj = Nothing
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Extension", "GetPluginValues"
End Sub




'// Scripts

Public Sub GetScriptValues(Script As String, ByRef Name, ByRef Major, ByRef Minor, ByRef Build, ByRef Author, ByRef Commands, ByRef Description)
    Dim Content As String
    Content = ReadFile(AppData & "Scripts\" & Script & ".txt")
    Name = vbNS
    Major = 0
    Minor = 0
    Build = 0
    Author = vbNS
    Commands = vbNS
    Description = vbNS
    frmBot.scGV.AddCode Content
    frmBot.scGV.Run "Script", Name, Major, Minor, Build, Author, Commands, Description
    frmBot.scGV.Reset
End Sub

Public Sub RefreshScripts()
On Error GoTo hErr:
    Dim i As Integer ', S() As String
    'ReDim S(frmBot.mnuScript.UBound)
1   For i = frmBot.mnuScript.UBound To 1 Step -1
        'S(I) = frmBot.mnuScript(I).Caption
2       Unload frmBot.mnuScript(i)
3   Next i
    'S(0) = frmBot.mnuScript(0).Caption
    'Debug.Print "Previous Scripts: " & Join(S, ", ")
4   frmBot.mnuScript(0).Caption = vbNS
    If Not SanityCheck Then Exit Sub
6   Dim F() As String
7   F = FileList(AppData & "Scripts\*.txt")
8   For i = 0 To UBound(F)
9       If LenB(F(i)) > 4 Then
10          With frmBot.mnuScript
11              Dim p As String
17              p = Left$(F(i), Len(F(i)) - 4)
19              If Len(.Item(0).Caption) > 0 Then Load frmBot.mnuScript(.Count)
20              .Item(.UBound).Caption = p
21              .Item(.UBound).Checked = frmBot.Bot(SelBot).ScriptEnabled(p)
            End With
        End If
NextItem:
    Next i
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Scripts", "RefreshScripts"
End Sub

Public Sub LoadScript(ScriptName As String, Optional ByVal Index As Integer = -1)
    On Error GoTo hErr:
    If Index = -1 Then Index = SelBot
1   With frmBot.Bot(Index)
2       WriteINI .ProfilePath, "Scripts", ScriptName, "1"
3       .ReloadPluginsScripts
4       If .IsScriptLoaded(ScriptName) = False Then
5           .LoadScripts
        Else
6           .scProcess ScriptName, "Event_Load"
            Dim B As BNCS
            For Each B In frmBot.Bot
                If B.IsLoaded Then
                    'If B.BotIndex <> SelBot Then
                        .scProcessArg ScriptName, "Profile_Loaded", B.BotIndex
                    'End If
                End If
            Next
        End If
7       .UpdateScript ScriptName
8       RefreshScripts
    End With
    RefreshProfileCommandList
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Scripts", "LoadScript"
End Sub

Public Sub UnloadScript(ScriptName As String, Optional ByVal Index As Integer = -1)
    On Error GoTo hErr:
    If Index = -1 Then Index = SelBot
1   With frmBot.Bot(Index)
2       WriteINI .ProfilePath, "Scripts", ScriptName, "0"
        'Delete commands, packets, frames
3       .Commands.DeleteType ScriptName, True
4       .Packets.DeleteType ScriptName, True
10      .Frames.DeleteType ScriptName, True
        'Delete Sockets
5       .DeleteSockets ScriptName
        'Delete Timers
6       .DeleteTimers ScriptName, True
        'Post Unload
7       .scProcess ScriptName, "Event_Unload"
        'Reload List
8       .ReloadPluginsScripts
        'Refresh List
9       RefreshScripts
    End With
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Scripts", "UnloadScript"
End Sub







'// Themes

Public Sub LoadTheme(strTheme As String)
On Error GoTo hErr:
    Dim File As String, F As New FileSystemObject
    If LenB(strTheme) = 0 Then strTheme = THEME_DEFAULT
    File = AppData & "Themes\" & strTheme & "\Theme.ini"
    CreateFolder AppData & "Themes\" & strTheme
    CreateFile File
    'Get values
    Dim Back&, ForeA&, ForeB&, Border&, Img$, OlImg1$, OlImg2$, OlImg3$, OlImg4$, OlImg5$, OlImg6$, OlImg7$, OlImg8$, Window&, List&, ComboB&, ComboF&, Temp$
    Dim Temp_AlignH$, Temp_AlignV$, Temp_StretchB As Boolean
    Img = AppData & "Themes\" & strTheme & "\Theme.jpg"
    OlImg1 = AppData & "Themes\" & strTheme & "\Overlay1.jpg"
    OlImg2 = AppData & "Themes\" & strTheme & "\Overlay2.jpg"
    OlImg3 = AppData & "Themes\" & strTheme & "\Overlay3.jpg"
    OlImg4 = AppData & "Themes\" & strTheme & "\Overlay4.jpg"
    OlImg5 = AppData & "Themes\" & strTheme & "\Overlay5.jpg"
    OlImg6 = AppData & "Themes\" & strTheme & "\Overlay6.jpg"
    OlImg7 = AppData & "Themes\" & strTheme & "\Overlay7.jpg"
    OlImg8 = AppData & "Themes\" & strTheme & "\Overlay8.jpg"
    If IsFile(Img) = False Then Img = AppData & "Themes\" & strTheme & "\Theme.gif"
    If IsFile(OlImg1) = False Then OlImg1 = AppData & "Themes\" & strTheme & "\Overlay1.gif"
    If IsFile(OlImg2) = False Then OlImg2 = AppData & "Themes\" & strTheme & "\Overlay2.gif"
    If IsFile(OlImg3) = False Then OlImg3 = AppData & "Themes\" & strTheme & "\Overlay3.gif"
    If IsFile(OlImg4) = False Then OlImg4 = AppData & "Themes\" & strTheme & "\Overlay4.gif"
    If IsFile(OlImg5) = False Then OlImg5 = AppData & "Themes\" & strTheme & "\Overlay5.gif"
    If IsFile(OlImg6) = False Then OlImg6 = AppData & "Themes\" & strTheme & "\Overlay6.gif"
    If IsFile(OlImg7) = False Then OlImg7 = AppData & "Themes\" & strTheme & "\Overlay7.gif"
    If IsFile(OlImg8) = False Then OlImg8 = AppData & "Themes\" & strTheme & "\Overlay8.gif"
    Back = Hex2Color(ReadINI(File, "Colors", "Background"))
    ForeA = Hex2Color(ReadINI(File, "Colors", "ForeA"))
    ForeB = Hex2Color(ReadINI(File, "Colors", "ForeB"))
    Border = Hex2Color(ReadINI(File, "Colors", "Border"))
    Window = Hex2Color(ReadINI(File, "Colors", "Window"))
    TabBackground = Hex2Color(ReadINI(File, "Colors", "TabBackground"))
    TabForeground = Hex2Color(ReadINI(File, "Colors", "TabForeground"))
    List = Hex2Color(ReadINI(File, "Colors", "List"))
    ComboB = Hex2Color(ReadINI(File, "Colors", "ComboB"))
    ComboF = Hex2Color(ReadINI(File, "Colors", "ComboF"))
    AlignmentT = LCase$(ReadINI(File, "Alignment", "Position"))         'Text Position
    ImageStretch = IsYes(ReadINI(File, "Alignment", "Stretch"))  'Stretch Background
    StretchHeight = Val(ReadINI(File, "Alignment", "StretchHeight"))    'Stretch Fixed Height
    Temp = ReadINI(File, "Alignment", "Background_Dock")
    DockOver1 = Val(ReadINI(File, "Alignment", "Overlay1_Dock"))
    DockOver2 = Val(ReadINI(File, "Alignment", "Overlay2_Dock"))
    DockOver3 = Val(ReadINI(File, "Alignment", "Overlay3_Dock"))
    DockOver4 = Val(ReadINI(File, "Alignment", "Overlay4_Dock"))
    DockOver5 = Val(ReadINI(File, "Alignment", "Overlay5_Dock"))
    DockOver6 = Val(ReadINI(File, "Alignment", "Overlay6_Dock"))
    DockOver7 = Val(ReadINI(File, "Alignment", "Overlay7_Dock"))
    DockOver8 = Val(ReadINI(File, "Alignment", "Overlay8_Dock"))
    
    'Read Old Variables for Docking
    Temp_AlignH = LCase$(ReadINI(File, "Alignment", "Horizontal"))               'Center, Right, Left
    Temp_AlignV = LCase$(ReadINI(File, "Alignment", "Vertical"))                 'Center, Bottom, Top
    Temp_StretchB = IsYes(ReadINI(File, "Alignment", "StretchBottom"))           'Bottom, Top
    
    'Read New Variable for Docking
    Temp = ReadINI(File, "Alignment", "Background_Dock")
    If Len(Temp) = 0 Then
        If ImageStretch Then
            If Temp_StretchB Then
                Temp = 7
            Else
                Temp = 1
            End If
        Else
            Select Case Temp_AlignH
            Case "center"
                Select Case Temp_AlignV
                Case "center"
                    Temp = 4
                Case "bottom"
                    Temp = 7
                Case Else
                    Temp = 1
                End Select
            Case "right"
                Select Case Temp_AlignV
                Case "center"
                    Temp = 5
                Case "bottom"
                    Temp = 8
                Case Else
                    Temp = 2
                End Select
            Case Else
                Select Case Temp_AlignV
                Case "center"
                    Temp = 3
                Case "bottom"
                    Temp = 6
                Case Else
                    Temp = 0
                End Select
            End Select
        End If
    End If
    DockBack = CInt(Val(Temp))
    
    If TabBackground = TabForeground Then
        TabBackground = vbButtonFace
        TabForeground = vbBlack
    End If
    
    PaddingT = Val(ReadINI(File, "Padding", "Top"))
    PaddingL = Val(ReadINI(File, "Padding", "Left"))
    PaddingR = Val(ReadINI(File, "Padding", "Right"))
    PaddingB = Val(ReadINI(File, "Padding", "Bottom"))
    PaddingX = Val(ReadINI(File, "Padding", "Text"))
    PaddingS = Val(ReadINI(File, "Padding", "Separator"))
    IndentL = Val(ReadINI(File, "Padding", "LeftIndent"))
    IndentR = Val(ReadINI(File, "Padding", "RightIndent"))
    If StretchHeight > 0 Then StretchHeight = StretchHeight * Screen.TwipsPerPixelY
    If IndentL > 0 Then IndentL = IndentL * Screen.TwipsPerPixelY
    If IndentR > 0 Then IndentR = IndentR * Screen.TwipsPerPixelY
    If PaddingT = 0 Then PaddingT = 56
    If PaddingL = 0 Then PaddingL = 8
    If PaddingR = 0 Then PaddingR = 8
    If PaddingB = 0 Then PaddingB = 8
    If PaddingS = 0 Then PaddingS = 8
    If PaddingX = 0 Then PaddingX = 8
    If PaddingT > 300 Then PaddingT = 300
    If PaddingL > 300 Then PaddingL = 300
    If PaddingR > 300 Then PaddingR = 300
    If PaddingB > 300 Then PaddingB = 300
    If PaddingS > 300 Then PaddingS = 300
    If PaddingX > 300 Then PaddingX = 300
    PaddingT = PaddingT * Screen.TwipsPerPixelY
    PaddingL = PaddingL * Screen.TwipsPerPixelX
    PaddingR = PaddingR * Screen.TwipsPerPixelY
    PaddingB = PaddingB * Screen.TwipsPerPixelY
    PaddingS = PaddingS * Screen.TwipsPerPixelY
    PaddingX = PaddingX * Screen.TwipsPerPixelY
    
    If ComboB = vbBlack And ComboF = vbBlack Then ComboF = vbWhite
    
    'Check if blacked out
    If Back = vbBlack And ForeA = vbBlack And ForeB = vbBlack And Border = vbBlack Then
        ForeA = vbWhite
        ForeB = vbWhite
        Border = &HE0E0E0
    End If
    'Check if whited out
    If Back = vbWhite And ForeA = vbWhite And ForeB = vbWhite And Border = vbWhite Then
        Back = vbBlack
        Border = &HE0E0E0
    End If
    'Apply colors
    With frmBot
        Dim C As Control
        For Each C In .Controls
            Select Case TypeName(C)
            Case "RichTextBox"
                C.BackColor = Window
            Case "ListView", "List", "PictureBox", "Label", "TextBox"
                C.BackColor = List
            Case "ComboBox"
                C.BackColor = ComboB
                C.ForeColor = ComboF
            End Select
        Next C
        .BackColor = Back
        .lblArrow.ForeColor = TabForeground
        .lblProfileData.ForeColor = ForeA
        .lblChannel.ForeColor = ForeB
        .shaChat.BorderColor = Border
        .shaList.BorderColor = Border
        .shaSend.BorderColor = Border
        .shaSmile.BorderColor = Border
        .shaListSel.BorderColor = Border
        .shaText.BorderColor = Border
        .shaCmd.BorderColor = Border
        .picNo.BackColor = Back
        .Shape1.BackStyle = vbTransparent
        .Shape2.BackStyle = vbTransparent
        .Shape2.BorderColor = Border
33      .TT.ForeColor = .lblChannel.ForeColor
34      .TT.BackColor = .BackColor
        Dim N As Integer
        For N = 0 To .lblNoProf.UBound
            .lblNoProf(N).ForeColor = ForeA
        Next
        .prfBack.Picture = Nothing
        .prfOL1.Picture = Nothing
        .prfOL2.Picture = Nothing
        .prfOL3.Picture = Nothing
        .prfOL4.Picture = Nothing
        .prfOL5.Picture = Nothing
        .prfOL6.Picture = Nothing
        .prfOL7.Picture = Nothing
        .prfOL8.Picture = Nothing
        On Error Resume Next
        .prfBack.Stretch = False
        .prfBack.Picture = LoadPicture(Img)
        .prfOL1.Picture = LoadPicture(OlImg1)
        .prfOL2.Picture = LoadPicture(OlImg2)
        .prfOL3.Picture = LoadPicture(OlImg3)
        .prfOL4.Picture = LoadPicture(OlImg4)
        .prfOL5.Picture = LoadPicture(OlImg5)
        .prfOL6.Picture = LoadPicture(OlImg6)
        .prfOL7.Picture = LoadPicture(OlImg7)
        .prfOL8.Picture = LoadPicture(OlImg8)
        .tbsProfile.Refresh
    End With
    
    CurrentTheme = strTheme
    WriteINI AppSettings, "Settings", "TheTheme", strTheme

    frmBot.Form_Resize
    frmBot.Cls
    frmBot.Refresh
    Exit Sub
hErr:
    
End Sub


