Attribute VB_Name = "modQueue"
Option Explicit

Public Queue() As New IQueue
Public SharedQueue As Boolean

Public Sub AddQueue(Index As Integer, Message As String)
    If LenB(Queue(0).Message) > 0 Then ReDim Preserve Queue(UBound(Queue) + 1)
    Queue(UBound(Queue)).Index = Index
    Queue(UBound(Queue)).Message = Message
End Sub

Public Sub ClearAllQueues()
    ReDim Queue(0)
    Dim B As BNCS
    For Each B In frmBot.Bot
        B.Queue.Consecutive = 0
    Next B
End Sub

Public Function CountQueue(Index As Integer) As Long
    Dim I As Integer, Count As Long
    For I = UBound(Queue) To 0 Step -1
        If Queue(I).Index = Index Then
            Count = Count + 1
        End If
    Next
    CountQueue = Count
End Function

Public Sub ClearQueue(Index As Integer)
    Dim I As Integer
    For I = UBound(Queue) To 0 Step -1
        If Queue(I).Index = Index Then
            Dim R As Integer
            For R = I To UBound(Queue) - 1
                Set Queue(R) = Queue(R + 1)
            Next
            ReDim Preserve Queue(UBound(Queue) - 1)
        End If
    Next
    frmBot.Bot(Index).Queue.Consecutive = 0
End Sub

Public Sub RemoveQueue(itemIndex As Integer)
    Dim I As Integer
    For I = itemIndex To UBound(Queue) - 1
        Set Queue(I) = Queue(I + 1)
    Next I
    ReDim Preserve Queue(UBound(Queue) - 1)
End Sub

Public Sub QueueRun()
    If UBound(Queue) > 0 Or LenB(Queue(0).Message) Then
        Dim Out As New clsPacketBuffer
        Dim B As BNCS, lQueue As Long
        For Each B In frmBot.Bot
            Dim I As Integer
            lQueue = UBound(Queue)
            For I = 0 To lQueue
                If Queue(I).Index = B.BotIndex Then
                    'Check if shared
                    If Not SharedQueue Then
                        'Check if ready to send
                        If (DblTickCount - B.Queue.TickLast) > B.Queue.CurDelay Then
                            'Send Away
                            Out.Clear
                            Out.InsertCString UTF8Encode(Queue(I).Message)
                            Out.SendBnetPacket B.ExposeSocket, SID_CHATCOMMAND
                            'Determine Delay
                            B.Queue.NextDelay Queue(I).Message
                            'Remove from Queue
                            RemoveQueue I
                            'Decrement Length
                            lQueue = UBound(Queue)
                        End If
                    Else
                        'Check if this bot is ready to send
                        If (DblTickCount - B.Queue.TickLast) > B.Queue.CurDelay Then
                            'Send Away
                            Out.Clear
                            Out.InsertCString UTF8Encode(Queue(I).Message)
                            Out.SendBnetPacket B.ExposeSocket, SID_CHATCOMMAND
                            'Determine Delay
                            B.Queue.NextDelay Queue(I).Message
                            'B.SendText Queue(I).Index
                            'Remove from Queue
                            RemoveQueue I
                            'Decrement Length
                            lQueue = UBound(Queue)
                        Else
                            'Check if another bot can send this away
                            Dim C As BNCS
                            For Each C In frmBot.Bot
                                'Check Server
                                If GetServerName(C.Config.Server, C.Config.IsWarCraft) = GetServerName(B.Config.Server, B.Config.IsWarCraft) Then
                                    'Check Channel
                                    If LCase$(C.Self.Channel) = LCase$(B.Self.Channel) Then
                                        'Check Operator
                                        If C.Self.IsOperator = B.Self.IsOperator Then
                                            'Check if ready to send
                                            If (DblTickCount - C.Queue.TickLast) > C.Queue.CurDelay Then
                                                'Send Away
                                                Out.Clear
                                                Out.InsertCString UTF8Encode(Queue(I).Message)
                                                Out.SendBnetPacket C.ExposeSocket, SID_CHATCOMMAND
                                                'Determine Delay
                                                B.Queue.NextDelay Queue(I).Message
                                                'Remove from Queue
                                                RemoveQueue I
                                                'Decrement Length
                                                lQueue = UBound(Queue)
                                            End If
                                        End If
                                    End If
                                End If
                            Next C
                        End If
                    End If
                End If
            Next I
        Next B
    End If
End Sub
