Attribute VB_Name = "modManifest"
'-----------------------------------------------------
' MirageBot Manifestation for XP/Vista Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

#If Win32 Then
    Private Declare Function InitCommonControlsEx Lib "comctl32" (iccex As tagInitCommonControlsEx) As Boolean
    Private Declare Function LoadLibrary Lib "kernel32" Alias "LoadLibraryA" (ByVal lpLibFileName As String) As Long
    Private Declare Function FreeLibrary Lib "kernel32" (ByVal hLibModule As Long) As Long
    Private Const ICC_USEREX_CLASSES = &H200
    Private Type tagInitCommonControlsEx
        lngSize As Long
        lngICC As Long
    End Type
#End If

Public Function InitCommonControlsVB() As Boolean
    On Error Resume Next
    Dim iccex As tagInitCommonControlsEx
    With iccex
        .lngSize = LenB(iccex)
        .lngICC = ICC_USEREX_CLASSES
    End With
    InitCommonControlsEx iccex
    InitCommonControlsVB = (Err.Number = 0)
    On Error GoTo 0
End Function

Sub Main()
On Error GoTo hErr:
    frmLoading.Show
    #If Win32 Then
        If Not TestIDE Then
8           If Not InitCommonControlsVB Then
                MsgBox "Manifest initialization error!", vbCritical
                End
                Exit Sub
            End If
        End If
    #End If
    frmBot.Show
    Unload frmLoading
    If options.TrayStart Then frmBot.Hide
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Main", "Main"
End Sub
