Attribute VB_Name = "modTags"
Option Explicit

Private Type TAG_TYPE
    blnUser As Boolean
    strText As String
    strTag As String
End Type

Public Tags() As TAG_TYPE

Public Sub LoadTags()
On Error GoTo hErr
1   ReDim Tags(0)
2   Dim FF As Integer, F As String, L As String, M() As String
3   FF = FreeFile
4   F = AppData & "Data\Preferences\Tags.ini"
5   Open F For Append As #FF
6   Close #FF
7   Open F For Input As #FF
8   Do Until EOF(FF)
9       Line Input #FF, L
10      M = Split(L, "//", 3)
11      If UBound(M) = 2 Then
12          If Not AddTag(M(1), M(2), M(0) = "U", False) Then
13              'Debug.Print "Failed to add tag: " & L
            End If
        Else
14          'Debug.Print "Failed to add tag: " & L
        End If
    Loop
15  Close #FF
    SaveTags
Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Tags", "LoadTags"
End Sub

Public Function AddTag(strText As String, strTag As String, blnUser As Boolean, Optional Save As Boolean = True) As Boolean
On Error GoTo hErr
    Dim r As Boolean, x As Integer
1   r = RemoveTag(strText, blnUser, Save)
2   If LenB(Tags(0).strText) = 0 Then x = 0 Else x = UBound(Tags) + 1: ReDim Preserve Tags(x)
3   With Tags(x)
4       .strText = strText
5       .strTag = strTag
6       .blnUser = blnUser
7   End With
8   AddTag = Not r
9   If Save Then SaveTags
Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Tags", "AddTag"
End Function

Public Function RemoveTag(strText As String, blnUser As Boolean, Optional Save As Boolean = True) As Boolean
On Error GoTo hErr
    Dim x As Integer, r As Integer
1   For x = 0 To UBound(Tags)
2       If Tags(x).blnUser = blnUser Then
3           If blnUser Then
4               If LCase$(Suffix(Tags(x).strText)) = LCase$(Suffix(strText)) Then
5                   If UBound(Tags) > 0 Then
6                       For r = x To UBound(Tags) - 1
7                           Tags(r) = Tags(r + 1)
8                       Next r
9                       ReDim Preserve Tags(UBound(Tags) - 1)
                    Else
10                      ReDim Tags(0)
                    End If
11                  RemoveTag = True
12                  If Save Then SaveTags
                    Exit Function
                End If
            Else
13              If LCase$(Tags(x).strText) = LCase$(strText) Then
14                  If UBound(Tags) > 0 Then
15                      For r = x To UBound(Tags) - 1
16                          Tags(r) = Tags(r + 1)
17                      Next r
18                      ReDim Preserve Tags(UBound(Tags) - 1)
                    Else
19                      ReDim Tags(0)
                    End If
21                  RemoveTag = True
22                  If Save Then SaveTags
                    Exit Function
                End If
            End If
        End If
    Next x
Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Tags", "RemoveTag"
End Function

Public Function GetTagOnly(strText As String) As String
On Error GoTo hErr
    Dim I As Integer
1   For I = 0 To UBound(Tags)
6       If LCase$(Tags(I).strText) = LCase$(strText) Then
7           GetTagOnly = Tags(I).strTag
            Exit Function
        End If
    Next I
Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Tags", "GetTagOnly"
End Function

Public Function GetTag(strText As String) As String
On Error GoTo hErr
    Dim Tag As String
1   Tag = GetTagOnly(strText)
2   If LenB(Tag) Then
        If options.DisableTrueName Then
            GetTag = Tag & " (" & strText & ")"
        Else
7           GetTag = Tag
        End If
    Else
12      GetTag = strText
    End If
Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Tags", "GetTag"
End Function

Public Sub SaveTags()
On Error GoTo hErr
1  Dim FF As Integer, F As String, I As Integer
2   FF = FreeFile
3   F = AppData & "Data\Preferences\Tags.ini"
    CreateFolder AppData & "Data\"
    CreateFolder AppData & "Data\Preferences\"
    
4   Open F For Append As #FF
5   Close #FF
6   Open F For Output As #FF
7       For I = 0 To UBound(Tags)
8           Print #FF, IIf(Tags(I).blnUser, "U", "C") & _
                "//" & Tags(I).strText & "//" & Tags(I).strTag
9       Next I
    Close #FF
Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Tags", "SaveTags"
End Sub
