Attribute VB_Name = "modIcons"
'-----------------------------------------------------
' MirageBot Icon Set Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Public Function ClientIconIndex(Index As Integer, Statstring As String, Flags As Long) As Integer
    On Error GoTo hErr
    If Len(Statstring) < 4 Then ClientIconIndex = 17: Exit Function
    Dim Client As String * 4, IconIndex As Integer
    Client = StrReverse$(Left$(Statstring, 4))
    Select Case Client
        Case "WAR3": IconIndex = 6
        Case "W3XP": IconIndex = 7
        Case "DSHR": IconIndex = 8
        Case "DRTL": IconIndex = 9
        Case "D2DV": IconIndex = 10
        Case "D2XP": IconIndex = 11
        Case "SSHR": IconIndex = 12
        Case "JSTR": IconIndex = 13
        Case "STAR": IconIndex = 14
        Case "SEXP": IconIndex = 15
        Case "W2BN": IconIndex = 16
        Case "CHAT": IconIndex = 18
        Case Else:   IconIndex = 17
    End Select
    If (Flags And &H2) Then IconIndex = 5
    If (Flags And &H1) Then IconIndex = 1
    If (Flags And &H8) Then IconIndex = 2
    If (Flags And &H4) Then IconIndex = 3
    If (Flags And &H20) Then IconIndex = 4
    ClientIconIndex = IconIndex
    Exit Function
hErr:
    ClientIconIndex = 17
    ErrorHandler Err.Description, Erl, "Iconset", "ClientIconIndex"
End Function
