Attribute VB_Name = "modGame"
Public Games() As objGameInfo

Public Const GAMETYPE_MELEE As Long = &H2
Public Const GAMETYPE_FFA As Long = &H3
Public Const GAMETYPE_ONEVSONE As Long = &H4
Public Const GAMETYPE_CTF As Long = &H5
Public Const GAMETYPE_GREED As Long = &H6
Public Const GAMETYPE_SLAUGHTER As Long = &H7
Public Const GAMETYPE_SUDDEN As Long = &H8
Public Const GAMETYPE_LADDER As Long = &H9
Public Const GAMETYPE_IRONMAN As Long = &H10
Public Const GAMETYPE_UMS As Long = &HA
Public Const GAMETYPE_TEAMMELEE As Long = &HB
Public Const GAMETYPE_TEAMFFA As Long = &HC
Public Const GAMETYPE_TEAMCTF As Long = &HD
Public Const GAMETYPE_TVB As Long = &HF
Public Const GAMETYPE_ALL As Long = &H0

Public Sub DecodeW2Map(Self As objSelf, Info As objGameInfo)
    With Info
        ',,12,4,1,4,1,63a8d525,,DRABS[CHR(&hD)]All You Need BNE.pud
        ',,15,8,1,f,2,ce32c391,3200,Rbelcarz[CHR(&hD)]World Domination BNE.pud
        If (InStr(1, .RawGameStats, ",") = 0) Then Exit Sub
        Dim strP() As String
        strP = Split(.RawGameStats, ",")
        If (UBound(strP) < 9) Then Exit Sub
        If (Not Len(strP(3)) = 1) Or (IsNumeric(strP(3)) = False) Then strP(3) = "4"    'GameSpeed
        If (Not Len(strP(5)) = 1) Or (IsNumeric(strP(5)) = False) Then strP(5) = "0"    'GameType
        If (Not Len(strP(4)) = 1) Or (IsNumeric(strP(4)) = False) Then strP(4) = "0"    'MapApproval
        If (IsNumeric(strP(8)) = False) Then strP(8) = "0"                              'Resources
        .RawGameSpeed = CLng(strP(3))
        .RawGameType = CLng(strP(5))
        .GameResources = CLng(strP(8))
        .GameSpeed = GameSpeedName(Self, .RawGameSpeed)
        .GameType = GameTypeName(.RawGameType)
        .Map = Split(strP(9), Chr$(&HD))(1)
        .MapApproval = MapApprovalName(CLng(strP(4)))
        .MapChecksum = strP(7)
        .MapIcon = MapIconIndex(CLng(strP(4)))
        .Host = Split(strP(9), Chr$(&HD))(0)
    End With
End Sub

Public Sub DecodeSCMap(Self As objSelf, Info As objGameInfo)
    With Info
        'Parse SC
        ',44,,6,1,2,,1,190508b2,4,,ptitloulou.TheHunters.
        
        '//GAME STATS
        If (InStr(1, .RawGameStats, ",") = 0) Then Exit Sub
        Dim strP() As String
        strP = Split(.RawGameStats, ",")
        If (UBound(strP) < 11) Then Exit Sub
    
        '//MAX PLAYERS
        If (Not Len(strP(2)) = 2) Or (IsNumeric(strP(2)) = False) Then
            .MaxPlayers = IIf((Len(strP(2)) = 0), "8", "?")
        Else
            .MaxPlayers = Right$(strP(2), 1)
        End If
        
        If (Not Len(strP(3)) = 1) Or (IsNumeric(strP(3)) = False) Then strP(3) = "4"    'GameSpeed
        If (Not Len(strP(4)) = 1) Or (IsNumeric(strP(4)) = False) Then strP(4) = "0"    'MapApproval
        If (Not Len(strP(9)) = 1) Or (IsNumeric(strP(9)) = False) Then strP(9) = "0"    'MapTileset
        .RawGameSpeed = CLng(strP(3))
        .GamePenalty = GamePenaltyName(.RawGameType, .MaxPlayers, .RawGamePenalty)
        .GameSpeed = GameSpeedName(Self, .RawGameSpeed)
        .Map = Split(strP(11), Chr$(&HD))(1)
        .MapApproval = MapApprovalName(CLng(strP(4)))
        .MapChecksum = strP(7)
        .MapIcon = MapIconIndex(CLng(strP(4)))
        .MapTileset = MapTilesetName(CLng(strP(9)))
        .Host = Split(strP(11), Chr$(&HD))(0)
        
        '//MAP SIZE
        If (Not Len(strP(1)) = 2) Or (IsNumeric(strP(1)) = False) Then
            .MapSize = IIf((Len(strP(1)) = 0), "256x256", "???x???")
        Else
            .MapSize = (CInt(Left$(strP(1), 1)) * 32) & "x" & (CInt(Right$(strP(1), 1)) * 32)
        End If
    End With
End Sub

Public Property Get GamePenaltyName(GameType As Long, MaxPlayers As String, V As Long) As String
    Select Case GameType
        Case 2, 3, 4, 5, 8 'melee / ffa / 1 on 1 / CTF / suddenDeath
            Select Case V
                Case 1: GamePenaltyName = "Penalty: Melee Disc"
                Case 2: GamePenaltyName = "Penalty: Loss"
            End Select
        Case 6  'Greed
            Select Case V
                Case 1: GamePenaltyName = "Resources: 2500"
                Case 2: GamePenaltyName = "Resources: 5000"
                Case 3: GamePenaltyName = "Resources: 7500"
                Case 4: GamePenaltyName = "Resources: 10000"
            End Select
        Case 7 'Slaughter
            Select Case V
                Case 1: GamePenaltyName = "Minutes: 15"
                Case 2: GamePenaltyName = "Minutes: 30"
                Case 3: GamePenaltyName = "Minutes: 45"
                Case 4: GamePenaltyName = "Minutes: 60"
                Case Else: GamePenaltyName = "Minutes: Unlimited"
            End Select
        Case 9 'Ladder
            Select Case V
                Case 1: GamePenaltyName = "Penalty: Ladder Disc"
                Case 2: GamePenaltyName = "Penalty: Ladder Loss + Disc"
            End Select
        Case &HA 'UMS
            Select Case V
                Case 1, 2:  GamePenaltyName = "Penalty: Draw"
            End Select
        Case &HB, &HC, &HD 'Team melee / team FFA / team CTF
            Select Case V
                Case 1: GamePenaltyName = "Teams: 2"
                Case 2: GamePenaltyName = "Teams: 3"
                Case 3: GamePenaltyName = "Teams: 4"
            End Select
        Case &HF 'Top vs Bottom
            Dim MP As Integer
            If (MaxPlayers = "?") Then
                MP = 8
            Else
                MP = CInt(MaxPlayers)
            End If
            If (V < 1) Or (V > 7) Then
                GamePenaltyName = "Teams: ? vs ?"
            Else
                GamePenaltyName = "Teams: " & V & " vs " & (MP - V)
            End If
        Case Else 'Unknown
            GamePenaltyName = "Penalty: None"
        End Select
End Property

Public Function GameTypeFromString(S As String) As Long
    Select Case UCase$(S)
    Case "TOP VS BOTTOM", "TVB"
        GameTypeFromString = GAMETYPE_TVB
    Case "MELEE"
        GameTypeFromString = GAMETYPE_MELEE
    Case "CTF", "CAPTURE THE FLAG"
        GameTypeFromString = GAMETYPE_CTF
    Case "TEAM MELEE"
        GameTypeFromString = GAMETYPE_TEAMMELEE
    Case "TEAM CTF", "TEAM CAPTURE THE FLAG"
        GameTypeFromString = GAMETYPE_TEAMCTF
    Case "TEAM FFA", "TEAM FREE FOR ALL"
        GameTypeFromString = GAMETYPE_TEAMFFA
    Case "FFA", "FREE FOR ALL"
        GameTypeFromString = GAMETYPE_FFA
    Case "ONE ON ONE", "ONE VS ONE", "1VS1", "1V1"
        GameTypeFromString = GAMETYPE_ONEVSONE
    Case "SLAUGHTER"
        GameTypeFromString = GAMETYPE_SLAUGHTER
    Case "SUDDEN DEATH"
        GameTypeFromString = GAMETYPE_SUDDEN
    Case "GREED"
        GameTypeFromString = GAMETYPE_GREED
    Case "LADDER"
        GameTypeFromString = GAMETYPE_LADDER
    Case "IRONMAN", "IRONMAN LADDER"
        GameTypeFromString = GAMETYPE_IRONMAN
    Case "USE MAP SETTINGS", "UMS"
        GameTypeFromString = GAMETYPE_UMS
    Case Else
        GameTypeFromString = GAMETYPE_ALL
    End Select
End Function

Public Property Get GameTypeName(V As Long) As String
    Select Case V
        Case &H0:  GameTypeName = "Show All"
        Case &H2:  GameTypeName = "Melee"
        Case &H3:  GameTypeName = "FFA"
        Case &H4:  GameTypeName = "One on One"
        Case &H5:  GameTypeName = "Capture the Flag"
        Case &H6:  GameTypeName = "Greed"
        Case &H7:  GameTypeName = "Slaughter"
        Case &H8:  GameTypeName = "Sudden Death"
        Case &H9:  GameTypeName = "Ladder"
        Case &H10: GameTypeName = "Ironman Ladder"
        Case &HA:  GameTypeName = "Use Map Settings"
        Case &HB:  GameTypeName = "Team Melee"
        Case &HC:  GameTypeName = "Team FFA"
        Case &HD:  GameTypeName = "Team Capture the Flag"
        Case &HF:  GameTypeName = "Top vs Bottom"
        Case Else: GameTypeName = "Unknown (" & Hex(V) & ")"
    End Select
End Property

Public Property Get GameSpeedName(Self As objSelf, V As Long) As String
    If Self.IsWarCraft3 Then
        Select Case V
            Case 0:     GameSpeedName = "Slow"
            Case 1:     GameSpeedName = "Normal"
            Case 2:     GameSpeedName = "Fast"
        End Select
    ElseIf Self.IsWarCraft2 Then
        Select Case V
            Case 0:     GameSpeedName = "Slowest"
            Case 1:     GameSpeedName = "Even Slower"
            Case 2:     GameSpeedName = "Slower"
            Case 3:     GameSpeedName = "Slow"
            Case 4:     GameSpeedName = "Normal"
            Case 5:     GameSpeedName = "Fast"
            Case 6:     GameSpeedName = "Faster"
            Case 7:     GameSpeedName = "Even Faster"
            Case Else:  GameSpeedName = "Fastest"
        End Select
    ElseIf Self.IsStarCraft Then
        Select Case V
            Case 0:     GameSpeedName = "Slowest"
            Case 1:     GameSpeedName = "Slower"
            Case 2:     GameSpeedName = "Slow"
            Case 3:     GameSpeedName = "Normal"
            Case 4:     GameSpeedName = "Fast"
            Case 5:     GameSpeedName = "Faster"
            Case Else:  GameSpeedName = "Fastest"
        End Select
    End If
End Property

Public Property Get MapSizeName(V As Long) As String
    Select Case V
        Case &H20000:   MapSizeName = "Small"
        Case &H40000:   MapSizeName = "Medium"
        Case &H80000:   MapSizeName = "Huge"
        Case Else:      MapSizeName = "Unknown (" & Hex(V) & ")"
    End Select
End Property

Public Property Get MapAuthorName(V As Long) As String
    Select Case V
        Case &H2000:    MapAuthorName = "Custom"
        Case &H4000:    MapAuthorName = "Blizzard"
        Case Else:      MapAuthorName = "Unknown (" & Hex(V) & ")"
    End Select
End Property

Public Property Get MapAuthorIcon(V As Long) As Integer
    Select Case V
        Case &H2000:    MapAuthorIcon = 5
        Case &H4000:    MapAuthorIcon = 1
        Case Else:      MapAuthorIcon = 5
    End Select
End Property

Public Property Get BattleTypeName(V As Long) As String
    Select Case V
        Case &H0:       BattleTypeName = "Battle"
        Case &H8000:    BattleTypeName = "Ladder"
        Case 32768:     BattleTypeName = "Ladder"
        Case &H10000:   BattleTypeName = "Scenario"
        Case Else:      BattleTypeName = "Unknown (" & Hex(V) & ", " & V & ")"
    End Select
End Property

Public Property Get GameVisibilityName(V As Long) As String
    Select Case V
        Case &H100:     GameVisibilityName = "Hide Terrain"
        Case &H200:     GameVisibilityName = "Map Explored"
        Case &H400:     GameVisibilityName = "Always Visible"
        Case &H800:     GameVisibilityName = "Default"
    End Select
End Property

Public Property Get GameObserversName(V As Long) As String
'    Select Case V
'        Case &H400000:    GameObserversName = "No Observers"
'        Case &H200000:    GameObserversName = "Observers on Defeat"
'        Case &H100000:    GameObserversName = "Observers Allowed"
'    End Select
    Select Case V
        Case &H0:       GameObserversName = "No Observers"
        Case &H2000:    GameObserversName = "Observers on Defeat"
        Case &H3000:    GameObserversName = "Observers Allowed"
        Case &H40000000: GameObserversName = "Referees Allowed"
    End Select
End Property

Public Property Get GameStateName(V As Long) As String
    Select Case V
        Case &H1:       GameStateName = "Doesn't Exist"
        Case &H2:       GameStateName = "Incorrect Password"
        Case &H3:       GameStateName = "Full"
        Case &H4:       GameStateName = "Started Already"
        Case &H6:       GameStateName = "Too many server requests"
    End Select
End Property

Public Property Get GameTimestamp(V As Long) As String
    GameTimestamp = DateAdd("s", -V, Time)
End Property

Public Property Get MapTilesetName(V As Long) As String
    Select Case V
        Case 0:         MapTilesetName = "Badlands"
        Case 1:         MapTilesetName = "Platform"
        Case 2:         MapTilesetName = "Installation"
        Case 3:         MapTilesetName = "Ash"
        Case 4:         MapTilesetName = "Jungle"
        Case 5:         MapTilesetName = "Desert"
        Case 6:         MapTilesetName = "Ice"
        Case 6:         MapTilesetName = "Twilight"
    End Select
End Property

Public Property Get MapApprovalName(V As Long) As String
    Select Case V
        Case 0:         MapApprovalName = "None"
        Case 1:         MapApprovalName = "Blizzard"
        Case 2:         MapApprovalName = "Ladder"
        Case 3:         MapApprovalName = "PGL"
        Case 4:         MapApprovalName = "KPK"
        Case 5:         MapApprovalName = "CompUSA"
    End Select
End Property

Public Property Get MapIconIndex(V As Long) As Integer
    Select Case V
        Case 1:         MapIconIndex = 1
        Case 2:         MapIconIndex = 2
        Case 3:         MapIconIndex = 4
        Case 4:         MapIconIndex = 3
        Case Else:      MapIconIndex = 5
    End Select
End Property
