Attribute VB_Name = "modFonts"

Public Sub LoadFonts()
    ChatFont = ReadINI(AppSettings, "Settings", "ChatFont")
    ListFont = ReadINI(AppSettings, "Settings", "ListFont")
    ChatFontSize = Val(ReadINI(AppSettings, "Settings", "ChatFontSize"))
    ListFontSize = Val(ReadINI(AppSettings, "Settings", "ListFontSize"))
    SendFont = ReadINI(AppSettings, "Settings", "SendFont")
    SendFontSize = Val(ReadINI(AppSettings, "Settings", "SendFontSize"))
    Const FontName As String = "Tahoma"
31  If LenB(ChatFont) = 0 Then ChatFont = FontName
32  If LenB(ListFont) = 0 Then ListFont = FontName
    If LenB(SendFont) = 0 Then ListFont = FontName
33  If ChatFontSize < 6 Or ChatFontSize > 16 Then ChatFontSize = 11
34  If ListFontSize < 6 Or ListFontSize > 16 Then ListFontSize = 11
    If SendFontSize < 6 Or SendFontSize > 16 Then SendFontSize = 11
    ChangeChatFont ChatFont, ChatFontSize, True
    ChangeListFont ListFont, ListFontSize
    ChangeSendFont SendFont, SendFontSize
End Sub

Public Sub ChangeChatFont(ByRef FontName As String, ByRef FontSize As Byte, Optional Initial As Boolean = False)
On Error GoTo hErr
1   If FontSize = 0 Then FontSize = 11
2   If LenB(FontName) = 0 Then FontName = "Tahoma"
3   Dim C As Control
4   For Each C In frmBot.Controls
        If TypeName(C) = "RichTextBox" Then
            Dim rtb As RichTextBox
            Set rtb = C
5           rtb.SelStart = 0
6           rtb.SelLength = 2000000000
7           rtb.SelFontName = FontName
8           rtb.SelFontSize = FontSize
9           If Initial Then rtb.Font.Name = FontName: rtb.Font.Size = FontSize
        End If
    Next C
    ChatFont = FontName
    ChatFontSize = FontSize
    WriteINI AppSettings, "Settings", "ChatFont", ChatFont
    WriteINI AppSettings, "Settings", "ChatFontSize", CStr(ChatFontSize)
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Main", "ChangeChatFont"
End Sub

Public Sub ChangeSendFont(ByRef FontName As String, ByRef FontSize As Byte)
On Error GoTo hErr
    With frmBot
        If LenB(FontName) = 0 Then FontName = "Tahoma"
        If FontSize = 0 Then FontSize = 11
        SendFont = FontName
        SendFontSize = FontSize
        WriteINI AppSettings, "Settings", "SendFont", SendFont
        WriteINI AppSettings, "Settings", "SendFontSize", CStr(SendFontSize)
        .cboSend.Font.Name = FontName: .cboCommand.Font.Name = FontName: .cboList.Font.Name = FontName
        .cboSend.Font.Size = FontSize: .cboCommand.Font.Size = FontSize: .cboList.Font.Size = FontSize
        .Form_Resize
    End With
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Main", "ChangeSendFont"
End Sub

Public Sub ChangeListFont(ByRef FontName As String, ByRef FontSize As Byte)
On Error GoTo hErr
1   If FontSize = 0 Then FontSize = 11
2   If LenB(FontName) = 0 Then FontName = "Tahoma"
3   Dim C As Control
4   For Each C In frmBot.Controls
        If TypeName(C) = "ListView" Then
            Dim lv As ListView
            Set lv = C
            lv.Font.Name = FontName
            lv.Font.Size = FontSize
        End If
    Next C
    ListFont = FontName
    ListFontSize = FontSize
    WriteINI AppSettings, "Settings", "ListFont", ListFont
    WriteINI AppSettings, "Settings", "ListFontSize", CStr(ListFontSize)
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Main", "ChangeListFont"
End Sub

