Attribute VB_Name = "modFocus"
Public LastWarning As Double

Public Function CreateFocus(Users As Collection, BotIndex As Integer) As Form
    Dim N As Form, C As Integer
    For Each N In Forms
        If N.Name = "frmFocus" Then
            If N.BotIndex = BotIndex Then
                C = C + 1
                If C >= options.FocusMax Then
                    If DblTickCount - LastWarning < 120000 Then Exit Function
                    LastWarning = DblTickCount
                    'Output frmBot.rtbChat(BotIndex), &HB0, , "Maximum number of focus windows for this profile has been met, please increase the number to display more!"
                    ShowExclamation "Warning", "Maximum number of focus windows allowed has been met, please increase this amount to view more windows.", False
                    Exit Function
                End If
            End If
        End If
    Next
    Dim F As New frmFocus, I As Integer
    For I = 1 To Users.Count
        F.AddUser Suffix(Users(I))
    Next I
    F.BotIndex = BotIndex
    If LenB(SendFont) = 0 Then SendFont = "Tahoma"
    F.cboSend.FontName = SendFont
    If Val(SendFontSize) = 0 Then SendFontSize = 11
    F.cboSend.FontSize = SendFontSize
    OutputFocus F.rtbFocus, SelBot, &HB0, , "To add a user type: #a [user]"
    OutputFocus F.rtbFocus, SelBot, &HB0, , "To delete a user type: #d [user]"
    If options.FocusBack Then
        F.WindowState = vbMinimized
        F.Show
    Else
        F.WindowState = vbNormal
        F.Show
    End If
    If F.Users.Count = 0 Then Unload F: Set CreateFocus = Nothing: Exit Function
    Set CreateFocus = F
End Function

Public Function CreateFocusAuto(Users As Collection, BotIndex As Integer) As Form
    Dim F As Form, I As Integer
    For Each F In Forms
        If F.Name = "frmFocus" Then
            If F.Tag = "AutoFocus" Then
                For I = 1 To Users.Count
                    F.AddUser Suffix(Users(I))
                Next I
                Set CreateFocusAuto = F
                Exit Function
            End If
        End If
    Next
    Dim N As Form, C As Integer
    For Each N In Forms
        If N.Name = "frmFocus" Then
            If N.BotIndex = BotIndex Then
                C = C + 1
                If C >= options.FocusMax Then
                    If DblTickCount - LastWarning < 120000 Then Exit Function
                    LastWarning = DblTickCount
                    'Output frmBot.rtbChat(BotIndex), &HB0, , "Maximum number of focus windows for this profile has been met, please increase the number to display more!"
                    ShowExclamation "Warning", "Maximum number of focus windows allowed has been met, please increase this amount to view more windows.", False
                    Exit Function
                End If
            End If
        End If
    Next
    Set F = New frmFocus
    For I = 1 To Users.Count
        F.AddUser Suffix(Users(I))
    Next I
    F.Tag = "AutoFocus"
    F.BotIndex = BotIndex
    If LenB(SendFont) = 0 Then SendFont = "Tahoma"
    F.cboSend.FontName = SendFont
    If Val(SendFontSize) = 0 Then SendFontSize = 11
    F.cboSend.FontSize = SendFontSize
    OutputFocus F.rtbFocus, SelBot, &HB0, , "To add a user type: #a [user]"
    OutputFocus F.rtbFocus, SelBot, &HB0, , "To delete a user type: #d [user]"
    If options.FocusBack Then
        F.WindowState = vbMinimized
        F.Show
    Else
        F.WindowState = vbNormal
        F.Show
    End If
    Set CreateFocusAuto = F
End Function

Public Function FocusWindows(Username As String, BotIndex As Integer, ByRef Success As Boolean) As Form()
On Error GoTo hErr:
1   Dim F As Form, G() As Form
2   ReDim G(0)
    Set G(0) = Nothing
4   For Each F In Forms
5       If F.Name = "frmFocus" Then
6           If F.BotIndex = BotIndex Then
                If F.IsUser(Username) Then
                    If Not G(UBound(G)) Is Nothing Then ReDim Preserve G(UBound(G) + 1)
10                  Set G(UBound(G)) = F
                    Success = True
                End If
            End If
        End If
    Next
11  FocusWindows = G
    Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Focus", "FocusWindows"
End Function

Public Function FocusSingle(Username As String, BotIndex As Integer, Success As Boolean) As Form
On Error GoTo hErr:
1   Dim F As Form
4   For Each F In Forms
5       If F.Name = "frmFocus" Then
6           If F.BotIndex = BotIndex Then
                If F.Users.Count = 1 Then
                    If F.IsUser(Username) Then
                        Success = True
                        Set FocusSingle = F
                    End If
                End If
            End If
        End If
    Next
    Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Focus", "FocusSingle"
End Function

