Attribute VB_Name = "modCommands"
Option Explicit

Public Type COMMANDSTRUCT
    Index As Integer
    Console As Boolean
    SpecialRank As RankingStruct
    Message As String
    Username As String
    Whisper As Boolean
    Account As String
End Type

Public Sub PluginCall(Client As Object, Plugin As String, Routine As String, CallType As VbCallType, Index As Integer, Username As String, Args As String, Whisper As Boolean)
    On Error GoTo plugErr:
1   CallByName Client, Routine, CallType, Index, Username, Args, Whisper
    Exit Sub
plugErr:
    ErrorHandler Err.Description, Erl, Plugin, Routine & " (" & Index & ", " & Username & ", " & Args & ")"
End Sub

Public Function PluginCommand(CS As COMMANDSTRUCT, PL As Integer, Command As String, Args As String) As Boolean
    On Error Resume Next
    If LenB(Trim$(Command)) = 0 Then Exit Function
    Dim vc As clsPlugCommand, CurPlugin As String
1   For Each vc In Commands
2       If LCase$(vc.Command) = LCase$(Command) Or LCase$(vc.Alias) = LCase$(Command) Then
            Dim C As Integer
3           For C = 0 To UBound(Plugins)
                If LenB(Plugins(C).Name) And LenB(vc.Plugin) Then
4                   If LCase$(Plugins(C).Name) = LCase$(vc.Plugin) Then
5                       If frmBot.Bot(CS.Index).PluginEnabled(Plugins(C).Name) Then
9                           If PL >= vc.AccessLevel And PL > 0 Then
12                              CurPlugin = Plugins(C).Name
                                PluginCall Plugins(C).Client, CurPlugin, vc.Routine, VbMethod, _
                                    CS.Index, CS.Username, Args, CS.Whisper
14                              If vc.Override Then PluginCommand = True: Exit Function
                            End If
                        End If
                    End If
                End If
            Next C
        End If
    Next vc
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "Commands", "PluginCommand (" & CurPlugin & ")"
    Resume Next
End Function

'If Internal Then
'   use commandCapable()
'Else
'   use Command.Level
'End If



Public Function ParseCommand(CS As COMMANDSTRUCT) As Boolean
    Dim CS2 As COMMANDSTRUCT
    CS2 = CS
    If InStr(CS2.Message, "; ") <> 0 Then
        Dim S() As String, N As Integer
        S = Split(CS2.Message, "; ")
        For N = 0 To UBound(S)
            CS2.Message = S(N)
            If HandleCustomCommand(CS2) = False Then
                If HandleCommand(CS2) Then ParseCommand = True
            Else
                ParseCommand = True
            End If
        Next N
    Else
        If HandleCustomCommand(CS2) = False Then
            If HandleCommand(CS2) Then ParseCommand = True
        Else
            ParseCommand = True
        End If
    End If
End Function

Public Function GetAccess(CS As COMMANDSTRUCT) As RankingStruct
    With frmBot.Bot(CS.Index)
        Dim DB As Integer, R As RankingStruct
        If Not CS.Console Then
            DB = .Database.Find(CS.Username)
            If (DB > -1) Then
                R = GetRankByID(.Database.GetUser(DB).RankID)
            Else
                If .clan.Count <> 0 Then
                    Dim CI As Integer, CR As Long
                    CI = .clan.Find(CS.Account)
                    If CI > -1 Then
                        Select Case .clan.GetByIndex(CI).Rank
                        Case CLANRANKENUM.CHIEFTAIN
                            CR = GetIDByRank(.Config.ARChieftain)
                        Case CLANRANKENUM.GRUNT
                            CR = GetIDByRank(.Config.ARGrunt)
                        Case CLANRANKENUM.PEON
                            CR = GetIDByRank(.Config.ARPeon)
                        Case CLANRANKENUM.SHAMAN
                            CR = GetIDByRank(.Config.ARShaman)
                        Case CLANRANKENUM.INITIATE
                            CR = GetIDByRank(.Config.ARInitiate)
                        End Select
                        If CR > -1 Then R = GetRankByID(CR)
                    Else
                        CR = GetIDByRank(.Config.ARUnclan)
                        If CR > -1 Then R = GetRankByID(CR)
                    End If
                End If
                If Len(R.RankName) = 0 Then
                    If .Friends.Count <> 0 Then
                        Dim FI As Integer, FR As Long, FO As clsFriend
                        For FI = 1 To .Friends.Count
                            Set FO = .Friends(FI)
                            If LCase$(FO.Username) = LCase$(CS.Account) Then
                                FR = GetIDByRank(.Config.ARFriend)
                                If FR > -1 Then
                                    R = GetRankByID(FR)
                                Else
                                    Exit Function
                                End If
                            End If
                        Next
                    End If
                End If
                If Len(R.RankName) = 0 Then Exit Function
            End If
        End If
        GetAccess = R
    End With
End Function

Public Function HandleCommand(CS As COMMANDSTRUCT) As Boolean
On Error GoTo hErr
1   Dim Handled As Boolean, DB As Integer, Count As Long, C As Integer, User As String
2   Dim R As RankingStruct, Command As String, Args As String, U As New clsUser
    
    R = GetAccess(CS)
    If LenB(R.RankName) = 0 Then Exit Function
    
19  'Get Command and cs.Message
20  If InStrB(CS.Message, Space$(1)) <> 0 Then
21      Command = Split(CS.Message, Space$(1))(0)
22      Args = Split(CS.Message, Space$(1), 2)(1)
23      CS.Message = Args
24  Else
25      Command = CS.Message
26      Args = vbNullString
27      CS.Message = Args
28  End If
29
30  With frmBot.Bot(CS.Index)
31      CS.Account = .GetAccount(CS.Username)
32      CS.Whisper = .Config.WhisperBack Or CS.Whisper
33
34      'Find user in database
35      If Not CS.Console Then
36          DB = .Database.Find(CS.Username)
37          If (DB > -1) Then
38              R = GetRankByID(.Database.GetUser(DB).RankID)
39              User = .Database.GetUser(DB).Username
            Else
                If .clan.Count <> 0 Then
                    Dim CI As Integer, CR As Long
                    CI = .clan.Find(CS.Account)
                    If CI > -1 Then
                        Select Case .clan.GetByIndex(CI).Rank
                        Case CLANRANKENUM.CHIEFTAIN
                            CR = GetIDByRank(.Config.ARChieftain)
                        Case CLANRANKENUM.GRUNT
                            CR = GetIDByRank(.Config.ARGrunt)
                        Case CLANRANKENUM.PEON
                            CR = GetIDByRank(.Config.ARPeon)
                        Case CLANRANKENUM.SHAMAN
                            CR = GetIDByRank(.Config.ARShaman)
                        Case CLANRANKENUM.INITIATE
                            CR = GetIDByRank(.Config.ARInitiate)
                        End Select
                        If CR > -1 Then R = GetRankByID(CR)
                    End If
                End If
                If Len(R.RankName) = 0 Then
                    If .Friends.Count <> 0 Then
                        Dim FI As Integer, FR As Long, FO As clsFriend
                        For FI = 1 To .Friends.Count
                            Set FO = .Friends(FI)
                            If LCase$(FO.Username) = LCase$(CS.Account) Then
                                FR = GetIDByRank(.Config.ARFriend)
                                If FR > -1 Then
                                    R = GetRankByID(FR)
                                Else
                                    Exit Function
                                End If
                            End If
                        Next
                    End If
                End If
                If Len(R.RankName) = 0 Then Exit Function
40          End If
            RName = R.RankName
41      Else
            RName = "<Console>"
43          DB = -1
44      End If
45  End With
46  HandleCommand = PluginCommand(CS, pluginLevel(R.RankName), Command, Args)
    If HandleCommand Then Exit Function
    
47  'Check for console commands first
48  With frmBot.Bot(CS.Index)
49      If CS.Console Then
50          Handled = True
51          Select Case UCase$(Command)
            Case "WHOIS", "WHERE": If LenB(Args) > 0 Then .SendAway "/" & Command & Space$(1) & .GetAccount(Args), HI_PRIORITY
            Case "TICTACTOE", "TTT": cmdTicTacToe CS
56          Case "PLUGINS": cmdListPlugins CS.Index
            Case "SCRIPTS": cmdListScripts CS.Index
            Case "COMMANDS": ListCommands CS.Index
            Case "GAMES": cmdGames CS
            Case "FOCUS": cmdFocus CS
            Case "BANS": cmdBans CS
            Case "CLEARBANS": cmdClearBans CS
57          Case "STATS"
58              If InStrB(Args, Space$(1)) = 0 And .Config.IsDiablo Then
59                  Dim UD As New clsUser
60                  Set UD = .Users.GetByName(Args)
61                  If Not UD Is Nothing Then
63                      If UD.Client = "D2DV" Or UD.Client = "D2XP" Then
65                          OutputEvent frmBot.rtbChat(CS.Index), &HB3, , UD.Account & "'s character:"
                            OutputEvent frmBot.rtbChat(CS.Index), &HB3, , GetClientStats(UD.Statstring)
74                      Else
75                          .SendAway "/stats " & Args & Space$(1) & UD.Client
76                      End If
77                  Else
78                      OutputEvent frmBot.rtbChat(CS.Index), &HB2, , "Cannot get Diablo II stats when the user is not in the channel. To get stats for another product type " & ChrW$(34) & "/stats " & Args & " [productID]" & ChrW$(34) & "; valid productIDs are STAR/SEXP/W2BN/WAR3/W3XP!"
79                  End If
80              Else
81                  Handled = False
82              End If
83          Case Else
84              Handled = False
85          End Select
86      End If
87

88      If Handled Then GoTo Final
89
90      'Check for triggered command
91      If CS.Console Or (LenB(R.RankName) <> 0) Then
92          Handled = True
93          Select Case UCase$(Command)
                '//////////////////////////////////////////////
                ' OPERATIONAL COMMANDS
                '\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
                Case "DESIGNATE", "DES": If commandCapable("DESIGNATE", RName) Then .SendAway "/designate " & .GetAccount(Args), HI_PRIORITY
                Case "CONTROL", "CTL": If commandCapable("CONTROL", RName) Then cmdControl CS
                Case "RECONNECT", "RC", "CONNECT": If commandCapable("RECONNECT", RName) Then .Connect
98              Case "QUIT", "EXIT", "DIE", "FUCKOFF": If commandCapable("QUIT", RName) Then Unload frmBot: End
99              Case "SHOW": If commandCapable("SHOW", RName) Then frmBot.Show: frmBot.WindowState = frmBot.LastWindowState
100             Case "HIDE": If commandCapable("HIDE", RName) Then frmBot.Hide: frmBot.WindowState = vbMinimized
101             Case "VERSION", "VER", "V": If commandCapable("VERSION", RName) Then Display CS, frmBot.Title(False) & " by Chriso (www.BnetDev.net)"
102             Case "BUILD": If commandCapable("BUILD", RName) Then Display CS, frmBot.Title(False) & " [build: " & App.Revision & "]"
103             Case "CLEARQUEUE", "CQ": If commandCapable("CLEARQUEUE", RName) Then frmBot.Bot(CS.Index).Queue.Clear: OutputEvent frmBot.rtbChat(CS.Index), &HB1, , "Queue cleared!"
104             Case "UNLOAD": If commandCapable("UNLOAD", RName) Then cmdUnload CS
105             Case "LOAD": If commandCapable("LOAD", RName) Then cmdLoad CS
106             Case "CONNECTALL": If commandCapable("CONNECTALL", RName) Then cmdConnectAll CS
                Case "DATABASE", "DB": If commandCapable("DATABASE", RName) Then cmdDatabase CS
107             Case "GROUP": If commandCapable("GROUP", RName) Then cmdGroup CS
                Case "UNGROUP": If commandCapable("UNGROUP", RName) Then cmdUngroup CS
                Case "GROUPS": If commandCapable("GROUPS", RName) Then cmdGroups CS
                Case "TAG": If commandCapable("TAG", RName) Then cmdAddTag CS
                Case "UNTAG": If commandCapable("UNTAG", RName) Then cmdRemoveTag CS
                Case "TAGS": If commandCapable("TAGS", RName) Then cmdTags CS
                Case "FILTERS": If commandCapable("FILTERS", RName) Then cmdFilters CS
                Case "FILTER": If commandCapable("FILTER", RName) Then cmdAddFilter CS
                Case "UNFILTER": If commandCapable("UNFILTER", RName) Then cmdRemoveFilter CS
                Case "HELP": If commandCapable("HELP", RName) Then cmdHelp CS
                
108             '//////////////////////////////////////////////
109             ' CONFIG COMMANDS
110             '\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
                Case "WHISPERBACK": If commandCapable("WHISPERBACK", RName) Then cmdWhisperBack CS
                Case "SETBACKUP": If commandCapable("SETBACKUP", RName) Then cmdSetBackup CS
111             Case "SETHOME": If commandCapable("SETHOME", RName) Then cmdSetHome CS
112             Case "SETACCOUNT": If commandCapable("SETACCOUNT", RName) Then cmdSetAccount CS
113             Case "SETPASSWORD": If commandCapable("SETPASSWORD", RName) Then cmdSetPassword CS
114             Case "SETNEWPASSWORD": If commandCapable("SETNEWPASSWORD", RName) Then cmdSetNewPassword CS
115             Case "SETTRIGGER": If commandCapable("SETTRIGGER", RName) Then cmdSetTrigger CS
116             Case "SETSERVER": If commandCapable("SETSERVER", RName) Then cmdSetServer CS
117             Case "SETIDLE": If commandCapable("SETIDLE", RName) Then cmdSetIdle CS
118             Case "SETGREET": If commandCapable("SETGREET", RName) Then cmdSetGreet CS
                Case "SETQUEUE": If commandCapable("SETQUEUE", RName) Then cmdSetQueue CS
                Case "ADDQUEUE": If commandCapable("ADDQUEUE", RName) Then cmdAddQueue CS
                Case "QUEUE": If commandCapable("QUEUE", RName) Then cmdQueue CS
                Case "QUEUES": If commandCapable("QUEUES", RName) Then cmdQueues CS
119             Case "IDLE": If commandCapable("IDLE", RName) Then cmdIdle CS
120             Case "GREET": If commandCapable("GREET", RName) Then cmdGreet CS
                Case "IDLEVARS": If commandCapable("IDLEVARS", RName) Then cmdIdleVars CS
                Case "GREETVARS": If commandCapable("GREETVARS", RName) Then cmdGreetVars CS

                '//////////////////////////////////////////////
                ' PLUGIN COMMANDS
                '\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
121             Case "LOADPLUGIN": If commandCapable("LOADPLUGIN", RName) Then cmdPluginLoadUnload CS, 1
122             Case "UNLOADPLUGIN": If commandCapable("UNLOADPLUGIN", RName) Then cmdPluginLoadUnload CS, 0
                Case "LOADSCRIPT": If commandCapable("LOADSCRIPT", RName) Then cmdScriptLoadUnload CS, 1
                Case "UNLOADSCRIPT": If commandCapable("UNLOADSCRIPT", RName) Then cmdScriptLoadUnload CS, 0
123
124             '//////////////////////////////////////////////
125             ' DATABASE COMMANDS
126             '\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
127             Case "FIND": If commandCapable("FIND", RName) Then cmdLookupUser CS
                Case "LIST": If commandCapable("LIST", RName) Then cmdLookupRank CS
128             Case "ADD": If commandCapable("ADD", RName) Then cmdAdd CS, R
129             Case "DELETE", "DEL": If commandCapable("DELETE", RName) Then cmdRemove CS, R
130             Case "ACCESS", "A"
131                 If commandCapable("ACCESS", RName) Then
132                     If DB > -1 Then
133                         Dim DBU As clsDatabaseUser
134                         Set DBU = .Database.GetUser(DB)
135                         Display CS, DBU.Username & "=>" & R.RankName & _
                                " (added by " & DBU.AddBy & " at " & _
                                DBU.AddTime & " on " & DBU.AddDate & ")"
138                     End If
139                 End If

140             '//////////////////////////////////////////////
141             ' BASIC COMMANDS
142             '\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
143             Case "TIME": If commandCapable("TIME", RName) Then Display CS, "System Time: " & Time & " on " & Date & " (" & GetTimeZoneName & ", " & GetCurrentTimeBias & ")": If CS.Console Then Handled = False
144             Case "DATE": If commandCapable("DATE", RName) Then Display CS, "System Date: " & WeekdayName(Weekday(Date, vbUseSystemDayOfWeek)) & Space$(1) & Dayeth(Day(Date)) & " of " & MonthName(Month(Date)) & Space$(1) & Year(Date) & " (week " & DatePart("ww", Date, vbUseSystemDayOfWeek, vbUseSystem) & ")"
145             Case "SAY": If commandCapable("SAY", RName) Then cmdSay CS
                Case "SPEAK": If commandCapable("SPEAK", RName) Then cmdSpeak CS
146             Case "ENCRYPT", "ENC": If commandCapable("ENCRYPT", RName) Then .SendAway ENCRYPTION_CHAR & Encrypt(Args)
147             Case "DECRYPT", "DEC": If commandCapable("DECRYPT", RName) Then If Left$(Args, 1) = ENCRYPTION_CHAR Then .SendAway Decrypt(Mid$(Args, 2)) Else Display CS, "Message does not appear to be encrypted!"
148             Case "EMOTE", "ME": If commandCapable("EMOTE", RName) Then .SendAway "/me " & Args
149             Case "PING", "P": If commandCapable("PING", RName) Then cmdPing CS
150             Case "PINGME", "PME": If commandCapable("PINGME", RName) Then cmdPingMe CS
151             Case "NUDGE": If commandCapable("NUDGE", RName) Then cmdNudge CS
                Case "NUDGESWEEP": If commandCapable("NUDGESWEEP", RName) Then .SendAway "/nudgesweep " & Args
                Case "NUDGEME": If commandCapable("NUDGEME", RName) Then cmdNudgeMe CS
152             Case "UPTIME": If commandCapable("UPTIME", RName) Then Display CS, "Uptime [System: " & DateTimeToShortestString(ConvertTickCount(DblTickCount())) & "], [Bot: " & DateTimeToShortestString(ConvertTickCount(DblTickCount() - TickLaunch)) & "], [Connection: " & DateTimeToShortestString(ConvertTickCount(DblTickCount() - .Self.TickOnline)) & "]"
153             Case "PROFILE": If commandCapable("PROFILE", RName) Then .profileLookup IIf(LenB(CS.Message) = 0, .Self.Username, Suffix(CS.Message)), (Len(CS.Account) > 1)
154             Case "INFO": If commandCapable("INFO", RName) Then cmdInfo CS
155             Case "LASTWHISPER", "LW": If commandCapable("LASTWHISPER", RName) Then If LenB(.Self.UserRE) = 0 Then Display CS, "No one has whispered me yet!" Else Display CS, "Last whisper received from: " & .Self.UserRE
156             Case "CMDADD": If commandCapable("CMDADD", RName) Then cmdAddCmd CS
240             Case "CMDDELETE", "CMDDEL": If commandCapable("CMDDELETE", RName) Then cmdRemoveCmd CS
                Case "CMDVARS": If commandCapable("CMDVARS", RName) Then cmdCmdVars CS
241             Case "CMD": If commandCapable("CMD", RName) Then cmdFindCmd CS
                Case "CMDS": If commandCapable("CMDS", RName) Then cmdCmds CS
                Case "PLUGCMDS": If commandCapable("PLUGCMDS", RName) Then cmdPluginCmd CS
                Case "MACRO": If commandCapable("MACRO", RName) Then cmdGetMacro CS
                
157             '//////////////////////////////////////////////
158             ' CHANNEL COMMANDS
159             '\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
160             Case "FORCE": If commandCapable("FORCE", RName) Then .SendJoinChannel Args, &H2
161             Case "JOIN", "J": If commandCapable("JOIN", RName) Then .SendAway "/join " & Args
162             Case "HOME", "H": If commandCapable("HOME", RName) Then .SendAway "/join " & .Config.Channel
                Case "BACKUP": If commandCapable("BACKUP", RName) Then .SendAway "/join " & .Config.BackupChannel
163             Case "FIRST": If commandCapable("FIRST", RName) Then .SendJoinChannel "The Void", &H1
164             Case "REJOIN", "RJ", "RESIGN": If commandCapable("REJOIN", RName) Then .SendJoinChannel .Self.Channel, &H2
165             Case "LAST": If commandCapable("LAST", RName) Then If LenB(.Self.PreviousChannel) <> 0 Then .SendJoinChannel .Self.PreviousChannel, &H0
166             Case "MASS": If commandCapable("MASS", RName) Then cmdMass CS

167             '//////////////////////////////////////////////
168             ' CLAN COMMANDS
169             '\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
170             Case "DEMOTE": If commandCapable("DEMOTE", RName) Then cmdDemoteMember CS
171             Case "PROMOTE": If commandCapable("PROMOTE", RName) Then cmdPromoteMember CS
172             Case "BOOT": If commandCapable("BOOT", RName) Then cmdRemoveMember CS
173             Case "CP": If commandCapable("CP", RName) Then .SendAway "/clan " & IIf(Val(CS.Message) = 1, "private", "public"), HI_PRIORITY: Display CS, "Channel set to " & IIf(Val(CS.Message) = 1, "private, only clan members can enter!", "public, all users can enter!")
174             Case "INVITE": If commandCapable("INVITE", RName) Then cmdInvite CS
175             Case "SETMOTD": If commandCapable("SETMOTD", RName) Then cmdSetMOTD CS
176             Case "SHAMANS": If commandCapable("SHAMANS", RName) Then cmdShamans CS
177             Case "CHIEFTAIN": If commandCapable("CHIEFTAIN", RName) Then cmdChieftain CS
244             Case "ACCEPT": If commandCapable("ACCEPT", RName) Then cmdAccept CS
245             Case "DECLINE": If commandCapable("DECLINE", RName) Then cmdDecline CS
                
188             '//////////////////////////////////////////////
189             ' MODERATION COMMANDS
190             '\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
191             Case "SWEEP": If commandCapable("SWEEP", RName) Then If .Self.IsOperator Then .SendAway "/sweep " & CS.Message Else Display CS, "I am not an operator!"
192             Case "IPSWEEP": If commandCapable("IPSWEEP", RName) Then If .Self.IsOperator Then .SendAway "/ipsweep " & Args Else Display CS, "I am not an operator!"
193             Case "BANCOUNT", "BC": If commandCapable("BANCOUNT", RName) Then Display CS, "Number of banned users: " & .Banned.Count
196             Case "OP", "GIVEOP": If commandCapable("OP", RName) Then If .Self.IsOperator Then .SendAway "/designate " & .GetAccount(Args): .SendAway "/resign" Else Display CS, "I am not an operator!"
197             Case "CHECKCHANNEL", "CC": If commandCapable("CHECKCHANNEL", RName) Then .CheckChannel
198             Case "UBL": If commandCapable("UBL", RName) Then cmdUBL CS
199             Case "IGNORE", "I": If commandCapable("IGNORE", RName) Then cmdIgnore CS
200             Case "UNIGNORE", "UNI": If commandCapable("UNIGNORE", RName) Then cmdUnignore CS
201             Case "BAN", "B": If commandCapable("BAN", RName) Then cmdBan CS
205             Case "BANIP", "IP": If commandCapable("IPBAN", RName) Then cmdBan CS, True
202             Case "KICK", "K": If commandCapable("KICK", RName) Then cmdKick CS
203             Case "UNBAN", "U": If commandCapable("UNBAN", RName) Then cmdUnban CS
209             Case "UNBANIP", "UNIP": If commandCapable("UNBANIP", RName) Then cmdUnban CS, True
204             Case "DDP": If commandCapable("DDP", RName) Then cmdDDP CS
206             Case "STATUS": If commandCapable("STATUS", RName) Then cmdStatus CS

                Case "CLANADD": If commandCapable("CLANADD", RName) Then cmdClanAdd CS
                Case "CLANDEL": If commandCapable("CLANDEL", RName) Then cmdClanDel CS
                Case "CLANBAN", "CB": If commandCapable("CLANBAN", RName) Then cmdClanBan CS
                Case "CLANS": If commandCapable("CLANS", RName) Then cmdClans CS
                Case "OUTSIDERBAN", "OB": If commandCapable("OUTSIDERBAN", RName) Then cmdOutsiderBan CS
207             Case "IPBAN", "IB": If commandCapable("IPBAN", RName) Then cmdIPBan CS
208             Case "LOCKDOWN", "LD": If commandCapable("LOCKDOWN", RName) Then cmdLockDown CS
210             Case "SMARTBAN", "SB": If commandCapable("SMARTBAN", RName) Then cmdSmartBan CS
211             Case "HASHBAN", "HB": If commandCapable("HASHBAN", RName) Then cmdHashBan CS
213             Case "FLOODBAN", "FB": If commandCapable("FLOODBAN", RName) Then cmdFloodBan CS
214             Case "LOADBAN", "LB": If commandCapable("LOADBAN", RName) Then cmdLoadBan CS
215             Case "NEXTBAN", "NB": If commandCapable("NEXTBAN", RName) Then cmdNextBan CS
216             Case "DODGEBAN", "DO": If commandCapable("DODGEBAN", RName) Then cmdDodgeBan CS
217             Case "RANDOMBAN", "RB": If commandCapable("RANDOMBAN", RName) Then cmdRandomBan CS
218             Case "SAFEUNBAN", "SU": If commandCapable("SAFEUNBAN", RName) Then cmdSafeUnban CS
219             Case "TIMEBAN", "TB": If commandCapable("TIMEBAN", RName) Then cmdTimeBan CS
                Case "REPEATBAN", "RP": If commandCapable("REPEATBAN", RName) Then cmdRepeatBan CS
220         Case Else
221             Handled = False
222         End Select
223     End If

Final:
227     If Handled Then
228         HandleCommand = True
229         Exit Function
230     End If
231 End With
232 HandleCommand = False
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "ManageCommands", "HandleCommand"
End Function

Private Sub Display(CS As COMMANDSTRUCT, Message As String)
    frmBot.Bot(CS.Index).Display CS.Account, Message, CS.Whisper
End Sub


'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' OPERATIONAL COMMANDS
'///////////////////////////////////////////////////////////////////////////////
Private Sub cmdGroup(CS As COMMANDSTRUCT)
    Dim User As String, Splt() As String
    Splt = Split(CS.Message, " ")
    If UBound(Splt) = 1 Then
        If IsGroup(Splt(1)) Then
            User = Suffix(Splt(0))
            If (GetGroupColor(User) <> -1) Then
                Display CS, GetRes("group", "1", User)
            Else
                Dim I As Integer
                For I = 0 To UBound(Groups())
                    If LCase$(Groups(I).Name) = LCase$(Splt(1)) Then
                        Groups(I).Add User
                        Groups(I).SaveGroup
                        Display CS, "Added " & User & " to group " & Groups(I).Name & "!"
                        RefreshChannel
                        Exit Sub
                    End If
                Next I
            End If
        Else
            Display CS, GetRes("group", "2", Splt(1))
        End If
    End If
End Sub
Private Sub cmdGroups(CS As COMMANDSTRUCT)
    Dim X As Integer, buf As String, sent As Boolean
    For X = 0 To UBound(Groups)
        If LenB(Groups(X).Name) > 0 Then
            buf = buf & Groups(X).Name & ", "
            If Len(buf) >= 40 Then
                Display CS, "Groups: " & Left$(buf, Len(buf) - 2)
                buf = vbNullString
                sent = True
            End If
        End If
    Next X
    If Len(buf) > 0 Then
        Display CS, "Groups: " & Left$(buf, Len(buf) - 2)
        buf = vbNullString
        sent = True
    End If
    If Not sent Then Display CS, "No groups found!"
End Sub
Private Sub cmdUngroup(CS As COMMANDSTRUCT)
    Dim I As Integer, C As Integer, Removed As Boolean
    C = UBound(Groups)
    For I = 0 To C
        If Groups(I).Remove(CS.Message) Then Removed = True
        If Removed Then Groups(I).SaveGroup
    Next I
    If Removed Then
        Display CS, GetRes("ungroup", "1")
    Else
        Display CS, GetRes("ungroup", "2", CS.Message)
    End If
    RefreshChannel
End Sub

Private Sub cmdCmdVars(CS As COMMANDSTRUCT)
    Display CS, GetRes("CmdVars", "1")
    Display CS, GetRes("CmdVars", "2")
    Display CS, GetRes("CmdVars", "3")
    Display CS, GetRes("CmdVars", "4")
End Sub
Private Sub cmdIdleVars(CS As COMMANDSTRUCT)
    Display CS, GetRes("Idle", "vars")
End Sub
Private Sub cmdGreetVars(CS As COMMANDSTRUCT)
    Display CS, GetRes("Greet", "vars")
End Sub
Private Sub cmdIdle(CS As COMMANDSTRUCT)
    If LenB(CS.Message) = 0 Then
        Display CS, GetRes("Idle", "3")
        Exit Sub
    End If
    With frmBot.Bot(CS.Index).Config
        Select Case UCase$(CS.Message)
        Case "ON": .Idle = True
            Display CS, GetRes("Idle", "1", OnOff(.Idle))
        Case "OFF": .Idle = False
            Display CS, GetRes("Idle", "1", OnOff(.Idle))
        Case "?"
            Display CS, GetRes("Idle", "2", OnOff(.Idle))
        Case Else
            Display CS, GetRes("Idle", "3")
        End Select
    End With
End Sub
Private Sub cmdGreet(CS As COMMANDSTRUCT)
    If LenB(CS.Message) = 0 Then
        Display CS, GetRes("Greet", "3")
        Exit Sub
    End If
    With frmBot.Bot(CS.Index).Config
        Select Case UCase$(CS.Message)
        Case "ON": .Greet = True
            Display CS, GetRes("Greet", "1", OnOff(.Greet))
        Case "OFF": .Greet = False
            Display CS, GetRes("Greet", "1", OnOff(.Greet))
        Case "?"
            Display CS, GetRes("Greet", "2", OnOff(.Greet))
        Case Else
            Display CS, GetRes("Greet", "3")
        End Select
    End With
End Sub
Private Sub cmdSetGreet(CS As COMMANDSTRUCT)
    With frmBot.Bot(CS.Index).Config
        If LenB(Trim$(CS.Message)) = 0 Then
            .GreetMessage = vbNullString
            .Greet = False
            Display CS, GetRes("greet", "4")
        Else
            .GreetMessage = CS.Message
            Display CS, GetRes("greet", "5")
        End If
    End With
End Sub
Private Sub cmdSetIdle(CS As COMMANDSTRUCT)
    With frmBot.Bot(CS.Index).Config
        If LenB(Trim$(CS.Message)) = 0 Then
            .IdleMessage = vbNullString
            .Idle = False
            Display CS, GetRes("idle", "6")
        Else
            If InStr(CS.Message, " ") > 0 Then
                Dim S() As String, Seconds As Double
                S = Split(CS.Message, " ", 2)
                Seconds = Abs(Val(S(0)))
                If Val(Seconds) > 0 Then
                    .IdleTime = Seconds
                End If
                .IdleMessage = S(1)
                Display CS, GetRes("idle", "4")
            Else
                Display CS, GetRes("idle", "5")
            End If
        End If
    End With
End Sub
Private Sub cmdGames(CS As COMMANDSTRUCT)
    With frmBot.Bot(CS.Index)
        If .Config.IsDiablo Then
            .SendRealmGameList
        Else
            .SendGameList CS.Message
        End If
    End With
End Sub
Private Sub cmdFocus(CS As COMMANDSTRUCT)
    Dim User As String, ui As Integer
    User = Trim$(Suffix(CS.Message))
    frmBot.Bot(CS.Index).Users.Find (User)
    If ui > -1 Then
        Dim frm As Form
        If IsFocusActive(User, frm, CS.Index) = False Then
            Set frm = New frmChatFocus
            frm.BotIndex = CS.Index
            frm.Caption = User
            frm.FocusedUser = User
            frm.Show
            FlashFocusWindow frm
        Else
            Display CS, "User is already being focused on."
            FlashFocusWindow frm
        End If
    Else
        Display CS, "User is not in channel."
    End If
End Sub
Private Sub cmdBans(CS As COMMANDSTRUCT)
    With frmBot.Bot(CS.Index).Banned
        OutputEvent frmBot.rtbChat(CS.Index), &HB2, , "There are currently " & .Count & " recorded bans!"
        Dim I As Integer
        For I = 0 To .Count
            If LenB(.Item(I).Username) Then OutputEvent frmBot.rtbChat(CS.Index), &HB2, , "- " & .Item(I).Username & " (" & .Item(I).Reason & ") banned by " & .Item(I).Operator & " (" & DateTimeToShortestString(ConvertTickCount(DblTickCount - .Item(I).Tick)) & ")"
        Next I
    End With
End Sub
Private Sub cmdClearBans(CS As COMMANDSTRUCT)
    frmBot.Bot(CS.Index).Banned.Clear
    OutputEvent frmBot.rtbChat(CS.Index), &HB1, , "Cleared recorded bans!"
End Sub
Private Sub cmdConnectAll(CS As COMMANDSTRUCT)
    Dim B As BNCS
    For Each B In frmBot.Bot
        If B.IsLoaded And B.IsOnline = False Then B.Connect
    Next B
End Sub
Private Sub cmdUnload(CS As COMMANDSTRUCT)
    With frmBot.Bot(CS.Index)
        If LenB(CS.Message) = 0 Then
            UnloadProfile CS.Index
        Else
            Dim M As Integer
            CS.Message = LCase$(CS.Message)
            For M = 0 To frmBot.Bot.UBound
                If LCase$(frmBot.Bot(M).Profile) = CS.Message And frmBot.Bot(M).IsLoaded Then
                    Display CS, "Unloading profile: " & frmBot.Bot(M).Profile
                    DoEvents
                    UnloadProfile frmBot.Bot(M).BotIndex
                End If
            Next M
            Display CS, "That profile is not loaded!"
        End If
    End With
End Sub
Private Sub cmdLoad(CS As COMMANDSTRUCT)
    If LenB(CS.Message) = 0 Then
        Display CS, "Please specify a profile to load!"
        Exit Sub
    End If
    With frmBot.Bot(CS.Index)
        Dim J As Folders, F As folder, K As Integer, found As Boolean, NewName As String
        Set J = FolderList(AppData & "Profiles\")
        For Each F In J
            If LCase$(CS.Message) = LCase$(F.Name) Then
                found = True
                NewName = F.Name
                For K = 0 To frmBot.Bot.UBound
                    If LCase$(frmBot.Bot(K).Profile) = LCase$(CS.Message) And frmBot.Bot(K).IsLoaded Then
                        Display CS, "That profile is already loaded!"
                    End If
                Next K
            End If
        Next
        If Not found Then
            Display CS, "That profile does not exist!"
        ElseIf found And LenB(NewName) <> 0 Then
            Display CS, "Loading profile: " & NewName
            LoadProfile NewName
        End If
    End With
End Sub

'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' FILTERING COMMANDS
'///////////////////////////////////////////////////////////////////////////////
Private Sub cmdFilters(CS As COMMANDSTRUCT)
    Dim X As Integer, buf As String, sent As Boolean
    For X = 0 To UBound(Filters)
        If Filters(X).blnUser = False Then
            If LenB(Filters(X).strText) > 0 Then
                buf = buf & Filters(X).strText & ", "
                If Len(buf) >= 40 Then
                    Display CS, "Message: " & Left$(buf, Len(buf) - 2)
                    buf = vbNullString
                    sent = True
                End If
            End If
        End If
    Next X
    If Len(buf) > 0 Then
        Display CS, "Message: " & Left$(buf, Len(buf) - 2)
        buf = vbNullString
        sent = True
    End If
    For X = 0 To UBound(Filters)
        If Filters(X).blnUser = True Then
            If LenB(Filters(X).strText) > 0 Then
                buf = buf & Filters(X).strText & ", "
                If Len(buf) >= 40 Then
                    Display CS, "User: " & Left$(buf, Len(buf) - 2)
                    buf = vbNullString
                    sent = True
                End If
            End If
        End If
    Next X
    If Len(buf) > 0 Then
        Display CS, "User: " & Left$(buf, Len(buf) - 2)
        buf = vbNullString
        sent = True
    End If
    If Not sent Then Display CS, "No filters found!"
End Sub
Private Sub cmdRemoveFilter(CS As COMMANDSTRUCT)
    If InStr(CS.Message, " ") > 0 Then
        Dim S() As String
        S = Split(CS.Message, " ", 2)
        If UBound(S) = 1 Then
            Select Case UCase$(S(0))
            Case "U"
                If RemoveFilter(S(1), True) Then
                    Display CS, "Removed user filter: " & S(1) & "."
                Else
                    Display CS, "User filter not found: " & S(1) & "."
                End If
                Exit Sub
            Case "M"
                'Debug.Print S(1)
                If RemoveFilter(S(1), False) Then
                    Display CS, "Removed message filter: " & S(1) & "."
                Else
                    Display CS, "Message filter not found: " & S(1) & "."
                End If
                Exit Sub
            End Select
        End If
    End If
    Display CS, "Syntax error, try: /unfilter [M/U] [message/user]"
End Sub
Private Sub cmdAddFilter(CS As COMMANDSTRUCT)
    If InStr(CS.Message, " ") > 0 Then
        Dim S() As String
        S = Split(CS.Message, " ", 2)
        If UBound(S) = 1 Then
            Select Case UCase$(S(0))
            Case "U"
                If AddFilter(S(1), True) Then
                    Display CS, "Added user filter: " & S(1) & "."
                Else
                    Display CS, "Replaced user filter: " & S(1) & "."
                End If
                Exit Sub
            Case "M"
                If AddFilter(S(1), False) Then
                    Display CS, "Added message filter: " & S(1) & "."
                Else
                    Display CS, "Replaced message filter: " & S(1) & "."
                End If
                Exit Sub
            End Select
        End If
    End If
    Display CS, "Syntax error, try: /filter [M/U] [message/user]"
End Sub

Private Sub cmdSay(CS As COMMANDSTRUCT)
    If CS.Console Then
        frmBot.Bot(CS.Index).SendAway CS.Message
    Else
        frmBot.Bot(CS.Index).SendAway CS.Username & " says: " & CS.Message
    End If
End Sub

Private Sub cmdSpeak(CS As COMMANDSTRUCT)
    If CS.Console = False Then
        If Left$(CS.Message, 1) = "/" Then
            If Len(CS.Message) > 4 And InStrB(CS.Message, " ") > 0 Then
                Select Case LCase$(Mid$(CS.Message, 2, InStr(CS.Message, " ") - 2))
                Case "ban", "kick", "designate", "resign", "rejoin", "join", "j", "rj", "unban", "ignore", "unignore"
                    frmBot.Bot(CS.Index).SendAway "Cannot send that command using 'speak'."
                    Exit Sub
                End Select
            End If
        End If
    End If
    frmBot.Bot(CS.Index).SendAway CS.Message
End Sub

'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' TAGGING COMMANDS
'///////////////////////////////////////////////////////////////////////////////
Private Sub cmdTags(CS As COMMANDSTRUCT)
    Dim X As Integer, buf As String, sent As Boolean
    For X = 0 To UBound(Tags)
        If Tags(X).blnUser = False Then
            If LenB(Tags(X).strText) > 0 Then
                buf = buf & Tags(X).strText & ", "
                If Len(buf) >= 40 Then
                    Display CS, "Channel: " & Left$(buf, Len(buf) - 2)
                    buf = vbNullString
                    sent = True
                End If
            End If
        End If
    Next X
    If Len(buf) > 0 Then
        Display CS, "Channel: " & Left$(buf, Len(buf) - 2)
        buf = vbNullString
        sent = True
    End If
    For X = 0 To UBound(Tags)
        If Tags(X).blnUser = True Then
            If LenB(Tags(X).strText) > 0 Then
                buf = buf & Tags(X).strText & ", "
                If Len(buf) >= 40 Then
                    Display CS, "User: " & Left$(buf, Len(buf) - 2)
                    buf = vbNullString
                    sent = True
                End If
            End If
        End If
    Next X
    If Len(buf) > 0 Then
        Display CS, "User: " & Left$(buf, Len(buf) - 2)
        buf = vbNullString
        sent = True
    End If
    If Not sent Then Display CS, "No tags found!"
End Sub
Private Sub cmdRemoveTag(CS As COMMANDSTRUCT)
    If InStr(CS.Message, " ") > 0 Then
        Dim S() As String
        S = Split(CS.Message, " ", 2)
        If UBound(S) = 1 Then
            Select Case UCase$(S(0))
            Case "U"
                If RemoveTag(S(1), True) Then
                    Display CS, "Removed user tagr: " & S(1) & "."
                Else
                    Display CS, "User tag not found: " & S(1) & "."
                End If
                Exit Sub
            Case "C"
                If RemoveTag(S(1), False) Then
                    Display CS, "Removed channel tag: " & S(1) & "."
                Else
                    Display CS, "Channel tag not found: " & S(1) & "."
                End If
                Exit Sub
            End Select
        End If
    End If
    Display CS, "Syntax error, try: /untag [C/U] [channel/user]"
End Sub
Private Sub cmdAddTag(CS As COMMANDSTRUCT)
    If InStr(CS.Message, " ") > 0 Then
        Dim S() As String, N() As String
        S = Split(CS.Message, " ", 2)
        If UBound(S) = 1 Then
            Select Case UCase$(S(0))
            Case "U"
                If InStr(S(1), ">") > 0 Then
                    N = Split(S(1), ">")
                    N(0) = Trim$(N(0))
                    N(1) = Trim$(N(1))
                    If AddTag(N(0), N(1), True) Then
                        Display CS, "Added tag for user: " & N(0) & "."
                    Else
                        Display CS, "Replaced tag for user: " & N(0) & "."
                    End If
                Else
                    Display CS, "Syntax error, try: /tag U [user] > [tag]"
                End If
                Exit Sub
            Case "C"
                If InStr(S(1), ">") > 0 Then
                    N = Split(S(1), ">")
                    N(0) = Trim$(N(0))
                    N(1) = Trim$(N(1))
                    If AddTag(N(0), N(1), False) Then
                        Display CS, "Added tag for channel: " & N(0) & "."
                    Else
                        Display CS, "Replaced tag for channel: " & N(0) & "."
                    End If
                Else
                    Display CS, "Syntax error, try: /tag C [channel] > [tag]"
                End If
                Exit Sub
            End Select
        End If
    End If
    Display CS, "Syntax error, try: /tag [C/U] [channel/user] -> [tag]"
End Sub

'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' BASIC COMMANDS
'///////////////////////////////////////////////////////////////////////////////
Private Sub cmdPing(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   With frmBot.Bot(CS.Index)
2       Dim U As New clsUser
3       If LenB(CS.Message) = 0 Then
4           Display CS, "My ping is: " & .Self.Ping & "ms"
5       Else
6           Set U = .Users.GetByName(CS.Message)
7           If Not U Is Nothing Then
                If LenB(U.Account) = 0 Then
                    Display CS, CS.Message & " is not in the channel!"
                Else
8                   Display CS, U.Account & " has a ping of: " & U.Ping & "ms"
                End If
9           Else
10              Display CS, CS.Message & " is not in the channel!"
11          End If
12      End If
13  End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "Ping"
End Sub
Private Sub cmdPingMe(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   With frmBot.Bot(CS.Index)
2       Dim U As New clsUser
3       Set U = .Users.GetByName(CS.Account)
4       If Not U Is Nothing Then Display CS, "Your ping is: " & U.Ping & "ms"
5   End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "PingMe"
End Sub
Private Sub cmdInfo(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   With frmBot.Bot(CS.Index)
2       Dim U As New clsUser
3       Set U = .Users.GetByName(CS.Message)
4       If Not U Is Nothing Then Display CS, U.Account & " [" & LongToHex(U.Flags) & ", " & U.Ping & "ms] " & _
            "joined " & DateTimeToShortString(ConvertTickCount(DblTickCount() - U.TickJoin)) & " ago, " & _
            "talked " & DateTimeToShortString(ConvertTickCount(DblTickCount() - U.TickTalk)) & " ago."
5   End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "Info"
End Sub
Private Sub cmdMass(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       Display CS, "Please specify a channel to move bots to!"
3       Exit Sub
4   End If
5   With frmBot.Bot(CS.Index)
6       Dim B As BNCS
7       For Each B In frmBot.Bot
8           If ServerMatch(B.Config.Server, .Config.Server) Then B.SendAway "/join " & CS.Message, HI_PRIORITY
9       Next B
10  End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "Mass"
End Sub


'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' CONFIG RELATED
'///////////////////////////////////////////////////////////////////////////////
Private Sub cmdSetHome(CS As COMMANDSTRUCT)
On Error GoTo hErr:
5   With frmBot.Bot(CS.Index)
1       If LenB(CS.Message) = 0 Then
            .Config.Channel = .Self.Channel
2           Display CS, "Home channel changed to: " & .Config.Channel
4       Else
6           .Config.Channel = CS.Message
7           Display CS, "Home channel changed to: " & .Config.Channel
        End If
8   End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "SetHome"
End Sub
Private Sub cmdWhisperBack(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   With frmBot.Bot(CS.Index).Config
        Select Case UCase$(CS.Message)
        Case "ON"
            .WhisperBack = True
2           Display CS, "WhisperBack is now: " & OnOff(.WhisperBack)
        Case "OFF"
            .WhisperBack = False
3           Display CS, "WhisperBack is now: " & OnOff(.WhisperBack)
        Case Else
4           Display CS, "WhisperBack is currently: " & OnOff(.WhisperBack)
        End Select
    End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "WhisperBack"
End Sub
Private Sub cmdSetBackup(CS As COMMANDSTRUCT)
On Error GoTo hErr:
5   With frmBot.Bot(CS.Index)
1       If LenB(CS.Message) = 0 Then
            .Config.BackupChannel = .Self.Channel
2           Display CS, "Backup channel changed to: " & .Config.BackupChannel
4       Else
6           .Config.BackupChannel = CS.Message
7           Display CS, "Backup channel changed to: " & .Config.BackupChannel
        End If
8   End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "SetBackup"
End Sub
Private Sub cmdSetAccount(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       Display CS, "Please specify a new account!"
3       Exit Sub
4   End If
5   With frmBot.Bot(CS.Index)
6       .Config.Username = CS.Message
7       Display CS, "Account changed to: " & CS.Message
8   End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "SetAccount"
End Sub
Private Sub cmdSetPassword(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       Display CS, "Please specify the account's password!"
3       Exit Sub
4   End If
5   With frmBot.Bot(CS.Index)
6       .Config.Password = CS.Message
7       Display CS, "Password changed!"
8   End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "SetPassword"
End Sub
Private Sub cmdSetNewPassword(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       Display CS, "Please specify a new password for the account!"
3       Exit Sub
4   End If
5   With frmBot.Bot(CS.Index)
6       .Config.NewPassword = CS.Message
7       Display CS, "New password set, reconnect to carry out change!"
8   End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "SetNewPassword"
End Sub
Private Sub cmdSetTrigger(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       Display CS, "Please specify a new trigger!"
3       Exit Sub
4   End If
5   With frmBot.Bot(CS.Index)
6       .Config.Trigger = CS.Message
7       Display CS, "Trigger changed to: " & CS.Message
8   End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "SetTrigger"
End Sub
Private Sub cmdQueues(CS As COMMANDSTRUCT)
On Error GoTo hErr:
    Dim F() As String, I As Integer, buf As String, e As Boolean
1   F = FileList(AppData & "Queues\*.ini")
2   For I = 0 To UBound(F)
3       If Len(F(I)) > 4 Then
            Dim S As String
4           S = Left$(F(I), Len(F(I)) - 4)
5           buf = buf & S & ", "
6           If Len(buf) > 50 Then
7               Display CS, "Queues: " & Left$(buf, Len(buf) - 2)
8               buf = vbNullString
9               e = True
            End If
        End If
    Next I
10  If Len(buf) > 0 Then
11      Display CS, "Queues: " & Left$(buf, Len(buf) - 2)
12      buf = vbNullString
        e = True
    End If
    If Not e Then
13      Display CS, "No queues created."
    End If
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "cmdQueues"
End Sub
Private Sub cmdAddQueue(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   If Len(CS.Message) = 0 Then
2       Display CS, "Please specify [queue] [values]."
        Exit Sub
    End If
    Dim T() As String, N As String, Q As String
3   T = Split(CS.Message, " ")
4   If Len(T(0)) = 0 Then
5       Display CS, "Please specify a queue name."
        Exit Sub
    End If
6   N = AppData & "Queues\" & T(0) & ".ini"
7   Q = "Queue"
8   If UBound(T) = 1 Then
        Dim F() As String, I As Integer, found As Boolean
9       F = FileList(AppData & "Queues\*.ini")
10      For I = 0 To UBound(F)
11          If Len(F(I)) > 4 Then
                Dim S As String
12              S = Left$(F(I), Len(F(I)) - 4)
13              If LCase$(T(0)) = LCase$(S) Then
                    found = True
                    Exit For
                End If
            End If
        Next I
14      If Not found Then
15          If InStr(T(1), ",") <> 0 Then
                Dim U() As String
16              U = Split(T(1), ",")
17              If UBound(U) = 5 Then
18                  WriteINI N, Q, "BASE", Val(U(0)) & ""
19                  WriteINI N, Q, "LENGTH", Val(U(1)) & ""
20                  WriteINI N, Q, "FREQ", Val(U(2)) & ""
21                  WriteINI N, Q, "MAX", Val(U(3)) & ""
22                  WriteINI N, Q, "EXTRA", Val(U(4)) & ""
23                  WriteINI N, Q, "EVERY", Val(U(5)) & ""
24                  Display CS, "Added new queue: " & T(0)
                Else
25                  Display CS, "Please specify queue values (e.g. 1500,15,15,6000,1500,3)"
                End If
            End If
        Else
26          Display CS, "Queue with that name already exists."
        End If
    Else
27      Display CS, "Please specify [name] [values]."
    End If
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "cmdAddQueue"
End Sub
Private Sub cmdQueue(CS As COMMANDSTRUCT)
On Error GoTo hErr:
    With frmBot.Bot(CS.Index)
        Display CS, "Current queue: " & .Config.Queue & " (" & .Queue.BaseDelay & "," & .Queue.LengthDelay & "," & .Queue.FrequencyDelay & "," & .Queue.MaximumDelay & "," & .Queue.ExtraDelay & "," & .Queue.EveryDelay & ")"
    End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "cmdQueue"
End Sub
Private Sub cmdSetQueue(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       Display CS, "Please specify a queue to switch to!"
3       Exit Sub
4   End If
    Dim F() As String, I As Integer
5   F = FileList(AppData & "Queues\*.ini")
6   For I = 0 To UBound(F)
7       If Len(F(I)) > 4 Then
            Dim S As String
8           S = Left$(F(I), Len(F(I)) - 4)
9           If LCase$(CS.Message) = LCase$(S) Then
10              With frmBot.Bot(CS.Index)
11                  .Config.Queue = S
12                  .Queue.Load AppData & "Queues\" & S & ".ini"
13                  Display CS, "Queue changed to: " & S & " (" & .Queue.BaseDelay & "," & .Queue.LengthDelay & "," & .Queue.FrequencyDelay & "," & .Queue.MaximumDelay & "," & .Queue.ExtraDelay & "," & .Queue.EveryDelay & ")"
                    Exit Sub
                End With
            End If
        End If
    Next I
14  With frmBot.Bot(CS.Index)
15      .Config.Queue = S
16      .Queue.Load AppData & "Queues\Default.ini"
17      Display CS, "Queue reverted to: Default"
    End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "cmdSetQueue"
End Sub
Private Sub cmdSetServer(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       Display CS, "Please specify a new server!"
3       Exit Sub
4   End If
5   With frmBot.Bot(CS.Index)
6       .Config.Server = CS.Message
7       Display CS, "Server changed to: " & CS.Message
8   End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "SetServer"
End Sub


'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' DATABASE RELATED
'///////////////////////////////////////////////////////////////////////////////
Private Sub cmdDatabase(CS As COMMANDSTRUCT)
    Dim I As Integer, C As Integer, buf As String, S As Boolean, RS As Boolean, DBT As Integer
    C = UBound(Ranking)
    For I = 0 To C
        If LenB(Ranking(I).RankName) > 0 Then
            Dim DBC As Integer
            DBC = frmBot.Bot(CS.Index).Database.CountRanked(Ranking(I).RankName)
            DBT = DBT + DBC
            buf = buf & Ranking(I).RankName & "/" & Ranking(I).Alias & " (" & DBC & "), "
        End If
        If Len(buf) >= 150 Then
            Display CS, IIf(RS, "... ", "Database: ") & Left$(buf, Len(buf) - 2) & IIf(I = C, ".", " ...")
            RS = True
            buf = vbNullString
            S = True
        End If
    Next I
    If Len(buf) > 0 Then
        Display CS, IIf(RS, "... ", "Database: ") & Left$(buf, Len(buf) - 2) & "."
        buf = vbNullString
        S = True
    End If
    If DBT > 0 Then Display CS, "There are a total of " & DBT & " users belonging to " & UBound(Ranking) + 1 & " ranks."
    If Not S Then Display CS, "Error: no ranks found!"
End Sub
Private Sub cmdLookupRank(CS As COMMANDSTRUCT)
On Error GoTo hErr:
    If modRanks.rankingExists(CS.Message) Then
        With frmBot.Bot(CS.Index).Database
            Dim U As clsDatabaseUser, RI As Integer
            Dim R() As String, I As Integer, RankUser As String, RankCount As Integer, RankSent As Boolean
            R = .GetRanked(CS.Message)
            If UBound(R) > 0 Then
                Display CS, UBound(R) + 1 & " users found with rank " & """" & GetRankByID(GetIDByRank(CS.Message)).RankName & """" & ":"
                For I = 0 To UBound(R)
                    If LenB(R(I)) Then
                        RankCount = RankCount + 1
                        Set U = Nothing
                        If InStr(R(I), "*") Then
                            RI = .FindPattern(R(I))
                            If RI > -1 Then
                                Set U = .GetUser(RI)
                            Else
                                RI = .Find(R(I))
                                If RI > -1 Then Set U = .GetUser(RI)
                            End If
                        Else
                            RI = .Find(R(I))
                            If RI > -1 Then Set U = .GetUser(RI)
                        End If
                        If Not U Is Nothing Then
                            RankUser = RankUser & U.Username & ", "
                        End If
                        If LenB(RankUser) > 150 Then
                            Display CS, IIf(RankSent, "... ", vbNullString) & Left$(RankUser, Len(RankUser) - 2) & IIf(I = UBound(R), ".", " ...")
                            RankCount = 0
                            RankUser = vbNullString
                            RankSent = True
                        End If
                    End If
                Next
17              If RankCount > 0 Then
18                  Display CS, IIf(RankSent, "... ", vbNullString) & Left$(RankUser, Len(RankUser) - 2) & "."
19                  RankCount = 0
20                  RankUser = vbNullString
21              End If
            Else
                If LenB(R(0)) = 0 Then
                    Display CS, "No users belong to the rank " & """" & GetRankByID(GetIDByRank(CS.Message)).RankName & """" & "!"
                Else
                    Set U = Nothing
                    If InStr(R(0), "*") Then
                        RI = .FindPattern(R(0))
                        If RI > -1 Then
                            Set U = .GetUser(RI)
                        Else
                            RI = .Find(R(0))
                            If RI > -1 Then Set U = .GetUser(RI)
                        End If
                    Else
                        RI = .Find(R(0))
                        If RI > -1 Then Set U = .GetUser(RI)
                    End If
                    If Not U Is Nothing Then
                        Display CS, U.Username & "=>" & GetRankByID(U.RankID).RankName & " (added by " & U.AddBy & " at " & U.AddTime & " on " & U.AddDate & ")"
                    End If
                End If
            End If
        End With
    Else
        Display CS, "That is not a valid rank."
    End If
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "Commands", "LookupRank"
End Sub
Private Sub cmdLookupUser(CS As COMMANDSTRUCT)
On Error GoTo hErr:
    If InStrB(CS.Message, Space$(1)) <> 0 Or LenB(CS.Message) = 0 Then
        Display CS, "Please specify a user or pattern to lookup!"
        Exit Sub
    End If
0   With frmBot.Bot(CS.Index)
1       Dim U As New clsDatabaseUser, Match() As Integer, mF As Integer, MatchText As String, MatchCount As Long, LookupSent As Boolean, PF As Integer
        PF = .Database.FindPattern(CS.Message)
        If PF > -1 Then
            Set U = .Database.GetUser(PF)
            Display CS, U.Username & "=>" & GetRankByID(U.RankID).RankName & " (added by " & U.AddBy & " at " & U.AddTime & " on " & U.AddDate & ")"
            Exit Sub
        End If
2       If .Database.MatchUser(CS.Message, Match) Then
3           If UBound(Match) > 0 Then
4               Display CS, UBound(Match) + 1 & " users found matching " & """" & CS.Message & """" & ":"
5               For mF = 0 To UBound(Match)
6                   MatchCount = MatchCount + 1
7                   With .Database.GetUser(Match(mF))
8                       MatchText = MatchText & .Username & " (" & GetRankByID(.RankID).Alias & "), "
9                   End With
10                  If Len(MatchText) > 150 Then
11                      Display CS, IIf(LookupSent, "... ", vbNullString) & Left$(MatchText, Len(MatchText) - 2) & IIf(mF = UBound(Match), ".", " ...")
12                      MatchCount = 0
13                      MatchText = vbNullString
14                      LookupSent = True
15                  End If
16              Next
17              If MatchCount > 0 Then
18                  Display CS, IIf(LookupSent, "... ", vbNullString) & Left$(MatchText, Len(MatchText) - 2) & "."
19                  MatchCount = 0
20                  MatchText = vbNullString
21              End If
22          ElseIf UBound(Match) = 0 Then
24              Set U = .Database.GetUser(Match(mF))
25              Display CS, U.Username & "=>" & GetRankByID(U.RankID).RankName & " (added by " & U.AddBy & " at " & U.AddTime & " on " & U.AddDate & ")"
26          End If
27      Else
28          Display CS, "No users matched criteria!"
29      End If
30  End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "LookupUser"
End Sub
Private Sub cmdAdd(CS As COMMANDSTRUCT, R As RankingStruct)
On Error GoTo hErr:
    If InStrB(CS.Message, " ") = 0 Or LenB(CS.Message) = 0 Then
        Display CS, "Please specify a user and rank to add someone to the database!"
        Exit Sub
    End If
1   Dim S() As String: S = Split(CS.Message, Space$(1))
2   Dim AddRank As RankingStruct: AddRank = getRanking(S(1))
3   Dim RetVal As String
4
5   With frmBot.Bot(CS.Index)
6       If AddRank.UserGroup And LenB(AddRank.RankName) <> 0 Then
7           If AddRank.PatternMatch Then
8               If rankManaged(R, AddRank) Then
18                  If .Database.Add(S(0), AddRank.RankName, , , CS.Username, RetVal) Then
                        Display CS, "Added user " & S(0) & _
                            " to " & """" & AddRank.RankName & """" & " rank!"
                        .CheckChannel
                    Else
                        Display CS, RetVal
                    End If
20              Else
21                  Display CS, "Your rank is not capable of adding users to " & """" & AddRank.RankName & """" & " rank!"
22              End If
23          Else
24              If rankManaged(R, AddRank) Then
25                  Dim I As Integer, Added As Boolean, Buffer As String, Conflict As Integer, sent As Boolean, Users() As String
26                  Users = .Users.Match(S(0))
27                  Added = False
28                  For I = 0 To UBound(Users)
29                      If .Database.Add(Users(I), AddRank.RankName, , , CS.Username, RetVal) Then
30                          If LenB(Users(I)) > 0 Then
31                              Buffer = Buffer & Users(I) & ", "
32                              Added = True
33                          End If
34                      Else
35                          Conflict = Conflict + 1
36                      End If
37                      If Len(Buffer) > 150 Then
38                          If Not sent Then
39                              Display CS, "Added users to " & """" & AddRank.RankName & """" & " rank: " & _
                                    Left$(Buffer, Len(Buffer) - 2) & IIf(I < UBound(Users), " ...", ".")
41                              sent = True
42                          Else
43                              Display CS, "... " & AddRank.RankName & ": " & _
                                    Left$(Buffer, Len(Buffer) - 2) & IIf(I < UBound(Users), " ...", ".")
45                          End If
46                          Buffer = vbNullString
47                      End If
48                  Next I
49                  If Added Then
50                      If Len(Buffer) > 3 Then
51                          If Not sent Then
52                              Display CS, "Added users to " & """" & AddRank.RankName & """" & " rank: " & _
                                    Left$(Buffer, Len(Buffer) - 2) & "."
54                              sent = True
55                          Else
56                              Display CS, "... " & AddRank.RankName & ": " & _
                                    Left$(Buffer, Len(Buffer) - 2) & "."
58                          End If
59                          Buffer = vbNullString
60                      End If
61                      If Conflict > 0 Then
62                          Display CS, "Conflicts encountered: " & Conflict
63                      End If
64                  Else
65                      If InStrB(S(0), "*") = 0 Then
66                          If .Database.Add(S(0), AddRank.RankName, , , CS.Username, RetVal) Then
67                                  Display CS, "Added user " & S(0) & _
                                        " to " & """" & AddRank.RankName & """" & " rank!"
69                                  .CheckChannel
70                          Else
71                              Display CS, RetVal
72                          End If
73                      Else
74                          Display CS, "This rank only allows exact users to be added!"
75                      End If
76                  End If
77                  .CheckChannel
78              Else
79                  Display CS, "Your rank is not capable of adding users to " & """" & AddRank.RankName & """" & " rank!"
80              End If
81          End If
82      Else
83          Display CS, "Invalid rank name!"
84      End If
85  End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "Add"
End Sub
Private Sub cmdRemove(CS As COMMANDSTRUCT, R As RankingStruct)
On Error GoTo hErr:
    If LenB(CS.Message) = 0 Or InStrB(CS.Message, " ") <> 0 Then
        Display CS, "Please specify a user to remove from the database!"
        Exit Sub
    End If
    Dim Remove() As Integer, I As Integer, Buffer As String, RemoveSent As Boolean
    Dim Find As Integer, U As clsDatabaseUser
    
1   With frmBot.Bot(CS.Index)
2       Find = .Database.FindPattern(CS.Message)
3       If Find > -1 Then
4           Set U = .Database.GetUser(Find)
5           If GetRankByID(.Database.GetUser(Find).RankID).PatternMatch Then
6               If rankManaged(R, GetRankByID(U.RankID)) Then
7                   If .Database.Remove(CS.Message) Then
8                       Display CS, "Removed user: " & CS.Message & "."
9                       Exit Sub
10                  End If
11              Else
12                  Display CS, "Your rank is unable to remove this user!"
13              End If
14          Else
15              If rankManaged(R, GetRankByID(U.RankID)) Then
16                  If .Database.Remove(CS.Message) Then
17                      Display CS, "Removed user: " & CS.Message & "."
18                      Exit Sub
19                  End If
20              Else
21                  Display CS, "Your rank is unable to remove this user!"
22              End If
23          End If
24      End If
25      If .Database.MatchUser(CS.Message, Remove) Then
26          Dim D() As clsDatabaseUser
27          ReDim D(UBound(Remove))
28          For I = 0 To UBound(Remove)
29              Set D(I) = .Database.GetUser(Remove(I))
30          Next I
31          For I = 0 To UBound(Remove)
32              Dim RemRank As RankingStruct
33              RemRank = GetRankByID(D(I).RankID)
34              If Not RemRank.PatternMatch Then
35                  If rankManaged(R, RemRank) Then
36                      If .Database.Remove(D(I).Username) Then
37                          Buffer = Buffer & D(I).Username & ", "
38                      End If
39                  End If
40                  If Len(Buffer) > 150 Then
41                      If RemoveSent Then
42                          Display CS, "... " & Left$(Buffer, Len(Buffer) - 2) & IIf(I = UBound(Remove), ".", " ...")
43                      Else
44                          Display CS, "Removed users: " & Left$(Buffer, Len(Buffer) - 2) & IIf(I = UBound(Remove), ".", " ...")
45                      End If
46                      Buffer = vbNullString
47                      RemoveSent = True
48                  End If
49              End If
50          Next
51          ReDim D(0)
52          If Len(Buffer) > 0 Then
53              If RemoveSent Then
54                  Display CS, "... " & Left$(Buffer, Len(Buffer) - 2) & "."
55              Else
56                  Display CS, "Removed users: " & Left$(Buffer, Len(Buffer) - 2) & "."
57              End If
58              Buffer = vbNullString
59              RemoveSent = True
60          End If
63      End If
64      If Not RemoveSent Then
65          Display CS, "No users matched criteria!"
66      End If
67  End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "Remove"
End Sub





'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' MODERATION RELATED
'///////////////////////////////////////////////////////////////////////////////
Private Sub cmdBan(CS As COMMANDSTRUCT, Optional IP As Boolean = False)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       Display CS, "Please specify a user to ban!"
3       Exit Sub
4   End If
5   With frmBot.Bot(CS.Index)
6       Dim banUser As String, banMessage As String, I As Integer
7       If InStrB(CS.Message, Space$(1)) <> 0 Then
8           banUser = Split(CS.Message, Space$(1))(0)
9           banMessage = Space$(1) & Split(CS.Message, Space$(1), 2)(1)
10      Else
11          banUser = CS.Message
12          banMessage = vbNullString
13      End If
        banUser = Replace$(banUser, """", " ")
        banUser = Replace$(banUser, ",", " ")
        
14      If InStr(banUser, "*") > 1 Or banUser = "*" Then
15          For I = 0 To .Users.Count
16              Dim U As clsUser
17              Set U = .Users.GetByIndex(I)
18              If Matches(U.Account, banUser) Then
19                  If Not .Database.GetSafe(U.Username) Then
20                      If U.IsBannable Then
                            If IP Then .SendAway "/ignore " & U.Account, HI_PRIORITY
                            .SendAway "/ban " & U.Account & banMessage, HI_PRIORITY
                        End If
21                  End If
22              End If
23          Next I
24      Else
25          If .Database.GetSafe(banUser) Then
26              Display CS, "User (" & banUser & ") is safelisted!"
27          Else
28              If IP Then .SendAway "/ignore " & banUser, HI_PRIORITY
32              .SendAway "/ban " & banUser & banMessage, HI_PRIORITY
29          End If
30      End If
31  End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "Ban"
End Sub
Private Sub cmdDDP(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       Display CS, "Please specify a user to designate!"
3       Exit Sub
4   End If
5   With frmBot.Bot(CS.Index)
6       .PerformDDP CS.Account, CS.Message
7   End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "DDP"
End Sub
Private Sub cmdUnban(CS As COMMANDSTRUCT, Optional IP As Boolean = False)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       Display CS, "Please specify a user to unban!"
3       Exit Sub
4   End If
5   With frmBot.Bot(CS.Index)
6       If InStr(CS.Message, "*") > 1 Or CS.Message = "*" Then
7           Dim Asterisk As Boolean, I As Integer
8           For I = 1 To .Banned.Count
9               If Matches(Suffix(.Banned.Item(I).Username), CS.Message) Then
10                  .SendAway "/unban " & .GetAccount(.Banned.Item(I).Username), HI_PRIORITY
23                  If IP Then .SendAway "/unignore " & .GetAccount(.Banned.Item(I).Username), HI_PRIORITY
11                  Asterisk = True
12              End If
13          Next I
14          If Not Asterisk And .Config.IsDiablo And Left$(CS.Message, 1) = "*" Then
15              .SendAway "/unban " & CS.Message, HI_PRIORITY
21              If IP Then .SendAway "/unignore " & CS.Message, HI_PRIORITY
16          End If
17      Else
18          .SendAway "/unban " & CS.Message, HI_PRIORITY
22          If IP Then .SendAway "/unignore " & CS.Message, HI_PRIORITY
19      End If
20  End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "Unban"
End Sub
Private Sub cmdKick(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       Display CS, "Please specify a user to kick!"
3       Exit Sub
4   End If
5   With frmBot.Bot(CS.Index)
6       Dim KickUser As String, KickMessage As String, I As Integer
7       If InStrB(CS.Message, Space$(1)) <> 0 Then
8           KickUser = Split(CS.Message, Space$(1))(0)
9           KickMessage = Space$(1) & Split(CS.Message, Space$(1), 2)(1)
10      Else
11          KickUser = CS.Message
12          KickMessage = vbNullString
13      End If
        KickUser = Replace$(KickUser, """", " ")
        KickUser = Replace$(KickUser, ",", " ")
        
14
15      If InStr(KickUser, "*") > 1 Or KickUser = "*" Then
16          For I = 0 To .Users.Count
17              Dim U As clsUser
18              Set U = .Users.GetByIndex(I)
19              If Matches(U.Account, KickUser) Then
20                  If Not .Database.GetSafe(U.Account) Then
21                      If U.IsBannable Then .SendAway "/kick " & U.Account & KickMessage, HI_PRIORITY
22                  End If
23              End If
24          Next I
25      Else
26          If .Database.GetSafe(KickUser) Then
27              Display CS, "User (" & KickUser & ") is safelisted!"
28          Else
29              .SendAway "/kick " & KickUser & KickMessage, HI_PRIORITY
30          End If
31      End If
32  End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "Kick"
End Sub

Private Sub cmdUnignore(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       Display CS, "Please specify a user to unignore!"
3       Exit Sub
4   End If
5   With frmBot.Bot(CS.Index)
6       Dim UnignoreUser As String, I As Integer
7       UnignoreUser = CS.Message
8       If InStrB(UnignoreUser, "*") <> 0 Then
9           Dim UnignoreFound As Boolean
10          For I = 0 To .Users.Count
11              Dim U As clsUser
12              Set U = .Users.GetByIndex(I)
13              If Matches(U.Account, UnignoreUser) Then
14                  If (Not U.IsIgnored) Then
15                      .SendAway "/unignore " & U.Account, HI_PRIORITY
16                      UnignoreFound = True
17                  End If
18              End If
19          Next I
20          If Not UnignoreFound Then .SendAway "/unignore " & UnignoreUser
21      Else
22          .SendAway "/unignore " & UnignoreUser, HI_PRIORITY
23      End If
24  End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "Unignore"
End Sub
Private Sub cmdIgnore(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   If LenB(CS.Message) = 0 Then
2       Display CS, ReadINI(AppRes, "Ignore", "1")
3       Exit Sub
4   End If
5   With frmBot.Bot(CS.Index)
6       Dim IgnoreUser As String, I As Integer
7       IgnoreUser = CS.Message
8       If InStr(IgnoreUser, "*") > 1 Or IgnoreUser = "*" Then
9           Dim IgnoreFound As Boolean
10          For I = 0 To .Users.Count
11              Dim U As clsUser
12              Set U = .Users.GetByIndex(I)
13              If Matches(U.Account, IgnoreUser) Then
14                  If Not .Database.GetSafe(U.Username) Then
15                      If (Not U.IsIgnored) Then
16                          .SendAway "/ignore " & U.Account, HI_PRIORITY
17                          IgnoreFound = True
18                      End If
19                  End If
20              End If
21          Next I
22          If Not IgnoreFound Then .SendAway "/ignore " & IgnoreUser
23      Else
24          If .Database.GetSafe(IgnoreUser) Then
25              Display CS, Replace$(ReadINI(AppRes, "Ignore", "2"), "%s", IgnoreUser)
26          Else
27              .SendAway "/ignore " & IgnoreUser, HI_PRIORITY
28          End If
29      End If
30  End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "Ignore"
End Sub
Private Sub cmdFloodBan(CS As COMMANDSTRUCT)
    If LenB(CS.Message) = 0 Then
        Display CS, GetRes("Mod", "FB3")
        Exit Sub
    End If
    With frmBot.Bot(CS.Index).Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .FloodBan = True
            Display CS, GetRes("Mod", "FB1", OnOff(.FloodBan))
        Case "OFF": .FloodBan = False
            Display CS, GetRes("Mod", "FB1", OnOff(.FloodBan))
        Case "?"
            Display CS, GetRes("Mod", "FB2", OnOff(.FloodBan))
        Case Else
            Display CS, GetRes("Mod", "FB3")
        End Select
    End With
End Sub
Private Sub cmdLoadBan(CS As COMMANDSTRUCT)
    If LenB(CS.Message) = 0 Then
        Display CS, GetRes("Mod", "LB3")
        Exit Sub
    End If
    With frmBot.Bot(CS.Index).Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .LoadBan = True
            Display CS, GetRes("Mod", "LB1", OnOff(.LoadBan))
        Case "OFF": .LoadBan = False
            Display CS, GetRes("Mod", "LB1", OnOff(.LoadBan))
        Case "?"
            Display CS, GetRes("Mod", "LB2", OnOff(.LoadBan))
        Case Else
            Display CS, GetRes("Mod", "LB3")
        End Select
    End With
End Sub
Private Sub cmdGetMacro(CS As COMMANDSTRUCT)
    Dim Content() As String
    Content = GetMacro(CS.Message)
    If UBound(Content) > 0 Or LenB(Content(0)) > 0 Then
        Dim I As Integer
        For I = 0 To UBound(Content)
            frmBot.Bot(CS.Index).SendAway Content(I), LO_PRIORITY
        Next I
    Else
        frmBot.Bot(CS.Index).SendAway "Macro does not exist!", LO_PRIORITY
    End If
End Sub
Private Sub cmdStatus(CS As COMMANDSTRUCT)
    With frmBot.Bot(CS.Index).Config.Op
        Display CS, "DodgeBan (" & OnOff(.DodgeBan) & _
                    "), FloodBan (" & OnOff(.FloodBan) & _
                    "), HashBan (" & OnOff(.HashBan) & _
                    "), IPBan (" & OnOff(.IPBan) & ")" & _
                    "), LoadBan (" & OnOff(.LoadBan) & _
                    "), LockDown (" & OnOff(.LockDown) & _
                    "), NextBan (" & OnOff(.NextBan) & ")"
        Display CS, "RandomBan (" & OnOff(.RandomBan) & _
                    "), RepeatBan (" & OnOff(.RepeatBan) & _
                    "), SafeUnban (" & OnOff(.SafeUnban) & _
                    "), SmartBan (" & OnOff(.SmartBan)
    End With
End Sub
Private Sub cmdIPBan(CS As COMMANDSTRUCT)
    If LenB(CS.Message) = 0 Then
        Display CS, GetRes("Mod", "IP3")
        Exit Sub
    End If
    With frmBot.Bot(CS.Index).Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .IPBan = True
            Display CS, GetRes("Mod", "IP1", OnOff(.IPBan))
        Case "OFF": .IPBan = False
            Display CS, GetRes("Mod", "IP1", OnOff(.IPBan))
        Case "?"
            Display CS, GetRes("Mod", "IP2", OnOff(.IPBan))
        Case Else
            Display CS, GetRes("Mod", "IP3")
        End Select
    End With
End Sub
Private Sub cmdSmartBan(CS As COMMANDSTRUCT)
    If LenB(CS.Message) = 0 Then
        Display CS, GetRes("Mod", "SB3")
        Exit Sub
    End If
    With frmBot.Bot(CS.Index).Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .SmartBan = True
            Display CS, GetRes("Mod", "SB1", OnOff(.SmartBan))
        Case "OFF": .SmartBan = False
            Display CS, GetRes("Mod", "SB1", OnOff(.SmartBan))
        Case "?"
            Display CS, GetRes("Mod", "SB2", OnOff(.SmartBan))
        Case Else
            Display CS, GetRes("Mod", "SB3")
        End Select
    End With
End Sub
Private Sub cmdDodgeBan(CS As COMMANDSTRUCT)
    If LenB(CS.Message) = 0 Then
        Display CS, GetRes("Mod", "DO3")
        Exit Sub
    End If
    With frmBot.Bot(CS.Index).Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .DodgeBan = True
            Display CS, GetRes("Mod", "DO1", OnOff(.DodgeBan))
        Case "OFF": .DodgeBan = False
            Display CS, GetRes("Mod", "DO1", OnOff(.DodgeBan))
        Case "?"
            Display CS, GetRes("Mod", "DO2", OnOff(.DodgeBan))
        Case Else
            Display CS, GetRes("Mod", "DO3")
        End Select
    End With
End Sub
Private Sub cmdNextBan(CS As COMMANDSTRUCT)
    If LenB(CS.Message) = 0 Then
        Display CS, GetRes("Mod", "NB3")
        Exit Sub
    End If
    With frmBot.Bot(CS.Index).Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .NextBan = True
            Display CS, GetRes("Mod", "NB1", OnOff(.NextBan))
        Case "OFF": .NextBan = False
            Display CS, GetRes("Mod", "NB1", OnOff(.NextBan))
        Case "?"
            Display CS, GetRes("Mod", "NB2", OnOff(.NextBan))
        Case Else
            Display CS, GetRes("Mod", "NB3")
        End Select
    End With
End Sub
Private Sub cmdLockDown(CS As COMMANDSTRUCT)
    If LenB(CS.Message) = 0 Then
        Display CS, GetRes("Mod", "LD3")
        Exit Sub
    End If
    With frmBot.Bot(CS.Index).Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .LockDown = True
            Display CS, GetRes("Mod", "LD1", OnOff(.LockDown))
        Case "OFF": .LockDown = False
            Display CS, GetRes("Mod", "LD1", OnOff(.LockDown))
        Case "?"
            Display CS, GetRes("Mod", "LD2", OnOff(.LockDown))
        Case Else
            Display CS, GetRes("Mod", "LD3")
        End Select
    End With
End Sub
Private Sub cmdHashBan(CS As COMMANDSTRUCT)
    If LenB(CS.Message) = 0 Then
        Display CS, GetRes("Mod", "HB3")
        Exit Sub
    End If
    With frmBot.Bot(CS.Index).Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .HashBan = True
            Display CS, GetRes("Mod", "HB1", OnOff(.HashBan))
        Case "OFF": .HashBan = False
            Display CS, GetRes("Mod", "HB1", OnOff(.HashBan))
        Case "?"
            Display CS, GetRes("Mod", "HB2", OnOff(.HashBan))
        Case Else
            Display CS, GetRes("Mod", "HB3")
        End Select
    End With
End Sub
Private Sub cmdClanAdd(CS As COMMANDSTRUCT)
    If Len(CS.Message) <> 0 Then
        If frmBot.Bot(CS.Index).Config.Op.ClanAdd(CS.Message) Then
            Display CS, "Added clan ban: " & RestrictAZ(CS.Message)
        Else
            Display CS, "Unable to add clan ban (conflict or invalid length)."
        End If
    Else
        Display CS, "Unable to add clan ban (invalid length)."
    End If
End Sub
Private Sub cmdClanDel(CS As COMMANDSTRUCT)
    If Len(CS.Message) <> 0 Then
        If frmBot.Bot(CS.Index).Config.Op.ClanDel(CS.Message) Then
            Display CS, "Deleted clan ban: " & RestrictAZ(CS.Message)
        Else
            Display CS, "Unable to delete clan ban (invalid length or not found)."
        End If
    Else
        Display CS, "Unable to delete clan ban (invalid length)."
    End If
End Sub
Private Sub cmdClans(CS As COMMANDSTRUCT)
    Dim M As String
    M = frmBot.Bot(CS.Index).Config.Op.GetClans
    If LenB(M) = 0 Then
        Display CS, "No clan bans added yet, type " & frmBot.Bot(CS.Index).Config.Trigger & "clanadd [clan]."
    Else
        Display CS, "Clan bans: " & M
    End If
End Sub
Private Sub cmdClanBan(CS As COMMANDSTRUCT)
    If LenB(CS.Message) = 0 Then
        Display CS, GetRes("Mod", "CB3")
        Exit Sub
    End If
    With frmBot.Bot(CS.Index).Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .ClanBan = True
            Display CS, GetRes("Mod", "CB1", OnOff(.ClanBan))
        Case "OFF": .ClanBan = False
            Display CS, GetRes("Mod", "CB1", OnOff(.ClanBan))
        Case "?"
            Display CS, GetRes("Mod", "CB2", OnOff(.ClanBan))
        Case Else
            Display CS, GetRes("Mod", "CB3")
        End Select
    End With
End Sub
Private Sub cmdOutsiderBan(CS As COMMANDSTRUCT)
    If LenB(CS.Message) = 0 Then
        Display CS, GetRes("Mod", "OB3")
        Exit Sub
    End If
    With frmBot.Bot(CS.Index).Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .OutsiderBan = True
            Display CS, GetRes("Mod", "OB1", OnOff(.OutsiderBan))
        Case "OFF": .OutsiderBan = False
            Display CS, GetRes("Mod", "OB1", OnOff(.OutsiderBan))
        Case "?"
            Display CS, GetRes("Mod", "OB2", OnOff(.OutsiderBan))
        Case Else
            Display CS, GetRes("Mod", "OB3")
        End Select
    End With
End Sub
Private Sub cmdRandomBan(CS As COMMANDSTRUCT)
    If LenB(CS.Message) = 0 Then
        Display CS, GetRes("Mod", "RB3")
        Exit Sub
    End If
    With frmBot.Bot(CS.Index).Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .RandomBan = True
            Display CS, GetRes("Mod", "RB1", OnOff(.RandomBan))
        Case "OFF": .RandomBan = False
            Display CS, GetRes("Mod", "RB1", OnOff(.RandomBan))
        Case "?"
            Display CS, GetRes("Mod", "RB2", OnOff(.RandomBan))
        Case Else
            Display CS, GetRes("Mod", "RB3")
        End Select
    End With
End Sub
Private Sub cmdRepeatBan(CS As COMMANDSTRUCT)
    If LenB(CS.Message) = 0 Then
        Display CS, GetRes("Mod", "RP3")
        Exit Sub
    End If
    With frmBot.Bot(CS.Index).Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .RepeatBan = True
            Display CS, GetRes("Mod", "RP1", OnOff(.RepeatBan))
        Case "OFF": .RepeatBan = False
            Display CS, GetRes("Mod", "RP1", OnOff(.RepeatBan))
        Case "?"
            Display CS, GetRes("Mod", "RP2", OnOff(.RepeatBan))
        Case Else
            Display CS, GetRes("Mod", "RP3")
        End Select
    End With
End Sub
Private Sub cmdSafeUnban(CS As COMMANDSTRUCT)
    If LenB(CS.Message) = 0 Then
        Display CS, GetRes("Mod", "SU3")
        Exit Sub
    End If
    With frmBot.Bot(CS.Index).Config.Op
        Select Case UCase$(CS.Message)
        Case "ON": .SafeUnban = True
            Display CS, GetRes("Mod", "SU1", OnOff(.SafeUnban))
        Case "OFF": .SafeUnban = False
            Display CS, GetRes("Mod", "SU1", OnOff(.SafeUnban))
        Case "?"
            Display CS, GetRes("Mod", "SU2", OnOff(.SafeUnban))
        Case Else
            Display CS, GetRes("Mod", "SU3")
        End Select
    End With
End Sub
'I could simply return "Note: Command overlap encountered on command 'say'"
Private Sub cmdTimeBan(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   With frmBot.Bot(CS.Index)
2       If InStrB(CS.Message, Space$(1)) <> 0 Then
3           Dim mSplt() As String
4           mSplt = Split(CS.Message, Space$(1))
5           If Not .Database.GetSafe(mSplt(0)) And CStr(Val(mSplt(1))) = mSplt(1) Then
6               .SendAway "/ban " & .GetAccount(mSplt(0)) & " TimeBan => " & Val(mSplt(1)), HI_PRIORITY
7               Dim mb As New clsModTimeBan
8               mb.Minutes = Val(mSplt(1))
9               mb.Username = mSplt(0)
10              .TimeBans.Add mb
11          Else
12              Display CS, GetRes("timeban", "1")
13          End If
14      Else
15          Display CS, GetRes("timeban", "2")
16      End If
17  End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "UBL"
End Sub
Private Sub cmdNudge(CS As COMMANDSTRUCT)
    With frmBot.Bot(CS.Index)
        If LenB(CS.Message) > 0 Then
            If InStrB(CS.Message, " ") <> 0 Then
                Dim S() As String
                S() = Split(CS.Message, " ", 2)
                .SendAway "/w " & S(0) & " [NUDG2]" & S(1), HI_PRIORITY
            Else
                .SendAway "/w " & CS.Message & " [NUDGE]", HI_PRIORITY
            End If
        End If
    End With
End Sub
Private Sub cmdNudgeMe(CS As COMMANDSTRUCT)
    With frmBot.Bot(CS.Index)
        If LenB(CS.Account) = 0 Then
            TryNudge CS.Index, "<Console>", CS.Message
        Else
            TryNudge CS.Index, CS.Account, CS.Message
        End If
    End With
End Sub
Private Sub cmdUBL(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   With frmBot.Bot(CS.Index)
2       If .Self.IsOperator Then
3           If (LenB(.Self.UserUBL) > 0) Then
4               .SendAway "/unban " & .Self.UserUBL, HI_PRIORITY
5               .Self.UserUBL = vbNullString
6           Else
7               Display CS, GetRes("ubl", "1")
8           End If
9       Else
10          Display CS, GetRes("ubl", "2")
11      End If
12  End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "UBL"
End Sub



'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' CLAN RELATED
'///////////////////////////////////////////////////////////////////////////////
Private Sub cmdDemoteMember(CS As COMMANDSTRUCT)
On Error GoTo hErr
1   With frmBot.Bot(CS.Index)
2       If .clan.InClan Then
3           If .clan.Rank = CHIEFTAIN Or .clan.Rank = SHAMAN Then
4               If .clan.IsMember(CS.Message) Then
5                   Dim CR As CLANRANKENUM
6                   CR = .clan.GetByName(CS.Message).Rank
7                   If (CR > PEON) And (CR < .clan.Rank) Then
8                       .SendClanRankChange CS.Message, CR - 1
9                   Else
10                      Display CS, GetRes("depromote", "1", "Demote")
11                  End If
12              Else
13                  Display CS, GetRes("depromote", "2")
14              End If
15          Else
16              Display CS, GetRes("depromote", "3", "Demote")
17          End If
18      Else
19          Display CS, GetRes("depromote", "4", "Demote")
20      End If
    End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "DemoteMember"
End Sub
Private Sub cmdPromoteMember(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   With frmBot.Bot(CS.Index)
2       If .clan.InClan Then
3           If .clan.Rank = CHIEFTAIN Or .clan.Rank = SHAMAN Then
4               If .clan.IsMember(CS.Message) Then
5                   Dim CR As CLANRANKENUM
6                   CR = .clan.GetByName(CS.Message).Rank
7                   If (CR > INITIATE) And (CR < SHAMAN) Then
8                       .SendClanRankChange CS.Message, CR + 1
9                   Else
10                      Display CS, GetRes("depromote", "1", "Promote")
11                  End If
12              Else
13                  Display CS, GetRes("depromote", "2")
14              End If
15          Else
16              Display CS, GetRes("depromote", "3", "Promote")
17          End If
18      Else
19          Display CS, GetRes("depromote", "4", "Promote")
20      End If
21  End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "PromoteMember"
End Sub
Private Sub cmdAddCmd(CS As COMMANDSTRUCT)
On Error GoTo hErr:
    If InStrB(CS.Message, " ") Then
        Dim I As Integer, S() As String
        S = Split(CS.Message, " ", 3)
        If UBound(S) = 2 Then
            If AddCommand(S(0), S(1), S(2)) Then
                Display CS, "Added command: " & S(0)
                SaveCommands
            Else
                Display CS, GetRes("addcmd", "1")
            End If
        Else
            Display CS, GetRes("addcmd", "3")
        End If
    Else
        Display CS, GetRes("addcmd", "3")
    End If
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "ManageCommands", "AddCmd"
End Sub
Private Sub cmdRemoveCmd(CS As COMMANDSTRUCT)
    If LenB(CS.Message) Then
        If RemoveCommand(CS.Message) Then
            Display CS, "Removed command: " & CS.Message
            SaveCommands
        Else
            Display CS, GetRes("delcmd", "1")
        End If
    Else
        Display CS, GetRes("delcmd", "2")
    End If
End Sub
Private Sub cmdCmds(CS As COMMANDSTRUCT)
    Dim I As Integer, C As Boolean, S As String
    For I = 0 To UBound(CustComm)
        If LenB(CustComm(I).ctCommand) Then
            S = S & CustComm(I).ctCommand & ", "
            If Len(S) >= 35 Then
                If Not C Then
                    Display CS, "Commands: " & Left$(S, Len(S) - 2)
                    C = True
                Else
                    Display CS, Left$(S, Len(S) - 2)
                End If
            End If
        End If
    Next I
    If LenB(S) Then
        If Not C Then
            Display CS, "Commands: " & Left$(S, Len(S) - 2) & "."
        Else
            Display CS, Left$(S, Len(S) - 2) & "."
        End If
    End If
End Sub
Private Sub cmdFindCmd(CS As COMMANDSTRUCT)
    If LenB(CS.Message) Then
        Dim I As Integer
        I = FindCommand(CS.Message)
        If I = -1 Then
            Display CS, "Command with that name does not exist!"
        Else
            Display CS, "Command [" & CustComm(I).ctCommand & ", " & CustComm(I).ctRank & "]: " & CustComm(I).ctResponse
        End If
    Else
        Display CS, "Please specify the command to find!"
    End If
End Sub
Private Sub cmdRemoveMember(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   With frmBot.Bot(CS.Index)
2       If .clan.Rank = SHAMAN Or .clan.Rank = CHIEFTAIN Then
3           .SendClanMemberRemove CS.Message
4       Else
5           Display CS, "Remove requires shaman or chieftain rank!"
6       End If
7   End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "RemoveMember"
End Sub
Private Sub cmdControl(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   If InStr(CS.Message, " ") <> 0 Then
        Dim S() As String, F As New FileSystemObject
2       S = Split(CS.Message, " ", 2)
3       If F.FolderExists(AppData & "Profiles\" & S(0)) Then
            If IsProfileLoaded(S(0)) Then
                Dim css As COMMANDSTRUCT
4               css = CS
5               css.Message = S(1)
                css.Index = modProfiles.GetProfileIndex(S(0))
6               If Not HandleCommand(css) Then
7                   Display css, "Command " & """" & Prefix(S(1), " ") & """" & " does not exist!"
                End If
            Else
                Display CS, "Profile " & """" & S(0) & """" & " is not loaded! Use /load [profile]."
            End If
        Else
8           Display CS, "Profile " & """" & S(0) & """" & " does not exist!"
        End If
    Else
9       Display CS, "Syntax incorrect, use: /control [profile] [command]."
    End If
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "Control"
End Sub
Private Sub cmdInvite(CS As COMMANDSTRUCT)
On Error GoTo hErr:
    If LenB(CS.Message) = 0 Then
        Display CS, "Please specify a user to invite!"
        Exit Sub
    End If
    With frmBot.Bot(CS.Index)
        If .clan.Rank = CHIEFTAIN Or .clan.Rank = SHAMAN Then
            .SendClanInvitation CS.Message
            Display CS, "Invite sent to " & CS.Message & "..."
        Else
            Display CS, "Invite requires shaman or chieftain rank!"
        End If
    End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "Invite"
End Sub
Private Sub cmdSetMOTD(CS As COMMANDSTRUCT)
On Error GoTo hErr:
    If LenB(CS.Message) = 0 Then
        Display CS, "Please specify a new clan Message Of The Day!"
        Exit Sub
    End If
    With frmBot.Bot(CS.Index)
        If .clan.Rank = CHIEFTAIN Or .clan.Rank = SHAMAN Then
            .SendClanSetMOTD CS.Message
            Display CS, "Changed MOTD: " & CS.Message
        Else
            Display CS, "Changing the MOTD requires shaman or chieftain rank!"
        End If
    End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "SetMOTD"
End Sub
Private Sub cmdAccept(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   With frmBot.Bot(CS.Index)
2       If (DblTickCount() - .clan.TickInviteResp) > 45000 Then
3           Display CS, "No pending clan requests or clan request expired!"
        Else
4           If .clan.InviteRespType = 1 Then
5               Display CS, "Accepted clan invitation!"
                .SendClanInvitationResponse True
6           ElseIf .clan.InviteRespType = 2 Then
7               Display CS, "Accepted clan creation invitation!"
                .SendClanCreateInvite True
            End If
        End If
    End With
    Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "Accept"
End Sub
Private Sub cmdDecline(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   With frmBot.Bot(CS.Index)
2       If DblTickCount() - .clan.TickInviteResp > 45000 Then
3           Display CS, "No pending clan requests or clan request expired!"
        Else
4           If .clan.InviteRespType = 1 Then
5               Display CS, "Declined clan invitation!"
                .SendClanInvitationResponse False
6           ElseIf .clan.InviteRespType = 2 Then
7               Display CS, "Declined clan creation invitation!"
                .SendClanCreateInvite False
            End If
        End If
    End With
    Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "Decline"
End Sub
Private Sub cmdShamans(CS As COMMANDSTRUCT)
On Error GoTo hErr:
1   With frmBot.Bot(CS.Index)
2       If .clan.InClan Then
3           Dim I As Integer, Buffer As String, ShamanSent As Boolean
4           For I = 0 To .clan.Count
5               Dim C As clsClanMember
6               Set C = .clan.GetByIndex(I)
7               If C.Rank = SHAMAN Then Buffer = Buffer & C.Username & ", "
10              If LenB(Buffer) >= 70 Then
11                  Display CS, IIf(ShamanSent, "... ", "Shamans: ") & Left$(Buffer, Len(Buffer) - 2)
                    Buffer = vbNullString
12                  If Not ShamanSent Then ShamanSent = True
13              End If
14          Next I
15          If LenB(Buffer) > 0 Then
16              Display CS, IIf(ShamanSent, "... ", "Shamans: ") & Left$(Buffer, Len(Buffer) - 2)
                Buffer = vbNullString
17              If Not ShamanSent Then ShamanSent = True
18          End If
19      Else
20          Display CS, "You are not a member of a clan!"
21      End If
22  End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "Shamans"
End Sub
Private Sub cmdChieftain(CS As COMMANDSTRUCT)
On Error GoTo hErr:
    With frmBot.Bot(CS.Index)
        If .clan.InClan Then
            Dim I As Integer
            For I = 0 To .clan.Count
                Dim C As clsClanMember
                Set C = .clan.GetByIndex(I)
                If C.Rank = CHIEFTAIN Then Display CS, "Chieftain: " & C.Username: Exit Sub
            Next I
            Display CS, "Error, no chieftain found?!"
        Else
            Display CS, "You are not a member of a clan!"
        End If
    End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "Chieftain"
End Sub




'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' PLUGIN RELATED
'///////////////////////////////////////////////////////////////////////////////
Private Sub cmdListPlugins(ByRef Index As Integer)
On Error GoTo hErr:
1   Dim I As Integer, Count As Integer
2   With frmBot
3       OutputEvent frmBot.rtbChat(Index), &HB1, , "Download more plugins by going to www.bnetdev.net"
5       Count = UBound(Plugins)
4       OutputEvent frmBot.rtbChat(Index), &HB3, , Count & " Installed Plugins:"
6       For I = 1 To Count
7           On Error Resume Next
8           If .Bot(Index).PluginEnabled(Plugins(I).Name) Then
9               OutputEvent frmBot.rtbChat(Index), &HB1, , "ON: " & Plugins(I).Client.Plugin_Version
10          Else
11              OutputEvent frmBot.rtbChat(Index), &HB2, , "OFF: " & Plugins(I).Client.Plugin_Version
12          End If
13          If Err Then
14              Err.Clear
15              If .Bot(Index).PluginEnabled(Plugins(I).Name) Then
16                  OutputEvent frmBot.rtbChat(Index), &HB1, , "ON: " & Plugins(I).Name
17              Else
18                  OutputEvent frmBot.rtbChat(Index), &HB2, , "OFF: " & Plugins(I).Name
19              End If
20          End If
21      Next
22  End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "ListPlugins"
End Sub
Private Sub cmdListScripts(ByRef Index As Integer)
On Error GoTo hErr:
1   Dim I As Integer, Count As Integer, Scripts() As String
    Scripts = FileList(AppData & "\Scripts\*.*")
2   With frmBot
3       OutputEvent frmBot.rtbChat(Index), &HB1, , "Download more scripts by going to www.bnetdev.net"
5       Count = UBound(Scripts)
4       OutputEvent frmBot.rtbChat(Index), &HB3, , Count & " Installed Scripts:"
6       For I = 0 To Count
            If InStrB(Scripts(I), ".") Then
                Dim ScriptName As String, ScriptExt As String
                ScriptExt = LCase$(Mid$(Scripts(I), InStrRev(Scripts(I), ".")))
                ScriptName = Left$(Scripts(I), InStrRev(Scripts(I), ".") - 1)
                If ScriptExt = ".vbs" Then
15                  If .Bot(Index).ScriptEnabled(ScriptName) Then
16                      OutputEvent frmBot.rtbChat(Index), &HB1, , "ON: " & ScriptName
17                  Else
18                      OutputEvent frmBot.rtbChat(Index), &HB2, , "OFF: " & ScriptName
19                  End If
                End If
            End If
21      Next
22  End With
Exit Sub
hErr:
ErrorHandler Err.Description, Erl, "ManageCommands", "ListScripts"
End Sub
Private Sub cmdScriptLoadUnload(CS As COMMANDSTRUCT, I As Integer)
    With frmBot.Bot(CS.Index)
        Dim FSO As New FileSystemObject
        If FSO.FileExists(AppData & "Scripts\" & CS.Message & ".vbs") Then
            If I = 0 Then
                UnloadScript CS.Message
                Display CS, "Script '" & CS.Message & "' is now disabled!"
            Else
                LoadScript CS.Message
                Display CS, "Script '" & CS.Message & "' is now enabled!"
            End If
        Else
            Display CS, "Script does not exist!"
        End If
        .ReloadPluginsScripts
    End With
End Sub
Private Sub cmdPluginLoadUnload(CS As COMMANDSTRUCT, I As Integer)
    With frmBot.Bot(CS.Index)
        If IsPlugin(CS.Message) Then
            WriteINI .ProfilePath, "Plugins", CS.Message, CStr(I)
            Display CS, "Plugin '" & CS.Message & "' is now " & IIf(I = 0, "disabled!", "enabled!")
        Else
            Display CS, "Plugin does not exist!"
        End If
        .ReloadPluginsScripts
    End With
End Sub
Private Sub cmdPluginCmd(CS As COMMANDSTRUCT)
    With frmBot.Bot(CS.Index)
        If IsPlugin(CS.Message) Then
            Dim T As String
            T = CmdPlugin(CS.Message)
            If LenB(T) Then
                Display CS, "Plugin commands: " & T
            Else
                Display CS, "Plugin does not have any registered commands."
            End If
        Else
            Display CS, "Plugin does not exist!"
        End If
    End With
End Sub


'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' CONSOLE ONLY
'///////////////////////////////////////////////////////////////////////////////
Private Sub cmdTicTacToe(CS As COMMANDSTRUCT)
    With frmBot.Bot(CS.Index)
        If LenB(CS.Message) > 0 Then
            If LCase$(Suffix(CS.Message)) <> LCase$(.Self.Username) Then
                .SendAway "/w " & .GetAccount(CS.Message) & " $_begin", HI_PRIORITY
            Else
                OutputEvent frmBot.rtbChat(CS.Index), &HB2, , "Trying to play with yourself? Sad..."
            End If
        End If
    End With
End Sub

Private Sub cmdHelp(CS As COMMANDSTRUCT)
    Dim R As String, o As String, A As String, RS As String
    R = commandRank(CS.Message)
    A = vbNullString
    o = vbNullString
    RS = AppRes
    Select Case LCase$(CS.Message)
    Case "say", "echo": o = ReadINI(RS, "Help", "say"): R = commandRank("say")
    Case "speak": o = ReadINI(RS, "Help", "speak"): R = commandRank("speak")
    Case "build": o = ReadINI(RS, "Help", "build")
    Case "clearqueue", "cq": o = ReadINI(RS, "Help", "clearqueue"): R = commandRank("clearqueue")
    Case "date": o = ReadINI(RS, "Help", "date")
    Case "time": o = ReadINI(RS, "Help", "time")
    Case "decrypt", "dec": o = ReadINI(RS, "Help", "decrypt"): R = commandRank("decrypt")
    Case "encrypt", "enc": o = ReadINI(RS, "Help", "encrypt"): R = commandRank("encrypt")
    Case "first": o = ReadINI(RS, "Help", "first")
    Case "join", "j": o = ReadINI(RS, "Help", "join"): R = commandRank("join")
    Case "force": o = ReadINI(RS, "Help", "force")
    Case "home", "h": o = ReadINI(RS, "Help", "home"): R = commandRank("home")
    Case "info": o = ReadINI(RS, "Help", "info")
    Case "last": o = ReadINI(RS, "Help", "last")
    Case "lastwhisper", "lw": o = ReadINI(RS, "Help", "lastwhisper")
    Case "macro": o = ReadINI(RS, "Help", "macro")
    Case "mass": o = ReadINI(RS, "Help", "mass")
    Case "nudge": o = ReadINI(RS, "Help", "nudge")
    Case "nudgesweep": o = ReadINI(RS, "Help", "nudgesweep")
    Case "nudgeme": o = ReadINI(RS, "Help", "nudgeme")
    Case "ping", "p": o = ReadINI(RS, "Help", "ping"): R = commandRank("ping")
    Case "pingme", "pme": o = ReadINI(RS, "Help", "pingme"): R = commandRank("pingme")
    Case "profile": o = ReadINI(RS, "Help", "profile")
    Case "rejoin", "rj": o = ReadINI(RS, "Help", "rejoin"): R = commandRank("rejoin")
    Case "version", "ver", "v": o = ReadINI(RS, "Help", "version"): R = commandRank("version")
    
    Case "setidle": o = ReadINI(RS, "Help", "setidle")
    Case "setgreet": o = ReadINI(RS, "Help", "setgreet")
    Case "idle": o = Replace$(ReadINI(RS, "Help", "mode_string"), "%s", "idle") & " " & ReadINI(RS, "Help", "idle")
    Case "greet": o = Replace$(ReadINI(RS, "Help", "mode_string"), "%s", "greet") & " " & ReadINI(RS, "Help", "greet")
    Case "greetvars": o = ReadINI(RS, "Help", "greetvars")
    Case "idlevars": o = ReadINI(RS, "Help", "idlevars")
    
    Case "boot": o = ReadINI(RS, "Help", "kick")
    Case "chieftain": o = ReadINI(RS, "Help", "chieftain")
    Case "cp": o = ReadINI(RS, "Help", "cp")
    Case "demote": o = ReadINI(RS, "Help", "demote")
    Case "promote": o = ReadINI(RS, "Help", "promote")
    Case "invite": o = ReadINI(RS, "Help", "invite")
    Case "setmotd": o = ReadINI(RS, "Help", "setmotd")
    Case "shamans": o = ReadINI(RS, "Help", "shamans")
    
    Case "cmdadd": o = ReadINI(RS, "Help", "cmdadd")
    Case "cmds": o = ReadINI(RS, "Help", "cmds")
    Case "cmddelete", "cmddel": o = ReadINI(RS, "Help", "cmddelete"): R = commandRank("cmddelete")
    Case "cmd": o = ReadINI(RS, "Help", "cmd")
    
    Case "access", "a": o = ReadINI(RS, "Help", "access"): R = commandRank("access")
    Case "add": o = ReadINI(RS, "Help", "add")
    Case "database", "db": o = ReadINI(RS, "Help", "database"): R = commandRank("database")
    Case "delete", "del": o = ReadINI(RS, "Help", "delete"): R = commandRank("delete")
    Case "find": o = ReadINI(RS, "Help", "find")
    Case "list": o = ReadINI(RS, "Help", "list")
    
    Case "connectall": o = ReadINI(RS, "Help", "connectall")
    Case "control": o = ReadINI(RS, "Help", "control")
    Case "filter": o = ReadINI(RS, "Help", "filter")
    Case "filters": o = ReadINI(RS, "Help", "filters")
    Case "group": o = ReadINI(RS, "Help", "group")
    Case "groups": o = ReadINI(RS, "Help", "groups")
    Case "hide": o = ReadINI(RS, "Help", "hide")
    Case "load": o = ReadINI(RS, "Help", "load")
    Case "loadplugin": o = ReadINI(RS, "Help", "loadplugin")
    Case "plugcmds": o = ReadINI(RS, "Help", "plugcmds")
    Case "quit", "exit", "die", "fuckoff": o = ReadINI(RS, "Help", "quit"): R = commandRank("quit")
    Case "reconnect", "connect", "rc": o = ReadINI(RS, "Help", "reconnect")
    Case "setaccount": o = ReadINI(RS, "Help", "setaccount")
    Case "sethome": o = ReadINI(RS, "Help", "sethome")
    Case "setnewpassword": o = ReadINI(RS, "Help", "setnewpassword")
    Case "setpassword": o = ReadINI(RS, "Help", "setpassword")
    Case "setserver": o = ReadINI(RS, "Help", "setserver")
    Case "settrigger": o = ReadINI(RS, "Help", "settrigger")
    Case "show": o = ReadINI(RS, "Help", "show")
    Case "tag": o = ReadINI(RS, "Help", "tag")
    Case "tags": o = ReadINI(RS, "Help", "tags")
    Case "unfilter": o = ReadINI(RS, "Help", "unfilter")
    Case "ungroup": o = ReadINI(RS, "Help", "ungroup")
    Case "unload": o = ReadINI(RS, "Help", "unload")
    Case "unloadplugin": o = ReadINI(RS, "Help", "unloadplugin")
    Case "untag": o = ReadINI(RS, "Help", "untag")
    
    Case "ban", "b": o = ReadINI(RS, "Help", "ban"): R = commandRank("ban")
    Case "bancount", "bc": o = ReadINI(RS, "Help", "bancount"): R = commandRank("bancount")
    Case "checkchannel", "cc": o = ReadINI(RS, "Help", "checkchannel"): R = commandRank("checkchannel")
    Case "ddp": o = ReadINI(RS, "Help", "ddp")
    Case "dodgeban", "do": o = Replace$(ReadINI(RS, "Help", "mode_string"), "%s", "dodgeban") & " " & ReadINI(RS, "Help", "dodgeban"): R = commandRank("dodgeban")
    Case "clanban", "cb": o = Replace$(ReadINI(RS, "Help", "mode_string"), "%s", "clanban") & " " & ReadINI(RS, "Help", "clanban"): R = commandRank("clanban")
    Case "clanadd": o = ReadINI(RS, "Help", "clanadd"): R = commandRank("clanadd")
    Case "clandel", "clandelete": o = ReadINI(RS, "Help", "clandel"): R = commandRank("clandel")
    Case "clans": o = ReadINI(RS, "Help", "clans"): R = commandRank("clans")
    Case "outsiderban", "ob": o = Replace$(ReadINI(RS, "Help", "mode_string"), "%s", "outsiderban") & " " & ReadINI(RS, "Help", "outsiderban"): R = commandRank("outsiderban")
    Case "floodban", "fb": o = Replace$(ReadINI(RS, "Help", "mode_string"), "%s", "floodban") & " " & ReadINI(RS, "Help", "floodban"): R = commandRank("floodban")
    Case "hashban", "hb": o = Replace$(ReadINI(RS, "Help", "mode_string"), "%s", "hashban") & " " & ReadINI(RS, "Help", "hashban"): R = commandRank("hashban")
    Case "loadban", "lb": o = Replace$(ReadINI(RS, "Help", "mode_string"), "%s", "loadban") & " " & ReadINI(RS, "Help", "loadban"): R = commandRank("loadban")
    Case "lockdown", "ld": o = Replace$(ReadINI(RS, "Help", "mode_string"), "%s", "lockdown") & " " & ReadINI(RS, "Help", "lockdown"): R = commandRank("lockdown")
    Case "nextban", "nb": o = Replace$(ReadINI(RS, "Help", "mode_string"), "%s", "nextban") & " " & ReadINI(RS, "Help", "nextban"): R = commandRank("nextban")
    Case "randomban", "rb": o = Replace$(ReadINI(RS, "Help", "mode_string"), "%s", "randomban") & " " & ReadINI(RS, "Help", "randomban"): R = commandRank("randomban")
    Case "repeatban", "rp": o = Replace$(ReadINI(RS, "Help", "mode_string"), "%s", "repeatban") & " " & ReadINI(RS, "Help", "repeatban"): R = commandRank("repeatban")
    Case "safeunban", "su": o = Replace$(ReadINI(RS, "Help", "mode_string"), "%s", "safeunban") & " " & ReadINI(RS, "Help", "safeunban"): R = commandRank("safeunban")
    Case "smartban", "sb": o = Replace$(ReadINI(RS, "Help", "mode_string"), "%s", "smartban") & " " & ReadINI(RS, "Help", "smartban"): R = commandRank("smartban")
    Case "ipban", "ib": o = Replace$(ReadINI(RS, "Help", "mode_string"), "%s", "ipban") & " " & ReadINI(RS, "Help", "ipban"): R = commandRank("ipban")
    Case "timeban", "tb": o = ReadINI(RS, "Help", "timeban"): R = commandRank("timeban")
    Case "giveop", "op": o = ReadINI(RS, "Help", "op"): R = commandRank("op")
    Case "designate", "des": o = ReadINI(RS, "Help", "designate"): R = commandRank("designate")
    Case "ignore", "i": o = ReadINI(RS, "Help", "ignore"): R = commandRank("ignore")
    Case "kick", "k": o = ReadINI(RS, "Help", "kick"): R = commandRank("kick")
    Case "banip", "ip": o = ReadINI(RS, "Help", "banip"): R = commandRank("banip")
    Case "ipsweep": o = ReadINI(RS, "Help", "ipsweep")
    Case "status": o = ReadINI(RS, "Help", "status")
    Case "sweep": o = ReadINI(RS, "Help", "sweep")
    Case "ubl": o = ReadINI(RS, "Help", "ubl")
    Case "unban", "u": o = ReadINI(RS, "Help", "unban"): R = commandRank("unban")
    Case "unignore", "ui": o = ReadINI(RS, "Help", "unignore"): R = commandRank("unignore")
    Case "unbanip", "unip": o = ReadINI(RS, "Help", "unbanip"): R = commandRank("unbanip")
    
    Case "addqueue": o = ReadINI(RS, "Help", "addqueue"): R = commandRank("addqueue")
    Case "queue": o = ReadINI(RS, "Help", "queue"): R = commandRank("queue")
    Case "queues": o = ReadINI(RS, "Help", "queues"): R = commandRank("queues")
    Case "setqueue": o = ReadINI(RS, "Help", "setqueue"): R = commandRank("setqueue")
    
    Case "commands":
        Dim I As Integer
        For I = 1 To 5
            Display CS, ReadINI(RS, "Help", "cmd_string" & I)
        Next I
        Exit Sub
    Case Else
        Display CS, ReadINI(RS, "Help", "cmd_unident")
        Exit Sub
    End Select
    If LenB(o) <> 0 Then
        If InStrB(o, " || ") <> 0 Then
            A = Split(o, " || ")(1)
            o = Split(o, " || ")(0)
        End If
        If LenB(A) = 0 Then A = "none"
        Display CS, "Help (" & LCase$(CS.Message) & ") - Parameters: " & A & ", Rank: " & R & " - " & o
    End If
End Sub



Public Sub ListCommands(Index As Integer)
    Dim R As RichTextBox
    Dim vc As clsPlugCommand, C As Integer, LP As String
    Set R = frmCommandList.rtb
    R.Text = vbNullString
    OutputEventFocus R, -1, &HB1, , "Internal Command Triggers:", , , , , True
    OutputEventFocus R, -1, &HB3, , "/ - Current bot only", , , , , True
    OutputEventFocus R, -1, &HB3, , "// - All bots", , , , , True
    OutputEventFocus R, -1, &HB3, , "/~ - All operator bots", , , , , True
    OutputEventFocus R, -1, &HB3, , "/` - All non-operator bots", , , , , True
    OutputEventFocus R, -1, &HB3, , "/@ - All bots on the same server as current bot", , , , , True
    OutputEventFocus R, -1, &HB0, , "-------------------------------------------------------", , , , , True
    OutputEventFocus R, -1, &HB1, , "External Command Triggers:", , , , , True
    OutputEventFocus R, -1, &HB3, , frmBot.Bot(SelectedBot).Config.Trigger & " - Current bot only", , , , , True
    OutputEventFocus R, -1, &HB3, , "!! - All bots in current channel that you have access to", , , , , True
    OutputEventFocus R, -1, &HB3, , "!~ - All operator bots in current channel that you have access to", , , , , True
    OutputEventFocus R, -1, &HB3, , "!` - All non-operator bots in current channel that you have access to", , , , , True
    OutputEventFocus R, -1, &HB0, , "-------------------------------------------------------", , , , , True
    OutputEventFocus R, -1, &HB1, , "Console (Internal) Commands:", , , , , True
    OutputEventFocus R, -1, &HB3, , "bans -- List all banned users.", , , , , True
    OutputEventFocus R, -1, &HB3, , "clearbans -- Clear banned user list.", , , , , True
    OutputEventFocus R, -1, &HB3, , "commands -- List all built-in/registered commands.", , , , , True
    OutputEventFocus R, -1, &HB3, , "focus (user) -- Open a Chat Focus window for specified user.", , , , , True
    OutputEventFocus R, -1, &HB3, , "forward/fw (message) -- Send a message to the last user you whispered.", , , , , True
    OutputEventFocus R, -1, &HB3, , "games -- Return a list of current games for your client.", , , , , True
    OutputEventFocus R, -1, &HB3, , "plugins -- List all plugins and their status.", , , , , True
    OutputEventFocus R, -1, &HB3, , "reply/re (message) -- Reply to the last user who whispered you.", , , , , True
    OutputEventFocus R, -1, &HB3, , "tictactoe/ttt (user) -- Request a game of Tic-Tac-Toe with specified user.", , , , , True
    OutputEventFocus R, -1, &HB0, , "-------------------------------------------------------", , , , , True
    OutputEventFocus R, -1, &HB1, , "Chat Commands:", , , , , True
    OutputEventFocus R, -1, &HB3, , "build -- Return the version of MirageBot including build.", , , , , True
    OutputEventFocus R, -1, &HB3, , "clearqueue/cq -- Clear the queue.", , , , , True
    OutputEventFocus R, -1, &HB3, , "date -- Return the current date on this computer.", , , , , True
    OutputEventFocus R, -1, &HB3, , "decrypt/dec (text) -- Return the text decrypted.", , , , , True
    OutputEventFocus R, -1, &HB3, , "emote/me (text) -- Express something using /me.", , , , , True
    OutputEventFocus R, -1, &HB3, , "encrypt/enc (text) -- Return the text encrypted.", , , , , True
    OutputEventFocus R, -1, &HB3, , "first -- Join the clients initial channel.", , , , , True
    OutputEventFocus R, -1, &HB3, , "force (channel) -- Join a channel forcefully using 0x02 flag.", , , , , True
    OutputEventFocus R, -1, &HB3, , "home/h -- Join the bot's home channel.", , , , , True
    OutputEventFocus R, -1, &HB3, , "info (user) -- Return information about a specific user.", , , , , True
    OutputEventFocus R, -1, &HB3, , "join/j (channel) -- Join specified channel.", , , , , True
    OutputEventFocus R, -1, &HB3, , "last -- Join the previous channel.", , , , , True
    OutputEventFocus R, -1, &HB3, , "lastwhisper/lw -- Return the last person who whispered this bot.", , , , , True
    OutputEventFocus R, -1, &HB3, , "macro (name) -- Return the content of a specific macro.", , , , , True
    OutputEventFocus R, -1, &HB3, , "mass (channel) -- Make every bot on this server join specific channel.", , , , , True
    OutputEventFocus R, -1, &HB3, , "nudge (user, [message]) -- Nudge a specific user.", , , , , True
    OutputEventFocus R, -1, &HB3, , "nudgesweep (channel) -- 'Basic' nudge all users in specified channel.", , , , , True
    OutputEventFocus R, -1, &HB3, , "nudgeme ([message]) -- Nudge the user of this bot.", , , , , True
    OutputEventFocus R, -1, &HB3, , "ping/p ([user]) -- Return ping of this bot or a specified user.", , , , , True
    OutputEventFocus R, -1, &HB3, , "pingme/pme ([user]) -- Return speaker's ping.", , , , , True
    OutputEventFocus R, -1, &HB3, , "profile ([user]) -- Return profile of this bot or a specified user.", , , , , True
    OutputEventFocus R, -1, &HB3, , "rejoin/rj -- Rejoin the current channel.", , , , , True
    OutputEventFocus R, -1, &HB3, , "time -- Return the current time on this computer.", , , , , True
    OutputEventFocus R, -1, &HB3, , "version/ver/v -- Return the version of MirageBot.", , , , , True
    OutputEventFocus R, -1, &HB0, , "-------------------------------------------------------", , , , , True
    OutputEventFocus R, -1, &HB1, , "Clan Commands:", , , , , True
    OutputEventFocus R, -1, &HB3, , "boot (member) -- Boot a member out of the clan.", , , , , True
    OutputEventFocus R, -1, &HB3, , "chieftain -- Return the clan's chieftain.", , , , , True
    OutputEventFocus R, -1, &HB3, , "cp (0/1) -- Toggle clan private(1)/public(0).", , , , , True
    OutputEventFocus R, -1, &HB3, , "demote (member) -- Demote a clan member's rank.", , , , , True
    OutputEventFocus R, -1, &HB3, , "invite (user) -- Invite a user to join the clan.", , , , , True
    OutputEventFocus R, -1, &HB3, , "promote (member) -- Promote a clan member's rank.", , , , , True
    OutputEventFocus R, -1, &HB3, , "setmotd (text) -- Change clan message of the day.", , , , , True
    OutputEventFocus R, -1, &HB3, , "shamans -- Return a list of the current shamans.", , , , , True
    OutputEventFocus R, -1, &HB0, , "-------------------------------------------------------", , , , , True
    OutputEventFocus R, -1, &HB1, , "Custom Command Management:", , , , , True
    OutputEventFocus R, -1, &HB3, , "cmd (command) -- Find a custom command.", , , , , True
    OutputEventFocus R, -1, &HB3, , "cmdadd (command, level, response) -- Add a new custom command.", , , , , True
    OutputEventFocus R, -1, &HB3, , "cmddelete/cmddel (command) -- Delete an existing custom command.", , , , , True
    OutputEventFocus R, -1, &HB3, , "cmds -- List all custom commands.", , , , , True
    OutputEventFocus R, -1, &HB0, , "-------------------------------------------------------", , , , , True
    OutputEventFocus R, -1, &HB1, , "Custom Commands:", , , , , True
    For C = 0 To UBound(CustComm)
        With CustComm(C)
            OutputEventFocus R, -1, &HB3, , .ctCommand & " [level: " & .ctRank & "] -- " & Replace$(.ctResponse, vbNewLine, "; "), , , , , True
        End With
    Next C
    OutputEventFocus R, -1, &HB0, , "-------------------------------------------------------", , , , , True
    OutputEventFocus R, -1, &HB1, , "Database Commands:", , , , , True
    OutputEventFocus R, -1, &HB3, , "access/a -- Return your rank.", , , , , True
    OutputEventFocus R, -1, &HB3, , "add (user, rank) -- Add a user to the database with specified rank.", , , , , True
    OutputEventFocus R, -1, &HB3, , "database/db -- Output information about the database.", , , , , True
    OutputEventFocus R, -1, &HB3, , "delete/del (user) -- Remove a specific user from the database.", , , , , True
    OutputEventFocus R, -1, &HB3, , "find (user) -- Find a specific user in the database.", , , , , True
    OutputEventFocus R, -1, &HB3, , "list (rank) -- List all users in the database belonging to a specific rank.", , , , , True
    OutputEventFocus R, -1, &HB0, , "-------------------------------------------------------", , , , , True
    OutputEventFocus R, -1, &HB1, , "High-Level Commands:", , , , , True
    OutputEventFocus R, -1, &HB3, , "connectall -- Connect all loaded bots.", , , , , True
    OutputEventFocus R, -1, &HB3, , "control (profile, command) -- Control a profile via a command.", , , , , True
    OutputEventFocus R, -1, &HB3, , "filter (m/u, text) -- Specify something to filter.", , , , , True
    OutputEventFocus R, -1, &HB3, , "filters -- List all filters.", , , , , True
    OutputEventFocus R, -1, &HB3, , "group (user, group) -- Add a user to a specific group.", , , , , True
    OutputEventFocus R, -1, &HB3, , "groups -- List all groups.", , , , , True
    OutputEventFocus R, -1, &HB3, , "greet (mode) -- Greet enables you to greet users who join your channel with a specific message. Mode = on/off/?", , , , , True
    OutputEventFocus R, -1, &HB3, , "greetvars -- View variables for greet message.", , , , , True
    OutputEventFocus R, -1, &HB3, , "hide -- Hide the bot.", , , , , True
    OutputEventFocus R, -1, &HB3, , "idle (mode) -- Idle enables you to send a dynamic message every X seconds. Mode = on/off/?", , , , , True
    OutputEventFocus R, -1, &HB3, , "idlevars -- View variables for idle message.", , , , , True
    OutputEventFocus R, -1, &HB3, , "load (profile) -- Load a specific profile.", , , , , True
    OutputEventFocus R, -1, &HB3, , "loadplugin (plugin) -- Load a specific plugin.", , , , , True
    OutputEventFocus R, -1, &HB3, , "plugcmds (plugin) -- List all commands for specified plugin.", , , , , True
    OutputEventFocus R, -1, &HB3, , "quit/exit/die/fuckoff -- Quit the bot.", , , , , True
    OutputEventFocus R, -1, &HB3, , "reconnect/connect/rc -- Reconnect the bot.", , , , , True
    OutputEventFocus R, -1, &HB3, , "setaccount (account) -- Change the bot's account.", , , , , True
    OutputEventFocus R, -1, &HB3, , "setgreet (message) -- Change the greet message.", , , , , True
    OutputEventFocus R, -1, &HB3, , "sethome (channel) -- Change the bot's home channel.", , , , , True
    OutputEventFocus R, -1, &HB3, , "setidle (time, message) -- Change the idle time and message.", , , , , True
    OutputEventFocus R, -1, &HB3, , "setnewpassword (password) -- Change the bot's new password.", , , , , True
    OutputEventFocus R, -1, &HB3, , "setpassword (password) -- Change the bot's password.", , , , , True
    OutputEventFocus R, -1, &HB3, , "setserver (server) -- Change the bot's server.", , , , , True
    OutputEventFocus R, -1, &HB3, , "settrigger (trigger) -- Change the bot's trigger.", , , , , True
    OutputEventFocus R, -1, &HB3, , "show -- Return the bot from being hidden.", , , , , True
    OutputEventFocus R, -1, &HB3, , "tag (c/u, text) -- Specify something to tag.", , , , , True
    OutputEventFocus R, -1, &HB3, , "tags -- List all filters.", , , , , True
    OutputEventFocus R, -1, &HB3, , "unfilter (m/u, text) -- Remove a specific filter.", , , , , True
    OutputEventFocus R, -1, &HB3, , "ungroup (username) -- Remove a user from a specific group.", , , , , True
    OutputEventFocus R, -1, &HB3, , "unload ([profile]) Unload the current bot or specified profile.", , , , , True
    OutputEventFocus R, -1, &HB3, , "unloadplugin (plugin) Unload the specified plugin.", , , , , True
    OutputEventFocus R, -1, &HB3, , "untag (c/u, text) -- Remove a specific tag.", , , , , True
    OutputEventFocus R, -1, &HB0, , "-------------------------------------------------------", , , , , True
    OutputEventFocus R, -1, &HB1, , "Moderation Commands:", , , , , True
    OutputEventFocus R, -1, &HB3, , "ban/b (text) -- Ban users in channel matching text OR an exact user.", , , , , True
    OutputEventFocus R, -1, &HB3, , "bancount/bc -- Return amount of bans the bot has seen.", , , , , True
    OutputEventFocus R, -1, &HB3, , "banip/ip (user) -- Ignore a specific user, then ban them.", , , , , True
    OutputEventFocus R, -1, &HB3, , "checkchannel/cc -- Search list of users applying moderation settings on each.", , , , , True
    OutputEventFocus R, -1, &HB3, , "ddp (user) -- Designate user, demote all shamans, rejoin, promote shamans again, and viola!", , , , , True
    OutputEventFocus R, -1, &HB3, , "dodgeban/do (mode) -- Dodgeban allows you to ban users who have already been banned and have came back on a different cdkey. Mode = on/off/?", , , , , True
    OutputEventFocus R, -1, &HB3, , "floodban/fb (mode) -- Floodban enables you to ban bots that join, spam, and leave quickly. Mode = on/off/?", , , , , True
    OutputEventFocus R, -1, &HB3, , "giveop/op (user) -- Designate user and rejoin primary ops.", , , , , True
    OutputEventFocus R, -1, &HB3, , "hashban/hb (mode) -- Hashban will ban users with on a duplicate account (e.g. Chriso#3). Mode = on/off/?", , , , , True
    OutputEventFocus R, -1, &HB3, , "ignore/i (user) -- Ignore a specific user.", , , , , True
    OutputEventFocus R, -1, &HB3, , "ipban/ib (mode) -- Ipban will ban users who are ignored. Mode = on/off/?", , , , , True
    OutputEventFocus R, -1, &HB3, , "ipsweep (channel) -- Ban and ignore all users in specified channel.", , , , , True
    OutputEventFocus R, -1, &HB3, , "kick/k (user) -- Kick users in channel matching text OR exact user.", , , , , True
    OutputEventFocus R, -1, &HB3, , "loadban/lb (mode) -- Loadban enables you to ban bots that appear to be a part of a massload. Mode = on/off/?", , , , , True
    OutputEventFocus R, -1, &HB3, , "lockdown/ld (mode) -- Lockdown will ban all users who are not safelisted in the database. Mode = on/off/?", , , , , True
    OutputEventFocus R, -1, &HB3, , "nextban/nb (mode) -- Nextban will ban the next user who joins the channel. Mode = on/off/?", , , , , True
    OutputEventFocus R, -1, &HB3, , "randomban/rb (mode) -- Randomban will ban users who appear to be on a random account. Mode = on/off/?", , , , , True
    OutputEventFocus R, -1, &HB3, , "repeatban/rp (mode) -- Repeatban will ban users who repeat the same text. Mode = on/off/?", , , , , True
    OutputEventFocus R, -1, &HB3, , "safeunban/su (mode) -- Safeunban will unban users who are in safe in the database. Mode = on/off/?", , , , , True
    OutputEventFocus R, -1, &HB3, , "smartban/sb (mode) -- Smartban will remove already banned users from the ban-queue. Mode = on/off/?", , , , , True
    OutputEventFocus R, -1, &HB3, , "status -- Show the status of all moderation settings.", , , , , True
    OutputEventFocus R, -1, &HB3, , "sweep (channel) -- Ban all users in specified channel.", , , , , True
    OutputEventFocus R, -1, &HB3, , "timeban/tb (user, time) -- Apply a temporary ban on a specific user for a period of time (in minutes).", , , , , True
    OutputEventFocus R, -1, &HB3, , "ubl -- Unban last user banned.", , , , , True
    OutputEventFocus R, -1, &HB3, , "unban/u (text) -- Unban users in ban list matching text OR exact user.", , , , , True
    OutputEventFocus R, -1, &HB3, , "unbanip/unip (text) -- Unban and unignore users in ban list matching text OR exact user.", , , , , True
    OutputEventFocus R, -1, &HB3, , "unignore/uni (user) -- Unignore a specific user.", , , , , True
    OutputEventFocus R, -1, &HB0, , "-------------------------------------------------------", , , , , True
    OutputEventFocus R, -1, &HB1, , "Queue Commands:", , , , , True
    OutputEventFocus R, -1, &HB3, , "addqueue (ID, values) -- Create a new queue with the given values.", , , , , True
    OutputEventFocus R, -1, &HB3, , "queue -- Echo current queue ID and settings.", , , , , True
    OutputEventFocus R, -1, &HB3, , "queues -- List all queues.", , , , , True
    OutputEventFocus R, -1, &HB3, , "setqueue (ID) -- Change selected queue.", , , , , True
    
    For Each vc In Commands
        For C = 0 To UBound(Plugins)
            If LCase$(Plugins(C).Name) = LCase$(vc.Plugin) Then
                If frmBot.Bot(Index).PluginEnabled(Plugins(C).Name) Then
                    If Plugins(C).Name <> LP Then
                        OutputEventFocus R, -1, &HB0, , "-------------------------------------------------------", , , , , True
                        OutputEventFocus R, -1, &HB1, , Plugins(C).Name & " Plugin:", , , , , True
                    End If
                    OutputEventFocus R, -1, &HB3, , _
                        vc.Command & IIf(LenB(vc.Alias), "/" & vc.Alias, vbNullString) & IIf(LenB(vc.Args), " (" & vc.Args & ")", vbNullString) & " -- " & vc.Help, , , , , True
                    LP = Plugins(C).Name
                End If
            End If
        Next C
    Next vc
    R.SelStart = 0
    frmCommandList.Show
    frmCommandList.Caption = "Command List for " & frmBot.Bot(Index).Profile
End Sub
