Attribute VB_Name = "modCommandsCustom"
Public Type Exposure
    ctCommand As String
    ctRank As String
    ctResponse As String
End Type

Public CustComm() As Exposure

Public Function AddCommand(Cmd As String, Rank As String, Response As String) As Boolean
On Error GoTo hErr:
    Dim I As Integer
1   I = FindCommand(Cmd)
2   If I > -1 Then AddCommand = False: Exit Function
    Dim C As Exposure
3   C.ctCommand = Cmd
    If Rank <> "*" And rankingExists(Rank) = False Then Exit Function
    If Rank = "*" Then
        C.ctRank = "*"
    Else
5       C.ctRank = GetRankByID(GetIDByRank(Rank)).Alias
    End If
6   C.ctResponse = Response
7   If LenB(CustComm(0).ctCommand) Then ReDim Preserve CustComm(UBound(CustComm) + 1)
8   CustComm(UBound(CustComm)) = C
    AddCommand = True
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "CustomCommands", "AddCommand"
End Function

Public Function FindCommand(Cmd As String) As Integer
On Error GoTo hErr:
    Dim I As Integer
1   For I = 0 To UBound(CustComm)
2       If LCase$(CustComm(I).ctCommand) = LCase$(Cmd) Then
3           FindCommand = I
            Exit Function
        End If
    Next I
    FindCommand = -1
    Exit Function
hErr:
    FindCommand = -1
    ErrorHandler Err.Description, Erl, "CustomCommands", "FindCommand"
End Function

Public Function RemoveCommand(Cmd As String) As Boolean
    Dim I As Integer
1   I = FindCommand(Cmd)
    RemoveCommand = False
    If I = -1 Then Exit Function
2   If UBound(CustComm) > 0 Then
        Dim X As Integer
3       For X = I To UBound(CustComm) - 1
4           CustComm(X) = CustComm(X + 1)
5       Next X
6       ReDim Preserve CustComm(UBound(CustComm) - 1)
    Else
7       ReDim CustComm(0)
    End If
    RemoveCommand = True
    Exit Function
hErr:
    RemoveCommand = False
    ErrorHandler Err.Description, Erl, "CustomCommands", "RemoveCommand"
End Function

Public Sub SaveCommands()
On Error Resume Next
    Dim F As String, FF As Integer
    FF = FreeFile
    F = AppData & "Commands.ini"
    Open F For Append As #FF: Close #FF
    Open F For Output As #FF
    Dim I As Integer
    For I = 0 To UBound(CustComm)
        Print #FF, CustComm(I).ctCommand & "#" & CustComm(I).ctRank & "#"; CustComm(I).ctResponse
    Next I
    Close #FF
End Sub

Public Sub LoadCommands()
On Error GoTo hErr:
1   ReDim CustComm(0)
2   Dim FSO As New FileSystemObject, TS As TextStream
3   Set TS = FSO.OpenTextFile(AppData & "Commands.ini", ForReading, True)
4   Do Until TS.AtEndOfStream
        Dim LN As String
5       LN = TS.ReadLine()
6       If InStrB(LN, "#") Then
            Dim SP() As String
7           SP = Split(LN, "#", 3)
8           If UBound(SP) = 2 Then
                Dim CC As New clsCommandObj
                Set CC = cp_CreateCommand(SP(0), 3)
                With CC
                    .Rank = SP(1)
                    .Owner = "Custom"
                End With
9               AddCommand SP(0), SP(1), SP(2)
            End If
        End If
    Loop
10  TS.Close
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "CustomCommands", "LoadCommands"
End Sub
'
'Public Function HandleCustomCommand(CS As COMMANDSTRUCT) As Boolean
'On Error GoTo hErr:
'    If LenB(CS.Message) = 0 Then Exit Function
'    Dim C() As String, I As Integer, B As BNCS
'1   C() = Split(CS.Message, " ", 2)
'    If LenB(C(0)) = 0 Then Exit Function
'2   Set B = frmBot.Bot(CS.Index)
'3   For I = 0 To UBound(CustComm)
'4       If LCase$(CustComm(I).ctCommand) = LCase$(C(0)) Then
'5           HandleCustomCommand = True
'6           If Not B Is Nothing Then
'7               Dim U As clsUser, L As clsClanMember, v As Integer, CR As String, CanRun As Boolean
'8               Set L = B.clan.GetByName(CS.Username)
'                If Not L Is Nothing Then CR = ClanRankToString(CByte(Val(L.Rank)))
'9               Set U = B.Users.GetByName(CS.Username)
'                If CustComm(I).ctRank = "*" Then
'                    CanRun = True
'                Else
'                    If CS.Console Then
'                        CanRun = True
'                    Else
'29                      Dim UserRank As RankingStruct, CommRank As RankingStruct
'                        UserRank = GetAccess(CS)
'                        If LenB(R.RankName) = 0 Then Exit Function
'31                      CommRank = GetRankByID(GetIDByRank(CustComm(I).ctRank))
'                        If LenB(UserRank.RankName) <> 0 And LenB(CommRank.RankName) <> 0 Then
'                            'Check if Users' Rank Inherits or Equals the Rank Required for this Command
'32                          CanRun = (rankInherited(UserRank, CommRank) Or UserRank.RankName = CommRank.RankName)
'                        End If
'                    End If
'                End If
'                If CanRun Then
'                    Dim T As String
'13                  T = CustComm(I).ctResponse
'14                  T = Replace$(T, "%0", B.GetAccount(CS.Username))
'15                  T = Replace$(T, "%a", CR)
'16                  T = Replace$(T, "%d", Date)
'17                  T = Replace$(T, "%e", GetServerName(B.Config.Server))
'18                  T = Replace$(T, "%h", B.Self.Channel)
'19                  T = Replace$(T, "%r", RankN)
'20                  T = Replace$(T, "%t", Time)
'21                  T = Replace$(T, "%u", B.Self.Username)
'22                  T = Replace$(T, "%v", "MirageBot " & App.Major & "." & App.Minor)
'                    If UBound(C) = 1 Then
'                        If InStr(C(1), " ") > 0 Then
'                            Dim nv As Integer, rest As String
'                            parts = Split(C(1), " ")
'                            For v = 0 To UBound(parts)
'                               If InStrB(T, "%" & v + 1) Then nv = v + 1: T = Replace$(T, "%" & v + 1, parts(v))
'                            Next
'                            For v = nv To UBound(parts)
'                                rest = rest & parts(v) & " "
'                            Next
'                            If LenB(rest) Then
'                                rest = Left$(rest, Len(rest) - 1)
'                                T = Replace$(T, "%z", rest)
'                            End If
'                        ElseIf LenB(C(1)) Then
'                            T = Replace$(T, "%1", C(1))
'                            T = Replace$(T, "%z", C(1))
'                        End If
'                    End If
'23                  If Not U Is Nothing Then
'24                      T = Replace$(T, "%c", GetClanName(U.Statstring))
'25                      T = Replace$(T, "%f", LongToHex(U.Flags))
'26                      T = Replace$(T, "%p", U.Ping)
'27                      T = Replace$(T, "%g", GetClientName(StrReverse$(Left$(U.Statstring, 4))))
'28                      T = Replace$(T, "%s", GetClientStats(U.Statstring))
'                    Else
'                        T = Replace$(T, "%c", vbNullString)
'                        T = Replace$(T, "%f", vbNullString)
'                        T = Replace$(T, "%p", vbNullString)
'                        T = Replace$(T, "%g", vbNullString)
'                        T = Replace$(T, "%s", vbNullString)
'                    End If
'                    frmBot.Bot(CS.Index).SendText T, CS.Username
'                End If
'            End If
'            Exit For
'        End If
'    Next
'    Exit Function
'hErr:
'    ErrorHandler Err.Description, Erl, "CustomCommands", "HandleCustomCommand"
'End Function
