Attribute VB_Name = "modCommandMgmt"
'// Should this be different for each bot?
'// Instantiated CommandManagement Class for each Bot Object

Public CommandPool() As clsCommandObj

Public Sub cp_DeleteScriptCommands()
    Dim I As Integer
    For I = UBound(CommandPool) To 0 Step -1
        If CommandPool(I).Exposure = 1 Then
            Dim Cmd As String
            Cmd = CommandPool(I).Cmd
            cp_DeleteCommand Cmd
        End If
    Next I
End Sub

Public Sub cp_DeleteAllScriptCommands(Script As String)
    Dim I As Integer
    For I = UBound(CommandPool) To 0 Step -1
        If CommandPool(I).Exposure = 1 Then
            If LCase$(CommandPool(I).Owner) = LCase$(Script) Then
                Dim Cmd As String
                Cmd = CommandPool(I).Cmd
                cp_DeleteCommand Cmd
            End If
        End If
    Next I
End Sub

Public Sub cp_ImportInternal(Optional DeleteFirst As Boolean)
On Error GoTo hErr:
1   Call cp_Init
    Dim R() As String, I As Integer, Section As String
2   R = Split(ReadFile(AppData & "Commands\Import.dat"), vbNewLine)
3   For I = 0 To UBound(R)
4       If InStr(R(I), "|") Then
5           Dim S() As String
6           S = Split(R(I), "|")
            'Command|Alias|Parameters|Help|Use
7           If UBound(S) = 4 Then
8               Dim O As New clsCommandObj
                If DeleteFirst Then cp_DeleteCommand S(0)
9               Set O = cp_CreateCommand(S(0), 0)
                If Not O Is Nothing Then
10                  With O
11                      .Alias = S(1)
12                      .Help = S(3)
13                      .Callback = "cmd" & S(0)
14                      .Owner = Section
15                      .Use = Val(S(4))
16                      .Parameters = S(2)
                    End With
                End If
            End If
        Else
            If Len(R(I)) > 0 Then
                Section = R(I)
            End If
        End If
    Next
19  Erase R
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "CommandManagement", "cp_ImportInternal"
End Sub

Public Function cp_Init()
    ReDim CommandPool(0)
    Set CommandPool(0) = New clsCommandObj
End Function

Public Sub cp_PluginCommand(CO As clsCommandObj, CS As clsCommandSettings)
On Error GoTo hErr:
    Dim I As Integer
1   For I = 1 To UBound(Plugins)
2       If LCase$(Plugins(I).Name) = LCase$(CO.Owner) Then
3           CallByName Plugins(I).Client, CO.Callback, VbMethod, CS
        End If
    Next I
    Exit Sub
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "Plugins", "cp_PluginCommand"
End Sub

Public Function cp_Commands(Owner As String) As String()
    Dim I As Integer, C() As String
    ReDim C(0)
    For I = 0 To UBound(CommandPool)
        If LCase$(CommandPool(I).Owner) = LCase$(Owner) Then
            If LenB(C(0)) > 0 Then ReDim Preserve C(UBound(C) + 1)
            C(UBound(C)) = CommandPool(I).Cmd
        End If
    Next I
    cp_Commands = C
End Function

Public Function cp_GetAccess2(Username As String, Index As Integer) As RankingStruct
    Dim CS As New clsCommandSettings
        CS.Username = Username
        CS.Index = Index
    cp_GetAccess2 = cp_GetAccess(CS)
End Function

Public Function cp_GetAccess(CS As clsCommandSettings) As RankingStruct
On Error GoTo hErr:
1   If LenB(CS.Username) = 0 Then Exit Function
    Dim R As RankingStruct, findUser As Integer
3   With CS.Bot
        'Check Actual Access
4       findUser = .Database.Find(Suffix(CS.Username))
5       If findUser > -1 Then R = GetRankByID(.Database.GetUser(findUser).RankID)
        'Check Clan Access
6       If LenB(R.RankName) = 0 Then
7           If .clan.Count <> 0 Then
8               Dim CI As Integer, CR As Long
9               CI = .clan.Find(CS.Username)
10              If CI > -1 Then
                    Select Case .clan.GetByIndex(CI).Rank
                    Case CLANRANKENUM.CHIEFTAIN
11                      CR = GetIDByRank(.Config.ARChieftain)
                    Case CLANRANKENUM.GRUNT
12                      CR = GetIDByRank(.Config.ARGrunt)
                    Case CLANRANKENUM.PEON
13                      CR = GetIDByRank(.Config.ARPeon)
                    Case CLANRANKENUM.SHAMAN
14                      CR = GetIDByRank(.Config.ARShaman)
                    Case CLANRANKENUM.INITIATE
15                      CR = GetIDByRank(.Config.ARInitiate)
                    End Select
16                  If CR > -1 Then R = GetRankByID(CR)
                End If
            End If
        End If
        'Check Friend Access
17      If Len(R.RankName) = 0 Then
18          If .Friends.Count <> 0 Then
19              Dim FI As Integer, FR As Long, FO As clsFriend
20              For FI = 1 To .Friends.Count
21                  Set FO = .Friends(FI)
22                  If LCase$(FO.Username) = LCase$(Suffix(CS.Username)) Then
23                      FR = GetIDByRank(.Config.ARFriend)
24                      If FR > -1 Then
25                          R = GetRankByID(FR)
                        End If
                    End If
                Next
            End If
        End If
    End With
26  cp_GetAccess = R
    Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "CommandManagement", "cp_GetAccess"
End Function

Public Function cp_RunCommand(CS As clsCommandSettings)
On Error GoTo hErr:
    Dim I As Integer, RankName As String, R As RankingStruct
    CS.Username = Suffix(CS.Username)
    If LenB(CS.Username) = 0 Then
        CS.IsConsole = True
        CS.Display = 3
    Else
        R = cp_GetAccess(CS)
        RankName = R.RankName
    End If
    
    Dim ExactMatch As Boolean
1   For I = 0 To UBound(CommandPool)
        ExactMatch = False
        If LCase$(CS.Command) = LCase$(CommandPool(I).Cmd) Then ExactMatch = True
        If LenB(CommandPool(I).Alias) Then
            If LCase$(CS.Command) = LCase$(CommandPool(I).Alias) Then ExactMatch = True
        End If
        Dim CanUse As Boolean
        Select Case CommandPool(I).Use
        Case 0
            CanUse = (CommandDefined(CS.Command) = False Or _
                        CS.Display = 3 Or _
                        CS.IsConsole Or _
                        CommandCapable(CommandPool(I).Cmd, RankName))
        Case 1
            CanUse = CS.IsConsole = True
        Case 2
            CanUse = (CommandDefined(CS.Command) = False Or _
                        CommandCapable(CommandPool(I).Cmd, RankName)) And _
                        CS.IsConsole = False
        End Select
2       If ExactMatch And CanUse Then
            Select Case CommandPool(I).Exposure
            Case 0  'Internal
                ' Find Person Issuing Command
                Dim cmdHdl As New clsCommandHandler
                CallByName cmdHdl, CommandPool(I).Callback, VbMethod, CS
                Set cmdHdl = Nothing
            Case 1  'Script
4               If frmBot.Bot(CS.Index).ScriptEnabled(CommandPool(I).Owner) Then
5                   frmBot.Bot(CS.Index).scProcessObj CommandPool(I).Owner, CommandPool(I).Callback, CS
                End If
            Case 2  'Plugin
                'Check if plugin is enabled
6               If frmBot.Bot(CS.Index).PluginEnabled(CommandPool(I).Owner) Then
7                   cp_PluginCommand CommandPool(I), CS
                End If
            Case 3  'Custom Command
            
            End Select
            cp_RunCommand = True
            Exit Function
        End If
    Next I
    Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "CommandManagement", "cp_RunCommand '" & CS.Command & "'"
End Function

Public Function cp_CreateCommand(Name As String, Optional Exposure As Integer) As Object
On Error GoTo hErr:
1   Dim I As Integer
2   For I = 0 To UBound(CommandPool)
3       If CommandPool(I).Cmd = LCase$(Name) Then
4           Set cp_CreateCommand = Nothing: Exit Function
        End If
    Next
5   If LenB(CommandPool(0).Cmd) <> 0 Then
        ReDim Preserve CommandPool(UBound(CommandPool) + 1)
        Set CommandPool(UBound(CommandPool)) = New clsCommandObj
    End If
6   CommandPool(UBound(CommandPool)).Cmd = LCase$(Name)
7   CommandPool(UBound(CommandPool)).Exposure = Exposure
8   Set cp_CreateCommand = CommandPool(UBound(CommandPool))
    frmBot.cboCommand.AddItem "/" & LCase$(Name) & " "
    Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "CommandManagement", "cp_CreateCommand"
End Function

Public Function cp_DeleteCommand(Name As String) As Boolean
On Error GoTo hErr:
    cp_DeleteCommand = False
1   Dim I As Integer
2   For I = 0 To UBound(CommandPool)
3       If CommandPool(I).Cmd = LCase$(Name) Then
4           cp_DeleteCommand = True
5           CommandPool(I).Cmd = vbNullString
        End If
    Next
6   For I = UBound(CommandPool) To 0 Step -1
7       If Len(CommandPool(I).Cmd) = 0 Then
            Dim R As Integer
8           For R = I To UBound(CommandPool) - 1
9               Set CommandPool(R) = CommandPool(R + 1)
10          Next
11          ReDim Preserve CommandPool(UBound(CommandPool) - 1)
        End If
    Next
    For I = frmBot.cboCommand.ListCount - 1 To 0 Step -1
        If LCase$(frmBot.cboCommand.List(I)) = "/" & LCase$(Name) Then
            frmBot.cboCommand.RemoveItem I
        End If
    Next I
    Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "CommandManagement", "cp_DeleteCommand"
End Function

Public Function cp_OpenCommand(Name As String) As Object
On Error GoTo hErr:
1   Dim I As Integer
2   For I = 0 To UBound(CommandPool)
3       If CommandPool(I).Cmd = LCase$(Name) Then
4           Set cp_OpenCommand = CommandPool(I): Exit Function
        End If
    Next
5   Set cp_OpenCommand = Nothing
    Exit Function
hErr:
    ErrorHandler Err.Number, Err.Description, Erl, "CommandManagement", "cp_OpenCommand"
End Function

Public Sub cp_List()
    Dim C As ComboBox, R As RichTextBox
    Set C = frmCommandList.cbo
    C.Clear
    Dim I As Integer, H As Integer
    For H = 0 To UBound(Ranking)
        If CommandCount(Ranking(H).RankName) > 0 Then
            C.AddItem Ranking(H).RankName
            If LenB(frmCommandList.R(0).Tag) Then Load frmCommandList.R(frmCommandList.R.Count)
            Set R = frmCommandList.R(frmCommandList.R.UBound)
            R.Tag = Ranking(H).RankName
            R.Text = vbNullString
            ReDim StrOut(0)
            For I = 0 To UBound(CommandPool)
                With CommandPool(I)
                    If CommandCapable(.Cmd, Ranking(H).RankName) Then
                        If LenB(StrOut(0)) > 0 Then ReDim Preserve StrOut(UBound(StrOut) + 1)
                        StrOut(UBound(StrOut)) = .Owner & "<b>" & .Cmd & IIf(Len(.Alias), "/" & .Alias, "") & "</b>" & _
                                IIf(Len(.Parameters), " <i>(" & .Parameters & ")</i>", "") & _
                                " - " & .Help
                    End If
                End With
            Next I
            MedianThreeQuickSort1 StrOut
            For I = 0 To UBound(StrOut)
                If InStrB(StrOut(I), "") Then
                    If StrTitle <> Split(StrOut(I), "")(0) Then
                        StrTitle = Split(StrOut(I), "")(0)
                        frmCommandList.Output1 R, "<b>" & StrTitle & "</b>"
                    End If
                    frmCommandList.Output2 R, CStr(Split(StrOut(I), "", 2)(1))
                End If
            Next
            R.SelStart = 0
            R.SelLength = Len(R.Text)
            R.SelFontSize = 10
            R.SelFontName = "Tahoma"
            R.SelHangingIndent = 200
            R.SelStart = 0
            R.SelLength = 0
        End If
    Next
    
    
    C.AddItem "<Console>"
    If LenB(frmCommandList.R(0).Tag) Then Load frmCommandList.R(frmCommandList.R.Count)
    Set R = frmCommandList.R(frmCommandList.R.UBound)
    R.Tag = "Console"
    R.Text = vbNullString
    ReDim StrOut(0)
    For I = 0 To UBound(CommandPool)
        With CommandPool(I)
            If .Use = 1 Then
                If LenB(StrOut(0)) > 0 Then ReDim Preserve StrOut(UBound(StrOut) + 1)
                StrOut(UBound(StrOut)) = .Owner & "<b>" & .Cmd & IIf(Len(.Alias), "/" & .Alias, "</b>") & "" & _
                        IIf(Len(.Parameters), " <i>(" & .Parameters & ")</i>", "") & _
                        " - " & .Help
            End If
        End With
    Next I
    MedianThreeQuickSort1 StrOut
    For I = 0 To UBound(StrOut)
        If InStrB(StrOut(I), "") Then
            If StrTitle <> Split(StrOut(I), "")(0) Then
                StrTitle = Split(StrOut(I), "")(0)
                frmCommandList.Output1 R, "<b>" & StrTitle & "</b>"
            End If
            frmCommandList.Output2 R, CStr(Split(StrOut(I), "", 2)(1))
        End If
    Next
    R.SelStart = 0
    R.SelLength = Len(R.Text)
    R.SelFontSize = 10
    R.SelFontName = "Tahoma"
    R.SelHangingIndent = 200
    R.SelStart = 0
    R.SelLength = 0
    
    
    
    C.AddItem "<Unranked>"
    If LenB(frmCommandList.R(0).Tag) Then Load frmCommandList.R(frmCommandList.R.Count)
    Set R = frmCommandList.R(frmCommandList.R.UBound)
    R.Tag = "Unranked"
    R.Text = vbNullString
    ReDim StrOut(0)
    For I = 0 To UBound(CommandPool)
        With CommandPool(I)
            If CommandDefined(.Cmd) = False And CommandDefined(.Alias) = False And .Use <> 1 Then
                If LenB(StrOut(0)) > 0 Then ReDim Preserve StrOut(UBound(StrOut) + 1)
                StrOut(UBound(StrOut)) = .Owner & "<b>" & .Cmd & IIf(Len(.Alias), "/" & .Alias, "</b>") & "" & _
                        IIf(Len(.Parameters), " <i>(" & .Parameters & ")</i>", "") & _
                        " - " & .Help
            End If
        End With
    Next I
    MedianThreeQuickSort1 StrOut
    For I = 0 To UBound(StrOut)
        If InStrB(StrOut(I), "") Then
            If StrTitle <> Split(StrOut(I), "")(0) Then
                StrTitle = Split(StrOut(I), "")(0)
                frmCommandList.Output1 R, "<b>" & StrTitle & "</b>"
            End If
            frmCommandList.Output2 R, CStr(Split(StrOut(I), "", 2)(1))
        End If
    Next
    R.SelStart = 0
    R.SelLength = Len(R.Text)
    R.SelFontSize = 10
    R.SelFontName = "Tahoma"
    R.SelHangingIndent = 200
    R.SelStart = 0
    R.SelLength = 0
    
    Erase StrOut

    frmCommandList.Show
    C.ListIndex = 0
End Sub
