VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsPDebuffer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'-----------------------------------------------------
' MirageBot Packet Debuffer Class
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Private Debuffer As String, Offset As Integer
Public Function CanRead() As Boolean
    CanRead = (Offset < Len(Debuffer))
End Function
Public Function GetDebuffer() As String
    GetDebuffer = Debuffer
End Function
Public Function ReadBytes() As Byte()
    Dim B() As Byte, i As Integer
    ReDim B(Len(Debuffer) - 1)
    For i = 1 To Len(Debuffer)
        B(i - 1) = Asc(Mid$(Debuffer, i, 1))
    Next i
    ReadBytes = B
End Function
Public Sub SetDebuffer(Data As String)
    Debuffer = Data
    Offset = 1
End Sub
Public Sub Skip(Bytes As Integer)
    Offset = Offset + Bytes
End Sub
Public Sub Back(Bytes As Integer)
    Offset = Offset - Bytes
End Sub
Public Function ReadAll() As String
    ReadAll = Mid$(Debuffer, Offset)
End Function
Public Function ReadBYTE() As Byte
    If (Len(Debuffer) >= Offset) Then
        ReadBYTE = Asc(Mid$(Debuffer, Offset, 1))
        Skip 1
    End If
End Function
Public Function ReadWORD() As Integer
    If (Len(Debuffer) >= Offset + 1) Then
        ReadWORD = ExtractInt16(Mid$(Debuffer, Offset, 2))
        Skip 2
    End If
End Function
Public Function ReadDWORD() As Long
    If (Len(Debuffer) >= Offset + 3) Then
        ReadDWORD = ExtractInt32(Mid$(Debuffer, Offset, 4))
        Skip 4
    End If
End Function
Public Function ReadQword() As Currency
    If (Len(Debuffer) >= Offset + 7) Then
        ReadQword = ExtractInt64(Mid$(Debuffer, Offset, 8))
        Skip 8
    End If
End Function
Public Function ReadFT() As String
    If (Len(Debuffer) >= Offset + 7) Then
        Dim FT As FILETIME, LT As FILETIME, ST As SYSTEMTIME
        FT = ExtractFT(Mid$(Debuffer, Offset, 8))
        FileTimeToLocalFileTime FT, LT
        FileTimeToSystemTime LT, ST
        ReadFT = ProcessSystemTime(ST)
        Skip 8
    End If
End Function
Public Function ReadFixedString(Optional Length As Integer = 4) As String
    If (Len(Debuffer) >= Offset + Length - 1) Then
        ReadFixedString = Mid$(Debuffer, Offset, Length)
        Skip Length
    End If
End Function
Public Function ReadFixedString2(Optional Length As Integer = 4) As String
    If (Len(Debuffer) < Offset + Length) Then Length = Len(Debuffer) - Offset + 1
    ReadFixedString2 = Mid$(Debuffer, Offset, Length)
    Skip Length
End Function
Public Function ReadDwordString() As String
    If (Len(Debuffer) >= Offset + 3) Then
        Dim tmp As String
        tmp = StrReverse$(Mid$(Debuffer, Offset, 4))
        If InStrB(tmp, vbNullChar) <> 0 Then tmp = Split(tmp, vbNullChar)(0)
        ReadDwordString = tmp
        Skip 4
    End If
End Function
Public Function ReadCVal() As Double
    ReadCVal = Val(ReadCString)
End Function
Public Function ReadCString() As String
    If (InStrB(Mid$(Debuffer, Offset), vbNullChar) > 0) Then
        ReadCString = Split(Mid$(Debuffer, Offset), vbNullChar)(0)
        Skip Len(ReadCString) + 1
    End If
End Function
Public Function ReadTSTRING(Terminator As String) As String
    If (InStrB(Mid$(Debuffer, Offset), Terminator) > 0) Then
        ReadTSTRING = Split(Mid$(Debuffer, Offset), Terminator)(0)
        Skip Len(ReadTSTRING) + Len(Terminator)
    End If
End Function
