VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsModeration"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'-----------------------------------------------------
' MirageBot Moderation Class
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Private Const MD As String = "Moderation"
Private mLockDown As Boolean, mFloodBan As Boolean, mLoadBan As Boolean, mHashBan As Boolean, mNextBan As Boolean, _
        mDodgeBan As Boolean, mSmartBan As Boolean, mSafeUnban As Boolean, mClanBan As Boolean, mOutsiderBan As Boolean, _
        mRandomBan As Boolean, mRepeatBan As Boolean, mIPBan As Boolean, mClanStr As String, mStatBan As Boolean, _
        mFilterBan As Boolean, mSilencedBan As Boolean

Public StatBans As New Collection, ProfilePath As String, StatBanPath As String

Public Sub Load()
    CreateFile ProfilePath
    CreateFile StatBanPath
    mClanStr = (LCase$(ReadINI(ProfilePath, MD, "Clans")))
    mClanBan = (UCase$(ReadINI(ProfilePath, MD, "ClanBan")) = "Y")
    mOutsiderBan = (UCase$(ReadINI(ProfilePath, MD, "OutsiderBan")) = "Y")
    mLockDown = (UCase$(ReadINI(ProfilePath, MD, "LockDown")) = "Y")
    mFloodBan = (UCase$(ReadINI(ProfilePath, MD, "FloodBan")) = "Y")
    mLoadBan = (UCase$(ReadINI(ProfilePath, MD, "LoadBan")) = "Y")
    mHashBan = (UCase$(ReadINI(ProfilePath, MD, "HashBan")) = "Y")
    mDodgeBan = (UCase$(ReadINI(ProfilePath, MD, "DodgeBan")) = "Y")
    mSmartBan = (UCase$(ReadINI(ProfilePath, MD, "SmartBan")) = "Y")
    mStatBan = (UCase$(ReadINI(ProfilePath, MD, "StatBan")) = "Y")
    mRandomBan = (UCase$(ReadINI(ProfilePath, MD, "RandomBan")) = "Y")
    mSafeUnban = (UCase$(ReadINI(ProfilePath, MD, "SafeUnban")) = "Y")
    mRepeatBan = (UCase$(ReadINI(ProfilePath, MD, "RepeatBan")) = "Y")
    mFilterBan = (UCase$(ReadINI(ProfilePath, MD, "FilterBan")) = "Y")
    mSilencedBan = (UCase$(ReadINI(ProfilePath, MD, "SilencedBan")) = "Y")
    mIPBan = (UCase$(ReadINI(ProfilePath, MD, "IPBan")) = "Y")
    Dim Content() As String, I As Integer
    Content = Split(ReadFile(StatBanPath), vbNewLine)
    For I = 0 To UBound(Content)
        If InStr(Content(I), "/") Then
            Dim Line() As String, E As String
            Line = Split(Content(I), "/")
            If UBound(Line) = 2 Then
                'Fail Silently
                StatAdd Line(0), Line(1), Line(2), E
            End If
        End If
    Next I
End Sub

Public Sub Save()
    CreateFile ProfilePath
    CreateFile StatBanPath
    ClanBan = ClanBan
    OutsiderBan = OutsiderBan
    LockDown = LockDown
    FloodBan = FloodBan
    LoadBan = LoadBan
    HashBan = HashBan
    DodgeBan = DodgeBan
    SmartBan = SmartBan
    RandomBan = RandomBan
    SafeUnban = SafeUnban
    StatBan = StatBan
    RepeatBan = RepeatBan
    FilterBan = FilterBan
    SilencedBan = SilencedBan
    IPBan = IPBan
    Dim Content As String, I As Integer
    For I = 1 To StatBans.Count
        If LenB(StatBans(I)) Then Content = Content & StatBans(I) & vbNewLine
    Next I
    SaveFile StatBanPath, Content
End Sub

Public Function StatDelete(ByVal ID As String) As Boolean
    Dim SF As Integer
    SF = StatFind(ID)
    If SF = -1 Then
        Exit Function
    Else
        StatBans.Remove SF
        StatDelete = True
        Save
    End If
End Function

Public Function StatFind(ByVal ID As String) As Integer
    Dim I As Integer
    For I = 1 To StatBans.Count
        If LCase$(Prefix(StatBans(I), "/")) = LCase$(ID) Then
            StatFind = I
            Exit Function
        End If
    Next
    StatFind = -1
End Function

Public Function StatMatch(ByVal stat As String, ByRef ID As String) As Boolean
    If StatBans.Count = 0 Then Exit Function
    Dim prod As String, I As Integer
    prod = StrReverse$(Left$(stat, 4))
    Select Case prod
    Case "STAR", "SEXP", "W2BN", "WAR3", "W3XP", "D2DV", "D2XP"
        'valid
    Case Else
        'not supported
        Exit Function
    End Select
    Dim S() As String
    Select Case prod
    Case "D2DV", "D2XP"
        For I = 1 To StatBans.Count
            S = Split(StatBans(I), "/")
            If UBound(S) = 2 Then
                If UCase$(S(1)) = prod Then
                    If S(2) = "all" Then
                        StatMatch = True: ID = S(0): Exit Function
                    Else
                        Dim objD2 As objStats_D2
                        Set objD2 = DecodeStatstring(stat)
                        Select Case Left$(S(2), 6)
                            Case "level=": If objD2.CharLevel = Val(Mid$(S(2), 7)) Then StatMatch = True: ID = S(0): Exit Function
                            Case "level<": If objD2.CharLevel < Val(Mid$(S(2), 7)) Then StatMatch = True: ID = S(0): Exit Function
                            Case "level>": If objD2.CharLevel > Val(Mid$(S(2), 7)) Then StatMatch = True: ID = S(0): Exit Function
                            Case "level!": If objD2.CharLevel <> Val(Mid$(S(2), 8)) Then StatMatch = True: ID = S(0): Exit Function
                        End Select
                    End If
                End If
            End If
        Next I
    Case "STAR", "SEXP", "W2BN"
        For I = 1 To StatBans.Count
            S = Split(StatBans(I), "/")
            If UBound(S) = 2 Then
                If UCase$(S(1)) = prod Then
                    If S(2) = "all" Then
                        StatMatch = True: ID = S(0): Exit Function
                    Else
                        Dim objSC As objStats_SC
                        Set objSC = DecodeStatstring(stat)
                        Select Case Left$(S(2), 5)
                            Case "wins=": If objSC.StatWins = Val(Mid$(S(2), 6)) Then StatMatch = True: ID = S(0): Exit Function
                            Case "wins<": If objSC.StatWins < Val(Mid$(S(2), 6)) Then StatMatch = True: ID = S(0): Exit Function
                            Case "wins>": If objSC.StatWins > Val(Mid$(S(2), 6)) Then StatMatch = True: ID = S(0): Exit Function
                            Case "wins!": If objSC.StatWins <> Val(Mid$(S(2), 7)) Then StatMatch = True: ID = S(0): Exit Function
                        End Select
                    End If
                End If
            End If
        Next I
    Case "WAR3", "W3XP"
        For I = 1 To StatBans.Count
            S = Split(StatBans(I), "/")
            If UBound(S) = 2 Then
                If UCase$(S(1)) = prod Then
                    If S(2) = "all" Then
                        StatMatch = True: ID = S(0): Exit Function
                    Else
                        Dim objW3 As objStats_W3, Tier As String, t() As String, E As Integer
                        Set objW3 = DecodeStatstring(stat)
                        Tier = Mid$(objW3.StatIcon, 3)
                        If Len(Tier) = 0 Then Tier = "O1"
                        t = Split(Mid$(S(2), 6), "|")
                        For E = 0 To UBound(t)
                            If LCase$(t(E)) = LCase$(Tier) Then
                                StatMatch = True: ID = S(0): Exit Function
                            End If
                        Next
                    End If
                End If
            End If
        Next
    End Select
End Function

Public Function StatAdd(ByVal ID As String, ByVal Product As String, _
        ByVal options As String, ByRef error As String) As Boolean
    Select Case UCase$(Product)
    Case "STAR", "SEXP", "W2BN", "WAR3", "W3XP", "D2DV", "D2XP"
        Product = UCase$(Product)
    Case Else
        error = "Invalid product specified!"
        Exit Function
    End Select
    options = LCase$(options)
    If options = "all" Then
        'Valid
    Else
        Select Case Product
        Case "STAR", "SEXP", "W2BN"
            If InStrB(options, "wins") Then
                If Left$(options, 4) = "wins" Then
                    Select Case Mid$(options, 5, 1)
                    Case "<", ">", "="
                        'Valid
                        If CStr(Val(Mid$(options, 6))) <> Mid$(options, 6) Then
                            error = "Invalid options string, only a number may appear after 'wins" & Mid$(options, 5, 1) & "' string."
                            Exit Function
                        End If
                    Case "!"
                        If Mid$(options, 6, 1) = "=" Then
                            If CStr(Val(Mid$(options, 7))) <> Mid$(options, 7) Then
                                error = "Invalid options string, only a number may appear after 'wins!=' string."
                                Exit Function
                            End If
                        Else
                            error = "Invalid options string, only = can go after ! symbol for 'wins'."
                            Exit Function
                        End If
                    Case Else
                        error = "Invalid options string, only operators <, >, =, != are accepted after 'wins' string."
                        Exit Function
                    End Select
                Else
                    error = "Invalid options string, " & Product & " only supports 'all' or 'wins' (e.g. wins=0, wins>15)."
                    Exit Function
                End If
            Else
                error = "Invalid options string, " & Product & " only supports 'all' or 'wins'."
                Exit Function
            End If
        Case "D2DV", "D2XP"
            If InStrB(options, "level") Then
                If Left$(options, 5) = "level" Then
                    Select Case Mid$(options, 6, 1)
                    Case "<", ">", "="
                        'Valid
                        If CStr(Val(Mid$(options, 7))) <> Mid$(options, 7) Then
                            error = "Invalid options string, only a number may appear after 'level" & Mid$(options, 6, 1) & "' string."
                            Exit Function
                        End If
                    Case "!"
                        If Mid$(options, 7, 1) = "=" Then
                            'Valid
                            If CStr(Val(Mid$(options, 8))) <> Mid$(options, 8) Then
                                error = "Invalid options string, only a number may appear after 'level!=' string."
                                Exit Function
                            End If
                        Else
                            error = "Invalid options string, only = can go after ! symbol for 'level'."
                            Exit Function
                        End If
                    End Select
                Else
                    error = "Invalid options string, " & Product & " only supports 'all' or 'level'."
                    Exit Function
                End If
            Else
                error = "Invalid options string, " & Product & " only supports 'all' or 'level'."
                Exit Function
            End If
        Case "WAR3", "W3XP"
            If InStrB(options, "tier") Then
                If Left$(options, 5) = "tier=" Then
                    Dim str() As String, I As Integer
                    str = Split(LCase$(Mid$(options, 6)), "|")
                    For I = 0 To UBound(str)
                        If Len(str(I)) = 2 Then
                            Select Case Left$(str(I), 1)
                            Case "h", "o", "n", "r", "u"
                                'Valid
                            Case "t"
                                If Product = "WAR3" Then
                                    error = "Invalid tier option, 'tournament' tier is only valid for 'W3XP'."
                                    Exit Function
                                End If
                            End Select
                            Select Case Right$(str(I), 1)
                            Case "1", "2", "3", "4"
                                'Valid
                            Case "5"
                                If Product = "WAR3" Then
                                    error = "Invalid tier option, tier cannot be higher than 4 for 'WAR3'."
                                    Exit Function
                                End If
                            Case Else
                                If Product = "WAR3" Then
                                    error = "Invalid tier option, tier must be in range 1 to 4."
                                Else
                                    error = "Invalid tier option, tier must be in range 1 to 5."
                                End If
                                Exit Function
                            End Select
                        Else
                            error = "Invalid tier option, tiers must appear as '[race][level]' like so: h1|o1|r1|u1|n1."
                            Exit Function
                        End If
                    Next
                Else
                    error = "Invalid options string, " & Product & " only supports 'all' or 'tier='."
                    Exit Function
                End If
            Else
                error = "Invalid options string, " & Product & " only supports 'all' or 'tier'."
                Exit Function
            End If
        End Select
    End If
    On Error GoTo AddErr:
    StatBans.Add ID & "/" & Product & "/" & options, ID
    StatAdd = True
    Save
    Exit Function
AddErr:
    error = "Statban with same name already exists!"
End Function

Public Function ClanAdd(Clan As String) As Boolean
    Clan = LCase$(RestrictCharacters(Clan))
    If Len(Clan) < 2 Or Len(Clan) > 4 Then Exit Function
    If InStrB(mClanStr, Clan) Then
        Dim S() As String, I As Integer
        S = Split(mClanStr, ",")
        For I = 0 To UBound(S)
            If S(I) = Clan Then
                Exit Function
            End If
        Next
    End If
    If Right$(mClanStr, 1) = "," Then
        mClanStr = mClanStr & Clan
    Else
        If Len(mClanStr) > 0 Then
            mClanStr = mClanStr & "," & Clan
        Else
            mClanStr = Clan
        End If
    End If
    WriteINI ProfilePath, MD, "Clans", LCase$(mClanStr)
    ClanAdd = True
End Function

Public Function GetClans() As String
    GetClans = Replace$(mClanStr, ",", ", ")
End Function

Public Function ClanDel(Clan As String) As Boolean
    Clan = LCase$(RestrictCharacters(Clan))
    If InStrB(mClanStr, Clan) Then
        Dim S() As String, I As Integer, Buf As String, Found As Boolean
        S = Split(mClanStr, ",")
        For I = 0 To UBound(S)
            If S(I) = Clan Then
                S(I) = vbNS
                Found = True
            End If
        Next
        If Found Then
            For I = 0 To UBound(S)
                If LenB(S(I)) Then Buf = Buf & S(I) & ","
            Next I
            If Right$(Buf, 1) = "," Then Buf = Left$(Buf, Len(Buf) - 1)
            mClanStr = LCase$(Buf)
            WriteINI ProfilePath, MD, "Clans", mClanStr
            ClanDel = True
        End If
    End If
End Function

Public Property Get LockDown() As Boolean
    LockDown = mLockDown
End Property
Public Property Let LockDown(V As Boolean)
    mLockDown = V
    WriteINI ProfilePath, MD, "LockDown", YesNo(V)
End Property

Public Property Get IPBan() As Boolean
    IPBan = mIPBan
End Property
Public Property Let IPBan(V As Boolean)
    mIPBan = V
    WriteINI ProfilePath, MD, "IPBan", YesNo(V)
End Property

Public Property Get FloodBan() As Boolean
    FloodBan = mFloodBan
End Property
Public Property Let FloodBan(V As Boolean)
    mFloodBan = V
    WriteINI ProfilePath, MD, "FloodBan", YesNo(V)
End Property

Public Property Get StatBan() As Boolean
    StatBan = mStatBan
End Property
Public Property Let StatBan(V As Boolean)
    mStatBan = V
    WriteINI ProfilePath, MD, "StatBan", YesNo(V)
End Property

Public Property Get FilterBan() As Boolean
    FilterBan = mFilterBan
End Property
Public Property Let FilterBan(V As Boolean)
    mFilterBan = V
    WriteINI ProfilePath, MD, "FilterBan", YesNo(V)
End Property

Public Property Get SilencedBan() As Boolean
    SilencedBan = mSilencedBan
End Property
Public Property Let SilencedBan(V As Boolean)
    mSilencedBan = V
    WriteINI ProfilePath, MD, "SilencedBan", YesNo(V)
End Property

Public Property Get ClanBan() As Boolean
    ClanBan = mClanBan
End Property
Public Property Let ClanBan(V As Boolean)
    mClanBan = V
    WriteINI ProfilePath, MD, "ClanBan", YesNo(V)
End Property

Public Property Get OutsiderBan() As Boolean
    OutsiderBan = mOutsiderBan
End Property
Public Property Let OutsiderBan(V As Boolean)
    mOutsiderBan = V
    WriteINI ProfilePath, MD, "OutsiderBan", YesNo(V)
End Property

Public Property Get SafeUnban() As Boolean
    SafeUnban = mSafeUnban
End Property
Public Property Let SafeUnban(V As Boolean)
    mSafeUnban = V
    WriteINI ProfilePath, MD, "SafeUnban", YesNo(V)
End Property

Public Property Get RepeatBan() As Boolean
    RepeatBan = mRepeatBan
End Property
Public Property Let RepeatBan(V As Boolean)
    mRepeatBan = V
    WriteINI ProfilePath, MD, "RepeatBan", YesNo(V)
End Property

Public Property Get RandomBan() As Boolean
    RandomBan = mRandomBan
End Property
Public Property Let RandomBan(V As Boolean)
    mRandomBan = V
    WriteINI ProfilePath, MD, "RandomBan", YesNo(V)
End Property

Public Property Get LoadBan() As Boolean
    LoadBan = mLoadBan
End Property
Public Property Let LoadBan(V As Boolean)
    mLoadBan = V
    WriteINI ProfilePath, MD, "LoadBan", YesNo(V)
End Property

Public Property Get HashBan() As Boolean
    HashBan = mHashBan
End Property
Public Property Let HashBan(V As Boolean)
    mHashBan = V
    WriteINI ProfilePath, MD, "HashBan", YesNo(V)
End Property

Public Property Get NextBan() As Boolean
    NextBan = mNextBan
End Property
Public Property Let NextBan(V As Boolean)
    mNextBan = V
End Property

Public Property Get DodgeBan() As Boolean
    DodgeBan = mDodgeBan
End Property
Public Property Let DodgeBan(V As Boolean)
    mDodgeBan = V
    WriteINI ProfilePath, MD, "DodgeBan", YesNo(V)
End Property

Public Property Get SmartBan() As Boolean
    SmartBan = mSmartBan
End Property
Public Property Let SmartBan(V As Boolean)
    mSmartBan = V
    WriteINI ProfilePath, MD, "SmartBan", YesNo(V)
End Property
