Attribute VB_Name = "modTime"
Option Explicit
Private Declare Function QueryPerformanceCounter Lib "kernel32" (lpPerformanceCount As Currency) As Long
Private Declare Function QueryPerformanceFrequency Lib "kernel32" (lpFrequency As Currency) As Long
Public Declare Function GetTickCount Lib "kernel32" () As Long

Public Function NowTickCount() As Double
    Dim Cou As Currency
    Dim Fre As Currency
    On Error GoTo hErr
    If QueryPerformanceCounter(Cou) And QueryPerformanceFrequency(Fre) Then
        NowTickCount = Int(Cou / Fre * 1000)
    Else
        NowTickCount = LongToUnsigned(GetTickCount)
    End If
    Exit Function
hErr:
    NowTickCount = 0
End Function

Private Function LongToUnsigned(Value As Long) As Double
    If Value < 0 Then
        LongToUnsigned = Value + 4294967296#
    Else
        LongToUnsigned = Value
    End If
End Function

Public Function DateTimeToShortString(ByRef DT As DATETIME) As String
    Dim buf As String
    If (DT.Days) Then buf = DT.Days & "d, "
    If (DT.Hours Or DT.Days) Then buf = buf & DT.Hours & "h, "
    If (DT.Hours Or DT.Days Or DT.Minutes) Then buf = buf & DT.Minutes & "m, "
    buf = buf & DT.Seconds & "s"
    DateTimeToShortString = buf
End Function

Public Function DateTimeToLongString(ByRef DT As DATETIME) As String
    Dim buf As String
    If (DT.Days) Then buf = DT.Days & IIf(DT.Days = 1, " day, ", " days, ")
    If (DT.Hours Or DT.Days) Then buf = buf & DT.Hours & IIf(DT.Hours = 1, " hour, ", " hours, ")
    If (DT.Hours Or DT.Days Or DT.Minutes) Then buf = buf & DT.Minutes & IIf(DT.Minutes = 1, " minute, ", " minutes, ")
    buf = buf & DT.Seconds & IIf(DT.Seconds = 1, " second", " seconds")
    DateTimeToLongString = buf
End Function

Public Function ConvertTickCount(ByVal TickCount As Double) As DATETIME
    On Error GoTo hErr:
    Dim DT As DATETIME
    TickCount = TickCount / 1000
    DT.Days = Int(TickCount / 86400)
    TickCount = TickCount Mod 86400
    DT.Hours = Int(TickCount / 3600)
    TickCount = TickCount Mod 3600
    DT.Minutes = Int(TickCount / 60)
    TickCount = TickCount Mod 60
    DT.Seconds = TickCount
    ConvertTickCount = DT
    Exit Function
hErr:
    ConvertTickCount = DT
    ErrorHandler "Time", "ConvertTickCount"
End Function
