Attribute VB_Name = "modLocaleInfo"
Option Explicit

Public Declare Function GetUserDefaultLCID Lib "kernel32" () As Long
Public Declare Function GetUserDefaultLangID Lib "kernel32" () As Long
Public Declare Function GetSystemDefaultLCID Lib "kernel32" () As Long
Public Declare Function GetSystemDefaultLangID Lib "kernel32" () As Long
Private Declare Function GetLocaleInfoA Lib "kernel32" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long

Public Const LOCALE_USER_DEFAULT              As Long = &H400
Public Const LOCALE_SABBREVLANGNAME           As Long = &H3
Public Const LOCALE_SENGCOUNTRY               As Long = &H1002
Public Const LOCALE_SABBREVCTRYNAME           As Long = &H7
Public Const LOCALE_SNATIVECTRYNAME           As Long = &H8
Public Const LOCALE_SISO3166CTRYNAME          As Long = &H5A
Public Const LOCALE_SISO639LANGNAME           As Long = &H59

Public Function GetLocaleInfo(ByVal lInfo As Long) As String
    Dim Buffer As String, Ret As Long
    Buffer = String$(256, vbNullChar)
    Ret = GetLocaleInfoA(LOCALE_USER_DEFAULT, lInfo, Buffer, Len(Buffer))
    If (Ret > 0) Then GetLocaleInfo = Left$(Buffer, Ret - 1)
End Function

Public Function GetRegion() As Long
    Dim Region As String * 4
    Region = GetLocaleInfo(LOCALE_SISO639LANGNAME) & GetLocaleInfo(LOCALE_SISO3166CTRYNAME)
    GetRegion = ExtractInt32(Replace$(Region, Space$(1), vbNullChar))
End Function
