Attribute VB_Name = "modFilters"
Option Explicit

Public UserFilters() As String, MessageFilters() As String

Public Function IsUserFiltered(ByVal Username As String) As Boolean
    On Error GoTo hErr
    Dim I As Integer
    For I = 0 To UBound(UserFilters())
        If LenB(UserFilters(I)) > 0 Then
            If InStrB(UserFilters(I), "*") > 0 Or InStrB(UserFilters(I), "?") > 0 Then
                If Matches(Suffix(Username), UserFilters(I)) Then
                    IsUserFiltered = True
                    Exit Function
                End If
            Else
                If LCase$(UserFilters(I)) = LCase$(Suffix(Username)) Then
                    IsUserFiltered = True
                    Exit Function
                End If
            End If
        End If
    Next I
    Exit Function
hErr:
    ErrorHandler "Filters", "IsUserFiltered"
End Function

Public Function IsMessageFiltered(ByVal Message As String) As Boolean
    On Error GoTo hErr
    Dim I As Integer
    For I = 0 To UBound(MessageFilters())
        If LenB(MessageFilters(I)) > 0 Then
            If InStrB(MessageFilters(I), "*") > 0 Or InStrB(MessageFilters(I), "?") > 0 Then
                If Matches(Message, MessageFilters(I)) Then
                    IsMessageFiltered = True
                    Exit Function
                End If
            Else
                If LCase$(MessageFilters(I)) = LCase$(Suffix(Message)) Then
                    IsMessageFiltered = True
                    Exit Function
                End If
            End If
        End If
    Next I
    Exit Function
hErr:
    ErrorHandler "Filters", "IsMessageFiltered"
End Function

Public Sub ReloadUserFilters()
    On Error GoTo hErr
    ReDim UserFilters(0)
    Dim strLine As String
    Open AppData & "UserFilters.dat" For Append As #1: Close #1
    Open AppData & "UserFilters.dat" For Input As #1
        Do Until EOF(1)
        Line Input #1, strLine
            If LenB(strLine) > 0 Then
                If LenB(UserFilters(0)) = 0 Then
                    UserFilters(0) = strLine
                Else
                    ReDim Preserve UserFilters(UBound(UserFilters) + 1)
                    UserFilters(UBound(UserFilters)) = strLine
                End If
            End If
        Loop
    Close #1
    Exit Sub
hErr:
    Close #1
    ErrorHandler "Filters", "ReloadUserFilters"
End Sub

Public Sub ReloadMessageFilters()
    On Error GoTo hErr
    ReDim MessageFilters(0)
    Dim strLine As String
    Open AppData & "MessageFilters.dat" For Append As #1: Close #1
    Open AppData & "MessageFilters.dat" For Input As #1
        Do Until EOF(1)
        Line Input #1, strLine
            If LenB(strLine) > 0 Then
                If LenB(MessageFilters(0)) = 0 Then
                    MessageFilters(0) = strLine
                Else
                    ReDim Preserve MessageFilters(UBound(MessageFilters) + 1)
                    MessageFilters(UBound(MessageFilters)) = strLine
                End If
            End If
        Loop
    Close #1
    Exit Sub
hErr:
    Close #1
    ErrorHandler "Filters", "ReloadMessageFilters"
End Sub
