Attribute VB_Name = "modBNET"
'Channel Flags
'x00: Private
'x01: Public
'x02: Moderated
'x04: Restricted
'x08: Silent
'x10: System
'x20: Product -Specific
'x1000: Globally Accessible
Const CF_PUBLIC = &H1
Const CF_MODERATED = &H2
Const CF_RESTRICTED = &H4
Const CF_SILENT = &H8
Const CF_SYSTEM = &H10
Const CF_PRODSPECIFIC = &H20
Const CF_GLOBAL = &H1000
Public Function MakeServer(Data As String) As String
    MakeServer = CLng("&H" & ToHex(Mid(Data, 1, 1))) & "." & CLng("&H" & ToHex(Mid(Data, 2, 1))) & "." & CLng("&H" & ToHex(Mid(Data, 3, 1))) & "." & CLng("&H" & ToHex(Mid(Data, 4, 1)))
End Function
Public Sub Send0x51()
    With PBuffer
        .InsertDWORD GTC
        .InsertDWORD Version
        .InsertDWORD Checksum
        If BNET.Product = "PX2D" Then
            .InsertDWORD &H2
        Else
            .InsertDWORD &H1
        End If
        .InsertDWORD &H0
        .InsertNonNTString CdkeyHash
        If BNET.Product = "PX2D" Then
            .InsertNonNTString Cdkey2Hash
        End If
        .InsertNTString ExeInfo
        .InsertNTString BNET.CdkeyOwner
        .SendPacket &H51
    End With
End Sub
Public Sub Send0x50()
    With PBuffer
        .InsertDWORD &H0
        .InsertNonNTString "68XI" & BNET.Product
        '.InsertDWORD "&H09"
        .InsertDWORD VerByte
        .InsertDWORD &H0
        .InsertDWORD &H0
        .InsertDWORD &H480
        .InsertDWORD &H1033
        .InsertDWORD &H1033
        .InsertNTString "USA"
        .InsertNTString "United States"
        .SendPacket &H50
    End With
    AddChat vbD2Grey, "Sending location information."
End Sub
Public Sub RequestBnetNews()
    With PBuffer
        .InsertDWORD &H0
        .SendPacket &H46
    End With
End Sub
Public Function GetChannelType(ByVal Flags As Long) As String
    If Flags = 0 Then
        GetChannelType = "Private" & GetChannelType
    End If
    If (CF_PUBLIC And Flags) = CF_PUBLIC Then
        GetChannelType = "Public" & GetChannelType
    End If
    If (CF_MODERATED And Flags) = CF_MODERATED Then
        GetChannelType = "Moderated " & GetChannelType
    End If
    If (CF_RESTRICTED And Flags) = CF_RESTRICTED Then
        GetChannelType = "Restricted " & GetChannelType
    End If
    If (CF_SILENT And Flags) = CF_SILENT Then
        GetChannelType = "Silent " & GetChannelType
    End If
    If (CF_SYSTEM And Flags) = CF_SYSTEM Then
        GetChannelType = "System " & GetChannelType
    End If
    If (CF_PRODSPECIFIC And Flags) = CF_PRODSPECIFIC Then
        GetChannelType = "Product-Specific " & GetChannelType
    End If
    If (CF_GLOBAL And Flags) = CF_GLOBAL Then
        GetChannelType = "Globally Accessible " & GetChannelType
    End If
End Function
Public Function GetIconTier(ByVal IconNum As Long, ByVal Race As String) As String
    Select Case Race
        Case "H"
            Select Case IconNum
                Case 1: GetIconTier = "Peon"
                Case 2: GetIconTier = "Footman"
                Case 3: GetIconTier = "Knight"
                Case 4: GetIconTier = "Archmage"
                Case 5: GetIconTier = "Medivh"
                Case Else: GetIconTier = "Unknown Human"
            End Select
        Case "O"
            Select Case IconNum
                Case 1: GetIconTier = "Peon"
                Case 2: GetIconTier = "Grunt"
                Case 3: GetIconTier = "Tauren"
                Case 4: GetIconTier = "Far Seer"
                Case 5: GetIconTier = "Thrall"
                Case Else: GetIconTier = "Unknown Orc"
            End Select
        Case "N"
            Select Case IconNum
                Case 1: GetIconTier = "Peon"
                Case 2: GetIconTier = "Archer"
                Case 3: GetIconTier = "Druid of the Claw"
                Case 4: GetIconTier = "Priestess of the Moon"
                Case 5: GetIconTier = "Furion Stomrage"
                Case Else: GetIconTier = "Unknown Night Elf"
            End Select
        Case "U"
            Select Case IconNum
                Case 1: GetIconTier = "Peon"
                Case 2: GetIconTier = "Ghoul"
                Case 3: GetIconTier = "Abomination"
                Case 4: GetIconTier = "Lich"
                Case 5: GetIconTier = "Tichondrius"
                Case Else: GetIconTier = "Unknown Undead"
            End Select
        Case "R"
            Select Case IconNum
                Case 1: GetIconTier = "Peon"
                Case 2: GetIconTier = "Green Dragon Whelp"
                Case 3: GetIconTier = "Blue Dragon"
                Case 4: GetIconTier = "Red Dragon"
                Case 5: GetIconTier = "Deathwing"
                Case Else: GetIconTier = "Unknown Random"
            End Select
        Case Else
    End Select
    RaceIcon = GetIconTier
End Function
Public Sub ParseBnet(Data As String)
Dim PacketID As Byte, RP As Long, outb As String, pCmd As String
Dim AccountHash As String
    PacketID = Asc(Mid(Data, 2, 1))
    Select Case PacketID
        Case &H0
            With PBuffer
                .SendPacket &H0
            End With
        Case &H34
                ConnectMCP frmRealm.lstRealms.text
        Case &H3E
            Dim server As String, Bleh2 As String
                P1 = Mid(Data, 5, 16)
                server = Mid(Data, 17, 8)
                Bleh2 = Mid(server, 5, 4)
                P2 = Mid(Data, 29, 48)
                RealmName = Mid(Data, 77, Len(Data) - 79)
                frmMain.wsRealm.Close
                frmMain.wsRealm.Connect MakeServer(Bleh2), 6112
        Case &H51
        Cpass = False
            pCmd = GetWORD(Mid(Data, 5, 2))
            Select Case pCmd
                Case &H0 '0x000: Passed challenge
                    With PBuffer
                        If BNET.Product = "3RAW" Then
                            .InsertNTString BNET.username
                            .InsertNTString BNET.Password
                            .SendBNLSPacket &H2
                        Else
                            '"tenb" for Ping "bnet" for UDP ; Can't use bnet with D2DV/D2XP
                            .InsertNonNTString "tenb"
                            .SendPacket &H14
                            .SendPacket &H2D
                            If Cpass = False Then
                                HType = 1
                                .InsertDWORD Len(BNET.Password)
                                .InsertDWORD &H0
                                .InsertNonNTString BNET.Password
                                .SendBNLSPacket &HB
                                SPass = True
                            Else
                                Cpass = False
                                HType = 3
                                .InsertDWORD Len(BNETPassword)
                                .InsertDWORD &H0
                                .InsertNonNTString BNET.Password
                                .SendBNLSPacket &HB
                            End If
                        End If
                    AddChat vbD2Tan, "Passed version and CD-Key check."
                    AddChat vbD2Grey, "Sending username and password."
                    End With
                Case &H100 '0x100: Old game version (Additional info field supplies patch MPQ filename)
                    AddChat vbRed, "Game out of date! (" & Mid(strData, 9) & ")"
                    frmMain.wsBnet.Close
                Case &H101 '0x101: Invalid version
                    AddChat vbRed, "Invalid game version!"
                    frmMain.wsBnet.Close
                Case &H200, &H210 '0x200: Invalid CD key
                    AddChat vbRed, "CD key is invalid!"
                    frmMain.wsBnet.Close
                Case &H201, &H211 '0x201: CD key in use (Additional info field supplies name of user)
                    AddChat vbRed, "CD key is in use by " & Mid(Data, 9, Len(Data) - 9)
                    frmMain.wsBnet.Close
                Case &H202, &H212 '0x202: Banned key
                    AddChat vbRed, "Your CD key is banned!"
                    frmMain.wsBnet.Close
                Case &H203, &H213 '0x203: Wrong Product
                    AddChat vbRed, "Your CD key is for the wrong product!"
                    frmMain.wsBnet.Close
            End Select
        Case &H25 'Ping
            If BNET.varLagPlug = 1 Then
            Else
                PBuffer.InsertNonNTString Mid(Data, 5, 4)
                PBuffer.SendPacket &H25
            End If
            Exit Sub
        Case &H53
            If Asc(Mid$(Data, 5, 1)) = &H1 Then
                If AttemptedC = False Then
                With PBuffer
                    .InsertNTString BNET.username
                    .InsertNTString BNET.Password
                    .SendBNLSPacket &H4
                End With
                AttemptedC = True
                End If
            Else
                With PBuffer
                    .InsertNonNTString Mid(Data, 9, 64)
                    .SendBNLSPacket &H3
                End With
            End If
        Case &H52
            Select Case GetWORD(Mid(Data, 5, 2))
                Case &H0
                    With PBuffer
                        .InsertNTString BNET.username
                        .InsertNTString BNET.Password
                        .SendBNLSPacket &H2
                    End With
                Case Else
            End Select
        Case &H54
            Select Case GetWORD(Mid(Data, 5, 2))
            Case &H0
                AddChat vbGreen, "Verifying login proof..."
                With PBuffer
                    .InsertNTString BNET.username
                    .InsertBYTE 0
                    .SendPacket &HA
                    .InsertNonNTString BNET.Product
                    .SendPacket &HB
                    .InsertDWORD 1
                    .InsertNTString "L"
                    .SendPacket &HC
                End With
            Case &H2
                AddChat vbRed, "Logon failed."
                If AttemptedC = False Then
                With PBuffer
                    .InsertNTString BNET.username
                    .InsertNTString BNET.Password
                    .SendBNLSPacket &H4
                End With
                AttemptedC = True
                End If
            End Select
        Case &H50
            Dim mpqn As Long, Hash As String, MPQName As String
                Servers = Val("&h" & StrToHex(StrReverse(Mid(Data, 9, 4))))
                MPQName = Mid(Data, 25, 12)
                Hash = Mid(Data, 38, Len(Data) - 2)
                mpqn = Val(Mid(MPQName, 8, 1))
                
                      With PBuffer
                         .InsertDWORD GetBNLSByte()
                         .InsertDWORD CLng(mpqn)
                         .InsertNTString Hash
                         .SendBNLSPacket &H9
                      End With
        Case &H46 ' get news reply
            Dim tmpnews As Long
            Dim spltns() As String
                spltns() = Split(StrToHex(Mid(Data, 22)), "0A")
                For tmpnews = 0 To UBound(spltns) - 1
                    AddChat vbYellow, "News: " & HexToStr(spltns(tmpnews))
                Next tmpnews
                Exit Sub
            Erase spltns()
        Case &H31 ' password change reply
            If InStr(Data, Chr(&H1)) Then
                AddChat vbGreen, "Password changed, logging on."
            Else
                AddChat vbRed, "Password not changed."
            End If
        Case &H3A ' account login reply
            Select Case Asc(Mid(Data, 5, 1))
                Case &H1
                    AddChat vbRed, "Logon failed."
                    If AttemptedC = False Then
                        With PBuffer
                            HType = 2
                            .InsertDWORD Len(BNET.Password)
                            .InsertDWORD &H0
                            .InsertNonNTString BNET.Password
                            .SendBNLSPacket &HB
                        End With
                        AttemptedC = True
                    End If
                Case &H2
                    AddChat vbRed, "The password you have provided is incorrect. Please try again."
                Case &H0
                    AddChat vbD2Tan, "Password is valid, logging in.."
                    With PBuffer
                        If (BNET.varCRealm = 1) And ((BNET.Product = "VD2D") Or (BNET.Product = "PX2D")) Then
                            .InsertDWORD &H0
                            .InsertDWORD &H0
                            .InsertBYTE &H0
                            .SendPacket &H34
                        Else
                            .InsertNTString BNET.username
                            .InsertBYTE 0
                            .SendPacket &HA
                            .InsertNonNTString BNET.Product
                            .SendPacket &HB
                            .InsertDWORD 2
                            .InsertNTString BNET.HomeChannel
                            .SendPacket &HC
                        End If
                    End With
                Case Else
            End Select
            Exit Sub
        Case &HF
            frmMain.ChatBot.DispatchMessage Data
            Exit Sub
        Case &H2A
        Case &HA
            Dim spltn() As String, strss As String
            Ping = Split(Data, 13, 4)
                spltn() = Split(Data, Chr(0), 5)
                modStatstring.ParseStatString spltn(2), strss
                frmMain.Caption = App.Title & " - Copyright  1/1/03 - 3/17/03 FyRe - version " & App.Major & "." & App.Minor & "." & App.Revision & " - " & "Logged on as: " & BNET.username
                'Display Output Ping After Connection Initiated.
                AddChat vbGreen, "Logged on as: " & spltn(1)
                frmMain.wsBnls.Close
                BNET.TrueUsername = spltn(1)
            Erase spltn()
                'WAR3 Join Channel after Product Join.
                If BNET.Product = "3RAW" Then
                    With PBuffer
                        .InsertNTString "/join " & BNET.HomeChannel
                        .SendPacket &HE
                    End With
                End If
                LastTalk = GetTickCount()
            Exit Sub
        Case &HB
            Dim Split0B() As String
            Dim z As Integer
                Split0B() = Split(Mid(Data, 5, Len(Data)), Chr(0))
                For z = 0 To UBound(Split0B) - 2
                    frmMain.lstChanSave.ListItems.Add , , Split0B(z)
                Next z
            Erase Split0B()
            Exit Sub
        Case &H19
            AddChat vbWhite, "Packet (0x19): ", vbGreen, Replace(Mid(Data, 9, Len(Data)), Chr(0), "")
            Exit Sub
        Case &H15
            Dim asplt() As String
            asplt() = Split(Mid(Data, 21), Chr(0), 3)
            If BNET.varAdBanner Then AddChat vbGrey, "Adbanner is now " & asplt(0) & " - " & asplt(1)
            Erase asplt()
        Case &H26
            Dim splti() As String
                splti() = Split(Mid(Data, 1, Len(Data) - 1), Chr(1), 2)
                'AddChat vbGrey, "Using " & splti(1) & " as icons file."
            Erase splti()
            If varRequestType = "Profile" Then
                Dim ProfileEnd As String
                Dim SplitProfile As Variant
                ProfileEnd = Mid(Data, 13, Len(Data))
                SplitProfile = Split(ProfileEnd, Chr(&H0))
            
                With frmProfile
                    .Show
                    .txtUsername.text = ""
                    .txtSex.text = ""
                    .txtAge.text = ""
                    .txtLocation.text = ""
                    .txtDescription.text = ""
                    .txtUsername.text = msPerson
                    .txtSex.text = SplitProfile(1)
                    .txtAge.text = SplitProfile(2)
                    .txtLocation.text = SplitProfile(3)
                    .txtDescription.text = SplitProfile(4)
                End With
                
            ElseIf varRequestType = "RecordData" Then
                Dim Temp As String
                Dim RecordData As Variant
                Temp = Mid(Data, 13, Len(Data))
                RecordData = Split(Temp, Chr(&H0))
                
                AddChat vbGrey, "Account Created: ", vbWhite, Mid(RecordData(0), 5)
                AddChat vbGrey, "Username: ", vbWhite, RecordData(1)
                AddChat vbGrey, "Last Logon: ", vbWhite, RecordData(2)
                AddChat vbGrey, "Account Expires: ", vbWhite, RecordData(3)
                AddChat vbGrey, "Last Logoff: ", vbWhite, RecordData(4)
                AddChat vbGrey, "Time Logged: ", vbWhite, RecordData(5)
            Else
            End If
        Case &H3D
            Select Case Asc(Mid(Data, 5, 1))
                Case &H0
                    AddChat vbGreen, "Account created!"
                    With frmMain
                        .wsBnet.Close
                        .wsBnls.Close
                        .wsBnet.Connect BNET.BattlenetServer, 6112
                    End With
                Case &H1
                    AddChat vbRed, "Error: Too short, must be atleast 3 characters long!"
                    frmMain.wsBnet.Close
                    frmMain.wsBnls.Close
                Case &H2
                    AddChat vbRed, "Error: Invalid characters in the name!"
                    frmMain.wsBnet.Close
                    frmMain.wsBnls.Close
                Case &H3
                    AddChat vbRed, "Error: Invalid words!"
                    frmMain.wsBnet.Close
                    frmMain.wsBnls.Close
                Case &H4
                    AddChat vbRed, "Error: That account already exists!"
                    frmMain.wsBnet.Close
                    frmMain.wsBnls.Close
                Case Else
                    AddChat vbRed, "Error: Unknown Failure!"
                    frmMain.wsBnet.Close
                    frmMain.wsBnls.Close
            End Select
        Case &H2D
        Case &H4A
        Case &H63
            Dim i As Integer
            Dim usrName As String
            Dim pos As Integer
            IP = StrReverse(DWORDtoIP(GetDWORD(Mid(Data, 13, 4))))
            IP = DWORDtoIP(GetDWORD(Mid(Data, 13, 4)))
            Port = GetWORD(Mid(Data, 17, 2))
            Count = Asc(Mid(Data, 19, 1))
            pos = 16
            For i = 1 To Count
                usrName = Mid(Mid(Data, 4), pos, InStr(pos, Mid(Data, 4), Chr(0)) - pos)
                Call frmW3Invited.List1.AddItem(usrName)
                pos = InStr(pos, Mid(Data, 4), Chr(0)) + 1
            Next i
            frmW3Invited.IP = IP
            frmW3Invited.Port = Port
            frmW3Invited.Show
            AddChat vbD2Tan, "You are being invited to an arranged team game on " & IP & ":" & Port
        Case &H1C
            AddChat vbD2Tan, "Created: " & frmStar.txtGameName.text & " // Password: " & frmStar.txtGamePass.text
            frmMain.txtChannelInfo.text = frmStar.txtGameName.text
            frmMain.lstChannel.ListItems.Clear
            PBuffer.SendPacket &H10
        Case &H61
            frmWar3.Hide
            frmMain.txtChannelInfo.text = "Arranged Game"
            frmMain.lstChannel.ListItems.Clear
        Case &H33
            PBuffer.SendPacket &H60
            AddChat vbD2Tan, "Requesting users to invite.."
        Case &H60
            frmWar3.InviteUsers.ListItems.Clear
            Count = Asc(Mid(Data, 5, 1))
            pos = 2
            For i = 1 To Count
                usrName = Mid(Mid(Data, 4), pos, InStr(pos, Mid(Data, 4), Chr(0)) - pos)
                frmWar3.InviteUsers.ListItems.Add , , usrName
                pos = InStr(pos, Mid(Data, 4), Chr(0)) + 1
            Next i
            
        Case &H6
        Case Else
            If Len(PacketID) = 1 Then
                AddChat vbRed, "Unhandled Packet: 0x0" & Hex(PacketID)
            Else
                AddChat vbRed, "Unhandled Packet: 0x" & Hex(PacketID)
            End If
            AddChat vbWhite, StrToHex(Hex(PacketID))
    End Select
End Sub
