using System.Runtime.InteropServices;
using System.Collections.Specialized;

internal static class PeFileReader
{
    #region _IMAGE_DOS_HEADER
    [StructLayout(LayoutKind.Sequential, Pack=1)]
    internal struct DosImageHeader
    {
        public short e_magic, e_cblp, e_cp, e_crlc, e_cparhdr, e_minalloc, e_maxalloc, e_ss, e_sp, e_csum, e_ip, e_cs, e_lfarlc, e_ovno;
        public short e_res0, e_res1, e_res2, e_res3;
        public short e_oemid, e_oeminfo;
        public short e_res2_0, e_res2_1, e_res2_2, e_res2_3, e_res2_4, e_res2_5, e_res2_6, e_res2_7, e_res2_8, e_res2_9;
        public int e_lfanew;
    }
    #endregion
    #region _IMAGE_NT_HEADERS
    [StructLayout(LayoutKind.Explicit)]
    internal struct NtHeaders
    {
        #region _IMAGE_OPTIONAL_HEADER
        #region 32-bit
        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        internal struct OptionalHeader32
        {
            #region std fields
            public short Magic;
            public byte MajorLinkerVersion, MinorLinkerVersion;
            public int SizeOfCode, SizeOfInitializedData, SizeOfUninitializedData, AddressOfEntryPoint, BaseOfCode, BaseOfData;
            #endregion
            #region nt fields
            public int ImageBase, SectionAlignment, FileAlignment;
            public short MajorOSVersion, MinorOSVersion, MajorImageVersion, MinorImageVersion, MajorSubsystemVersion, MinorSubsystemVersion;
            public int Win32VersionValue, SizeOfImage, SizeOfHeaders, CheckSum;
            public short Subsystem, DllCharacteristics;
            public int SizeOfStackReserve, SizeOfStackCommit, SizeOfHeapReserve, SizeOfHeapCommit, LoaderFlags, NumberOfRvaAndSizes;
            #endregion
            #region unrolled IMAGE_DATA_DIRECTORY entries
            public ImageDataDirectory IDD0, IDD1, IDD2, IDD3, IDD4, IDD5, IDD6, IDD7, IDD8, IDD9, IDDA, IDDB, IDDC, IDDD, IDDE, IDDF;
            #endregion
        }
        #endregion
        #region 64-bit
        #endregion
        #region _IMAGE_DATA_DIRECTORY
        internal struct ImageDataDirectory
        {
            public int VirtualAddress;
            public int Size;
        }
        #endregion
        #endregion
        [FieldOffset(0)]
        public int Signature;
        #region _IMAGE_FILE_HEADER fields
        [FieldOffset(4)]
        public short Machine;
        [FieldOffset(6)]
        public short NumberOfSections;
        [FieldOffset(8)]
        public int TimeDateStamp;
        [FieldOffset(12)]
        public int PointerToSymbolTable;
        [FieldOffset(0x10)]
        public int NumberOfSymbols;
        [FieldOffset(0x14)]
        public short SizeOfOptionalHeader;
        [FieldOffset(0x16)]
        public short Characteristics;
        #endregion
        [FieldOffset(0x18)]
        public OptionalHeader32 OptionalHeader;
    }
    #endregion

    #region _IMAGE_SECTION_HEADER
    [StructLayout(LayoutKind.Explicit)]
    public struct ImageSectionHeader
    {
        [FieldOffset(0)]
        public byte Name; 
        [FieldOffset(8)]
        public int PhysicalAddress;
        [FieldOffset(8)]
        public int VirtualSize;
        [FieldOffset(12)]
        public int VirtualAddress;
        [FieldOffset(0x10)]
        public int SizeOfRawData;
        [FieldOffset(0x14)]
        public int PointerToRawData;
        [FieldOffset(0x18)]
        public int PointerToRelocations;
        [FieldOffset(0x1c)]
        public int PointerToLinenumbers;
        [FieldOffset(0x20)]
        public short NumberOfRelocations;
        [FieldOffset(0x22)]
        public short NumberOfLinenumbers;
        [FieldOffset(0x24)]
        public int Characteristics;
    }
    #endregion

    #region _IMAGE_BASE_RELOCATION
    [StructLayout(LayoutKind.Sequential)]
    public struct ImageBaseRelocation
    {
        public int VirtualAddress;
        public int SizeOfBlock;
    }
    #endregion

    #region _IMAGE_RESOURCE_DIRECTORY_ENTRY
    [StructLayout(LayoutKind.Explicit)]
    public struct ImageResourceDirectoryEntry
    {
        [MarshalAs(UnmanagedType.I4)]
        [FieldOffset(0)]
        public BitVector32 NameOffsetVector;
        [FieldOffset(0)]
        public int Name;
        [FieldOffset(0)]
        public short Id;
        [FieldOffset(4)]
        public int OffsetToData;
        [FieldOffset(4)]
        public BitVector32 DirectoryOffsetVector;
    }
    #endregion

    #region _IMAGE_RESOURCE_DIRECTORY 
    public struct ImageResourceDirectory
    {
#pragma warning disable 649
        public int Characteristics;
        public int TimeDateStamp;
        public short MajorVersion;
        public short MinorVersion;
        public short NumberOfNamedEntries;
        public short NumberOfIdEntries;
#pragma warning restore 649
    }
    #endregion
}
