using System;
using System.Collections.Generic;
using System.Text;

internal static class Native
{
    internal unsafe static void Memcpy(void* target, void* src, int byteLength)
    {
        if ((byteLength % 4) == 0)
        {
            int* tgt = (int*)target;
            int* sr = (int*)src;
            byteLength /= 4;
            for (int i = 0; i < byteLength; i++)
            {
                *(tgt + i) = *(sr + i);
            }
        }
        else
        {
            byte* tgt = (byte*)target;
            byte* sr = (byte*)src;
            for (int i = 0; i < byteLength; i++)
            {
                *(tgt + i) = *(sr + i);
            }
        }
    }

    internal unsafe static void Memset(void* target, byte value, int byteLength)
    {
        if ((byteLength % 4) == 0)
        {
            int* tgt = (int*)target;
            int val = value | (value << 8) | (value << 16) | (value << 24);
            byteLength /= 4;
            for (int i = 0; i < byteLength; i++)
            {
                *(tgt + i) = val;
            }
        }
        else
        {
            byte* tgt = (byte*)target;
            for (int i = 0; i < byteLength; i++)
            {
                *(tgt + i) = value;
            }
        }
    }
    internal static unsafe byte* Memmove(byte* dest, byte* src, int byteCount)
    {
        using (HeapPtr ptr = new HeapPtr(byteCount, AllocMethod.HGlobal))
        {
            ptr.ReadData(src, byteCount);
            Memcpy((void*)dest, ptr.ToPointer(), byteCount);
            return dest;
        }
    }
}
