using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;


    internal sealed class LockdownHeap
    {
        #region LDHeapRecord
        private class LDHeapRecord
        {
            public byte[] data;

        }
        #endregion

        public LockdownHeap()
        {
            m_obs = new List<LDHeapRecord>();
        }

        private List<LDHeapRecord> m_obs;

        public void Add(int[] src)
        {
            byte[] data = new byte[src.Length * 4];
            Buffer.BlockCopy(src, 0, data, 0, src.Length * 4);
            Add(data);
        }

        public void Add(byte[] data)
        {
            if (data.Length < 0x10)
                throw new ArgumentOutOfRangeException("data", "Argument must be 16 bytes or longer.");

            LDHeapRecord rec = new LDHeapRecord();
            rec.data = new byte[16];
            Buffer.BlockCopy(data, 0, rec.data, 0, 16);
            m_obs.Add(rec);
        }

        public HeapPtr ToPointer()
        {
            int byteLength = m_obs.Count * 16;
            HeapPtr ptr = new HeapPtr(byteLength, AllocMethod.HGlobal);
            for (int i = 0; i < m_obs.Count; i++)
            {
                IntPtr memoryBase = (IntPtr)ptr;
                IntPtr memoryOffset = new IntPtr(memoryBase.ToInt64() + (i * 16));
                Marshal.Copy(m_obs[i].data, 0, memoryOffset, 16);
            }
            return ptr;
        }

        public int CurrentLength
        {
            get { return m_obs.Count; }
        }
    }

