﻿Imports System.Xml.Linq
Imports Entelechy.NativeMethods
Module modSettings
  Public Function ProfileCount() As Integer
    Dim xFile As XElement
    Try
      If My.Computer.FileSystem.FileExists(AppData & "\Settings.xml") Then
        Dim lCount As UInt32 = 0
        xFile = XElement.Load(AppData & "\Settings.xml")
        Dim xProfiles = xFile.Element("PROFILES")
        If xProfiles Is Nothing Then
          lCount = 0
        Else
          For Each xItem In xProfiles.Elements
            If xItem.Name = "PROFILE" Then lCount += 1
          Next
        End If
        Return lCount
      Else
        Return 0
      End If
    Catch
      Return 0
    End Try
  End Function

  Public Sub InsertSettings(Index As Integer, NewIndex As Integer)
    Dim xFile As XElement
    If My.Computer.FileSystem.FileExists(AppData & "\Settings.xml") Then
      xFile = XElement.Load(AppData & "\Settings.xml")
      Dim xProfiles = xFile.Element("PROFILES")
      If xProfiles IsNot Nothing Then
        Dim xIndex As XElement = (From xItem As XElement In xProfiles.Elements Where xItem.Name = "PROFILE" AndAlso xItem.Attribute("ID").Value = Index Select xItem).FirstOrDefault
        If xIndex Is Nothing Then Exit Sub
        If Index < NewIndex Then
          For I As Integer = Index To NewIndex - 1
            For Each xItem As XElement In xProfiles.Elements
              If xItem.Name = "PROFILE" And xItem.Attribute("ID").Value = I + 1 Then
                xItem.Attribute("ID").Value = I
                Exit For
              End If
            Next xItem
          Next
          xIndex.Attribute("ID").Value = NewIndex
        ElseIf Index > NewIndex Then
          For I As Integer = Index - 1 To NewIndex Step -1
            For Each xItem As XElement In xProfiles.Elements
              If xItem.Name = "PROFILE" And xItem.Attribute("ID").Value = I Then
                xItem.Attribute("ID").Value = I + 1
                Exit For
              End If
            Next xItem
          Next
          xIndex.Attribute("ID").Value = NewIndex
        End If
      End If
      xFile.Save(AppData & "\Settings.xml")
    End If
  End Sub

  Public Sub LoadSettings(Index As Integer, ByRef Settings As BNUI.cConfig)
    Dim xFile As XElement
    If My.Computer.FileSystem.FileExists(AppData & "\Settings.xml") Then
      xFile = XElement.Load(AppData & "\Settings.xml")
      Dim xProfiles = xFile.Element("PROFILES")
      Settings = New BNUI.cConfig
      If xProfiles IsNot Nothing Then
        Dim xItem As XElement = (From xFind As XElement In xProfiles.Elements Where xFind.Name = "PROFILE" AndAlso xFind.Attribute("ID").Value = Index Select xFind).FirstOrDefault
        If xItem IsNot Nothing Then
          If xItem.Attribute("NAME") IsNot Nothing Then Settings.Account.ProfileName = xItem.Attribute("NAME").Value
          If xItem.Element("BNET") IsNot Nothing Then
            Dim xBNet As XElement = xItem.Element("BNET")
            If xBNet.Element("ACCOUNT") IsNot Nothing Then
              Dim xAccount As XElement = xBNet.Element("ACCOUNT")
              If xAccount.Element("ACCOUNT") IsNot Nothing Then Settings.Account.Username = xAccount.Element("ACCOUNT").Value
              If xAccount.Element("PASSWORD") IsNot Nothing Then Settings.Account.Password = xAccount.Element("PASSWORD").Value
              If xAccount.Element("EMAIL") IsNot Nothing Then Settings.Account.EMail = xAccount.Element("EMAIL").Value
            End If
            If xBNet.Element("CONNECTION") IsNot Nothing Then
              Dim xConnection As XElement = xBNet.Element("CONNECTION")
              If xConnection.Element("PRODUCT") IsNot Nothing Then Settings.Account.Client.Product = [Enum].Parse(GetType(BNUI.GameType), xConnection.Element("PRODUCT").Value)
              If xConnection.Element("PRODUCT").HasAttributes Then If xConnection.Element("PRODUCT").Attribute("SPAWN") IsNot Nothing Then Settings.Account.Client.Spawn = xConnection.Element("PRODUCT").Attribute("SPAWN").Value
              If xConnection.Element("STATSTRING") IsNot Nothing Then Settings.Account.StatString = xConnection.Element("STATSTRING").Value
              If xConnection.Element("CDKEY") IsNot Nothing Then
                If xConnection.Element("CDKEY").HasElements Then
                  If xConnection.Element("CDKEY").Element("PRODUCT") IsNot Nothing Then Settings.Account.Client.CDKey.ProductVal = xConnection.Element("CDKEY").Element("PRODUCT")
                  If xConnection.Element("CDKEY").Element("PUBLIC") IsNot Nothing Then Settings.Account.Client.CDKey.PublicVal = xConnection.Element("CDKEY").Element("PUBLIC")
                  If xConnection.Element("CDKEY").Element("PRIVATE") IsNot Nothing Then
                    Dim sPriv As String = xConnection.Element("CDKEY").Element("PRIVATE")
                    If IsNumeric(sPriv) Then
                      Settings.Account.Client.CDKey.PrivateVal = sPriv
                    Else
                      Dim sBytes() As String = sPriv.Split("-")
                      If sBytes.Length = 10 Then
                        ReDim Settings.Account.Client.CDKey.PrivateVal26(9)
                        For I As Integer = 0 To sBytes.Length - 1
                          Settings.Account.Client.CDKey.PrivateVal26(I) = Byte.Parse(sBytes(I), NumberStyles.HexNumber)
                        Next
                      End If
                    End If
                  End If
                Else
                  Dim cKey As New clsKey(xConnection.Element("CDKEY").Value)
                  Settings.Account.Client.CDKey.ProductVal = cKey.Product
                  Settings.Account.Client.CDKey.PublicVal = cKey.PublicVal
                  Settings.Account.Client.CDKey.PrivateVal = cKey.PrivateVal
                  Settings.Account.Client.CDKey.PrivateVal26 = cKey.PrivateVal26
                End If
              End If
              If xConnection.Element("EXPKEY") IsNot Nothing Then
                If xConnection.Element("EXPKEY").HasElements Then
                  If xConnection.Element("EXPKEY").Element("PRODUCT") IsNot Nothing Then Settings.Account.Client.EXPKey.ProductVal = xConnection.Element("EXPKEY").Element("PRODUCT")
                  If xConnection.Element("EXPKEY").Element("PUBLIC") IsNot Nothing Then Settings.Account.Client.EXPKey.PublicVal = xConnection.Element("EXPKEY").Element("PUBLIC")
                  If xConnection.Element("EXPKEY").Element("PRIVATE") IsNot Nothing Then
                    Dim sPriv As String = xConnection.Element("EXPKEY").Element("PRIVATE")
                    If IsNumeric(sPriv) Then
                      Settings.Account.Client.EXPKey.PrivateVal = sPriv
                    Else
                      Dim sBytes() As String = sPriv.Split("-")
                      If sBytes.Length = 10 Then
                        ReDim Settings.Account.Client.EXPKey.PrivateVal26(9)
                        For I As Integer = 0 To sBytes.Length - 1
                          Settings.Account.Client.EXPKey.PrivateVal26(I) = Byte.Parse(sBytes(I), NumberStyles.HexNumber)
                        Next
                      End If
                    End If
                  End If
                Else
                  Dim cKey As New clsKey(xConnection.Element("EXPKEY").Value)
                  Settings.Account.Client.EXPKey.ProductVal = cKey.Product
                  Settings.Account.Client.EXPKey.PublicVal = cKey.PublicVal
                  Settings.Account.Client.EXPKey.PrivateVal = cKey.PrivateVal
                  Settings.Account.Client.EXPKey.PrivateVal26 = cKey.PrivateVal26
                End If
              End If
              If xConnection.Element("HOMECHANNEL") IsNot Nothing Then Settings.Account.HomeChannel = xConnection.Element("HOMECHANNEL").Value
              If xConnection.Element("SERVER") IsNot Nothing Then Settings.Server = xConnection.Element("SERVER").Value
              If Settings.Account.ProfileName Is Nothing Then
                If GetGateways() Is Nothing Then
                  Settings.Account.ProfileName = Settings.Account.Username & "@" & Settings.Server
                Else
                  Settings.Account.ProfileName = Settings.Account.Username & "@" & GetGatewayName(Settings.Server, Settings.Account.Client.Product = BNUI.GameType.WAR3 Or Settings.Account.Client.Product = BNUI.GameType.W3XP)
                End If
              End If
              If xConnection.Element("D2REALM") IsNot Nothing Then Settings.Account.Client.D2Realm = xConnection.Element("D2REALM").Value
            End If
          End If
          If xItem.Element("CONFIGURATION") IsNot Nothing Then
            Dim xConfiguration As XElement = xItem.Element("CONFIGURATION")
            If xConfiguration.Element("CHAT") IsNot Nothing Then
              Dim xChat As XElement = xConfiguration.Element("CHAT")
              If xChat.Element("PUBAWAY") IsNot Nothing Then Settings.Display.PubAway = xChat.Element("PUBAWAY").Value
              If xChat.Element("AUTOAWAY") IsNot Nothing Then Settings.AutoAway = xChat.Element("AUTOAWAY").Value
              If xChat.Element("UTF8") IsNot Nothing Then Settings.UTF8 = xChat.Element("UTF8").Value
              If xChat.Element("WHISFWD") IsNot Nothing Then Settings.WhisFwd = xChat.Element("WHISFWD").Value
              If xChat.Element("MAXLINES") IsNot Nothing Then Settings.Display.MaxLines = xChat.Element("MAXLINES").Value
              If Settings.Display.MaxLines < MAXLINE_MIN Then Settings.Display.MaxLines = MAXLINE_MIN
              If Settings.Display.MaxLines > MAXLINE_MAX Then Settings.Display.MaxLines = MAXLINE_MAX
              If xChat.Element("D2EMOTE") IsNot Nothing Then Settings.Display.D2Emote = xChat.Element("D2EMOTE").Value
              If xChat.Element("JOINLEAVE") IsNot Nothing Then Settings.Display.JoinLeave = xChat.Element("JOINLEAVE").Value
              If xChat.Element("LOGCHAT") IsNot Nothing Then Settings.LogChat = xChat.Element("LOGCHAT").Value
              If xChat.Element("SPAM") IsNot Nothing Then Settings.Display.PreventSpam = xChat.Element("SPAM").Value
              If xChat.Element("EMOTICONS") IsNot Nothing Then Settings.Display.Emoticons = xChat.Element("EMOTICONS").Value
            End If
            If xConfiguration.Element("UI") IsNot Nothing Then
              Dim xUI As XElement = xConfiguration.Element("UI")
              If xUI.Element("TIMESTAMP") IsNot Nothing Then
                Dim xStamp As XElement = xUI.Element("TIMESTAMP")
                If xStamp.Attribute("ENABLED") IsNot Nothing Then Settings.Display.TimeStampEnabled = xStamp.Attribute("ENABLED")
                Settings.Display.TimeStamp = xStamp.Value
              End If
              If xUI.Element("WHISWIN") IsNot Nothing Then Settings.Display.WhisWin = xUI.Element("WHISWIN").Value
              If xUI.Element("RICHTEXT") IsNot Nothing Then Settings.Display.RichText = xUI.Element("RICHTEXT").Value
              If xUI.Element("ACCOUNTINFO") IsNot Nothing Then Settings.Display.AccountInfo = xUI.Element("ACCOUNTINFO").Value
              If xUI.Element("LISTWIDTH") IsNot Nothing Then Settings.Display.UI.ListWidth = xUI.Element("LISTWIDTH").Value
              If xUI.Element("PREWIDTH") IsNot Nothing Then Settings.Display.UI.PreWidth = xUI.Element("PREWIDTH").Value
              If xUI.Element("SENDWIDTH") IsNot Nothing Then Settings.Display.UI.SendWidth = xUI.Element("SENDWIDTH").Value
              If xUI.Element("WHISPERWIDTH") IsNot Nothing Then Settings.Display.UI.WhisperWidth = xUI.Element("WHISPERWIDTH").Value
              If xUI.Element("STYLESHEET") IsNot Nothing Then Settings.Display.UI.CustomCSS = xUI.Element("STYLESHEET").Value
            End If
            If xConfiguration.Element("NETWORK") IsNot Nothing Then
              Dim xNetwork As XElement = xConfiguration.Element("NETWORK")
              If xNetwork.Element("AUTOCONNECT") IsNot Nothing Then Settings.AutoConnect = xNetwork.Element("AUTOCONNECT").Value
              If xNetwork.Element("UDP") IsNot Nothing Then Settings.Account.Client.UDPPlug = xNetwork.Element("UDP").Value
              If xNetwork.Element("ADS") IsNot Nothing Then Settings.Display.GetAds = xNetwork.Element("ADS").Value
              If xNetwork.Element("PING") IsNot Nothing Then Settings.PingSpoof = xNetwork.Element("PING").Value
              If xNetwork.Element("RECONNECT") IsNot Nothing Then Settings.AutoReconnect = xNetwork.Element("RECONNECT").Value
              If xNetwork.Element("PROXY") IsNot Nothing Then
                Dim xProxy As XElement = xNetwork.Element("PROXY")
                If xProxy.Attribute("ENABLED") IsNot Nothing Then Settings.Proxy.Use = xProxy.Attribute("ENABLED").Value
                If xProxy.Element("IP") IsNot Nothing Then Settings.Proxy.IP = xProxy.Element("IP").Value
                If xProxy.Element("PORT") IsNot Nothing Then Settings.Proxy.Port = xProxy.Element("PORT").Value
                If xProxy.Element("VER") IsNot Nothing Then
                  Select Case xProxy.Element("VER").Value.ToUpper
                    Case "HTTP"
                      Settings.Proxy.Ver = BNUI.ProxyType.HTTP
                    Case "SOCKS4"
                      Settings.Proxy.Ver = BNUI.ProxyType.SOCKS4
                    Case "SOCKS5"
                      Settings.Proxy.Ver = BNUI.ProxyType.SOCKS5
                    Case Else
                      Settings.Proxy.Ver = BNUI.ProxyType.HTTP
                  End Select
                End If
                If xProxy.Element("USER") IsNot Nothing Then Settings.Proxy.User = xProxy.Element("USER").Value
                If xProxy.Element("PASS") IsNot Nothing Then Settings.Proxy.Pass = xProxy.Element("PASS").Value
              End If
            End If
            If xConfiguration.Element("SQUELCH") IsNot Nothing Then
              Dim xSquelch As XElement = xConfiguration.Element("SQUELCH")
              If xSquelch.HasElements Then
                For Each xSquelchedUser As XElement In xSquelch.Elements
                  Settings.SquelchList.Add(xSquelchedUser.Value)
                Next
              End If
            End If
          End If
          If xItem.Element("IDLE") IsNot Nothing Then
            Dim xIdle As XElement = xItem.Element("IDLE")
            If xIdle.HasAttributes Then
              Settings.Idle.IdleOn = xIdle.Attribute("ENABLED").Value
            Else
              Settings.Idle.IdleOn = False
            End If
            If xIdle.Element("TIME") IsNot Nothing Then
              Settings.Idle.IdleTime = IIf(xIdle.Element("TIME").Value > 0, xIdle.Element("TIME").Value, 20)
              If xIdle.Element("TIME").HasAttributes Then
                Settings.Idle.IdleOnSong = xIdle.Element("TIME").Attribute("SONG").Value
              Else
                Settings.Idle.IdleOnSong = False
              End If
            End If
            If xIdle.Element("TEXT") IsNot Nothing Then Settings.Idle.IdleText = xIdle.Element("TEXT").Value
          End If
        End If
        If xFile.Element("GENERAL") IsNot Nothing Then
          Dim xGeneral As XElement = xFile.Element("GENERAL")
          If Settings.Account.Client.Product = 0 Then
            Settings.VerByte = 0
          Else
            If xGeneral.Element(Settings.Account.Client.Product.ToString & "_VERBYTE") IsNot Nothing Then Settings.VerByte = xGeneral.Element(Settings.Account.Client.Product.ToString & "_VERBYTE").Value
          End If
          If xGeneral.Element("HASHPATH") IsNot Nothing Then Settings.HashPath = xGeneral.Element("HASHPATH").Value
        End If
      End If
      If String.IsNullOrEmpty(Settings.HashPath) Then Settings.HashPath = AppData & "\Hashes\"
    Else
      Settings = New BNUI.cConfig
    End If
  End Sub

  Public Function GrabKeyStruct(ByRef xSource As XElement) As BNUI.ProductKey
    Dim kStruct As New BNUI.ProductKey
    If xSource IsNot Nothing Then
      If xSource.HasElements Then
        If xSource.Element("PRODUCT") IsNot Nothing Then kStruct.ProductVal = xSource.Element("PRODUCT")
        If xSource.Element("PUBLIC") IsNot Nothing Then kStruct.PublicVal = xSource.Element("PUBLIC")
        If xSource.Element("PRIVATE") IsNot Nothing Then
          Dim sPriv As String = xSource.Element("PRIVATE")
          If IsNumeric(sPriv) Then
            kStruct.PrivateVal = sPriv
            Erase kStruct.PrivateVal26
          Else
            Dim sBytes() As String = sPriv.Split("-")
            If sBytes.Length = 10 Then
              ReDim kStruct.PrivateVal26(9)
              For I As Integer = 0 To sBytes.Length - 1
                kStruct.PrivateVal26(I) = Byte.Parse(sBytes(I), NumberStyles.HexNumber)
              Next
            End If
            kStruct.PrivateVal = 0
          End If
        End If
      Else
        Dim cKey As New clsKey(xSource.Value)
        kStruct.ProductVal = cKey.Product
        kStruct.PublicVal = cKey.PublicVal
        kStruct.PrivateVal = cKey.PrivateVal
        kStruct.PrivateVal26 = cKey.PrivateVal26
      End If
    End If
    Return kStruct
  End Function

  Public Function CreateKeyFromStruct(Product As String, ByRef kStruct As BNUI.ProductKey) As XElement
    If kStruct.PrivateVal26 Is Nothing Then
      Return New XElement(Product, New XElement("PRODUCT", kStruct.ProductVal),
                                   New XElement("PUBLIC", kStruct.PublicVal),
                                   New XElement("PRIVATE", kStruct.PrivateVal))
    Else
      Return New XElement(Product, New XElement("PRODUCT", kStruct.ProductVal),
                                   New XElement("PUBLIC", kStruct.PublicVal),
                                   New XElement("PRIVATE", BitConverter.ToString(kStruct.PrivateVal26)))
    End If
  End Function

  Public Function GetCDKeys(Expansion As Boolean) As IEnumerable(Of XElement)
    Dim xFile As XElement
    GetCDKeys = {New XElement("NONE")}
    If My.Computer.FileSystem.FileExists(AppData & "\Settings.xml") Then
      xFile = XElement.Load(AppData & "\Settings.xml")
      Dim xGeneral = xFile.Element("GENERAL")
      Dim xKeyList As XElement
      If Expansion Then
        xKeyList = xGeneral.Element("EXP_KEYS")
      Else
        xKeyList = xGeneral.Element("CD_KEYS")
      End If
      If xKeyList IsNot Nothing Then Return xKeyList.Elements
    End If
  End Function

  Public Function KeyToStruct(sKey As String) As BNUI.ProductKey
    Dim cKey As New clsKey(sKey)
    Dim tKey As BNUI.ProductKey
    tKey.ProductVal = cKey.Product
    tKey.PublicVal = cKey.PublicVal
    tKey.PrivateVal = cKey.PrivateVal
    tKey.PrivateVal26 = cKey.PrivateVal26
    Return tKey
  End Function

  Public Sub AddCDKey(sKey As String, Product As BNUI.GameType)
    Dim xFile As XElement
    Dim xNewKey = CreateKeyFromStruct(Product.ToString, KeyToStruct(sKey))
    If My.Computer.FileSystem.FileExists(AppData & "\Settings.xml") Then
      xFile = XElement.Load(AppData & "\Settings.xml")
    Else
      xFile = CreateGenericFile()
    End If
    Dim xGeneral As XElement = xFile.Element("GENERAL")
    Dim xKeys As XElement
    If Product = BNUI.GameType.D2XP Or Product = BNUI.GameType.W3XP Then
      xKeys = xGeneral.Element("EXP_KEYS")
    Else
      xKeys = xGeneral.Element("CD_KEYS")
    End If
    If xKeys Is Nothing Then
      If Product = BNUI.GameType.D2XP Or Product = BNUI.GameType.W3XP Then
        xGeneral.Add(New XElement("EXP_KEYS", xNewKey))
      Else
        xGeneral.Add(New XElement("CD_KEYS", xNewKey))
      End If
      xFile.Save(AppData & "\Settings.xml")
    Else
      Dim bFound As Boolean = False
      For Each xItem In xKeys.Elements
        If xItem.HasElements Then
          If xItem.Equals(xNewKey) Then
            bFound = True
            Exit For
          End If
        Else
          xItem = CreateKeyFromStruct(xItem.Name.ToString, KeyToStruct(xItem.Value))
          xFile.Save(AppData & "\Settings.xml")
          If xItem.Equals(xNewKey) Then
            bFound = True
            Exit For
          End If
        End If
      Next xItem
      If Not bFound Then
        xKeys.Add(xNewKey)
        xFile.Save(AppData & "\Settings.xml")
      End If
    End If
  End Sub

  Public Sub RemCDKey(sKey As String, Product As BNUI.GameType)
    Dim xFile As XElement
    Dim xDelKey = CreateKeyFromStruct(Product.ToString, KeyToStruct(sKey))
    If My.Computer.FileSystem.FileExists(AppData & "\Settings.xml") Then
      xFile = XElement.Load(AppData & "\Settings.xml")
      Dim xGeneral As XElement = xFile.Element("GENERAL")
      Dim xKeys As XElement
      If Product = BNUI.GameType.D2XP Or Product = BNUI.GameType.W3XP Then
        xKeys = xGeneral.Element("EXP_KEYS")
      Else
        xKeys = xGeneral.Element("CD_KEYS")
      End If
      If xKeys IsNot Nothing Then
        For Each xItem In xKeys.Elements
          If xItem.ToString = xDelKey.ToString Then
            xItem.Remove()
            xFile.Save(AppData & "\Settings.xml")
            Exit For
          End If
        Next xItem
      End If
    End If
  End Sub

  Public Sub ClearSettings()
    Dim xFile As XElement
    If My.Computer.FileSystem.FileExists(AppData & "\Settings.xml") Then
      xFile = XElement.Load(AppData & "\Settings.xml")
      xFile.Element("PROFILES").RemoveAll()
    Else
      xFile = CreateGenericFile()
    End If
    xFile.Save(AppData & "\Settings.xml")
  End Sub

  Public Sub SaveSettings(Index As Integer, ByRef Settings As BNUI.cConfig)
    Dim xProfile As New XElement("PROFILE",
                                  New XAttribute("ID", Index.ToString),
                                  New XAttribute("NAME", Settings.Account.ProfileName),
                                  New XElement("BNET",
                                              New XElement("ACCOUNT",
                                                            New XElement("ACCOUNT", Settings.Account.Username),
                                                            New XElement("PASSWORD", Settings.Account.Password),
                                                            New XElement("EMAIL", Settings.Account.EMail)),
                                              New XElement("CONNECTION",
                                                            New XElement("PRODUCT", New XAttribute("SPAWN", Settings.Account.Client.Spawn), Settings.Account.Client.Product.ToString),
                                                            New XElement("STATSTRING", Settings.Account.StatString),
                                                            CreateKeyFromStruct("CDKEY", Settings.Account.Client.CDKey),
                                                            CreateKeyFromStruct("EXPKEY", Settings.Account.Client.EXPKey),
                                                            New XElement("HOMECHANNEL", Settings.Account.HomeChannel),
                                                            New XElement("SERVER", Settings.Server),
                                                            New XElement("D2REALM", Settings.Account.Client.D2Realm))),
                                  New XElement("CONFIGURATION",
                                                New XElement("CHAT",
                                                            New XElement("PUBAWAY", Settings.Display.PubAway),
                                                            New XElement("AUTOAWAY", Settings.AutoAway),
                                                            New XElement("UTF8", Settings.UTF8),
                                                            New XElement("WHISFWD", Settings.WhisFwd),
                                                            New XElement("MAXLINES", Settings.Display.MaxLines),
                                                            New XElement("D2EMOTE", Settings.Display.D2Emote),
                                                            New XElement("JOINLEAVE", Settings.Display.JoinLeave),
                                                            New XElement("LOGCHAT", Settings.LogChat),
                                                            New XElement("SPAM", Settings.Display.PreventSpam),
                                                            New XElement("EMOTICONS", Settings.Display.Emoticons)),
                                                New XElement("UI",
                                                            New XElement("TIMESTAMP", New XAttribute("ENABLED", Settings.Display.TimeStampEnabled), Settings.Display.TimeStamp),
                                                            New XElement("WHISWIN", Settings.Display.WhisWin),
                                                            New XElement("RICHTEXT", Settings.Display.RichText),
                                                            New XElement("ACCOUNTINFO", Settings.Display.AccountInfo),
                                                            New XElement("LISTWIDTH", Settings.Display.UI.ListWidth),
                                                            New XElement("PREWIDTH", Settings.Display.UI.PreWidth),
                                                            New XElement("SENDWIDTH", Settings.Display.UI.SendWidth),
                                                            New XElement("WHISPERWIDTH", Settings.Display.UI.WhisperWidth),
                                                            New XElement("STYLESHEET", Settings.Display.UI.CustomCSS)),
                                                New XElement("NETWORK",
                                                            New XElement("AUTOCONNECT", Settings.AutoConnect),
                                                            New XElement("UDP", Settings.Account.Client.UDPPlug),
                                                            New XElement("ADS", Settings.Display.GetAds),
                                                            New XElement("PING", Settings.PingSpoof),
                                                            New XElement("RECONNECT", Settings.AutoReconnect),
                                                            New XElement("PROXY", New XAttribute("ENABLED", Settings.Proxy.Use),
                                                                          New XElement("IP", Settings.Proxy.IP),
                                                                          New XElement("PORT", Settings.Proxy.Port),
                                                                          New XElement("VER", Settings.Proxy.Ver.ToString),
                                                                          New XElement("USER", Settings.Proxy.User),
                                                                          New XElement("PASS", Settings.Proxy.Pass))),
                                                New XElement("SQUELCH",
                                                             CreateSquelchList(Settings.SquelchList))),
                                  New XElement("IDLE", New XAttribute("ENABLED", Settings.Idle.IdleOn),
                                              New XElement("TIME", Settings.Idle.IdleTime, New XAttribute("SONG", Settings.Idle.IdleOnSong)),
                                              New XElement("TEXT", Settings.Idle.IdleText)))
    Dim xFile As XElement
    If My.Computer.FileSystem.FileExists(AppData & "\Settings.xml") Then
      xFile = XElement.Load(AppData & "\Settings.xml")
      Dim xProfiles = xFile.Element("PROFILES")
      If xProfiles Is Nothing Then
        xFile.Add("PROFILES")
        xProfiles = xFile.Element("PROFILES")
      End If
      Dim bFound As Boolean = False
      For Each xItem In xProfiles.Elements
        If xItem.Name = "PROFILE" And xItem.Attribute("ID").Value = Index Then
          bFound = True
          xItem.ReplaceWith(xProfile)
          Exit For
        End If
      Next
      If Not bFound Then
        xProfiles.Add(xProfile)
      End If
    Else
      xFile = CreateGenericFile()
      xFile.Element("PROFILES").Add(xProfile)
    End If
    xFile.Save(AppData & "\Settings.xml")
  End Sub

  Public Sub RemoveSettings(Index As Integer)
    Dim xFile As XElement
    If My.Computer.FileSystem.FileExists(AppData & "\Settings.xml") Then
      xFile = XElement.Load(AppData & "\Settings.xml")
      Dim xProfiles = xFile.Element("PROFILES")
      For Each xItem In xProfiles.Elements
        If xItem.Name = "PROFILE" And xItem.Attribute("ID").Value = Index Then
          xItem.Remove()
          Exit For
        End If
      Next
      xFile.Save(AppData & "\Settings.xml")
    End If
  End Sub

  Public Sub SetVerbyte(GameID As BNUI.GameType, VerByte As UInt32)
    Dim xFile As XElement
    Dim xVerByte = New XElement(GameID.ToString & "_VERBYTE", VerByte.ToString)
    If My.Computer.FileSystem.FileExists(AppData & "\Settings.xml") Then
      xFile = XElement.Load(AppData & "\Settings.xml")
      Dim xGeneral = xFile.Element("GENERAL")
      Dim bFound As Boolean = False
      For Each xItem In xGeneral.Elements
        If xItem.Name = GameID.ToString & "_VERBYTE" Then
          bFound = True
          xItem.ReplaceWith(xVerByte)
          Exit For
        End If
      Next
      If Not bFound Then
        xGeneral.Add(xVerByte)
      End If
    Else
      xFile = CreateGenericFile()
      xFile.Element("GENERAL").Add(xVerByte)
    End If
    xFile.Save(AppData & "\Settings.xml")
  End Sub

  Public Function ReadVerbyte(GameID As BNUI.GameType) As UInt32
    Dim xFile As XElement
    If My.Computer.FileSystem.FileExists(AppData & "\Settings.xml") Then
      xFile = XElement.Load(AppData & "\Settings.xml")
      Dim xGeneral = xFile.Element("GENERAL")
      Dim bFound As Boolean = False
      Dim xItem As XElement = xGeneral.Element(GameID.ToString & "_VERBYTE")
      If xItem Is Nothing Then Return 0
      Return xItem.Value
    End If
    Return 0
  End Function

  Private Function CreateSquelchList(List As ArrayList) As XElement()
    Dim xEls(List.Count - 1) As XElement
    For I As Integer = 0 To List.Count - 1
      xEls(I) = New XElement("USER", List(I))
    Next
    Return xEls
  End Function

  Private Function CreateGenericFile() As XElement
    Return New XElement("SETTINGS",
                              New XElement("GENERAL", New XElement("CD_KEYS"), New XElement("EXP_KEYS")),
                              New XElement("PROFILES"))
  End Function
End Module

Public Module CookieJar
  Private Function Pottery() As XElement
    Return New XElement("COOKIEJAR")
  End Function

  Public Sub BakeCookie(ID As UInt32, Timestamp As UInt32, CookieName As String, CookieValue As String)
    Dim xCookie As New XElement("COOKIE",
                                  New XAttribute("ID", ID.ToString),
                                  New XAttribute("TIME", Timestamp.ToString),
                                  New XAttribute("NAME", CookieName),
                                  New XAttribute("VALUE", CookieValue))
    Dim xFile As XElement
    If My.Computer.FileSystem.FileExists(AppData & "\CookieJar.xml") Then
      xFile = XElement.Load(AppData & "\CookieJar.xml")
      Dim xJar = xFile.Element("COOKIEJAR")
      Dim bFound As Boolean = False
      For Each xItem In xJar.Elements
        If xItem.Name = "COOKIE" And xItem.Attribute("NAME").Value = CookieName Then
          bFound = True
          xItem.ReplaceWith(xCookie)
          Exit For
        End If
      Next
      If Not bFound Then
        xJar.Add(xCookie)
      End If
    Else
      xFile = Pottery()
      xFile.Add(xCookie)
    End If
    xFile.Save(AppData & "\CookieJar.xml")
  End Sub

  Public Sub EatCookie(ByRef ID As Integer, ByRef Timestamp As UInt32, CookieName As String, ByRef CookieValue As String)
    Dim xFile As XElement
    If My.Computer.FileSystem.FileExists(AppData & "\CookieJar.xml") Then
      xFile = XElement.Load(AppData & "\CookieJar.xml")
      Dim xJar = xFile.Element("COOKIEJAR")
      If xJar IsNot Nothing Then
        Dim xCookie As XElement = (From xFind As XElement In xJar.Elements Where xFind.Attribute("NAME") = CookieName Select xFind).FirstOrDefault
        If xCookie IsNot Nothing Then
          If xCookie.Attribute("ID") IsNot Nothing Then ID = xCookie.Attribute("ID").Value
          If xCookie.Attribute("TIME") IsNot Nothing Then ID = xCookie.Attribute("TIME").Value
          If xCookie.Attribute("VALUE") IsNot Nothing Then ID = xCookie.Attribute("VALUE").Value
        End If
      End If
    End If
  End Sub
End Module

Public Class INIReader
  Private INIFile As String
  Private Sections() As String
  Private Keys()() As String
  Public Sub New(FileName As String)
    INIFile = FileName
    Dim sTmp As String = CleanRet(INIRead(INIFile, Nothing, Nothing, ""))
    Sections = sTmp.Split(vbNullChar)
    ReDim Keys(Sections.Length - 1)
    For I = 0 To Sections.Length - 1
      If Sections(I).Length > 0 Then
        sTmp = CleanRet(INIRead(INIFile, Sections(I), Nothing, ""))
        sTmp.Replace(vbNullChar & vbNullChar, vbNullChar)
        Keys(I) = sTmp.Split(vbNullChar)
      End If
    Next
  End Sub

  Public Function GetSections() As String()
    Return Sections
  End Function

  Public Function GetKeys(Section As String) As String()
    For I As Integer = 0 To Sections.Length - 1
      If Sections(I) = Section Then
        Return Keys(I)
      End If
    Next
    Return Nothing
  End Function

  Public Function GetValue(Section As String, Key As String) As String
    Return INIRead(INIFile, Section, Key, String.Empty)
  End Function

  Private Function CleanRet(sTmp As String) As String
    sTmp.Replace(vbNullChar & vbNullChar, vbNullChar)
    If sTmp.Length > 0 Then
      Do While sTmp.Substring(sTmp.Length - 1) = vbNullChar
        sTmp = sTmp.Substring(0, sTmp.Length - 1)
      Loop
    End If
    Return sTmp
  End Function

  Private Function INIRead(INIPath As String, SectionName As String, KeyName As String, DefaultValue As String) As String
    Dim sData As String = Space(1024)
    Dim n As Integer = GetPrivateProfileStringW(SectionName, KeyName, DefaultValue, sData, sData.Length, INIPath)
    If n > 0 Then
      INIRead = sData.Substring(0, n)
    Else
      INIRead = DefaultValue
    End If
  End Function
End Class