﻿Module modParseStats
  Public Class ParseW3Stats
    Public Class ParseW3Map
      Public Function DecodeData(enc() As Byte, ByRef dec() As Byte) As Long
        Dim I As Long
        Dim J As Long
        Dim D As Byte
        Dim lngLen As Long
        For I = 0 To enc.Length - 1
          If (I Mod 8) Then
            ReDim Preserve dec(lngLen)
            J += 1
            dec(lngLen) = (enc(I) And (((D >> J) Or (Not 1))))
            lngLen += 1
          Else
            J = 0
            D = enc(I)
          End If
        Next I
        Return lngLen
      End Function
      Public Function Speed(Flags As UInt32) As String
        Flags = Flags And &H3
        Select Case Flags
          Case &H0 : Return My.Resources.STATSTRING_W3_MAP_SPEED_0
          Case &H1 : Return My.Resources.STATSTRING_W3_MAP_SPEED_1
          Case &H2 : Return My.Resources.STATSTRING_W3_MAP_SPEED_2
          Case Else : Return ResString(My.Resources.STATSTRING_W3_UNKNOWN, PadHex(Flags, 8))
        End Select
      End Function
      Public Function Visibility(Flags As UInt32) As String
        Flags = Flags And &HF00
        Select Case Flags
          Case &H100 : Return My.Resources.STATSTRING_W3_MAP_VIS_100
          Case &H200 : Return My.Resources.STATSTRING_W3_MAP_VIS_200
          Case &H400 : Return My.Resources.STATSTRING_W3_MAP_VIS_400
          Case &H800 : Return My.Resources.STATSTRING_W3_MAP_VIS_800
          Case Else : Return ResString(My.Resources.STATSTRING_W3_UNKNOWN, PadHex(Flags, 8))
        End Select
      End Function
      Public Function Refs(Flags As UInt32) As String
        Flags = Flags And &H40003000
        Select Case Flags
          Case &H0 : Return My.Resources.STATSTRING_W3_MAP_REFS_0
          Case &H2000 : Return My.Resources.STATSTRING_W3_MAP_REFS_2000
          Case &H3000 : Return My.Resources.STATSTRING_W3_MAP_REFS_3000
          Case &H40000000 : Return My.Resources.STATSTRING_W3_MAP_REFS_40000000
          Case Else : Return ResString(My.Resources.STATSTRING_W3_UNKNOWN, PadHex(Flags, 8))
        End Select
      End Function
      Public Function TeamTogether(Flags As UInt32) As Boolean
        Flags = Flags And &H7064000
        Return Flags And &H4000
      End Function
      Public Function FixedTeam(Flags As UInt32) As Boolean
        Flags = Flags And &H7064000
        Return Flags And &H60000
      End Function
      Public Function UnitShare(Flags As UInt32) As Boolean
        Flags = Flags And &H7064000
        Return Flags And &H1000000
      End Function
      Public Function RandomHero(Flags As UInt32) As Boolean
        Flags = Flags And &H7064000
        Return Flags And &H2000000
      End Function
      Public Function RandomRace(Flags As UInt32) As Boolean
        Flags = Flags And &H7064000
        Return Flags And &H4000000
      End Function
    End Class
    Public Class ParseW3Game
      Public Function GameType(Flags As UInt32) As String
        If Flags And &H1 Then Return My.Resources.STATSTRING_W3_GAME_TYPE_1
        If Flags And &H2 Then Return My.Resources.STATSTRING_W3_GAME_TYPE_2
        If Flags And &H3 Then Return My.Resources.STATSTRING_W3_GAME_TYPE_3
        If Flags And &H4 Then Return My.Resources.STATSTRING_W3_GAME_TYPE_4
        If Flags And &H5 Then Return My.Resources.STATSTRING_W3_GAME_TYPE_5
        If Flags And &H6 Then Return My.Resources.STATSTRING_W3_GAME_TYPE_6
        If Flags And &H7 Then Return My.Resources.STATSTRING_W3_GAME_TYPE_7
        If Flags And &H8 Then Return My.Resources.STATSTRING_W3_GAME_TYPE_8
        If Flags And &H9 Then Return My.Resources.STATSTRING_W3_GAME_TYPE_9
        If Flags And &HA Then Return My.Resources.STATSTRING_W3_GAME_TYPE_A
        If Flags And &HB Then Return My.Resources.STATSTRING_W3_GAME_TYPE_B
        If Flags And &HC Then Return My.Resources.STATSTRING_W3_GAME_TYPE_C
        If Flags And &HD Then Return My.Resources.STATSTRING_W3_GAME_TYPE_D
        If Flags And &HF Then Return My.Resources.STATSTRING_W3_GAME_TYPE_F
        If Flags And &H10 Then Return My.Resources.STATSTRING_W3_GAME_TYPE_10
        Return ResString(My.Resources.STATSTRING_W3_UNKNOWN, PadHex(Flags, 8))
      End Function
      Public Function BlizMap(Flags As UInt32) As Boolean
        Flags = Flags And &H6000
        Return Flags And &H2000
      End Function
      Public Function CustomMap(Flags As UInt32) As Boolean
        Flags = Flags And &H6000
        Return Flags And &H4000
      End Function
      Public Function BattleType(Flags As UInt32) As String
        Flags = Flags And &H18000
        Select Case Flags
          Case &H8000 : Return My.Resources.STATSTRING_W3_GAME_BATTLETYPE_8000
          Case &H10000 : Return My.Resources.STATSTRING_W3_GAME_BATTLETYPE_10000
          Case &H0 : Return My.Resources.STATSTRING_W3_GAME_BATTLETYPE_0
          Case Else : Return ResString(My.Resources.STATSTRING_W3_UNKNOWN, PadHex(Flags, 8))
        End Select
      End Function
      Public Function MapSize(Flags As UInt32) As String
        Flags = Flags And &HE0000
        Dim sRet As String = Nothing
        If Flags And &H20000 Then sRet &= My.Resources.STATSTRING_W3_GAME_MAPSIZE_20000 & ", "
        If Flags And &H40000 Then sRet &= My.Resources.STATSTRING_W3_GAME_MAPSIZE_40000 & ", "
        If Flags And &H80000 Then sRet &= My.Resources.STATSTRING_W3_GAME_MAPSIZE_80000 & ", "
        If sRet.Length > 0 Then
          Return sRet.Substring(0, sRet.Length - 2)
        Else
          Return ResString(My.Resources.STATSTRING_W3_UNKNOWN, PadHex(Flags, 8))
        End If
      End Function
      Public Function Observers(Flags As UInt32) As String
        Flags = Flags And &H700000
        Select Case Flags
          Case &H100000 : Return My.Resources.STATSTRING_W3_GAME_OBSERVERS_100000
          Case &H200000 : Return My.Resources.STATSTRING_W3_GAME_OBSERVERS_200000
          Case &H400000 : Return My.Resources.STATSTRING_W3_GAME_OBSERVERS_400000
          Case Else : Return ResString(My.Resources.STATSTRING_W3_UNKNOWN, PadHex(Flags, 8))
        End Select
      End Function
      Public Function PrivateGame(Flags As UInt32) As Boolean
        Return Flags And &H800
      End Function
    End Class
    Public Map As New ParseW3Map
    Public Game As New ParseW3Game
  End Class
  Public Class ParseD2Stats
    Public Function GameStats(Stats As Long) As String
      Dim strStats As String = String.Empty
      If Stats = D2GAME_DOWN Then
        Return My.Resources.STATSTRING_D2_GAMESTATS_DOWN
      ElseIf Stats = D2GAME_GONE Then
        Return My.Resources.STATSTRING_D2_GAMESTATS_GONE
      Else
        If (Stats And D2GAME_EMPTY) Then strStats = My.Resources.STATSTRING_D2_GAMESTATS_EMPTY & " "
        If (Stats And D2GAME_EXPANSION) Then strStats &= My.Resources.STATSTRING_D2_GAMESTATS_EXP & " "
        If (Stats And D2GAME_HARDCORE) Then strStats &= My.Resources.STATSTRING_D2_GAMESTATS_HC & " "
        If (Stats And D2GAME_LADDER) Then strStats &= My.Resources.STATSTRING_D2_GAMESTATS_LAD & " "
        If (Stats And D2GAME_NIGHTMARE) Then strStats &= My.Resources.STATSTRING_D2_GAMESTATS_NIGHTMARE & " "
        If (Stats And D2GAME_HELL) Then strStats &= My.Resources.STATSTRING_D2_GAMESTATS_HELL & " "
        Return Trim(strStats)
      End If
    End Function
    Private Function ArmorName(Torso As Byte, Legs As Byte, RArm As Byte, LArm As Byte, RShoulder As Byte, LShoulder As Byte) As String
      Dim sArmor As String
      sArmor = Torso & Legs & RArm & LArm & RShoulder & LShoulder
      Select Case sArmor
        Case "111111", "255255255255255255" : Return Nothing
        Case "111122" : Return My.Resources.STATSTRING_D2_ARMOR_111122
        Case "211122" : Return My.Resources.STATSTRING_D2_ARMOR_211122
        Case "212222" : Return My.Resources.STATSTRING_D2_ARMOR_212222
        Case "122122" : Return My.Resources.STATSTRING_D2_ARMOR_122122
        Case "221122" : Return My.Resources.STATSTRING_D2_ARMOR_221122
        Case "222222" : Return My.Resources.STATSTRING_D2_ARMOR_222222
        Case "311133" : Return My.Resources.STATSTRING_D2_ARMOR_311133
        Case "222233" : Return My.Resources.STATSTRING_D2_ARMOR_222233
        Case "322222" : Return My.Resources.STATSTRING_D2_ARMOR_322222
        Case "223133" : Return My.Resources.STATSTRING_D2_ARMOR_223133
        Case "332233" : Return My.Resources.STATSTRING_D2_ARMOR_332233
        Case "333322" : Return My.Resources.STATSTRING_D2_ARMOR_333322
        Case "233333" : Return My.Resources.STATSTRING_D2_ARMOR_233333
        Case "333333" : Return My.Resources.STATSTRING_D2_ARMOR_333333
        Case "332331" : Return My.Resources.STATSTRING_D2_ARMOR_332331
        Case Else : Return ResString(My.Resources.STATSTRING_D2_ARMOR_Unknown, sArmor)
      End Select
    End Function
    Private Function ColorName(Color As Byte) As String
      Dim sTint As String = String.Empty
      Dim sColor As String
      Color = Color Mod &HA0
      If Color And &H20 Then
        sTint = My.Resources.STATSTRING_D2_COLOR_TINT20
        Color = Color Mod &H20
      ElseIf Color And &H40 Then
        sTint = My.Resources.STATSTRING_D2_COLOR_TINT40
        Color = Color Mod &H20
      End If
      Select Case Color
        Case &H0, &HFF, &H1F : sColor = String.Empty
        Case &H1 : sColor = My.Resources.STATSTRING_D2_COLOR_1
        Case &H2 : sColor = My.Resources.STATSTRING_D2_COLOR_2
        Case &H3 : sColor = My.Resources.STATSTRING_D2_COLOR_3
        Case &H4 : sColor = My.Resources.STATSTRING_D2_COLOR_4
        Case &H5 : sColor = My.Resources.STATSTRING_D2_COLOR_5
        Case &H6 : sColor = My.Resources.STATSTRING_D2_COLOR_6
        Case &H7 : sColor = My.Resources.STATSTRING_D2_COLOR_7
        Case &H8 : sColor = My.Resources.STATSTRING_D2_COLOR_8
        Case &H9 : sColor = My.Resources.STATSTRING_D2_COLOR_9
        Case &HA : sColor = My.Resources.STATSTRING_D2_COLOR_A
        Case &HB : sColor = My.Resources.STATSTRING_D2_COLOR_B
        Case &HC : sColor = My.Resources.STATSTRING_D2_COLOR_C
        Case &HD : sColor = My.Resources.STATSTRING_D2_COLOR_D
        Case &HE : sColor = My.Resources.STATSTRING_D2_COLOR_E
        Case &HF : sColor = My.Resources.STATSTRING_D2_COLOR_F
        Case &H10 : sColor = My.Resources.STATSTRING_D2_COLOR_10
        Case &H11 : sColor = My.Resources.STATSTRING_D2_COLOR_11
        Case &H12 : sColor = My.Resources.STATSTRING_D2_COLOR_12
        Case &H13 : sColor = My.Resources.STATSTRING_D2_COLOR_13
        Case &H14 : sColor = My.Resources.STATSTRING_D2_COLOR_14
        Case &H15 : sColor = My.Resources.STATSTRING_D2_COLOR_15
        Case Else : sColor = ResString(My.Resources.STATSTRING_D2_COLOR_UNKNOWN, PadHex(Color, 2))
      End Select
      If Not String.IsNullOrEmpty(sColor) Then
        If Not String.IsNullOrEmpty(sTint) Then
          Return sTint & " " & sColor
        Else
          Return sColor
        End If
      Else
        Return Nothing
      End If
    End Function
    Private Function EquipName(Item As Byte) As String
      Select Case Item
        Case &H0, &H1, &H2, &H3, &HFF : Return Nothing
        Case &H4, &H39 : Return My.Resources.STATSTRING_D2_EQUIP_4
        Case &H5, &H3A : Return My.Resources.STATSTRING_D2_EQUIP_5
        Case &H6, &H3B : Return My.Resources.STATSTRING_D2_EQUIP_6
        Case &H7, &H3C : Return My.Resources.STATSTRING_D2_EQUIP_7
        Case &H8, &H3D : Return My.Resources.STATSTRING_D2_EQUIP_8
        Case &H9, &H3E : Return My.Resources.STATSTRING_D2_EQUIP_9
        Case &HA, &H3F : Return My.Resources.STATSTRING_D2_EQUIP_A
        Case &H40, &H53 : Return My.Resources.STATSTRING_D2_EQUIP_40
        Case &H56 : Return My.Resources.STATSTRING_D2_EQUIP_56
        Case &H57 : Return My.Resources.STATSTRING_D2_EQUIP_57
        Case &H58 : Return My.Resources.STATSTRING_D2_EQUIP_58
        Case &H59 : Return My.Resources.STATSTRING_D2_EQUIP_59
        Case &H5A : Return My.Resources.STATSTRING_D2_EQUIP_5A
        Case &H5B : Return My.Resources.STATSTRING_D2_EQUIP_5B
        Case Else : Return ResString(My.Resources.STATSTRING_D2_EQUIP_UNKNOWN, PadHex(Item, 2))
      End Select
    End Function
    Private Function ItemName(Item As Byte) As String
      Select Case Item
        Case &H0, &HFF : Return Nothing
        Case &H4 : Return My.Resources.STATSTRING_D2_ITEM_4
        Case &H5 : Return My.Resources.STATSTRING_D2_ITEM_5
        Case &H6 : Return My.Resources.STATSTRING_D2_ITEM_6
        Case &H7 : Return My.Resources.STATSTRING_D2_ITEM_7
        Case &H8 : Return My.Resources.STATSTRING_D2_ITEM_8
        Case &H9 : Return My.Resources.STATSTRING_D2_ITEM_9
        Case &HA : Return My.Resources.STATSTRING_D2_ITEM_A
        Case &HB : Return My.Resources.STATSTRING_D2_ITEM_B
        Case &HC : Return My.Resources.STATSTRING_D2_ITEM_C
        Case &HD : Return My.Resources.STATSTRING_D2_ITEM_D
        Case &HE : Return My.Resources.STATSTRING_D2_ITEM_E
        Case &HF : Return My.Resources.STATSTRING_D2_ITEM_F
        Case &H10 : Return My.Resources.STATSTRING_D2_ITEM_10
        Case &H11 : Return My.Resources.STATSTRING_D2_ITEM_11
        Case &H12 : Return My.Resources.STATSTRING_D2_ITEM_12
        Case &H13 : Return My.Resources.STATSTRING_D2_ITEM_13
        Case &H14 : Return My.Resources.STATSTRING_D2_ITEM_14
        Case &H15 : Return My.Resources.STATSTRING_D2_ITEM_15
        Case &H16 : Return My.Resources.STATSTRING_D2_ITEM_16
        Case &H17 : Return My.Resources.STATSTRING_D2_ITEM_17
        Case &H18 : Return My.Resources.STATSTRING_D2_ITEM_18
        Case &H19 : Return My.Resources.STATSTRING_D2_ITEM_19
        Case &H1A : Return My.Resources.STATSTRING_D2_ITEM_1A
        Case &H1B : Return My.Resources.STATSTRING_D2_ITEM_1B
        Case &H1C : Return My.Resources.STATSTRING_D2_ITEM_1C
        Case &H1D : Return My.Resources.STATSTRING_D2_ITEM_1D
        Case &H1E : Return My.Resources.STATSTRING_D2_ITEM_1E
        Case &H1F : Return My.Resources.STATSTRING_D2_ITEM_1F
        Case &H20 : Return My.Resources.STATSTRING_D2_ITEM_20
        Case &H21 : Return My.Resources.STATSTRING_D2_ITEM_21
        Case &H22 : Return My.Resources.STATSTRING_D2_ITEM_22
        Case &H23 : Return My.Resources.STATSTRING_D2_ITEM_23
        Case &H24 : Return My.Resources.STATSTRING_D2_ITEM_24
        Case &H25 : Return My.Resources.STATSTRING_D2_ITEM_25
        Case &H26 : Return My.Resources.STATSTRING_D2_ITEM_26
        Case &H27 : Return My.Resources.STATSTRING_D2_ITEM_27
        Case &H28 : Return My.Resources.STATSTRING_D2_ITEM_28
        Case &H29 : Return My.Resources.STATSTRING_D2_ITEM_29
        Case &H2A : Return My.Resources.STATSTRING_D2_ITEM_2A
        Case &H2B, &HF3, &HF4, &HFB : Return My.Resources.STATSTRING_D2_ITEM_2B
        Case &H2C, &HF5, &HF6, &HFC : Return My.Resources.STATSTRING_D2_ITEM_2C
        Case &H2D, &HF7, &HF8, &HFD : Return My.Resources.STATSTRING_D2_ITEM_2D
        Case &H2E, &HF9, &HFA, &HFE : Return My.Resources.STATSTRING_D2_ITEM_2E
        Case &H2F : Return My.Resources.STATSTRING_D2_ITEM_2F
        Case &H30 : Return My.Resources.STATSTRING_D2_ITEM_30
        Case &H31, &H7A, &HF0 : Return My.Resources.STATSTRING_D2_ITEM_31
        Case &H32, &H7C, &HF2 : Return My.Resources.STATSTRING_D2_ITEM_32
        Case &H33 : Return My.Resources.STATSTRING_D2_ITEM_33
        Case &H34 : Return My.Resources.STATSTRING_D2_ITEM_34
        Case &H35 : Return My.Resources.STATSTRING_D2_ITEM_35
        Case &H36 : Return My.Resources.STATSTRING_D2_ITEM_36
        Case &H37 : Return My.Resources.STATSTRING_D2_ITEM_37
        Case &H4F : Return My.Resources.STATSTRING_D2_ITEM_4F
        Case &H50 : Return My.Resources.STATSTRING_D2_ITEM_50
        Case &H51 : Return My.Resources.STATSTRING_D2_ITEM_51
        Case &H52 : Return My.Resources.STATSTRING_D2_ITEM_52
        Case &H54 : Return My.Resources.STATSTRING_D2_ITEM_54
        Case &H55 : Return My.Resources.STATSTRING_D2_ITEM_55
        Case &H5C : Return My.Resources.STATSTRING_D2_ITEM_5C
        Case &H5D : Return My.Resources.STATSTRING_D2_ITEM_5D
        Case &H5E : Return My.Resources.STATSTRING_D2_ITEM_5E
        Case &H5F : Return My.Resources.STATSTRING_D2_ITEM_5F
        Case &H60 : Return My.Resources.STATSTRING_D2_ITEM_60
        Case &H61 : Return My.Resources.STATSTRING_D2_ITEM_61
        Case &H75, &HEB : Return My.Resources.STATSTRING_D2_ITEM_75
        Case &H76, &HEC : Return My.Resources.STATSTRING_D2_ITEM_76
        Case &H77, &HED : Return My.Resources.STATSTRING_D2_ITEM_77
        Case &H78, &HEE : Return My.Resources.STATSTRING_D2_ITEM_78
        Case &HEF : Return My.Resources.STATSTRING_D2_ITEM_EF
        Case &HF1 : Return My.Resources.STATSTRING_D2_ITEM_f1
        Case Else : Return ResString(My.Resources.STATSTRING_D2_ITEM_UNKNOWN, PadHex(Item, 2))
      End Select
    End Function
    Private Function ParseItems(P() As Byte) As String
      Dim Helm As String
      Dim Armor As String
      Dim RWeapon As String
      Dim LWeapon As String
      Dim LShield As String
      Dim LItem As String
      Dim sRet As String = String.Empty
      Helm = EquipName(P(2))
      Armor = ArmorName(P(3), P(4), P(5), P(6), P(10), P(11))
      RWeapon = ItemName(P(7))
      LWeapon = ItemName(P(8))
      LShield = ItemName(P(9))
      LItem = ItemName(P(12))
      If Not String.IsNullOrEmpty(Helm) Then sRet = My.Resources.STATSTRING_D2_A & " " & Trim(ColorName(P(14)) & " " & Helm)
      If Not String.IsNullOrEmpty(Armor) Then sRet &= ", " & My.Resources.STATSTRING_D2_A & " " & Trim(ColorName(P(15)) & " " & Armor)
      If Not String.IsNullOrEmpty(RWeapon) Then sRet &= ", " & My.Resources.STATSTRING_D2_A & " " & Trim(ColorName(P(19)) & " " & RWeapon)
      If Not String.IsNullOrEmpty(LWeapon) Then sRet &= ", " & My.Resources.STATSTRING_D2_AND_A & " " & Trim(ColorName(P(20)) & " " & LWeapon)
      If Not String.IsNullOrEmpty(LShield) Then sRet &= ", " & My.Resources.STATSTRING_D2_AND_A & " " & Trim(ColorName(P(21)) & " " & LShield)
      If Not String.IsNullOrEmpty(LItem) Then sRet &= ", " & My.Resources.STATSTRING_D2_AND_A & " " & Trim(ColorName(P(24)) & " " & LItem)
      If Not String.IsNullOrEmpty(sRet) Then
        Do While sRet.Substring(0, 2) = ", "
          sRet = sRet.Substring(3)
        Loop
        Return sRet
      Else
        Return My.Resources.STATSTRING_D2_NOTHING
      End If
    End Function
    Private Function GetCharacterName(StatString As String, start As Byte, ByRef cName As String) As Byte
      cName = Mid(StatString, start, InStr(start, StatString, ",") - start)
      Return InStr(start, StatString, ",") + 1
    End Function
    Private Function GetServer(StatString As String, ByRef Server As String) As Byte
      Server = Mid(StatString, 5, InStr(5, StatString, ",") - 5)
      Return InStr(5, StatString, ",") + 1
    End Function
    Public Function ParseChar(Stats As String) As String
      Dim d2Classes(0 To 7) As String
      Dim P() As Byte
      Dim Server As String = String.Empty
      Dim Name As String = String.Empty
      Dim sLen As Byte
      Dim CharClass As Byte
      Dim Female As Boolean
      Dim CharLevel As Long
      Dim Hardcore As Boolean
      Dim Dead As Boolean
      Dim Ladder As Boolean
      Dim Expansion As Boolean
      Dim D2Act As String
      Dim D2Title As Integer
      Dim D2sTitle As String = String.Empty
      Dim CharStats As String
      If Len(Stats) = 4 Then
        CharStats = My.Resources.STATSTRING_D2_OPEN
      ElseIf Len(Stats) > 4 Then
        d2Classes(0) = My.Resources.STATSTRING_D2_CLASS_0
        d2Classes(1) = My.Resources.STATSTRING_D2_CLASS_1
        d2Classes(2) = My.Resources.STATSTRING_D2_CLASS_2
        d2Classes(3) = My.Resources.STATSTRING_D2_CLASS_3
        d2Classes(4) = My.Resources.STATSTRING_D2_CLASS_4
        d2Classes(5) = My.Resources.STATSTRING_D2_CLASS_5
        d2Classes(6) = My.Resources.STATSTRING_D2_CLASS_6
        d2Classes(7) = My.Resources.STATSTRING_D2_CLASS_7
        sLen = GetServer(Stats, Server)
        sLen = GetCharacterName(Stats, sLen, Name)
        ReDim P(Stats.Length - sLen - 1)
        MakeArray(Stats.Substring(sLen - 1), P)
        If UBound(P) >= 30 Then
          CharClass = P(13) - 1
          If CharClass < 0 Or CharClass > 6 Then CharClass = 7
          Female = CharClass = 0 Or CharClass = 1 Or CharClass = 6
          CharLevel = P(25)
          Hardcore = P(26) And &H4
          Dead = P(26) And &H8
          If Not Hardcore Then Dead = False
          Expansion = P(26) And &H20
          Ladder = Not (P(30) = &HFF)
          If Left$(Stats, 4) = "PX2D" And (P(26) And &H20) Then
            Select Case P(27)
              Case &H80
                D2Act = "1 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NORMAL & ")"
                D2Title = 0
              Case &H82
                D2Act = "2 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NORMAL & ")"
                D2Title = 0
              Case &H84
                D2Act = "3 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NORMAL & ")"
                D2Title = 0
              Case &H86
                D2Act = "4/5 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NORMAL & ")"
                D2Title = 0
              Case &H88
                D2Act = "5 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NORMAL & ")"
                D2Title = 0
              Case &H8A
                D2Act = "1 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NIGHTMARE & ")"
                D2Title = 1
              Case &H8C
                D2Act = "2 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NIGHTMARE & ")"
                D2Title = 1
              Case &H8E
                D2Act = "3 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NIGHTMARE & ")"
                D2Title = 1
              Case &H90
                D2Act = "4/5 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NIGHTMARE & ")"
                D2Title = 1
              Case &H92
                D2Act = "5 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NIGHTMARE & ")"
                D2Title = 1
              Case &H94
                D2Act = "1 (" & My.Resources.STATSTRING_D2_DIFFICULTY_HELL & ")"
                D2Title = 2
              Case &H96
                D2Act = "2 (" & My.Resources.STATSTRING_D2_DIFFICULTY_HELL & ")"
                D2Title = 2
              Case &H98
                D2Act = "3 (" & My.Resources.STATSTRING_D2_DIFFICULTY_HELL & ")"
                D2Title = 2
              Case &H9A
                D2Act = "4/5 (" & My.Resources.STATSTRING_D2_DIFFICULTY_HELL & ")"
                D2Title = 2
              Case &H9C
                D2Act = "5 (" & My.Resources.STATSTRING_D2_DIFFICULTY_HELL & ")"
                D2Title = 2
              Case &H9E
                D2Act = String.Empty
                D2Title = 3
              Case Else
                D2Act = String.Empty
                D2Title = P(27)
            End Select
            If D2Title < 1 Then
              D2sTitle = String.Empty
            ElseIf D2Title < 4 Then
              If Hardcore Then
                Select Case D2Title
                  Case 1
                    D2sTitle = "Destroyer"
                  Case 2
                    D2sTitle = "Conquerer"
                  Case 3
                    D2sTitle = "Guardian"
                End Select
              Else
                Select Case D2Title
                  Case 1
                    D2sTitle = "Slayer"
                  Case 2
                    D2sTitle = "Champion"
                  Case 3
                    D2sTitle = IIf(Female, "Matriarch", "Patriarch")
                End Select
              End If
            Else
              D2sTitle = "Unknown: 0x" & Hex$(P(27))
            End If
          Else
            Select Case P(27)

              Case &H80
                D2Act = "1 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NORMAL & ")"
                D2Title = 0
              Case &H82
                D2Act = "2 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NORMAL & ")"
                D2Title = 0
              Case &H84
                D2Act = "3 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NORMAL & ")"
                D2Title = 0
              Case &H86
                D2Act = "4 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NORMAL & ")"
                D2Title = 0
              Case &H88
                D2Act = "1 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NIGHTMARE & ")"
                D2Title = 1
              Case &H8A
                D2Act = "2 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NIGHTMARE & ")"
                D2Title = 1
              Case &H8C
                D2Act = "3 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NIGHTMARE & ")"
                D2Title = 1
              Case &H8E
                D2Act = "4 (" & My.Resources.STATSTRING_D2_DIFFICULTY_NIGHTMARE & ")"
                D2Title = 1
              Case &H90
                D2Act = "1 (" & My.Resources.STATSTRING_D2_DIFFICULTY_HELL & ")"
                D2Title = 2
              Case &H92
                D2Act = "2 (" & My.Resources.STATSTRING_D2_DIFFICULTY_HELL & ")"
                D2Title = 2
              Case &H94
                D2Act = "3 (" & My.Resources.STATSTRING_D2_DIFFICULTY_HELL & ")"
                D2Title = 2
              Case &H96
                D2Act = "4 (" & My.Resources.STATSTRING_D2_DIFFICULTY_HELL & ")"
                D2Title = 2
              Case &H98
                D2Act = String.Empty
                D2Title = 3
              Case Else
                D2Act = String.Empty
                D2Title = 0
            End Select
            If D2Title < 1 Then
              D2sTitle = String.Empty
            ElseIf D2Title < 4 Then
              If Hardcore Then
                Select Case D2Title
                  Case 1
                    D2sTitle = IIf(Female, My.Resources.STATSTRING_D2_TITLE_HC1F, My.Resources.STATSTRING_D2_TITLE_HC1M)
                  Case 2
                    D2sTitle = IIf(Female, My.Resources.STATSTRING_D2_TITLE_HC2F, My.Resources.STATSTRING_D2_TITLE_HC2M)
                  Case 3
                    D2sTitle = IIf(Female, My.Resources.STATSTRING_D2_TITLE_HC3F, My.Resources.STATSTRING_D2_TITLE_HC3M)
                End Select
              Else
                Select Case D2Title
                  Case 1
                    D2sTitle = IIf(Female, My.Resources.STATSTRING_D2_TITLE_1F, My.Resources.STATSTRING_D2_TITLE_1M)
                  Case 2
                    D2sTitle = IIf(Female, My.Resources.STATSTRING_D2_TITLE_2F, My.Resources.STATSTRING_D2_TITLE_2M)
                  Case 3
                    D2sTitle = IIf(Female, My.Resources.STATSTRING_D2_TITLE_3F, My.Resources.STATSTRING_D2_TITLE_3M)
                End Select
              End If
            Else
              D2sTitle = ResString(My.Resources.STATSTRING_D2_TITLE_UNKNOWN, PadHex(P(27), 2))
            End If
          End If
          CharStats = ResString(My.Resources.STATSTRING_D2, D2sTitle, Name, IIf(Dead, My.Resources.STATSTRING_D2_3, String.Empty), IIf(Hardcore, My.Resources.STATSTRING_D2_4, String.Empty), CharLevel, IIf(Expansion, My.Resources.STATSTRING_D2_6, String.Empty), IIf(Ladder, My.Resources.STATSTRING_D2_7T, My.Resources.STATSTRING_D2_7F), d2Classes(CharClass), IIf(Not String.IsNullOrEmpty(D2Act), ResString(My.Resources.STATSTRING_D2_9, D2Act), String.Empty), Server, ParseItems(P))
        Else
          CharStats = Stats
        End If
      Else
        CharStats = Stats
      End If
      Return GameStringToName(Stats.Substring(0, 4)) & ": " & CharStats
    End Function
    Private Sub MakeArray(Text As String, ByRef nArray() As Byte)
      nArray = System.Text.Encoding.GetEncoding(LATIN_1).GetBytes(Text)
    End Sub
  End Class
  Public Class ParseSCStats
    Private Function MapSize(strCase As String) As String
      If String.IsNullOrEmpty(strCase) Then Return "128x128"
      Dim X As Integer = Integer.Parse(strCase.Substring(0, 1))
      Dim Y As Integer = Integer.Parse(strCase.Substring(1, 1))
      Return (X * 32) & "x" & (Y * 32)
    End Function
    Private Function Players(strCase As String) As Byte
      If String.IsNullOrEmpty(strCase) Then Return 8
      Return Byte.Parse(strCase) - 10
    End Function
    Private Function Speed(strCase As String) As String
      If String.IsNullOrEmpty(strCase) Then Return My.Resources.STATSTRING_SC_SPEED_4
      Select Case Integer.Parse(strCase, NumberStyles.HexNumber)
        Case 0 : Return My.Resources.STATSTRING_SC_SPEED_0
        Case 1 : Return My.Resources.STATSTRING_SC_SPEED_1
        Case 2 : Return My.Resources.STATSTRING_SC_SPEED_2
        Case 3 : Return My.Resources.STATSTRING_SC_SPEED_3
        Case 4 : Return My.Resources.STATSTRING_SC_SPEED_4
        Case 5 : Return My.Resources.STATSTRING_SC_SPEED_5
        Case 6 : Return My.Resources.STATSTRING_SC_SPEED_6
        Case Else : Return My.Resources.STATSTRING_SC_SPEED_4
      End Select
    End Function
    Private Function Approval(strCase As String) As String
      If String.IsNullOrEmpty(strCase) Then Return My.Resources.STATSTRING_CLASSIC_APPROVAL_0
      Select Case Integer.Parse(strCase, NumberStyles.HexNumber)
        Case &H0 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_0
        Case &H1 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_1
        Case &H2 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_2
        Case &H3 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_3
        Case &H4 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_4
        Case &H5 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_5
        Case Else : Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strCase)
      End Select
    End Function
    Private Function GameType(strCase As String) As String
      Select Case Integer.Parse(strCase, NumberStyles.HexNumber)
        Case 2 : Return My.Resources.STATSTRING_CLASSIC_TYPE_2
        Case 3 : Return My.Resources.STATSTRING_CLASSIC_TYPE_3
        Case 4 : Return My.Resources.STATSTRING_CLASSIC_TYPE_4
        Case 5 : Return My.Resources.STATSTRING_CLASSIC_TYPE_5
        Case 6 : Return My.Resources.STATSTRING_CLASSIC_TYPE_6
        Case 7 : Return My.Resources.STATSTRING_CLASSIC_TYPE_7
        Case 8 : Return My.Resources.STATSTRING_CLASSIC_TYPE_8
        Case 9 : Return My.Resources.STATSTRING_CLASSIC_TYPE_9
        Case &HA : Return My.Resources.STATSTRING_CLASSIC_TYPE_A
        Case &HB : Return My.Resources.STATSTRING_CLASSIC_TYPE_B
        Case &HC : Return My.Resources.STATSTRING_CLASSIC_TYPE_C
        Case &HD : Return My.Resources.STATSTRING_CLASSIC_TYPE_D
        Case &HF : Return My.Resources.STATSTRING_CLASSIC_TYPE_F
        Case &H10 : Return My.Resources.STATSTRING_CLASSIC_TYPE_10
        Case &H20 : Return My.Resources.STATSTRING_CLASSIC_TYPE_20
        Case Else : Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strCase)
      End Select
    End Function
    Private Function GameSetting(strType As String, strParam As String, Optional Players As Byte = 8) As String
      If String.IsNullOrEmpty(strParam) Then Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
      Select Case Integer.Parse(strType, NumberStyles.HexNumber)
        Case &H2 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &H3 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &H4 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &H5 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &H6 : Return ResString(My.Resources.STATSTRING_CLASSIC_SETTING_6, 2500 * Integer.Parse(strParam, NumberStyles.HexNumber))
        Case &H7 : Return ResString(My.Resources.STATSTRING_CLASSIC_SETTING_7, 15 * Integer.Parse(strParam, NumberStyles.HexNumber))
        Case &H8 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &H9
          Select Case Integer.Parse(strParam, NumberStyles.HexNumber)
            Case &H1 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
            Case &H2 : Return My.Resources.STATSTRING_CLASSIC_SETTING_9_2
            Case Else : Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strParam)
          End Select
        Case &HA : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &HB : Return ResString(My.Resources.STATSTRING_CLASSIC_SETTING_BCD, Integer.Parse(strParam, NumberStyles.HexNumber) + 1)
        Case &HC : Return ResString(My.Resources.STATSTRING_CLASSIC_SETTING_BCD, Integer.Parse(strParam, NumberStyles.HexNumber) + 1)
        Case &HD : Return ResString(My.Resources.STATSTRING_CLASSIC_SETTING_BCD, Integer.Parse(strParam, NumberStyles.HexNumber) + 1)
        Case &HF
          Dim iVal As Integer = Integer.Parse(strParam, NumberStyles.HexNumber)
          If iVal < Players Then
            Return iVal & " vs " & (Players - iVal)
          Else
            Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strParam)
          End If
        Case &H10 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &H20 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case Else : Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strType)
      End Select
    End Function
    Private Function Tileset(strCase As String) As String
      If String.IsNullOrEmpty(strCase) Then Return My.Resources.STATSTRING_SC_TILESET_0
      Select Case Byte.Parse(strCase, NumberStyles.HexNumber)
        Case &H0 : Return My.Resources.STATSTRING_SC_TILESET_0
        Case &H1 : Return My.Resources.STATSTRING_SC_TILESET_1
        Case &H2 : Return My.Resources.STATSTRING_SC_TILESET_2
        Case &H3 : Return My.Resources.STATSTRING_SC_TILESET_3
        Case &H4 : Return My.Resources.STATSTRING_SC_TILESET_4
        Case &H5 : Return My.Resources.STATSTRING_SC_TILESET_5
        Case &H6 : Return My.Resources.STATSTRING_SC_TILESET_6
        Case &H7 : Return My.Resources.STATSTRING_SC_TILESET_7
        Case Else : Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strCase)
      End Select
    End Function
    Public Function ParseMapStats(strStats As String, Optional Shorten As Boolean = False) As String
      Dim aSplit() As String = Split(strStats, ",")
      Dim sSaveHash As String = aSplit(0)
      Dim sMapSize As String = MapSize(aSplit(1))
      Dim bPlayers As Byte = Players(aSplit(2))
      Dim sGameSpeed As String = Speed(aSplit(3))
      Dim sApproval As String = Approval(aSplit(4))
      Dim sGameType As String = GameType(aSplit(5))
      Dim sParameter As String = GameSetting(aSplit(5), aSplit(7), bPlayers)
      Dim sChecksum As String = aSplit(8)
      Dim sTileset As String = Tileset(aSplit(9))
      Dim bReplay As Boolean = aSplit(10) = "1"
      Dim sCreator As String = Split(aSplit(11), vbCr)(0)
      Dim sMapName As String = Split(aSplit(11), vbCr)(1)
      If Shorten Then
        Return sGameType
      Else
        Return ResString(My.Resources.STATSTRING_SC_MAP, sCreator, sMapName, sMapSize, sTileset, sGameType, sParameter, sGameSpeed, bPlayers, sApproval, IIf(String.IsNullOrEmpty(sSaveHash), String.Empty, ResString(My.Resources.STATSTRING_SC_MAP_10, sSaveHash)), IIf(bReplay, ResString(My.Resources.STATSTRING_SC_MAP_11, Nothing), String.Empty))
      End If
    End Function
  End Class
  Public Class ParseJSSCStats
    Private Function MapSize(strCase As String) As String
      If String.IsNullOrEmpty(strCase) Then Return "128x128"
      Dim X As Integer = Integer.Parse(strCase.Substring(0, 1))
      Dim Y As Integer = Integer.Parse(strCase.Substring(1, 1))
      Return (X * 32) & "x" & (Y * 32)
    End Function
    Private Function Players(strCase As String) As Byte
      If String.IsNullOrEmpty(strCase) Then Return 8
      Return Byte.Parse(strCase) - 10
    End Function
    Private Function Speed(strCase As String) As String
      If String.IsNullOrEmpty(strCase) Then Return My.Resources.STATSTRING_SC_SPEED_4
      Select Case Integer.Parse(strCase, NumberStyles.HexNumber)
        Case 0 : Return My.Resources.STATSTRING_SC_SPEED_0
        Case 1 : Return My.Resources.STATSTRING_SC_SPEED_1
        Case 2 : Return My.Resources.STATSTRING_SC_SPEED_2
        Case 3 : Return My.Resources.STATSTRING_SC_SPEED_3
        Case 4 : Return My.Resources.STATSTRING_SC_SPEED_4
        Case 5 : Return My.Resources.STATSTRING_SC_SPEED_5
        Case 6 : Return My.Resources.STATSTRING_SC_SPEED_6
        Case Else : Return My.Resources.STATSTRING_SC_SPEED_4
      End Select
    End Function
    Private Function Approval(strCase As String) As String
      If String.IsNullOrEmpty(strCase) Then Return My.Resources.STATSTRING_CLASSIC_APPROVAL_0
      Select Case Integer.Parse(strCase, NumberStyles.HexNumber)
        Case &H0 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_0
        Case &H1 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_1
        Case &H2 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_2
        Case &H3 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_3
        Case &H4 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_4
        Case &H5 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_5
        Case Else : Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strCase)
      End Select
    End Function
    Private Function GameType(strCase As String) As String
      Select Case Integer.Parse(strCase, NumberStyles.HexNumber)
        Case 2 : Return My.Resources.STATSTRING_CLASSIC_TYPE_2
        Case 3 : Return My.Resources.STATSTRING_CLASSIC_TYPE_3
        Case 4 : Return My.Resources.STATSTRING_CLASSIC_TYPE_4
        Case 5 : Return My.Resources.STATSTRING_CLASSIC_TYPE_5
        Case 6 : Return My.Resources.STATSTRING_CLASSIC_TYPE_6
        Case 7 : Return My.Resources.STATSTRING_CLASSIC_TYPE_7
        Case 8 : Return My.Resources.STATSTRING_CLASSIC_TYPE_8
        Case 9 : Return My.Resources.STATSTRING_CLASSIC_TYPE_9
        Case &HA : Return My.Resources.STATSTRING_CLASSIC_TYPE_A
        Case &HB : Return My.Resources.STATSTRING_CLASSIC_TYPE_B
        Case &HC : Return My.Resources.STATSTRING_CLASSIC_TYPE_C
        Case &HD : Return My.Resources.STATSTRING_CLASSIC_TYPE_D
        Case &HF : Return My.Resources.STATSTRING_CLASSIC_TYPE_F
        Case &H10 : Return My.Resources.STATSTRING_CLASSIC_TYPE_10
        Case &H20 : Return My.Resources.STATSTRING_CLASSIC_TYPE_20
        Case Else : Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strCase)
      End Select
    End Function
    Private Function GameSetting(strType As String, strParam As String, Optional Players As Byte = 8) As String
      If String.IsNullOrEmpty(strParam) Then Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
      Select Case Integer.Parse(strType, NumberStyles.HexNumber)
        Case &H2 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &H3 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &H4 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &H5 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &H6 : Return ResString(My.Resources.STATSTRING_CLASSIC_SETTING_6, (2500 * Integer.Parse(strParam, NumberStyles.HexNumber)))
        Case &H7 : Return ResString(My.Resources.STATSTRING_CLASSIC_SETTING_7, (15 * Integer.Parse(strParam, NumberStyles.HexNumber)))
        Case &H8 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &H9
          Select Case Integer.Parse(strParam, NumberStyles.HexNumber)
            Case &H1 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
            Case &H2 : Return My.Resources.STATSTRING_CLASSIC_SETTING_9_2
            Case Else : Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strParam)
          End Select
        Case &HA : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &HB : Return ResString(My.Resources.STATSTRING_CLASSIC_SETTING_BCD, Integer.Parse(strParam, NumberStyles.HexNumber) + 1)
        Case &HC : Return ResString(My.Resources.STATSTRING_CLASSIC_SETTING_BCD, Integer.Parse(strParam, NumberStyles.HexNumber) + 1)
        Case &HD : Return ResString(My.Resources.STATSTRING_CLASSIC_SETTING_BCD, Integer.Parse(strParam, NumberStyles.HexNumber) + 1)
        Case &HF
          Dim iVal As Integer = Integer.Parse(strParam, NumberStyles.HexNumber)
          If iVal < Players Then
            Return ResString(My.Resources.STATSTRING_CLASSIC_SETTING_F, iVal, (Players - iVal))
          Else
            Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strParam)
          End If
        Case &H10 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &H20 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case Else : Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strType)
      End Select
    End Function
    Private Function Tileset(strCase As String) As String
      If String.IsNullOrEmpty(strCase) Then Return My.Resources.STATSTRING_SC_TILESET_0
      Select Case Byte.Parse(strCase, NumberStyles.HexNumber)
        Case &H0 : Return My.Resources.STATSTRING_SC_TILESET_0
        Case &H1 : Return My.Resources.STATSTRING_SC_TILESET_1
        Case &H2 : Return My.Resources.STATSTRING_SC_TILESET_2
        Case &H3 : Return My.Resources.STATSTRING_SC_TILESET_3
        Case &H4 : Return My.Resources.STATSTRING_SC_TILESET_4
        Case &H5 : Return My.Resources.STATSTRING_SC_TILESET_5
        Case &H6 : Return My.Resources.STATSTRING_SC_TILESET_6
        Case &H7 : Return My.Resources.STATSTRING_SC_TILESET_7
        Case Else : Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strCase)
      End Select
    End Function
    Public Function ParseMapStats(strStats As String, Optional Shorten As Boolean = False) As String
      Dim aSplit() As String = Split(strStats, ",")
      Dim sSaveHash As String = aSplit(0)
      Dim sMapSize As String = MapSize(aSplit(1))
      Dim bPlayers As Byte = Players(aSplit(2))
      Dim sGameSpeed As String = Speed(aSplit(3))
      Dim sApproval As String = Approval(aSplit(4))
      Dim sGameType As String = GameType(aSplit(5))
      Dim sParameter As String = GameSetting(aSplit(5), aSplit(6), bPlayers)
      Dim sChecksum As String = aSplit(7)
      Dim sTileset As String = Tileset(aSplit(8))
      Dim sCreator As String = Split(aSplit(9), vbCr)(0)
      Dim sMapName As String = Split(aSplit(9), vbCr)(1)
      If Shorten Then
        Return sGameType
      Else
        Return ResString(My.Resources.STATSTRING_SC_MAP, sCreator, sMapName, sMapSize, sTileset, sGameType, sParameter, sGameSpeed, bPlayers, sApproval, IIf(String.IsNullOrEmpty(sSaveHash), String.Empty, ResString(My.Resources.STATSTRING_SC_MAP_10, sSaveHash)), String.Empty)
      End If
    End Function
  End Class
  Public Class ParseW2Stats
    Private Function MapSize(strCase As String) As String
      If String.IsNullOrEmpty(strCase) Then Return "128x128"
      Dim X As Integer = Integer.Parse(strCase.Substring(0, 1))
      Dim Y As Integer = Integer.Parse(strCase.Substring(1, 1))
      Return (X * 32) & "x" & (Y * 32)
    End Function
    Private Function Players(strCase As String) As Byte
      If String.IsNullOrEmpty(strCase) Then Return 8
      Return Byte.Parse(strCase) - 10
    End Function
    Private Function Speed(strCase As String) As String
      If String.IsNullOrEmpty(strCase) Then Return My.Resources.STATSTRING_W2_SPEED_5
      Select Case Integer.Parse(strCase, NumberStyles.HexNumber)
        Case &H0 : Return My.Resources.STATSTRING_W2_SPEED_0
        Case &H1 : Return My.Resources.STATSTRING_W2_SPEED_1
        Case &H2 : Return My.Resources.STATSTRING_W2_SPEED_2
        Case &H3 : Return My.Resources.STATSTRING_W2_SPEED_3
        Case &H4 : Return My.Resources.STATSTRING_W2_SPEED_4
        Case &H5 : Return My.Resources.STATSTRING_W2_SPEED_5
        Case &H6 : Return My.Resources.STATSTRING_W2_SPEED_6
        Case &H7 : Return My.Resources.STATSTRING_W2_SPEED_7
        Case &H8 : Return My.Resources.STATSTRING_W2_SPEED_8
        Case Else : Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strCase)
      End Select
    End Function
    Private Function Approval(strCase As String) As String
      If String.IsNullOrEmpty(strCase) Then Return My.Resources.STATSTRING_CLASSIC_APPROVAL_0
      Select Case Integer.Parse(strCase, NumberStyles.HexNumber)
        Case &H0 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_0
        Case &H1 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_1
        Case &H2 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_2
        Case &H3 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_3
        Case &H4 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_4
        Case &H5 : Return My.Resources.STATSTRING_CLASSIC_APPROVAL_5
        Case Else : Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strCase)
      End Select
    End Function
    Private Function GameType(strCase As String) As String
      If String.IsNullOrEmpty(strCase) Then Return My.Resources.STATSTRING_CLASSIC_TYPE_0
      Select Case Integer.Parse(strCase, NumberStyles.HexNumber)
        Case &H2 : Return My.Resources.STATSTRING_CLASSIC_TYPE_2
        Case &H3 : Return My.Resources.STATSTRING_CLASSIC_TYPE_3
        Case &H4 : Return My.Resources.STATSTRING_CLASSIC_TYPE_4
        Case &H9 : Return My.Resources.STATSTRING_CLASSIC_TYPE_9
        Case &HA : Return My.Resources.STATSTRING_CLASSIC_TYPE_A
        Case &HF : Return My.Resources.STATSTRING_CLASSIC_TYPE_F
        Case &H10 : Return My.Resources.STATSTRING_CLASSIC_TYPE_10
        Case Else : Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strCase)
      End Select
    End Function
    Private Function GameParam(strType As String, strParam As String, Optional Players As Byte = 8) As String
      If String.IsNullOrEmpty(strParam) Then Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
      Select Case Integer.Parse(strType, NumberStyles.HexNumber)
        Case &H2 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &H3 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &H4 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &H9
          Select Case Integer.Parse(strParam, NumberStyles.HexNumber)
            Case &H1 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
            Case &H2 : Return My.Resources.STATSTRING_CLASSIC_SETTING_9_2
            Case Else : Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strParam)
          End Select
        Case &HA : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case &HF
          Dim iVal As Integer = Integer.Parse(strParam, NumberStyles.HexNumber)
          If iVal < Players Then
            Return ResString(My.Resources.STATSTRING_CLASSIC_SETTING_F, iVal, (Players - iVal))
          Else
            Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strParam)
          End If
        Case &H10 : Return My.Resources.STATSTRING_CLASSIC_SETTING_NONE
        Case Else : Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strType)
      End Select
    End Function
    Public Function OnePeon(strCase As String) As Boolean
      If String.IsNullOrEmpty(strCase) Then Return False
      Dim iCase As Integer = Integer.Parse(strCase, NumberStyles.HexNumber) And &HF00
      Return iCase And &H200
    End Function
    Public Function FixedOrder(strCase As String) As Boolean
      If String.IsNullOrEmpty(strCase) Then Return False
      Dim iCase As Integer = Integer.Parse(strCase, NumberStyles.HexNumber) And &HF00
      Return iCase And &H400
    End Function
    Public Function Resources(strCase As String) As String
      If String.IsNullOrEmpty(strCase) Then Return My.Resources.STATSTRING_W2_RESOURCES_0
      Dim iCase As Integer = Integer.Parse(strCase, NumberStyles.HexNumber) And &H23000
      If iCase = &H0 Then Return My.Resources.STATSTRING_W2_RESOURCES_0
      If iCase = &H1000 Then Return My.Resources.STATSTRING_W2_RESOURCES_1000
      If iCase = &H2000 Then Return My.Resources.STATSTRING_W2_RESOURCES_2000
      If iCase = &H3000 Then Return My.Resources.STATSTRING_W2_RESOURCES_3000
      If iCase = &H20000 Then Return My.Resources.STATSTRING_W2_RESOURCES_20000
      Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strCase)
    End Function
    Public Function Tileset(strCase As String) As String
      If String.IsNullOrEmpty(strCase) Then Return My.Resources.STATSTRING_W2_TILESET_0
      Dim iCase As Integer = Integer.Parse(strCase, NumberStyles.HexNumber) And &H1C000
      If iCase = &H0 Then Return My.Resources.STATSTRING_W2_TILESET_0
      If iCase = &H4000 Then Return My.Resources.STATSTRING_W2_TILESET_4000
      If iCase = &H8000 Then Return My.Resources.STATSTRING_W2_TILESET_8000
      If iCase = &HC000 Then Return My.Resources.STATSTRING_W2_TILESET_C000
      If iCase = &H14000 Then Return My.Resources.STATSTRING_W2_TILESET_14000
      If iCase = &H1C000 Then Return My.Resources.STATSTRING_W2_TILESET_1C000
      Return ResString(My.Resources.STATSTRING_CLASSIC_UNKNOWN, strCase)
    End Function
    Public Function ParseMapStats(strStats As String, Optional Shorten As Boolean = False) As String
      Dim aSplit() As String = Split(strStats, ",")
      Dim sMapSize As String = MapSize(aSplit(1))
      Dim bPlayers As Byte = Players(aSplit(2))
      Dim sGameSpeed As String = Speed(aSplit(3))
      Dim sApproval As String = Approval(aSplit(4))
      Dim sGameType As String = GameType(aSplit(5))
      Dim sParameter As String = GameParam(aSplit(5), aSplit(6), bPlayers)
      Dim sChecksum As String = aSplit(7)
      Dim bPeon As Boolean = OnePeon(aSplit(8))
      Dim bFixed As Boolean = FixedOrder(aSplit(8))
      Dim sResources As String = Resources(aSplit(8))
      Dim sTileset As String = Tileset(aSplit(8))
      Dim sCreator As String = Split(aSplit(9), vbCr)(0)
      Dim sMapName As String = Split(aSplit(9), vbCr)(1)
      If Shorten Then
        Return sGameType
      Else
        Return ResString(My.Resources.STATSTRING_W2_MAP, sCreator, sMapName, sMapSize, sTileset, sGameType, sParameter, sGameSpeed, bPlayers, sApproval, IIf(Not (bPeon Or bFixed), "Default", IIf(bPeon, "One Peon", String.Empty) & IIf(bPeon And bFixed, ", ", String.Empty) & IIf(bFixed, "Fixed Order", String.Empty)))
      End If
    End Function
  End Class
  Public ParseSCStat As New ParseSCStats
  Public ParseJSSCStat As New ParseJSSCStats
  Public ParseW2Stat As New ParseW2Stats
  Public ParseD2Stat As New ParseD2Stats
  Public ParseW3Stat As New ParseW3Stats

  Public Function CreateGameStatString(GameID As String, GameMap As String, GameSpeed As UInt16, GameType As UInt16, Teams As UInt16, GameCreator As String) As String
    Select Case GameID
      Case "SSHR"
        'CreateGameStatString = "," & GetMapSize(GameMap) & "," & GetMapPlayers(GameMap) & "," & GameSpeed.ToString & ",," & GameType.ToString & "," & IIf(GameType = &HF, Teams, 1).ToString & "," & GetMapChecksum(GameMap) & "," & GetMapTileset(GameMap) & "," & GameCreator & vbLf & GameMap & vbLf
    End Select
    CreateGameStatString = "Not Implemented!"
  End Function

  Public Function ParseStatString(StatString() As Byte) As String
    Return ParseStatString(System.Text.Encoding.GetEncoding(LATIN_1).GetString(StatString))
  End Function

  Public Function ParseStatString(StatString As String) As String
    Dim Values() As String
    Dim sClass As String
    Dim sStats As String
    Dim I As Integer
    If String.IsNullOrEmpty(StatString) Then Return Nothing
    Select Case StrReverse(StatString.Substring(0, 4))
      Case "DRTL", "DSHR"
        If Len(StatString) > 4 Then
          Values = Split(Mid(StatString, 6), " ")
          If UBound(Values) <> 8 Then
            Return ResString(My.Resources.STATSTRING_ILLEGAL, GameStringToName(StatString.Substring(0, 4)), StatString)
          Else
            Select Case Values(1)
              Case 0 : sClass = My.Resources.STATSTRING_D1_CLASS_0
              Case 1 : sClass = My.Resources.STATSTRING_D1_CLASS_1
              Case 2 : sClass = My.Resources.STATSTRING_D1_CLASS_2
              Case Else : sClass = Values(1)
            End Select
            Return ResString(My.Resources.STATSTRING_D1, GameStringToName(StatString.Substring(0, 4)), Values(0), sClass, Values(2), IIf(Values(2) = "1", String.Empty, My.Resources.STATSTRING_PLURAL), Values(3), Values(4), Values(5), Values(6), Values(7))
          End If
        Else
          Return ResString(My.Resources.STATSTRING_BOT, GameStringToName(StatString.Substring(0, 4)))
        End If
      Case "D2DV", "D2XP"
        Return ParseD2Stat.ParseChar(StatString)
      Case "STAR", "JSTR", "SEXP", "W2BN"
        If Len(StatString) > 4 Then
          Values = Split(Mid$(StatString, 6), " ")
          If UBound(Values) <> 8 Then
            Return ResString(My.Resources.STATSTRING_ILLEGAL, GameStringToName(StatString.Substring(0, 4)), StatString)
          Else
            sStats = ResString(My.Resources.STATSTRING_SC_2, Values(2), IIf(Values(2) = 1, String.Empty, My.Resources.STATSTRING_PLURAL))
            If Values(0) > 0 Then sStats &= ResString(My.Resources.STATSTRING_SC_0, Values(0), IIf(Values(5) > 0, ResString(My.Resources.STATSTRING_SC_5, Values(5)), String.Empty))
            If Values(1) > 0 Then sStats &= ResString(My.Resources.STATSTRING_SC_1, Values(1))
            If Values(6) > 0 Then sStats &= ResString(My.Resources.STATSTRING_SC_6, Values(6))
            If Values(7) > 0 Then sStats &= ResString(My.Resources.STATSTRING_SC_7, Values(7))
            If Values(8) <> StatString.Substring(0, 4) Then
              Select Case StrReverse(Values(8))
                Case "WCRF" : sStats &= ResString(My.Resources.STATSTRING_SC_8, My.Resources.STATSTRING_WCG_RF)
                Case "WCPL" : sStats &= ResString(My.Resources.STATSTRING_SC_8, My.Resources.STATSTRING_WCG_PL)
                Case "WCGO" : sStats &= ResString(My.Resources.STATSTRING_SC_8, My.Resources.STATSTRING_WCG_GO)
                Case "WCSI" : sStats &= ResString(My.Resources.STATSTRING_SC_8, My.Resources.STATSTRING_WCG_SI)
                Case "WCBR" : sStats &= ResString(My.Resources.STATSTRING_SC_8, My.Resources.STATSTRING_WCG_BR)
                Case "WCPG" : sStats &= ResString(My.Resources.STATSTRING_SC_8, My.Resources.STATSTRING_WCG_PG)
                Case Else : sStats &= ResString(My.Resources.STATSTRING_SC_8, StrReverse(Values(8)))
              End Select
            End If
            If Values(4) > 0 Then sStats &= ResString(My.Resources.STATSTRING_SC_4, Values(4))
            Return ResString(My.Resources.STATSTRING_SC, GameStringToName(StatString.Substring(0, 4)), IIf(Values(3) = 1, My.Resources.STATSTRING_SPAWN, String.Empty), sStats)
          End If
        Else
          Return ResString(My.Resources.STATSTRING_BOT, GameStringToName(StatString.Substring(0, 4)))
        End If
      Case "SSHR"
        Return GameStringToName(StatString.Substring(0, 4))
      Case "WAR3", "W3XP"
        If Len(StatString) > 4 Then
          If Len(StatString) > 10 Then
            StatString = StatString & " "
            Values = Split(StatString.Substring(4), " ")
            For I = LBound(Values) To UBound(Values)
              Values(I) = StrReverse(Values(I))
            Next I
            If StrReverse(StatString.Substring(0, 4)) = "WAR3" Then
              Select Case Values(1).Substring(Values(1).Length - 2)
                Case "H1" : sClass = My.Resources.STATSTRING_W3_RACE_H & " " & My.Resources.STATSTRING_W3_ICON_1
                Case "H2" : sClass = My.Resources.STATSTRING_W3_RACE_H & " " & My.Resources.STATSTRING_W3_ICON_C_H2
                Case "H3" : sClass = My.Resources.STATSTRING_W3_RACE_H & " " & My.Resources.STATSTRING_W3_ICON_C_H3
                Case "H4" : sClass = My.Resources.STATSTRING_W3_RACE_H & " " & My.Resources.STATSTRING_W3_ICON_C_H4
                Case "H5" : sClass = My.Resources.STATSTRING_W3_RACE_H & " " & My.Resources.STATSTRING_W3_ICON_C_H5
                Case "O1" : sClass = My.Resources.STATSTRING_W3_RACE_O & " " & My.Resources.STATSTRING_W3_ICON_1
                Case "O2" : sClass = My.Resources.STATSTRING_W3_RACE_O & " " & My.Resources.STATSTRING_W3_ICON_C_O2
                Case "O3" : sClass = My.Resources.STATSTRING_W3_RACE_O & " " & My.Resources.STATSTRING_W3_ICON_C_O3
                Case "O4" : sClass = My.Resources.STATSTRING_W3_RACE_O & " " & My.Resources.STATSTRING_W3_ICON_C_O4
                Case "O5" : sClass = My.Resources.STATSTRING_W3_RACE_O & " " & My.Resources.STATSTRING_W3_ICON_C_O5
                Case "N1" : sClass = My.Resources.STATSTRING_W3_RACE_N & " " & My.Resources.STATSTRING_W3_ICON_1
                Case "N2" : sClass = My.Resources.STATSTRING_W3_RACE_N & " " & My.Resources.STATSTRING_W3_ICON_C_N2
                Case "N3" : sClass = My.Resources.STATSTRING_W3_RACE_N & " " & My.Resources.STATSTRING_W3_ICON_C_N3
                Case "N4" : sClass = My.Resources.STATSTRING_W3_RACE_N & " " & My.Resources.STATSTRING_W3_ICON_C_N4
                Case "N5" : sClass = My.Resources.STATSTRING_W3_RACE_N & " " & My.Resources.STATSTRING_W3_ICON_C_N5
                Case "U1" : sClass = My.Resources.STATSTRING_W3_RACE_U & " " & My.Resources.STATSTRING_W3_ICON_1
                Case "U2" : sClass = My.Resources.STATSTRING_W3_RACE_U & " " & My.Resources.STATSTRING_W3_ICON_C_U2
                Case "U3" : sClass = My.Resources.STATSTRING_W3_RACE_U & " " & My.Resources.STATSTRING_W3_ICON_C_U3
                Case "U4" : sClass = My.Resources.STATSTRING_W3_RACE_U & " " & My.Resources.STATSTRING_W3_ICON_C_U4
                Case "U5" : sClass = My.Resources.STATSTRING_W3_RACE_U & " " & My.Resources.STATSTRING_W3_ICON_C_U5
                Case "R1" : sClass = My.Resources.STATSTRING_W3_RACE_R & " " & My.Resources.STATSTRING_W3_ICON_1
                Case "R2" : sClass = My.Resources.STATSTRING_W3_RACE_R & " " & My.Resources.STATSTRING_W3_ICON_C_R2
                Case "R3" : sClass = My.Resources.STATSTRING_W3_RACE_R & " " & My.Resources.STATSTRING_W3_ICON_C_R3
                Case "R4" : sClass = My.Resources.STATSTRING_W3_RACE_R & " " & My.Resources.STATSTRING_W3_ICON_C_R4
                Case "R5" : sClass = My.Resources.STATSTRING_W3_RACE_R & " " & My.Resources.STATSTRING_W3_ICON_C_R5
                Case Else
                  Select Case Values(1)
                    Case "WCPG" : sClass = My.Resources.STATSTRING_WCG_PG
                    Case "WCPL" : sClass = My.Resources.STATSTRING_WCG_PL
                    Case "WCBR" : sClass = My.Resources.STATSTRING_WCG_BR
                    Case "WCGO" : sClass = My.Resources.STATSTRING_WCG_GO
                    Case "WCSI" : sClass = My.Resources.STATSTRING_WCG_SI
                    Case "WCRF" : sClass = My.Resources.STATSTRING_WCG_RF
                    Case "BRED" : sClass = My.Resources.STATSTRING_W3_ICON_BRED
                    Case "BTEA" : sClass = My.Resources.STATSTRING_W3_ICON_BTEA
                    Case "BYEL" : sClass = My.Resources.STATSTRING_W3_ICON_BYEL
                    Case "BOMB" : sClass = My.Resources.STATSTRING_W3_ICON_BOMB
                    Case "FBLU" : sClass = My.Resources.STATSTRING_W3_ICON_FBLU
                    Case "FRED" : sClass = My.Resources.STATSTRING_W3_ICON_FRED
                    Case "FWHI" : sClass = My.Resources.STATSTRING_W3_ICON_FWHI
                    Case "SBLU" : sClass = My.Resources.STATSTRING_W3_ICON_SBLU
                    Case "SGRN" : sClass = My.Resources.STATSTRING_W3_ICON_SGRN
                    Case "SPUR" : sClass = My.Resources.STATSTRING_W3_ICON_SPUR
                    Case "SRED" : sClass = My.Resources.STATSTRING_W3_ICON_SRED
                    Case "SYEL" : sClass = My.Resources.STATSTRING_W3_ICON_SYEL
                    Case "TBLU" : sClass = My.Resources.STATSTRING_W3_ICON_TBLU
                    Case "TBLY" : sClass = My.Resources.STATSTRING_W3_ICON_TBLY
                    Case "TYEL" : sClass = My.Resources.STATSTRING_W3_ICON_TYEL
                    Case "WGLD" : sClass = My.Resources.STATSTRING_W3_ICON_WGLD
                    Case "WGL2" : sClass = My.Resources.STATSTRING_W3_ICON_WGL2
                    Case "WGRN" : sClass = My.Resources.STATSTRING_W3_ICON_WGRN
                    Case "WIND" : sClass = My.Resources.STATSTRING_W3_ICON_WIND
                    Case "WPUR" : sClass = My.Resources.STATSTRING_W3_ICON_WPUR
                    Case "WRED" : sClass = My.Resources.STATSTRING_W3_ICON_WRED
                    Case Else : sClass = Values(1)
                  End Select
              End Select
            Else
              Select Case Values(1).Substring(Values(1).Length - 2)
                Case "H1" : sClass = My.Resources.STATSTRING_W3_RACE_H & " " & My.Resources.STATSTRING_W3_ICON_1
                Case "H2" : sClass = My.Resources.STATSTRING_W3_RACE_H & " " & My.Resources.STATSTRING_W3_ICON_E_H2
                Case "H3" : sClass = My.Resources.STATSTRING_W3_RACE_H & " " & My.Resources.STATSTRING_W3_ICON_E_H3
                Case "H4" : sClass = My.Resources.STATSTRING_W3_RACE_H & " " & My.Resources.STATSTRING_W3_ICON_E_H4
                Case "H5" : sClass = My.Resources.STATSTRING_W3_RACE_H & " " & My.Resources.STATSTRING_W3_ICON_E_H5
                Case "H6" : sClass = My.Resources.STATSTRING_W3_RACE_H & " " & My.Resources.STATSTRING_W3_ICON_E_H6
                Case "O1" : sClass = My.Resources.STATSTRING_W3_RACE_O & " " & My.Resources.STATSTRING_W3_ICON_1
                Case "O2" : sClass = My.Resources.STATSTRING_W3_RACE_O & " " & My.Resources.STATSTRING_W3_ICON_E_O2
                Case "O3" : sClass = My.Resources.STATSTRING_W3_RACE_O & " " & My.Resources.STATSTRING_W3_ICON_E_O3
                Case "O4" : sClass = My.Resources.STATSTRING_W3_RACE_O & " " & My.Resources.STATSTRING_W3_ICON_E_O4
                Case "O5" : sClass = My.Resources.STATSTRING_W3_RACE_O & " " & My.Resources.STATSTRING_W3_ICON_E_O5
                Case "O6" : sClass = My.Resources.STATSTRING_W3_RACE_O & " " & My.Resources.STATSTRING_W3_ICON_E_O6
                Case "N1" : sClass = My.Resources.STATSTRING_W3_RACE_N & " " & My.Resources.STATSTRING_W3_ICON_1
                Case "N2" : sClass = My.Resources.STATSTRING_W3_RACE_N & " " & My.Resources.STATSTRING_W3_ICON_E_N2
                Case "N3" : sClass = My.Resources.STATSTRING_W3_RACE_N & " " & My.Resources.STATSTRING_W3_ICON_E_N3
                Case "N4" : sClass = My.Resources.STATSTRING_W3_RACE_N & " " & My.Resources.STATSTRING_W3_ICON_E_N4
                Case "N5" : sClass = My.Resources.STATSTRING_W3_RACE_N & " " & My.Resources.STATSTRING_W3_ICON_E_N5
                Case "N6" : sClass = My.Resources.STATSTRING_W3_RACE_N & " " & My.Resources.STATSTRING_W3_ICON_E_N6
                Case "U1" : sClass = My.Resources.STATSTRING_W3_RACE_U & " " & My.Resources.STATSTRING_W3_ICON_1
                Case "U2" : sClass = My.Resources.STATSTRING_W3_RACE_U & " " & My.Resources.STATSTRING_W3_ICON_E_U2
                Case "U3" : sClass = My.Resources.STATSTRING_W3_RACE_U & " " & My.Resources.STATSTRING_W3_ICON_E_U3
                Case "U4" : sClass = My.Resources.STATSTRING_W3_RACE_U & " " & My.Resources.STATSTRING_W3_ICON_E_U4
                Case "U5" : sClass = My.Resources.STATSTRING_W3_RACE_U & " " & My.Resources.STATSTRING_W3_ICON_E_U5
                Case "U6" : sClass = My.Resources.STATSTRING_W3_RACE_U & " " & My.Resources.STATSTRING_W3_ICON_E_U6
                Case "R1" : sClass = My.Resources.STATSTRING_W3_RACE_R & " " & My.Resources.STATSTRING_W3_ICON_1
                Case "R2" : sClass = My.Resources.STATSTRING_W3_RACE_R & " " & My.Resources.STATSTRING_W3_ICON_E_R2
                Case "R3" : sClass = My.Resources.STATSTRING_W3_RACE_R & " " & My.Resources.STATSTRING_W3_ICON_E_R3
                Case "R4" : sClass = My.Resources.STATSTRING_W3_RACE_R & " " & My.Resources.STATSTRING_W3_ICON_E_R4
                Case "R5" : sClass = My.Resources.STATSTRING_W3_RACE_R & " " & My.Resources.STATSTRING_W3_ICON_E_R5
                Case "R6" : sClass = My.Resources.STATSTRING_W3_RACE_R & " " & My.Resources.STATSTRING_W3_ICON_E_R6
                Case "D1" : sClass = My.Resources.STATSTRING_W3_RACE_D & " " & My.Resources.STATSTRING_W3_ICON_1
                Case "D2" : sClass = My.Resources.STATSTRING_W3_RACE_D & " " & My.Resources.STATSTRING_W3_ICON_E_D2
                Case "D3" : sClass = My.Resources.STATSTRING_W3_RACE_D & " " & My.Resources.STATSTRING_W3_ICON_E_D3
                Case "D4" : sClass = My.Resources.STATSTRING_W3_RACE_D & " " & My.Resources.STATSTRING_W3_ICON_E_D4
                Case "D5" : sClass = My.Resources.STATSTRING_W3_RACE_D & " " & My.Resources.STATSTRING_W3_ICON_E_D5
                Case "D6" : sClass = My.Resources.STATSTRING_W3_RACE_D & " " & My.Resources.STATSTRING_W3_ICON_E_D6
                Case Else
                  Select Case Values(1)
                    Case "WCPG" : sClass = My.Resources.STATSTRING_WCG_PG
                    Case "WCPL" : sClass = My.Resources.STATSTRING_WCG_PL
                    Case "WCBR" : sClass = My.Resources.STATSTRING_WCG_BR
                    Case "WCGO" : sClass = My.Resources.STATSTRING_WCG_GO
                    Case "WCSI" : sClass = My.Resources.STATSTRING_WCG_SI
                    Case "WCRF" : sClass = My.Resources.STATSTRING_WCG_RF
                    Case "BRED" : sClass = My.Resources.STATSTRING_W3_ICON_BRED
                    Case "BTEA" : sClass = My.Resources.STATSTRING_W3_ICON_BTEA
                    Case "BYEL" : sClass = My.Resources.STATSTRING_W3_ICON_BYEL
                    Case "BOMB" : sClass = My.Resources.STATSTRING_W3_ICON_BOMB
                    Case "FBLU" : sClass = My.Resources.STATSTRING_W3_ICON_FBLU
                    Case "FRED" : sClass = My.Resources.STATSTRING_W3_ICON_FRED
                    Case "FWHI" : sClass = My.Resources.STATSTRING_W3_ICON_FWHI
                    Case "SBLU" : sClass = My.Resources.STATSTRING_W3_ICON_SBLU
                    Case "SGRN" : sClass = My.Resources.STATSTRING_W3_ICON_SGRN
                    Case "SPUR" : sClass = My.Resources.STATSTRING_W3_ICON_SPUR
                    Case "SRED" : sClass = My.Resources.STATSTRING_W3_ICON_SRED
                    Case "SYEL" : sClass = My.Resources.STATSTRING_W3_ICON_SYEL
                    Case "TBLU" : sClass = My.Resources.STATSTRING_W3_ICON_TBLU
                    Case "TBLY" : sClass = My.Resources.STATSTRING_W3_ICON_TBLY
                    Case "TYEL" : sClass = My.Resources.STATSTRING_W3_ICON_TYEL
                    Case "WGLD" : sClass = My.Resources.STATSTRING_W3_ICON_WGLD
                    Case "WGL2" : sClass = My.Resources.STATSTRING_W3_ICON_WGL2
                    Case "WGRN" : sClass = My.Resources.STATSTRING_W3_ICON_WGRN
                    Case "WIND" : sClass = My.Resources.STATSTRING_W3_ICON_WIND
                    Case "WPUR" : sClass = My.Resources.STATSTRING_W3_ICON_WPUR
                    Case "WRED" : sClass = My.Resources.STATSTRING_W3_ICON_WRED
                    Case Else : sClass = Values(1)
                  End Select
              End Select
            End If
            If String.IsNullOrEmpty(sClass) Then sClass = Values(1)
            Return ResString(My.Resources.STATSTRING_W3, GameStringToName(StatString.Substring(0, 4)), StrReverse(Values(2)), sClass, IIf(Len(Values(3)) > 0, ResString(My.Resources.STATSTRING_W3_CLAN, Values(3)), String.Empty))
          Else
            Return ResString(My.Resources.STATSTRING_ILLEGAL, GameStringToName(StatString.Substring(0, 4)), StatString)
          End If
        Else
          Return ResString(My.Resources.STATSTRING_BOT, GameStringToName(StatString.Substring(0, 4)))
        End If
      Case "CHAT"
        If Len(StatString) > 4 Then
          Return ResString(My.Resources.STATSTRING_ILLEGAL, GameStringToName(StatString.Substring(0, 4)), StatString)
        Else
          Return ResString(My.Resources.STATSTRING_BOT, GameStringToName(StatString.Substring(0, 4)))
        End If
      Case Else
        Return ResString(My.Resources.STATSTRING_ILLEGAL, GameStringToName(StatString.Substring(0, 4)), StatString)
    End Select
  End Function
End Module
