﻿Imports System.ComponentModel
Imports System.Runtime.InteropServices

Partial Public Class AlphaForm
  Inherits System.Windows.Forms.Form
  Private m_background As Bitmap
  Private m_backgroundEx As Bitmap
  Private m_backgroundFull As Bitmap
  Private m_useBackgroundEx As Boolean
  Private m_layeredWnd As LayeredWindow
  Private m_offX As Integer
  Private m_offY As Integer
  Private m_renderCtrlBG As Boolean
  Private m_enhanced As Boolean
  Private m_sizeMode As SizeModes
  Private m_hiddenControls As List(Of Control)
  Private m_controlDict As Dictionary(Of Control, Boolean)
  Private m_initialised As Boolean
  Private m_customLayeredWindowProc As Win32.Win32WndProc
  Private m_layeredWindowProc As IntPtr
  Public Sub New()
    If Not Me.DesignMode Then m_layeredWnd = New LayeredWindow()
    m_sizeMode = SizeModes.None
    m_background = Nothing
    m_backgroundEx = Nothing
    m_backgroundFull = Nothing
    m_renderCtrlBG = False
    m_enhanced = False
    m_hiddenControls = New List(Of Control)()
    m_controlDict = New Dictionary(Of Control, Boolean)()
    m_initialised = False
    Me.SetStyle(ControlStyles.DoubleBuffer, True)
  End Sub
#Region "Properties"
  Public Enum SizeModes
    None
    Stretch
    Clip
  End Enum

  <Category("AlphaForm")> _
  Public Property BlendedBackground() As Bitmap
    Get
      Return m_background
    End Get
    Set(value As Bitmap)
      If m_background IsNot value Then
        m_background = value
        UpdateLayeredBackground()
      End If
    End Set
  End Property

  <Category("AlphaForm")> _
  Public Property DrawControlBackgrounds() As Boolean
    Get
      Return m_renderCtrlBG
    End Get
    Set(value As Boolean)
      If m_renderCtrlBG <> value Then
        m_renderCtrlBG = value
        UpdateLayeredBackground()
      End If
    End Set
  End Property

  <Category("AlphaForm")> _
  Public Property EnhancedRendering() As Boolean
    Get
      Return m_enhanced
    End Get
    Set(value As Boolean)
      m_enhanced = value
    End Set
  End Property

  <Category("AlphaForm")> _
  Public Property SizeMode() As SizeModes
    Get
      Return m_sizeMode
    End Get
    Set(value As SizeModes)
      m_sizeMode = value
      UpdateLayeredBackground()
    End Set
  End Property

  Public Sub SetOpacity(Opacity As Double)
    Me.Opacity = Opacity
    If m_background IsNot Nothing Then
      Dim width As Integer = Me.ClientSize.Width
      Dim height As Integer = Me.ClientSize.Height
      If m_sizeMode = SizeModes.None Then
        width = m_background.Width
        height = m_background.Height
      End If
      Dim _opacity As Byte = CByte(Math.Truncate(Me.Opacity * 255))
      If m_useBackgroundEx Then
        m_layeredWnd.UpdateWindow(m_backgroundEx, _opacity, width, height, m_layeredWnd.LayeredPos)
      Else
        m_layeredWnd.UpdateWindow(m_background, _opacity, width, height, m_layeredWnd.LayeredPos)
      End If
    End If
  End Sub

  Public Sub UpdateLayeredBackground()
    UpdateLayeredBackground(Me.ClientSize.Width, Me.ClientSize.Height)
  End Sub

  Public Sub DrawControlBackground(ctrl As Control, drawBack As Boolean)
    If m_controlDict.ContainsKey(ctrl) Then m_controlDict(ctrl) = drawBack
  End Sub
#End Region
  Protected Overrides Sub OnLoad(e As EventArgs)
    MyBase.OnLoad(e)
    Me.BackColor = Color.Fuchsia
    Me.TransparencyKey = Color.Fuchsia
    Me.AllowTransparency = True
    Dim screen As New Point(0, 0)
    screen = Me.PointToScreen(screen)
    m_offX = screen.X - Me.Location.X
    m_offY = screen.Y - Me.Location.Y
    If Not Me.DesignMode Then
      Dim formLoc As Point = Me.Location
      formLoc.X += m_offX
      formLoc.Y += m_offY
      m_layeredWnd.Text = "AlphaForm"
      m_initialised = True
      UpdateLayeredBackground(Me.ClientSize.Width, Me.ClientSize.Height, formLoc, True)
      m_layeredWnd.Show()
      m_layeredWnd.Enabled = False
      m_customLayeredWindowProc = New Win32.Win32WndProc(AddressOf Me.LayeredWindowWndProc)
      m_layeredWindowProc = Win32.SetWindowLong(m_layeredWnd.Handle, CUInt(Win32.Message.GWL_WNDPROC), m_customLayeredWindowProc)
    End If
  End Sub
  Protected Overrides Sub OnPaintBackground(e As PaintEventArgs)
    MyBase.OnPaintBackground(e)
    If m_background IsNot Nothing Then
      If Me.DesignMode Then
        e.Graphics.DrawImage(m_background, 0, 0, m_background.Width, m_background.Height)
      ElseIf m_renderCtrlBG Then
        For Each kvp As KeyValuePair(Of Control, Boolean) In m_controlDict
          Dim ctrl As Control = kvp.Key
          Dim drawBack As Boolean = kvp.Value
          If drawBack AndAlso ctrl.BackColor = Color.Transparent Then
            Dim rect As Rectangle = ctrl.ClientRectangle
            rect.X = ctrl.Left
            rect.Y = ctrl.Top
            If m_useBackgroundEx Then
              e.Graphics.DrawImage(m_backgroundFull, rect, rect, GraphicsUnit.Pixel)
            Else
              e.Graphics.DrawImage(m_background, rect, rect, GraphicsUnit.Pixel)
            End If
          End If
        Next
      End If
    End If
  End Sub
  Protected Overrides Sub OnControlAdded(e As ControlEventArgs)
    MyBase.OnControlAdded(e)
    If Not m_controlDict.ContainsKey(e.Control) Then m_controlDict.Add(e.Control, True)
  End Sub
  Protected Overrides Sub OnControlRemoved(e As ControlEventArgs)
    MyBase.OnControlRemoved(e)
    If m_controlDict.ContainsKey(e.Control) Then m_controlDict.Remove(e.Control)
  End Sub
  Private Sub updateLayeredBackground(width As Integer, height As Integer, pos As Point)
    UpdateLayeredBackground(width, height, pos, True)
  End Sub
  Private Sub updateLayeredBackground(width As Integer, height As Integer)
    UpdateLayeredBackground(width, height, m_layeredWnd.LayeredPos, True)
  End Sub
  Private Sub updateLayeredBackground(width As Integer, height As Integer, pos As Point, Render As Boolean)
    m_useBackgroundEx = False
    If Me.DesignMode OrElse m_background Is Nothing OrElse Not m_initialised Then Exit Sub
    Select Case m_sizeMode
      Case SizeModes.Stretch
        m_useBackgroundEx = True
      Case SizeModes.Clip
      Case SizeModes.None
        width = m_background.Width
        height = m_background.Height
    End Select
    If (m_renderCtrlBG OrElse m_useBackgroundEx) AndAlso Render Then
      If m_backgroundEx IsNot Nothing Then
        m_backgroundEx.Dispose()
        m_backgroundEx = Nothing
      End If
      If m_backgroundFull IsNot Nothing Then
        m_backgroundFull.Dispose()
        m_backgroundFull = Nothing
      End If
      If m_sizeMode = SizeModes.Clip Then
        m_backgroundEx = New Bitmap(m_background)
      Else
        m_backgroundEx = New Bitmap(m_background, width, height)
      End If
      m_backgroundFull = New Bitmap(m_backgroundEx)
    End If
    If m_renderCtrlBG Then
      If Render Then
        Dim g As Graphics = Graphics.FromImage(m_backgroundEx)
        For Each kvp As KeyValuePair(Of Control, Boolean) In m_controlDict
          Dim ctrl As Control = kvp.Key
          Dim drawBack As Boolean = kvp.Value
          If drawBack AndAlso ctrl.BackColor = Color.Transparent Then
            Dim rect As Rectangle = ctrl.ClientRectangle
            rect.X = ctrl.Left
            rect.Y = ctrl.Top
            g.FillRectangle(Brushes.Fuchsia, rect)
          End If
        Next
        g.Dispose()
        m_backgroundEx.MakeTransparent(Color.Fuchsia)
      End If
      m_useBackgroundEx = True
    End If
    Dim _opacity As Byte = CByte(Math.Truncate(Me.Opacity * 255))
    If m_useBackgroundEx Then
      m_layeredWnd.UpdateWindow(m_backgroundEx, _opacity, width, height, pos)
    Else
      m_layeredWnd.UpdateWindow(m_background, _opacity, width, height, pos)
    End If
  End Sub
  Private Sub updateLayeredSize(width As Integer, height As Integer)
    updateLayeredSize(width, height, False)
  End Sub
  Private Sub updateLayeredSize(width As Integer, height As Integer, forceUpdate As Boolean)
    If Not m_initialised Then Return
    If Not forceUpdate AndAlso (width = m_layeredWnd.LayeredSize.Width AndAlso height = m_layeredWnd.LayeredSize.Height) Then Return
    Select Case m_sizeMode
      Case SizeModes.None
        Exit Select
      Case SizeModes.Stretch
        If True Then
          UpdateLayeredBackground(width, height)
          Me.Invalidate(False)
        End If
        Exit Select
      Case SizeModes.Clip
        If True Then
          Dim _opacity As Byte = CByte(Math.Truncate(Me.Opacity * 255))
          If m_useBackgroundEx Then
            m_layeredWnd.UpdateWindow(m_backgroundEx, _opacity, width, height, m_layeredWnd.LayeredPos)
          Else
            m_layeredWnd.UpdateWindow(m_background, _opacity, width, height, m_layeredWnd.LayeredPos)
          End If
        End If
        Exit Select
    End Select
  End Sub
  Protected Overrides Sub WndProc(ByRef m As Message)
    If Me.DesignMode Then
      MyBase.WndProc(m)
      Return
    End If
    Select Case m.Msg
      Case Win32.Message.WM_ACTIVATE
        If m.WParam <> IntPtr.Zero Then
          Dim prevWnd As IntPtr = Win32.GetWindow(m_layeredWnd.Handle, Win32.GetWindow_Cmd.GW_HWNDPREV)
          While prevWnd <> IntPtr.Zero
            If Win32.IsWindowVisible(prevWnd) Then Exit While
            prevWnd = Win32.GetWindow(prevWnd, Win32.GetWindow_Cmd.GW_HWNDPREV)
          End While
          If prevWnd <> Me.Handle Then Win32.SetWindowPos(m_layeredWnd.Handle, Me.Handle, 0, 0, 0, 0, CUInt(Win32.WindowPosFlags.SWP_NOSENDCHANGING Or Win32.WindowPosFlags.SWP_NOACTIVATE Or Win32.WindowPosFlags.SWP_NOSIZE Or Win32.WindowPosFlags.SWP_NOMOVE))
        End If
    End Select
    MyBase.WndProc(m)
  End Sub
  Private Function LayeredWindowWndProc(hWnd As IntPtr, Msg As Integer, wParam As Integer, lParam As Integer) As Integer
    Select Case Msg
      Case Win32.Message.WM_SETCURSOR
        Return 0
    End Select
    Return Win32.CallWindowProc(m_layeredWindowProc, hWnd, Msg, wParam, lParam)
  End Function
End Class

Class LayeredWindow
  Inherits Form
  Private m_rect As Rectangle
  Public Property LayeredPos() As Point
    Get
      Return m_rect.Location
    End Get
    Set(value As Point)
      m_rect.Location = value
    End Set
  End Property
  Public ReadOnly Property LayeredSize() As Size
    Get
      Return m_rect.Size
    End Get
  End Property
  Public Sub New()
    Me.ShowInTaskbar = False
    Me.FormBorderStyle = FormBorderStyle.None
  End Sub
  Public Sub UpdateWindow(image As Bitmap, opacity As Byte)
    UpdateWindow(image, opacity, -1, -1, Me.LayeredPos)
  End Sub
  Public Sub UpdateWindow(image As Bitmap, opacity As Byte, width As Integer, height As Integer, pos As Point)
    Dim hdcWindow As IntPtr = Win32.GetWindowDC(Me.Handle)
    Dim hDC As IntPtr = Win32.CreateCompatibleDC(hdcWindow)
    Dim hBitmap As IntPtr = image.GetHbitmap(Color.FromArgb(0))
    Dim hOld As IntPtr = Win32.SelectObject(hDC, hBitmap)
    Dim size As New Size(0, 0)
    Dim zero As New Point(0, 0)
    If width = -1 OrElse height = -1 Then
      size.Width = image.Width
      size.Height = image.Height
    Else
      size.Width = Math.Min(image.Width, width)
      size.Height = Math.Min(image.Height, height)
    End If
    m_rect.Size = size
    m_rect.Location = pos
    Dim blend As New Win32.BLENDFUNCTION()
    blend.BlendOp = CByte(Win32.BlendOps.AC_SRC_OVER)
    blend.SourceConstantAlpha = opacity
    blend.AlphaFormat = CByte(Win32.BlendOps.AC_SRC_ALPHA)
    blend.BlendFlags = CByte(Win32.BlendFlags.None)
    Win32.UpdateLayeredWindow(Me.Handle, hdcWindow, pos, size, hDC, zero, 0, blend, Win32.BlendFlags.ULW_ALPHA)
    Win32.SelectObject(hDC, hOld)
    Win32.DeleteObject(hBitmap)
    Win32.DeleteDC(hDC)
    Win32.ReleaseDC(Me.Handle, hdcWindow)
  End Sub
  Protected Overrides ReadOnly Property CreateParams() As CreateParams
    Get
      Dim cp As CreateParams = MyBase.CreateParams
      cp.ExStyle = cp.ExStyle Or &H80000
      Return cp
    End Get
  End Property
End Class

NotInheritable Class Win32
  Public Enum Message As UInteger
    WM_NCHITTEST = 132
    HTTRANSPARENT = &HFFFFFFFFUI
    HTCLIENT = 1
    HTCAPTION = 2
    WM_NCMOUSEMOVE = 160
    WM_NCLBUTTONDOWN = 161
    WM_NCLBUTTONUP = 162
    WM_NCLBUTTONDBLCLK = 163
    WM_WINDOWPOSCHANGING = 70
    WM_ENTERSIZEMOVE = 561
    WM_EXITSIZEMOVE = 562
    WM_SYSCOMMAND = 274
    WM_PAINT = 15
    HWND_TOP = 0
    SC_MINIMIZE = 61472
    SC_RESTORE = 61728
    SC_MAXIMIZE = 61488
    WM_SIZE = 5
    WM_ACTIVATE = 6
    WM_SETFOCUS = 7
    WM_SETCURSOR = 32
    WM_MOUSEMOVE = &H200
    WM_LBUTTONDOWN = &H201
    WM_LBUTTONUP = &H202
    WM_LBUTTONDBLCLK = &H203
    WM_RBUTTONDOWN = &H204
    WM_RBUTTONUP = &H205
    WM_RBUTTONDBLCLK = &H206
    WM_MBUTTONDOWN = &H207
    WM_MBUTTONUP = &H208
    WM_MBUTTONDBLCLK = &H209
    WM_MOUSEWHEEL = &H20A
    WM_XBUTTONDOWN = &H20B
    WM_XBUTTONUP = &H20C
    WM_XBUTTONDBLCLK = &H20D
    WM_MOUSELEAVE = &H2A3
    WM_WINDOWPOSCHANGED = &H47
    WM_NCACTIVATE = &H86
    GWL_WNDPROC = &HFFFFFFFCUI
    GWL_EXSTYLE = &HFFFFFFECUI
  End Enum
  <StructLayout(LayoutKind.Sequential)> _
  Public Structure WINDOWPOS
    Public hwnd As IntPtr
    Public hwndInsertAfter As IntPtr
    Public x As Integer
    Public y As Integer
    Public cx As Integer
    Public cy As Integer
    Public flags As WindowPosFlags
  End Structure
  <Flags()> _
  Public Enum WindowPosFlags As UInteger
    NONE = &H0
    SWP_NOSIZE = &H1
    SWP_NOMOVE = &H2
    SWP_NOZORDER = &H4
    SWP_NOREDRAW = &H8
    SWP_NOACTIVATE = &H10
    SWP_FRAMECHANGED = &H20
    SWP_SHOWWINDOW = &H40
    SWP_HIDEWINDOW = &H80
    SWP_NOCOPYBITS = &H100
    SWP_NOOWNERZORDER = &H200
    SWP_NOSENDCHANGING = &H400
    SWP_DEFERERASE = &H2000
    SWP_ASYNCWINDOWPOS = &H4000
    SWP_CUSTOMFLAG = &H8000
  End Enum
  Public Enum GetWindow_Cmd As UInteger
    GW_HWNDFIRST = 0
    GW_HWNDLAST = 1
    GW_HWNDNEXT = 2
    GW_HWNDPREV = 3
    GW_OWNER = 4
    GW_CHILD = 5
    GW_ENABLEDPOPUP = 6
  End Enum
  <StructLayout(LayoutKind.Sequential, Pack:=1)> _
  Public Structure BLENDFUNCTION
    Public BlendOp As Byte
    Public BlendFlags As Byte
    Public SourceConstantAlpha As Byte
    Public AlphaFormat As Byte
  End Structure
  Public Enum BlendOps As Byte
    AC_SRC_OVER = &H0
    AC_SRC_ALPHA = &H1
    AC_SRC_NO_PREMULT_ALPHA = &H1
    AC_SRC_NO_ALPHA = &H2
    AC_DST_NO_PREMULT_ALPHA = &H10
    AC_DST_NO_ALPHA = &H20
  End Enum
  Public Enum BlendFlags As UInteger
    None = &H0
    ULW_COLORKEY = &H1
    ULW_ALPHA = &H2
    ULW_OPAQUE = &H4
  End Enum
  Public Enum TernaryRasterOperations As UInteger
    SRCCOPY = &HCC0020
    SRCPAINT = &HEE0086
    SRCAND = &H8800C6
    SRCINVERT = &H660046
    SRCERASE = &H440328
    NOTSRCCOPY = &H330008
    NOTSRCERASE = &H1100A6
    MERGECOPY = &HC000CA
    MERGEPAINT = &HBB0226
    PATCOPY = &HF00021
    PATPAINT = &HFB0A09
    PATINVERT = &H5A0049
    DSTINVERT = &H550009
    BLACKNESS = &H42
    WHITENESS = &HFF0062
  End Enum
  Public Delegate Function Win32WndProc(hWnd As IntPtr, Msg As Integer, wParam As Integer, lParam As Integer) As Integer
  <DllImportAttribute("user32.dll")> _
  Public Shared Function SendMessage(hWnd As IntPtr, Msg As Integer, wParam As Integer, lParam As Integer) As Integer
  End Function
  <DllImport("user32.dll")> _
  Public Shared Function SetWindowPos(hWnd As IntPtr, hWndInsertAfter As IntPtr, X As Integer, Y As Integer, cx As Integer, cy As Integer, _
  uFlags As UInteger) As <MarshalAs(UnmanagedType.Bool)> Boolean
  End Function
  <DllImport("user32")> _
  Public Shared Function SetWindowLong(hWnd As IntPtr, nIndex As Integer, flags As Long) As IntPtr
  End Function
  <DllImport("user32")> _
  Public Shared Function SetWindowLong(hWnd As IntPtr, nIndex As UInteger, newProc As Win32WndProc) As IntPtr
  End Function
  <DllImport("user32")> _
  Public Shared Function CallWindowProc(lpPrevWndFunc As IntPtr, hWnd As IntPtr, Msg As Integer, wParam As Integer, lParam As Integer) As Integer
  End Function
  <DllImport("user32.dll", SetLastError:=True)> _
  Public Shared Function GetWindow(hWnd As IntPtr, uCmd As GetWindow_Cmd) As IntPtr
  End Function
  <DllImport("gdi32.dll")> _
  Public Shared Function CreateCompatibleDC(hDC As IntPtr) As IntPtr
  End Function
  <DllImport("gdi32.dll")> _
  Public Shared Function SelectObject(hDC As IntPtr, hObject As IntPtr) As IntPtr
  End Function
  <DllImport("gdi32.dll")> _
  Public Shared Function DeleteObject(hObject As IntPtr) As Boolean
  End Function
  <DllImport("gdi32.dll")> _
  Public Shared Function DeleteDC(hdc As IntPtr) As Boolean
  End Function
  <DllImport("user32.dll")> _
  Public Shared Function ReleaseDC(hWnd As IntPtr, hDC As IntPtr) As Integer
  End Function
  <DllImport("user32.dll")> _
  Public Shared Function IsWindowVisible(hWnd As IntPtr) As Boolean
  End Function
  Public Declare Auto Function UpdateLayeredWindow Lib "user32.dll" (hwnd As IntPtr, hdcDst As IntPtr, ByRef pptDst As Point, ByRef psize As Size, hdcSrc As IntPtr, ByRef pprSrc As Point, crKey As Int32, ByRef pblend As BLENDFUNCTION, dwFlags As BlendFlags) As Boolean
  <DllImport("user32.dll")> _
  Public Shared Function GetWindowDC(hWnd As IntPtr) As IntPtr
  End Function
End Class
