﻿Public Class frmWhisper
  Private Delegate Sub SetTabValueCallback([Page] As TabPage, [Alert] As Boolean)

  Private Sub SetTabValue([Page] As TabPage, [Alert] As Boolean)
    If Me.tbsWhisper.InvokeRequired Then
      Dim d As New SetTabValueCallback(AddressOf SetTabValue)
      Me.BeginInvoke(d, New Object() {[Page], [Alert]})
    Else
      If Alert Then
        If Not tbsWhisper.SelectedTab Is Page Then If Not Page.Text.StartsWith("[*] ") Then Page.Text = "[*] " & Page.Text
        If Not Me.Focused Then
          Dim fl As New NativeMethods.FLASHWINFO
          fl.cbSize = System.Runtime.InteropServices.Marshal.SizeOf(fl)
          fl.hwnd = Me.Handle
          fl.dwFlags = NativeMethods.FLASHW_ALL
          fl.uCount = 2
          fl.dwTimeout = 500
          NativeMethods.FlashWindowEx(fl)
        End If
      Else
        If Page.Text.StartsWith("[*] ") Then Page.Text = Page.Text.Substring(4)
      End If
    End If
  End Sub

  Public Sub AddWhisper(ByRef UI As BNUI, WhisTo As String)
    Dim NewTab As New TabPage
    Dim NewUI As New WhisWin
    NewTab.Tag = {UI, NewUI}
    NewUI.Tag = WhisTo
    tbsWhisper.TabPages.Add(NewTab)
    NewTab.Controls.Add(NewUI)
    NewUI.Dock = DockStyle.Fill
    NewTab.Text = WhisTo & " (" & GetGatewayName(UI.Config.Server, UI.Config.Account.Client.Product = BNUI.GameType.WAR3 Or UI.Config.Account.Client.Product = BNUI.GameType.W3XP) & ")" ' Replace(UI.Config.Server, ".Battle.net", String.Empty, 1, -1, CompareMethod.Text) & ")"
    NewTab.ToolTipText = "From: " & UI.Config.Account.Username & vbNewLine &
                         "To: " & WhisTo & vbNewLine &
                         "Server: " & UI.Config.Server
    NewTab.BackColor = Color.Black
    tbsWhisper.SelectedTab = NewTab
  End Sub

  Public Sub RemoveWhisper(ProfileID As Integer)
    If tbsWhisper.TabCount > ProfileID Then
      Dim Profile As WhisWin = tbsWhisper.TabPages(ProfileID).Tag(1)
      tbsWhisper.TabPages(ProfileID).Controls.Remove(Profile)
      tbsWhisper.TabPages.Remove(tbsWhisper.TabPages(ProfileID))
      If tbsWhisper.TabCount = 0 Then tbsWhisper.Visible = False
    End If
  End Sub

  Private Sub tbsWhisper_MouseUp(sender As Object, e As System.Windows.Forms.MouseEventArgs) Handles tbsWhisper.MouseUp
    If tbsWhisper.TabCount > 0 Then
      Dim lLen As Long = 1
      For I As Integer = 0 To tbsWhisper.TabCount - 1
        If tbsWhisper.GetTabRect(I).Contains(e.Location) Then
          SetTabValue(tbsWhisper.TabPages(I), False)
          tbsWhisper.Tag = I
          Exit For
        End If
      Next
      If e.Button = Windows.Forms.MouseButtons.Middle Then
        RemoveWhisper(tbsWhisper.Tag)
      ElseIf e.Button = Windows.Forms.MouseButtons.Right Then
        'Show Menu?
      End If
    End If
  End Sub

  Public Function WhisperFrom(Account As String, Message As String, ByRef sender As BNUI) As Boolean
    For Each TabUI As TabPage In tbsWhisper.TabPages
      Dim UI As WhisWin = TabUI.Tag(1)
      If StrComp(UI.Tag, Account, CompareMethod.Text) = 0 Then
        If Not Me.Visible Then Me.Show()
        SetTabValue(TabUI, True)
        UI.gWhisper.AddChat(GeckoChat.ChatType.UserChat, "From: " & Account, Message)
        Return True
      End If
    Next
    If sender.Config.Display.WhisWin = 2 Then
      AddWhisper(sender, Account)
      For Each TabUI As TabPage In tbsWhisper.TabPages
        Dim UI As WhisWin = TabUI.Tag(1)
        If StrComp(UI.Tag, Account, CompareMethod.Text) = 0 Then
          If Not Me.Visible Then Me.Show()
          SetTabValue(TabUI, True)
          UI.gWhisper.AddChat(GeckoChat.ChatType.UserChat, "From: " & Account, Message)
          Return True
        End If
      Next
    End If
    Return False
  End Function

  Public Function WhisperTo(Account As String, Message As String, ByRef sender As BNUI) As Boolean
    For Each TabUI As TabPage In tbsWhisper.TabPages
      Dim UI As WhisWin = TabUI.Tag(1)
      If StrComp(UI.Tag, Account, CompareMethod.Text) = 0 Then
        If Not Me.Visible Then Me.Show()
        UI.gWhisper.AddChat(GeckoChat.ChatType.SelfChat, "To: " & Account, Message)
        Return True
      End If
    Next
    If sender.Config.Display.WhisWin = 2 Then
      AddWhisper(sender, Account)
      For Each TabUI As TabPage In tbsWhisper.TabPages
        Dim UI As WhisWin = TabUI.Tag(1)
        If StrComp(UI.Tag, Account, CompareMethod.Text) = 0 Then
          If Not Me.Visible Then Me.Show()
          UI.gWhisper.AddChat(GeckoChat.ChatType.SelfChat, "To: " & Account, Message)
          Return True
        End If
      Next
    End If
    Return False
  End Function

  Private Sub frmWhisper_Load(sender As Object, e As System.EventArgs) Handles Me.Load
    Me.Size = My.Settings.Whisper_Size
    Me.Location = My.Settings.Whisper_Location
    If Me.Location.X > My.Computer.Screen.WorkingArea.Width Or Me.Location.X < 0 Then Me.Location = New Point(0, Me.Location.Y)
    If Me.Location.Y > My.Computer.Screen.WorkingArea.Height Or Me.Location.Y < 0 Then Me.Location = New Point(Me.Location.X, 0)
  End Sub

  Private Sub frmWhisper_ResizeEnd(sender As Object, e As System.EventArgs) Handles Me.ResizeEnd
    My.Settings.Whisper_Size = Me.Size
    My.Settings.Whisper_Location = Me.Location
  End Sub

End Class