﻿Public Class frmW3IconSelection
  Public CurrentIcon As String
  Private bEXP As Boolean
  Private ResMan As New Resources.ResourceManager("Entelechy.frmW3IconSelection", Reflection.[Assembly].GetExecutingAssembly)

  Private Sub frmW3IconSelection_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
    pctIcon.Image = pctIcon.InitialImage
    lblInfo.Text = ResMan.GetString("INFO_NONE")
    bEXP = CType(Me.Tag, BNUI).Config.Account.Client.Product = BNUI.GameType.W3XP
    PopulateCombo()
    For I As Integer = 0 To cmbIcons.Items.Count - 1
      If CType(cmbIcons.Items(I), BNUI.W3IconList).Name = CurrentIcon Then
        cmbIcons.SelectedIndex = I
        Exit For
      End If
    Next
  End Sub

  Private Sub PopulateCombo()
    cmbIcons.Items.Clear()
    cmbIcons.bEXP = bEXP
    If CType(Me.Tag, BNUI).W3Icons IsNot Nothing Then
      Dim W3Icons() As BNUI.W3IconList = CType(Me.Tag, BNUI).W3Icons
      For Each Icon As BNUI.W3IconList In W3Icons
        cmbIcons.Items.Add(Icon)
      Next
    Else
      MsgBox(ResMan.GetString("ERR_NOLIST"), MsgBoxStyle.Critical)
      Me.Close()
    End If
  End Sub

  Private Sub cmbIcons_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles cmbIcons.SelectedIndexChanged
    If cmbIcons.SelectedIndex > -1 Then
      pctIcon.Image = pctIcon.InitialImage
      Dim Icon As BNUI.W3IconList = CType(cmbIcons.SelectedItem, BNUI.W3IconList)
      If String.IsNullOrEmpty(Icon.Icon) Then
        pctIcon.Image = pctIcon.ErrorImage
        lblInfo.Text = ResMan.GetString("ERR_NOICON")
      Else
        lblInfo.Text = ResString(ResMan.GetString("INFO_ICON"), GetW3IcoName(bEXP, Icon.Icon), Icon.Wins) & IIf(Icon.Enabled = 1, String.Empty, vbNewLine & ResMan.GetString("INFO_ICON_NOTMET"))
        If My.Computer.FileSystem.FileExists(AppTemp & "\icons\WAR3\Portrait\" & IIf(bEXP, "W3XP", "WAR3") & "_" & Icon.Icon & ".gif") Then
          pctIcon.Tag = Nothing
          pctIcon.Image = Image.FromFile(AppTemp & "\icons\WAR3\Portrait\" & IIf(bEXP, "W3XP", "WAR3") & "_" & Icon.Icon & ".gif").Clone
        Else
          pctIcon.Tag = Icon.Icon
          cmbIcons.Enabled = False
          pctIcon.LoadAsync("http://classic.battle.net/war3/ladder/portraits/animated/" & IIf(bEXP, "W3XP", "WAR3") & "/" & Icon.Icon & ".gif")
        End If
        cmdSet.Enabled = Icon.Enabled = 1
      End If
    Else
      pctIcon.Tag = Nothing
      pctIcon.Image = pctIcon.InitialImage
      lblInfo.Text = ResMan.GetString("INFO_DEFAULT")
      cmdSet.Enabled = True
    End If
  End Sub

  Private Sub cmdClose_Click(sender As System.Object, e As System.EventArgs) Handles cmdClose.Click
    pctIcon.CancelAsync()
  End Sub

  Private Sub cmdSet_Click(sender As Object, e As System.EventArgs) Handles cmdSet.Click
    pctIcon.CancelAsync()
    If cmbIcons.SelectedIndex > -1 Then
      CurrentIcon = CType(cmbIcons.SelectedItem, BNUI.W3IconList).Icon
    Else
      CurrentIcon = Nothing
    End If
  End Sub

  Private Sub pctIcon_LoadCompleted(sender As Object, e As System.ComponentModel.AsyncCompletedEventArgs) Handles pctIcon.LoadCompleted
    If cmbIcons.Enabled = False Then
      cmbIcons.Enabled = True
      cmbIcons.Focus()
    End If
    If e.Error Is Nothing Then
      If pctIcon.Tag IsNot Nothing Then
        If Not My.Computer.FileSystem.DirectoryExists(AppTemp & "\icons\WAR3\Portrait") Then My.Computer.FileSystem.CreateDirectory(AppTemp & "\icons\WAR3\Portrait")
        pctIcon.Image.Save(AppTemp & "\icons\WAR3\Portrait\" & IIf(bEXP, "W3XP", "WAR3") & "_" & pctIcon.Tag & ".gif")
      End If
    Else
      pctIcon.Image = pctIcon.ErrorImage
    End If
  End Sub

  Private Sub cmdDefault_Click(sender As System.Object, e As System.EventArgs) Handles cmdDefault.Click
    cmbIcons.SelectedIndex = -1
  End Sub
End Class

Public Class ImageComboBox
  Inherits ComboBox
  Public bEXP As Boolean
  Public Sub New()
    DrawMode = Windows.Forms.DrawMode.OwnerDrawFixed
    MyBase.ItemHeight = 18
  End Sub
  Protected Overrides Sub OnDrawItem(e As System.Windows.Forms.DrawItemEventArgs)
    e.DrawBackground()
    e.DrawFocusRectangle()
    If e.Index > -1 Then
      Dim Item As BNUI.W3IconList = CType(Me.Items(e.Index), BNUI.W3IconList)
      Dim itmName As String = GetW3IcoName(bEXP, Item.Icon)
      Dim itmImage As Image = GetW3IcoIcon(bEXP, Item.Icon)
      If String.IsNullOrEmpty(itmName) Then Exit Sub
      Dim imageX As Integer = e.Bounds.X + 2
      Dim imageY As Integer = e.Bounds.Top + ((e.Bounds.Height - itmImage.Height) / 2)
      e.Graphics.DrawImage(itmImage, imageX, imageY)
      e.Graphics.DrawString(itmName, Me.Font, IIf(Item.Enabled = 1, New SolidBrush(Me.ForeColor), New SolidBrush(Color.Gray)), New Point(imageX + itmImage.Width - 3, e.Bounds.Top + 2))
    End If
    MyBase.OnDrawItem(e)
  End Sub
End Class
