﻿Public Class frmStatString
  Public Sub New(Statstring As String)
    InitializeComponent()
    txtStatstring.Text = Statstring
  End Sub

  Private Sub cmbClass_Changed(sender As System.Object, e As System.EventArgs) Handles cmbClass.SelectedIndexChanged, cmbClass.TextChanged
    If cmbClass.SelectedIndex >= 0 And cmbClass.SelectedIndex < 3 Then
      pctCharacter.Image = imlDRTLChars.Images(cmbClass.SelectedIndex)
    Else
      pctCharacter.Image = imlDRTLChars.Images(3)
    End If
    BuildStatString()
  End Sub

  Private Sub cmdOK_Click(sender As System.Object, e As System.EventArgs) Handles cmdOK.Click
    Me.DialogResult = Windows.Forms.DialogResult.OK
    Me.Close()
  End Sub

  Private Sub cmdCancel_Click(sender As System.Object, e As System.EventArgs) Handles cmdCancel.Click
    Me.DialogResult = Windows.Forms.DialogResult.Cancel
    Me.Close()
  End Sub

  Private Sub txtTextbox_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtLevel.TextChanged, txtDots.TextChanged, txtStrength.TextChanged, txtMagic.TextChanged, txtDexterity.TextChanged, txtVitality.TextChanged, txtGold.TextChanged
    BuildStatString()
  End Sub

  Private Sub BuildStatString()
    If String.IsNullOrEmpty(txtStatstring.Tag) Then
      txtStatstring.Tag = "BUILDING"
      txtStatstring.Text = "LTRD " & txtLevel.Text & " " & IIf(cmbClass.SelectedIndex > -1, cmbClass.SelectedIndex, cmbClass.Text) & " " & txtDots.Text & " " & txtStrength.Text & " " & txtMagic.Text & " " & txtDexterity.Text & " " & txtVitality.Text & " " & txtGold.Text & " 0"
      txtStatstring.Tag = Nothing
    End If
  End Sub

  Private Sub txtStatstring_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtStatstring.TextChanged
    If String.IsNullOrEmpty(txtStatstring.Tag) AndAlso txtStatstring.Text.Contains(" ") Then
      txtStatstring.Tag = "STATING"
      Dim sSplit() As String = txtStatstring.Text.Split(" "c)
      If sSplit.Length = 10 Then
        txtLevel.Text = sSplit(1)
        If IsNumeric(sSplit(2)) Then
          If sSplit(2) = "0" Or sSplit(2) = "1" Or sSplit(2) = "2" Then
            cmbClass.SelectedIndex = sSplit(2)
          Else
            cmbClass.Text = sSplit(2)
          End If
        Else
          cmbClass.Text = sSplit(2)
        End If
        txtDots.Text = sSplit(3)
        txtStrength.Text = sSplit(4)
        txtMagic.Text = sSplit(5)
        txtDexterity.Text = sSplit(6)
        txtVitality.Text = sSplit(7)
        txtGold.Text = sSplit(8)
      End If
      txtStatstring.Tag = Nothing
    End If
  End Sub
End Class