﻿Imports Microsoft.WindowsAPICodePack.Taskbar
Imports System.Runtime.InteropServices
Imports System.ComponentModel
Imports System.Windows.Forms.VisualStyles

Public NotInheritable Class frmSplash
  Inherits AlphaForm

  Private Delegate Sub SetOpacityCallback([Opacity] As Double)
  Private Delegate Sub SetStatusCallback([Status] As String)

  Private Sub SetOpacity2([Opacity] As Double)
    If Me.InvokeRequired Then
      Me.Invoke(New SetOpacityCallback(AddressOf SetOpacity2), New Object() {[Opacity]})
    Else
      Me.Opacity = Opacity
    End If
  End Sub

  Public Sub SetStatus([Status] As String)
    If Me.InvokeRequired Then
      Me.BeginInvoke(New SetStatusCallback(AddressOf SetStatus), New Object() {[Status]})
    Else
      If Status = "OFF" Then
        Me.Close()
      Else
        pbLoader.Tag += 1
        SetProgress(pbLoader.Tag, 7)
        If TaskbarManager.IsPlatformSupported Then
          TaskbarManager.Instance.SetProgressState(TaskbarProgressBarState.Normal)
          TaskbarManager.Instance.SetProgressValue(pbLoader.Tag, 7)
        End If
        lblStatus.Text = Status
      End If
    End If
  End Sub

  Private Sub SetProgress(Value As Integer, Max As Integer)
    Dim bmpTmp As New Bitmap(pbLoader.Width, pbLoader.Height)
    Using g As Graphics = Graphics.FromImage(bmpTmp)
      g.Clear(Color.Transparent)
      Dim tmpBrush As New Drawing2D.LinearGradientBrush(New Point(0, 0), New Point(0, pbLoader.Height), Color.DarkBlue, Color.Transparent)
      g.FillRectangle(tmpBrush, 0, 0, CInt(pbLoader.Width * (Value / Max)), pbLoader.Height)
    End Using
    pbLoader.Image = bmpTmp
  End Sub

  Private Sub frmSplash_FormClosing(sender As Object, e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
    If My.Computer.FileSystem.FileExists(AppData & "\Settings.bak") Then
      If My.Computer.FileSystem.FileExists(AppData & "\Settings.xml") Then
        My.Computer.FileSystem.RenameFile(AppData & "\Settings.xml", AppData & "\Settings.old")
        My.Computer.FileSystem.RenameFile(AppData & "\Settings.bak", AppData & "\Settings.xml")
      Else
        My.Computer.FileSystem.RenameFile(AppData & "\Settings.bak", AppData & "\Settings.xml")
      End If
    End If
    End
  End Sub

  Private Sub frmSplash_Load(sender As Object, e As System.EventArgs) Handles Me.Load
    If My.Settings.Splash Then
      'DrawControlBackgrounds = True
      'DrawControlBackground(pctAppTitle, True)
      UpdateLayeredBackground()
      lblVer.Text = Version
      'Me.AllowTransparency = True
      'SetOpacity2(0)

      'Dim fadeThread As New Threading.Thread(AddressOf FadeIn)
      'fadeThread.Start()

    Else
      'SetOpacity2(0)
      SetOpacity2(0)
    End If
  End Sub

  Public Sub HideMe()
    'Me.AllowTransparency = True
    'SetOpacity2(1)
    SetOpacity2(0)
    'FadeOut()
  End Sub

  'Private Sub FadeIn()
  '  Dim I As Double = 0
  '  Do
  '    I += 0.05
  '    Threading.Thread.Sleep(10)
  '    SetOpacity2(I)
  '  Loop While I < 1
  'End Sub

  'Private Sub FadeOut()
  '  Dim I As Double = 1
  '  Do
  '    I -= 0.05
  '    Threading.Thread.Sleep(10)
  '    SetOpacity2(I)
  '  Loop While I > 0
  'End Sub

  Private Sub cmdClose_Click(sender As System.Object, e As System.EventArgs) Handles cmdClose.Click
    Me.Close()
  End Sub

End Class
