﻿Public Class frmSettings

  Private Sub cmdCancel_Click(sender As System.Object, e As System.EventArgs) Handles cmdCancel.Click
    Me.Close()
  End Sub

  Private Sub cmdApply_Click(sender As System.Object, e As System.EventArgs) Handles cmdApply.Click
    My.Settings.StartupUpdates = chkUpdates.Checked
    If Not My.Settings.TaskbarThumbs = chkTaskbarThumbnails.Checked Then
      My.Settings.TaskbarThumbs = chkTaskbarThumbnails.Checked
      frmMain.RefreshPreviews()
    End If
    My.Settings.Splash = chkSplash.Checked
    My.Settings.TrayIcon = chkTray.Checked
    My.Settings.AlwaysAppData = chkAppData.Checked
    My.Settings.MinToTray = chkTrayMin.Checked
    My.Settings.MouseTabSwitch = chk5ButtonMouse.Checked
    Select Case cmbPlayer.SelectedIndex
      Case 0 : My.Settings.MediaPlayer = "LimeLight"
      Case 1 : My.Settings.MediaPlayer = "Winamp"
      Case 2 : My.Settings.MediaPlayer = "WMP"
      Case 3 : My.Settings.MediaPlayer = "iTunes"
      Case Else : My.Settings.MediaPlayer = "LimeLight"
    End Select
    My.Settings.PlayerPath = txtPath.Text
    frmMain.tmrMouse.Enabled = My.Settings.MouseTabSwitch
    frmMain.trayIcon.Visible = My.Settings.TrayIcon
    My.Settings.Save()
    MPControls = New clsMediaControls
  End Sub

  Private Sub cmdOK_Click(sender As System.Object, e As System.EventArgs) Handles cmdOK.Click
    cmdApply.PerformClick()
    cmdCancel.PerformClick()
  End Sub

  Private Sub frmSettings_Load(sender As Object, e As System.EventArgs) Handles Me.Load
    chkUpdates.Checked = My.Settings.StartupUpdates
    chkTaskbarThumbnails.Checked = My.Settings.TaskbarThumbs
    chkSplash.Checked = My.Settings.Splash
    chkTray.Checked = My.Settings.TrayIcon
    chkAppData.Checked = My.Settings.AlwaysAppData
    chkTrayMin.Checked = My.Settings.MinToTray
    chk5ButtonMouse.Checked = My.Settings.MouseTabSwitch
    Select Case My.Settings.MediaPlayer
      Case "LimeLight" : cmbPlayer.SelectedIndex = 0
      Case "Winamp" : cmbPlayer.SelectedIndex = 1
      Case "WMP" : cmbPlayer.SelectedIndex = 2
      Case "iTunes" : cmbPlayer.SelectedIndex = 3
    End Select
    txtPath.Text = My.Settings.PlayerPath
    Me.Top = frmMain.Top + (frmMain.Height / 2) - (Me.Height / 2)
    If Me.Top < 0 Then Me.Top = 0
    Me.Left = frmMain.Left + (frmMain.Width / 2) - (Me.Width / 2)
    If Me.Left < 0 Then Me.Left = 0
  End Sub

  Private Sub cmbPlayer_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles cmbPlayer.SelectedIndexChanged
    Select Case cmbPlayer.SelectedIndex
      Case 0 : txtPath.Text = My.Computer.FileSystem.SpecialDirectories.ProgramFiles & "\RealityRipple Software\Lime Light Media Player\LLMP.exe"
      Case 1 : txtPath.Text = My.Computer.FileSystem.SpecialDirectories.ProgramFiles & "\Winamp\Winamp.exe"
      Case 2 : txtPath.Text = My.Computer.FileSystem.SpecialDirectories.ProgramFiles & "\Windows Media Player\wmplayer.exe"
      Case 3 : txtPath.Text = My.Computer.FileSystem.SpecialDirectories.ProgramFiles & "\iTunes\iTunes.exe"
    End Select
  End Sub

  Private Sub cmdPath_Click(sender As System.Object, e As System.EventArgs) Handles cmdPath.Click
    Dim cdlBrowse As New Windows.Forms.OpenFileDialog
    cdlBrowse.CheckFileExists = True
    cdlBrowse.DefaultExt = ".exe"
    cdlBrowse.FileName = txtPath.Text
    cdlBrowse.Filter = "Applications|*.exe|All Files|*.*"
    cdlBrowse.InitialDirectory = IO.Path.GetDirectoryName(txtPath.Text)
    cdlBrowse.Multiselect = False
    cdlBrowse.ShowHelp = False
    cdlBrowse.ShowReadOnly = False
    cdlBrowse.Title = "Select " & cmbPlayer.Text & " path..."
    cdlBrowse.ValidateNames = True
    cdlBrowse.ShowDialog(Me)
    If Not String.IsNullOrEmpty(cdlBrowse.FileName) Then txtPath.Text = cdlBrowse.FileName
  End Sub
End Class