﻿Public Class frmProfile
  Public Enum UpdateTypes
    Account
    STAR
    SEXP
    JSTR
    SSHR
    W2BN
    FIND
    WAR3Stats
    WAR3ClanStats
    WAR3ClanInfo
  End Enum
  Private Delegate Sub UpdateTabCallback([Account] As String, UpdateType As UpdateTypes, [InfoStrings] As String())
  Private Delegate Sub UpdateTabPacketCallback([Account] As String, UpdateType As UpdateTypes, [InfoPacket] As BNCSReader)

  Public Sub UpdateTab(Account As String, UpdateType As UpdateTypes, InfoStrings() As String)
    If Me.InvokeRequired Then
      Dim d As New UpdateTabCallback(AddressOf UpdateTab)
      Me.Invoke(d, New Object() {[Account], [UpdateType], [InfoStrings]})
    Else
      Dim tmpProfile As BNProfile = (From tmpTab As TabPage In tbsProfiles.TabPages Where tmpTab.Text = Account Select tmpTab.Tag).FirstOrDefault
      If tmpProfile Is Nothing Then
        If UpdateType = UpdateTypes.Account Then
          tbsProfiles.Visible = True
          Dim NewProfile As New BNProfile
          Dim NewTab As New TabPage
          NewProfile.Tag = NewTab
          NewTab.Tag = NewProfile
          tbsProfiles.TabPages.Add(NewTab)
          NewTab.Controls.Add(NewProfile)
          NewProfile.Dock = DockStyle.Fill
          Dim UI As BNUI = Me.Tag
          NewTab.Text = Account
          NewProfile.LoadProfileInfo(Not (Account = UI.Config.Account.Username), InfoStrings)
          NewTab.BackColor = Color.Black
          NewTab.ForeColor = Color.White
          tbsProfiles.SelectedIndex = tbsProfiles.TabCount - 1
          cmdWrite.Enabled = (Account = UI.Config.Account.Username)
        End If
      Else
        Dim UI As BNUI = Me.Tag
        Select Case UpdateType
          Case UpdateTypes.Account
            tmpProfile.LoadProfileInfo(Not (Account = UI.Config.Account.Username), InfoStrings)
          Case UpdateTypes.FIND
            If Not String.IsNullOrEmpty(InfoStrings(0)) Then tmpProfile.RecordProds.Add(BNUI.GameType.STAR)
            If Not String.IsNullOrEmpty(InfoStrings(1)) Then tmpProfile.RecordProds.Add(BNUI.GameType.SEXP)
            If Not String.IsNullOrEmpty(InfoStrings(2)) Then tmpProfile.RecordProds.Add(BNUI.GameType.JSTR)
            If Not String.IsNullOrEmpty(InfoStrings(3)) Then tmpProfile.RecordProds.Add(BNUI.GameType.SSHR)
            If Not String.IsNullOrEmpty(InfoStrings(4)) Then tmpProfile.RecordProds.Add(BNUI.GameType.W2BN)
          Case UpdateTypes.STAR
            tmpProfile.LoadSTARInfo(Not (Account = UI.Config.Account.Username), InfoStrings)
          Case UpdateTypes.SEXP
            tmpProfile.LoadSEXPInfo(Not (Account = UI.Config.Account.Username), InfoStrings)
          Case UpdateTypes.JSTR
            tmpProfile.LoadJSTRInfo(Not (Account = UI.Config.Account.Username), InfoStrings)
          Case UpdateTypes.SSHR
            tmpProfile.LoadSSHRInfo(Not (Account = UI.Config.Account.Username), InfoStrings)
          Case UpdateTypes.W2BN
            tmpProfile.LoadW2BNInfo(Not (Account = UI.Config.Account.Username), InfoStrings)
        End Select
      End If
    End If
  End Sub

  Public Function CheckTab(Account As String, Product As BNUI.GameType) As Byte
    '0 = not part of
    '1 = needed
    '2 = listed
    '3 = unknown
    Dim tmpProfile As BNProfile = (From tmpTab As TabPage In tbsProfiles.TabPages Where tmpTab.Text = Account Select tmpTab.Tag).FirstOrDefault
    If tmpProfile Is Nothing Then Return 3
    If tmpProfile.RecordProds.Contains(Product) Then
      Select Case Product
        Case BNUI.GameType.STAR
          If tmpProfile.tbsRecord.TabPages.Contains(tmpProfile.tabSTAR) Then
            Return 2
          Else
            Return 1
          End If
        Case BNUI.GameType.SEXP
          If tmpProfile.tbsRecord.TabPages.Contains(tmpProfile.tabSEXP) Then
            Return 2
          Else
            Return 1
          End If
        Case BNUI.GameType.JSTR
          If tmpProfile.tbsRecord.TabPages.Contains(tmpProfile.tabJSTR) Then
            Return 2
          Else
            Return 1
          End If
        Case BNUI.GameType.SSHR
          If tmpProfile.tbsRecord.TabPages.Contains(tmpProfile.tabSSHR) Then
            Return 2
          Else
            Return 1
          End If
        Case BNUI.GameType.W2BN
          If tmpProfile.tbsRecord.TabPages.Contains(tmpProfile.tabW2BN) Or tmpProfile.tbsRecord.TabPages.Contains(tmpProfile.tabW2BNIRON) Then
            Return 2
          Else
            Return 1
          End If
        Case Else
          Return 3
      End Select
    Else
      If tmpProfile.RecordProds.Count = 0 Then
        Return 3
      Else
        Return 0
      End If
    End If
  End Function

  Public Sub UpdateW3Tab(Account As String, UpdateType As UpdateTypes, InfoStrings() As String)
    If Me.InvokeRequired Then
      Dim d As New UpdateTabCallback(AddressOf UpdateW3Tab)
      Me.BeginInvoke(d, New Object() {[Account], [UpdateType], [InfoStrings]})
    Else
      Dim tmpProfile As W3Profile = (From tmpTab As TabPage In tbsProfiles.TabPages Where tmpTab.Text = Account Select tmpTab.Tag).FirstOrDefault
      If tmpProfile Is Nothing Then
        If UpdateType = UpdateTypes.Account Then
          tbsProfiles.Visible = True
          Dim NewProfile As New W3Profile
          Dim NewTab As New TabPage
          NewProfile.Tag = NewTab
          NewTab.Tag = NewProfile
          tbsProfiles.TabPages.Add(NewTab)
          NewTab.Controls.Add(NewProfile)
          NewProfile.Dock = DockStyle.Fill
          Dim UI As BNUI = Me.Tag
          NewTab.Text = Account
          NewProfile.LoadProfileInfo(Not (Account = UI.Config.Account.Username), InfoStrings)
          NewTab.BackColor = Color.Black
          NewTab.ForeColor = Color.White
          tbsProfiles.SelectedIndex = tbsProfiles.TabCount - 1
          cmdWrite.Enabled = (Account = UI.Config.Account.Username)
        End If
      Else
        Dim UI As BNUI = Me.Tag
        Select Case UpdateType
          Case UpdateTypes.Account
            tmpProfile.LoadProfileInfo(Not (Account = UI.Config.Account.Username), InfoStrings)
          Case UpdateTypes.WAR3ClanInfo
            tmpProfile.LoadClanInfo(InfoStrings)
        End Select
      End If
    End If
  End Sub


  Public Sub UpdateW3Tab(Account As String, UpdateType As UpdateTypes, InfoPacket As BNCSReader)
    If Me.InvokeRequired Then
      Dim d As New UpdateTabPacketCallback(AddressOf UpdateW3Tab)
      Me.BeginInvoke(d, New Object() {[Account], [UpdateType], [InfoPacket]})
    Else
      Dim tmpProfile As W3Profile = (From tmpTab As TabPage In tbsProfiles.TabPages Where tmpTab.Text = Account Select tmpTab.Tag).FirstOrDefault
      If tmpProfile IsNot Nothing Then
        Dim UI As BNUI = Me.Tag
        Select Case UpdateType
          Case UpdateTypes.WAR3Stats, UpdateTypes.WAR3ClanStats
            tmpProfile.LoadWAR3Info(InfoPacket)
          Case Else
            'Nothing
        End Select
      End If
    End If
  End Sub

  Public Sub RemoveTab(ProfileID As Integer)
    If tbsProfiles.TabCount > ProfileID Then
      If ReferenceEquals(tbsProfiles.TabPages(ProfileID).Tag.GetType, GetType(BNProfile)) Then
        Dim Profile As BNProfile = tbsProfiles.TabPages(ProfileID).Tag
        tbsProfiles.TabPages(ProfileID).Controls.Remove(Profile)
        tbsProfiles.TabPages.Remove(tbsProfiles.TabPages(ProfileID))
        If tbsProfiles.TabCount = 0 Then tbsProfiles.Visible = False
      Else
        Dim Profile As W3Profile = tbsProfiles.TabPages(ProfileID).Tag
        tbsProfiles.TabPages(ProfileID).Controls.Remove(Profile)
        tbsProfiles.TabPages.Remove(tbsProfiles.TabPages(ProfileID))
        If tbsProfiles.TabCount = 0 Then tbsProfiles.Visible = False
      End If
    End If
  End Sub

  Private Sub cmdGet_Click(sender As System.Object, e As System.EventArgs) Handles cmdGet.Click
    Dim UI As BNUI = Me.Tag
    If (UI.Config.Account.Client.Product = BNUI.GameType.WAR3 Or UI.Config.Account.Client.Product = BNUI.GameType.W3XP) AndAlso Not txtAccount.Text.ToLower.Contains("@" & GetGatewayName(UI.Config.Server, False).ToLower.Replace("."c, "").Replace(" "c, "")) Then
      UI.GetUserData(txtAccount.Text, BNUI.ProfileRequests.ProfileRequestType.UserProfile, BNUI.ProfileRequests.ProfileRequestDisplay.PrivateUI, UI.Config.Account.Client.Product.ToString)
    Else
      UI.GetUserData(txtAccount.Text, BNUI.ProfileRequests.ProfileRequestType.UserProfile, BNUI.ProfileRequests.ProfileRequestDisplay.PrivateUI)
    End If
  End Sub

  Private Sub cmdClose_Click(sender As System.Object, e As System.EventArgs) Handles cmdClose.Click
    txtAccount.Text = String.Empty
    For I As Integer = tbsProfiles.TabCount - 1 To 0 Step -1
      RemoveTab(I)
    Next
    Me.Hide()
  End Sub

  Private Sub txtAccount_KeyPress(sender As Object, e As System.Windows.Forms.KeyPressEventArgs) Handles txtAccount.KeyPress
    If e.KeyChar = Chr(13) Then
      e.Handled = True
      cmdGet.PerformClick()
    End If
  End Sub

  Private Sub cmdWrite_Click(sender As System.Object, e As System.EventArgs) Handles cmdWrite.Click
    Dim UI As BNUI = Me.Tag
    If ReferenceEquals(tbsProfiles.SelectedTab.Tag.GetType, GetType(BNProfile)) Then
      Dim Profile As BNProfile = tbsProfiles.SelectedTab.Tag
      UI.BNCS_WRITEUSERDATA_Send(txtAccount.Text, {"profile\sex", "profile\age", "profile\location", "profile\description"}, {CleanLines(Profile.sSex), CleanLines(Profile.sAge), CleanLines(Profile.sLocation), CleanLines(Profile.sDescription)})
    Else
      Dim Profile As W3Profile = tbsProfiles.SelectedTab.Tag
      UI.BNCS_WRITEUSERDATA_Send(txtAccount.Text, {"profile\location", "profile\description"}, {CleanLines(Profile.sHomepage), CleanLines(Profile.sAdditionalInformation)})
    End If
    UI.gChat.AddChat(GeckoChat.ChatType.ServiceSuccess, My.Resources.PROTOCOL_BNCS, My.Resources.PROFILE_SAVED)
  End Sub

  Private Sub frmProfile_FormClosing(sender As Object, e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
    If e.CloseReason = CloseReason.UserClosing Then
      e.Cancel = True
      cmdClose.PerformClick()
    End If
  End Sub

  Private Sub tbsProfiles_MouseUp(sender As Object, e As System.Windows.Forms.MouseEventArgs) Handles tbsProfiles.MouseUp
    If tbsProfiles.TabCount > 0 Then
      Dim lLen As Long = 1
      For I As Integer = 0 To tbsProfiles.TabCount - 1
        If tbsProfiles.GetTabRect(I).Contains(e.Location) Then
          tbsProfiles.Tag = I
          Exit For
        End If
      Next
      If e.Button = Windows.Forms.MouseButtons.Middle Then
        RemoveTab(tbsProfiles.Tag)
      ElseIf e.Button = Windows.Forms.MouseButtons.Right Then
        'Show Menu?
      End If
    End If
  End Sub

  Private Sub tbsProfiles_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles tbsProfiles.SelectedIndexChanged
    If tbsProfiles.TabCount > 0 Then
      Dim UI As BNUI = Me.Tag
      cmdWrite.Enabled = (tbsProfiles.SelectedTab.Text = UI.Config.Account.Username)
    End If
  End Sub

  Private Sub frmProfile_Load(sender As Object, e As System.EventArgs) Handles Me.Load
    Me.Size = My.Settings.Profile_Size
    Me.Location = My.Settings.Profile_Location
    If Me.Location.X > My.Computer.Screen.WorkingArea.Width Or Me.Location.X < 0 Then Me.Location = New Point(0, Me.Location.Y)
    If Me.Location.Y > My.Computer.Screen.WorkingArea.Height Or Me.Location.Y < 0 Then Me.Location = New Point(Me.Location.X, 0)
  End Sub

  Private Sub frmProfile_ResizeEnd(sender As Object, e As System.EventArgs) Handles Me.ResizeEnd
    My.Settings.Profile_Size = Me.Size
    My.Settings.Profile_Location = Me.Location
  End Sub

  Private Function CleanLines(sLines As String) As String
    Do Until InStr(sLines, vbLf) = 0
      sLines = sLines.Replace(vbCr & vbLf, vbCr)
      sLines = sLines.Replace(vbLf, vbCr)
    Loop
    Return sLines.Replace(vbCr, vbCrLf)
  End Function
End Class