﻿Imports Microsoft.WindowsAPICodePack.Taskbar
Imports System.Xml.Linq
Imports Microsoft.WindowsAPICodePack.Shell

Public Class frmMain
  Private cfgProfiles() As BNUI.cConfig
  Public selProfile As Integer
  Private bThumbs As Boolean
  Private Delegate Sub SelectTabCallBack([Tab] As TabPage)
  Private WithEvents ttbConnect As New ThumbnailToolBarButton(My.Resources.connect, "Connect")
  Private WithEvents ttbDisconnect As New ThumbnailToolBarButton(My.Resources.disconnect, "Disconnect")
  Private ResMan As Resources.ResourceManager
  Private bBottoms() As Boolean

  Private Sub SelectTab([Tab] As TabPage)
    If Me.InvokeRequired Then
      Dim d As New SelectTabCallBack(AddressOf SelectTab)
      Me.BeginInvoke(d, New Object() {[Tab]})
    Else
      tbsBots.SelectTab(Tab)
    End If
  End Sub

  Private Sub frmMain_FormClosing(sender As Object, e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
    Try
      SaveAllSettings(True)
    Finally
      Application.Exit()
    End Try
  End Sub

  Private Sub SaveAllSettings(Optional bClose As Boolean = False)
    Try
      If My.Computer.FileSystem.FileExists(AppData & "\Settings.xml") Then My.Computer.FileSystem.CopyFile(AppData & "\Settings.xml", AppData & "\Settings.bak")
      ClearSettings()
      For I As Integer = 0 To tbsBots.TabPages.Count - 1
        Dim UI As BNUI = tbsBots.TabPages(I).Tag
        If UI.spltChat.Width - UI.spltChat.SplitterDistance > 0 Then UI.Config.Display.UI.ListWidth = UI.spltChat.Width - UI.spltChat.SplitterDistance
        UI.Config.Display.UI.PreWidth = UI.txtPre.Width
        UI.Config.Display.UI.SendWidth = UI.cmdSend.Width
        UI.Config.Display.UI.WhisperWidth = UI.cmdWhisper.Width
        SaveSettings(I, UI.Config)
        If bClose Then If UI.Status > 0 And Not UI.Status = 2 Then UI.BNCS_Disconnect()
      Next I
    Catch
      If My.Computer.FileSystem.FileExists(AppData & "\Settings.bak") Then
        If My.Computer.FileSystem.FileExists(AppData & "\Settings.xml") Then
          My.Computer.FileSystem.DeleteFile(AppData & "\Settings.xml")
          My.Computer.FileSystem.RenameFile(AppData & "\Settings.bak", "Settings.xml")
        Else
          My.Computer.FileSystem.RenameFile(AppData & "\Settings.bak", "Settings.xml")
        End If
      End If
    Finally
      If My.Computer.FileSystem.FileExists(AppData & "\Settings.bak") Then My.Computer.FileSystem.DeleteFile(AppData & "\Settings.bak")
    End Try
  End Sub

  Private Sub frmMain_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
    If My.Settings.Splash Then frmSplash.SetStatus(My.Resources.SPLASH_INIT)
    ResMan = New Resources.ResourceManager("Entelechy.frmMain", Reflection.[Assembly].GetExecutingAssembly)
    Randomize()
    If My.Settings.Splash Then frmSplash.SetStatus(My.Resources.SPLASH_GECKO)
    Skybound.Gecko.Xpcom.Initialize(System.Windows.Forms.Application.StartupPath & "\xulrunner\")
    'If My.Computer.FileSystem.FileExists(Application.StartupPath & "\FreeImage.dll") Then My.Computer.FileSystem.DeleteFile(Application.StartupPath & "\FreeImage.dll")
    'If Environment.Is64BitProcess Then
    '  My.Computer.FileSystem.CopyFile(Application.StartupPath & "\FreeImagex64.dll", "FreeImage.dll")
    'Else
    '  My.Computer.FileSystem.CopyFile(Application.StartupPath & "\FreeImagex86.dll", "FreeImage.dll")
    'End If
    If My.Settings.Splash Then frmSplash.SetStatus(My.Resources.SPLASH_ICONS)
    ParseAllIcons()
    If My.Settings.Splash Then frmSplash.SetStatus(My.Resources.SPLASH_SERVERS)
    LoadBNServer()
    If My.Settings.Splash Then frmSplash.SetStatus(My.Resources.SPLASH_PROFILES)
    Me.Size = My.Settings.Main_Size
    LoadProfiles()
    Dim Init As Boolean = True
    If My.Settings.StartupUpdates Then
      If My.Settings.Splash Then frmSplash.SetStatus(My.Resources.SPLASH_UPDATE)
      If CheckUpdates(False) Then Init = False
    End If
    If My.Settings.Splash Then frmSplash.SetStatus(My.Resources.SPLASH_COMPLETE)
    tmrUpdate.Enabled = True
    StartTime = Environment.TickCount
    If String.IsNullOrEmpty(My.Settings.PlayerPath) Then
      Select Case My.Settings.MediaPlayer
        Case "Winamp" : My.Settings.PlayerPath = My.Computer.FileSystem.SpecialDirectories.ProgramFiles & "\Winamp\Winamp.exe"
        Case "WMP" : My.Settings.PlayerPath = My.Computer.FileSystem.SpecialDirectories.ProgramFiles & "\Windows Media Player\wmplayer.exe"
        Case "iTunes" : My.Settings.PlayerPath = My.Computer.FileSystem.SpecialDirectories.ProgramFiles & "\iTunes\iTunes.exe"
        Case "LimeLight" : My.Settings.PlayerPath = My.Computer.FileSystem.SpecialDirectories.ProgramFiles & "\RealityRipple Software\Lime Light Media Player\LLMP.exe"
      End Select
    End If
    MPControls = New clsMediaControls
    Me.Location = My.Settings.Main_Location
    If Me.Location.X > My.Computer.Screen.WorkingArea.Width Or Me.Location.X < 0 Then Me.Location = New Point(0, Me.Location.Y)
    If Me.Location.Y > My.Computer.Screen.WorkingArea.Height Or Me.Location.Y < 0 Then Me.Location = New Point(Me.Location.X, 0)
    Me.WindowState = My.Settings.Main_State
    Me.Tag = "LOADED"
    trayIcon.Visible = My.Settings.TrayIcon
    If tbsBots.TabCount > 0 Then
      tbsBots.SelectedIndex = 0
    Else
      mnuOptionsAccounts.PerformClick()
    End If
    tmrInit.Enabled = Init
    tmrMouse.Enabled = My.Settings.MouseTabSwitch
    If My.Settings.Splash Then frmSplash.HideMe()
  End Sub

  Private Function CheckUpdates(Passive As Boolean) As Boolean
    Dim xPath As String = AppTemp & "\ver.xml"
    If Now.Subtract(My.Computer.FileSystem.GetFileInfo(xPath).CreationTime).TotalHours >= 4 Then
      Dim wsXML As New Net.WebClient
      wsXML.CachePolicy = New Net.Cache.HttpRequestCachePolicy(System.Net.Cache.HttpRequestCacheLevel.NoCacheNoStore)
      Try
        wsXML.DownloadFile(New Uri("http://update.realityripple.com/Entelechy/ver.xml"), xPath)
      Catch ex As Exception
        Return False
      End Try
      Dim xVer As XDocument = XDocument.Load(xPath)
      Dim xVerFile As XElement = xVer.Element("verfile")
      Dim xUpdates As XElement = xVerFile.Element("updates")
      If xUpdates IsNot Nothing Then
        Dim bUpdate As Boolean = False
        For Each File In xUpdates.Elements("file")
          Dim sLocalPath As String = Application.StartupPath & "\" & File.Element("path").Value
          If My.Computer.FileSystem.FileExists(sLocalPath) Then
            If FileVersionInfo.GetVersionInfo(sLocalPath).FileVersion = String.Empty Then
              Using MD5 As New System.Security.Cryptography.HMACMD5({31, 41, 59, 26, 53, 58, 97, 93, 238, 46, 26, 43, 38, 32, 79, 50, 28, 84, 197, 16, 93, 99, 37, 5, 105, 8, 20, 97, 4, 94, 45, 92, 30, 78, 16, 40, 62, 86, 208, 9, 98, 62, 80, 34, 82, 53, 42, 11, 70, 67, 98, 214, 80, 86, 51, 32, 82, 30, 66, 4, 70, 93, 84, 46})
                If BitConverter.ToString(MD5.ComputeHash(My.Computer.FileSystem.ReadAllBytes(sLocalPath))) <> File.Element("hash").Value Then
                  bUpdate = True
                  Exit For
                End If
              End Using
            Else
              If FileVersionInfo.GetVersionInfo(sLocalPath).FileVersion < File.Element("ver").Value Then
                bUpdate = True
                Exit For
              End If
            End If
          Else
            bUpdate = True
            Exit For
          End If
        Next
        If bUpdate Then
          If Passive Then
            trayIcon.Tag = "UPDATE"
            If Not trayIcon.Visible Then trayIcon.Visible = True
            trayIcon.ShowBalloonTip(60000, String.Empty, My.Resources.INFO_UPDATE_AVAILABLE, ToolTipIcon.Info)
            Return True
          Else
            If MsgBox(My.Resources.SPLASH_UPDATE_AVAILABLE, vbQuestion Or MsgBoxStyle.YesNo Or MsgBoxStyle.SystemModal) = MsgBoxResult.Yes Then
              mnuHelpAbout.PerformClick()
              Return True
            End If
          End If
        End If
      End If
    End If
    Return False
  End Function

  Private Sub mnuBotConnect_Click(sender As System.Object, e As System.EventArgs) Handles mnuBotConnect.Click
    If tbsBots.TabPages.Count > 0 Then
      Dim UI As BNUI = tbsBots.SelectedTab.Tag
      If UI.Status > 0 And Not UI.Status = 2 Then UI.BNCS_Disconnect()
      UI.BNCS_Connect()
    Else
      MsgBox(My.Resources.MAIN_NOBOTS, MsgBoxStyle.Critical)
    End If
  End Sub

  Private Sub mnuOptionsAccounts_Click(sender As System.Object, e As System.EventArgs) Handles mnuOptionsAccounts.Click
    selProfile = -1
    If Not frmAccountOptions.Visible Then frmAccountOptions.Show(Me)
  End Sub

  Private Sub AddBot(ProfileID As Integer)
    Dim NewUI As New BNUI
    Dim NewTab As New TabPage
    NewUI.Initialize()
    NewUI.Config = cfgProfiles(ProfileID)
    NewUI.Config.Parent = NewUI
    NewUI.TabIndex = 99
    NewUI.TabStop = False
    NewTab.TabIndex = 99
    NewTab.TabStop = False
    NewUI.Tag = NewTab
    NewTab.Tag = NewUI
    tbsBots.TabPages.Add(NewTab)
    NewTab.Controls.Add(NewUI)
    NewUI.Dock = DockStyle.Fill
    NewTab.Text = cfgProfiles(ProfileID).Account.ProfileName
    NewUI.spltChat.SplitterDistance = IIf(NewUI.spltChat.Width - NewUI.Config.Display.UI.ListWidth > 0, NewUI.spltChat.Width - NewUI.Config.Display.UI.ListWidth, NewUI.spltChat.Width - 225)
    NewUI.txtPre.Width = NewUI.Config.Display.UI.PreWidth
    NewUI.cmdSend.Width = NewUI.Config.Display.UI.SendWidth
    NewUI.cmdWhisper.Width = NewUI.Config.Display.UI.WhisperWidth
    NewUI.Index = ProfileID
    NewTab.BackColor = Color.Black
    AddPreviewBitmap(NewTab)
    tbsBots.SelectedTab = NewTab
    UpdatePreviewBitmap(NewTab)
  End Sub

  Private Sub preview_TabbedThumbnailMinimized(sender As Object, e As TabbedThumbnailEventArgs)
    tmrTrayRefresh.Tag = {"Minimized", e.WindowHandle}
    tmrTrayRefresh.Enabled = True
  End Sub

  Private Sub preview_TabbedThumbnailMaximized(sender As Object, e As TabbedThumbnailEventArgs)
    tmrTrayRefresh.Tag = {"Maximized", e.WindowHandle}
    tmrTrayRefresh.Enabled = True
  End Sub

  Private Sub preview_TabbedThumbnailClosed(sender As Object, e As TabbedThumbnailEventArgs)
    If bThumbs Then
      tmrTrayRefresh.Tag = {"Closed", e.WindowHandle}
      tmrTrayRefresh.Enabled = True
    End If
  End Sub

  Private Sub preview_TabbedThumbnailActivated(sender As Object, e As TabbedThumbnailEventArgs)
    If bThumbs Then
      tmrTrayRefresh.Tag = {"Activated", e.WindowHandle}
      tmrTrayRefresh.Enabled = True
    End If
  End Sub

  Public Sub RemoveBot(ProfileID As Integer)
    Dim UI As BNUI = tbsBots.TabPages(ProfileID).Tag
    RemovePreviewBitmap(tbsBots.TabPages(ProfileID))
    UI.Terminate()
    tbsBots.TabPages(ProfileID).Controls.Remove(UI)
    UI.Dispose()
    UI = Nothing
    tbsBots.TabPages(ProfileID).Tag = Nothing
    tbsBots.TabPages.Remove(tbsBots.TabPages(ProfileID))
    RemoveSettings(ProfileID)
  End Sub

  Public Sub LoadProfiles()
    Dim bChangeCount As Boolean
    If cfgProfiles Is Nothing Then
      ReDim cfgProfiles(ProfileCount() - 1)
      bChangeCount = True
    Else
      If UBound(cfgProfiles) <> ProfileCount() - 1 Then
        bChangeCount = True
        ReDim cfgProfiles(ProfileCount() - 1)
      End If
    End If
    For I As Integer = 0 To UBound(cfgProfiles)
      LoadSettings(I, cfgProfiles(I))
      If tbsBots.TabPages.Count - 1 < I Then AddBot(I)
    Next
    For I As Integer = 0 To tbsBots.TabPages.Count - 1
      If UBound(cfgProfiles) < I Then RemoveBot(I)
    Next
    For I As Integer = 0 To tbsBots.TabCount - 1
      tbsBots.TabPages(I).Text = cfgProfiles(I).Account.ProfileName
      Dim UI As BNUI = tbsBots.TabPages(I).Tag
      UI.Config = cfgProfiles(I)
      UI.Config.Parent = UI
      UI.gChat.TimeStampFormat = UI.Config.Display.TimeStamp
      UI.Config.Display.GetAds = cfgProfiles(I).Display.GetAds
      UI.Config.LogChat = cfgProfiles(I).LogChat
    Next (I)
  End Sub

  Private Sub mnuBotDisconnect_Click(sender As System.Object, e As System.EventArgs) Handles mnuBotDisconnect.Click
    If tbsBots.TabPages.Count > 0 Then
      Dim UI As BNUI = tbsBots.SelectedTab.Tag
      If UI.Status > 0 And Not UI.Status = 2 Then UI.BNCS_Disconnect()
    Else
      MsgBox(My.Resources.MAIN_NOBOTS, MsgBoxStyle.Critical)
    End If
  End Sub

  Private Sub tmrUpdate_Tick(sender As System.Object, e As System.EventArgs) Handles tmrUpdate.Tick
    If tbsBots.TabCount > 0 Then
      For I As Integer = 0 To tbsBots.TabCount - 1
        Dim UIt As BNUI = tbsBots.TabPages(I).Tag
        Dim sTip As String
        If UIt.IsOnline Then
          sTip = ResString(My.Resources.MAIN_TAB_TOOLTIP, UIt.BNetData.UniqueName, UIt.Config.Server, GameStringToName(UIt.Config.Account.Client.Product.ToString), UIt.Channel)
        Else
          sTip = My.Resources.MAIN_TAB_TOOLTIP_OFFLINE
        End If
        If Not tbsBots.TabPages(I).ToolTipText = sTip Then
          tbsBots.TabPages(I).ToolTipText = sTip
          If bThumbs Then
            UIt.ThumbView.Title = tbsBots.TabPages(I).Text & IIf(UIt.IsOnline, " - " & UIt.Channel, String.Empty)
            UIt.ThumbView.Tooltip = sTip
          End If
        End If
        If String.IsNullOrEmpty(tbsBots.TabPages(I).ImageKey) OrElse Not IsNumeric(tbsBots.TabPages(I).ImageKey) Then
          tbsBots.TabPages(I).ImageKey = 0
          Using bmpIcon As New Bitmap(imlStatus.Images.Item(tbsBots.TabPages(I).ImageKey))
            If bThumbs Then UIt.ThumbView.SetWindowIcon(bmpIcon.GetHicon)
          End Using
        Else
          If Not tbsBots.TabPages(I).ImageKey = UIt.Status Then
            tbsBots.TabPages(I).ImageKey = UIt.Status
            Using bmpIcon As New Bitmap(imlStatus.Images.Item(tbsBots.TabPages(I).ImageKey))
              If bThumbs Then UIt.ThumbView.SetWindowIcon(bmpIcon.GetHicon)
            End Using
          End If
        End If
      Next
      mnuBotAll.Enabled = True
      Dim UI As BNUI = tbsBots.SelectedTab.Tag
      If UI.Status > 0 And Not UI.Status = 2 Then
        mnuBotConnect.Enabled = True
        mnuBotConnect.Text = ResMan.GetString("mnuBotReconnect.Text")
        mnuBotDisconnect.Enabled = True
      Else
        mnuBotConnect.Enabled = True
        mnuBotConnect.Text = ResMan.GetString("mnuBotConnect.Text")
        mnuBotDisconnect.Enabled = False
      End If
    Else
      mnuBotAll.Enabled = False
      mnuBotConnect.Enabled = False
      mnuBotDisconnect.Enabled = False
    End If
    Static LastUpdate As Date
    If LastUpdate = New Date Then LastUpdate = Now
    If Math.Abs(DateDiff(DateInterval.Hour, LastUpdate, Now)) > 23 Then
      LastUpdate = Now
      CheckUpdates(True)
    End If
  End Sub

  Private Sub mnuBotExit_Click(sender As System.Object, e As System.EventArgs) Handles mnuBotExit.Click
    Me.Close()
  End Sub

  Private Sub mnuBotAllConnect_Click(sender As System.Object, e As System.EventArgs) Handles mnuBotAllConnect.Click
    If tbsBots.TabCount > 0 Then
      For I As Integer = 0 To tbsBots.TabCount - 1
        Dim UI As BNUI = tbsBots.TabPages(I).Tag
        If UI.Status = 0 Or UI.Status = 2 Then UI.BNCS_Connect()
      Next
    Else
      MsgBox(My.Resources.MAIN_NOBOTS, MsgBoxStyle.Critical)
    End If
  End Sub

  Private Sub mnuBotAllDisconnect_Click(sender As System.Object, e As System.EventArgs) Handles mnuBotAllDisconnect.Click
    If tbsBots.TabCount > 0 Then
      For I As Integer = 0 To tbsBots.TabCount - 1
        Dim UI As BNUI = tbsBots.TabPages(I).Tag
        If UI.Status > 0 And Not UI.Status = 2 Then UI.BNCS_Disconnect()
      Next
    Else
      MsgBox(My.Resources.MAIN_NOBOTS, MsgBoxStyle.Critical)
    End If
  End Sub

  Private Sub mnuTabConnect_Click(sender As System.Object, e As System.EventArgs) Handles mnuTabConnect.Click
    Dim UI As BNUI = tbsBots.TabPages(selProfile).Tag
    If UI.Status > 0 And Not UI.Status = 2 Then UI.BNCS_Disconnect()
    UI.BNCS_Connect()
    selProfile = -1
  End Sub

  Private Sub mnuTabDisconnect_Click(sender As System.Object, e As System.EventArgs) Handles mnuTabDisconnect.Click
    Dim UI As BNUI = tbsBots.TabPages(selProfile).Tag
    If UI.Status > 0 And Not UI.Status = 2 Then UI.BNCS_Disconnect()
    selProfile = -1
  End Sub

  Private Sub mnuTabOptions_Click(sender As System.Object, e As System.EventArgs) Handles mnuTabOptions.Click
    If frmAccountOptions.Visible Then
      frmAccountOptions.frmAccountOptions_Load(New Object, New EventArgs)
    Else
      frmAccountOptions.Show(Me)
    End If
  End Sub

  Private Sub mnuTabDelete_Click(sender As System.Object, e As System.EventArgs) Handles mnuTabDelete.Click
    If MsgBox(ResString(My.Resources.DELETE_CONFIRM, tbsBots.TabPages(selProfile).Text), MsgBoxStyle.Question + MsgBoxStyle.YesNo) = MsgBoxResult.Yes Then
      RemoveBot(selProfile)
      SaveAllSettings()
    End If
    selProfile = -1
  End Sub

  Private Sub tbsBots_MouseDown(sender As Object, e As System.Windows.Forms.MouseEventArgs) Handles tbsBots.MouseDown
    If e.Button = Windows.Forms.MouseButtons.Left And tbsBots.TabCount > 0 Then
      Dim lLen As Long = 1
      For I As Integer = 0 To tbsBots.TabCount - 1
        If tbsBots.GetTabRect(I).Contains(e.Location) Then
          selProfile = I
          Exit For
        End If
      Next
    End If
  End Sub

  Private Sub tbsBots_MouseUp(sender As Object, e As System.Windows.Forms.MouseEventArgs) Handles tbsBots.MouseUp
    If e.Button = Windows.Forms.MouseButtons.Right And tbsBots.TabCount > 0 Then
      Dim lLen As Long = 1
      For I As Integer = 0 To tbsBots.TabCount - 1
        If tbsBots.GetTabRect(I).Contains(e.Location) Then
          selProfile = I
          Exit For
        End If
      Next
      Dim UI As BNUI = tbsBots.TabPages(selProfile).Tag
      If UI.Status > 0 And Not UI.Status = 2 Then
        mnuTabConnect.Enabled = True
        mnuTabConnect.Text = ResMan.GetString("mnuTabReconnect.Text")
        mnuTabDisconnect.Enabled = True
      Else
        mnuTabConnect.Enabled = True
        mnuTabConnect.Text = ResMan.GetString("mnuTabConnect.Text")
        mnuTabDisconnect.Enabled = False
      End If
      mnuTab.Show(tbsBots, New Point(e.X, e.Y))
    ElseIf e.Button = Windows.Forms.MouseButtons.Left And tbsBots.TabCount > 0 Then
      Dim lLen As Long = 1
      Dim iSel As Integer = -1
      For I As Integer = 0 To tbsBots.TabCount - 1
        If tbsBots.GetTabRect(I).Contains(e.Location) Then
          iSel = I
          Exit For
        End If
      Next
      If iSel = -1 Then
        Dim tRect As Rectangle = tbsBots.GetTabRect(tbsBots.TabCount - 1)
        If tRect.Right < e.Location.X And tRect.Top < e.Location.Y And tRect.Bottom > e.Location.Y Then
          iSel = tbsBots.TabCount - 1
        Else
          iSel = selProfile
        End If
      End If
      If selProfile = -1 Then Exit Sub
      If selProfile <> iSel Then
        InsertSettings(selProfile, iSel)
        If selProfile < iSel Then
          Dim iTab As TabPage = tbsBots.TabPages(selProfile)
          For I As Integer = selProfile To iSel - 1
            For Each Tab As TabPage In tbsBots.TabPages
              If tbsBots.TabPages.IndexOf(Tab) = I + 1 Then
                tbsBots.TabPages(I) = Tab
                Exit For
              End If
            Next Tab
          Next
          tbsBots.TabPages(iSel) = iTab
        ElseIf selProfile > iSel Then
          Dim iTab As TabPage = tbsBots.TabPages(selProfile)
          For I As Integer = selProfile - 1 To iSel Step -1
            For Each Tab As TabPage In tbsBots.TabPages
              If tbsBots.TabPages.IndexOf(Tab) = I Then
                tbsBots.TabPages(I + 1) = Tab
                Exit For
              End If
            Next Tab
          Next
          tbsBots.TabPages(iSel) = iTab
        End If
        tbsBots.SelectedIndex = iSel
        tmrTrayRefresh.Tag = {"Refresh", IntPtr.Zero}
        tmrTrayRefresh.Enabled = True
      End If
      selProfile = -1
    ElseIf e.Button = Windows.Forms.MouseButtons.Middle And tbsBots.TabCount > 0 Then
      Dim lLen As Long = 1
      Dim iTab As Integer = -1
      For I As Integer = 0 To tbsBots.TabCount - 1
        If tbsBots.GetTabRect(I).Contains(e.Location) Then
          iTab = I
          Exit For
        End If
      Next
      If iTab > -1 Then
        Dim UI As BNUI = tbsBots.TabPages(iTab).Tag
        If UI.Status > 0 And Not UI.Status = 2 Then
          UI.BNCS_Disconnect()
        Else
          UI.BNCS_Connect()
        End If
      End If
    End If
  End Sub

  Private Sub frmMain_Resize(sender As Object, e As System.EventArgs) Handles Me.Resize
    Static lastMax As Boolean
    If Me.Tag = "LOADED" Then
      If Me.WindowState = FormWindowState.Minimized Then
        If My.Settings.MinToTray Then mnuTrayShow.PerformClick()
      Else
        trayIcon.Visible = My.Settings.TrayIcon
        My.Settings.Main_State = Me.WindowState
      End If
      If Me.WindowState = FormWindowState.Maximized And Not lastMax Then
        lastMax = True
        Dim selTab As TabPage = tbsBots.SelectedTab
        For Each tabItem As TabPage In tbsBots.TabPages
          If tabItem Is selTab Then
            UpdatePreviewBitmap(tabItem)
          Else
            Dim bnItem As BNUI = tabItem.Tag
            bnItem.Dock = DockStyle.None
            bnItem.Size = selTab.Size
            UpdatePreviewBitmap(tabItem)
            bnItem.Dock = DockStyle.Fill
          End If
        Next
      ElseIf Me.WindowState = FormWindowState.Normal And lastMax Then
        lastMax = False
        Dim selTab As TabPage = tbsBots.SelectedTab
        For Each tabItem As TabPage In tbsBots.TabPages
          If tabItem Is selTab Then
            UpdatePreviewBitmap(tabItem)
          Else
            Dim bnItem As BNUI = tabItem.Tag
            bnItem.Dock = DockStyle.None
            bnItem.Size = selTab.Size
            UpdatePreviewBitmap(tabItem)
            bnItem.Dock = DockStyle.Fill
          End If
        Next
      End If
      If bBottoms IsNot Nothing Then
        For I As Integer = 0 To tbsBots.TabPages.Count - 1
          If bBottoms(I) Then
            Dim ui As BNUI = CType(tbsBots.TabPages(I).Tag, BNUI)
            ui.ToBottom()
          End If
        Next
      End If
    End If
  End Sub

  Private Sub frmMain_ResizeBegin(sender As Object, e As System.EventArgs) Handles Me.ResizeBegin
    If Me.Tag = "LOADED" Then
      ReDim bBottoms(tbsBots.TabPages.Count - 1)
      For I As Integer = 0 To tbsBots.TabPages.Count - 1
        Dim ui As BNUI = CType(tbsBots.TabPages(I).Tag, BNUI)
        bBottoms(I) = ui.AtBottom
      Next
    End If
  End Sub

  Private Sub frmMain_ResizeEnd(sender As Object, e As System.EventArgs) Handles Me.ResizeEnd
    If Me.Tag = "LOADED" Then
      If Me.WindowState = FormWindowState.Normal Then
        For I As Integer = 0 To tbsBots.TabPages.Count - 1
          If bBottoms(I) Then
            Dim ui As BNUI = CType(tbsBots.TabPages(I).Tag, BNUI)
            ui.ToBottom()
          End If
        Next
        My.Settings.Main_Location = Me.Location
        My.Settings.Main_Size = Me.Size
      End If
      If Not Me.WindowState = FormWindowState.Minimized Then
        Dim selTab As TabPage = tbsBots.SelectedTab
        For Each tabItem As TabPage In tbsBots.TabPages
          If tabItem Is selTab Then
            UpdatePreviewBitmap(tabItem)
          Else
            Dim bnItem As BNUI = tabItem.Tag
            bnItem.Dock = DockStyle.None
            bnItem.Size = selTab.Size
            UpdatePreviewBitmap(tabItem)
            bnItem.Dock = DockStyle.Fill
          End If
        Next
      End If
    End If
  End Sub

  Protected Overrides Sub WndProc(ByRef m As System.Windows.Forms.Message)
    Static sLast As FormWindowState
    Static bB() As Boolean
    If m.Msg = &H46 Then
      sLast = Me.WindowState
      ReDim bB(tbsBots.TabPages.Count - 1)
      For I As Integer = 0 To tbsBots.TabPages.Count - 1
        Dim ui As BNUI = CType(tbsBots.TabPages(I).Tag, BNUI)
        bB(I) = ui.AtBottom
      Next
    End If
    If m.Msg = &H47 Then
      If sLast <> Me.WindowState Then
        sLast = Me.WindowState
        For I As Integer = 0 To tbsBots.TabPages.Count - 1
          If bB(I) Then
            Dim ui As BNUI = CType(tbsBots.TabPages(I).Tag, BNUI)
            ui.ToBottom()
          End If
        Next
      End If
    End If
    MyBase.WndProc(m)
  End Sub

  Private Sub mnuHelpConfig_Click(sender As System.Object, e As System.EventArgs) Handles mnuHelpConfig.Click
    Process.Start(AppData)
  End Sub

  Private Sub mnuAbout_Click(sender As System.Object, e As System.EventArgs) Handles mnuHelpAbout.Click, mnuTrayAbout.Click
    If My.Computer.FileSystem.FileExists(AppTemp & "\ver.xml") Then My.Computer.FileSystem.DeleteFile(AppTemp & "\ver.xml")
    If frmAbout.Visible Then
      frmAbout.Focus()
    Else
      frmAbout.Show(Me)
    End If
  End Sub

  Private Sub mnuHelpChat_Click(sender As System.Object, e As System.EventArgs) Handles mnuHelpChat.Click
    If tbsBots.TabPages.Count > 0 Then
      Dim UI As BNUI = tbsBots.SelectedTab.Tag
      ShowHelp(UI, &H0)
    End If
  End Sub

  Private Sub tbsBots_Selecting(sender As Object, e As System.Windows.Forms.TabControlCancelEventArgs) Handles tbsBots.Selecting
    UpdatePreviewBitmap(tbsBots.SelectedTab)
  End Sub

  Private Sub tbsBots_SelectedIndexChanged(sender As Object, e As System.EventArgs) Handles tbsBots.SelectedIndexChanged
    If tbsBots.SelectedTab IsNot Nothing Then
      Dim UI As BNUI = tbsBots.SelectedTab.Tag
      UI.txtSend.Focus()
      If bThumbs Then If TaskbarManager.Instance.TabbedThumbnail.IsThumbnailPreviewAdded(UI.ThumbView) Then TaskbarManager.Instance.TabbedThumbnail.SetActiveTab(UI.ThumbView)
    End If
  End Sub

  Public Sub RefreshPreviews()
    For Each tmpPage As TabPage In tbsBots.TabPages
      RemovePreviewBitmap(tmpPage)
      AddPreviewBitmap(tmpPage)
      If bThumbs Then
        Dim UIt As BNUI = tmpPage.Tag
        If UIt.ThumbView IsNot Nothing Then
          Dim sTip As String
          If UIt.IsOnline Then
            sTip = ResString(My.Resources.MAIN_TAB_TOOLTIP, UIt.BNetData.UniqueName, UIt.Config.Server, GameStringToName(UIt.Config.Account.Client.Product.ToString), UIt.Channel)
          Else
            sTip = My.Resources.MAIN_TAB_TOOLTIP_OFFLINE
          End If
          UIt.ThumbView.Title = tmpPage.Text & IIf(UIt.IsOnline, " - " & UIt.Channel, String.Empty)
          UIt.ThumbView.Tooltip = sTip
          Using bmpIcon As New Bitmap(imlStatus.Images.Item(tmpPage.ImageKey))
            If bThumbs Then UIt.ThumbView.SetWindowIcon(bmpIcon.GetHicon)
          End Using
        End If
      End If
    Next
  End Sub

  Private Sub AddPreviewBitmap(tabPage As TabPage)
    If TaskbarManager.IsPlatformSupported And My.Settings.TaskbarThumbs Then
      Dim tabUI As BNUI = tabPage.Tag
      tabUI.ThumbView = New TabbedThumbnail(Me.Handle, tabPage.Handle)
      AddHandler tabUI.ThumbView.TabbedThumbnailActivated, AddressOf preview_TabbedThumbnailActivated
      AddHandler tabUI.ThumbView.TabbedThumbnailClosed, AddressOf preview_TabbedThumbnailClosed
      AddHandler tabUI.ThumbView.TabbedThumbnailMaximized, AddressOf preview_TabbedThumbnailMaximized
      AddHandler tabUI.ThumbView.TabbedThumbnailMinimized, AddressOf preview_TabbedThumbnailMinimized
      TaskbarManager.Instance.TabbedThumbnail.AddThumbnailPreview(tabUI.ThumbView)
      TaskbarManager.Instance.ThumbnailToolBars.AddButtons(tabPage.Handle, ttbConnect, ttbDisconnect)
      bThumbs = True
      For Each tabItem As TabPage In tbsBots.TabPages
        If CType(tabItem.Tag, BNUI).ThumbView Is Nothing Then
          bThumbs = False
          Exit For
        End If
      Next
    End If
  End Sub

  Public Sub UpdatePreviewBitmap(tabPage As TabPage)
    If bThumbs Then
      If TaskbarManager.IsPlatformSupported AndAlso tabPage IsNot Nothing Then
        Dim preview As TabbedThumbnail = TaskbarManager.Instance.TabbedThumbnail.GetThumbnailPreview(tabPage)
        If preview IsNot Nothing Then
          Dim UI As BNUI = tabPage.Tag
          If Not UI.Size.IsEmpty Then
            Using bm As New Bitmap(UI.Size.Width, UI.Size.Height)
              UI.DrawToBitmap(bm, New Rectangle(Point.Empty, UI.Size))
              preview.SetImage(bm)
            End Using
          End If
        End If
      End If
    End If
  End Sub

  Private Sub RemovePreviewBitmap(tabPage As TabPage)
    If TaskbarManager.IsPlatformSupported Then
      Dim tabUI As BNUI = tabPage.Tag
      If tabUI.ThumbView IsNot Nothing Then
        If TaskbarManager.Instance.TabbedThumbnail.IsThumbnailPreviewAdded(tabUI.ThumbView) Then TaskbarManager.Instance.TabbedThumbnail.RemoveThumbnailPreview(tabUI.ThumbView)
        RemoveHandler tabUI.ThumbView.TabbedThumbnailActivated, AddressOf preview_TabbedThumbnailActivated
        RemoveHandler tabUI.ThumbView.TabbedThumbnailClosed, AddressOf preview_TabbedThumbnailClosed
        RemoveHandler tabUI.ThumbView.TabbedThumbnailMaximized, AddressOf preview_TabbedThumbnailMaximized
        RemoveHandler tabUI.ThumbView.TabbedThumbnailMinimized, AddressOf preview_TabbedThumbnailMinimized
        tabUI.ThumbView = Nothing
      End If
    Else
      Dim tabUI As BNUI = tabPage.Tag
      If tabUI.ThumbView IsNot Nothing Then
        RemoveHandler tabUI.ThumbView.TabbedThumbnailActivated, AddressOf preview_TabbedThumbnailActivated
        RemoveHandler tabUI.ThumbView.TabbedThumbnailClosed, AddressOf preview_TabbedThumbnailClosed
        RemoveHandler tabUI.ThumbView.TabbedThumbnailMaximized, AddressOf preview_TabbedThumbnailMaximized
        RemoveHandler tabUI.ThumbView.TabbedThumbnailMinimized, AddressOf preview_TabbedThumbnailMinimized
        tabUI.ThumbView = Nothing
      End If
    End If
    bThumbs = False
    For Each tabItem As TabPage In tbsBots.TabPages
      If CType(tabItem.Tag, BNUI).ThumbView IsNot Nothing Then
        bThumbs = True
        Exit For
      End If
    Next
  End Sub

  Private Sub trayIcon_BalloonTipClicked(sender As Object, e As System.EventArgs) Handles trayIcon.BalloonTipClicked
    If trayIcon.Tag Is Nothing Then
      mnuTrayShow.PerformClick()
    Else
      trayIcon.Tag = Nothing
      If Not Me.Visible Then mnuTrayShow.PerformClick()
      If Me.WindowState = FormWindowState.Minimized Then Me.WindowState = My.Settings.Main_State
      trayIcon.Visible = My.Settings.TrayIcon
      mnuAbout_Click(sender, e)
    End If
  End Sub

  Private Sub trayIcon_BalloonTipClosed(sender As Object, e As System.EventArgs) Handles trayIcon.BalloonTipClosed
    If trayIcon.Tag IsNot Nothing Then
      trayIcon.Tag = Nothing
      If Me.Visible Then
        trayIcon.Visible = My.Settings.TrayIcon
      Else
        trayIcon.Visible = My.Settings.MinToTray Or My.Settings.TrayIcon
      End If
    End If
  End Sub

  Private Sub trayIcon_MouseClick(sender As Object, e As System.Windows.Forms.MouseEventArgs) Handles trayIcon.MouseClick
    If e.Button = Windows.Forms.MouseButtons.Left Then
      If Me.Visible Then Me.Activate()
      trayIcon.BalloonTipIcon = ToolTipIcon.Info
      trayIcon.BalloonTipTitle = My.Resources.MAIN_TRAY_BALLOON_TITLE
      Dim sText As String = String.Empty
      For Each tabBot As TabPage In tbsBots.TabPages
        Dim UI As BNUI = tabBot.Tag
        If UI.IsOnline Then
          sText &= ResString(My.Resources.MAIN_TRAY_BALLOON_TEXT, IIf(String.IsNullOrEmpty(UI.BNetData.UniqueName), UI.Config.Account.Username, UI.BNetData.UniqueName), BNServerNames.GetGatewayName(UI.Config.Server, False), UI.Channel)
        Else
          sText &= ResString(My.Resources.MAIN_TRAY_BALLOON_TEXT_OFFLINE, UI.Config.Account.ProfileName)
        End If
        sText &= vbNewLine
      Next
      trayIcon.BalloonTipText = sText
      trayIcon.ShowBalloonTip(45000)
    End If
  End Sub

  Private Sub mnuTrayShow_Click(sender As System.Object, e As System.EventArgs) Handles mnuTrayShow.Click
    Me.Visible = Not Me.Visible
    If Me.Visible Then
      Me.Activate()
      mnuTrayShow.Text = ResMan.GetString("mnuTrayHide.Text")
      trayIcon.Visible = My.Settings.TrayIcon
      If Me.WindowState = FormWindowState.Minimized Then Me.WindowState = My.Settings.Main_State
    Else
      mnuTrayShow.Text = ResMan.GetString("mnuTrayShow.Text")
      trayIcon.Visible = My.Settings.MinToTray Or My.Settings.TrayIcon
    End If
  End Sub

  Private Sub mnuTrayExit_Click(sender As System.Object, e As System.EventArgs) Handles mnuTrayExit.Click
    Me.Close()
  End Sub

  Private Sub mnuTray_Opening(sender As System.Object, e As System.ComponentModel.CancelEventArgs) Handles mnuTray.Opening
    If Me.Visible Then
      mnuTrayShow.Text = ResMan.GetString("mnuTrayHide.Text")
    Else
      mnuTrayShow.Text = ResMan.GetString("mnuTrayShow.Text")
    End If
    mnuTrayProfiles.DropDownItems.Clear()
    Dim mnuTrayAll As New ToolStripMenuItem(ResMan.GetString("mnuBotAll.Text"))
    Dim mnuTrayAllConnect As New ToolStripMenuItem(ResMan.GetString("mnuBotAllConnect.Text"))
    AddHandler mnuTrayAllConnect.Click, AddressOf mnuBotAllConnect_Click
    Dim mnuTrayAllDisconnect As New ToolStripMenuItem(ResMan.GetString("mnuBotAllDisconnect.Text"))
    AddHandler mnuTrayAllDisconnect.Click, AddressOf mnuBotAllDisconnect_Click
    mnuTrayAll.DropDownItems.Add(mnuTrayAllConnect)
    mnuTrayAll.DropDownItems.Add(mnuTrayAllDisconnect)
    mnuTrayProfiles.DropDownItems.Add(mnuTrayAll)
    mnuTrayProfiles.DropDownItems.Add(mnuTrayProfilesSpace)
    CType(mnuTrayAll.DropDown, ToolStripDropDownMenu).ShowImageMargin = False
    For Each tabBot As TabPage In tbsBots.TabPages
      Dim UI As BNUI = tabBot.Tag
      Dim mnuTrayProfilesItem As New ToolStripMenuItem(UI.Config.Account.ProfileName)
      AddHandler mnuTrayProfilesItem.MouseHover, AddressOf mnuTrayProfilesItem_MouseHover
      mnuTrayProfilesItem.Name = UI.Index
      Dim mnuTrayProfilesItemConnect As New ToolStripMenuItem(ResMan.GetString(IIf(UI.Status > 0, "mnuTabReconnect.Text", "mnuTabConnect.Text")))
      AddHandler mnuTrayProfilesItemConnect.Click, AddressOf mnuTabConnect_Click
      mnuTrayProfilesItem.DropDownItems.Add(mnuTrayProfilesItemConnect)

      Dim mnuTrayProfilesItemDisconnect As New ToolStripMenuItem(ResMan.GetString("mnuTabDisconnect.Text"))
      AddHandler mnuTrayProfilesItemDisconnect.Click, AddressOf mnuTabDisconnect_Click
      mnuTrayProfilesItemDisconnect.Enabled = UI.Status > 0
      mnuTrayProfilesItem.DropDownItems.Add(mnuTrayProfilesItemDisconnect)

      mnuTrayProfilesItem.DropDownItems.Add(New ToolStripSeparator)

      Dim mnuTrayProfilesItemOptions As New ToolStripMenuItem(ResMan.GetString("mnuTabOptions.Text"))
      AddHandler mnuTrayProfilesItemOptions.Click, AddressOf mnuTabOptions_Click
      mnuTrayProfilesItem.DropDownItems.Add(mnuTrayProfilesItemOptions)

      mnuTrayProfilesItem.DropDownItems.Add(New ToolStripSeparator)

      Dim mnuTrayProfilesItemDelete As New ToolStripMenuItem(ResMan.GetString("mnuTabDelete.Text"))
      AddHandler mnuTrayProfilesItemDelete.Click, AddressOf mnuTabDelete_Click
      mnuTrayProfilesItem.DropDownItems.Add(mnuTrayProfilesItemDelete)
      mnuTrayProfiles.DropDownItems.Add(mnuTrayProfilesItem)
      CType(mnuTrayProfilesItem.DropDown, ToolStripDropDownMenu).ShowImageMargin = False
    Next
  End Sub

  Private Sub mnuTrayProfilesItem_MouseHover(sender As Object, e As EventArgs)
    selProfile = sender.name
  End Sub

  Private Sub mnuBotOptionsPasswordReset_Click(sender As System.Object, e As System.EventArgs) Handles mnuBotOptionsPasswordReset.Click
    If tbsBots.TabPages.Count > 0 Then
      Dim UI As BNUI = tbsBots.SelectedTab.Tag
      If UI.Status > 0 And Not UI.Status = 2 Then UI.BNCS_Disconnect()
      UI.Config.Account.Change.PassReset = True
      UI.BNCS_Connect()
    Else
      MsgBox(My.Resources.MAIN_NOBOTS, MsgBoxStyle.Critical)
    End If
  End Sub

  Private Sub mnuBotOptionsEMail_Click(sender As System.Object, e As System.EventArgs) Handles mnuBotOptionsEMail.Click
    If tbsBots.TabPages.Count > 0 Then
      Dim UI As BNUI = tbsBots.SelectedTab.Tag
      If UI.Status > 0 And Not UI.Status = 2 Then UI.BNCS_Disconnect()
      UI.Config.Account.Change.EMail = InputBox(My.Resources.MAIN_CHANGE_EMAIL, My.Resources.MAIN_CHANGE_EMAIL_TITLE, UI.Config.Account.EMail)
      UI.BNCS_Connect()
    Else
      MsgBox(My.Resources.MAIN_NOBOTS, MsgBoxStyle.Critical)
    End If
  End Sub

  Private Sub mnuBotOptionsPasswordChange_Click(sender As System.Object, e As System.EventArgs) Handles mnuBotOptionsPasswordChange.Click
    If tbsBots.TabPages.Count > 0 Then
      Dim UI As BNUI = tbsBots.SelectedTab.Tag
      If UI.Status > 0 And Not UI.Status = 2 Then UI.BNCS_Disconnect()
      UI.Config.Account.Change.Password = InputBox(My.Resources.MAIN_CHANGE_PASSWORD, My.Resources.MAIN_CHANGE_PASSWORD_TITLE, UI.Config.Account.Password)
      UI.BNCS_Connect()
    Else
      MsgBox(My.Resources.MAIN_NOBOTS, MsgBoxStyle.Critical)
    End If
  End Sub

  Private Sub tmrMouse_Tick(sender As System.Object, e As System.EventArgs) Handles tmrMouse.Tick
    If ActiveForm Is Me And tbsBots.TabCount > 0 Then
      If tmrMouse.Interval = 10 Then
        tmrMouse.Interval = 350
      ElseIf tmrMouse.Interval = 350 Then
        tmrMouse.Interval = 200
      End If
      If MouseButtons = Windows.Forms.MouseButtons.XButton1 Then
        If tbsBots.SelectedIndex = 0 Then
          tbsBots.SelectedIndex = tbsBots.TabCount - 1
        Else
          tbsBots.SelectedIndex -= 1
        End If
      ElseIf MouseButtons = Windows.Forms.MouseButtons.XButton2 Then
        If tbsBots.SelectedIndex = tbsBots.TabCount - 1 Then
          tbsBots.SelectedIndex = 0
        Else
          tbsBots.SelectedIndex += 1
        End If
      Else
        tmrMouse.Interval = 10
      End If
    End If
  End Sub

  Private Sub tmrInit_Tick(sender As System.Object, e As System.EventArgs) Handles tmrInit.Tick
    tmrInit.Enabled = False
    For I As Integer = 0 To tbsBots.TabPages.Count - 1
      Dim UI As BNUI = tbsBots.TabPages(I).Tag
      If UI.Config.AutoConnect And Not Command.Contains("/offline") Then
        UI.BNCS_Connect()
        Application.DoEvents()
        Threading.Thread.Sleep(100)
      End If
    Next
  End Sub

  Private Sub SettingsToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles mnuOptionsSettings.Click
    If Not frmSettings.Visible Then frmSettings.Show(Me)
  End Sub

  Private Sub tmrTrayRefresh_Tick(sender As System.Object, e As System.EventArgs) Handles tmrTrayRefresh.Tick
    tmrTrayRefresh.Enabled = False
    If tmrTrayRefresh.Tag IsNot Nothing Then
      Dim sCommand As String = CType(tmrTrayRefresh.Tag, Array)(0)
      Dim hWnd As IntPtr
      Dim selTab As TabPage
      If CType(tmrTrayRefresh.Tag, Array)(1) = IntPtr.Zero Then
        hWnd = IntPtr.Zero
        selTab = Nothing
      Else
        hWnd = CType(tmrTrayRefresh.Tag, Array)(1)
        selTab = (From page As TabPage In tbsBots.TabPages Where page.Handle = hWnd).FirstOrDefault
      End If
      Select Case sCommand
        Case "Activated"
          If Me.WindowState = FormWindowState.Minimized Then Me.WindowState = FormWindowState.Normal
          If Me.Visible And Me.WindowState <> FormWindowState.Minimized Then Me.Activate()
          If selTab IsNot Nothing Then SelectTab(selTab)
          TaskbarManager.Instance.TabbedThumbnail.SetActiveTab(hWnd)
          UpdatePreviewBitmap(tbsBots.SelectedTab)
        Case "Minimized"
          Me.WindowState = FormWindowState.Minimized
        Case "Maximized"
          Me.WindowState = FormWindowState.Maximized
          If tbsBots.Size <> Size.Empty AndAlso tbsBots.TabPages.Count > 0 AndAlso tbsBots.SelectedTab IsNot Nothing Then UpdatePreviewBitmap(tbsBots.SelectedTab)
        Case "Closed"
          If selTab IsNot Nothing Then
            Dim UI As BNUI = selTab.Tag
            If MsgBox(ResString(My.Resources.DELETE_CONFIRM, selTab.Text), MsgBoxStyle.Question + MsgBoxStyle.YesNo) = MsgBoxResult.Yes Then
              RemoveBot(UI.Index)
              tbsBots.TabPages.Remove(selTab)
              SaveAllSettings()
            Else
              RefreshPreviews()
            End If
          End If
        Case "Refresh"
          RefreshPreviews()
      End Select
    End If
    tmrTrayRefresh.Tag = Nothing
  End Sub

  Private Sub frmMain_Shown(sender As Object, e As System.EventArgs) Handles Me.Shown
    If TaskbarManager.IsPlatformSupported Then
      Dim jList As JumpList
      jList = JumpList.CreateJumpList()
      jList.ClearAllUserTasks()
      Dim jllApp As New JumpListLink(Application.StartupPath, My.Resources.JUMPLIST_BOTFOLDER) With {.IconReference = New IconReference(Application.ExecutablePath, 0)}
      Dim jllConfig As New JumpListLink(AppData, My.Resources.JUMPLIST_CONFIGFOLDER) With {.IconReference = New IconReference("explorer.exe", 0)}
      Dim jllSettings As New JumpListLink("notepad.exe", My.Resources.JUMPLIST_SETTINGS) With {.Arguments = AppData & "\Settings.xml", .IconReference = New IconReference("notepad.exe", 0)}
      Dim jllWebsite As New JumpListLink("http://e.realityripple.com/", My.Resources.JUMPLIST_WEBSITE) With {.IconReference = New IconReference("shell32.dll", 135)}
      jList.AddUserTasks(jllSettings)
      jList.AddUserTasks(jllWebsite)
      jList.AddUserTasks(New JumpListSeparator)
      jList.AddUserTasks(jllApp)
      jList.AddUserTasks(jllConfig)
      jList.KnownCategoryToDisplay = JumpListKnownCategoryType.Neither
      jList.Refresh()
    End If
  End Sub

  Private Sub ttbConnect_Click(sender As Object, e As Microsoft.WindowsAPICodePack.Taskbar.ThumbnailButtonClickedEventArgs) Handles ttbConnect.Click
    Dim selTab As TabPage = (From page As TabPage In tbsBots.TabPages Where page.Handle = e.WindowHandle).FirstOrDefault
    CType(selTab.Tag, BNUI).BNCS_Connect()
  End Sub

  Private Sub ttbDisconnect_Click(sender As Object, e As Microsoft.WindowsAPICodePack.Taskbar.ThumbnailButtonClickedEventArgs) Handles ttbDisconnect.Click
    Dim selTab As TabPage = (From page As TabPage In tbsBots.TabPages Where page.Handle = e.WindowHandle).FirstOrDefault
    CType(selTab.Tag, BNUI).BNCS_Disconnect()
  End Sub

  Private Sub mnuHelpComment_Click(sender As System.Object, e As System.EventArgs) Handles mnuHelpComment.Click
    frmComment.Show(Me)
  End Sub

  Private Sub mnuBotHistory_Click(sender As System.Object, e As System.EventArgs) Handles mnuBotHistory.Click
    frmHistory.Show()
  End Sub

  Private Sub mnuOptions_DropDownOpening(sender As Object, e As System.EventArgs) Handles mnuOptions.DropDownOpening
    selProfile = -1
  End Sub
End Class
