﻿Public Class frmHistory

  Private Sub frmHistory_Load(sender As Object, e As System.EventArgs) Handles Me.Load
    cmbProfile.Items.Clear()
    If My.Computer.FileSystem.DirectoryExists(AppData & "\Logs\") Then
      For Each Directory As String In My.Computer.FileSystem.GetDirectories(AppData & "\Logs\")
        cmbProfile.Items.Add(IO.Path.GetFileName(Directory))
        If frmMain.Visible AndAlso frmMain.tbsBots.SelectedIndex > -1 Then
          If IO.Path.GetFileName(Directory) = frmMain.tbsBots.SelectedTab.Text Then
            cmbProfile.SelectedIndex = cmbProfile.Items.Count - 1
          End If
        End If
      Next
    End If
    If cmbProfile.Items.Count > 0 Then
      If cmbProfile.SelectedIndex = -1 Then cmbProfile.SelectedIndex = 0
    Else
      Me.Close()
      MsgBox(My.Resources.HISTORY_NONE, MsgBoxStyle.OkOnly Or MsgBoxStyle.Exclamation)
    End If
  End Sub

  Private Sub cmbProfile_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles cmbProfile.SelectedIndexChanged
    lvDates.Items.Clear()
    If cmbProfile.SelectedIndex > -1 Then
      For Each LogFile As String In My.Computer.FileSystem.GetFiles(AppData & "\Logs\" & cmbProfile.Text)
        Dim lvItem As New ListViewItem(IO.Path.GetFileNameWithoutExtension(LogFile))
        lvItem.ImageIndex = 0
        lvItem.SubItems.Add(ByteSize(My.Computer.FileSystem.GetFileInfo(LogFile).Length))
        lvDates.Items.Add(lvItem)
      Next
      If lvDates.Items.Count > 0 Then lvDates.Items(0).Selected = True
      lvDates.TileSize = New Size(lvDates.ClientSize.Width, 50)
    End If
  End Sub

  Private Sub lvDates_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles lvDates.SelectedIndexChanged
    If lvDates.SelectedIndices.Count > 0 Then gwHistory.Navigate(AppData & "\Logs\" & cmbProfile.Text & "\" & lvDates.SelectedItems(0).Text & ".html")
  End Sub

  Private Sub cmdFind_Click(sender As System.Object, e As System.EventArgs) Handles cmdFind.Click
    If gwHistory.Url IsNot Nothing Then
      Dim scrollTop As Integer = gwHistory.Document.DocumentElement.ScrollTop
      Dim bEnd As Boolean = True
      gwHistory.Hide()
      For Each contTR As Skybound.Gecko.GeckoElement In gwHistory.Document.Body.GetElementsByTagName("table")(0).GetElementsByTagName("tr")
        If contTR.TextContent.ToLower.Contains(txtFind.Text.ToLower) Then
          contTR.ScrollIntoView(False)
          If scrollTop < gwHistory.Document.DocumentElement.ScrollTop Then
            bEnd = False
            Exit For
          End If
        End If
      Next
      gwHistory.Show()
      If bEnd Then
        Beep()
      End If
    End If
  End Sub

  Private Sub txtFind_KeyDown(sender As Object, e As System.Windows.Forms.KeyEventArgs) Handles txtFind.KeyDown
    If e.KeyCode = Keys.Enter Then
      e.Handled = True
      e.SuppressKeyPress = True
    End If
  End Sub

  Private Sub txtFind_KeyUp(sender As Object, e As System.Windows.Forms.KeyEventArgs) Handles txtFind.KeyUp
    If e.KeyCode = Keys.Enter Then
      e.Handled = True
      e.SuppressKeyPress = True
      cmdFind_Click(sender, New EventArgs)
    End If
  End Sub

  Private Sub gwHistory_DomClick(sender As Object, e As Skybound.Gecko.GeckoDomEventArgs) Handles gwHistory.DomClick
    If e.Target IsNot Nothing AndAlso e.Target.TagName.ToLower = "a" Then e.Handled = True
  End Sub

  Private Sub gwHistory_DomMouseDown(sender As Object, e As Skybound.Gecko.GeckoDomMouseEventArgs) Handles gwHistory.DomMouseDown
    If e.Target IsNot Nothing AndAlso e.Target.TagName.ToLower = "a" Then e.Handled = True
  End Sub

  Private Sub gwHistory_DomMouseUp(sender As Object, e As Skybound.Gecko.GeckoDomMouseEventArgs) Handles gwHistory.DomMouseUp
    If gwHistory.CanCopySelection Then
      gwHistory.CopySelection()
      Dim sTmp As String = Clipboard.GetText
      If sTmp IsNot String.Empty Then
        gwHistory.SelectNone()
        Clipboard.SetText(Replace(sTmp, vbTab & vbNewLine, " "))
      End If
    End If
    If e.Target IsNot Nothing AndAlso e.Target.TagName.ToLower = "a" Then
      If Not String.IsNullOrEmpty(e.Target.GetAttribute("name")) Then
        If e.Target.GetAttribute("name") = "URL" Then
          If Not String.IsNullOrEmpty(e.Target.GetAttribute("href")) Then
            e.Handled = True
            Dim sURL As String = e.Target.GetAttribute("href")
            If e.Button = 0 Then
              Try
                Process.Start(sURL)
              Catch ex As Exception
                MsgBox(ResString(My.Resources.ADDRESS_UNABLE_TO_HANDLE, sURL), MsgBoxStyle.Critical)
              End Try
            ElseIf e.Button = 2 Then
              mnuAddress.Tag = sURL
              mnuAddress.Show(gwHistory, New Point(e.ClientX, e.ClientY))
            End If
          End If
        End If
      End If
    End If
  End Sub

  Private Sub OpenURLInBrowserToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles OpenURLInBrowserToolStripMenuItem.Click
    Process.Start(mnuAddress.Tag)
  End Sub

  Private Sub CopyURLToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles CopyURLToolStripMenuItem.Click
    Clipboard.SetText(mnuAddress.Tag)
  End Sub

  Private Sub frmHistory_Resize(sender As Object, e As System.EventArgs) Handles Me.Resize
    lvDates.TileSize = New Size(lvDates.ClientSize.Width, 50)
  End Sub

  Private Sub gwHistory_MouseWheel(sender As Object, e As System.Windows.Forms.MouseEventArgs) Handles gwHistory.MouseWheel
    gwHistory.Document.DocumentElement.ScrollTop += e.Delta
  End Sub
End Class