﻿Imports System.Windows.Forms

Public Class frmCDKey
  Public CDKey As String
  Private gClient As BNUI.GameType

  Private Sub cmdOK_Click(sender As System.Object, e As System.EventArgs) Handles cmdOK.Click
    If pnlKeys.Controls.Contains(pnl13) Then
      If txt13A.Text.Length = 4 Then
        If txt13B.Text.Length = 5 Then
          If txt13C.Text.Length = 4 Then
            CDKey = txt13A.Text & "-" & txt13B.Text & "-" & txt13C.Text
            Me.DialogResult = DialogResult.OK
            Me.Close()
          Else
            txt13C.Focus()
          End If
        Else
          txt13B.Focus()
        End If
      Else
        txt13A.Focus()
      End If
    ElseIf pnlKeys.Controls.Contains(pnl16) Then
      If txt16A.Text.Length = 4 Then
        If txt16B.Text.Length = 4 Then
          If txt16C.Text.Length = 4 Then
            If txt16D.Text.Length = 4 Then
              CDKey = txt16A.Text & "-" & txt16B.Text & "-" & txt16C.Text & "-" & txt16D.Text
              Me.DialogResult = DialogResult.OK
              Me.Close()
            Else
              txt16D.Focus()
            End If
          Else
            txt16C.Focus()
          End If
        Else
          txt16B.Focus()
        End If
      Else
        txt16A.Focus()
      End If
    ElseIf pnlKeys.Controls.Contains(pnl26) Then
      If txt26A.Text.Length = 6 Then
        If txt26B.Text.Length = 4 Then
          If txt26C.Text.Length = 6 Then
            If txt26D.Text.Length = 4 Then
              If txt26E.Text.Length = 6 Then
                CDKey = txt26A.Text & "-" & txt26B.Text & "-" & txt26C.Text & "-" & txt26D.Text & "-" & txt26E.Text
                Me.DialogResult = DialogResult.OK
                Me.Close()
              Else
                txt26E.Focus()
              End If
            Else
              txt26D.Focus()
            End If
          Else
            txt26C.Focus()
          End If
        Else
          txt26B.Focus()
        End If
      Else
        txt26A.Focus()
      End If
    End If
  End Sub

  Private Sub cmdCancel_Click(sender As System.Object, e As System.EventArgs) Handles cmdCancel.Click
    Me.DialogResult = System.Windows.Forms.DialogResult.Cancel
    Me.Close()
  End Sub

  Private Sub lblBNet_LinkClicked(sender As System.Object, e As System.Windows.Forms.LinkLabelLinkClickedEventArgs) Handles lblBNet.LinkClicked
    Process.Start("http://www.battle.net")
  End Sub

  Public Sub New()
    InitializeComponent()
    gClient = BNUI.GameType.STAR
    If pnlKeys.Controls.Contains(pnl13) Then pnlKeys.Controls.Remove(pnl13)
    If pnlKeys.Controls.Contains(pnl16) Then pnlKeys.Controls.Remove(pnl16)
    If pnlKeys.Controls.Contains(pnl26) Then pnlKeys.Controls.Remove(pnl26)
  End Sub

  Public Sub New(Client As BNUI.GameType)
    InitializeComponent()
    gClient = Client
    If pnlKeys.Controls.Contains(pnl13) Then pnlKeys.Controls.Remove(pnl13)
    If pnlKeys.Controls.Contains(pnl16) Then pnlKeys.Controls.Remove(pnl16)
    If pnlKeys.Controls.Contains(pnl26) Then pnlKeys.Controls.Remove(pnl26)
  End Sub

  Private Sub ShowKeys(DisplayStyle As Byte)
    If pnlKeys.Controls.Contains(pnl13) Then pnlKeys.Controls.Remove(pnl13)
    If pnlKeys.Controls.Contains(pnl16) Then pnlKeys.Controls.Remove(pnl16)
    If pnlKeys.Controls.Contains(pnl26) Then pnlKeys.Controls.Remove(pnl26)
    Select Case DisplayStyle
      Case 1
        pnlKeys.Controls.Add(pnl13, 0, 0)
        pnl13.Anchor = AnchorStyles.None
        txt13A.Focus()
      Case 2
        pnlKeys.Controls.Add(pnl16, 0, 0)
        pnl16.Anchor = AnchorStyles.None
        txt16A.Focus()
      Case 3
        pnlKeys.Controls.Add(pnl26, 0, 0)
        pnl26.Anchor = AnchorStyles.None
        txt26A.Focus()
    End Select
  End Sub

  Private Sub chk26Key_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chk26Key.CheckedChanged
    If chk26Key.Checked Then
      ShowKeys(3)
    Else
      Select Case gClient
        Case BNUI.GameType.STAR, BNUI.GameType.SEXP, BNUI.GameType.JSTR
          ShowKeys(1)
        Case BNUI.GameType.D2DV, BNUI.GameType.D2XP
          ShowKeys(2)
      End Select
    End If
  End Sub

  Private Sub txt13_DragDrop(sender As Object, e As System.Windows.Forms.DragEventArgs) Handles txt13A.DragDrop, txt13B.DragDrop, txt13C.DragDrop
    If Not String.IsNullOrEmpty(e.Data.GetData("String")) Then
      Dim Key As String = CDLegal(e.Data.GetData("String"))
      If Key.Length = 13 Then
        txt13A.Text = Key.Substring(0, 4)
        txt13B.Text = Key.Substring(4, 5)
        txt13C.Text = Key.Substring(9, 4)
        e.Effect = DragDropEffects.Copy
      Else
        e.Effect = DragDropEffects.None
      End If
    End If
  End Sub

  Private Sub txt13_DragOver(sender As Object, e As System.Windows.Forms.DragEventArgs) Handles txt13A.DragOver, txt13B.DragOver, txt13C.DragOver
    If Not e.Data.GetDataPresent(GetType(String)) Then
      e.Effect = DragDropEffects.None
    Else
      Dim Key As String = CDLegal(e.Data.GetData(GetType(String)))
      If Key.Length = 13 Then
        e.Effect = DragDropEffects.Copy
      Else
        e.Effect = DragDropEffects.None
      End If
    End If
  End Sub

  Private Sub txt13_GotFocus(sender As Object, e As System.EventArgs) Handles txt13A.GotFocus, txt13B.GotFocus, txt13C.GotFocus
    sender.SelectAll()
  End Sub

  Private Sub txt13_KeyDown(sender As TextBox, e As System.Windows.Forms.KeyEventArgs) Handles txt13A.KeyDown, txt13B.KeyDown, txt13C.KeyDown
    If e.KeyValue = 86 And e.Control Then
      If Not String.IsNullOrEmpty(Clipboard.GetText) Then
        Dim Key As String = CDLegal(Clipboard.GetText)
        If Key.Length = 13 Then
          txt13A.Text = Key.Substring(0, 4)
          txt13B.Text = Key.Substring(4, 5)
          txt13C.Text = Key.Substring(9, 4)
          'cmdOK.Focus()
          e.Handled = True
        Else
          sender.Text = Key
          e.Handled = True
        End If
      End If
    ElseIf (e.KeyValue >= 48 And e.KeyValue <= 57) Then
      ' 0-9
      If sender.Text.Length = sender.MaxLength And sender.SelectionLength = 0 Then
        Select Case sender.Name
          Case "txt13A"
            txt13B.Focus()
            SendKeys.Send(Chr(e.KeyValue))
          Case "txt13B"
            txt13C.Focus()
            SendKeys.Send(Chr(e.KeyValue))
          Case "txt13C"
            'cmdOK.Focus()
        End Select
        e.SuppressKeyPress = True
        e.Handled = True
      End If
    ElseIf e.KeyValue = 8 Or e.KeyValue = 46 Or (e.KeyValue = 88 And e.Control) Or (e.KeyValue = 67 And e.Control) Or e.KeyValue = 35 Or e.KeyValue = 36 Or e.KeyValue = 37 Or e.KeyValue = 39 Or e.KeyValue = 9 Then
      'Backspace, Delete, Ctrl+C, Ctrl+X, Home, End, Left, Right, Tab
      If e.KeyValue = 8 And String.IsNullOrEmpty(sender.Text) Then
        Select Case sender.Name
          Case "txt13A"
            e.SuppressKeyPress = True
            e.Handled = True
          Case "txt13B"
            txt13A.Focus()
            txt13A.SelectionStart = txt13A.Text.Length
            txt13A.SelectionLength = 0
          Case "txt13C"
            txt13B.Focus()
            txt13B.SelectionStart = txt13B.Text.Length
            txt13B.SelectionLength = 0
        End Select
      End If
    Else
      e.SuppressKeyPress = True
      e.Handled = True
    End If
  End Sub

  Private Sub txt13_KeyUp(sender As Object, e As System.Windows.Forms.KeyEventArgs) Handles txt13A.KeyUp, txt13B.KeyUp, txt13C.KeyUp
    Dim sKey As String = txt13A.Text & txt13B.Text & txt13C.Text
    If sKey.Length = 13 Then
      Dim Key As New clsKey(CDLegal(sKey))
      If Key.IsValid Then
        errInfo.SetError(pnl13, Nothing)
      Else
        errInfo.SetError(pnl13, My.Resources.CDKEY_INVALID)
      End If
    Else
      errInfo.SetError(pnl13, Nothing)
    End If
  End Sub

  Private Sub txt16_DragDrop(sender As Object, e As System.Windows.Forms.DragEventArgs) Handles txt16A.DragDrop, txt16B.DragDrop, txt16C.DragDrop, txt16D.DragDrop
    If Not String.IsNullOrEmpty(e.Data.GetData("String")) Then
      Dim Key As String = CDLegal(e.Data.GetData("String"))
      If Key.Length = 16 Then
        txt16A.Text = Key.Substring(0, 4)
        txt16B.Text = Key.Substring(4, 4)
        txt16C.Text = Key.Substring(8, 4)
        txt16D.Text = Key.Substring(12, 4)
        e.Effect = DragDropEffects.Copy
      Else
        e.Effect = DragDropEffects.None
      End If
    End If
  End Sub

  Private Sub txt16_DragOver(sender As Object, e As System.Windows.Forms.DragEventArgs) Handles txt16A.DragOver, txt16B.DragOver, txt16C.DragOver, txt16D.DragOver
    If Not e.Data.GetDataPresent(GetType(String)) Then
      e.Effect = DragDropEffects.None
    Else
      Dim Key As String = CDLegal(e.Data.GetData(GetType(String)))
      If Key.Length = 16 Then
        e.Effect = DragDropEffects.Copy
      Else
        e.Effect = DragDropEffects.None
      End If
    End If
  End Sub

  Private Sub txt16_GotFocus(sender As Object, e As System.EventArgs) Handles txt16A.GotFocus, txt16B.GotFocus, txt16C.GotFocus, txt16D.GotFocus
    sender.SelectAll()
  End Sub

  Private Sub txt16_KeyDown(sender As Object, e As System.Windows.Forms.KeyEventArgs) Handles txt16A.KeyDown, txt16B.KeyDown, txt16C.KeyDown, txt16D.KeyDown
    Dim Key As String
    If e.KeyValue = 86 And e.Control Then
      If Not String.IsNullOrEmpty(Clipboard.GetText) Then
        Key = CDLegal(Clipboard.GetText)
        If Key.Length = 16 Then
          txt16A.Text = Key.Substring(0, 4)
          txt16B.Text = Key.Substring(4, 4)
          txt16C.Text = Key.Substring(8, 4)
          txt16D.Text = Key.Substring(12, 4)
          'cmdOK.Focus()
          e.Handled = True
        Else
          sender.text = Key
          e.Handled = True
        End If
      End If
    ElseIf (e.KeyValue >= 65 And e.KeyValue <= 90) Or (e.KeyValue >= 48 And e.KeyValue <= 57) Then
      'A-Z, 0-9
      If sender.Text.Length = sender.MaxLength And sender.SelectionLength = 0 Then
        Select Case sender.Name
          Case "txt16A"
            txt16B.Focus()
            SendKeys.Send(Chr(e.KeyValue))
          Case "txt16B"
            txt16C.Focus()
            SendKeys.Send(Chr(e.KeyValue))
          Case "txt16C"
            txt16D.Focus()
            SendKeys.Send(Chr(e.KeyValue))
          Case "txt16D"
            'cmdOK.Focus()
        End Select
        e.SuppressKeyPress = True
        e.Handled = True
      End If
    ElseIf e.KeyValue = 8 Or e.KeyValue = 46 Or (e.KeyValue = 88 And e.Control) Or (e.KeyValue = 67 And e.Control) Or e.KeyValue = 35 Or e.KeyValue = 36 Or e.KeyValue = 37 Or e.KeyValue = 39 Or e.KeyValue = 9 Then
      'Backspace, Delete, Ctrl+C, Ctrl+X, Home, End, Left, Right, Tab
      If e.KeyValue = 8 And String.IsNullOrEmpty(sender.text) And sender.SelectionLength = 0 Then
        Select Case sender.Name.ToString
          Case "txt16A"
            e.SuppressKeyPress = True
            e.Handled = True
          Case "txt16B"
            txt16A.Focus()
            txt16A.SelectionStart = txt16A.Text.Length
            txt16A.SelectionLength = 0
          Case "txt16C"
            txt16B.Focus()
            txt16B.SelectionStart = txt16B.Text.Length
            txt16B.SelectionLength = 0
          Case "txt16D"
            txt16C.Focus()
            txt16C.SelectionStart = txt16C.Text.Length
            txt16C.SelectionLength = 0
        End Select
      End If
    Else
      e.SuppressKeyPress = True
      e.Handled = True
    End If
  End Sub

  Private Sub txt16_KeyUp(sender As Object, e As System.Windows.Forms.KeyEventArgs) Handles txt16A.KeyUp, txt16B.KeyUp, txt16C.KeyUp, txt16D.KeyUp
    Dim sKey As String = txt16A.Text & txt16B.Text & txt16C.Text & txt16D.Text
    If sKey.Length = 16 Then
      Dim Key As New clsKey(CDLegal(sKey))
      If Key.IsValid Then
        errInfo.SetError(pnl16, Nothing)
      Else
        errInfo.SetError(pnl16, My.Resources.CDKEY_INVALID)
      End If
    Else
      errInfo.SetError(pnl16, Nothing)
    End If
  End Sub

  Private Sub txt26_DragDrop(sender As Object, e As System.Windows.Forms.DragEventArgs) Handles txt26A.DragDrop, txt26B.DragDrop, txt26C.DragDrop, txt26D.DragDrop, txt26E.DragDrop
    If Not String.IsNullOrEmpty(e.Data.GetData(GetType(String))) Then
      Dim Key As String = CDLegal(e.Data.GetData(GetType(String)))
      If Key.Length = 26 Then
        txt26A.Text = Key.Substring(0, 6)
        txt26B.Text = Key.Substring(6, 4)
        txt26C.Text = Key.Substring(10, 6)
        txt26D.Text = Key.Substring(16, 4)
        txt26E.Text = Key.Substring(20, 6)
        e.Effect = DragDropEffects.Copy
      Else
        e.Effect = DragDropEffects.None
      End If
    End If
  End Sub

  Private Sub txt26_DragOver(sender As Object, e As System.Windows.Forms.DragEventArgs) Handles txt26A.DragOver, txt26B.DragOver, txt26C.DragOver, txt26D.DragOver, txt26E.DragOver
    If Not e.Data.GetDataPresent(GetType(String)) Then
      e.Effect = DragDropEffects.None
    Else
      Dim Key As String = CDLegal(e.Data.GetData(GetType(String)))
      If Key.Length = 26 Then
        e.Effect = DragDropEffects.Copy
      Else
        e.Effect = DragDropEffects.None
      End If
    End If
  End Sub

  Private Sub txt26_GotFocus(sender As Object, e As System.EventArgs) Handles txt26A.GotFocus, txt26B.GotFocus, txt26C.GotFocus, txt26D.GotFocus, txt26E.GotFocus
    sender.SelectAll()
  End Sub

  Private Sub txt26_KeyDown(sender As Object, e As System.Windows.Forms.KeyEventArgs) Handles txt26A.KeyDown, txt26B.KeyDown, txt26C.KeyDown, txt26D.KeyDown, txt26E.KeyDown
    Dim Key As String
    If e.KeyValue = 86 And e.Control Then
      If Not String.IsNullOrEmpty(Clipboard.GetText) Then
        Key = CDLegal(Clipboard.GetText)
        If Key.Length = 26 Then
          txt26A.Text = Key.Substring(0, 6)
          txt26B.Text = Key.Substring(6, 4)
          txt26C.Text = Key.Substring(10, 6)
          txt26D.Text = Key.Substring(16, 4)
          txt26E.Text = Key.Substring(20, 6)
          'cmdOK.Focus()
          e.Handled = True
        Else
          sender.text = Key
          e.Handled = True
        End If
      End If
    ElseIf (e.KeyValue >= 65 And e.KeyValue <= 90) Or (e.KeyValue >= 48 And e.KeyValue <= 57) Then
      'A-Z, 0-9
      If sender.Text.Length = sender.MaxLength Then
        Select Case sender.Name
          Case "txt26A"
            txt26B.Focus()
            SendKeys.Send(Chr(e.KeyValue))
          Case "txt26B"
            txt26C.Focus()
            SendKeys.Send(Chr(e.KeyValue))
          Case "txt26C"
            txt26D.Focus()
            SendKeys.Send(Chr(e.KeyValue))
          Case "txt26D"
            txt26E.Focus()
            SendKeys.Send(Chr(e.KeyValue))
          Case "txt26E"
            'cmdOK.Focus()
        End Select
        e.SuppressKeyPress = True
        e.Handled = True
      End If
    ElseIf e.KeyValue = 8 Or e.KeyValue = 46 Or (e.KeyValue = 88 And e.Control) Or (e.KeyValue = 67 And e.Control) Or e.KeyValue = 35 Or e.KeyValue = 36 Or e.KeyValue = 37 Or e.KeyValue = 39 Or e.KeyValue = 9 Then
      If e.KeyValue = 8 And String.IsNullOrEmpty(sender.text) Then
        Select Case sender.Name
          Case "txt26A"
            e.SuppressKeyPress = True
            e.Handled = True
          Case "txt26B"
            txt26A.Focus()
            txt26A.SelectionStart = txt26A.Text.Length
            txt26A.SelectionLength = 0
          Case "txt26C"
            txt26B.Focus()
            txt26B.SelectionStart = txt26B.Text.Length
            txt26B.SelectionLength = 0
          Case "txt26D"
            txt26C.Focus()
            txt26C.SelectionStart = txt26C.Text.Length
            txt26C.SelectionLength = 0
          Case "txt26E"
            txt26D.Focus()
            txt26D.SelectionStart = txt26D.Text.Length
            txt26D.SelectionLength = 0
        End Select
      End If
      'Backspace, Delete, Ctrl+C, Ctrl+X, Home, End, Left, Right, Tab
    Else
      e.SuppressKeyPress = True
      e.Handled = True
    End If
  End Sub

  Private Sub txt26_KeyUp(sender As Object, e As System.Windows.Forms.KeyEventArgs) Handles txt26A.KeyUp, txt26B.KeyUp, txt26C.KeyUp, txt26D.KeyUp, txt26E.KeyUp
    Dim sKey As String = txt26A.Text & txt26B.Text & txt26C.Text & txt26D.Text & txt26E.Text
    If sKey.Length = 26 Then
      Dim Key As New clsKey(CDLegal(sKey))
      If Key.IsValid Then
        errInfo.SetError(pnl26, Nothing)
      Else
        errInfo.SetError(pnl26, My.Resources.CDKEY_INVALID)
      End If
    Else
      errInfo.SetError(pnl26, Nothing)
    End If
  End Sub

  Private Sub frmCDKey_Load(sender As Object, e As System.EventArgs) Handles Me.Load
    Select Case gClient
      Case BNUI.GameType.STAR, BNUI.GameType.SEXP
        ShowKeys(1)
        chk26Key.Visible = True
      Case BNUI.GameType.JSTR
        ShowKeys(1)
        chk26Key.Visible = False
      Case BNUI.GameType.D2DV, BNUI.GameType.D2XP
        ShowKeys(2)
        chk26Key.Visible = True
      Case BNUI.GameType.W2BN
        ShowKeys(2)
        chk26Key.Visible = False
      Case BNUI.GameType.WAR3, BNUI.GameType.W3XP
        ShowKeys(3)
        chk26Key.Visible = False
      Case Else
        MsgBox(ResString(My.Resources.CDKEY_CLIENT_NOSUPPORT, GameTypeToGameTitle(gClient)), MsgBoxStyle.Exclamation)
        Me.DialogResult = System.Windows.Forms.DialogResult.Cancel
        Me.Close()
    End Select
    lblBNet.Visible = chk26Key.Visible
  End Sub
End Class
