﻿Public Class frmAccountOptions
  Private Profiles() As BNUI.cConfig
  Private SaveValues As Boolean
  Private gCSSTest As Skybound.Gecko.GeckoWebBrowser = Nothing

  Private Sub cmbProduct_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles cmbProduct.SelectedIndexChanged
    Dim KeyType As Byte
    chkRealm.Enabled = False
    chkSpawn.Enabled = False
    Select Case cmbProduct.SelectedIndex
      Case 0
        If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.DRTL
        pctProduct.SizeMode = PictureBoxSizeMode.Zoom
        pctProduct.Image = My.Resources.BANNER_DIABLO
        KeyType = 1
      Case 1
        If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.DSHR
        pctProduct.SizeMode = PictureBoxSizeMode.Zoom
        pctProduct.Image = My.Resources.BANNER_DIABLO
        KeyType = 1
      Case 2
        If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.D2DV
        pctProduct.SizeMode = PictureBoxSizeMode.Zoom
        pctProduct.Image = My.Resources.LOGO_D2DV
        KeyType = 4
        chkRealm.Enabled = True
      Case 3
        If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.D2XP
        pctProduct.SizeMode = PictureBoxSizeMode.Zoom
        pctProduct.Image = My.Resources.LOGO_D2XP
        KeyType = 5
        chkRealm.Enabled = True
      Case 4
        If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.DIII
        pctProduct.SizeMode = PictureBoxSizeMode.Zoom
        pctProduct.Image = My.Resources.LOGO_DIII
        KeyType = 0
      Case 5
        If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.STAR
        pctProduct.SizeMode = PictureBoxSizeMode.Zoom
        pctProduct.Image = My.Resources.LOGO_STAR
        KeyType = 2
        chkSpawn.Enabled = True
      Case 6
        If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.SEXP
        pctProduct.SizeMode = PictureBoxSizeMode.Zoom
        pctProduct.Image = My.Resources.LOGO_SEXP
        KeyType = 2
      Case 7
        If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.SSHR
        pctProduct.SizeMode = PictureBoxSizeMode.Zoom
        pctProduct.Image = My.Resources.LOGO_SSHR
        KeyType = 0
      Case 8
        If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.JSTR
        pctProduct.SizeMode = PictureBoxSizeMode.Zoom
        pctProduct.Image = My.Resources.LOGO_JSTR
        KeyType = 2
        chkSpawn.Enabled = True
      Case 9
        If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.SCII
        pctProduct.SizeMode = PictureBoxSizeMode.Zoom
        pctProduct.Image = My.Resources.LOGO_SCII
        KeyType = 0
      Case 10
        If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.W2BN
        pctProduct.SizeMode = PictureBoxSizeMode.Zoom
        pctProduct.Image = My.Resources.LOGO_W2BN
        KeyType = 4
        chkSpawn.Enabled = True
      Case 11
        If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.WAR3
        pctProduct.SizeMode = PictureBoxSizeMode.Zoom
        pctProduct.Image = My.Resources.LOGO_WAR3
        KeyType = 6
      Case 12
        If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.W3XP
        pctProduct.SizeMode = PictureBoxSizeMode.Zoom
        pctProduct.Image = My.Resources.LOGO_W3XP
        KeyType = 7
      Case 13
        If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.WOW
        pctProduct.SizeMode = PictureBoxSizeMode.Zoom
        pctProduct.Image = My.Resources.LOGO_WOW
        KeyType = 0
      Case Else
        pctProduct.SizeMode = PictureBoxSizeMode.CenterImage
        pctProduct.Image = My.Resources.BANNER_BATTLENET
        KeyType = 0
    End Select
    Select Case KeyType
      Case 0
        txtStatString.Enabled = False
        cmbCDKey.Enabled = False
        cmbCDKey.Text = String.Empty
        If pnlConnection.Controls.Contains(chkEXPKey) Then
          pnlConnection.Controls.Remove(chkEXPKey)
          pnlConnection.Controls.Add(lblEXPKey, 0, 3)
        End If
        cmbEXPKey.Enabled = False
        cmbEXPKey.Items.Clear()
        cmbEXPKey.Text = String.Empty
      Case 1
        txtStatString.Enabled = True
        cmbCDKey.Enabled = False
        cmbCDKey.Text = String.Empty
        If pnlConnection.Controls.Contains(chkEXPKey) Then
          pnlConnection.Controls.Remove(chkEXPKey)
          pnlConnection.Controls.Add(lblEXPKey, 0, 3)
        End If
        cmbEXPKey.Enabled = False
        cmbEXPKey.Items.Clear()
        cmbEXPKey.Text = String.Empty
      Case 2
        txtStatString.Enabled = False
        cmbCDKey.Enabled = True
        If pnlConnection.Controls.Contains(chkEXPKey) Then
          pnlConnection.Controls.Remove(chkEXPKey)
          pnlConnection.Controls.Add(lblEXPKey, 0, 3)
        End If
        cmbEXPKey.Enabled = False
        cmbEXPKey.Items.Clear()
        cmbEXPKey.Text = String.Empty
      Case 3
        txtStatString.Enabled = False
        cmbCDKey.Enabled = True
        If pnlConnection.Controls.Contains(chkEXPKey) Then
          pnlConnection.Controls.Remove(chkEXPKey)
          pnlConnection.Controls.Add(lblEXPKey, 0, 3)
        End If
        cmbEXPKey.Enabled = True
      Case 4
        txtStatString.Enabled = False
        cmbCDKey.Enabled = True
        If pnlConnection.Controls.Contains(chkEXPKey) Then
          pnlConnection.Controls.Remove(chkEXPKey)
          pnlConnection.Controls.Add(lblEXPKey, 0, 3)
        End If
        cmbEXPKey.Enabled = False
        cmbEXPKey.Items.Clear()
        cmbEXPKey.Text = String.Empty
      Case 5
        txtStatString.Enabled = False
        cmbCDKey.Enabled = True
        If pnlConnection.Controls.Contains(chkEXPKey) Then
          pnlConnection.Controls.Remove(chkEXPKey)
          pnlConnection.Controls.Add(lblEXPKey, 0, 3)
        End If
        cmbEXPKey.Enabled = True
      Case 6
        txtStatString.Enabled = False
        cmbCDKey.Enabled = True
        If pnlConnection.Controls.Contains(lblEXPKey) Then
          pnlConnection.Controls.Remove(lblEXPKey)
          pnlConnection.Controls.Add(chkEXPKey, 0, 3)
        End If
        If Profiles(cmbProfile.SelectedIndex).Account.Client.EXPKey.ProductVal = 0 Then
          cmbEXPKey.Enabled = False
          cmbEXPKey.Items.Clear()
          cmbEXPKey.Text = String.Empty
        Else
          chkEXPKey.Checked = True
          cmbEXPKey.Enabled = True
        End If
      Case 7
        txtStatString.Enabled = False
        cmbCDKey.Enabled = True
        If pnlConnection.Controls.Contains(chkEXPKey) Then
          pnlConnection.Controls.Remove(chkEXPKey)
          pnlConnection.Controls.Add(lblEXPKey, 0, 3)
        End If
        cmbEXPKey.Enabled = True
    End Select
    If SaveValues Then LoadKeys()
    cmdNewKey.Enabled = cmbCDKey.Enabled
    cmdDelKey.Enabled = cmbCDKey.Enabled
    cmdNewExp.Enabled = cmbEXPKey.Enabled
    cmdDelExp.Enabled = cmbEXPKey.Enabled
    lblCDKey.Enabled = cmbCDKey.Enabled
    lblEXPKey.Enabled = cmbEXPKey.Enabled
    lblStatString.Enabled = txtStatString.Enabled
    cmdEditStatstring.Enabled = txtStatString.Enabled
    LoadGateways(GameIsBN2(Profiles(cmbProfile.SelectedIndex).Account.Client.Product))
    If GameIsBN2(Profiles(cmbProfile.SelectedIndex).Account.Client.Product) OrElse GetGateways() Is Nothing Then
      cmbServer.Text = Profiles(cmbProfile.SelectedIndex).Server
    Else
      cmbServer.Text = GetGatewayName(Profiles(cmbProfile.SelectedIndex).Server)
    End If
  End Sub

  Private Sub LoadKeys()
    If cmbCDKey.Enabled Then
      cmbCDKey.Items.Clear()
      If Profiles(cmbProfile.SelectedIndex).Account.Client.Product = 0 Then Exit Sub
      Dim KeyList = From CDKey As Xml.Linq.XElement In GetCDKeys(False) Where CDKey.Name.LocalName = GetProd.ToString Select CDKey
      If KeyList.Count > 0 Then
        For I As Integer = 0 To KeyList.Count - 1
          Dim tmpKey As BNUI.ProductKey = GrabKeyStruct(KeyList(I))
          Dim cTmpKey As New clsKey(tmpKey)
          If cTmpKey.IsValid Then
            cmbCDKey.Items.Add(cTmpKey.Key)
          Else
            cmbCDKey.Items.Add(KeyList(I).Value)
          End If
        Next
      End If
      Dim cKey As New clsKey(Profiles(cmbProfile.SelectedIndex).Account.Client.CDKey)
      If ProdMatch(GetProd, cKey.Product, False) Then
        cmbCDKey.Text = cKey.Key
        If String.IsNullOrEmpty(cmbCDKey.Text) Then
          If cmbCDKey.Items.Count > 0 Then
            cmbCDKey.SelectedIndex = 0
          Else
            If Profiles(cmbProfile.SelectedIndex).Account.Client.CDKey.ProductVal <> 0 Then
              cmbCDKey.Items.Add(cKey.Key)
              cmbCDKey.SelectedIndex = cmbCDKey.Items.Count - 1
            End If
          End If
        End If
      Else
        If cmbCDKey.Items.Count > 0 Then cmbCDKey.SelectedIndex = 0
      End If
    End If
    If cmbEXPKey.Enabled Then
      cmbEXPKey.Items.Clear()
      Dim gProduct As BNUI.GameType = Profiles(cmbProfile.SelectedIndex).Account.Client.Product
      If Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.WAR3 Then gProduct = BNUI.GameType.W3XP
      Dim ExpList = From CDKey As Xml.Linq.XElement In GetCDKeys(True) Where CDKey.Name.LocalName = gProduct.ToString Select CDKey
      If ExpList.Count > 0 Then
        For I As Integer = 0 To ExpList.Count - 1
          Dim tmpKey As BNUI.ProductKey = GrabKeyStruct(ExpList(I))
          Dim cTmpKey As New clsKey(tmpKey)
          If cTmpKey.IsValid Then
            cmbEXPKey.Items.Add(cTmpKey.Key)
          Else
            cmbEXPKey.Items.Add(ExpList(I).Value)
          End If
        Next
      End If
      Dim cXKey As New clsKey(Profiles(cmbProfile.SelectedIndex).Account.Client.EXPKey)
      If ProdMatch(GetProd, cXKey.Product, True) Then
        cmbEXPKey.Text = cXKey.Key
        If String.IsNullOrEmpty(cmbEXPKey.Text) Then
          If cmbEXPKey.Items.Count > 0 Then
            cmbEXPKey.SelectedIndex = 0
          Else
            If Profiles(cmbProfile.SelectedIndex).Account.Client.EXPKey.ProductVal <> 0 Then
              cmbEXPKey.Items.Add(cXKey.Key)
              cmbEXPKey.SelectedIndex = cmbEXPKey.Items.Count - 1
            End If
          End If
        End If
      Else
        If cmbEXPKey.Items.Count > 0 Then cmbEXPKey.SelectedIndex = 0
      End If
    End If
  End Sub

  Private Sub cmdOK_Click(sender As System.Object, e As System.EventArgs) Handles cmdOK.Click
    Dim I As Integer
    If UBound(Profiles) < ProfileCount() - 1 Then
      For I = UBound(Profiles) + 1 To ProfileCount() - 1
        RemoveSettings(I)
      Next
    End If
    For I = 0 To UBound(Profiles)
      SaveSettings(I, Profiles(I))
    Next
    Me.Close()
    frmMain.LoadProfiles()
  End Sub

  Private Sub cmdCancel_Click(sender As System.Object, e As System.EventArgs) Handles cmdCancel.Click
    Me.Close()
  End Sub

  Private Sub frmAccountOptions_FormClosing(sender As Object, e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
    My.Settings.Options_Size = Me.Size
  End Sub

  Private Sub LoadGateways(Optional ByVal Expansion As Boolean = False)
    cmbServer.Items.Clear()
    If Expansion Then
      cmbServer.Items.Add("US.Logon.Battle.net")
      cmbServer.Items.Add("EU.Logon.Battle.net")
      cmbServer.Items.Add("CN.Logon.Battle.net")
      cmbServer.Items.Add("KR.Logon.Battle.net")
    Else
      If GetGateways() Is Nothing Then
        cmbServer.Items.Add("USWest.Battle.net")
        cmbServer.Items.Add("USEast.Battle.net")
        cmbServer.Items.Add("Asia.Battle.net")
        cmbServer.Items.Add("Europe.Battle.net")
      Else
        For Each GatewayURL As String In GetGateways()
          cmbServer.Items.Add(GetGatewayName(GatewayURL))
        Next
      End If
    End If
  End Sub

  Public Sub frmAccountOptions_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
    LoadGateways()
    SaveValues = False
    Dim lStart As Integer
    If frmMain.selProfile = -1 Then
      If frmMain.tbsBots.TabCount > 0 Then
        lStart = frmMain.tbsBots.SelectedIndex
      Else
        lStart = 0
      End If
    Else
      lStart = frmMain.selProfile
      frmMain.selProfile = -1
    End If
    gCSSTest = New Skybound.Gecko.GeckoWebBrowser
    gCSSTest.Dock = DockStyle.None
    gCSSTest.Margin = New Padding(0)
    gCSSTest.Padding = New Padding(0)
    gCSSTest.NoDefaultContextMenu = True
    Me.Controls.Add(gCSSTest)
    gCSSTest.Location = New Point(Me.Width, Me.Height)
    gCSSTest.Size = New Size(320, 240)
    cmbCSSFontFamily.Items.Clear()
    For Each sFont As FontFamily In FontFamily.Families
      cmbCSSFontFamily.Items.Add(sFont.Name)
    Next
    cmbProfile.Items.Clear()
    If ProfileCount() = 0 Then
      cmdNewProfile.PerformClick()
    Else
      ReDim Profiles(ProfileCount() - 1)
      Dim I As Integer
      For I = 0 To ProfileCount() - 1
        LoadSettings(I, Profiles(I))
        If Profiles(I).Account.ProfileName Is Nothing Then
          If GameIsBN2(Profiles(I).Account.Client.Product) Then
            Profiles(I).Account.ProfileName = Profiles(I).Account.Username & "@" & Profiles(I).Server.Substring(0, 2)
          ElseIf GetGateways() Is Nothing Then
            Profiles(I).Account.ProfileName = Profiles(I).Account.Username & "@" & Profiles(I).Server
          Else
            Profiles(I).Account.ProfileName = Profiles(I).Account.Username & "@" & GetGatewayName(Profiles(I).Server, Profiles(I).Account.Client.Product = BNUI.GameType.WAR3 Or Profiles(I).Account.Client.Product = BNUI.GameType.W3XP)
          End If
        End If
        cmbProfile.Items.Add(Profiles(I).Account.ProfileName)
      Next
      cmbProfile.SelectedIndex = lStart
    End If
    Me.Tag = Nothing
    Me.Top = frmMain.Top + (frmMain.Height / 2) - (Me.Height / 2)
    If Me.Top < 0 Then Me.Top = 0
    Me.Left = frmMain.Left + (frmMain.Width / 2) - (Me.Width / 2)
    If Me.Left < 0 Then Me.Left = 0
    SaveValues = True
    Me.Size = My.Settings.Options_Size
  End Sub

  Private Sub cmdNewProfile_Click(sender As System.Object, e As System.EventArgs) Handles cmdNewProfile.Click
    If Profiles Is Nothing Then
      ReDim Profiles(0)
    Else
      ReDim Preserve Profiles(UBound(Profiles) + 1)
    End If
    LoadSettings(UBound(Profiles), Profiles(UBound(Profiles)))
    cmbProfile.Items.Add(ResString(My.Resources.ACCOUNTOPTIONS_PROFILE_DEFAULT, cmbProfile.Items.Count + 1))
    cmbProfile.SelectedIndex = cmbProfile.Items.Count - 1
    cmbProfile_SelectedIndexChanged(sender, e)
  End Sub

  Private Sub cmdRemProfile_Click(sender As System.Object, e As System.EventArgs) Handles cmdRemProfile.Click
    If cmbProfile.SelectedIndex > -1 Then
      If MsgBox(ResString(My.Resources.DELETE_CONFIRM, cmbProfile.SelectedItem), vbYesNo + vbQuestion) = vbYes Then
        Dim I As Integer
        For I = cmbProfile.SelectedIndex + 1 To UBound(Profiles)
          Profiles(I - 1) = Profiles(I)
        Next I
        ReDim Preserve Profiles(UBound(Profiles) - 1)
        cmbProfile.Items.Remove(cmbProfile.SelectedItem)
        cmbProfile.SelectedIndex = 0
      End If
    End If
  End Sub

  Private Sub txtAccount_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtAccount.TextChanged
    If SaveValues Then
      Profiles(cmbProfile.SelectedIndex).Account.Username = txtAccount.Text
      If chkProfileName.Checked Then
        chkProfileName_CheckedChanged(sender, e)
        txtProfile_TextChanged(sender, e)
      End If
    End If
  End Sub

  Private Function GetProd() As BNUI.GameType
    Dim sProd As BNUI.GameType = Profiles(cmbProfile.SelectedIndex).Account.Client.Product
    If sProd = BNUI.GameType.SEXP Or sProd = BNUI.GameType.JSTR Then sProd = BNUI.GameType.STAR
    If sProd = BNUI.GameType.D2XP Then sProd = BNUI.GameType.D2DV
    If sProd = BNUI.GameType.W3XP Then sProd = BNUI.GameType.WAR3
    GetProd = sProd
  End Function

  Private Sub cmbProfile_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles cmbProfile.SelectedIndexChanged
    If cmbProfile.SelectedIndex > -1 And String.IsNullOrEmpty(cmbProfile.Tag) Then
      SaveValues = False
      With Profiles(cmbProfile.SelectedIndex)
        txtProfile.Text = .Account.ProfileName
        txtAccount.Text = .Account.Username
        txtPassword.Text = .Account.Password
        txtEMail.Text = .Account.EMail
        Select Case .Account.Client.Product
          Case BNUI.GameType.DRTL : cmbProduct.SelectedIndex = 0
          Case BNUI.GameType.DSHR : cmbProduct.SelectedIndex = 1
          Case BNUI.GameType.D2DV : cmbProduct.SelectedIndex = 2
          Case BNUI.GameType.D2XP : cmbProduct.SelectedIndex = 3
          Case BNUI.GameType.DIII : cmbProduct.SelectedIndex = 4
          Case BNUI.GameType.STAR : cmbProduct.SelectedIndex = 5
          Case BNUI.GameType.SEXP : cmbProduct.SelectedIndex = 6
          Case BNUI.GameType.SSHR : cmbProduct.SelectedIndex = 7
          Case BNUI.GameType.JSTR : cmbProduct.SelectedIndex = 8
          Case BNUI.GameType.SCII : cmbProduct.SelectedIndex = 9
          Case BNUI.GameType.W2BN : cmbProduct.SelectedIndex = 10
          Case BNUI.GameType.WAR3 : cmbProduct.SelectedIndex = 11
          Case BNUI.GameType.W3XP : cmbProduct.SelectedIndex = 12
          Case BNUI.GameType.WOW : cmbProduct.SelectedIndex = 13
        End Select
        txtStatString.Text = .Account.StatString
        chkSpawn.Checked = .Account.Client.Spawn
        LoadKeys()
        txtHomeChannel.Text = .Account.HomeChannel
        LoadGateways(GameIsBN2(.Account.Client.Product))
        If GameIsBN2(.Account.Client.Product) OrElse GetGateways() Is Nothing Then
          cmbServer.Text = .Server
        Else
          cmbServer.Text = GetGatewayName(.Server)
        End If
        If String.IsNullOrEmpty(cmbServer.Text) Then cmbServer.Text = .Server
        If GameIsBN2(.Account.Client.Product) Then
          chkProfileName.Checked = .Account.ProfileName = .Account.Username & "@" & .Server.Substring(0, 2)
        Else
          chkProfileName.Checked = .Account.ProfileName = .Account.Username & "@" & GetGatewayName(.Server, .Account.Client.Product = BNUI.GameType.WAR3 Or .Account.Client.Product = BNUI.GameType.W3XP)
        End If
        chkProfileName_CheckedChanged(sender, e)
        chkRealm.Checked = .Account.Client.D2Realm
        chkPubAway.Checked = .Display.PubAway
        chkAway.Checked = (.AutoAway <> 0)
        If chkAway.Checked Then
          cmbAway.Value = .AutoAway
        Else
          cmbAway.Value = 20
        End If
        chkAway_CheckedChanged(sender, e)
        chkUTF8.Checked = .UTF8
        txtWhisFwd.Text = .WhisFwd
        If .Display.MaxLines < MAXLINE_MIN Then
          cmbLines.Value = MAXLINE_MIN
        ElseIf .Display.MaxLines > MAXLINE_MAX Then
          cmbLines.Value = MAXLINE_MAX
        Else
          cmbLines.Value = .Display.MaxLines
        End If
        chkD2Emote.Checked = .Display.D2Emote
        chkJoinLeave.Checked = .Display.JoinLeave
        chkLog.Checked = .LogChat
        chkSpam.Checked = .Display.PreventSpam
        chkEmoticons.Checked = .Display.Emoticons
        txtTimeStamp.Text = .Display.TimeStamp
        cmbWhisWin.SelectedIndex = .Display.WhisWin
        chkRichText.Checked = .Display.RichText
        chkAccountInfo.Checked = .Display.AccountInfo
        chkUDP.Checked = .Account.Client.UDPPlug
        chkAutoConnect.Checked = .AutoConnect
        chkAds.Checked = .Display.GetAds
        cmbPing.SelectedIndex = IIf(.PingSpoof < 4, .PingSpoof, 4)
        txtPing.Enabled = .PingSpoof > 3
        If .PingSpoof > 3 Then
          txtPing.Text = .PingSpoof
        Else
          txtPing.Text = String.Empty
        End If
        If .AutoReconnect > 2 Then
          chkReconnect.Checked = True
          cmbReconnect.Value = .AutoReconnect
        Else
          chkReconnect.Checked = False
          cmbReconnect.Value = 3
        End If
        chkProxy.Checked = .Proxy.Use
        If Split(.Proxy.IP, ".").Length = 4 Then
          txtProxyIP1.Text = Split(.Proxy.IP, ".")(0)
          txtProxyIP2.Text = Split(.Proxy.IP, ".")(1)
          txtProxyIP3.Text = Split(.Proxy.IP, ".")(2)
          txtProxyIP4.Text = Split(.Proxy.IP, ".")(3)
        Else
          txtProxyIP1.Text = "127"
          txtProxyIP2.Text = "0"
          txtProxyIP3.Text = "0"
          txtProxyIP4.Text = "1"
        End If
        If .Proxy.Port > 0 Then
          cmbProxyPort.Value = .Proxy.Port
        Else
          cmbProxyPort.Value = 1080
        End If
        Select Case .Proxy.Ver
          Case BNUI.ProxyType.SOCKS4
            optSOCKS4.Checked = True
          Case BNUI.ProxyType.SOCKS5
            optSOCKS5.Checked = True
          Case BNUI.ProxyType.HTTP
            optHTTP.Checked = True
        End Select
        chkProxy_CheckedChanged(sender, e)
        cmbIdleTime.Value = IIf(.Idle.IdleTime > 0, .Idle.IdleTime, 1)
        chkIdleSongChange.Checked = .Idle.IdleOnSong
        Select Case .Idle.IdleText
          Case "/me Uptime [Sys: %u][Bot: %b][Net: %o]"
            optIdleUptime.Checked = True
            optIdleVer.Checked = False
            optIdleSong.Checked = False
            optIdleText.Checked = False
            txtIdleText.Text = String.Empty
          Case "/me is running %v"
            optIdleVer.Checked = True
            optIdleSong.Checked = False
            optIdleText.Checked = False
            optIdleUptime.Checked = False
            txtIdleText.Text = String.Empty
          Case "/me is listening to %s"
            optIdleText.Checked = False
            optIdleUptime.Checked = False
            optIdleVer.Checked = False
            optIdleSong.Checked = True
            txtIdleText.Text = String.Empty
          Case Else
            optIdleText.Checked = True
            optIdleUptime.Checked = False
            optIdleVer.Checked = False
            optIdleSong.Checked = False
            txtIdleText.Text = .Idle.IdleText
        End Select
        chkIdle.Checked = .Idle.IdleOn
        chkIdle_CheckedChanged(sender, e)
        If String.IsNullOrEmpty(.Display.UI.CustomCSS) Then
          cmdCSSDefault_Click(sender, e)
          cmdCSSCreate_Click(sender, e)
        Else
          txtCSS.Text = Replace(.Display.UI.CustomCSS, "\n", vbNewLine)
        End If
      End With
      SaveValues = True
    End If
  End Sub

  Private Sub txtPassword_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtPassword.TextChanged
    txtPassword.BackColor = IIf(txtPassword.TextLength > 12, Color.DarkRed, Color.Black)
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Password = txtPassword.Text
  End Sub

  Private Sub txtEMail_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtEMail.TextChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.EMail = txtEMail.Text
  End Sub

  Private Sub txtHomeChannel_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtHomeChannel.TextChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.HomeChannel = txtHomeChannel.Text
  End Sub

  Private Sub cmbServer_TextChanged(sender As Object, e As System.EventArgs) Handles cmbServer.TextChanged
    If SaveValues Then
      If GameIsBN2(Profiles(cmbProfile.SelectedIndex).Account.Client.Product) OrElse GetGateways() Is Nothing Then
        Profiles(cmbProfile.SelectedIndex).Server = cmbServer.Text
      Else
        Profiles(cmbProfile.SelectedIndex).Server = (From GatewayURL As String In GetGateways() Where StrComp(GetGatewayName(GatewayURL), cmbServer.Text, CompareMethod.Text) = 0 Select GatewayURL)(0)
      End If
      If String.IsNullOrEmpty(Profiles(cmbProfile.SelectedIndex).Server) Then Profiles(cmbProfile.SelectedIndex).Server = cmbServer.Text
      If chkProfileName.Checked Then
        chkProfileName_CheckedChanged(sender, e)
        txtProfile_TextChanged(sender, e)
      End If
    End If
  End Sub

  Private Sub chkSpawn_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkSpawn.CheckedChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Client.Spawn = chkSpawn.Checked
  End Sub

  Private Sub cmdNewKey_Click(sender As System.Object, e As System.EventArgs) Handles cmdNewKey.Click
    Using dlgKey As New frmCDKey(Profiles(cmbProfile.SelectedIndex).Account.Client.Product)
      dlgKey.ShowDialog(Me)
      If dlgKey.DialogResult = DialogResult.OK Then
        If cmbCDKey.Items.Contains(dlgKey.CDKey) Then
          MsgBox(ResString(My.Resources.ACCOUNTOPTIONS_CDKEY_DUPLICATE, dlgKey.CDKey), MsgBoxStyle.Exclamation)
        Else
          AddCDKey(dlgKey.CDKey, GetProd)
          cmbCDKey.Items.Add(dlgKey.CDKey)
          cmbCDKey.SelectedIndex = cmbCDKey.Items.Count - 1
        End If
      End If
    End Using
  End Sub

  Private Sub cmbCDKey_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles cmbCDKey.SelectedIndexChanged
    If SaveValues Then
      Dim sKey As New clsKey(cmbCDKey.Text)
      Profiles(cmbProfile.SelectedIndex).Account.Client.CDKey.ProductVal = sKey.Product
      Profiles(cmbProfile.SelectedIndex).Account.Client.CDKey.PublicVal = sKey.PublicVal
      Profiles(cmbProfile.SelectedIndex).Account.Client.CDKey.PrivateVal = sKey.PrivateVal
      Profiles(cmbProfile.SelectedIndex).Account.Client.CDKey.PrivateVal26 = sKey.PrivateVal26
    End If
  End Sub

  Private Sub cmbEXPKey_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles cmbEXPKey.SelectedIndexChanged
    If SaveValues Then
      Dim sKey As New clsKey(cmbEXPKey.Text)
      Profiles(cmbProfile.SelectedIndex).Account.Client.EXPKey.ProductVal = sKey.Product
      Profiles(cmbProfile.SelectedIndex).Account.Client.EXPKey.PublicVal = sKey.PublicVal
      Profiles(cmbProfile.SelectedIndex).Account.Client.EXPKey.PrivateVal = sKey.PrivateVal
      Profiles(cmbProfile.SelectedIndex).Account.Client.EXPKey.PrivateVal26 = sKey.PrivateVal26
    End If
  End Sub

  Private Sub cmdDelKey_Click(sender As System.Object, e As System.EventArgs) Handles cmdDelKey.Click
    RemCDKey(cmbCDKey.Text, GetProd)
    cmbCDKey.Items.Remove(cmbCDKey.SelectedItem)
  End Sub

  Private Sub cmdNewExp_Click(sender As System.Object, e As System.EventArgs) Handles cmdNewExp.Click
    Dim gProduct As BNUI.GameType = Profiles(cmbProfile.SelectedIndex).Account.Client.Product
    If Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.WAR3 Then gProduct = BNUI.GameType.W3XP
    Using dlgKey As New frmCDKey(gProduct)
      dlgKey.ShowDialog(Me)
      If dlgKey.DialogResult = DialogResult.OK Then
        If cmbEXPKey.Items.Contains(dlgKey.CDKey) Then
          MsgBox(ResString(My.Resources.ACCOUNTOPTIONS_EXPKEY_DUPLICATE, dlgKey.CDKey), MsgBoxStyle.Exclamation)
        Else
          AddCDKey(dlgKey.CDKey, gProduct)
          cmbEXPKey.Items.Add(dlgKey.CDKey)
          cmbEXPKey.SelectedIndex = cmbEXPKey.Items.Count - 1
        End If
      End If
    End Using
  End Sub

  Private Sub cmdDelExp_Click(sender As System.Object, e As System.EventArgs) Handles cmdDelExp.Click
    Dim gProduct As BNUI.GameType = Profiles(cmbProfile.SelectedIndex).Account.Client.Product
    If Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.WAR3 Then gProduct = BNUI.GameType.W3XP
    RemCDKey(cmbEXPKey.Text, gProduct)
    cmbEXPKey.Items.Remove(cmbEXPKey.SelectedItem)
  End Sub

  Private Sub chkUTF8_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkUTF8.CheckedChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).UTF8 = chkUTF8.Checked
  End Sub

  Private Sub chkUDP_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkUDP.CheckedChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Client.UDPPlug = chkUDP.Checked
  End Sub

  Private Sub txtStatString_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtStatString.TextChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.StatString = txtStatString.Text
  End Sub

  Private Sub optIdle_Click(sender As Object, e As System.EventArgs) Handles optIdleText.Click, optIdleSong.Click, optIdleVer.Click, optIdleUptime.Click
    optIdleText.Checked = False
    optIdleSong.Checked = False
    optIdleVer.Checked = False
    optIdleUptime.Checked = False
    sender.checked = True
    If SaveValues Then
      If sender.Name.ToString = "optIdleText" Then
        Profiles(cmbProfile.SelectedIndex).Idle.IdleText = txtIdleText.Text
      Else
        Profiles(cmbProfile.SelectedIndex).Idle.IdleText = sender.Tag
      End If
    End If
  End Sub

  Private Sub chkRealm_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkRealm.CheckedChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Account.Client.D2Realm = chkRealm.Checked
  End Sub

  Private Sub chkPubAway_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkPubAway.CheckedChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Display.PubAway = chkPubAway.Checked
  End Sub

  Private Sub chkAway_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkAway.CheckedChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).AutoAway = IIf(chkAway.Checked, cmbAway.Value, 0)
    cmbAway.Enabled = chkAway.Checked
  End Sub

  Private Sub txtWhisFwd_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtWhisFwd.TextChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).WhisFwd = txtWhisFwd.Text
  End Sub

  Private Sub cmbLines_ValueChanged(sender As System.Object, e As System.EventArgs) Handles cmbLines.ValueChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Display.MaxLines = cmbLines.Value
  End Sub

  Private Sub chkD2Emote_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkD2Emote.CheckedChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Display.D2Emote = chkD2Emote.Checked
  End Sub

  Private Sub chkJoinLeave_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkJoinLeave.CheckedChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Display.JoinLeave = chkJoinLeave.Checked
  End Sub

  Private Sub chkLog_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkLog.CheckedChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).LogChat = chkLog.Checked
  End Sub

  Private Sub chkSpam_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkSpam.CheckedChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Display.PreventSpam = chkSpam.Checked
  End Sub

  Private Sub chkEmoticons_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkEmoticons.CheckedChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Display.Emoticons = chkEmoticons.Checked
  End Sub

  Private Sub txtTimeStamp_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtTimeStamp.TextChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Display.TimeStamp = txtTimeStamp.Text
  End Sub

  Private Sub cmbWhisWin_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles cmbWhisWin.SelectedIndexChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Display.WhisWin = cmbWhisWin.SelectedIndex
  End Sub

  Private Sub chkRichText_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkRichText.CheckedChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Display.RichText = chkRichText.Checked
  End Sub

  Private Sub chkAccountInfo_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkAccountInfo.CheckedChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Display.AccountInfo = chkAccountInfo.Checked
  End Sub

  Private Sub chkAutoConnect_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkAutoConnect.CheckedChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).AutoConnect = chkAutoConnect.Checked
  End Sub

  Private Sub chkAds_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkAds.CheckedChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Display.GetAds = chkAds.Checked
  End Sub

  Private Sub cmbPing_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles cmbPing.SelectedIndexChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).PingSpoof = cmbPing.SelectedIndex
    txtPing.Enabled = cmbPing.SelectedIndex = 4
  End Sub

  Private Sub txtPing_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtPing.TextChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).PingSpoof = IIf(Not String.IsNullOrEmpty(txtPing.Text), txtPing.Text, 0)
  End Sub

  Private Sub chkReconnect_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkReconnect.CheckedChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).AutoReconnect = IIf(chkReconnect.Checked, cmbReconnect.Value, 0)
    cmbReconnect.Enabled = chkReconnect.Checked
  End Sub

  Private Sub cmbAway_ValueChanged(sender As System.Object, e As System.EventArgs) Handles cmbAway.ValueChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).AutoAway = cmbAway.Value
  End Sub

  Private Sub cmbReconnect_ValueChanged(sender As System.Object, e As System.EventArgs) Handles cmbReconnect.ValueChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).AutoReconnect = cmbReconnect.Value
  End Sub

  Private Sub chkProxy_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkProxy.CheckedChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Proxy.Use = chkProxy.Checked
    If chkProxy.Checked Then
      lblProxyIP.Enabled = True
      txtProxyIP1.Enabled = True
      txtProxyIP2.Enabled = True
      txtProxyIP3.Enabled = True
      txtProxyIP4.Enabled = True
      lblProxyPort.Enabled = True
      cmbProxyPort.Enabled = True
      optHTTP.Enabled = True
      optSOCKS4.Enabled = True
      optSOCKS5.Enabled = True
    Else
      lblProxyIP.Enabled = False
      txtProxyIP1.Enabled = False
      txtProxyIP2.Enabled = False
      txtProxyIP3.Enabled = False
      txtProxyIP4.Enabled = False
      lblProxyPort.Enabled = False
      cmbProxyPort.Enabled = False
      optHTTP.Enabled = False
      optSOCKS4.Enabled = False
      optSOCKS5.Enabled = False
    End If
  End Sub

  Private Sub txtProxyIP_KeyDown(sender As Object, e As System.Windows.Forms.KeyEventArgs) Handles txtProxyIP1.KeyDown, txtProxyIP2.KeyDown, txtProxyIP3.KeyDown, txtProxyIP4.KeyDown
    Dim IP As String
    If e.KeyValue = 86 And e.Control Then
      If Len(Clipboard.GetText) > 0 Then
        IP = Clipboard.GetText
        If Split(IP, ".").Length = 4 Then
          Dim sIP() As String = Split(IP, ".")
          txtProxyIP1.Text = Val(sIP(0).Trim.Replace(vbCr, String.Empty).Replace(vbLf, String.Empty)).ToString.Trim
          txtProxyIP2.Text = Val(sIP(1).Trim.Replace(vbCr, String.Empty).Replace(vbLf, String.Empty)).ToString.Trim
          txtProxyIP3.Text = Val(sIP(2).Trim.Replace(vbCr, String.Empty).Replace(vbLf, String.Empty)).ToString.Trim
          If InStr(sIP(3), ":") > 0 Then
            txtProxyIP4.Text = Val(Split(sIP(3), ":")(0).Trim.Replace(vbCr, String.Empty).Replace(vbLf, String.Empty)).ToString.Trim
            cmbProxyPort.Value = Val(Split(sIP(3), ":")(1).Trim.Replace(vbCr, String.Empty).Replace(vbLf, String.Empty)).ToString.Trim
          Else
            txtProxyIP4.Text = Val(sIP(3).Trim.Replace(vbCr, String.Empty).Replace(vbLf, String.Empty)).ToString.Trim
          End If
          e.Handled = True
          e.SuppressKeyPress = True
        Else
          sender.text = IP
          e.Handled = True
          e.SuppressKeyPress = True
        End If
      End If
    ElseIf (e.KeyValue >= 48 And e.KeyValue <= 57) Then
      ' 0-9
      If sender.Text.Length = sender.MaxLength And sender.SelectionLength = 0 Then
        Select Case sender.Name
          Case "txtProxyIP1"
            txtProxyIP2.Focus()
            SendKeys.Send(Chr(e.KeyValue))
          Case "txtProxyIP2"
            txtProxyIP3.Focus()
            SendKeys.Send(Chr(e.KeyValue))
          Case "txtProxyIP3"
            txtProxyIP4.Focus()
            SendKeys.Send(Chr(e.KeyValue))
          Case "txtProxyIP4"
            Beep()
        End Select
        e.SuppressKeyPress = True
        e.Handled = True
      End If
    ElseIf e.KeyCode = Keys.Back Or e.KeyCode = Keys.Delete Or (e.KeyCode = Keys.X And e.Control) Or (e.KeyCode = Keys.C And e.Control) Or e.KeyCode = Keys.Home Or e.KeyCode = Keys.End Or e.KeyCode = Keys.Left Or e.KeyCode = Keys.Right Or e.KeyCode = Keys.Tab Then
      'Backspace, Delete, Ctrl+C, Ctrl+X, Home, End, Left, Right, Tab
      If e.KeyCode = Keys.Back And String.IsNullOrEmpty(sender.text) Then
        Select Case sender.Name
          Case "txtProxyIP1"
            Beep()
            e.SuppressKeyPress = True
            e.Handled = True
          Case "txtProxyIP2"
            txtProxyIP1.Focus()
            txtProxyIP1.SelectionStart = txtProxyIP1.Text.Length
            txtProxyIP1.SelectionLength = 0
          Case "txtProxyIP3"
            txtProxyIP2.Focus()
            txtProxyIP2.SelectionStart = txtProxyIP2.Text.Length
            txtProxyIP2.SelectionLength = 0
          Case "txtProxyIP4"
            txtProxyIP3.Focus()
            txtProxyIP3.SelectionStart = txtProxyIP3.Text.Length
            txtProxyIP3.SelectionLength = 0
        End Select
      End If
    ElseIf e.KeyCode = Keys.OemPeriod Then
      Select Case sender.Name
        Case "txtProxyIP1"
          txtProxyIP2.Focus()
        Case "txtProxyIP2"
          txtProxyIP3.Focus()
        Case "txtProxyIP3"
          txtProxyIP4.Focus()
        Case "txtProxyIP4"
          Beep()
      End Select
      e.Handled = True
      e.SuppressKeyPress = True
    Else
      e.SuppressKeyPress = True
      e.Handled = True
    End If
  End Sub

  Private Sub txtProxyIP1_KeyUp(sender As Object, e As System.Windows.Forms.KeyEventArgs) Handles txtProxyIP1.KeyUp
    If e.Control And e.KeyCode = Keys.V Then
      e.Handled = True
      e.SuppressKeyPress = True
    End If
  End Sub

  Private Sub txtProxyIP_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtProxyIP1.TextChanged, txtProxyIP2.TextChanged, txtProxyIP3.TextChanged, txtProxyIP4.TextChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Proxy.IP = txtProxyIP1.Text & "." & txtProxyIP2.Text & "." & txtProxyIP3.Text & "." & txtProxyIP4.Text
  End Sub

  Private Sub chkIdleSongChange_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkIdleSongChange.CheckedChanged
    If chkIdleSongChange.Checked Then
      If SaveValues Then Profiles(cmbProfile.SelectedIndex).Idle.IdleOnSong = True
      lblIdleTime.Enabled = False
      cmbIdleTime.Enabled = False
      lblIdleTimeMin.Enabled = False
    Else
      If SaveValues Then Profiles(cmbProfile.SelectedIndex).Idle.IdleOnSong = False
      lblIdleTime.Enabled = True
      cmbIdleTime.Enabled = True
      lblIdleTimeMin.Enabled = True
      'If Profiles(cmbProfile.SelectedIndex).IdleTime = -1 Then cmbIdleTime_ValueChanged(sender, e)
    End If
  End Sub

  Private Sub chkIdle_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkIdle.CheckedChanged
    If chkIdle.Checked Then
      chkIdleSongChange.Enabled = True
      lblIdleTime.Enabled = Not chkIdleSongChange.Checked
      cmbIdleTime.Enabled = Not chkIdleSongChange.Checked
      lblIdleTimeMin.Enabled = Not chkIdleSongChange.Checked
      optIdleText.Enabled = True
      txtIdleText.Enabled = True
      lblIdleText.Enabled = True
      optIdleSong.Enabled = True
      lblIdleSong.Enabled = True
      optIdleVer.Enabled = True
      lblIdleVer.Enabled = True
      optIdleUptime.Enabled = True
      lblIdleUptime.Enabled = True
      lstVars.Enabled = True
      lstVars2.Enabled = True
      If SaveValues Then
        Profiles(cmbProfile.SelectedIndex).Idle.IdleOn = True
        chkIdleSongChange_CheckedChanged(sender, e)
        If optIdleText.Checked Then
          optIdle_Click(optIdleText, e)
        ElseIf optIdleVer.Checked Then
          optIdle_Click(optIdleVer, e)
        ElseIf optIdleSong.Checked Then
          optIdle_Click(optIdleSong, e)
        Else
          optIdle_Click(optIdleUptime, e)
        End If
      End If
    Else
      chkIdleSongChange.Enabled = False
      lblIdleTime.Enabled = False
      cmbIdleTime.Enabled = False
      lblIdleTimeMin.Enabled = False
      optIdleText.Enabled = False
      txtIdleText.Enabled = False
      lblIdleText.Enabled = False
      optIdleSong.Enabled = False
      lblIdleSong.Enabled = False
      optIdleVer.Enabled = False
      lblIdleVer.Enabled = False
      optIdleUptime.Enabled = False
      lblIdleUptime.Enabled = False
      lstVars.Enabled = False
      lstVars2.Enabled = False
      If SaveValues Then Profiles(cmbProfile.SelectedIndex).Idle.IdleOn = False
    End If
  End Sub

  Private Sub txtIdleText_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtIdleText.TextChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Idle.IdleText = txtIdleText.Text
  End Sub

  Private Sub cmbIdleTime_ValueChanged(sender As System.Object, e As System.EventArgs) Handles cmbIdleTime.ValueChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Idle.IdleTime = cmbIdleTime.Value
  End Sub

  Private Sub cmdPassToggle_Click(sender As System.Object, e As System.EventArgs) Handles cmdPassToggle.Click
    txtPassword.UseSystemPasswordChar = Not txtPassword.UseSystemPasswordChar
  End Sub

  Private Sub tmrIdleExample_Tick(sender As System.Object, e As System.EventArgs) Handles tmrIdleExample.Tick
    lblIdleVer.Text = ResString(My.Resources.ACCOUNTOPTIONS_IDLE_VER, txtAccount.Text, Version)
    lblIdleUptime.Text = ResString(My.Resources.ACCOUNTOPTIONS_IDLE_UPTIME, txtAccount.Text, ConvertTime(Environment.TickCount, True), ConvertTime(Environment.TickCount - StartTime, True), "15s")
    lblIdleSong.Text = ResString(My.Resources.ACCOUNTOPTIONS_IDLE_SONG, txtAccount.Text, MPControls.GetSong)
    If txtIdleText.Text.Length > 0 Then
      Dim sText As String = String.Empty
      Dim bEmote As Boolean
      If txtIdleText.Text.Length >= 4 Then If txtIdleText.Text.Substring(0, 4).ToLower = "/me " Then bEmote = True
      If txtIdleText.Text.Length >= 7 Then If txtIdleText.Text.Substring(0, 7).ToLower = "/emote " Then bEmote = True
      Dim sMsg As String
      If bEmote Then
        If txtIdleText.Text.Substring(0, 4).ToLower = "/me " Then
          sMsg = txtIdleText.Text.Substring(4)
        ElseIf txtIdleText.Text.Substring(0, 7).ToLower = "/emote " Then
          sMsg = txtIdleText.Text.Substring(7)
        Else
          sMsg = txtIdleText.Text
        End If
      Else
        sMsg = txtIdleText.Text
      End If
      Dim sQuote As String
      If My.Computer.FileSystem.FileExists(AppData & "\Quotes.txt") Then
        Dim sQuotes() As String = Split(My.Computer.FileSystem.ReadAllText(AppData & "\Quotes.txt"), vbNewLine)
        Dim lQuote As Integer = Int(Rnd() * sQuotes.Length)
        sQuote = sQuotes(lQuote)
      Else
        sQuote = My.Resources.ERR_QUOTES_NONE
      End If
      sMsg = Replace(sMsg, "%1", txtAccount.Text)
      sMsg = Replace(sMsg, "%a", My.Resources.INFO_AWAY_AVAILABLE)
      sMsg = Replace(sMsg, "%b", ConvertTime(Environment.TickCount - StartTime, True))
      sMsg = Replace(sMsg, "%c", IIf(txtHomeChannel.Text = String.Empty, "Default Home Channel", txtHomeChannel.Text))
      sMsg = Replace(sMsg, "%d", Now.Month & "/" & Now.Day & "/" & Now.Year)
      sMsg = Replace(sMsg, "%l", "1d 1h 1m 1s")
      sMsg = Replace(sMsg, "%o", "15s")
      sMsg = Replace(sMsg, "%p", "223ms")
      sMsg = Replace(sMsg, "%q", sQuote)
      sMsg = Replace(sMsg, "%r", "Elegia")
      sMsg = Replace(sMsg, "%s", MPControls.GetSong)
      sMsg = Replace(sMsg, "%t", TimeOfDay.ToString(txtTimeStamp.Text))
      sMsg = Replace(sMsg, "%u", ConvertTime(Environment.TickCount, True))
      sMsg = Replace(sMsg, "%v", "Entelechy " & Version)
      If bEmote Then
        lblIdleText.Text = ResString(My.Resources.ACCOUNTOPTIONS_IDLE_TEXT_EMOTE, txtAccount.Text, sMsg)
      Else
        lblIdleText.Text = ResString(My.Resources.ACCOUNTOPTIONS_IDLE_TEXT, txtAccount.Text, sMsg)
      End If
    Else
      lblIdleText.Text = ResString(My.Resources.ACCOUNTOPTIONS_IDLE_TEXT, txtAccount.Text, "...?")
    End If
  End Sub

  Private Sub txtProfile_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtProfile.TextChanged
    If SaveValues Then
      Profiles(cmbProfile.SelectedIndex).Account.ProfileName = txtProfile.Text
      cmbProfile.Tag = "Changing..."
      cmbProfile.Items(cmbProfile.SelectedIndex) = Profiles(cmbProfile.SelectedIndex).Account.ProfileName
      cmbProfile.Tag = Nothing
    End If
  End Sub

  Private Sub chkProfileName_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkProfileName.CheckedChanged
    If chkProfileName.Checked Then
      txtProfile.Enabled = False
      If GameIsBN2(Profiles(cmbProfile.SelectedIndex).Account.Client.Product) Then
        txtProfile.Text = Profiles(cmbProfile.SelectedIndex).Account.Username & "@" & Profiles(cmbProfile.SelectedIndex).Server.Substring(0, 2)
      ElseIf GetGateways() Is Nothing Then
        txtProfile.Text = Profiles(cmbProfile.SelectedIndex).Account.Username & "@" & Profiles(cmbProfile.SelectedIndex).Server
      Else
        txtProfile.Text = Profiles(cmbProfile.SelectedIndex).Account.Username & "@" & GetGatewayName(Profiles(cmbProfile.SelectedIndex).Server, Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.WAR3 Or Profiles(cmbProfile.SelectedIndex).Account.Client.Product = BNUI.GameType.W3XP)
      End If
      txtProfile_TextChanged(sender, e)
    Else
      txtProfile.Enabled = True
    End If
  End Sub

  Private Sub cmbProxyPort_Scroll(sender As Object, e As System.Windows.Forms.ScrollEventArgs) Handles cmbProxyPort.Scroll
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Proxy.Port = cmbProxyPort.Value
  End Sub

  Private Sub cmbProxyPort_ValueChanged(sender As System.Object, e As System.EventArgs) Handles cmbProxyPort.ValueChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Proxy.Port = cmbProxyPort.Value
  End Sub

  Private Sub optHTTP_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles optHTTP.CheckedChanged
    If optHTTP.Checked Then
      If SaveValues Then Profiles(cmbProfile.SelectedIndex).Proxy.Ver = BNUI.ProxyType.HTTP
      lblProxyUser.Enabled = False
      txtProxyUser.Enabled = False
      lblProxyPass.Enabled = False
      txtProxyPass.Enabled = False
    End If
  End Sub

  Private Sub optSOCKS4_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles optSOCKS4.CheckedChanged
    If optSOCKS4.Checked Then
      If SaveValues Then Profiles(cmbProfile.SelectedIndex).Proxy.Ver = BNUI.ProxyType.SOCKS4
      lblProxyUser.Enabled = False
      txtProxyUser.Enabled = False
      lblProxyPass.Enabled = False
      txtProxyPass.Enabled = False
    End If
  End Sub

  Private Sub optSOCKS5_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles optSOCKS5.CheckedChanged
    If optSOCKS5.Checked Then
      If SaveValues AndAlso optSOCKS5.Checked Then Profiles(cmbProfile.SelectedIndex).Proxy.Ver = BNUI.ProxyType.SOCKS5
      lblProxyUser.Enabled = True
      txtProxyUser.Enabled = True
      lblProxyPass.Enabled = True
      txtProxyPass.Enabled = True
    End If
  End Sub

  Private Sub txtProxyUser_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtProxyUser.TextChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Proxy.User = txtProxyUser.Text
  End Sub

  Private Sub txtProxyPass_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtProxyPass.TextChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Proxy.Pass = txtProxyPass.Text
  End Sub

  Private Sub chkEXPKey_CheckedChanged(sender As Object, e As System.EventArgs) Handles chkEXPKey.CheckedChanged
    If SaveValues Then
      If chkEXPKey.Checked Then
        cmbEXPKey.Enabled = True
        cmdNewExp.Enabled = True
        cmdDelExp.Enabled = True
        LoadKeys()
        Dim sKey As New clsKey(cmbEXPKey.Text)
        Profiles(cmbProfile.SelectedIndex).Account.Client.EXPKey.ProductVal = sKey.Product
        Profiles(cmbProfile.SelectedIndex).Account.Client.EXPKey.PublicVal = sKey.PublicVal
        Profiles(cmbProfile.SelectedIndex).Account.Client.EXPKey.PrivateVal = sKey.PrivateVal
        Profiles(cmbProfile.SelectedIndex).Account.Client.EXPKey.PrivateVal26 = sKey.PrivateVal26
      Else
        cmbEXPKey.Enabled = False
        cmbEXPKey.Items.Clear()
        'cmbEXPKey.Text = String.Empty
        cmdNewExp.Enabled = False
        cmdDelExp.Enabled = False
        Profiles(cmbProfile.SelectedIndex).Account.Client.EXPKey.ProductVal = 0
        Profiles(cmbProfile.SelectedIndex).Account.Client.EXPKey.PublicVal = 0
        Profiles(cmbProfile.SelectedIndex).Account.Client.EXPKey.PrivateVal = 0
        Erase Profiles(cmbProfile.SelectedIndex).Account.Client.EXPKey.PrivateVal26
      End If
    End If
  End Sub

  Private Sub cmdEditStatstring_Click(sender As System.Object, e As System.EventArgs) Handles cmdEditStatstring.Click
    Dim frmStats As New frmStatString(txtStatString.Text)
    If frmStats.ShowDialog(Me) = Windows.Forms.DialogResult.OK Then txtStatString.Text = frmStats.txtStatstring.Text
  End Sub

  'Private Sub chkChatBG_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkChatBG.CheckedChanged
  '  txtChatBG.Enabled = chkChatBG.Checked
  '  cmdChatBGBrowse.Enabled = chkChatBG.Checked
  '  If SaveValues Then Profiles(cmbProfile.SelectedIndex).Display.UI.Background.Enabled = chkChatBG.Checked
  'End Sub

  'Private Sub cmdChatBGBrowse_Click(sender As Object, e As System.EventArgs)
  '  Dim cdlBrowse As New OpenFileDialog
  '  cdlBrowse.Filter = "All Image Types (*.jpg; *.png; *.gif; *.bmp)|*.jpg;*.jpeg;*.jpe;*.png;*.gif;*.bmp|All Files (*.*)|*.*"
  '  cdlBrowse.CheckFileExists = True
  '  If cdlBrowse.ShowDialog(Me) = Windows.Forms.DialogResult.OK Then
  '    txtChatBG.Text = cdlBrowse.FileName
  '  End If
  'End Sub

  'Private Sub txtChatBG_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtChatBG.TextChanged
  '  If SaveValues Then Profiles(cmbProfile.SelectedIndex).Display.UI.Background.Path = txtChatBG.Text
  'End Sub

  Private Sub optCSSBGColor_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles optCSSBGColor.CheckedChanged
    txtCSSBGColor.Enabled = True
    cmdCSSBGImage.Enabled = False
    cmbCSSBGGradientAlign.Enabled = False
    txtCSSBGGradientColor1.Enabled = False
    txtCSSBGGradientColor2.Enabled = False
  End Sub

  Private Sub optCSSBGImage_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles optCSSBGImage.CheckedChanged
    txtCSSBGColor.Enabled = False
    cmdCSSBGImage.Enabled = True
    cmbCSSBGGradientAlign.Enabled = False
    txtCSSBGGradientColor1.Enabled = False
    txtCSSBGGradientColor2.Enabled = False
  End Sub

  Private Sub optCSSBGGradient_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles optCSSBGGradient.CheckedChanged
    txtCSSBGColor.Enabled = False
    cmdCSSBGImage.Enabled = False
    cmbCSSBGGradientAlign.Enabled = True
    txtCSSBGGradientColor1.Enabled = True
    txtCSSBGGradientColor2.Enabled = True
  End Sub

  Private Function ColorToRGBA(cColor As Color) As String
    Dim colorsArray As System.Array = [Enum].GetValues(GetType(KnownColor))
    Dim allColors(colorsArray.Length) As KnownColor
    Array.Copy(colorsArray, allColors, colorsArray.Length)
    For Each cItem As KnownColor In allColors
      Dim cKColor As Color = Color.FromKnownColor(cItem)
      If cKColor.ToArgb = cColor.ToArgb And cKColor.IsNamedColor And Not cKColor.IsSystemColor Then Return cKColor.Name
    Next
    Return "rgba(" & cColor.R & "," & cColor.G & "," & cColor.B & "," & cColor.A & ")"
  End Function

  Private Sub cmdCSSCreate_Click(sender As System.Object, e As System.EventArgs) Handles cmdCSSCreate.Click
    Dim sCSS As String = "html" & vbNewLine &
                  "{" & vbNewLine &
                  " height: 100%;" & vbNewLine &
                  "}" & vbNewLine &
                  "body" & vbNewLine &
                  "{" & vbNewLine
    If optCSSBGColor.Checked Then
      sCSS &= " background-color: " & ColorToRGBA(txtCSSBGColor.SelectedColor) & ";" & vbNewLine
    ElseIf optCSSBGImage.Checked Then
      sCSS &= " background-color: black;" & vbNewLine &
                     " background-image: url(""file://" & Replace(cmdCSSBGImage.Tag, "\", "/") & """);" & vbNewLine &
                     " background-positon: center center;" & vbNewLine &
                     " background-repeat: no-repeat;" & vbNewLine &
                     " background-attachment: fixed;" & vbNewLine &
                     " background-size: cover;" & vbNewLine
    ElseIf optCSSBGGradient.Checked Then
      sCSS &= " background-color: black;" & vbNewLine &
                     " background-image: -moz-linear-gradient(" & IIf(cmbCSSBGGradientAlign.SelectedIndex = 0, "top", "left") & ", " & ColorToRGBA(txtCSSBGGradientColor1.SelectedColor) & ", " & ColorToRGBA(txtCSSBGGradientColor2.SelectedColor) & ");" & vbNewLine &
                     " background-repeat: no-repeat;" & vbNewLine &
                     " background-attachment: fixed;" & vbNewLine
    Else
      sCSS &= " background-color: black;" & vbNewLine
    End If
    sCSS &= " color: yellow;" & vbNewLine &
                   " margin: 0;" & vbNewLine &
                   " padding: 0;" & vbNewLine &
                   " top: 0;" & vbNewLine &
                   " left: 0;" & vbNewLine &
                   " font-family: " & cmbCSSFontFamily.Text & ";" & vbNewLine &
                   " font-size: " & cmbCSSFontSize.Text & ";" & vbNewLine &
                   "}" & vbNewLine &
                   "table.chat" & vbNewLine &
                   "{" & vbNewLine &
                   " width: 100%;" & vbNewLine &
                   " margin: 0;" & vbNewLine &
                   " padding: 0;" & vbNewLine &
                   "}" & vbNewLine &
                   "td.timestamp" & vbNewLine &
                   "{" & vbNewLine &
                   " color: " & ColorToRGBA(txtCSSTimestamp.SelectedColor) & ";" & vbNewLine &
                   " white-space: nowrap;" & vbNewLine &
                   " vertical-align: top;" & vbNewLine &
                   "}" & vbNewLine &
                   "td.chat" & vbNewLine &
                   "{" & vbNewLine &
                   " width: 100%;" & vbNewLine &
                   "}" & vbNewLine &
                   "table.message" & vbNewLine &
                   "{" & vbNewLine &
                   " width: 100%;" & vbNewLine &
                   " table-layout: fixed;" & vbNewLine &
                   " margin: 0;" & vbNewLine &
                   " padding: 0;" & vbNewLine &
                   " border-spacing: 0;" & vbNewLine &
                   "}" & vbNewLine &
                   "table.message td" & vbNewLine &
                   "{" & vbNewLine &
                   " padding: 0;" & vbNewLine &
                   "}" & vbNewLine &
                   "div.contents" & vbNewLine &
                   "{" & vbNewLine &
                   " width: 100%;" & vbNewLine &
                   " word-wrap: break-word;" & vbNewLine &
                   "}" & vbNewLine &
                   "span.protocol" & vbNewLine &
                   "{" & vbNewLine &
                   " color: gray;" & vbNewLine &
                   "}" & vbNewLine &
                   "a.user" & vbNewLine &
                   "{" & vbNewLine &
                   " color: " & ColorToRGBA(txtCSSUserColor.SelectedColor) & " !important;" & vbNewLine &
                   " text-decoration: none !important;" & vbNewLine &
                   " cursor: pointer;" & vbNewLine &
                   "}" & vbNewLine &
                   "a.self" & vbNewLine &
                   "{" & vbNewLine &
                   " color: " & ColorToRGBA(txtCSSSelfColor.SelectedColor) & " !important;" & vbNewLine &
                   " text-decoration: none !important;" & vbNewLine &
                   " cursor: pointer;" & vbNewLine &
                   "}" & vbNewLine &
                   "a.friend" & vbNewLine &
                   "{" & vbNewLine &
                   " color: " & ColorToRGBA(txtCSSFriendColor.SelectedColor) & " !important;" & vbNewLine &
                   " text-decoration: none !important;" & vbNewLine &
                   " cursor: pointer;" & vbNewLine &
                   "}" & vbNewLine &
                   "a.d2emote" & vbNewLine &
                   "{" & vbNewLine &
                   " color: " & ColorToRGBA(txtCSSD2EmoteColor.SelectedColor) & " !important;" & vbNewLine &
                   " text-decoration: none !important;" & vbNewLine &
                   " cursor: pointer;" & vbNewLine &
                   "}" & vbNewLine &
                   "span.text" & vbNewLine &
                   "{" & vbNewLine &
                   " color: " & ColorToRGBA(txtCSSTextColor.SelectedColor) & ";" & vbNewLine &
                   "}" & vbNewLine &
                   "span.emote" & vbNewLine &
                   "{" & vbNewLine &
                   " color: " & ColorToRGBA(txtCSSEmoteColor.SelectedColor) & ";" & vbNewLine &
                   "}" & vbNewLine &
                   "span.d2emote" & vbNewLine &
                   "{" & vbNewLine &
                   " color: " & ColorToRGBA(txtCSSD2EmoteColor.SelectedColor) & ";" & vbNewLine &
                   "}" & vbNewLine &
                   "span.info" & vbNewLine &
                   "{" & vbNewLine &
                   " color: " & ColorToRGBA(txtCSSInfoColor.SelectedColor) & ";" & vbNewLine &
                   "}" & vbNewLine &
                   "span.error" & vbNewLine &
                   "{" & vbNewLine &
                   " color: " & ColorToRGBA(txtCSSErrorColor.SelectedColor) & ";" & vbNewLine &
                   "}" & vbNewLine &
                   "span.success" & vbNewLine &
                   "{" & vbNewLine &
                   " color: " & ColorToRGBA(txtCSSSuccessColor.SelectedColor) & ";" & vbNewLine &
                   "}" & vbNewLine &
                   "span.whisper" & vbNewLine &
                   "{" & vbNewLine &
                   " color: " & ColorToRGBA(txtCSSWhisperColor.SelectedColor) & ";" & vbNewLine &
                   " text-shadow: 1px 1px 3px;" & vbNewLine &
                   "}" & vbNewLine &
                   "span.broadcast" & vbNewLine &
                   "{" & vbNewLine &
                   " color: " & ColorToRGBA(txtCSSBroadcastColor.SelectedColor) & ";" & vbNewLine &
                   "}" & vbNewLine &
                   "a" & vbNewLine &
                   "{" & vbNewLine &
                   " color: " & ColorToRGBA(txtCSSTextColor.SelectedColor) & ";" & vbNewLine &
                   " text-decoration: none;" & vbNewLine &
                   "}" & vbNewLine &
                   "a:hover" & vbNewLine &
                   "{" & vbNewLine &
                   " text-decoration: underline;" & vbNewLine &
                   "}" & vbNewLine &
                   "a:active" & vbNewLine &
                   "{" & vbNewLine &
                   " color: red;" & vbNewLine &
                   " text-decoration: underline;" & vbNewLine &
                   "}" & vbNewLine &
                   "img.emoticon" & vbNewLine &
                   "{" & vbNewLine &
                   " vertical-align: bottom;" & vbNewLine &
                   " border: 0;" & vbNewLine &
                   " padding: 0;" & vbNewLine &
                   " margin: 1px;" & vbNewLine &
                   " width: 16px;" & vbNewLine &
                   " height: 16px;" & vbNewLine &
                   "}" & vbNewLine &
                   "div#banlist" & vbNewLine &
                   "{" & vbNewLine &
                   " position: fixed;" & vbNewLine &
                   " top: 0;" & vbNewLine &
                   " right: 0;" & vbNewLine &
                   " width: auto;" & vbNewLine &
                   " text-align: right;" & vbNewLine &
                   " color: red;" & vbNewLine &
                   " text-shadow: 0 0 3px;" & vbNewLine &
                   "}"
    txtCSS.Text = sCSS
  End Sub

  Private Sub cmdCSSBGImage_Click(sender As System.Object, e As System.EventArgs) Handles cmdCSSBGImage.Click
    Dim cdlBrowse As New OpenFileDialog With {.Filter = "All Image Types (*.jpg; *.png; *.gif; *.bmp)|*.jpg;*.jpeg;*.jpe;*.png;*.gif;*.bmp|All Files (*.*)|*.*", .CheckFileExists = True}
    If cdlBrowse.ShowDialog(Me) = Windows.Forms.DialogResult.OK Then
      cmdCSSBGImage.Tag = cdlBrowse.FileName
    End If
  End Sub

  Private Sub cmdCSSDefault_Click(sender As System.Object, e As System.EventArgs) Handles cmdCSSDefault.Click
    optCSSBGGradient.Checked = True
    cmbCSSBGGradientAlign.SelectedIndex = 0
    txtCSSBGGradientColor1.SelectedColor = Color.FromArgb(255, 20, 20, 20)
    txtCSSBGGradientColor2.SelectedColor = Color.Black
    If cmbCSSFontFamily.Items.Contains("Microsoft Sans Serif") Then
      cmbCSSFontFamily.Text = "Microsoft Sans Serif"
    Else
      cmbCSSFontFamily.Text = FontFamily.GenericSansSerif.Name
    End If
    cmbCSSFontSize.Text = "10pt"
    txtCSSTimestamp.SelectedColor = Color.White
    txtCSSUserColor.SelectedColor = Color.Yellow
    txtCSSSelfColor.SelectedColor = Color.Aqua
    txtCSSFriendColor.SelectedColor = Color.Lime
    txtCSSD2EmoteColor.SelectedColor = Color.Gray
    txtCSSTextColor.SelectedColor = Color.White
    txtCSSEmoteColor.SelectedColor = Color.Yellow
    txtCSSInfoColor.SelectedColor = Color.Yellow
    txtCSSErrorColor.SelectedColor = Color.Red
    txtCSSSuccessColor.SelectedColor = Color.Lime
    txtCSSWhisperColor.SelectedColor = Color.Gray
    txtCSSBroadcastColor.SelectedColor = Color.Orange
    cmdCSSCreate.Focus()
  End Sub

  Private Sub txtCSS_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtCSS.TextChanged
    If SaveValues Then Profiles(cmbProfile.SelectedIndex).Display.UI.CustomCSS = Replace(txtCSS.Text, vbNewLine, "\n")
    ParseCSS()
  End Sub

  Private Sub ParseCSS()
    If Not gCSSTest.Created Then Exit Sub
    gCSSTest.LoadHtml("<!DOCTYPE html><html><head><title>Test</title><style type=""text/css"">" & vbNewLine & txtCSS.Text & vbNewLine & "</style></head><body></body></html>")
    Do While gCSSTest.IsBusy
      Application.DoEvents()
    Loop
    For Each rule In gCSSTest.Document.StyleSheets(0).CssRules
      Select Case rule.SelectorText
        Case "body"
          Dim bgColor As String = GetRule(rule.StyleCssText, "background-color")
          Dim bgImage As String = GetRule(rule.StyleCssText, "background-image")
          Dim fontFam As String = GetRule(rule.StyleCssText, "font-family")
          Dim fontSize As String = GetRule(rule.StyleCssText, "font-size")
          If Not String.IsNullOrEmpty(bgColor) Then txtCSSBGColor.SelectedColor = ColorStrToColor(bgColor)
          If Not String.IsNullOrEmpty(bgImage) Then
            If bgImage.StartsWith("-moz-linear-gradient") Then
              optCSSBGGradient.Checked = True
              bgImage = bgImage.Substring(bgImage.IndexOf("("c) + 1)
              Dim grad() As String = Nothing
              bgImage = bgImage.Substring(0, bgImage.LastIndexOf(")"c))
              If bgImage.Contains("rgb(") Then
                ReDim grad(2)
                grad(0) = bgImage.Substring(0, bgImage.IndexOf(",") - 1)
                bgImage = bgImage.Substring(bgImage.IndexOf(",") + 1).Trim
                If bgImage.Contains("),") Then
                  grad(1) = bgImage.Substring(bgImage.IndexOf("rgb("))
                  grad(1) = grad(1).Substring(0, grad(1).IndexOf("),") + 1)
                  bgImage = bgImage.Substring(bgImage.IndexOf("),") + 2).Trim
                Else
                  grad(1) = bgImage.Substring(0, bgImage.IndexOf(",") - 1)
                  bgImage = bgImage.Substring(bgImage.IndexOf(",") + 1).Trim
                End If
                If bgImage.Contains("))") Then
                  grad(2) = bgImage.Substring(bgImage.IndexOf("rgb("))
                  grad(2) = grad(2).Substring(0, grad(2).IndexOf(")"))
                ElseIf bgImage.Contains(")") Then
                  grad(2) = bgImage.Substring(0, bgImage.LastIndexOf(")") - 1)
                Else
                  grad(2) = bgImage
                End If
              Else
                grad = Split(bgImage, ",", 3)
              End If
              grad(0) = grad(0).Trim
              grad(1) = grad(1).Trim
              grad(2) = grad(2).Trim
              Select Case grad(0).Trim.ToLower
                Case "top", "center top"
                  cmbCSSBGGradientAlign.SelectedIndex = 0
                  txtCSSBGGradientColor1.SelectedColor = ColorStrToColor(grad(1))
                  txtCSSBGGradientColor2.SelectedColor = ColorStrToColor(grad(2))
                Case "bottom", "center bottom"
                  cmbCSSBGGradientAlign.SelectedIndex = 0
                  txtCSSBGGradientColor1.SelectedColor = ColorStrToColor(grad(2))
                  txtCSSBGGradientColor2.SelectedColor = ColorStrToColor(grad(1))
                Case "left", "left center"
                  cmbCSSBGGradientAlign.SelectedIndex = 1
                  txtCSSBGGradientColor1.SelectedColor = ColorStrToColor(grad(1))
                  txtCSSBGGradientColor2.SelectedColor = ColorStrToColor(grad(2))
                Case "right", "right center"
                  cmbCSSBGGradientAlign.SelectedIndex = 1
                  txtCSSBGGradientColor1.SelectedColor = ColorStrToColor(grad(2))
                  txtCSSBGGradientColor2.SelectedColor = ColorStrToColor(grad(1))
              End Select
            ElseIf bgImage.StartsWith("url") Then
              optCSSBGImage.Checked = True
              bgImage = bgImage.Substring(bgImage.IndexOf("(""") + 2)
              bgImage = bgImage.Substring(0, bgImage.LastIndexOf(""")"))
              bgImage = bgImage.Substring(bgImage.IndexOf("://") + 3)
              cmdCSSBGImage.Tag = bgImage
            Else
              optCSSBGColor.Checked = True
            End If
          Else
            optCSSBGColor.Checked = True
          End If
          If Not String.IsNullOrEmpty(fontFam) Then
            For Each item In cmbCSSFontFamily.Items
              If StrComp(item, fontFam, CompareMethod.Text) = 0 Then
                cmbCSSFontFamily.Text = item
                Exit For
              End If
            Next
          End If
          If Not String.IsNullOrEmpty(fontSize) Then cmbCSSFontSize.Text = fontSize
        Case "td.timestamp"
          Dim sColor As String = GetRule(rule.StyleCssText, "color")
          If Not String.IsNullOrEmpty(sColor) Then txtCSSTimestamp.SelectedColor = ColorStrToColor(sColor)
        Case "a.user"
          Dim sColor As String = GetRule(rule.StyleCssText, "color")
          If Not String.IsNullOrEmpty(sColor) Then txtCSSUserColor.SelectedColor = ColorStrToColor(sColor)
        Case "a.self"
          Dim sColor As String = GetRule(rule.StyleCssText, "color")
          If Not String.IsNullOrEmpty(sColor) Then txtCSSSelfColor.SelectedColor = ColorStrToColor(sColor)
        Case "a.friend"
          Dim sColor As String = GetRule(rule.StyleCssText, "color")
          If Not String.IsNullOrEmpty(sColor) Then txtCSSFriendColor.SelectedColor = ColorStrToColor(sColor)
        Case "a.d2emote", "span.d2emote"
          Dim sColor As String = GetRule(rule.StyleCssText, "color")
          If Not String.IsNullOrEmpty(sColor) Then txtCSSD2EmoteColor.SelectedColor = ColorStrToColor(sColor)
        Case "span.text"
          Dim sColor As String = GetRule(rule.StyleCssText, "color")
          If Not String.IsNullOrEmpty(sColor) Then txtCSSTextColor.SelectedColor = ColorStrToColor(sColor)
        Case "span.emote"
          Dim sColor As String = GetRule(rule.StyleCssText, "color")
          If Not String.IsNullOrEmpty(sColor) Then txtCSSEmoteColor.SelectedColor = ColorStrToColor(sColor)
        Case "span.info"
          Dim sColor As String = GetRule(rule.StyleCssText, "color")
          If Not String.IsNullOrEmpty(sColor) Then txtCSSInfoColor.SelectedColor = ColorStrToColor(sColor)
        Case "span.error"
          Dim sColor As String = GetRule(rule.StyleCssText, "color")
          If Not String.IsNullOrEmpty(sColor) Then txtCSSErrorColor.SelectedColor = ColorStrToColor(sColor)
        Case "span.success"
          Dim sColor As String = GetRule(rule.StyleCssText, "color")
          If Not String.IsNullOrEmpty(sColor) Then txtCSSSuccessColor.SelectedColor = ColorStrToColor(sColor)
        Case "span.whisper"
          Dim sColor As String = GetRule(rule.StyleCssText, "color")
          If Not String.IsNullOrEmpty(sColor) Then txtCSSWhisperColor.SelectedColor = ColorStrToColor(sColor)
        Case "span.broadcast"
          Dim sColor As String = GetRule(rule.StyleCssText, "color")
          If Not String.IsNullOrEmpty(sColor) Then txtCSSBroadcastColor.SelectedColor = ColorStrToColor(sColor)
      End Select
    Next
  End Sub

  Private Function GetRule(Style As String, Find As String) As String
    Dim sRules() As String = Style.Split(";"c)
    For Each rule In sRules
      If String.IsNullOrEmpty(rule.Trim) Then Continue For
      If rule.Trim.ToLower.StartsWith(Find.ToLower & ":") Then Return rule.Trim.Substring(rule.Trim.IndexOf(":"c) + 1).Trim
    Next
    Return Nothing
  End Function

  Private Function ColorStrToColor(sColor As String) As Color
    Try
      If sColor.EndsWith(" ! important") Then sColor = sColor.Substring(0, sColor.Length - 12)
      If sColor.StartsWith("#") Then
        Return Color.FromArgb(Int32.Parse(sColor.Substring(1), NumberStyles.HexNumber))
      ElseIf sColor.StartsWith("rgb") Then
        sColor = sColor.Substring(sColor.IndexOf("("c) + 1)
        sColor = sColor.Substring(0, sColor.LastIndexOf(")"c))
        Dim rgb() As String = sColor.Split(","c)
        Return Color.FromArgb(rgb(0), rgb(1), rgb(2))
      ElseIf sColor.StartsWith("rgba") Then
        sColor = sColor.Substring(sColor.IndexOf("("c) + 1)
        sColor = sColor.Substring(0, sColor.LastIndexOf(")"c))
        Dim rgba() As String = sColor.Split(","c)
        Return Color.FromArgb(rgba(3), rgba(0), rgba(1), rgba(2))
      Else
        Return Color.FromName(sColor)
      End If
    Catch ex As Exception
      Return Color.Empty
    End Try
  End Function



End Class